/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecn;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.mmc.pdm.common.util.ECNUtil;
import kd.mmc.pdm.common.util.MMCUtils;

public class ECNUnSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("type");
        e.getFieldKeys().add("pentrybom");
        e.getFieldKeys().add("pentryecn");
        e.getFieldKeys().add("entryversioncontrol");
        e.getFieldKeys().add("pentryoldversion");
        e.getFieldKeys().add("pentrynewversion");
        e.getFieldKeys().add("pentryvaliddate");
        e.getFieldKeys().add("pentryinvaliddate");
        e.getFieldKeys().add("entryisbulkmaterial");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntity = e.getDataEntities();
        ArrayList<DynamicObject> successData = new ArrayList<DynamicObject>();
        String key = e.getOperationKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            e.setCancelOperation(true);
        }
        if (StringUtils.equals((CharSequence)"unsubmit", (CharSequence)key)) {
            for (int j = 0; j < dataEntity.length; ++j) {
                int i;
                boolean isECNVersion;
                DynamicObject dObject = dataEntity[j];
                DynamicObject type = dObject.getDynamicObject("type");
                boolean bl = isECNVersion = type != null && MMCUtils.getDynamicObjectBooleanData((DynamicObject)type, (String)"isecnversion") != false;
                if (!isECNVersion) {
                    successData.add(dObject);
                    continue;
                }
                boolean isSuccess = true;
                HashMap<Integer, String> idx = new HashMap<Integer, String>(0);
                DynamicObjectCollection pentrys = dObject.getDynamicObjectCollection("pentry");
                for (i = 0; i < pentrys.size(); ++i) {
                    DynamicObject entry = (DynamicObject)pentrys.get(i);
                    DynamicObject bom = entry.getDynamicObject("pentrybom");
                    String pentryecn = entry.getString("pentryecn");
                    if (StringUtil.isEmpty((CharSequence)pentryecn)) {
                        return;
                    }
                    try {
                        ECNUtil.deleteECNVersion((DynamicObject)bom, (String)pentryecn);
                        String presentECN = ECNUtil.getPreEcnVersion((String)pentryecn);
                        idx.put(i, presentECN);
                        continue;
                    }
                    catch (KDBizException exp) {
                        isSuccess = false;
                        this.operationResult.addErrorInfo((OperateErrorInfo)ECNUtil.buildErrMessage((DynamicObject)dObject, (KDBizException)exp, (int)j, (int)0));
                        break;
                    }
                }
                if (!isSuccess) continue;
                for (i = 0; i < pentrys.size(); ++i) {
                    String value = (String)idx.get(i);
                    if (value == null) continue;
                    DynamicObject entry = (DynamicObject)pentrys.get(i);
                    entry.set("pentryecn", (Object)value);
                }
                successData.add(dObject);
            }
            e.setDataEntities(successData.toArray(new DynamicObject[successData.size()]));
        }
    }
}

