/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecn.route;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pdm.business.ecoplatform.ECNUpdateRouteBusiness;
import kd.mmc.pdm.business.ecoplatform.EcoRouteUtils;
import kd.mmc.pdm.business.ecoplatform.GetEcoEffectManuftechBusiness;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.opplugin.ecn.ECNBaseOpPlugin;
import kd.mmc.pdm.opplugin.ecn.route.ECNRouteAuditValidatorPlugin;

public class ECNRouteAuditOpPlugin
extends ECNBaseOpPlugin {
    private static final Log logger = LogFactory.getLog(ECNRouteAuditOpPlugin.class);
    private Map<String, String> errorMap = new HashMap<String, String>(16);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("pentry.pentryroute");
        e.getFieldKeys().add("pentry.pentryroutename");
        e.getFieldKeys().add("pentry.pentryoldrtversion");
        e.getFieldKeys().add("pentry.pentrynewrtversion");
        e.getFieldKeys().add("pentry.ecorouteid");
        e.getFieldKeys().add("pentry.ecoroutedata");
        e.getFieldKeys().add("pentry.ecotype.trandatetoday");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ECNRouteAuditValidatorPlugin());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dyncol = e.getDataEntities();
        String opName = e.getOperationKey();
        if (!"audit".equals(opName)) {
            return;
        }
        this.errorMap = new HashMap<String, String>(16);
        ArrayList<DynamicObject> newObjList = new ArrayList<DynamicObject>(10);
        boolean isRoute = Boolean.FALSE;
        for (int j = 0; j < dyncol.length; ++j) {
            DynamicObject dObject = dyncol[j];
            if (!this.isRouteChange(dObject)) continue;
            isRoute = Boolean.TRUE;
            newObjList.add(dObject);
            StringBuilder errors = new StringBuilder();
            try (TXHandle h = TX.requiresNew();){
                String errorMsg;
                try {
                    Set<Long> ecoBomIdSet = this.getAllEcoObjIds(dObject);
                    if (!ecoBomIdSet.isEmpty()) {
                        EcoRouteUtils.updateStatusAndActTime(ecoBomIdSet, (DynamicObject)dObject);
                    }
                    this.auditInitVersionEcoObj(dObject);
                    errorMsg = ECNUpdateRouteBusiness.getInstance().execUpdate(dObject);
                    this.updateEstimateStatus(dObject);
                    errors.append(errorMsg);
                }
                catch (Exception e1) {
                    newObjList.remove(dObject);
                    logger.error((Throwable)e1);
                    errorMsg = e1.getMessage();
                    if (errorMsg == null || "".equals(errorMsg)) {
                        errorMsg = PlatformUtils.getExceptionString((Exception)e1);
                    }
                    errors.append(errorMsg);
                    h.markRollback();
                }
                if (errors.length() <= 0) continue;
                this.errorMap.put(dObject.getString("billno"), errors.toString());
                continue;
            }
        }
        if (isRoute) {
            e.setDataEntities(newObjList.toArray(new DynamicObject[0]));
        }
        this.errorMap.put("successful_count", newObjList.size() + "");
        this.errorMap.put("failed_count", dyncol.length - newObjList.size() + "");
    }

    @Override
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String opName = e.getOperationKey();
        if (!"audit".equals(opName)) {
            return;
        }
        DynamicObject[] dyncol = e.getDataEntities();
        ArrayList<DynamicObject> updateDataList = new ArrayList<DynamicObject>(16);
        for (int j = 0; j < dyncol.length; ++j) {
            DynamicObject dObject = dyncol[j];
            if (!this.isRouteChange(dObject)) continue;
            DynamicObjectCollection pentrys = dObject.getDynamicObjectCollection("pentry");
            HashSet<Long> updateOrderPentryIdSet = new HashSet<Long>(16);
            for (DynamicObject obj : pentrys) {
                DynamicObject ecoType = obj.getDynamicObject("ecotype");
                if (ecoType == null || !ecoType.getBoolean("autoupdateorder")) continue;
                updateOrderPentryIdSet.add(obj.getLong("id"));
            }
            if (updateOrderPentryIdSet.isEmpty()) continue;
            String errorMsg = "";
            try {
                Map returnMap = GetEcoEffectManuftechBusiness.getInstance().createManuftechChangeByPentryId(updateOrderPentryIdSet);
                errorMsg = returnMap.get("errormsg") == null ? "" : returnMap.get("errormsg").toString();
            }
            catch (Exception e1) {
                logger.error((Throwable)e1);
                errorMsg = PlatformUtils.getSimpleExceptionString((Exception)e1);
            }
            if (errorMsg == null || "".equals(errorMsg)) continue;
            if (errorMsg.length() > 1900) {
                errorMsg = errorMsg.substring(0, 1900);
            }
            dObject.set("errormsg", (Object)errorMsg);
            updateDataList.add(dObject);
        }
        if (!updateDataList.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateDataList.toArray(new DynamicObject[updateDataList.size()]), (OperateOption)OperateOption.create());
        }
        this.throwAduitErrorMsg(this.errorMap);
    }
}

