/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecn.route;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mmc.fmm.common.util.DateCommonUtils;
import kd.mmc.pdm.business.ecoplatform.EcoRouteUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.ECNNewUtil;
import kd.mmc.pdm.common.util.ECNUtil;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.ecoroute.EcoPdmRouteUtils;
import kd.mmc.pdm.common.util.ecoroute.ExistRouteEntity;
import kd.mmc.pdm.opplugin.ecn.ECNBaseValidatorPlugin;

public class ECNRouteSubmitValidatorPlugin
extends ECNBaseValidatorPlugin {
    private static final Log logger = LogFactory.getLog(ECNRouteSubmitValidatorPlugin.class);

    @Override
    public void validate() {
        String operate = this.getOperateKey();
        if (!"submit".equals(operate)) {
            return;
        }
        ExtendedDataEntity[] objs = this.getDataEntities();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdfSec = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashSet<String> repeatKeyString = new HashSet<String>(16);
        HashSet<String> judgeSame = new HashSet<String>(16);
        Set<Long> ecoRouteIdSet = this.getEcoRouteIdSet(objs);
        Map<Long, DynamicObject> ecoRouteDataMap = this.getEcoRouteDatas(ecoRouteIdSet);
        EcoPdmRouteUtils.clearData();
        ExistRouteEntity existRouteEntity = EcoPdmRouteUtils.getRouteByDatabase(ecoRouteDataMap);
        HashMap param = new HashMap(3);
        for (ExtendedDataEntity obj : objs) {
            Long ecnId;
            Map otherEcnMap;
            DynamicObject dObject = obj.getDataEntity();
            if (!this.isRouteChange(dObject)) continue;
            DynamicObjectCollection pentrys = dObject.getDynamicObjectCollection("pentry");
            String billNo = dObject.getString("billno");
            if (pentrys.isEmpty()) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u53f7%s\u7684\u4ea7\u54c1\u5206\u5f55\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"ECNRouteSubmitValidatorPlugin_22", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), billNo));
                continue;
            }
            HashMap<String, Integer> check = new HashMap<String, Integer>(16);
            String checkOrgMsg = this.checkOrgPermItem(dObject);
            if (!this.isNullString(checkOrgMsg)) {
                this.addErrorMessage(obj, checkOrgMsg);
                continue;
            }
            HashSet<Long> allProcessEntryIdSet = new HashSet<Long>(16);
            int pSize = pentrys.size();
            boolean isCreateVersion = false;
            for (int i = 0; i < pSize; ++i) {
                String errorInfo;
                String chkExistsEcnMsg;
                DynamicObject mater;
                DynamicObject entry = (DynamicObject)pentrys.get(i);
                DynamicObject route = entry.getDynamicObject("pentryroute");
                String versionCtr = entry.getString("entryversioncontrol");
                long pRoutePK = ECNUtil.getDynamicObjectId((DynamicObject)route);
                if (!"D".equals(versionCtr)) {
                    if (route == null) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u6570\u636e\u6821\u9a8c\u51fa\u9519\uff0c\u5de5\u827a\u8def\u7ebf\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"ECNRouteSubmitValidatorPlugin_1", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                    if (!repeatKeyString.add(String.valueOf(pRoutePK))) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u4fee\u6539\u6216\u987a\u5ef6\u7248\u672c\u64cd\u4f5c\u65f6\uff0c\u540c\u4e00\u5de5\u827a\u8def\u7ebf\u7f16\u7801%2$s\u4e0d\u5141\u8bb8\u8fdb\u884c\u591a\u6b21\u53d8\u66f4\u64cd\u4f5c\u3002", (String)"ECNRouteSubmitValidatorPlugin_27", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, route.getString("number")));
                        continue;
                    }
                }
                if ((mater = this.getMaterialMasterObj(entry)) == null) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u4ea7\u54c1\u4fe1\u606f\u4e2d\u7b2c%2$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u6ca1\u6709\u5f55\u5165\u4ea7\u54c1\u7269\u6599\u4fe1\u606f\u3002", (String)"ECNRouteSubmitValidatorPlugin_23", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), billNo, i + 1));
                    continue;
                }
                String pMaterPK = mater.getString("id");
                String materialNum = mater.getString("number");
                Date pentryvaliddate = entry.getDate("pentryvaliddate");
                if (pentryvaliddate == null) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\u6570\u636e\u6821\u9a8c\u51fa\u9519\uff0c\u751f\u6548\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"ECNRouteSubmitValidatorPlugin_24", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                String entryversioncontrol = entry.getString("entryversioncontrol");
                DynamicObject pentrynewversion = entry.getDynamicObject("pentrynewrtversion");
                String checkInputNewRtVersionMsg = this.checkNewRtVersionIsNull(dObject, entry);
                if (!this.isNullString(checkInputNewRtVersionMsg)) {
                    this.addErrorMessage(obj, checkInputNewRtVersionMsg);
                    continue;
                }
                String checkInputRtNameMsg = this.checkRouteNameIsNull(dObject, entry);
                if (!this.isNullString(checkInputRtNameMsg)) {
                    this.addErrorMessage(obj, checkInputRtNameMsg);
                    continue;
                }
                if (entryversioncontrol.equals("B")) {
                    String key = pMaterPK + "+" + materialNum;
                    Object value = check.get(key);
                    if (value != null) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\u3001\u7b2c%2$s\u6761\u4ea7\u54c1\u5206\u5f55\u201c%3$s\u201d\u4ea7\u54c1\u7f16\u7801\u76f8\u540c\uff0c\u4e0d\u80fd\u540c\u65f6\u8fdb\u884c\u987a\u5ef6\u7248\u672c\u53d8\u66f4\u3002", (String)"ECNRouteSubmitValidatorPlugin_18", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), check.get(key), i + 1, materialNum));
                        continue;
                    }
                    check.put(key, i + 1);
                }
                if ("D".equals(versionCtr)) {
                    DynamicObject bomauxproperty = entry.getDynamicObject("bomauxproperty");
                    if (mater.getBoolean("isuseauxpty") && null == bomauxproperty) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u6570\u636e\u6821\u9a8c\u51fa\u9519\uff0c\u8f85\u52a9\u5c5e\u6027\u4e0d\u5b58\u5728,\u8bf7\u586b\u5199\u3002", (String)"ECNRouteSubmitValidatorPlugin_19", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                    String flag = mater.getPkValue() + "_";
                    if (pentrynewversion != null) {
                        flag = flag + pentrynewversion.getPkValue();
                    }
                    if (!judgeSame.add(flag)) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u5b58\u5728\u521d\u59cb\u7248\u672c\uff0c\u4ea7\u54c1\u7f16\u7801\uff0c\u65b0\u7248\u672c\u76f8\u540c\u7684\u5206\u5f55\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ECNRouteSubmitValidatorPlugin_20", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                }
                if (!this.isNullString(chkExistsEcnMsg = this.checkExistsEcnBill(dObject, route))) {
                    this.addErrorMessage(obj, chkExistsEcnMsg);
                    continue;
                }
                String ecnRouteid = MMCUtils.getDynamicObjectStringData((DynamicObject)entry, (String)"ecorouteid");
                if (StringUtils.isEmpty((CharSequence)ecnRouteid) || "0".equals(ecnRouteid)) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u5176\u7ec4\u4ef6\u5206\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ECNRouteSubmitValidatorPlugin_21", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                DynamicObject pEntryDO = ecoRouteDataMap.get(Long.parseLong(ecnRouteid));
                DynamicObjectCollection entrys = pEntryDO.getDynamicObjectCollection("processentry");
                if (PlatformUtils.isNullCollection((DynamicObjectCollection)entrys)) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u5176\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"ECNRouteSubmitValidatorPlugin_2", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1));
                    break;
                }
                Set<Long> changeProcessEntryIdSet = this.getProcessEntryIdSet(entrys);
                HashMap<String, ArrayList<DynamicObject>> opMap = new HashMap<String, ArrayList<DynamicObject>>(16);
                HashMap<String, ArrayList<DynamicObject>> opInstorePointMap = new HashMap<String, ArrayList<DynamicObject>>(16);
                int index = 0;
                ArrayList<DynamicObject> routeInstocrePointList = new ArrayList(16);
                if (route != null) {
                    routeInstocrePointList = EcoRouteUtils.getRouteEntryInstorePoint((Long)pRoutePK);
                    this.resetOldProcessStoragePointData(routeInstocrePointList, entrys);
                }
                if (StringUtils.isNotEmpty((CharSequence)(errorInfo = EcoPdmRouteUtils.validateRouteHead((ExistRouteEntity)existRouteEntity, (DynamicObject)pEntryDO, param)))) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c%2$s", (String)"ECNRouteSubmitValidatorPlugin_29", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, errorInfo));
                    continue;
                }
                EcoPdmRouteUtils.addRepeatMainSet((DynamicObject)pEntryDO, param);
                int entrySize = entrys.size();
                for (int j = 0; j < entrySize; ++j) {
                    Date acttime;
                    Optional<DynamicObject> optional;
                    DynamicObject entryentity = (DynamicObject)entrys.get(j);
                    ++index;
                    String entrymode = entryentity.getString("entrymode");
                    if (StringUtils.isBlank((CharSequence)entrymode)) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\uff0c\u884c\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"ECNRouteSubmitValidatorPlugin_3", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                        continue;
                    }
                    String operationNo = entryentity.getString("operationno");
                    String processSeq = entryentity.getString("parent");
                    if (StringUtils.isBlank((CharSequence)operationNo) || "0".equals(operationNo)) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\uff0c\u5de5\u5e8f\u53f7\u4e3a\u7a7a\u3002", (String)"ECNRouteSubmitValidatorPlugin_4", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)processSeq) || "0".equals(processSeq)) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\uff0c\u5de5\u5e8f\u5e8f\u5217\u4e3a\u7a7a\u3002", (String)"ECNRouteSubmitValidatorPlugin_15", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)"A", (CharSequence)entrymode) && !StringUtils.equals((CharSequence)"C", (CharSequence)entrymode) && !StringUtils.equals((CharSequence)"E", (CharSequence)entrymode)) continue;
                    Date entryvaliddate = entryentity.getDate("entryvaliddate");
                    if (entryvaliddate == null) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\uff0c\u751f\u6548\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"ECNRouteSubmitValidatorPlugin_5", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                        continue;
                    }
                    Date entryinvaliddate = entryentity.getDate("entryinvaliddate");
                    if (entryinvaliddate == null) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\uff0c\u5931\u6548\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"ECNRouteSubmitValidatorPlugin_6", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                        continue;
                    }
                    Date entryinvaliddatetrans = null;
                    Date entryvaliddatetrans = null;
                    try {
                        entryinvaliddatetrans = sdf.parse(sdf.format(entryinvaliddate));
                        entryvaliddatetrans = sdf.parse(sdf.format(entryvaliddate));
                    }
                    catch (ParseException e) {
                        logger.error((Throwable)e);
                        continue;
                    }
                    if (entryvaliddatetrans.compareTo(entryinvaliddatetrans) > 0) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u4ea7\u54c1\u4fe1\u606f\u5206\u5f55\uff0c\u5931\u6548\u65e5\u671f\u65e9\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"ECNRouteSubmitValidatorPlugin_7", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                        continue;
                    }
                    Long processEntryid = entryentity.getLong("oldprocessentryid");
                    if (StringUtils.equals((CharSequence)"C", (CharSequence)entrymode) && (optional = entrys.stream().filter(f -> "B".equals(f.getString("entrymode")) && Objects.equals(processEntryid, f.getLong("oldprocessentryid"))).findFirst()).isPresent()) {
                        DynamicObject dynamicObject = optional.get();
                        Date entryvaliddateBefore = dynamicObject.getDate("entryvaliddate");
                        Date entryvaliddateAfter = ECNNewUtil.setDateSubOne((Date)entryvaliddate);
                        if (entryvaliddateBefore != null && entryvaliddateAfter.compareTo(entryvaliddateBefore) < 0) {
                            String entryvaliddateBefores = sdfSec.format(entryvaliddateBefore);
                            String entryvaliddates = sdfSec.format(entryvaliddateAfter);
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\uff0c\u53d8\u66f4\u540e\u751f\u6548\u65f6\u95f4\u201c%3$s\u201d\u5e94\u5927\u4e8e\u53d8\u66f4\u524d\u751f\u6548\u65f6\u95f4\u201c%4$s\u201d\u3002", (String)"ECNRouteSubmitValidatorPlugin_8", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index, entryvaliddates, entryvaliddateBefores));
                            continue;
                        }
                    }
                    if ((acttime = entryentity.getDate("acttime")) == null) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u4ea7\u54c1\u4fe1\u606f\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e3a\u7a7a\u3002", (String)"ECNRouteSubmitValidatorPlugin_28", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                        continue;
                    }
                    if (StringUtils.equals((CharSequence)"E", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"B", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"C", (CharSequence)entrymode)) {
                        if ((StringUtils.equals((CharSequence)"B", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"E", (CharSequence)entrymode)) && acttime.compareTo(entryvaliddate) <= 0) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5de5\u5e8f\u4fe1\u606f\u751f\u6548\u65f6\u95f4\u3002", (String)"ECNRouteSubmitValidatorPlugin_9", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                            continue;
                        }
                        if (acttime.compareTo(entryinvaliddate) > 0) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5de5\u5e8f\u4fe1\u606f\u5931\u6548\u65f6\u95f4\u3002", (String)"ECNRouteSubmitValidatorPlugin_10", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                            continue;
                        }
                    }
                    if (StringUtils.equals((CharSequence)"E", (CharSequence)entrymode) && "A".equals(versionCtr) && !PlatformUtils.isNullLong((Long)processEntryid)) {
                        DynamicObject processEntry;
                        HashSet<Long> processEntryIdSet = new HashSet<Long>(16);
                        processEntryIdSet.add(processEntryid);
                        String otherEcnBillNo = EcoRouteUtils.getAduitEcnBill(processEntryIdSet, (Long)dObject.getLong("id"), (String)entrymode);
                        if (otherEcnBillNo != null && !"".equals(otherEcnBillNo)) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55,\u4e0d\u5141\u8bb8\u540c\u65f6\u5b58\u5728\u591a\u5f20\u5931\u6548\u7684\u5de5\u7a0b\u53d8\u66f4\u6570\u636e,\u5176\u4ed6\u5de5\u7a0b\u53d8\u66f4\u5355\u53f7\u4e3a\u201c%3$s\u201d\u3002", (String)"ECNRouteSubmitValidatorPlugin_11", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index, otherEcnBillNo));
                            continue;
                        }
                        Map processEntryDataMap = EcoRouteUtils.getRouteEntryData(processEntryIdSet);
                        DynamicObject dynamicObject = processEntry = processEntryDataMap == null ? null : (DynamicObject)processEntryDataMap.get(processEntryid);
                        if (processEntry != null) {
                            entryvaliddate = processEntry.getDate("entryvaliddate");
                            entryinvaliddate = processEntry.getDate("entryinvaliddate");
                            if (acttime != null && acttime.compareTo(entryvaliddate) <= 0) {
                                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5de5\u827a\u8def\u7ebf\u7684\u5de5\u5e8f\u5206\u5f55\u6700\u65b0\u7ec4\u4ef6\u751f\u6548\u65f6\u95f4\u3002", (String)"ECNRouteSubmitValidatorPlugin_12", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                                continue;
                            }
                            if (acttime != null && acttime.compareTo(entryinvaliddate) > 0) {
                                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\uff0c\u5b9e\u65bd\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5de5\u827a\u8def\u7ebf\u7684\u5de5\u5e8f\u5206\u5f55\u6700\u65b0\u7ec4\u4ef6\u5931\u6548\u65f6\u95f4\u3002", (String)"ECNRouteSubmitValidatorPlugin_13", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index));
                                continue;
                            }
                        }
                    }
                    if (StringUtils.equals((CharSequence)"A", (CharSequence)entrymode) || StringUtils.equals((CharSequence)"C", (CharSequence)entrymode)) {
                        Date entryinvaliddate2;
                        Date entryvaliddate2;
                        ArrayList<DynamicObject> hisList;
                        List existProcessList = EcoRouteUtils.getRouteEntryDataByOp((String)processSeq, (String)operationNo, (Long)pRoutePK);
                        if (!PlatformUtils.isNullList((List)existProcessList)) {
                            for (int k = 0; k < existProcessList.size(); ++k) {
                                DynamicObject processEntry = (DynamicObject)existProcessList.get(k);
                                Date entryvaliddate22 = processEntry.getDate("entryvaliddate");
                                Date entryinvaliddate22 = processEntry.getDate("entryinvaliddate");
                                Long processEntryId2 = processEntry.getLong("entryid");
                                if (StringUtils.equals((CharSequence)"C", (CharSequence)entrymode) && changeProcessEntryIdSet.contains(processEntryId2) || !DateCommonUtils.DateIsUnion((Date)acttime, (Date)entryinvaliddate, (Date)entryvaliddate22, (Date)entryinvaliddate22)) continue;
                                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\uff0c\u5728\u5de5\u827a\u8def\u7ebf\u4e2d\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u5de5\u5e8f\u5e8f\u5217\u201c%3$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%4$s\u201d\u3001\u4e14\u751f\u5931\u6548\u65f6\u95f4\u6709\u4ea4\u96c6\u7684\u6570\u636e\u3002", (String)"ECNRouteSubmitValidatorPlugin_16", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index, processSeq, operationNo));
                                break;
                            }
                        }
                        if ((hisList = (ArrayList<DynamicObject>)opMap.get(processSeq + "_" + operationNo)) == null) {
                            hisList = new ArrayList<DynamicObject>(16);
                        }
                        if (!hisList.isEmpty()) {
                            for (int k = 0; k < hisList.size(); ++k) {
                                DynamicObject oldProcessEntry = (DynamicObject)hisList.get(k);
                                entryvaliddate2 = oldProcessEntry.getDate("acttime");
                                if (!DateCommonUtils.DateIsUnion((Date)acttime, (Date)entryinvaliddate, (Date)entryvaliddate2, (Date)(entryinvaliddate2 = oldProcessEntry.getDate("entryinvaliddate")))) continue;
                                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\uff0c\u5b58\u5728\u65b0\u589e\u6216\u4fee\u6539\u76f8\u540c\u5de5\u5e8f\u5e8f\u5217\u201c%3$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%4$s\u201d\u3001\u4e14\u751f\u5931\u6548\u65f6\u95f4\u6709\u4ea4\u96c6\u7684\u6570\u636e\u3002", (String)"ECNRouteSubmitValidatorPlugin_17", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index, processSeq, operationNo));
                                break;
                            }
                        }
                        hisList.add(entryentity);
                        opMap.put(processSeq + "_" + operationNo, hisList);
                        if (entryentity.getBoolean("storagepoint") && !PlatformUtils.isNullList(routeInstocrePointList)) {
                            for (int k = 0; k < routeInstocrePointList.size(); ++k) {
                                DynamicObject processEntry = (DynamicObject)routeInstocrePointList.get(k);
                                if (!processEntry.getBoolean("storagepoint")) continue;
                                entryvaliddate2 = processEntry.getDate("entryvaliddate");
                                entryinvaliddate2 = processEntry.getDate("entryinvaliddate");
                                Long processEntryId2 = processEntry.getLong("entryid");
                                if (StringUtils.equals((CharSequence)"C", (CharSequence)entrymode) && changeProcessEntryIdSet.contains(processEntryId2) || !DateCommonUtils.DateIsUnion((Date)acttime, (Date)entryinvaliddate, (Date)entryvaliddate2, (Date)entryinvaliddate2)) continue;
                                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\uff0c\u5de5\u5e8f\u5e8f\u5217\u201c%3$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%4$s\u201d\u5728\u751f\u5931\u6548\u65f6\u95f4\u5185\u5b58\u5728\u6709\u4ea4\u96c6\u7684\u5165\u5e93\u70b9\u6570\u636e\u3002", (String)"ECNRouteSubmitValidatorPlugin_25", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index, processSeq, operationNo));
                                break;
                            }
                        }
                        if (entryentity.getBoolean("storagepoint")) {
                            ArrayList<DynamicObject> hisInstorePointList = (ArrayList<DynamicObject>)opInstorePointMap.get(pRoutePK + "_" + pMaterPK);
                            if (hisInstorePointList == null) {
                                hisInstorePointList = new ArrayList<DynamicObject>(16);
                            }
                            if (!hisInstorePointList.isEmpty()) {
                                for (int k = 0; k < hisInstorePointList.size(); ++k) {
                                    Date entryinvaliddate23;
                                    DynamicObject oldProcessEntry = (DynamicObject)hisInstorePointList.get(k);
                                    Date entryvaliddate23 = oldProcessEntry.getDate("acttime");
                                    if (!DateCommonUtils.DateIsUnion((Date)acttime, (Date)entryinvaliddate, (Date)entryvaliddate23, (Date)(entryinvaliddate23 = oldProcessEntry.getDate("entryinvaliddate")))) continue;
                                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6761\u4ea7\u54c1\u5206\u5f55\uff0c\u7b2c%2$s\u6761\u5de5\u5e8f\u4fe1\u606f\u5206\u5f55\uff0c\u5de5\u5e8f\u5e8f\u5217\u201c%3$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%4$s\u201d\u3001\u751f\u5931\u6548\u65f6\u95f4\u5185\u5b58\u5728\u6709\u4ea4\u96c6\u7684\u5165\u5e93\u70b9\u6570\u636e\u3002", (String)"ECNRouteSubmitValidatorPlugin_26", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), i + 1, index, processSeq, operationNo));
                                    break;
                                }
                            }
                            hisInstorePointList.add(entryentity);
                            opInstorePointMap.put(pRoutePK + "_" + pMaterPK, hisInstorePointList);
                        }
                    }
                    if (PlatformUtils.isNullLong((Long)processEntryid)) continue;
                    allProcessEntryIdSet.add(processEntryid);
                }
                String statusMsg = this.checkBomRtIsAuditStatus(dObject);
                if (statusMsg == null || "".equals(statusMsg)) continue;
                this.addErrorMessage(obj, statusMsg);
            }
            if (!allProcessEntryIdSet.isEmpty() && (otherEcnMap = EcoRouteUtils.getEcnEntryNoEnd(allProcessEntryIdSet, (Long)(ecnId = Long.valueOf(dObject.getLong("id"))))) != null && !otherEcnMap.isEmpty()) {
                String otherEcnBillNo = (String)otherEcnMap.get("ecobillno");
                String entrydesc = (String)otherEcnMap.get("entrydesc");
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u7684\u5de5\u5e8f\u5206\u5f55\u4e2d\uff0c\u5de5\u5e8f\u53f7\u201c%1$s\u201d\u5b58\u5728\u672a\u8bc4\u4f30\u5b8c\u6bd5\u7684\u5176\u5b83\u53d8\u66f4\u5355\u201c%2$s\u201d\u6570\u636e\uff0c\u8bf7\u5904\u7406\u3002", (String)"ECNRouteSubmitValidatorPlugin_14", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), entrydesc, otherEcnBillNo));
                continue;
            }
            ValidateResult res = this.getValidateResult();
            List lista = res.getAllErrorInfo();
            if (!lista.isEmpty()) continue;
            DynamicObject submitObjTem = BusinessDataServiceHelper.newDynamicObject((String)"pdm_ecobom");
            this.pentrySubmit(pentrys, obj, submitObjTem);
        }
    }

    private void pentrySubmit(DynamicObjectCollection pentry, ExtendedDataEntity enobj, DynamicObject submitObjTem) {
        ArrayList<Long> list = new ArrayList<Long>(16);
        HashMap<Long, DynamicObject> versionMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject[] obj : pentry) {
            String controlVersion = obj.getString("entryversioncontrol");
            if (!"D".equals(controlVersion)) continue;
            Long ecorouteid = obj.getLong("ecorouteid");
            list.add(ecorouteid);
            versionMap.put(ecorouteid, obj.getDynamicObject("pentrynewrtversion"));
        }
        if (!list.isEmpty()) {
            DynamicObject[] col;
            for (DynamicObject dy : col = BusinessDataServiceHelper.load((Object[])list.toArray(new Object[list.size()]), (DynamicObjectType)submitObjTem.getDynamicObjectType())) {
                dy.set("routeversion", versionMap.get(dy.getPkValue()));
            }
            OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"pdm_ecoroute", (DynamicObject[])col, null);
            String submitErrorMsg = PlatformUtils.getErrorMsg((OperationResult)result);
            if (submitErrorMsg != null && !"".equals(submitErrorMsg)) {
                this.addErrorMessage(enobj, submitErrorMsg);
            }
        }
    }

    private Set<Long> getProcessEntryIdSet(DynamicObjectCollection entrys) {
        HashSet<Long> entryIdSet = new HashSet<Long>(16);
        for (int j = 0; j < entrys.size(); ++j) {
            DynamicObject entryentity = (DynamicObject)entrys.get(j);
            Long processEntryid = entryentity.getLong("oldprocessentryid");
            if (PlatformUtils.isNullLong((Long)processEntryid)) continue;
            entryIdSet.add(processEntryid);
        }
        return entryIdSet;
    }

    private void resetOldProcessStoragePointData(List<DynamicObject> routeInstocrePointList, DynamicObjectCollection ecoRouteEntrys) {
        for (int j = 0; j < ecoRouteEntrys.size(); ++j) {
            DynamicObject entryentity = (DynamicObject)ecoRouteEntrys.get(j);
            Long processEntryid = entryentity.getLong("oldprocessentryid");
            if (PlatformUtils.isNullLong((Long)processEntryid)) continue;
            Date acttime = entryentity.getDate("acttime");
            String entrymode = entryentity.getString("entrymode");
            DynamicObject oldProcessEntry = this.getOldProcessData(routeInstocrePointList, processEntryid);
            if (oldProcessEntry == null) continue;
            if ("E".equals(entrymode)) {
                oldProcessEntry.set("entryinvaliddate", (Object)PlatformUtils.addSecond((Date)acttime, (int)-1));
                continue;
            }
            if (!"C".equals(entrymode)) continue;
            oldProcessEntry.set("storagepoint", entryentity.get("storagepoint"));
            oldProcessEntry.set("entryinvaliddate", (Object)acttime);
        }
    }

    private DynamicObject getOldProcessData(List<DynamicObject> routeInstocrePointList, Long processEntryId) {
        int size = routeInstocrePointList.size();
        if (size > 0) {
            for (DynamicObject entry : routeInstocrePointList) {
                if (!((Long)entry.getPkValue()).equals(processEntryId)) continue;
                return entry;
            }
        }
        return null;
    }
}

