/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.ecoplatform;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.formula.platform.engine.RunFormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.business.ecoplatform.EcoFilterHelper;

public class EcoRequireFilterOpVal
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(EcoRequireFilterOpVal.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String opKey = this.getOperateKey();
        if (!("audit".equals(opKey) || "enable".equals(opKey) || "submit".equals(opKey))) {
            return;
        }
        HashSet<String> repeatSet = new HashSet<String>(16);
        int size = 0;
        for (ExtendedDataEntity data : dataEntities) {
            String formulaStr;
            DynamicObject obj = data.getDataEntity();
            String number = obj.getString("number");
            ++size;
            DynamicObject srcObjectEntity = obj.getDynamicObject("srcobjectentity");
            DynamicObject targetObjectEntity = obj.getDynamicObject("objectentity");
            boolean isforward = obj.getBoolean("isforward");
            if ("audit".equals(opKey) || "enable".equals(opKey)) {
                String keyString = srcObjectEntity.getPkValue() + "_" + targetObjectEntity.getPkValue() + "_" + isforward;
                if (!repeatSet.add(keyString)) {
                    for (ExtendedDataEntity dataB : dataEntities) {
                        DynamicObject objB = dataB.getDataEntity();
                        DynamicObject srcObjectEntityB = objB.getDynamicObject("srcobjectentity");
                        DynamicObject targetObjectEntityB = objB.getDynamicObject("objectentity");
                        boolean isforwardB = objB.getBoolean("isforward");
                        String keyStringB = srcObjectEntityB.getPkValue() + "_" + targetObjectEntityB.getPkValue() + "_" + isforwardB;
                        if (!keyString.equals(keyStringB)) continue;
                        this.addErrorMessage(dataB, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u7f16\u7801\u4e3a%2$s\u7684\u8bbe\u7f6e\u4e2d\uff0c\u540c\u4e00\u5de5\u7a0b\u53d8\u66f4\u4e1a\u52a1\u5bf9\u8c61\u3001\u76ee\u6807\u4e1a\u52a1\u5bf9\u8c61\u3001\u6b63\u5411\u6807\u8bc6\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u4e2a\u5ba1\u6838\u53ef\u7528\u7684\u914d\u7f6e\u3002", (String)"EcoRequireFilterOpVal_01", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), dataB.getRowIndex() + 1, objB.getString("number")));
                    }
                    continue;
                }
                if (this.isExists(srcObjectEntity, targetObjectEntity, isforward, (Long)obj.getPkValue())) {
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u7f16\u7801\u4e3a%2$s\u7684\u8bbe\u7f6e\u4e2d\uff0c\u540c\u4e00\u5de5\u7a0b\u53d8\u66f4\u4e1a\u52a1\u5bf9\u8c61\u3001\u76ee\u6807\u4e1a\u52a1\u5bf9\u8c61\u3001\u6b63\u5411\u6807\u8bc6\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u4e2a\u5ba1\u6838\u53ef\u7528\u7684\u914d\u7f6e\u3002", (String)"EcoRequireFilterOpVal_01", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), size, number));
                }
            }
            if (!"submit".equals(opKey) || (formulaStr = EcoFilterHelper.buildFromulaStr((DynamicObject)obj, (boolean)Boolean.FALSE)) == null || "".equals(formulaStr)) continue;
            try {
                EcoFilterHelper.validFormula((String)formulaStr);
            }
            catch (RunFormulaException e) {
                logger.error((Throwable)e);
                String formulaDescStr = EcoFilterHelper.buildFromulaStr((DynamicObject)obj, (boolean)Boolean.TRUE);
                formulaDescStr = formulaDescStr + "\r\n" + e.getMessage();
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a\u7f16\u7801\u4e3a%2$s\u7684\u8bbe\u7f6e\u4e2d\uff0c\u5339\u914d\u7ef4\u5ea6\u8bbe\u7f6e\u6821\u9a8c\u4e0d\u6b63\u786e\u3002%3$s\u3002", (String)"EcoRequireFilterOpVal_02", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), size, number, formulaDescStr));
            }
        }
    }

    private boolean isExists(DynamicObject srcObjectEntity, DynamicObject targetObjectEntity, boolean isFrowars, Long id) {
        QFilter qfilter = new QFilter("srcobjectentity", "=", srcObjectEntity.getPkValue());
        qfilter.and(new QFilter("objectentity", "=", targetObjectEntity.getPkValue()));
        qfilter.and(new QFilter("isforward", "=", (Object)isFrowars));
        qfilter.and(new QFilter("enable", "=", (Object)"1"));
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        qfilter.and(new QFilter("id", "<>", (Object)id));
        return QueryServiceHelper.exists((String)"pdm_ecorequirefilter", (QFilter[])new QFilter[]{qfilter});
    }
}

