/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.prdsel;

import java.util.ArrayList;
import java.util.List;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;

public class ProductConfigureDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("masterconfigcode");
        e.getFieldKeys().add("number");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if ("delete".equals(operationKey)) {
            DynamicObject[] dataEntities = e.getDataEntities();
            ArrayList<DynamicObject> deleteDataEntities = new ArrayList<DynamicObject>(4);
            StringBuilder msgError = new StringBuilder();
            for (int i = 0; i < dataEntities.length; ++i) {
                DynamicObject dataEntity = dataEntities[i];
                DynamicObject configCodeDO = dataEntity.getDynamicObject("masterconfigcode");
                if (configCodeDO == null) continue;
                if (this.checkConfigCodeReference(configCodeDO)) {
                    String productConfigNumber = dataEntity.getString("number");
                    String configCodeNumber = configCodeDO.getString("number");
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u914d\u7f6e\u6e05\u5355\u201c%1$s\u201d\u7684\u914d\u7f6e\u53f7\u201c%2$s\u201d\u5df2\u88ab\u5176\u4ed6\u5355\u636e\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ProductConfigureDeleteOp_0", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), productConfigNumber, configCodeNumber);
                    this.getOperationResult().addErrorInfo((OperateErrorInfo)this.buildErrMessage(configCodeDO, "", errorMsg));
                    continue;
                }
                deleteDataEntities.add(dataEntity);
            }
            e.setDataEntities(deleteDataEntities.toArray(new DynamicObject[deleteDataEntities.size()]));
        }
    }

    private boolean checkConfigCodeReference(DynamicObject configCodeDO) {
        boolean isExistReference = false;
        Long configCodePK = 0L;
        if (configCodeDO == null) {
            return isExistReference;
        }
        configCodePK = configCodeDO.getLong("id");
        if (configCodePK <= 0L) {
            return isExistReference;
        }
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        List refrenceResult = checker.getAllRefs((BasedataEntityType)configCodeDO.getDataEntityType(), (Object)configCodePK);
        if (refrenceResult.size() > 0) {
            for (BaseDataRefenceKey refenceKey : refrenceResult) {
                if ("pdm_productconfigure".equals(refenceKey.getRefEntityKey())) continue;
                isExistReference = true;
                break;
            }
        }
        return isExistReference;
    }

    private ValidationErrorInfo buildErrMessage(DynamicObject obj, String erroCode, String msg) {
        Object pkId = obj.getPkValue();
        int dataIndex = 0;
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        String errCodeMsg = "delete_error";
        if (StringUtils.isNotEmpty((CharSequence)erroCode)) {
            errCodeMsg = erroCode;
        }
        ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, errCodeMsg, "delete_productconfigure", msg, errorLevel);
        return info;
    }
}

