/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.prdsel;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.util.io.ExceptionUtils;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.formula.platform.engine.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMExpandConfigBusiness;
import kd.mmc.pdm.business.proconfig.proconfiglist.ParseFeatureListToMatListBusiness;
import kd.mmc.pdm.common.constants.ProductConfigureListConst;
import kd.mmc.pdm.common.objectbeen.FeatureValueObj;
import kd.mmc.pdm.common.objectbeen.ProdConfigureFeatureDefAndValObj;
import kd.mmc.pdm.common.objectbeen.SuperBomEntryNumberObj;
import kd.mmc.pdm.common.util.CommonUtils;
import kd.mmc.pdm.common.util.ConfigNumberGenerateUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;
import kd.mmc.pdm.opplugin.prdsel.ProductConfigureSaveOpVal;
import net.sf.json.JSONArray;
import org.json.simple.JSONObject;

public class ProductConfigureSaveOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog((String)ProductConfigureSaveOp.class.getName());
    private static int cycleCount = 0;

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ProductConfigureSaveOpVal());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        OperateOption operateOption = this.getOption();
        if (StringUtils.equals((CharSequence)"donothing_savefeaturelist", (CharSequence)operationKey)) {
            boolean containsIds = operateOption.containsVariable("ids");
            boolean seqAndPseq = operateOption.containsVariable("seqAndPseq");
            if (containsIds && seqAndPseq) {
                this.setFinalDymicObject(operateOption);
            }
        }
    }

    private void setFinalDymicObject(OperateOption operateOption) {
        String variableValue = operateOption.getVariableValue("ids");
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(variableValue), (String)"pdm_productconfigure");
        DynamicObjectCollection dynamicObjectCollection = loadSingle.getDynamicObjectCollection("treeentryentity");
        HashMap<String, Object> seqAndPIdMap = new HashMap<String, Object>();
        HashMap<String, DynamicObject> seqAndTreeMap = new HashMap<String, DynamicObject>();
        HashMap<String, String> seqAndEntrySeqMap = new HashMap<String, String>();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String seq = dynamicObject.getString("seq");
            String entryseq = dynamicObject.getString("entryseq");
            seqAndPIdMap.put(seq, dynamicObject.getPkValue());
            seqAndTreeMap.put(seq, dynamicObject);
            seqAndEntrySeqMap.put(entryseq, seq);
        }
        String seqAndPseqString = operateOption.getVariableValue("seqAndPseq");
        JSONArray array = new JSONArray();
        array.add((Object)seqAndPseqString);
        List seqAndPseqs = JSONArray.toList((JSONArray)array, Map.class);
        Map seqAndPseq = (Map)seqAndPseqs.get(0);
        Set entrySet = seqAndPseq.entrySet();
        ArrayList<DynamicObject> upList = new ArrayList<DynamicObject>(50);
        for (Map.Entry entry : entrySet) {
            String entrySeq = (String)entry.getKey();
            String seq = (String)seqAndEntrySeqMap.get(entrySeq);
            DynamicObject dynamicObject = (DynamicObject)seqAndTreeMap.get(seq);
            if (null == dynamicObject) continue;
            String pentrySeq = (String)entry.getValue();
            String pseq = (String)seqAndEntrySeqMap.get(pentrySeq);
            Object pid = seqAndPIdMap.get(pseq);
            dynamicObject.set("pid", pid);
            upList.add(dynamicObject);
        }
        SaveServiceHelper.update((DynamicObject[])upList.toArray(new DynamicObject[0]));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities2;
        String operationKey = e.getOperationKey();
        boolean validate = this.validate(operationKey, dataEntities2 = e.getDataEntities(), e);
        if (!validate) {
            return;
        }
        DynamicObject dataEntity = dataEntities2[0];
        if (dataEntity == null) {
            return;
        }
        DynamicObjectCollection allfeatureVals = dataEntity.getDynamicObjectCollection("featuretreeentryentity");
        DynamicObjectCollection allfeatureDefs = dataEntity.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection newfeatureVals = new DynamicObjectCollection(allfeatureVals.getDynamicObjectType(), (Object)allfeatureVals);
        DynamicObjectCollection newfeatureDefs = new DynamicObjectCollection(allfeatureDefs.getDynamicObjectType(), (Object)allfeatureDefs);
        HashMap<String, DynamicObjectCollection> newFeatureDefAndValueColls = new HashMap<String, DynamicObjectCollection>();
        this.getNewFeatrueValues(allfeatureVals, newfeatureVals, newFeatureDefAndValueColls, allfeatureDefs, newfeatureDefs);
        DynamicObject prodOrgObj = dataEntity.getDynamicObject("prodorgid");
        try {
            ParseFeatureListToMatListBusiness parseBusiness = new ParseFeatureListToMatListBusiness(null, new Date(), BigDecimal.ONE, -1L, false, true, 30);
            Row proConfigObj = this.createHeadDatSet(dataEntity);
            if (proConfigObj == null) {
                return;
            }
            DynamicObject superBomObj = dataEntity.getDynamicObject("superbom");
            long superBomId = superBomObj == null ? 0L : superBomObj.getLong("id");
            QFilter superBomfilter = new QFilter("id", "=", (Object)superBomId);
            DataSet superBomDatSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pdm_mftbom", (String)ParseFeatureListToMatListBusiness.getPropertiesWithQuerySuperBom((BigDecimal)BigDecimal.ONE), (QFilter[])new QFilter[]{superBomfilter}, null);
            long configPlanId = proConfigObj.getLong("productconfigplan");
            Map bomExpandMap = BOMExpandConfigBusiness.getBomExpandConfigByConfigPlan((long)configPlanId);
            Map<String, List<Map<String, Object>>> featureValMap = this.createFeatureValList(newFeatureDefAndValueColls);
            List<Map<String, Object>> featureDefList = this.createFeatureDef(newfeatureDefs);
            DataSet proConfigDatSet = parseBusiness.parase(proConfigObj, superBomDatSet, featureValMap, featureDefList, this.operateOption, true, bomExpandMap, prodOrgObj.getPkValue().toString(), 0L, 0L, 0L);
            this.saveProductConfig(dataEntity, proConfigDatSet, newfeatureDefs, newfeatureVals, e);
        }
        catch (Exception e1) {
            logger.error(ExceptionUtils.stringifyException((Throwable)e1));
            this.getOperationResult().setMessage(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%s\u3002", (String)"ProductConfigureSaveOp_5", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), e1.getMessage()));
            this.getOperationResult().setSuccess(false);
            e.setCancel(true);
        }
    }

    private Map<String, List<Map<String, Object>>> createFeatureValList(Map<String, DynamicObjectCollection> newFeatureDefAndValueColls) {
        HashMap<String, List<Map<String, Object>>> featureValMap = new HashMap<String, List<Map<String, Object>>>(8);
        if (newFeatureDefAndValueColls == null || newFeatureDefAndValueColls.isEmpty()) {
            return featureValMap;
        }
        Set<Map.Entry<String, DynamicObjectCollection>> entrySet = newFeatureDefAndValueColls.entrySet();
        for (Map.Entry<String, DynamicObjectCollection> entry : entrySet) {
            String featureDefId = entry.getKey();
            DynamicObjectCollection featureValObjCol = entry.getValue();
            ArrayList featureValList = new ArrayList(100);
            for (int i = 0; i < featureValObjCol.size(); ++i) {
                HashMap<String, Object> featureMap = new HashMap<String, Object>(64);
                DynamicObject featureValObj = (DynamicObject)featureValObjCol.get(i);
                DynamicObject feratureDefObj = featureValObj.getDynamicObject("featuredefno");
                long feratureDefId = feratureDefObj == null ? 0L : feratureDefObj.getLong("id");
                String featureNum = feratureDefObj == null ? "" : feratureDefObj.getString("number");
                featureMap.put("featuredefno", feratureDefId);
                featureMap.put("featureNum", featureNum);
                featureMap.put("entryvalue", featureValObj.get("entryvalue"));
                featureMap.put("entryvaluename", "entryvaluename");
                featureValList.add(featureMap);
            }
            featureValMap.put(featureDefId, featureValList);
        }
        return featureValMap;
    }

    private List<Map<String, Object>> createFeatureDef(DynamicObjectCollection newfeatureDefs) {
        if (newfeatureDefs == null || newfeatureDefs.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> featureDefList = new ArrayList<Map<String, Object>>(newfeatureDefs.size());
        for (int i = 0; i < newfeatureDefs.size(); ++i) {
            HashMap<String, Object> defMap = new HashMap<String, Object>(64);
            DynamicObject defObj = (DynamicObject)newfeatureDefs.get(i);
            defMap.put("featureid", defObj.get("featureid"));
            defMap.put("itemselector", defObj.get("itemselector"));
            featureDefList.add(defMap);
        }
        return featureDefList;
    }

    private Row createHeadDatSet(DynamicObject obj) {
        DataEntityPropertyCollection properties = obj.getDataEntityType().getProperties();
        String fields = ParseFeatureListToMatListBusiness.getHeadFields();
        QFilter filter = new QFilter("1", "=", (Object)2);
        DataSet proConfigDatSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pdm_productconfigure", (String)fields, (QFilter[])new QFilter[]{filter}, null);
        RowMeta rowMeta = proConfigDatSet.getRowMeta();
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        String[] fieldNames = rowMeta.getFieldNames();
        Object[] objArray = new Object[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            if (!properties.containsKey((Object)fieldName)) continue;
            Object fieldObj = obj.get(fieldName);
            if (fieldObj instanceof DynamicObject) {
                DynamicObject fieldValue = (DynamicObject)obj.get(fieldName);
                objArray[i] = fieldValue.getLong("id");
                continue;
            }
            objArray[i] = fieldObj instanceof Long ? (obj.get(fieldName) == null ? Long.valueOf(0L) : obj.get(fieldName)) : (fieldObj instanceof String ? (obj.get(fieldName) == null ? "" : obj.get(fieldName)) : (fieldObj instanceof BigDecimal ? (obj.get(fieldName) == null ? BigDecimal.ZERO : obj.get(fieldName)) : obj.get(fieldName)));
        }
        builder.append(objArray);
        DataSet proConfigSet = builder.build();
        Row proConfigObj = null;
        if (proConfigSet.hasNext()) {
            proConfigObj = proConfigSet.next();
        }
        return proConfigObj;
    }

    private void getNewFeatrueValues(DynamicObjectCollection allfeatureVals, DynamicObjectCollection newfeatureVals, Map<String, DynamicObjectCollection> newFeatureDefAndValueColls, DynamicObjectCollection allfeatureDefs, DynamicObjectCollection newfeatureDefs) {
        HashMap<String, DynamicObject> allfeatureDefSeqAndId = new HashMap<String, DynamicObject>();
        for (DynamicObject dynamicObject : allfeatureDefs) {
            this.setProConfigureFeatureEntry(allfeatureDefs, newfeatureDefs, dynamicObject);
            DynamicObject object = dynamicObject.getDynamicObject("featureid");
            if (object == null) continue;
            allfeatureDefSeqAndId.put(object.getPkValue().toString(), object);
        }
        DynamicObjectType entryEntityType = allfeatureDefs.getDynamicObjectType();
        DynamicObjectType featureEntryEntityType = allfeatureVals.getDynamicObjectType();
        if (this.operateOption.containsVariable("featureRows")) {
            String featureRows = this.operateOption.getVariableValue("featureRows");
            JSONArray array = new JSONArray();
            array.add((Object)featureRows);
            HashMap<String, Class<FeatureValueObj>> classMap = new HashMap<String, Class<FeatureValueObj>>();
            classMap.put("featureValues", FeatureValueObj.class);
            List defAndValObjs = JSONArray.toList((JSONArray)array, ProdConfigureFeatureDefAndValObj.class, classMap);
            List list = (List)defAndValObjs.get(0);
            for (ProdConfigureFeatureDefAndValObj prodConfigureFeatureDefAndValObj : list) {
                String featureDefId = prodConfigureFeatureDefAndValObj.getFeatureDefId();
                DynamicObject featureDef = (DynamicObject)allfeatureDefSeqAndId.get(featureDefId);
                List featureValues = prodConfigureFeatureDefAndValObj.getFeatureValues();
                DynamicObjectCollection featureValColls = new DynamicObjectCollection();
                for (FeatureValueObj featureValueObj : featureValues) {
                    this.setFeatureValColls(allfeatureVals, featureEntryEntityType, featureDef, featureValColls, featureValueObj, newfeatureDefs, null);
                }
                newFeatureDefAndValueColls.put(featureDefId, featureValColls);
                newfeatureVals.addAll((Collection)featureValColls);
            }
        }
    }

    private void setProConfigureFeatureEntry(DynamicObjectCollection allfeatureDefs, DynamicObjectCollection newfeatureDefs, DynamicObject featureEntryDO) {
        if (allfeatureDefs == null || newfeatureDefs == null || featureEntryDO == null) {
            return;
        }
        DynamicObjectType entryEntityType = allfeatureDefs.getDynamicObjectType();
        DynamicObject newfeatureDefDO = new DynamicObject(entryEntityType, (Object)allfeatureDefs);
        DynamicObject featureDefDO = featureEntryDO.getDynamicObject("featureid");
        String featureDefNumberID = featureEntryDO.getString("featurenumberid");
        String featureValue = featureEntryDO.getString("featurevalue");
        String configProcess = featureEntryDO.getString("configprocess");
        String featureValueName = featureEntryDO.getString("featurevaluename");
        String featureValueID = featureEntryDO.getString("featurevalueid");
        newfeatureDefDO.set("featureid", (Object)featureDefDO);
        newfeatureDefDO.set("featurenumberid", (Object)featureDefNumberID);
        newfeatureDefDO.set("featurevalue", (Object)featureValue);
        newfeatureDefDO.set("configprocess", (Object)configProcess);
        newfeatureDefDO.set("featurevaluename", (Object)featureValueName);
        newfeatureDefDO.set("featurevalueid", (Object)featureValueID);
        newfeatureDefs.add((Object)newfeatureDefDO);
    }

    private void setFeatureValColls(DynamicObjectCollection allfeatureVals, DynamicObjectType featureEntryEntityType, DynamicObject featureDef, DynamicObjectCollection featureValColls, FeatureValueObj featureValueObj, DynamicObjectCollection newfeatureDefs, DynamicObject newfeatureDef) {
        if (featureValueObj.getFeatureValueChoose()) {
            DynamicObject newfeatureVal = new DynamicObject(featureEntryEntityType, (Object)allfeatureVals);
            newfeatureVal.set("featuredefno", (Object)featureDef);
            newfeatureVal.set("entryvalue", (Object)featureValueObj.getFeatureValue());
            newfeatureVal.set("entryvaluename", (Object)featureValueObj.getFeatureValueName());
            newfeatureVal.set("seq", (Object)featureValueObj.getFeatureValueSeq());
            featureValColls.add((Object)newfeatureVal);
        }
    }

    private boolean validate(String operationKey, DynamicObject[] dataEntities, BeforeOperationArgs e) {
        if (!StringUtils.equals((CharSequence)"donothing_savefeaturelist", (CharSequence)operationKey)) {
            return false;
        }
        if (!this.isExistVariableOfId(e)) {
            return false;
        }
        return this.validateOprationAndDataEntity(dataEntities);
    }

    private boolean validateOprationAndDataEntity(DynamicObject[] dataEntities) {
        if (!this.validateOperationVarible()) {
            return false;
        }
        return 0 < dataEntities.length;
    }

    private boolean validateOperationVarible() {
        boolean containsId = this.operateOption.containsVariable("ids");
        boolean containsVariable = this.operateOption.containsVariable("dataChanged");
        if (containsId && containsVariable && !Boolean.parseBoolean(this.operateOption.getVariableValue("dataChanged"))) {
            return false;
        }
        boolean configtype = this.operateOption.containsVariable("configtype");
        return !configtype || !StringUtils.equals((CharSequence)"1", (CharSequence)this.operateOption.getVariableValue("configtype"));
    }

    private boolean isExistVariableOfId(BeforeOperationArgs e) {
        if (this.operateOption.containsVariable("ids")) {
            String id = this.operateOption.getVariableValue("ids");
            ORMImpl impl = new ORMImpl();
            QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(id));
            boolean exists = impl.exists("pdm_productconfigure", new QFilter[]{qFilter});
            if (!exists) {
                this.operateOption.removeVariable("ids");
            } else {
                DynamicObject productConfigure = BusinessDataServiceHelper.loadSingle((String)"pdm_productconfigure", (String)"status", (QFilter[])new QFilter[]{qFilter});
                String status = productConfigure.getString("status");
                if (StringUtils.equals((CharSequence)"C", (CharSequence)status)) {
                    e.setCancel(true);
                    e.setCancelMessage(ResManager.loadKDString((String)"\u751f\u6210\u7684\u4ea7\u54c1\u914d\u7f6e\u6e05\u5355\u5df2\u63d0\u4ea4\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u4fdd\u5b58\u3002", (String)"ProductConfigureSaveOp_2", (String)"mmc-pdm-opplugin", (Object[])new Object[0]));
                    return false;
                }
            }
        }
        return true;
    }

    private void getFeatureDefSeqOfFormula(Map<Object, List<String>> featureDefSeqOfFormula, Map<Object, List<String>> featureDefSeqOfFormulaType, List<SuperBomEntryNumberObj> newMaterialColls) {
        for (int i = 1; i < newMaterialColls.size(); ++i) {
            SuperBomEntryNumberObj bomEntryNumberObj = newMaterialColls.get(i);
            DynamicObject dynamicObject = bomEntryNumberObj.getSuperBom();
            DynamicObjectCollection subentryentitys = dynamicObject.getDynamicObjectCollection("subentryentity");
            ArrayList<String> formulaList = new ArrayList<String>();
            ArrayList<String> formulaTypeList = new ArrayList<String>();
            for (DynamicObject subentryentity : subentryentitys) {
                DynamicObject chararuleno = subentryentity.getDynamicObject("chararuleno");
                DynamicObject newchararuleno = BusinessDataServiceHelper.loadSingle((Object)chararuleno.getPkValue(), (String)"pdm_chararule", (String)"formula,type");
                String type = newchararuleno.getString("type");
                formulaTypeList.add(type);
                String formula = newchararuleno.getString("formula");
                formulaList.add(formula);
            }
            featureDefSeqOfFormula.put(bomEntryNumberObj.getEntrySeq(), formulaList);
            featureDefSeqOfFormulaType.put(bomEntryNumberObj.getEntrySeq(), formulaTypeList);
        }
    }

    private List<SuperBomEntryNumberObj> getTreeBOMInfo(DynamicObject dataEntity, Map<String, String> errorMap) {
        DynamicObject superbom = dataEntity.getDynamicObject("superbom");
        if (null == superbom) {
            return new ArrayList<SuperBomEntryNumberObj>();
        }
        DynamicObjectCollection entry = superbom.getDynamicObjectCollection("entry");
        DynamicObjectType dynamicObjectType = entry.getDynamicObjectType();
        DynamicObject material = superbom.getDynamicObject("materialid");
        ArrayList<SuperBomEntryNumberObj> newMaterialColls = new ArrayList<SuperBomEntryNumberObj>();
        ArrayList<String> superBomPkValues = new ArrayList<String>();
        this.setFirstComponentInfo(superbom, superBomPkValues, dynamicObjectType, newMaterialColls, material);
        String newMaterialSeq = "1";
        HashMap<String, String> seqAndPseq = new HashMap<String, String>();
        this.setOtherComponentsInfos(superbom, superBomPkValues, entry, newMaterialColls, newMaterialSeq, seqAndPseq, errorMap);
        if (!seqAndPseq.isEmpty()) {
            this.operateOption.setVariableValue("seqAndPseq", JSONObject.toJSONString(seqAndPseq));
        }
        return newMaterialColls;
    }

    private void setOtherComponentsInfos(DynamicObject superbom, List<String> superBomPkValues, DynamicObjectCollection entry, List<SuperBomEntryNumberObj> newMaterialColls, String newMaterialSeq, Map<String, String> seqAndPseq, Map<String, String> errorMap) {
        String sonLength = "1";
        HashMap<String, String> entrySeqWithLength = new HashMap<String, String>();
        entrySeqWithLength.put("newMaterialSeq", newMaterialSeq);
        entrySeqWithLength.put("sonLength", sonLength);
        HashMap<String, DynamicObject> memoryCache = new HashMap<String, DynamicObject>();
        cycleCount = 0;
        this.setOtherComponentsInfo(superbom, superBomPkValues, entry, newMaterialColls, entrySeqWithLength, seqAndPseq, errorMap, memoryCache);
        logger.warn(String.format("mmc-pdm-superbom-expand-cycleCount: %s", cycleCount));
    }

    private void setOtherComponentsInfo(DynamicObject superbom, List<String> superBomPkValues, DynamicObjectCollection entry, List<SuperBomEntryNumberObj> newMaterialColls, Map<String, String> entrySeqWithLength, Map<String, String> seqAndPseq, Map<String, String> errorMap, Map<String, DynamicObject> memoryCache) {
        String newMaterialSeq = entrySeqWithLength.get("newMaterialSeq");
        DynamicObject createorg = superbom.getDynamicObject("createorg");
        String orgKey = String.valueOf(createorg.getPkValue());
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject sonComponent;
            DynamicObject dynamicObject = (DynamicObject)entry.get(i);
            Object materialId = dynamicObject.getDynamicObject("entrymaterialid").getPkValue();
            String mKey = String.valueOf(materialId);
            logger.warn(String.format("mmc-pdm-superbom-expand-material: %s, newMaterialSeq: %s, size: %s", mKey, newMaterialSeq, entry.size()));
            String seq = String.valueOf(i + 1);
            String sonMaterialSeq = newMaterialSeq + '.' + seq;
            String originalSonLength = entrySeqWithLength.get("sonLength");
            int sonLength = sonMaterialSeq.split("\\.").length;
            if (Integer.parseInt(originalSonLength) == sonLength) {
                superBomPkValues.remove(superBomPkValues.size() - 1);
            } else {
                superBomPkValues = superBomPkValues.subList(0, sonLength - 1);
            }
            if (superBomPkValues.contains(mKey)) {
                String superBomNumber = superbom.getString("number");
                errorMap.put("superBomNumber", superBomNumber);
                return;
            }
            superBomPkValues.add(mKey);
            entrySeqWithLength.put("sonLength", String.valueOf(sonLength));
            seqAndPseq.put(sonMaterialSeq, newMaterialSeq);
            ++cycleCount;
            SuperBomEntryNumberObj bomEntryNumber = new SuperBomEntryNumberObj();
            bomEntryNumber.setEntrySeq(sonMaterialSeq);
            bomEntryNumber.setSuperBom(dynamicObject);
            bomEntryNumber.setSuperBomNumber(superbom.getString("number"));
            bomEntryNumber.setSuperBomId(superbom.getPkValue().toString());
            bomEntryNumber.setSuperBomModifyTime(String.valueOf(superbom.getDate("modifytime").getTime()));
            newMaterialColls.add(bomEntryNumber);
            QFilter sonMaterialId = new QFilter("materialid", "=", (Object)Long.parseLong(mKey));
            QFilter sonMaterialStatus = new QFilter("status", "=", (Object)"C");
            QFilter sonMaterialEnable = new QFilter("enable", "=", (Object)"1");
            QFilter sonMaterialOrg = new QFilter("createorg.id", "=", createorg.getPkValue());
            QFilter[] allDataFilter = new QFilter[]{sonMaterialId, sonMaterialStatus, sonMaterialEnable, sonMaterialOrg};
            String cacheKey = mKey + " - " + orgKey;
            if (memoryCache.containsKey(cacheKey)) {
                sonComponent = memoryCache.get(cacheKey);
            } else {
                sonComponent = BusinessDataServiceHelper.loadSingleFromCache((String)"pdm_mftbom", (String)this.getPropertiesWithQuerySuperBom(), (QFilter[])allDataFilter);
                memoryCache.put(cacheKey, sonComponent);
            }
            if (sonComponent == null) continue;
            DynamicObjectCollection sonEntry = sonComponent.getDynamicObjectCollection("entry");
            entrySeqWithLength.put("newMaterialSeq", sonMaterialSeq);
            this.setOtherComponentsInfo(sonComponent, superBomPkValues, sonEntry, newMaterialColls, entrySeqWithLength, seqAndPseq, errorMap, memoryCache);
        }
    }

    private String getPropertiesWithQuerySuperBom() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",number");
        sb.append(",modifytime");
        sb.append(",entry.entrymaterialid");
        sb.append(",entry.entryqtytype");
        sb.append(",entry.entryscraprate");
        sb.append(",entry.entryinvaliddate");
        sb.append(",entry.entryunit");
        sb.append(",entry.entryfixscrap");
        sb.append(",entry.entryvaliddate");
        sb.append(",entry.entrytype");
        sb.append(",entry.entryqty");
        sb.append(",entry.entryqtynumerator");
        sb.append(",entry.entryqtydenominator");
        sb.append(",entry.opt");
        sb.append(",entry.entryversion");
        sb.append(",entry.entryauxproperty");
        sb.append(",entry.mutuexcopt");
        sb.append(",subentryentity");
        sb.append(",createorg");
        sb.append(",subentryentity.chararuleno");
        return sb.toString();
    }

    private String setFirstComponentInfo(DynamicObject superbom, List<String> superBomPkValues, DynamicObjectType dynamicObjectType, List<SuperBomEntryNumberObj> materialColls, DynamicObject material) {
        DynamicObject newMaterial = new DynamicObject(dynamicObjectType);
        String superBOMPkValue = superbom.getPkValue().toString();
        superBomPkValues.add(material.getPkValue().toString());
        newMaterial.set("id", (Object)superBOMPkValue);
        newMaterial.set("entryseq", (Object)"1");
        newMaterial.set("entrymaterialid", (Object)material);
        SuperBomEntryNumberObj bomEntryNumberObj = new SuperBomEntryNumberObj();
        bomEntryNumberObj.setEntrySeq("1");
        bomEntryNumberObj.setSuperBom(newMaterial);
        materialColls.add(bomEntryNumberObj);
        return superBOMPkValue;
    }

    private Object runFormula(Map<String, Object> errorMap, SuperBomEntryNumberObj bomEntryNumberObj, int i, String formula, Map<String, Object> varValues, String formulaType) {
        Object result = null;
        try {
            result = FormulaEngine.runFormula((String)formula, varValues);
            String booleanString = "true,false";
            boolean resultTypeNotAllow = StringUtils.equals((CharSequence)"3", (CharSequence)formulaType) && !CommonUtils.isNumber((String)result.toString()) ? true : StringUtils.equals((CharSequence)"2", (CharSequence)formulaType) && !booleanString.contains(result.toString());
            if (null == result || resultTypeNotAllow) {
                this.setFormulaErrorMap(errorMap, bomEntryNumberObj, i, new NullPointerException(), formula);
                return null;
            }
        }
        catch (Exception e1) {
            this.setFormulaErrorMap(errorMap, bomEntryNumberObj, i, e1, formula);
        }
        return result;
    }

    private void setFormulaErrorMap(Map<String, Object> errorMap, SuperBomEntryNumberObj bomEntryNumberObj, int i, Exception e1, String formula) {
        String superBomNumber = bomEntryNumberObj.getSuperBomNumber();
        DynamicObject component = bomEntryNumberObj.getSuperBom();
        String modifytime = bomEntryNumberObj.getSuperBomModifyTime();
        String superBomId = bomEntryNumberObj.getSuperBomId();
        DynamicObjectCollection componentFeatureRules = component.getDynamicObjectCollection("subentryentity");
        DynamicObject componentFeatureRule = (DynamicObject)componentFeatureRules.get(i);
        DynamicObject ruleId = componentFeatureRule.getDynamicObject("chararuleno");
        Object ruleName = ruleId.get("name");
        DynamicObject entrymaterial = component.getDynamicObject("entrymaterial");
        Object materialNumber = entrymaterial.get("number");
        logger.error(String.format("mmc-pdm-superbom-formula-error: bm: %s, m: %s, rn: %s, formula: %s", superBomNumber, materialNumber, ruleName, formula), (Throwable)e1);
        String exceptionMessage = e1 instanceof NullPointerException ? String.format(ResManager.loadKDString((String)"\u8d85\u7ea7BOM\u7f16\u7801\u201c%1$s\u201d\u4e2d\u7ec4\u4ef6\u7f16\u7801 \u201c%2$s\u201d , \u516c\u5f0f \u201c%3$s\u201d \u8fd4\u56de\u7ed3\u679c\u4e0e\u516c\u5f0f\u7c7b\u578b\u4e0d\u4e00\u81f4, \u8bf7\u4fee\u6539\u3002", (String)"ProductConfigureSaveOp_3", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), superBomNumber, materialNumber, ruleName) : String.format(ResManager.loadKDString((String)"\u8d85\u7ea7BOM\u7f16\u7801\u201c%1$s\u201d\u4e2d\u7ec4\u4ef6\u7f16\u7801 \u201c%1$s\u201d , \u516c\u5f0f \u201c%3$s\u201d \u89e3\u6790\u5931\u8d25, \u8bf7\u4fee\u6539\u3002", (String)"ProductConfigureSaveOp_4", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), superBomNumber, materialNumber, ruleName);
        errorMap.put("exceptionMessage", exceptionMessage);
        this.operateOption.setVariableValue("exceptionMessage", exceptionMessage);
        this.operateOption.setVariableValue("errorSuperBomId", superBomId);
        this.operateOption.setVariableValue("errorSuperBomModifytime", modifytime);
    }

    private boolean setFormulaResultForExpresstion(SuperBomEntryNumberObj bomEntryNumberObj, Object result, List<Boolean> validateResultForExpressions) {
        if (null == result) {
            return false;
        }
        BigDecimal resultString = new BigDecimal(result.toString());
        boolean validateResultForExpression = resultString.compareTo(new BigDecimal("0")) >= 0 ? Boolean.TRUE : Boolean.FALSE;
        if (validateResultForExpression) {
            DynamicObject component = bomEntryNumberObj.getSuperBom();
            component.set("entryqty", (Object)resultString);
        }
        validateResultForExpressions.add(validateResultForExpression);
        return validateResultForExpression;
    }

    private void saveProductConfig(DynamicObject dataEntity, DataSet proConfigDatSet, DynamicObjectCollection newfeatureDefs, DynamicObjectCollection newfeatureVals, BeforeOperationArgs e) {
        OperationResult executeOperate;
        List successPkIds;
        DynamicObject schemeObj = dataEntity.getDynamicObject("productconfigplan");
        String isrepeatbom = schemeObj.getString("isrepeatbom");
        DynamicObject prodMatObj = dataEntity.getDynamicObject("materielno");
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        String uniquestr = this.getProConfigResult(entryEntity);
        if ("true".equals(isrepeatbom)) {
            DynamicObject existConfigCodeObj;
            String id = "";
            if (this.operateOption.containsVariable("ids")) {
                id = this.operateOption.getVariableValue("ids");
            }
            if ((existConfigCodeObj = this.getTheSameConfig(uniquestr, prodMatObj, id)) != null) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u201c%1$s\u201d\u5b58\u5728\u76f8\u540c\u914d\u7f6e\u53f7\u201c%2$s\u201d\u7684\u914d\u7f6e\u3002", (String)"ProductConfigureSaveOp_6", (String)"mmc-pdm-opplugin", (Object[])new Object[0]), prodMatObj.getString("number"), existConfigCodeObj.getString("number"));
                e.setCancelMessage(errorMsg);
                e.setCancel(true);
                return;
            }
        }
        DynamicObject productConfig = this.getNewDynamicObject(dataEntity, proConfigDatSet, newfeatureDefs, newfeatureVals);
        productConfig.set("uniquestr_tag", (Object)uniquestr);
        this.createConfigNum(productConfig);
        this.isFeatureTreeEntryShow(productConfig);
        if (this.operateOption.containsVariable("ids")) {
            DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(this.operateOption.getVariableValue("ids")), (String)"pdm_productconfigure");
            BusinessDataServiceHelper.delete((IDataEntityType)productConfig.getDynamicObjectType(), (Object[])new DynamicObject[]{loadSingle});
        }
        if (!(successPkIds = (executeOperate = OperationServiceHelper.executeOperate((String)"save", (String)"pdm_productconfigure", (DynamicObject[])new DynamicObject[]{productConfig}, (OperateOption)this.operateOption)).getSuccessPkIds()).isEmpty()) {
            StringBuilder ids = new StringBuilder();
            for (Object successPkId : successPkIds) {
                ids.append(successPkId);
            }
            this.operateOption.setVariableValue("ids", ids.toString());
        } else {
            List errorList = executeOperate.getAllErrorOrValidateInfo();
            for (IOperateInfo info : errorList) {
                e.setCancelMessage(info.getMessage());
            }
            e.setCancel(true);
        }
    }

    private DynamicObject getTheSameConfig(String uniquestr, DynamicObject prodMatObj, String curId) {
        DynamicObject proConfigListObj;
        DynamicObject configcodeObj = null;
        if (uniquestr == null || "".equals(uniquestr)) {
            return configcodeObj;
        }
        QFilter filter = new QFilter("uniquestr_tag", "=", (Object)uniquestr);
        QFilter id = new QFilter("id", "!=", (Object)(curId == null || "".equals(curId) ? 0L : Long.parseLong(curId)));
        QFilter prodMat = new QFilter("materielno", "=", (Object)(prodMatObj == null ? 0L : prodMatObj.getLong("id")));
        if (curId != null && !"".equals(curId)) {
            filter = filter.and(id);
        }
        if ((proConfigListObj = BusinessDataServiceHelper.loadSingleFromCache((String)"pdm_productconfigure", (QFilter[])new QFilter[]{filter = filter.and(prodMat)})) != null) {
            configcodeObj = proConfigListObj.getDynamicObject("masterconfigcode");
        }
        return configcodeObj;
    }

    private String getProConfigResult(DynamicObjectCollection featureList) {
        if (featureList == null || featureList.isEmpty()) {
            return "";
        }
        ArrayList<Object> list = new ArrayList<Object>(featureList.size());
        for (int i = 0; i < featureList.size(); ++i) {
            DynamicObject obj = (DynamicObject)featureList.get(i);
            Object featureDefObj = obj.get("featureid");
            String featureId = "";
            featureId = featureDefObj instanceof DynamicObject ? ((DynamicObject)featureDefObj).getString("id") : "0";
            String featureVal = obj.getString("featurevalue");
            Object dataKey = featureId + featureVal;
            list.add(dataKey);
        }
        Object[] retArray = list.toArray(new String[list.size()]);
        Arrays.sort(retArray);
        StringBuilder uniquestr = new StringBuilder();
        for (Object dataKey : retArray) {
            uniquestr.append((String)dataKey);
        }
        return uniquestr.toString();
    }

    private void isFeatureTreeEntryShow(DynamicObject productConfig) {
        if (productConfig == null) {
            return;
        }
        DynamicObject productConfigPlan = productConfig.getDynamicObject("productconfigplan");
        if ((productConfigPlan = this.queryComplateConfigPlan(productConfigPlan)) == null) {
            return;
        }
        String fconfigType = productConfigPlan.getString("configtype");
        boolean dealResult = productConfigPlan.getBoolean("isdealresult");
        DynamicObjectCollection treeEntryDOC = productConfig.getDynamicObjectCollection("treeentryentity");
        if (StringUtils.equals((CharSequence)"2", (CharSequence)fconfigType) && !dealResult && treeEntryDOC != null) {
            treeEntryDOC.clear();
        }
    }

    private void hanlderFeatureTreeEntry(DynamicObject productConfig) {
        if (productConfig == null) {
            return;
        }
        DynamicObject productConfigPlan = productConfig.getDynamicObject("productconfigplan");
        if ((productConfigPlan = this.queryComplateConfigPlan(productConfigPlan)) == null) {
            return;
        }
        String fconfigType = productConfigPlan.getString("configtype");
        boolean dealResult = productConfigPlan.getBoolean("isdealresult");
        DynamicObjectCollection treeEntryDOC = productConfig.getDynamicObjectCollection("treeentryentity");
        if (StringUtils.equals((CharSequence)"2", (CharSequence)fconfigType) && dealResult) {
            if (treeEntryDOC == null) {
                return;
            }
            HashSet<Long> materialIDSet = new HashSet<Long>(8);
            HashMap<Long, DynamicObject> materialEntryMap = new HashMap<Long, DynamicObject>(8);
            for (int i = 0; i < treeEntryDOC.size(); ++i) {
                DynamicObject materialDO;
                DynamicObject treeEntryDO = (DynamicObject)treeEntryDOC.get(i);
                if (treeEntryDO == null || (materialDO = treeEntryDO.getDynamicObject("entrymaterial")) == null) continue;
                materialIDSet.add(materialDO.getLong("id"));
                materialEntryMap.put(materialDO.getLong("id"), treeEntryDO);
            }
            QFilter qFilter = new QFilter("id", "in", materialIDSet);
            DynamicObjectCollection materialDOC = QueryServiceHelper.query((String)"bd_material", (String)"id,configproperties", (QFilter[])new QFilter[]{qFilter});
            if (materialDOC != null) {
                treeEntryDOC.clear();
                for (int i = 0; i < materialDOC.size(); ++i) {
                    DynamicObject materialDO = (DynamicObject)materialDOC.get(i);
                    String configProperties = materialDO.getString("configproperties");
                    long materialPK = materialDO.getLong("id");
                    if (!StringUtils.equals((CharSequence)"2", (CharSequence)configProperties)) continue;
                    treeEntryDOC.add(materialEntryMap.get(materialPK));
                }
            }
        }
    }

    private DynamicObject queryComplateConfigPlan(DynamicObject productConfigPlan) {
        if (productConfigPlan == null) {
            return null;
        }
        long planPk = productConfigPlan.getLong("id");
        DynamicObject planDO = BusinessDataServiceHelper.loadSingle((Object)planPk, (String)"pdm_proconfigscheme");
        return planDO;
    }

    private void createConfigNum(DynamicObject productConfig) {
        if (productConfig == null) {
            return;
        }
        DynamicObject masterConfigCode = productConfig.getDynamicObject("masterconfigcode");
        DynamicObjectCollection treeentryentity = productConfig.getDynamicObjectCollection("treeentryentity");
        if (treeentryentity == null || treeentryentity.isEmpty()) {
            return;
        }
        String rootSeq = this.getRootElement(treeentryentity);
        if (rootSeq == null || "".equals(rootSeq)) {
            return;
        }
        String configCode = "";
        if (masterConfigCode != null) {
            configCode = String.valueOf(masterConfigCode.getPkValue());
        } else {
            HashMap<String, Integer> params = new HashMap<String, Integer>(10);
            params.put("ventryseq", Integer.parseInt(rootSeq));
            com.alibaba.fastjson.JSONObject configJSON = ConfigNumberGenerateUtils.autoGenerateConfigNumer((DynamicObject)productConfig, (String)"pdm_productconfigure", params);
            configCode = configJSON.getString(String.valueOf(rootSeq));
            productConfig.set("masterconfigcode", (Object)Long.parseLong(configCode));
        }
        this.operateOption.setVariableValue("configcode", configCode);
        boolean isMultipleConfigCode = PdmParamSetHelper.getBooleanParamValue((String)"isMultipleConfigCode");
        for (int i = 0; i < treeentryentity.size(); ++i) {
            String configProperties;
            DynamicObject treeentryentityObj = (DynamicObject)treeentryentity.get(i);
            Object seq = treeentryentityObj.get("seq");
            String newEntryCode = "";
            if (isMultipleConfigCode) {
                DynamicObject entryCode = treeentryentityObj.getDynamicObject("configcode");
                if (entryCode == null && !rootSeq.equals(seq.toString())) {
                    HashMap<String, Object> params = new HashMap<String, Object>(10);
                    params.put("ventryseq", seq);
                    com.alibaba.fastjson.JSONObject configJSON = ConfigNumberGenerateUtils.autoGenerateConfigNumer((DynamicObject)productConfig, (String)"pdm_productconfigure", params);
                    newEntryCode = configJSON.getString(String.valueOf(seq));
                } else {
                    newEntryCode = rootSeq.equals(seq.toString()) ? configCode : "0";
                }
            } else {
                newEntryCode = configCode;
            }
            DynamicObject entryMatObj = treeentryentityObj.getDynamicObject("entrymaterial");
            String string = configProperties = entryMatObj == null ? "" : entryMatObj.getString("configproperties");
            if ("2".equals(configProperties) || "3".equals(configProperties)) {
                treeentryentityObj.set("configcode", (Object)Long.parseLong(newEntryCode));
                continue;
            }
            treeentryentityObj.set("configcode", (Object)0L);
        }
    }

    private String getRootElement(DynamicObjectCollection allTreeList) {
        String retSeq = "";
        if (allTreeList == null || allTreeList.isEmpty()) {
            return retSeq;
        }
        for (int i = 0; i < allTreeList.size(); ++i) {
            DynamicObject entryObj = (DynamicObject)allTreeList.get(i);
            String pid = entryObj.getString("pid");
            String enrtySeq = entryObj.getString("seq");
            if (!"0".equals(pid)) continue;
            retSeq = enrtySeq;
            break;
        }
        return retSeq;
    }

    private DynamicObject getNewDynamicObject(DynamicObject dataEntity, DataSet proConfigDatSet, DynamicObjectCollection newfeatureDefs, DynamicObjectCollection newfeatureVals) {
        Map<Object, DynamicObject> matMap = this.searchMaterial(proConfigDatSet.copy());
        DynamicObject productConfig = BusinessDataServiceHelper.newDynamicObject((String)"pdm_productconfigure");
        DataEntityPropertyCollection productConfigureProperties = dataEntity.getDynamicObjectType().getProperties();
        for (IDataEntityProperty iDataEntityProperty : productConfigureProperties) {
            if (StringUtils.equals((CharSequence)"orgfield", (CharSequence)iDataEntityProperty.getName()) || StringUtils.equals((CharSequence)"orgfield_id", (CharSequence)iDataEntityProperty.getName())) {
                productConfig.set("orgfield", null);
                productConfig.set("orgfield_id", (Object)0L);
                continue;
            }
            if (StringUtils.equals((CharSequence)"createorg_id", (CharSequence)iDataEntityProperty.getName()) || StringUtils.equals((CharSequence)"createorg", (CharSequence)iDataEntityProperty.getName())) {
                DynamicObject createorg = (DynamicObject)dataEntity.get("createorg");
                productConfig.set("createorg", (Object)createorg);
                productConfig.set("createorg_id", (Object)createorg.getLong("id"));
                continue;
            }
            if (StringUtils.equals((CharSequence)"treeentryentity", (CharSequence)iDataEntityProperty.getName())) {
                this.createTreeEntry(proConfigDatSet, productConfig, matMap);
                continue;
            }
            if (StringUtils.equals((CharSequence)"entryentity", (CharSequence)iDataEntityProperty.getName())) {
                productConfig.set("entryentity", (Object)newfeatureDefs);
                continue;
            }
            if (StringUtils.equals((CharSequence)"featuretreeentryentity", (CharSequence)iDataEntityProperty.getName())) {
                productConfig.set("featuretreeentryentity", (Object)newfeatureVals);
                continue;
            }
            Object value = iDataEntityProperty.getValue((Object)dataEntity);
            productConfig.set(iDataEntityProperty, value);
        }
        productConfig.set("useorg_id", (Object)0L);
        productConfig.set("status", (Object)"A");
        return productConfig;
    }

    private Map<Object, DynamicObject> searchMaterial(DataSet proConfigDatSet) {
        if (proConfigDatSet == null) {
            return null;
        }
        HashSet<Long> matIdSet = new HashSet<Long>(100);
        while (proConfigDatSet.hasNext()) {
            Row row = proConfigDatSet.next();
            long matId = row.getLong("entrymaterial_id");
            matIdSet.add(matId);
        }
        if (matIdSet.isEmpty()) {
            return null;
        }
        QFilter filter = new QFilter("id", "in", matIdSet);
        return BusinessDataServiceHelper.loadFromCache((String)"bd_material", (QFilter[])new QFilter[]{filter});
    }

    private void createTreeEntry(DataSet proConfigDatSet, DynamicObject productConfig, Map<Object, DynamicObject> matMap) {
        if (proConfigDatSet == null) {
            return;
        }
        DynamicObjectCollection treeEntityEntry = productConfig.getDynamicObjectCollection("treeentryentity");
        int seq = 0;
        while (proConfigDatSet.hasNext()) {
            Row row = proConfigDatSet.next();
            String pid = row.getString("pid");
            DynamicObject treeEntryObj = treeEntityEntry.addNew();
            if ("0".equals(pid)) {
                this.createRootNode(treeEntryObj, row, seq, matMap);
                ++seq;
                continue;
            }
            this.createChildNode(treeEntryObj, row, seq, matMap);
            ++seq;
        }
    }

    private void createRootNode(DynamicObject targetObj, Row sourceObj, int seq, Map<Object, DynamicObject> matMap) {
        DynamicObject entryMaterialObj = matMap.get(sourceObj.get("entrymaterial_id"));
        DynamicObject entryUnit = null;
        if (entryMaterialObj != null) {
            entryUnit = entryMaterialObj.getDynamicObject("baseunit");
        }
        targetObj.set("seq", (Object)seq);
        targetObj.set("entryseq", (Object)1);
        targetObj.set("entrymaterial", (Object)entryMaterialObj);
        targetObj.set("entryunit", (Object)entryUnit);
        targetObj.set("entryscraprate", (Object)0);
        targetObj.set("entryfixscrap", (Object)0);
        targetObj.set("entryqty", (Object)1);
        targetObj.set("entryqtydenominator", (Object)1);
        targetObj.set("entryqtynumerator", (Object)1);
        targetObj.set("pid", (Object)sourceObj.getLong("pid"));
        targetObj.set("id", (Object)sourceObj.getLong("id"));
        targetObj.set("entrymaterial", (Object)entryMaterialObj);
    }

    private void createChildNode(DynamicObject targetObj, Row sourceObj, int seq, Map<Object, DynamicObject> matMap) {
        DynamicObject entryMaterialObj = matMap.get(sourceObj.get("entrymaterial_id"));
        targetObj.set("seq", (Object)seq);
        targetObj.set("entryseq", sourceObj.get("entryseq"));
        targetObj.set("pid", (Object)sourceObj.getLong("pid"));
        targetObj.set("id", (Object)sourceObj.getLong("id"));
        targetObj.set("superbomentryid", (Object)sourceObj.getLong("superbomentryid"));
        Set entrySet = ProductConfigureListConst.getProperties().entrySet();
        for (Map.Entry next : entrySet) {
            String value = (String)next.getValue();
            if ("entrymaterialid".equals(value)) {
                targetObj.set((String)next.getKey(), (Object)entryMaterialObj);
                continue;
            }
            targetObj.set((String)next.getKey(), sourceObj.get((String)next.getValue()));
        }
        logger.warn(String.format("mmc-pdm-copy-bomdatas mId: %s, auxProp: %s, srcAuxProp: %s", targetObj.get("entrymaterial"), targetObj.get("entryauxproperty"), sourceObj.get("entryauxproperty")));
        targetObj.set("entryauxproperty", sourceObj.get("entryauxproperty"));
    }
}

