/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.opplugin.workcard;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pdm.common.workcard.ToolRequireCardUtils;
import kd.mmc.pdm.opplugin.workcard.ToolRequireCardUpdateVal;
import org.apache.commons.collections4.CollectionUtils;

public class ToolRequireCardUpdateOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        ToolRequireCardUtils.setEntityColumn((PreparePropertysEventArgs)e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ToolRequireCardUpdateVal());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        long userId = RequestContext.get().getCurrUserId();
        HashSet<Long> projectIds = new HashSet<Long>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> cardIds = new HashSet<Long>(16);
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject projectRange;
            DynamicObject dataEntity = dataEntities[i];
            if (dataEntity.getDynamicObject("org") != null) {
                orgIds.add(dataEntity.getDynamicObject("org").getLong("id"));
            }
            if ((projectRange = dataEntity.getDynamicObject("projectrange")) != null && projectRange.getDynamicObject("project") != null) {
                projectIds.add(projectRange.getDynamicObject("project").getLong("id"));
            }
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : dynamicObjectCollection) {
                if (object.getDynamicObject("cardnum") == null) continue;
                cardIds.add(object.getDynamicObject("cardnum").getLong("id"));
            }
        }
        Map projectCardMap = ToolRequireCardUtils.getProjectCardMap(projectIds, (String)"mpdm_cardtooldemand");
        Set toolDemand = ToolRequireCardUtils.getCardToolDemand(orgIds, cardIds);
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObjectCollection dynamicObjectCollection;
            DynamicObject dataEntity = dataEntities[i];
            DynamicObject projectRange = dataEntity.getDynamicObject("projectrange");
            if (projectRange == null || projectRange.getDynamicObject("project") == null) continue;
            Set set = (Set)projectCardMap.get(projectRange.getDynamicObject("project").getLong("id"));
            if (CollectionUtils.isNotEmpty((Collection)set)) {
                dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
                for (DynamicObject object : dynamicObjectCollection) {
                    if (object.getDynamicObject("cardnum") != null && set.contains(object.getDynamicObject("cardnum").getLong("id"))) {
                        if ("D".equals(object.getString("toolstatus"))) {
                            object.set("toolstatus", (Object)"A");
                        }
                        if (!"D".equals(object.getString("toolstatus")) && !"C".equals(object.getString("toolstatus")) && object.getDynamicObject("cardnum") != null && toolDemand.contains(object.getDynamicObject("cardnum").getLong("id"))) {
                            object.set("toolstatus", (Object)"C");
                        }
                    }
                    if (object.getDynamicObject("cardnum") == null || set.contains(object.getDynamicObject("cardnum").getLong("id")) || "C".equals(object.getString("toolstatus"))) continue;
                    object.set("toolstatus", (Object)"D");
                }
                if ("B".equals(projectRange.getString("toolcreatestatus"))) continue;
                Set longs = ToolRequireCardUtils.getToolRequireCard(orgIds, (Set)set);
                List addCardIds = set.stream().filter(x -> !longs.contains(x)).collect(Collectors.toList());
                Map map = BusinessDataServiceHelper.loadFromCache((String)"mpdm_mrocardroute", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", addCardIds)});
                for (Long id : addCardIds) {
                    DynamicObject object1 = dynamicObjectCollection.addNew();
                    object1.set("cardnum", map.get(id));
                    object1.set("requiretool", (Object)"A");
                    object1.set("toolstatus", (Object)"A");
                    object1.set("moduser", (Object)userId);
                }
                continue;
            }
            dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : dynamicObjectCollection) {
                if ("C".equals(object.getString("toolstatus"))) continue;
                object.set("toolstatus", (Object)"D");
            }
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        ToolRequireCardUtils.updateProject((DynamicObject[])e.getDataEntities());
    }
}

