/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.bom.ecoroute.EcoCommonHelper;

public class AddEcoLogUtils {
    public static void addEcoLogByActtime(DynamicObject ecoChangeEntry, DynamicObject ecoBill, DynamicObject ecoPentry, Map<String, DynamicObject> ecoRecordLogMap, List<DynamicObject> ecoRecordLogList, String logremark, Date oldActTime, String oldEstimatestatus) {
        String fieldName;
        String fieldNumber;
        DynamicObject ecoLog = AddEcoLogUtils.genEcoLog(ecoChangeEntry, ecoBill, ecoPentry, ecoRecordLogMap, ecoRecordLogList);
        Date newActTime = AddEcoLogUtils.getNewActtime(ecoChangeEntry);
        String newEstimatestatus = AddEcoLogUtils.getNewEstimateStatus(ecoChangeEntry);
        if (PlatformUtils.isDiffDate((Date)oldActTime, (Date)newActTime)) {
            fieldNumber = AddEcoLogUtils.getActtimeFieldNumber(ecoChangeEntry);
            fieldName = AddEcoLogUtils.getFieldName(ecoChangeEntry, fieldNumber);
            AddEcoLogUtils.genEcoLogEntry(ecoLog, fieldNumber, fieldName, AddEcoLogUtils.getStringValue(oldActTime), AddEcoLogUtils.getStringValue(newActTime), logremark);
        }
        if (PlatformUtils.isDiffString((String)oldEstimatestatus, (String)newEstimatestatus)) {
            fieldNumber = AddEcoLogUtils.getEstimateStatusFieldNumber(ecoChangeEntry);
            fieldName = AddEcoLogUtils.getFieldName(ecoChangeEntry, fieldNumber);
            AddEcoLogUtils.genEcoLogEntry(ecoLog, fieldNumber, fieldName, AddEcoLogUtils.getStringValue(AddEcoLogUtils.getEstimateStatusValueName(oldEstimatestatus)), AddEcoLogUtils.getStringValue(AddEcoLogUtils.getEstimateStatusValueName(newEstimatestatus)), logremark);
        }
    }

    public static void addEcoLog(DynamicObject oldEcoChangeEntry, DynamicObject newEcoChangeEntry, DynamicObject ecoBill, DynamicObject ecoPentry, Map<String, DynamicObject> ecoRecordLogMap, List<DynamicObject> ecoRecordLogList, String logremark, DynamicObject oldEcoType, DynamicObject newEcoType, Map<String, Object> newValueMap) {
        boolean isEcoTypeDiff = EcoCommonHelper.isDifferent((Object)oldEcoType, (Object)newEcoType);
        Map<String, String> diffFieldMap = AddEcoLogUtils.getDiffField(oldEcoChangeEntry, newEcoChangeEntry, newValueMap);
        if (diffFieldMap.isEmpty() && !isEcoTypeDiff) {
            return;
        }
        DynamicObject ecoLog = AddEcoLogUtils.genEcoLog(oldEcoChangeEntry, ecoBill, ecoPentry, ecoRecordLogMap, ecoRecordLogList);
        for (Map.Entry<String, String> fieldMap : diffFieldMap.entrySet()) {
            String fieldNumber = fieldMap.getKey();
            String fieldName = fieldMap.getValue();
            Object oldValue = oldEcoChangeEntry.get(fieldNumber);
            Object newValue = AddEcoLogUtils.getNewValue(newEcoChangeEntry, newValueMap, fieldNumber);
            if (AddEcoLogUtils.isEstimateStatusField(fieldNumber)) {
                oldValue = AddEcoLogUtils.getEstimateStatusValueName(oldValue);
                newValue = AddEcoLogUtils.getEstimateStatusValueName(newValue);
            } else if (AddEcoLogUtils.isTransqtyField(fieldNumber)) {
                oldValue = AddEcoLogUtils.formatBigdecimal((BigDecimal)oldValue, newEcoChangeEntry);
                newValue = AddEcoLogUtils.formatBigdecimal((BigDecimal)newValue, newEcoChangeEntry);
            }
            AddEcoLogUtils.genEcoLogEntry(ecoLog, fieldNumber, fieldName, AddEcoLogUtils.getStringValue(oldValue), AddEcoLogUtils.getStringValue(newValue), logremark);
        }
        if (isEcoTypeDiff) {
            String fieldNumber = "ecotype";
            String fieldName = AddEcoLogUtils.getFieldName(ecoPentry, fieldNumber);
            Object oldValue = oldEcoChangeEntry.get(fieldNumber);
            Object newValue = newEcoChangeEntry.get(fieldNumber);
            AddEcoLogUtils.genEcoLogEntry(ecoLog, fieldNumber, fieldName, AddEcoLogUtils.getStringValue(oldValue), AddEcoLogUtils.getStringValue(newValue), logremark);
        }
    }

    public static void addEcoLogByField(DynamicObject ecoBomEntry, Object oldValue, Object newValue, String fieldNumber, String fieldName, DynamicObject ecoBill, DynamicObject ecoPentry, Map<String, DynamicObject> ecoRecordLogMap, List<DynamicObject> ecoRecordLogList, String logremark) {
        DynamicObject ecoLog = AddEcoLogUtils.genEcoLog(ecoBomEntry, ecoBill, ecoPentry, ecoRecordLogMap, ecoRecordLogList);
        AddEcoLogUtils.genEcoLogEntry(ecoLog, fieldNumber, fieldName, AddEcoLogUtils.getStringValue(oldValue), AddEcoLogUtils.getStringValue(newValue), logremark);
    }

    public static void addEcoLogByEstimate(DynamicObject result, Map<String, DynamicObject> ecoRecordLogMap, List<DynamicObject> ecoRecordLogList, String logremark, Date oldActTime, String oldEstimatestatus, Date newActTime, String newEstimatestatus) {
        String fieldName;
        String fieldNumber;
        DynamicObject ecoLog = AddEcoLogUtils.genEcoLog(result, ecoRecordLogMap, ecoRecordLogList);
        if (PlatformUtils.isDiffDate((Date)oldActTime, (Date)newActTime)) {
            fieldNumber = AddEcoLogUtils.getActtimeFieldNumber(null);
            fieldName = AddEcoLogUtils.getFieldName(null, fieldNumber);
            AddEcoLogUtils.genEcoLogEntry(ecoLog, fieldNumber, fieldName, AddEcoLogUtils.getStringValue(oldActTime), AddEcoLogUtils.getStringValue(newActTime), logremark);
        }
        if (PlatformUtils.isDiffString((String)oldEstimatestatus, (String)newEstimatestatus)) {
            fieldNumber = AddEcoLogUtils.getEstimateStatusFieldNumber(null);
            fieldName = AddEcoLogUtils.getFieldName(null, fieldNumber);
            AddEcoLogUtils.genEcoLogEntry(ecoLog, fieldNumber, fieldName, AddEcoLogUtils.getStringValue(AddEcoLogUtils.getEstimateStatusValueName(oldEstimatestatus)), AddEcoLogUtils.getStringValue(AddEcoLogUtils.getEstimateStatusValueName(newEstimatestatus)), logremark);
        }
    }

    private static DynamicObject genEcoLog(DynamicObject ecoChangeEntry, DynamicObject ecoBill, DynamicObject ecoPentry, Map<String, DynamicObject> ecoRecordLogMap, List<DynamicObject> ecoRecordLogList) {
        String cacheKeys = AddEcoLogUtils.genKeys(ecoChangeEntry);
        DynamicObject ecoLog = ecoRecordLogMap.get(cacheKeys);
        if (ecoLog == null) {
            Long ecoLogId = AddEcoLogUtils.getEcoChangeLogId(ecoChangeEntry);
            ecoLog = ecoLogId == null || ecoLogId.equals(0L) ? AddEcoLogUtils.newEcoLog(ecoChangeEntry, ecoBill, ecoPentry) : BusinessDataServiceHelper.loadSingle((Object)ecoLogId, (String)"pdm_ecochangelog");
            ecoRecordLogMap.put(cacheKeys, ecoLog);
        }
        PlatformUtils.addList(ecoRecordLogList, (DynamicObject)ecoLog);
        return ecoLog;
    }

    private static DynamicObject genEcoLog(DynamicObject result, Map<String, DynamicObject> ecoRecordLogMap, List<DynamicObject> ecoRecordLogList) {
        String cacheKeys = AddEcoLogUtils.genKeysByResult(result);
        DynamicObject ecoLog = ecoRecordLogMap.get(cacheKeys);
        if (ecoLog == null) {
            Long ecoLogId = AddEcoLogUtils.getEcoChangeLogId("A", result.getLong("ecobomentryid"));
            ecoLog = ecoLogId == null || ecoLogId.equals(0L) ? AddEcoLogUtils.newEcoLogByResult(result) : BusinessDataServiceHelper.loadSingle((Object)ecoLogId, (String)"pdm_ecochangelog");
            ecoRecordLogMap.put(cacheKeys, ecoLog);
        }
        PlatformUtils.addList(ecoRecordLogList, (DynamicObject)ecoLog);
        return ecoLog;
    }

    private static Set<String> getInCludeFieldSet() {
        HashSet<String> fieldSet = new HashSet<String>(16);
        fieldSet.add("tranqty");
        fieldSet.add("transtartdate");
        fieldSet.add("entryvaliddate");
        fieldSet.add("entryinvaliddate");
        fieldSet.add("acttime");
        fieldSet.add("entryrefno");
        fieldSet.add("estimatestatus");
        fieldSet.add("groupkey");
        fieldSet.add("refkey");
        fieldSet.add("iscanestimate");
        fieldSet.add("continuouspoint");
        fieldSet.add("entrygroupno");
        fieldSet.add("copentryvaliddate");
        fieldSet.add("copentryinvaliddate");
        fieldSet.add("copacttime");
        return fieldSet;
    }

    private static Map<String, String> getDiffField(DynamicObject oldEcoChangeEntry, DynamicObject newEcoChangeEntry, Map<String, Object> newValueMap) {
        HashMap<String, String> diffMap = new HashMap<String, String>(16);
        Set<String> unIncludeFieldSet = AddEcoLogUtils.getInCludeFieldSet();
        for (String fieldNumber : unIncludeFieldSet) {
            Object newValue;
            Object oldValue;
            if (!oldEcoChangeEntry.containsProperty(fieldNumber) || !newEcoChangeEntry.containsProperty(fieldNumber) || !EcoCommonHelper.isDifferent((Object)(oldValue = oldEcoChangeEntry.get(fieldNumber)), (Object)(newValue = AddEcoLogUtils.getNewValue(newEcoChangeEntry, newValueMap, fieldNumber)))) continue;
            diffMap.put(fieldNumber, AddEcoLogUtils.getFieldName(oldEcoChangeEntry, fieldNumber));
        }
        return diffMap;
    }

    private static Object getNewValue(DynamicObject newEcoChangeEntry, Map<String, Object> newValueMap, String fieldNumber) {
        if (newValueMap != null && newValueMap.containsKey(fieldNumber)) {
            return newValueMap.get(fieldNumber);
        }
        return newEcoChangeEntry.get(fieldNumber);
    }

    private static DynamicObject newEcoLog(DynamicObject ecoChangeEntry, DynamicObject ecoBill, DynamicObject ecoPentry) {
        DynamicObject ecoLog = AddEcoLogUtils.buildEcoLogHead();
        ecoLog.set("bomecoid", (Object)ecoBill.getLong("id"));
        ecoLog.set("org", (Object)ecoBill.getDynamicObject("org"));
        ecoLog.set("number", (Object)ecoBill.getString("billno"));
        ecoLog.set("billno", (Object)ecoBill.getString("billno"));
        ecoLog.set("name", (Object)ecoBill.getString("name"));
        if (AddEcoLogUtils.isBomChange(ecoBill)) {
            ecoLog.set("pentrybom", (Object)ecoPentry.getDynamicObject("pentrybom"));
        } else {
            ecoLog.set("pentryroute", (Object)ecoPentry.getDynamicObject("pentryroute"));
        }
        ecoLog.set("proentrymaterialid", (Object)ecoPentry.getDynamicObject("proentrymaterialid"));
        ecoLog.set("pentryid", ecoPentry.getPkValue());
        ecoLog.set("ecobomid", (Object)AddEcoLogUtils.getEcoBomId(ecoBill, ecoPentry));
        ecoLog.set("ecobomentryid", (Object)AddEcoLogUtils.getEcoChangeEntryId(ecoChangeEntry));
        ecoLog.set("changetype", (Object)ecoBill.getString("changetype"));
        ecoLog.set("entrymode", (Object)AddEcoLogUtils.getEntryMode(ecoChangeEntry));
        ecoLog.set("entryseq", ecoChangeEntry.get("entryseq"));
        String updateObj = AddEcoLogUtils.getUpdateObj(ecoChangeEntry);
        ecoLog.set("updateobject", (Object)updateObj);
        if ("A".equals(updateObj)) {
            ecoLog.set("entrymaterialid", ecoChangeEntry.get("entrymaterial"));
            ecoLog.set("featuretype", ecoChangeEntry.get("featuretype"));
        } else if ("B".equals(updateObj)) {
            ecoLog.set("copentrymaterialid", ecoChangeEntry.get("copentrymaterialid"));
        } else if ("C".equals(updateObj)) {
            ecoLog.set("operation", ecoChangeEntry.get("operation"));
            ecoLog.set("operationno", ecoChangeEntry.get("operationno"));
            ecoLog.set("opparent", ecoChangeEntry.get("parent"));
        }
        return ecoLog;
    }

    private static DynamicObject buildEcoLogHead() {
        DynamicObject ecoLog = BusinessDataServiceHelper.newDynamicObject((String)"pdm_ecochangelog");
        Long ecoLogId = ORM.create().genLongId("pdm_ecochangelog");
        ecoLog.set("status", (Object)"C");
        ecoLog.set("enable", (Object)"1");
        long currentUserId = AddEcoLogUtils.getCurrentUserId();
        Date date = new Date();
        ecoLog.set("creator", (Object)currentUserId);
        ecoLog.set("createtime", (Object)date);
        ecoLog.set("modifier", (Object)currentUserId);
        ecoLog.set("modifytime", (Object)date);
        ecoLog.set("id", (Object)ecoLogId);
        return ecoLog;
    }

    public static DynamicObject newEcoLogByResult(DynamicObject result) {
        DynamicObject ecoLog = AddEcoLogUtils.buildEcoLogHead();
        ecoLog.set("bomecoid", (Object)result.getLong("supplyentryid"));
        ecoLog.set("org", result.get("supplyorg"));
        ecoLog.set("number", result.get("supplybillno"));
        ecoLog.set("billno", result.get("supplybillno"));
        ecoLog.set("name", (Object)"");
        ecoLog.set("pentrybom", result.get("bomid"));
        ecoLog.set("pentryid", (Object)result.getLong("supplyentryid"));
        ecoLog.set("ecobomid", result.get("ecobomid"));
        ecoLog.set("ecobomentryid", result.get("ecobomentryid"));
        ecoLog.set("changetype", (Object)"A");
        ecoLog.set("entrymode", result.get("entrymode"));
        ecoLog.set("entryseq", result.get("supplyseq"));
        ecoLog.set("updateobject", (Object)"A");
        ecoLog.set("entrymaterialid", result.get("material"));
        ecoLog.set("featuretype", result.get("featuretype"));
        return ecoLog;
    }

    private static String getFieldName(DynamicObject ecoChangeEntry, String fieldNumber) {
        if (ecoChangeEntry != null) {
            IDataEntityProperty dataEntityProperties = (IDataEntityProperty)ecoChangeEntry.getDataEntityType().getProperties().get((Object)fieldNumber);
            if (dataEntityProperties != null) {
                return dataEntityProperties.getDisplayName().getLocaleValue();
            }
        } else {
            if (AddEcoLogUtils.isEstimateStatusField(fieldNumber)) {
                return ResManager.loadKDString((String)"\u8bc4\u4f30\u72b6\u6001", (String)"AddEcoLogUtils_14", (String)"mmc-pdm-business", (Object[])new Object[0]);
            }
            if (AddEcoLogUtils.isActtimeField(fieldNumber)) {
                return ResManager.loadKDString((String)"\u5b9e\u65bd\u65f6\u95f4", (String)"AddEcoLogUtils_15", (String)"mmc-pdm-business", (Object[])new Object[0]);
            }
        }
        return fieldNumber;
    }

    public static String getStringValue(Object obj) {
        if (obj instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format((Date)obj);
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? AddEcoLogUtils.getBooleanYes() : AddEcoLogUtils.getBooleanNo();
        }
        if (obj instanceof DynamicObject) {
            DynamicObject dy = (DynamicObject)obj;
            String dyname = dy.getString("name");
            if (StringUtils.isEmpty((String)dyname)) {
                dyname = dy.getString("number");
            }
            if (StringUtils.isEmpty((String)dyname)) {
                dyname = dy.getPkValue().toString();
            }
            return dyname;
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).compareTo(BigDecimal.ZERO) == 0 ? "0" : obj.toString();
        }
        return obj == null ? "" : obj.toString();
    }

    private static DynamicObject genEcoLogEntry(DynamicObject ecoLog, String fieldNumber, String fieldName, String oldValue, String newValue, String remark) {
        DynamicObjectCollection coll = ecoLog.getDynamicObjectCollection("entryentity");
        DynamicObject logEntry = coll.addNew();
        logEntry.set("changedate", (Object)new Date());
        logEntry.set("changeuser", (Object)AddEcoLogUtils.getCurrentUserId());
        logEntry.set("entryremark", (Object)remark);
        logEntry.set("fieldname", (Object)fieldName);
        logEntry.set("fieldnumber", (Object)fieldNumber);
        logEntry.set("oldvalue", (Object)oldValue);
        logEntry.set("newvalue", (Object)newValue);
        logEntry.set("seq", (Object)coll.size());
        ecoLog.set("modifier", logEntry.get("changeuser"));
        ecoLog.set("modifytime", logEntry.get("changedate"));
        return logEntry;
    }

    private static Long getCurrentUserId() {
        return UserServiceHelper.getCurrentUserId();
    }

    public static String getDetialDesc() {
        return ResManager.loadKDString((String)"\u8be6\u60c5", (String)"AddEcoLogUtils_1", (String)"mmc-pdm-business", (Object[])new Object[0]);
    }

    public static String getBooleanYes() {
        return ResManager.loadKDString((String)"\u662f", (String)"AddEcoLogUtils_9", (String)"mmc-pdm-business", (Object[])new Object[0]);
    }

    public static String getBooleanNo() {
        return ResManager.loadKDString((String)"\u5426", (String)"AddEcoLogUtils_10", (String)"mmc-pdm-business", (Object[])new Object[0]);
    }

    private static boolean isBomChange(DynamicObject ecnBill) {
        return "A".equals(ecnBill.getString("changetype"));
    }

    private static Long getEcoBomId(DynamicObject ecnBill, DynamicObject ecoPentry) {
        if (AddEcoLogUtils.isBomChange(ecnBill)) {
            return ecoPentry.getLong("ecobomid");
        }
        return ecoPentry.getLong("ecorouteid");
    }

    private static String getEntityName(DynamicObject ecoChangeEntry) {
        return ecoChangeEntry == null ? "" : ecoChangeEntry.getDynamicObjectType().getName();
    }

    public static boolean isCop(DynamicObject ecoChangeEntry) {
        return "pdm_ecobomcopentry_f7".equals(AddEcoLogUtils.getEntityName(ecoChangeEntry));
    }

    private static String getUpdateObj(DynamicObject ecoChangeEntry) {
        String entityName = AddEcoLogUtils.getEntityName(ecoChangeEntry);
        if ("pdm_ecobomcopentry_f7".equals(entityName)) {
            return "B";
        }
        if ("pdm_ecoroute_entryf7".equals(entityName)) {
            return "C";
        }
        return "A";
    }

    private static Date getNewActtime(DynamicObject ecoChangeEntry) {
        return ecoChangeEntry.getDate(AddEcoLogUtils.getActtimeFieldNumber(ecoChangeEntry));
    }

    private static String getActtimeFieldNumber(DynamicObject ecoChangeEntry) {
        return AddEcoLogUtils.isCop(ecoChangeEntry) ? "copacttime" : "acttime";
    }

    private static String getEstimateStatusFieldNumber(DynamicObject ecoChangeEntry) {
        return "estimatestatus";
    }

    public static boolean isEstimateStatusField(String fieldNumber) {
        return "estimatestatus".equalsIgnoreCase(fieldNumber) || "copestimatestatus".equalsIgnoreCase(fieldNumber);
    }

    public static boolean isTransqtyField(String fieldNumber) {
        return "tranqty".equalsIgnoreCase(fieldNumber);
    }

    public static boolean isActtimeField(String fieldNumber) {
        return "acttime".equalsIgnoreCase(fieldNumber) || "copacttime".equalsIgnoreCase(fieldNumber);
    }

    private static String getEntryMode(DynamicObject ecoChangeEntry) {
        if (AddEcoLogUtils.isCop(ecoChangeEntry)) {
            return ecoChangeEntry.getString("copentrymode");
        }
        return ecoChangeEntry.getString("entrymode");
    }

    private static String getNewEstimateStatus(DynamicObject ecoChangeEntry) {
        return ecoChangeEntry.getString(AddEcoLogUtils.getEstimateStatusFieldNumber(ecoChangeEntry));
    }

    public static String getNewEsRemark(DynamicObject ecoChangeEntry) {
        return ecoChangeEntry.getString("esremark");
    }

    private static Long getEcoChangeEntryId(DynamicObject ecoChangeEntry) {
        return ecoChangeEntry.getLong("entryid");
    }

    public static String getLogRemark(String fromType, Set<Long> ecoBomEntryIdSet, DynamicObject updateDy, String otherRemark) {
        boolean isRefRow = ecoBomEntryIdSet.contains(updateDy.getLong("entryid"));
        String refrows = ResManager.loadKDString((String)"\u81ea\u8eab\u7684", (String)"AddEcoLogUtils_2", (String)"mmc-pdm-business", (Object[])new Object[0]);
        if (!isRefRow) {
            refrows = ResManager.loadKDString((String)"\u5173\u8054\u6570\u636e\u7684", (String)"AddEcoLogUtils_3", (String)"mmc-pdm-business", (Object[])new Object[0]);
        }
        String remark = "";
        remark = "estimatecompute".equals(fromType) ? String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u8bc4\u4f30\u8fd0\u7b97\u5b8c\u6bd5\u540e\u66f4\u65b0%1$s\u5b9e\u65bd\u65f6\u95f4\u53ca\u8bc4\u4f30\u72b6\u6001\u3002", (String)"AddEcoLogUtils_4", (String)"mmc-pdm-business", (Object[])new Object[0]), refrows) : ("handEstimateEnd".equals(fromType) ? String.format(ResManager.loadKDString((String)"\u624b\u5de5\u8bc4\u4f30\u5b8c\u6bd5\u540e\u66f4\u65b0%1$s\u5b9e\u65bd\u65f6\u95f4\u53ca\u8bc4\u4f30\u72b6\u6001\u3002", (String)"AddEcoLogUtils_5", (String)"mmc-pdm-business", (Object[])new Object[0]), refrows) : ("auditecn".equals(fromType) ? String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u5ba1\u6838\u540e\u66f4\u65b0%1$s\u5b9e\u65bd\u65f6\u95f4\u53ca\u8bc4\u4f30\u72b6\u6001\u3002", (String)"AddEcoLogUtils_6", (String)"mmc-pdm-business", (Object[])new Object[0]), refrows) : ("updatebom".equals(fromType) ? String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u63a7\u5236\u5e73\u53f0-\u5b9e\u65bd\u8c03\u6574\u540e\u66f4\u65b0%1$s\u5b9e\u65bd\u65f6\u95f4\u53ca\u8bc4\u4f30\u72b6\u6001\u3002", (String)"AddEcoLogUtils_7", (String)"mmc-pdm-business", (Object[])new Object[0]), refrows) : ResManager.loadKDString((String)"\u5176\u4ed6:\u66f4\u65b0\u5b9e\u65bd\u65f6\u95f4\u53ca\u8bc4\u4f30\u72b6\u6001\u3002", (String)"AddEcoLogUtils_8", (String)"mmc-pdm-business", (Object[])new Object[0]))));
        return StringUtils.isEmpty((String)otherRemark) ? remark : remark + " " + otherRemark;
    }

    public static String getLogRemark(String fromType, Set<Long> ecoBomEntryIdSet, DynamicObject updateDy) {
        return AddEcoLogUtils.getLogRemark(fromType, ecoBomEntryIdSet, updateDy, "");
    }

    private static Long getEcoChangeLogId(DynamicObject ecoChangeEntry) {
        String updateObj = AddEcoLogUtils.getUpdateObj(ecoChangeEntry);
        Long ecoChangeEntryId = AddEcoLogUtils.getEcoChangeEntryId(ecoChangeEntry);
        return AddEcoLogUtils.getEcoChangeLogId(updateObj, ecoChangeEntryId);
    }

    private static String genKeys(DynamicObject ecoChangeEntry) {
        String updateObj = AddEcoLogUtils.getUpdateObj(ecoChangeEntry);
        Long ecoChangeEntryId = AddEcoLogUtils.getEcoChangeEntryId(ecoChangeEntry);
        return updateObj + "_" + ecoChangeEntryId;
    }

    private static String genKeysByResult(DynamicObject result) {
        return result.getString("ecobomentryid");
    }

    private static Long getEcoChangeLogId(String updateObject, Long ecoChangeEntryId) {
        QFilter qfilter = new QFilter("updateobject", "=", (Object)updateObject);
        qfilter = qfilter.and(new QFilter("ecobomentryid", "=", (Object)ecoChangeEntryId));
        DynamicObject log = QueryServiceHelper.queryOne((String)"pdm_ecochangelog", (String)"id", (QFilter[])new QFilter[]{qfilter});
        return log == null ? 0L : log.getLong("id");
    }

    private static String getEstimateStatusValueName(Object value) {
        if ("B".equals(value)) {
            return ResManager.loadKDString((String)"\u8bc4\u4f30\u4e2d", (String)"AddEcoLogUtils_11", (String)"mmc-pdm-business", (Object[])new Object[0]);
        }
        if ("C".equals(value)) {
            return ResManager.loadKDString((String)"\u8bc4\u4f30\u5b8c\u6210", (String)"AddEcoLogUtils_12", (String)"mmc-pdm-business", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u672a\u8bc4\u4f30", (String)"AddEcoLogUtils_13", (String)"mmc-pdm-business", (Object[])new Object[0]);
    }

    private static String formatBigdecimal(BigDecimal tranqty, DynamicObject ecoBomEntry) {
        DynamicObject unit = ecoBomEntry.getDynamicObject("entryunit");
        if (unit != null) {
            return tranqty.setScale(unit.getInt("precision"), AddEcoLogUtils.getRoundType(unit)).toString();
        }
        return tranqty.toString();
    }

    public static int getRoundType(DynamicObject unit) {
        String precisionAccount = unit.getString("precisionaccount");
        int roundType = 0;
        switch (precisionAccount) {
            case "1": {
                roundType = 4;
                break;
            }
            case "2": {
                roundType = 1;
                break;
            }
            case "3": {
                roundType = 0;
                break;
            }
        }
        return roundType;
    }
}

