/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.GetEcoEffectManuftechBusiness;
import kd.mmc.pdm.business.ecoplatform.GetEcoEffectOrderBusiness;
import kd.mmc.pdm.common.bom.ecoplatform.EffectOrderConst;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.MMCUtils;

public class AddEffectOrderBillBusiness {
    private static final Log log = LogFactory.getLog(AddEffectOrderBillBusiness.class);
    private static final int MAXBOTPSIZE = 15000;
    public static final DBRoute scmDBRoute = new DBRoute("scm");

    public List<Object> addData(List<Map<String, Object>> gridDataList, String updateObject) {
        if (PlatformUtils.isNullList(gridDataList)) {
            return null;
        }
        if (this.isRouteChange(updateObject)) {
            return this.addDataByRouteChange(gridDataList);
        }
        return this.addDataByBomChange(gridDataList);
    }

    private List<Object> addDataByRouteChange(List<Map<String, Object>> gridDataList) {
        String updateObject = "B";
        int size = gridDataList.size();
        HashMap<String, DynamicObject> headMap = new HashMap<String, DynamicObject>(16);
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(16);
        HashSet<Long> sfcManftechEntryIdSet = new HashSet<Long>(16);
        HashSet<Long> filterIdSet = new HashSet<Long>(16);
        HashMap<String, Set<Long>> orderEntryIdMap = new HashMap<String, Set<Long>>(16);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> dataMap = gridDataList.get(i);
            Long sfcManftechEntryId = this.getSfcManfTechEntryId(dataMap);
            if (!PlatformUtils.isNullLong((Long)sfcManftechEntryId)) {
                sfcManftechEntryIdSet.add(sfcManftechEntryId);
            }
            Long ecoRequireFilterId = this.getEcoRequireFilterId(dataMap, updateObject);
            filterIdSet.add(ecoRequireFilterId);
            this.addOrderEntryIdToMap(dataMap, orderEntryIdMap, updateObject);
        }
        List sfcManftechDataList = null;
        if (!sfcManftechEntryIdSet.isEmpty()) {
            QFilter qFilter = new QFilter("oprentryentity.id", "in", sfcManftechEntryIdSet);
            DataSet ds = this.getSfcManftechDataSet(qFilter);
            sfcManftechDataList = MMCUtils.parseToList((DataSet)ds);
        }
        Map<Object, DynamicObject> filterMap = this.getEcoFilterData(filterIdSet);
        Map<String, DynamicObject> orderStatusMap = this.queryOrderStatus(orderEntryIdMap);
        long startTime = System.currentTimeMillis();
        HashMap<Long, CodeRuleInfo> codeRuleInfoMap = new HashMap<Long, CodeRuleInfo>(16);
        ORM orm = ORM.create();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> dataMap = gridDataList.get(i);
            Long ecoRequireFilterId = this.getEcoRequireFilterId(dataMap, updateObject);
            String orderEntityName = this.getOrderEntityName(dataMap, updateObject);
            Long orderEntryId = this.getOrderEntryId(dataMap, updateObject);
            boolean isTransmit = this.isTransmit(orderStatusMap.get(orderEntityName + "_" + orderEntryId), filterMap.get(ecoRequireFilterId));
            DynamicObject head = this.buildHead(dataMap, headMap, codeRuleInfoMap, saveList, orm, updateObject, isTransmit);
            DynamicObject entry = this.addEntryDataB(dataMap, head);
            this.addBeforeEntryDataB(dataMap, head, entry, sfcManftechDataList);
            this.addAfterEntryData(dataMap, head, entry, isTransmit);
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info(String.format("------AddEffectOrderBillBusiness.addDataByRouteChange route.size:%s,cost:%s,saveList.size:%s", size, enddate, saveList.size()));
        return this.saveResult(saveList);
    }

    private Long getOrgId(Map<String, Object> dataMap, String updateObject) {
        String fieldNumber = this.isRouteChange(updateObject) ? "orgsfc" : "org";
        return this.getLongValue(dataMap, fieldNumber);
    }

    private DynamicObject buildHead(Map<String, Object> dataMap, Map<String, DynamicObject> headMap, Map<Long, CodeRuleInfo> codeRuleInfoMap, List<DynamicObject> saveList, ORM orm, String updateObject, boolean isTransmit) {
        String groupHeadKeyStrinng = this.getHeadGroupKeyString(dataMap, updateObject, isTransmit);
        DynamicObject head = headMap.get(groupHeadKeyStrinng);
        if (head == null) {
            head = this.addHeadData(dataMap, updateObject);
            head.set("id", (Object)this.genLongId(orm, "pdm_ecoeffectorderbill"));
            if (StringUtils.isEmpty((String)head.getString("billno"))) {
                Long orgId = this.getOrgId(dataMap, updateObject);
                CodeRuleInfo codeRuleInfo = codeRuleInfoMap.get(orgId);
                if (codeRuleInfo == null && !codeRuleInfoMap.containsKey(orgId)) {
                    codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"pdm_ecoeffectorderbill", (DynamicObject)head, (String)String.valueOf(orgId));
                    codeRuleInfoMap.put(orgId, codeRuleInfo);
                }
                if (codeRuleInfo == null) {
                    head.set("billno", (Object)("AUTO-" + head.getLong("id")));
                } else {
                    head.set("billno", (Object)this.getNumbers(codeRuleInfo, head));
                }
            }
            headMap.put(groupHeadKeyStrinng, head);
            saveList.add(head);
        }
        return head;
    }

    private List<Object> addDataByBomChange(List<Map<String, Object>> gridDataList) {
        DataSet ds;
        QFilter qFilter;
        int size = gridDataList.size();
        String updateObject = "A";
        HashMap<String, DynamicObject> headMap = new HashMap<String, DynamicObject>(16);
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(16);
        HashSet<Long> productMaterialMftIdSet = new HashSet<Long>(16);
        HashSet<Long> pomStockEntryIdSet = new HashSet<Long>(16);
        HashSet<Long> omStockEntryIdSet = new HashSet<Long>(16);
        HashSet<Long> filterIdSet = new HashSet<Long>(16);
        HashMap<String, Set<Long>> orderEntryIdMap = new HashMap<String, Set<Long>>(16);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> dataMap = gridDataList.get(i);
            String orderType = this.getStringValue(dataMap, "ordertype");
            Long stockEntryId = this.getMftStockEntryId(dataMap);
            if (!PlatformUtils.isNullLong((Long)stockEntryId)) {
                if ("A".equals(orderType)) {
                    pomStockEntryIdSet.add(stockEntryId);
                } else {
                    omStockEntryIdSet.add(stockEntryId);
                }
            }
            productMaterialMftIdSet.add(this.getLongValue(dataMap, "productmaterialmft"));
            Long ecoRequireFilterId = this.getEcoRequireFilterId(dataMap, updateObject);
            filterIdSet.add(ecoRequireFilterId);
            this.addOrderEntryIdToMap(dataMap, orderEntryIdMap, updateObject);
        }
        HashMap<Object, DynamicObject> mftMap = new HashMap(productMaterialMftIdSet.size());
        if (!productMaterialMftIdSet.isEmpty()) {
            mftMap = this.getMasterIdByMftId(productMaterialMftIdSet);
        }
        Map<Object, DynamicObject> filterMap = this.getEcoFilterData(filterIdSet);
        Map<String, DynamicObject> orderStatusMap = this.queryOrderStatus(orderEntryIdMap);
        List pomStockDataList = null;
        List omStockDataList = null;
        if (!pomStockEntryIdSet.isEmpty()) {
            qFilter = new QFilter("stockentry.id", "in", pomStockEntryIdSet);
            ds = this.getPomMftStockDataSet(qFilter);
            pomStockDataList = MMCUtils.parseToList((DataSet)ds);
        }
        if (!omStockEntryIdSet.isEmpty()) {
            qFilter = new QFilter("stockentry.id", "in", omStockEntryIdSet);
            ds = this.getOmMftStockDataSet(qFilter);
            omStockDataList = MMCUtils.parseToList((DataSet)ds);
        }
        long startTime = System.currentTimeMillis();
        HashMap<Long, CodeRuleInfo> codeRuleInfoMap = new HashMap<Long, CodeRuleInfo>(16);
        ORM orm = ORM.create();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> dataMap = gridDataList.get(i);
            Long ecoRequireFilterId = this.getEcoRequireFilterId(dataMap, updateObject);
            String orderEntityName = this.getOrderEntityName(dataMap, updateObject);
            Long orderEntryId = this.getOrderEntryId(dataMap, updateObject);
            boolean isTransmit = this.isTransmit(orderStatusMap.get(orderEntityName + "_" + orderEntryId), filterMap.get(ecoRequireFilterId));
            DynamicObject head = this.buildHead(dataMap, headMap, codeRuleInfoMap, saveList, orm, updateObject, isTransmit);
            DynamicObject entry = this.addEntryDataA(dataMap, head, mftMap);
            this.addBeforeEntryDataA(dataMap, head, entry, pomStockDataList, omStockDataList);
            this.addAfterEntryData(dataMap, head, entry, isTransmit);
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info(String.format("------AddEffectOrderBillBusiness.addDataByBomChange bom.size:%s,cost:%s,saveList.size:%s", size, enddate, saveList.size()));
        return this.saveResult(saveList);
    }

    private void addOrderEntryIdToMap(Map<String, Object> dataMap, Map<String, Set<Long>> orderEntryIdMap, String updateObject) {
        String orderEntityName = this.getOrderEntityName(dataMap, updateObject);
        Set<Long> orderEntryIdSet = orderEntryIdMap.get(orderEntityName);
        if (orderEntryIdSet == null) {
            orderEntryIdSet = new HashSet<Long>(16);
        }
        orderEntryIdSet.add(this.getOrderEntryId(dataMap, updateObject));
        orderEntryIdMap.put(orderEntityName, orderEntryIdSet);
    }

    private Long getOrderEntryId(Map<String, Object> dataMap, String updateObject) {
        if ("A".equals(updateObject)) {
            return this.getLongValue(dataMap, "orderentryid");
        }
        return this.getLongValue(dataMap, "orderentryidsfc");
    }

    private Map<String, DynamicObject> queryOrderStatus(Map<String, Set<Long>> orderMap) {
        String selectProperties = "id,billstatus,treeentryentity entryid,treeentryentity.planstatus planstatus";
        HashMap<String, DynamicObject> orderEntryStatusMap = new HashMap<String, DynamicObject>(64);
        for (Map.Entry<String, Set<Long>> entrys : orderMap.entrySet()) {
            String orderEntityName = entrys.getKey();
            Set<Long> orderEntryIdSet = entrys.getValue();
            DynamicObjectCollection coll = QueryServiceHelper.query((String)orderEntityName, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("treeentryentity.id", "in", orderEntryIdSet)});
            for (DynamicObject order : coll) {
                orderEntryStatusMap.put(orderEntityName + "_" + order.getLong("entryid"), order);
            }
        }
        return orderEntryStatusMap;
    }

    private List<Object> saveResult(List<DynamicObject> saveList) {
        List successDataList = null;
        if (!saveList.isEmpty()) {
            String errorString;
            OperateOption option = this.getOperateOption();
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pdm_ecoeffectorderbill", (DynamicObject[])saveList.toArray(new DynamicObject[saveList.size()]), (OperateOption)option);
            if (saveResult.getAllErrorOrValidateInfo() != null && !StringUtils.isEmpty((String)(errorString = PlatformUtils.getErrorMsg((OperationResult)saveResult)))) {
                String errorStr = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f71\u54cd\u8ba2\u5355\u7ed3\u679c\u8bb0\u5f55\u65f6\u53d1\u751f\u9519\u8bef\uff1a%1$s\u3002", (String)"AddEffectOrderBillBusiness_8", (String)"mmc-pdm-business", (Object[])new Object[0]), errorString);
                throw new KDBizException(errorStr);
            }
            successDataList = saveResult.getSuccessPkIds();
        }
        return successDataList;
    }

    private boolean isRouteChange(String updateObject) {
        return "B".equals(updateObject);
    }

    public Long genLongId(ORM orm, String entityname) {
        return orm.genLongId(entityname);
    }

    public void deleteNextBillData(List<Object> successDataList) {
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select ", new Object[0]);
        sb.append(" h.fid ", new Object[0]);
        sb.append(" from t_pdm_effectorderbill h ", new Object[0]);
        sb.append(" where ", new Object[0]);
        sb.appendIn("h.fid", successDataList);
        sb.append(" and not exists(select d.fentryid from t_pdm_effectorderentry d  ", new Object[0]);
        sb.append(" inner join t_pdm_effectorderafter d1 on d.fentryid = d1.fentryid  ", new Object[0]);
        sb.append(" where d.fid = h.fid  ", new Object[0]);
        sb.append(" and  d1.fupdateresult <> 'A' ) ", new Object[0]);
        ArrayList<Long> deleteIdList = new ArrayList<Long>(successDataList.size());
        try (DataSet ds = DB.queryDataSet((String)(AddEffectOrderBillBusiness.class.getName() + "deleteNextBillData"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                deleteIdList.add(row.getLong("fid"));
            }
        }
        if (!deleteIdList.isEmpty()) {
            QFilter qfilter = new QFilter("id", "in", deleteIdList);
            DeleteServiceHelper.delete((String)"pdm_ecoeffectorderbill", (QFilter[])new QFilter[]{qfilter});
        }
    }

    public Map<String, Object> genNextBillData(List<Object> successDataList, String changeType) {
        if (this.isRouteChange(changeType)) {
            return this.genNextBillDataByRouteChange(successDataList);
        }
        return this.genNextBillDataByBomChange(successDataList);
    }

    private Map<String, Object> genNextBillDataByBomChange(List<Object> successDataList) {
        List successfulPkIds;
        String msg;
        Map<String, Object> subResultMap;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("errormsg", "");
        resultMap.put("xstockids_pom", null);
        resultMap.put("xstockids_om", null);
        resultMap.put("stockids_pom", null);
        resultMap.put("stockids_om", null);
        if (PlatformUtils.isNullList(successDataList)) {
            return resultMap;
        }
        DynamicObject[] orderDatas = BusinessDataServiceHelper.load((Object[])successDataList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pdm_ecoeffectorderbill"));
        if (orderDatas == null || orderDatas.length < 1) {
            return resultMap;
        }
        List<DynamicObject> xPomMftStockList = this.dealGroupType(orderDatas, "pom_xmftstock");
        List<DynamicObject> xOmMftStockList = this.dealGroupType(orderDatas, "om_xmftstock");
        List<DynamicObject> pomMftStockList = this.dealGroupType(orderDatas, "pom_mftstock");
        List<DynamicObject> omMftStockList = this.dealGroupType(orderDatas, "om_mftstock");
        StringBuilder sb = new StringBuilder();
        if (!PlatformUtils.isNullList(xPomMftStockList)) {
            subResultMap = this.createNextBillByBotp(xPomMftStockList, "pom_xmftstock");
            msg = subResultMap.get("errormsg") == null ? "" : subResultMap.get("errormsg").toString();
            successfulPkIds = PlatformUtils.getPkIdsFromMap(subResultMap, (String)"successpkids");
            this.addString(msg, sb);
            this.genUnionMsg(msg, resultMap);
            resultMap.put("xstockids_pom", successfulPkIds);
        }
        if (!PlatformUtils.isNullList(xOmMftStockList)) {
            subResultMap = this.createNextBillByBotp(xOmMftStockList, "om_xmftstock");
            msg = subResultMap.get("errormsg") == null ? "" : subResultMap.get("errormsg").toString();
            successfulPkIds = PlatformUtils.getPkIdsFromMap(subResultMap, (String)"successpkids");
            this.addString(msg, sb);
            this.genUnionMsg(msg, resultMap);
            resultMap.put("xstockids_om", successfulPkIds);
        }
        if (!PlatformUtils.isNullList(pomMftStockList)) {
            subResultMap = this.createNextBillByBotp(pomMftStockList, "pom_mftstock");
            msg = subResultMap.get("errormsg") == null ? "" : subResultMap.get("errormsg").toString();
            successfulPkIds = PlatformUtils.getPkIdsFromMap(subResultMap, (String)"successpkids");
            this.addString(msg, sb);
            this.genUnionMsg(msg, resultMap);
            resultMap.put("stockids_pom", successfulPkIds);
        }
        if (!PlatformUtils.isNullList(omMftStockList)) {
            subResultMap = this.createNextBillByBotp(omMftStockList, "om_mftstock");
            msg = subResultMap.get("errormsg") == null ? "" : subResultMap.get("errormsg").toString();
            successfulPkIds = PlatformUtils.getPkIdsFromMap(subResultMap, (String)"successpkids");
            this.addString(msg, sb);
            this.genUnionMsg(msg, resultMap);
            resultMap.put("stockids_om", successfulPkIds);
        }
        log.info(String.format("------AddEffectOrderBillBusiness.genNextBillDataByBomChange successDataList.size:%s,xPomMftStockList.size:%s,xOmMftStockList.size:%s,pomMftStockList.size:%s,ENTITY_OMMFTSTOCK.size:%s", successDataList.size(), xPomMftStockList.size(), xOmMftStockList.size(), pomMftStockList.size(), omMftStockList.size()));
        return resultMap;
    }

    private Map<String, Object> genNextBillDataByRouteChange(List<Object> successDataList) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("errormsg", "");
        resultMap.put("xsfcmanftechids_sfc", null);
        if (PlatformUtils.isNullList(successDataList)) {
            return resultMap;
        }
        DynamicObject[] orderDatas = BusinessDataServiceHelper.load((Object[])successDataList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pdm_ecoeffectorderbill"));
        if (orderDatas == null || orderDatas.length < 1) {
            return resultMap;
        }
        List<DynamicObject> xSfcManfTechList = this.dealGroupType(orderDatas, "sfc_xmanftech");
        StringBuilder sb = new StringBuilder();
        if (!PlatformUtils.isNullList(xSfcManfTechList)) {
            Map<String, Object> subResultMap = this.createNextBillByBotp(xSfcManfTechList, "sfc_xmanftech");
            String msg = subResultMap.get("errormsg") == null ? "" : subResultMap.get("errormsg").toString();
            List successfulPkIds = PlatformUtils.getPkIdsFromMap(subResultMap, (String)"successpkids");
            this.addString(msg, sb);
            this.genUnionMsg(msg, resultMap);
            resultMap.put("xsfcmanftechids_sfc", successfulPkIds);
        }
        log.info(String.format("------AddEffectOrderBillBusiness.genNextBillDataByRouteChange,successDataList.size:%s,xSfcManfTechList.size:%s", successDataList.size(), xSfcManfTechList.size()));
        return resultMap;
    }

    public void genUnionMsg(String msg, Map<String, Object> resultMap) {
        if (StringUtils.isNotEmpty((String)msg)) {
            msg = msg + " " + (resultMap.get("errormsg") == null ? "" : resultMap.get("errormsg").toString());
            resultMap.put("errormsg", msg);
        }
    }

    public void addString(String msg, StringBuilder sb) {
        if (!StringUtils.isEmpty((String)msg)) {
            if (sb.length() < 1) {
                sb.append(msg);
            } else {
                sb.append(msg).append("\r\n");
            }
        }
    }

    public Map<String, Object> createNextBillByBotp(List<DynamicObject> sourceBillList, String nextBillEntityName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("errormsg", null);
        resultMap.put("successpkids", null);
        if (sourceBillList == null || sourceBillList.isEmpty()) {
            return resultMap;
        }
        String botpId = this.getDefaultBotpId(nextBillEntityName);
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> allSuccessfulIdList = new ArrayList<Object>(16);
        for (int i = 0; i < sourceBillList.size(); ++i) {
            DynamicObject head = sourceBillList.get(i);
            ListSelectedRow srcBil = new ListSelectedRow(head.getPkValue());
            needPushRows.add(srcBil);
            if (needPushRows.size() <= 15000) continue;
            String msg = this.push(needPushRows, botpId, nextBillEntityName, sourceBillList, allSuccessfulIdList);
            needPushRows.clear();
            this.addString(msg, sb);
        }
        if (!needPushRows.isEmpty()) {
            String msg = this.push(needPushRows, botpId, nextBillEntityName, sourceBillList, allSuccessfulIdList);
            this.addString(msg, sb);
        }
        resultMap.put("errormsg", sb.toString());
        resultMap.put("successpkids", allSuccessfulIdList);
        return resultMap;
    }

    private boolean isXBill(String nextBillEntityName) {
        return "om_xmftstock".equals(nextBillEntityName) || "pom_xmftstock".equals(nextBillEntityName) || "sfc_xmanftech".equals(nextBillEntityName);
    }

    private String push(List<ListSelectedRow> needPushRows, String botpId, String nextBillEntityName, List<DynamicObject> sourceBillList, List<Object> allSuccessfulIdList) {
        PushArgs pushArgs = this.genPushArgs("pdm_ecoeffectorderbill", nextBillEntityName, botpId);
        try {
            pushArgs.setSelectedRows(needPushRows);
            ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
            MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)nextBillEntityName);
            if (!pushResult.isSuccess()) {
                String errors = this.getErrByRes(pushResult);
                log.info("----------AddEffectOrderBillBusiness.push,pushResult is failed :" + errors);
                throw new KDBizException(new ErrorCode("createNextBill", errors), new Object[0]);
            }
            List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
            if (targetBillObjs.isEmpty()) {
                log.info("----------AddEffectOrderBillBusiness.push,pushResult is failed : targetBillObjs.isEmpty()");
                return null;
            }
            HashSet<Long> stockIdSet = new HashSet<Long>(16);
            ArrayList<DynamicObject> stockList = new ArrayList<DynamicObject>(16);
            if (this.isXBill(nextBillEntityName)) {
                ORM orm = ORM.create();
                for (int i = 0; i < targetBillObjs.size(); ++i) {
                    DynamicObject tragetBill = (DynamicObject)targetBillObjs.get(i);
                    Long billId = tragetBill.getLong("id");
                    if (billId == null || billId.equals(0L)) {
                        billId = this.genLongId(orm, nextBillEntityName);
                        tragetBill.set("id", (Object)billId);
                    }
                    log.info("----------AddEffectOrderBillBusiness.createNextBill,tragetBill :" + tragetBill.get("billno") + "-" + tragetBill.get("id"));
                }
            } else {
                for (int i = 0; i < targetBillObjs.size(); ++i) {
                    DynamicObject tragetBill = (DynamicObject)targetBillObjs.get(i);
                    Long billId = tragetBill.getLong("id");
                    if (!stockIdSet.add(billId)) continue;
                    stockList.add(tragetBill);
                }
            }
            if (this.isXBill(nextBillEntityName)) {
                OperateOption create = OperateOption.create();
                create.setVariableValue("ishasright", "true");
                create.setVariableValue("ignorewarn", "true");
                create.setVariableValue("ignoreinteraction", "true");
                create.setVariableValue("batchop_batchsize", "50");
                OperationResult saveOperate = SaveServiceHelper.saveOperate((String)nextBillEntityName, (DynamicObject[])targetBillObjs.toArray(new DynamicObject[targetBillObjs.size()]), (OperateOption)create);
                log.info("----------AddEffectOrderBillBusiness.createNextBill,saveOperate :" + saveOperate.toString());
                int errorCount = this.writeXBillInfo(saveOperate, sourceBillList, nextBillEntityName, targetBillObjs);
                List successPkIds = saveOperate.getSuccessPkIds();
                if (successPkIds != null && !successPkIds.isEmpty()) {
                    allSuccessfulIdList.addAll(successPkIds);
                }
                if (errorCount > 0) {
                    String errorStr = String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u4e0b\u6e38\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355\u65f6\u51fa\u73b0%1$s\u6761\u9519\u8bef\uff0c\u8bf7\u524d\u5f80\u201c\u5de5\u7a0b\u53d8\u66f4\u5f71\u54cd\u8ba2\u5355\u8bb0\u5f55\u201d\u5217\u8868\u67e5\u770b\u5206\u6790\u3002", (String)"AddEffectOrderBillBusiness_9", (String)"mmc-pdm-business", (Object[])new Object[0]), errorCount);
                    if (this.isXTech(nextBillEntityName)) {
                        errorStr = String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u4e0b\u6e38\u5de5\u5e8f\u8ba1\u5212\u53d8\u66f4\u5355\u65f6\u51fa\u73b0%1$s\u6761\u9519\u8bef\uff0c\u8bf7\u5728[\u5de5\u7a0b\u53d8\u66f4\u5f71\u54cd\u8bb0\u5f55]\u5217\u8868\u8fdb\u884c\u67e5\u770b\u5206\u6790\u3002", (String)"AddEffectOrderBillBusiness_13", (String)"mmc-pdm-business", (Object[])new Object[0]), errorCount);
                    }
                    return errorStr;
                }
            } else {
                SaveServiceHelper.save((DynamicObject[])stockList.toArray(new DynamicObject[stockList.size()]));
                OperationResult saveOperate = new OperationResult();
                saveOperate.setSuccessPkIds(new ArrayList(stockIdSet));
                int errorCount = this.writeBillInfo(saveOperate, sourceBillList, nextBillEntityName, stockList);
                if (saveOperate.getSuccessPkIds() != null && !saveOperate.getSuccessPkIds().isEmpty()) {
                    allSuccessfulIdList.addAll(saveOperate.getSuccessPkIds());
                }
                if (errorCount > 0) {
                    return String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u4e0b\u6e38\u7ec4\u4ef6\u6e05\u5355\u65f6\u51fa\u73b0%1$s\u6761\u9519\u8bef\u3002\u8bf7\u5728\u201c\u5de5\u7a0b\u53d8\u66f4\u5f71\u54cd\u8ba2\u5355\u8bb0\u5f55\u201d\u5217\u8868\u4e2d\u67e5\u770b\u5206\u6790\u3002", (String)"AddEffectOrderBillBusiness_10", (String)"mmc-pdm-business", (Object[])new Object[0]), errorCount);
                }
            }
            return "";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private int writeBillInfo(OperationResult saveOperate, List<DynamicObject> sourceBillList, String nextBillEntityName, List<DynamicObject> targetBillObjs) {
        HashSet saveSuccessIds = new HashSet(saveOperate.getSuccessPkIds());
        Map<Long, Map<String, Object>> errorDataMap = this.getStockErrorStrMap(saveOperate, targetBillObjs);
        int errorCount = 0;
        Date currentDate = new Date();
        for (int i = 0; i < sourceBillList.size(); ++i) {
            DynamicObject head = sourceBillList.get(i);
            DynamicObjectCollection entryColl = head.getDynamicObjectCollection("entryentity");
            for (int j = 0; j < entryColl.size(); ++j) {
                DynamicObject entry = (DynamicObject)entryColl.get(j);
                DynamicObjectCollection afterColl = entry.getDynamicObjectCollection("subentryentityafter");
                for (int k = 0; k < afterColl.size(); ++k) {
                    DynamicObject afterentry = (DynamicObject)afterColl.get(k);
                    Long stockId = afterentry.getLong("afterstockid");
                    if (saveSuccessIds.contains(stockId)) {
                        afterentry.set("updateresult", (Object)"B");
                        afterentry.set("updatetime", (Object)currentDate);
                        afterentry.set("errorreason", (Object)"");
                        afterentry.set("nextbillno", afterentry.get("afterstockno"));
                        afterentry.set("nextbillid", afterentry.get("afterstockid"));
                        afterentry.set("nextbillentityname", (Object)nextBillEntityName);
                        continue;
                    }
                    if (!errorDataMap.containsKey(stockId)) continue;
                    Map<String, Object> errDataMap = errorDataMap.get(stockId);
                    afterentry.set("updateresult", (Object)"C");
                    afterentry.set("updatetime", (Object)currentDate);
                    afterentry.set("errorreason", errDataMap.get("errorString"));
                    afterentry.set("nextbillno", (Object)"");
                    afterentry.set("nextbillid", (Object)0L);
                    afterentry.set("nextbillentityname", (Object)nextBillEntityName);
                    ++errorCount;
                }
            }
        }
        SaveServiceHelper.update((DynamicObject[])sourceBillList.toArray(new DynamicObject[sourceBillList.size()]));
        return errorCount;
    }

    public String saveStockData(String nextBillEntityName, DynamicObject stock) {
        String saveResult = "";
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stock});
        }
        catch (Exception e) {
            log.error((Throwable)e);
            saveResult = this.getExceptionString(e);
        }
        return saveResult;
    }

    private String getExceptionString(Exception ex) {
        String msg = ex.getMessage();
        if (msg == null || "".equals(msg) || "null".equals(msg)) {
            msg = PlatformUtils.getExceptionString((Exception)ex);
        }
        if (msg != null && msg.length() > 240) {
            msg = msg.substring(0, 240);
        }
        return String.format(ResManager.loadKDString((String)"\u5931\u8d25:%1$s\u3002", (String)"AddEffectOrderBillBusiness_11", (String)"mmc-pdm-business", (Object[])new Object[0]), msg);
    }

    private int writeXBillInfo(OperationResult saveOperate, List<DynamicObject> sourceBillList, String nextBillEntityName, List<DynamicObject> targetBillObjs) {
        HashSet<Object> saveSuccessIds = new HashSet<Object>(saveOperate.getSuccessPkIds());
        Map<Object, Object> successDataMap = new HashMap(16);
        if (!saveSuccessIds.isEmpty()) {
            successDataMap = this.isXTech(nextBillEntityName) ? this.queryXTechData(saveSuccessIds, nextBillEntityName) : this.queryXStockData(saveSuccessIds, nextBillEntityName);
        }
        Map<String, Map<String, Object>> errorDataMap = this.getXStockErrorStrMap(saveOperate, targetBillObjs);
        Date currentDate = new Date();
        log.info(String.format("----------AddEffectOrderBillBusiness.writeXBillInfo successDataMap:%s,errorDataMap:%s", successDataMap.toString(), errorDataMap.toString()));
        int errorCount = 0;
        for (int i = 0; i < sourceBillList.size(); ++i) {
            DynamicObject head = sourceBillList.get(i);
            DynamicObjectCollection entryColl = head.getDynamicObjectCollection("entryentity");
            for (int j = 0; j < entryColl.size(); ++j) {
                DynamicObject entry = (DynamicObject)entryColl.get(j);
                DynamicObjectCollection afterColl = entry.getDynamicObjectCollection("subentryentityafter");
                for (int k = 0; k < afterColl.size(); ++k) {
                    DynamicObject afterentry = (DynamicObject)afterColl.get(k);
                    Long afterEntryId = afterentry.getLong("id");
                    String keyString = PlatformUtils.getUnionString((Object)head.getPkValue(), (Object)afterEntryId);
                    Map nextDataMap = (Map)successDataMap.get(keyString);
                    Map<String, Object> errDataMap = errorDataMap.get(keyString);
                    if (nextDataMap != null) {
                        afterentry.set("updateresult", (Object)"B");
                        afterentry.set("updatetime", (Object)currentDate);
                        afterentry.set("errorreason", (Object)"");
                        afterentry.set("nextbillno", nextDataMap.get("nextBillNo"));
                        afterentry.set("nextbillid", nextDataMap.get("nextBillId"));
                        afterentry.set("nextbillentityname", nextDataMap.get("nextBillEntityName"));
                        continue;
                    }
                    if (errDataMap == null) continue;
                    afterentry.set("updateresult", (Object)"C");
                    afterentry.set("updatetime", (Object)currentDate);
                    afterentry.set("errorreason", errDataMap.get("errorString"));
                    afterentry.set("nextbillno", (Object)"");
                    afterentry.set("nextbillid", (Object)0L);
                    afterentry.set("nextbillentityname", (Object)nextBillEntityName);
                    ++errorCount;
                }
            }
        }
        SaveServiceHelper.update((DynamicObject[])sourceBillList.toArray(new DynamicObject[sourceBillList.size()]));
        return errorCount;
    }

    private boolean isXTech(String nextBillEntityName) {
        return "sfc_xmanftech".equals(nextBillEntityName);
    }

    private Map<String, Map<String, Object>> getXStockErrorStrMap(OperationResult saveOperate, List<DynamicObject> targetBillObjs) {
        String allErrorString = PlatformUtils.getErrorMsg((OperationResult)saveOperate);
        HashMap<String, Map<String, Object>> errorDataMap = new HashMap<String, Map<String, Object>>(16);
        String entryEntityName = this.getEntryEntity(targetBillObjs.get(0));
        String srcBillIdName = this.getSrcBillId(targetBillObjs.get(0));
        String srcBillEntryIdName = this.getSrcBillEntryId(targetBillObjs.get(0));
        for (IOperateInfo errInfo : saveOperate.getAllErrorOrValidateInfo()) {
            String errorString = errInfo.getMessage();
            if (StringUtils.isEmpty((String)errorString)) {
                errorString = allErrorString;
            }
            if (errorString.length() > 254) {
                errorString = errorString.substring(254);
            }
            for (int i = 0; i < targetBillObjs.size(); ++i) {
                DynamicObject targetBillObj = targetBillObjs.get(i);
                if (!targetBillObj.getPkValue().equals(errInfo.getPkValue())) continue;
                DynamicObjectCollection coll = targetBillObj.getDynamicObjectCollection(entryEntityName);
                for (int j = 0; j < coll.size(); ++j) {
                    DynamicObject entry = (DynamicObject)coll.get(j);
                    Long srcBillId = entry.getLong(srcBillIdName);
                    Long srcbillentryid = entry.getLong(srcBillEntryIdName);
                    HashMap<String, String> dataMap = new HashMap<String, String>(16);
                    dataMap.put("errorString", errorString);
                    errorDataMap.put(PlatformUtils.getUnionString((Object)srcBillId, (Object)srcbillentryid), dataMap);
                }
            }
        }
        return errorDataMap;
    }

    private String getEntryEntity(DynamicObject targetBillObj) {
        if (this.isXTech(targetBillObj.getDataEntityType().getName())) {
            return "oprentryentity";
        }
        return "stockentry";
    }

    private String getSrcBillId(DynamicObject targetBillObj) {
        if (this.isXTech(targetBillObj.getDataEntityType().getName())) {
            return "oprsrcbillid";
        }
        return "srcbillid";
    }

    private String getSrcBillEntryId(DynamicObject targetBillObj) {
        if (this.isXTech(targetBillObj.getDataEntityType().getName())) {
            return "oprsrcbillentryid";
        }
        return "srcbillentryid";
    }

    private Map<Long, Map<String, Object>> getStockErrorStrMap(OperationResult saveOperate, List<DynamicObject> targetBillObjs) {
        String allErrorString = PlatformUtils.getErrorMsg((OperationResult)saveOperate);
        HashMap<Long, Map<String, Object>> errorDataMap = new HashMap<Long, Map<String, Object>>(16);
        for (IOperateInfo errInfo : saveOperate.getAllErrorOrValidateInfo()) {
            String errorString = errInfo.getMessage();
            if (StringUtils.isEmpty((String)errorString)) {
                errorString = allErrorString;
            }
            if (errorString.length() > 254) {
                errorString = errorString.substring(254);
            }
            for (int i = 0; i < targetBillObjs.size(); ++i) {
                DynamicObject targetBillObj = targetBillObjs.get(i);
                if (!targetBillObj.getPkValue().equals(errInfo.getPkValue())) continue;
                HashMap<String, String> dataMap = new HashMap<String, String>(16);
                dataMap.put("errorString", errorString);
                errorDataMap.put((Long)errInfo.getPkValue(), dataMap);
            }
        }
        return errorDataMap;
    }

    private Map<String, Map<String, Object>> queryXStockData(Set<Object> saveSuccessIds, String nextBillEntityName) {
        String selectFields = "id,billno,stockentry.id entryid,stockentry.srcbillid srcbillid,stockentry.srcbillentryid srcbillentryid ";
        HashMap<String, Map<String, Object>> xstockDataMap = new HashMap<String, Map<String, Object>>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(AddEffectOrderBillBusiness.class.getName() + "_queryXStockData"), (String)nextBillEntityName, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", saveSuccessIds)}, (String)"");){
            while (ds.hasNext()) {
                Row arow = ds.next();
                String nextBillNo = arow.getString("billno");
                Long nextBillId = arow.getLong("id");
                Long srcbillid = arow.getLong("srcbillid");
                Long srcbillentryid = arow.getLong("srcbillentryid");
                HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                dataMap.put("nextBillNo", nextBillNo);
                dataMap.put("nextBillId", nextBillId);
                dataMap.put("nextBillEntityName", nextBillEntityName);
                xstockDataMap.put(PlatformUtils.getUnionString((Object)srcbillid, (Object)srcbillentryid), dataMap);
            }
        }
        return xstockDataMap;
    }

    private Map<String, Map<String, Object>> queryXTechData(Set<Object> saveSuccessIds, String nextBillEntityName) {
        String selectFields = "id,billno,oprentryentity.id entryid,oprentryentity.oprsrcbillid srcbillid,oprentryentity.oprsrcbillentryid srcbillentryid ";
        HashMap<String, Map<String, Object>> xstockDataMap = new HashMap<String, Map<String, Object>>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(AddEffectOrderBillBusiness.class.getName() + "_queryXTechData"), (String)nextBillEntityName, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", saveSuccessIds)}, (String)"");){
            while (ds.hasNext()) {
                Row arow = ds.next();
                String nextBillNo = arow.getString("billno");
                Long nextBillId = arow.getLong("id");
                Long srcbillid = arow.getLong("srcbillid");
                Long srcbillentryid = arow.getLong("srcbillentryid");
                HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                dataMap.put("nextBillNo", nextBillNo);
                dataMap.put("nextBillId", nextBillId);
                dataMap.put("nextBillEntityName", nextBillEntityName);
                xstockDataMap.put(PlatformUtils.getUnionString((Object)srcbillid, (Object)srcbillentryid), dataMap);
            }
        }
        return xstockDataMap;
    }

    public String getErrByRes(ConvertOperationResult pushResult) {
        StringBuilder errMessage = new StringBuilder().append(pushResult.getMessage());
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            if (billReport.isFullSuccess()) continue;
            errMessage.append(billReport.getFailMessage());
        }
        return errMessage.toString();
    }

    private String getDefaultBotpId(String nextBillEntityName) {
        List rules = ConvertRuleCache.loadRules((String)"pdm_ecoeffectorderbill", (String)nextBillEntityName);
        ArrayList<String> ruleIdList = new ArrayList<String>(16);
        for (ConvertRuleElement rule : rules) {
            if (!rule.isEnabled()) continue;
            if (rule.isDefRule()) {
                return rule.getId();
            }
            ruleIdList.add(rule.getId());
        }
        if (ruleIdList.size() == 1) {
            return (String)ruleIdList.get(0);
        }
        return null;
    }

    private PushArgs genPushArgs(String sourceEntity, String targetEntity, String botpID) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(sourceEntity);
        pushArgs.setTargetEntityNumber(targetEntity);
        pushArgs.setHasRight(false);
        if (!StringUtils.isEmpty((String)botpID) && !"0".equals(botpID)) {
            pushArgs.setRuleId(botpID);
        }
        pushArgs.setBuildConvReport(true);
        return pushArgs;
    }

    private List<DynamicObject> dealGroupType(DynamicObject[] orderDatas, String nextBillEntityName) {
        ArrayList<DynamicObject> groupList = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < orderDatas.length; ++i) {
            DynamicObject orderData = orderDatas[i];
            Long orderBillTypeId = orderData.getDynamicObject("orderbilltype").getLong("id");
            boolean isUnTransmit = this.isunTransmitData(orderData);
            DynamicObject filter = orderData.getDynamicObject("ecorequirefilter");
            String unTransmitDealMode = filter.getString("untransmitdealmode");
            if (isUnTransmit && "A".equals(unTransmitDealMode)) continue;
            if (this.isXTech(nextBillEntityName)) {
                groupList.add(orderData);
                continue;
            }
            boolean isXStock = this.isXStock(orderData);
            if (isUnTransmit && "B".equals(unTransmitDealMode)) {
                isXStock = false;
            }
            if (nextBillEntityName.equals("pom_xmftstock")) {
                if (!isXStock || !orderBillTypeId.equals(EffectOrderConst.BILLTYPEID_POMMFTSTOCK)) continue;
                groupList.add(orderData);
                continue;
            }
            if (nextBillEntityName.equals("om_xmftstock")) {
                if (!isXStock || !orderBillTypeId.equals(EffectOrderConst.BILLTYPEID_OMMFTSTOCK)) continue;
                groupList.add(orderData);
                continue;
            }
            if (nextBillEntityName.equals("pom_mftstock")) {
                if (isXStock || !orderBillTypeId.equals(EffectOrderConst.BILLTYPEID_POMMFTSTOCK)) continue;
                groupList.add(orderData);
                continue;
            }
            if (!nextBillEntityName.equals("om_mftstock") || isXStock || !orderBillTypeId.equals(EffectOrderConst.BILLTYPEID_OMMFTSTOCK)) continue;
            groupList.add(orderData);
        }
        return groupList;
    }

    public boolean isXStock(DynamicObject orderData) {
        Long transactionTypeId = this.getTransactionTypeId(orderData);
        if (transactionTypeId.equals(0L)) {
            return false;
        }
        String selectProperties = "isstockchange";
        DynamicObject trans = BusinessDataServiceHelper.loadSingleFromCache((Object)transactionTypeId, (String)"mpdm_transactproduct", (String)selectProperties);
        return trans.getBoolean("isstockchange");
    }

    public boolean isunTransmitData(DynamicObject orderData) {
        DynamicObjectCollection entryColl = orderData.getDynamicObjectCollection("entryentity");
        if (entryColl == null || entryColl.isEmpty()) {
            return false;
        }
        DynamicObjectCollection afterColl = ((DynamicObject)entryColl.get(0)).getDynamicObjectCollection("subentryentityafter");
        if (afterColl == null || afterColl.isEmpty()) {
            return false;
        }
        return ((DynamicObject)afterColl.get(0)).getBoolean("isuntransmit");
    }

    public Long getTransactionTypeId(DynamicObject orderData) {
        DynamicObjectCollection entryColl = orderData.getDynamicObjectCollection("entryentity");
        if (entryColl == null || entryColl.isEmpty()) {
            return 0L;
        }
        DynamicObjectCollection afterColl = ((DynamicObject)entryColl.get(0)).getDynamicObjectCollection("subentryentityafter");
        if (afterColl == null || afterColl.isEmpty()) {
            return 0L;
        }
        Object trans = ((DynamicObject)afterColl.get(0)).get("aftertransactiontype");
        if (trans instanceof Long) {
            return (Long)trans;
        }
        if (trans instanceof DynamicObject) {
            return ((DynamicObject)trans).getLong("id");
        }
        return 0L;
    }

    private String getNumbers(CodeRuleInfo codeRule, DynamicObject data) {
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)data);
    }

    private Long getEcoPEntryId(Map<String, Object> dataMap, String updateObject) {
        String fieldNumber = this.isRouteChange(updateObject) ? "ecopentyridsfc" : "ecopentyrid";
        return this.getLongValue(dataMap, fieldNumber);
    }

    private String getOrderType(Map<String, Object> dataMap, String updateObject) {
        String fieldNumber = this.isRouteChange(updateObject) ? "ordertypesfc" : "ordertype";
        return this.getStringValue(dataMap, fieldNumber);
    }

    private Long getTransactionTypeId(Map<String, Object> dataMap, String updateObject) {
        String fieldNumber = this.isRouteChange(updateObject) ? "transactiontypesfc" : "transactiontype";
        return this.getLongValue(dataMap, fieldNumber);
    }

    private Long getEcoRequireFilterId(Map<String, Object> dataMap, String updateObject) {
        String fieldNumber = this.isRouteChange(updateObject) ? "ecorequirefiltersfc" : "ecorequirefilter";
        return this.getLongValue(dataMap, fieldNumber);
    }

    private String getHeadGroupKeyString(Map<String, Object> dataMap, String updateObject, boolean isTransmit) {
        Long ecoPEntryId = this.getEcoPEntryId(dataMap, updateObject);
        String orderType = this.getOrderType(dataMap, updateObject);
        Long orgId = this.getOrgId(dataMap, updateObject);
        Long transactionTypeId = this.getTransactionTypeId(dataMap, updateObject);
        Long ecoRequireFilterId = this.getEcoRequireFilterId(dataMap, updateObject);
        String groupKeyString = PlatformUtils.getUnionString((Object)orgId, (Object)orderType, (Object)transactionTypeId, (Object)ecoRequireFilterId);
        groupKeyString = PlatformUtils.getUnionString((Object)groupKeyString, (Object)(isTransmit ? "1" : "0"));
        if (this.isRouteChange(updateObject)) {
            return groupKeyString;
        }
        String groupNo = this.getStringValue(dataMap, "entrygroupno");
        String refNo = this.getStringValue(dataMap, "entryrefno");
        if (StringUtils.isEmpty((String)refNo)) {
            if (StringUtils.isEmpty((String)groupNo)) {
                return groupKeyString;
            }
            return PlatformUtils.getUnionString((Object)groupKeyString, (Object)ecoPEntryId, (Object)groupNo, (Object)"");
        }
        return PlatformUtils.getUnionString((Object)groupKeyString, (Object)refNo);
    }

    private Long getOrderBillTypeId(Map<String, Object> dataMap, String updateObject) {
        if (this.isRouteChange(updateObject)) {
            return EffectOrderConst.BILLTYPEID_SFCMANFTECH;
        }
        String orderType = this.getStringValue(dataMap, "ordertype");
        return "A".equals(orderType) ? EffectOrderConst.BILLTYPEID_POMMFTSTOCK : EffectOrderConst.BILLTYPEID_OMMFTSTOCK;
    }

    private String getOrderEntityName(Map<String, Object> dataMap, String updateObject) {
        if (this.isRouteChange(updateObject)) {
            return "pom_mftorder";
        }
        String orderType = this.getStringValue(dataMap, "ordertype");
        return "A".equals(orderType) ? "pom_mftorder" : "om_mftorder";
    }

    private DynamicObject addHeadData(Map<String, Object> dataMap, String updateObject) {
        DynamicObject head = BusinessDataServiceHelper.newDynamicObject((String)"pdm_ecoeffectorderbill");
        head.set("org", (Object)this.getOrgId(dataMap, updateObject));
        head.set("billno", (Object)"");
        head.set("billstatus", (Object)"A");
        head.set("updateobject", (Object)updateObject);
        head.set("billtype", (Object)EffectOrderConst.BILLTYPEID_ECOEFFECTORDERBILL);
        head.set("orderbilltype", (Object)this.getOrderBillTypeId(dataMap, updateObject));
        head.set("creator", (Object)RequestContext.get().getCurrUserId());
        head.set("createtime", (Object)new Date());
        head.set("refno", (Object)(this.isRouteChange(updateObject) ? "" : this.getStringValue(dataMap, "entryrefno")));
        head.set("ecorequirefilter", (Object)this.getEcoRequireFilterId(dataMap, updateObject));
        return head;
    }

    private DynamicObject addEntryDataA(Map<String, Object> dataMap, DynamicObject head, Map<Object, DynamicObject> mftMap) {
        DynamicObject materialMft;
        DynamicObject entry = this.getExistEntryObject(dataMap, head, "A");
        if (entry != null) {
            return entry;
        }
        entry = this.buildNewEntryObject(head);
        entry.set("ecoid", (Object)this.getLongValue(dataMap, "ecoid"));
        entry.set("ecobillno", (Object)this.getStringValue(dataMap, "ecochangebillno"));
        entry.set("ecopentyrid", (Object)this.getLongValue(dataMap, "ecopentyrid"));
        entry.set("ecobomentryid", (Object)this.getLongValue(dataMap, "ecobomentryid"));
        entry.set("afterecobomentryid", (Object)this.getLongValue(dataMap, "afterecobomentryid"));
        entry.set("entrymode", (Object)this.getStringValue(dataMap, "entrymode"));
        entry.set("acttime", dataMap.get("acttime"));
        entry.set("changeqtynumerator", (Object)this.getBigDecimalValue(dataMap, "changeqtynumerator"));
        entry.set("changeqtydenominator", (Object)this.getBigDecimalValue(dataMap, "changeqtydenominator"));
        entry.set("productmaterial", (Object)this.getLongValue(dataMap, "productmaterialmft"));
        entry.set("productmaterialid", (Object)0L);
        if (mftMap != null && (materialMft = mftMap.get(this.getLongValue(dataMap, "productmaterialmft"))) != null) {
            entry.set("productmaterialid", (Object)materialMft.getDynamicObject("masterid"));
        }
        entry.set("material", (Object)this.getLongValue(dataMap, "material"));
        entry.set("materialmasterid", (Object)this.getLongValue(dataMap, "materialmasterid"));
        entry.set("productunit", (Object)this.getLongValue(dataMap, "productunit"));
        entry.set("unit", (Object)this.getLongValue(dataMap, "unit"));
        entry.set("fixscrap", (Object)this.getBigDecimalValue(dataMap, "fixscrap"));
        entry.set("scraprate", (Object)this.getBigDecimalValue(dataMap, "scraprate"));
        entry.set("childbomid", (Object)this.getLongValue(dataMap, "childbomid"));
        entry.set("bomworkcenter", (Object)this.getLongValue(dataMap, "bomworkcenter"));
        entry.set("bomworkstation", (Object)this.getLongValue(dataMap, "bomworkstation"));
        entry.set("isjumplevel", (Object)this.getBooleanValue(dataMap, "isjumplevel"));
        entry.set("configuredcode", (Object)this.getLongValue(dataMap, "configuredcode"));
        entry.set("entryqtytype", (Object)this.getStringValue(dataMap, "entryqtytype"));
        entry.set("bomentryid", (Object)this.getLongValue(dataMap, "bomentryid"));
        entry.set("oldbomentryid", (Object)this.getLongValue(dataMap, "oldbomentryid"));
        entry.set("auxproperties", (Object)this.getLongValue(dataMap, "auxproperties"));
        entry.set("bomversion", (Object)this.getLongValue(dataMap, "bomchildversion"));
        entry.set("entrygroupno", (Object)this.getStringValue(dataMap, "entrygroupno"));
        entry.set("entryreplaceplan", (Object)this.getLongValue(dataMap, "afterreplaceplan"));
        entry.set("entryisreplaceplanmm", (Object)this.getBooleanValue(dataMap, "afterisreplaceplanmm"));
        entry.set("reppriority", (Object)this.getIntValue(dataMap, "afterreppriority"));
        entry.set("featuretype", (Object)this.getLongValue(dataMap, "featuretype"));
        return entry;
    }

    private Long getEcoEntryIdByMap(Map<String, Object> dataMap, String updateObject) {
        if (this.isRouteChange(updateObject)) {
            return this.getLongValue(dataMap, "ecorouteentryidsfc");
        }
        return this.getLongValue(dataMap, "ecobomentryid");
    }

    private Long getEcoEntryIdByDynamicObject(DynamicObject entryRow, String updateObject) {
        if (this.isRouteChange(updateObject)) {
            return entryRow.getLong("ecorouteentryid");
        }
        return entryRow.getLong("ecobomentryid");
    }

    private Long getEcoMaterialIdByMap(Map<String, Object> dataMap, String updateObject) {
        if (this.isRouteChange(updateObject)) {
            return 0L;
        }
        return this.getLongValue(dataMap, "materialmasterid");
    }

    private Long getEcoMaterialIdByDynamicObject(DynamicObject entryRow, String updateObject) {
        if (this.isRouteChange(updateObject)) {
            return 0L;
        }
        return entryRow.getLong("materialmasterid");
    }

    private DynamicObject getExistEntryObject(Map<String, Object> dataMap, DynamicObject head, String updateObject) {
        DynamicObjectCollection coll = head.getDynamicObjectCollection("entryentity");
        if (!PlatformUtils.isNullCollection((DynamicObjectCollection)coll)) {
            Long ecoEntryId = this.getEcoEntryIdByMap(dataMap, updateObject);
            Long materialId = this.getEcoMaterialIdByMap(dataMap, updateObject);
            for (DynamicObject entryRow : coll) {
                Long ecoEntryIdRow = this.getEcoEntryIdByDynamicObject(entryRow, updateObject);
                Long materialIdRow = this.getEcoMaterialIdByDynamicObject(entryRow, updateObject);
                if (!ecoEntryIdRow.equals(ecoEntryId) || !materialIdRow.equals(materialId)) continue;
                return entryRow;
            }
        }
        return null;
    }

    private DynamicObject buildNewEntryObject(DynamicObject head) {
        DynamicObjectCollection coll = head.getDynamicObjectCollection("entryentity");
        return coll.addNew();
    }

    private DynamicObject addEntryDataB(Map<String, Object> dataMap, DynamicObject head) {
        DynamicObject entry = this.getExistEntryObject(dataMap, head, "B");
        if (entry != null) {
            return entry;
        }
        entry = this.buildNewEntryObject(head);
        boolean isDisableData = "E".equals(this.getStringValue(dataMap, "entrymodesfc"));
        String changeType = PlatformUtils.getStringValue(dataMap, (String)"changetypesfc");
        entry.set("ecoid", (Object)this.getLongValue(dataMap, "ecoidsfc"));
        entry.set("ecobillno", (Object)this.getStringValue(dataMap, "ecochangebillnosfc"));
        entry.set("ecopentyrid", (Object)this.getLongValue(dataMap, "ecopentyridsfc"));
        entry.set("ecorouteentryid", (Object)this.getLongValue(dataMap, "ecorouteentryidsfc"));
        entry.set("afterecorouteentryid", (Object)this.getLongValue(dataMap, "afterecorouteentryidsfc"));
        entry.set("entrymode", (Object)this.getStringValue(dataMap, "entrymodesfc"));
        entry.set("acttime", dataMap.get("acttimesfc"));
        entry.set("productmaterialid", (Object)this.getLongValue(dataMap, "productmaterialsfc"));
        entry.set("productunit", (Object)this.getLongValue(dataMap, "productunitsfc"));
        entry.set("routeentryid", (Object)this.getLongValue(dataMap, "oprsourceentryidsfc"));
        entry.set("oldrouteentryid", (Object)this.getLongValue(dataMap, "oldoprsourceentryidsfc"));
        entry.set("routeid", (Object)this.getLongValue(dataMap, "processroutesfc"));
        if (isDisableData && !"A".equals(changeType)) {
            entry.set("oprparent", (Object)this.getStringValue(dataMap, "beforeoprparentsfc"));
            entry.set("oproperationno", (Object)this.getStringValue(dataMap, "beforeoprnosfc"));
            entry.set("oproperation", (Object)this.getLongValue(dataMap, "beforeoproperationsfc"));
            entry.set("operationdesc", (Object)this.getStringValue(dataMap, "beforeopdescsfc"));
        } else {
            entry.set("oprparent", (Object)this.getStringValue(dataMap, "afteroprparentsfc"));
            entry.set("oproperationno", (Object)this.getStringValue(dataMap, "afteroprnosfc"));
            entry.set("oproperation", (Object)this.getLongValue(dataMap, "afteroproperationsfc"));
            entry.set("operationdesc", (Object)this.getStringValue(dataMap, "afteropdescsfc"));
        }
        return entry;
    }

    private DynamicObject buildNewBeforeEntryObject(DynamicObject entry) {
        DynamicObjectCollection coll = entry.getDynamicObjectCollection("subentryentitybefore");
        return coll.addNew();
    }

    private Long getBeforeEntryId(DynamicObject entryRow, String updateObject) {
        if (this.isRouteChange(updateObject)) {
            return entryRow.getLong("beforetechentryid");
        }
        return entryRow.getLong("beforestockentryid");
    }

    private DynamicObject getExistBeforeEntryObject(Map<String, Object> dataMap, DynamicObject entry, String updateObject) {
        DynamicObjectCollection coll = entry.getDynamicObjectCollection("subentryentitybefore");
        if (!PlatformUtils.isNullCollection((DynamicObjectCollection)coll)) {
            Long entryId = this.isRouteChange(updateObject) ? this.getSfcManfTechEntryId(dataMap) : this.getMftStockEntryId(dataMap);
            for (DynamicObject entryRow : coll) {
                Long entryIdRow = this.getBeforeEntryId(entryRow, updateObject);
                if (!entryIdRow.equals(entryId)) continue;
                return entryRow;
            }
        }
        return null;
    }

    public DynamicObject addBeforeEntryDataA(Map<String, Object> dataMap, DynamicObject head, DynamicObject entry, List<Map<String, Object>> pomStockDataList, List<Map<String, Object>> omStockDataList) {
        Long stockEntryId = this.getMftStockEntryId(dataMap);
        if (PlatformUtils.isNullLong((Long)stockEntryId)) {
            return null;
        }
        DynamicObject beforeEntry = this.getExistBeforeEntryObject(dataMap, entry, "A");
        if (beforeEntry != null) {
            return beforeEntry;
        }
        String orderType = this.getStringValue(dataMap, "ordertype");
        Map<String, Object> stockEntryData = this.getStockEntryData(orderType, stockEntryId, pomStockDataList, omStockDataList);
        if (stockEntryData == null) {
            String billTypeName = ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355", (String)"AddEffectOrderBillBusiness_06", (String)"mmc-pdm-business", (Object[])new Object[0]);
            if ("B".equals(orderType)) {
                billTypeName = ResManager.loadKDString((String)"\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355", (String)"AddEffectOrderBillBusiness_07", (String)"mmc-pdm-business", (Object[])new Object[0]);
            }
            throw new KDBizException(new ErrorCode("addBeforeEntryData", String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u5206\u5f55ID\u4e3a\u201c%1$s\u201d\u7684\u7ec4\u4ef6\u6e05\u5355\uff0c\u5355\u636e\u7c7b\u578b\u4e3a\u201c%2$s\u201d\uff0c\u65e0\u6cd5\u4ea7\u751f\u5f71\u54cd\u5de5\u5355\u8bb0\u5f55\u8868\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"AddEffectOrderBillBusiness_12", (String)"mmc-pdm-business", (Object[])new Object[0]), stockEntryId, billTypeName)), new Object[0]);
        }
        beforeEntry = this.buildNewBeforeEntryObject(entry);
        beforeEntry.set("beforeorderbillno", (Object)this.getStringValue(stockEntryData, "orderno"));
        beforeEntry.set("beforestockno", (Object)this.getStringValue(stockEntryData, "billno"));
        beforeEntry.set("beforestockentryid", (Object)this.getLongValue(stockEntryData, "stockentry"));
        beforeEntry.set("beforestockid", (Object)this.getLongValue(stockEntryData, "id"));
        beforeEntry.set("beforematerialid", (Object)this.getLongValue(stockEntryData, "stockentry.materielmasterid"));
        beforeEntry.set("beforematerial", (Object)this.getLongValue(stockEntryData, "stockentry.materialid"));
        beforeEntry.set("beforeunit", (Object)this.getLongValue(stockEntryData, "unitid"));
        beforeEntry.set("beforeqtynumerator", (Object)this.getBigDecimalValue(stockEntryData, "stockentry.qtynumerator"));
        beforeEntry.set("beforeqtydenominator", (Object)this.getBigDecimalValue(stockEntryData, "stockentry.qtydenominator"));
        beforeEntry.set("beforedemandqty", (Object)this.getBigDecimalValue(stockEntryData, "stockentry.demandqty"));
        beforeEntry.set("beforefixscrap", (Object)this.getBigDecimalValue(stockEntryData, "stockentry.fixscrap"));
        beforeEntry.set("beforescraprate", (Object)this.getBigDecimalValue(stockEntryData, "stockentry.scraprate"));
        beforeEntry.set("beforeorderqty", (Object)this.getBigDecimalValue(stockEntryData, "qty"));
        beforeEntry.set("beforebomentryid", (Object)this.getLongValue(stockEntryData, "stockentry.bomentryid"));
        beforeEntry.set("beforebomversion", (Object)this.getLongValue(stockEntryData, "stockentry.bomreversion"));
        beforeEntry.set("beforeconfiguredcode", (Object)this.getLongValue(stockEntryData, "stockentry.entryconfiguredcode"));
        beforeEntry.set("beforeworkcenter", (Object)this.getLongValue(stockEntryData, "stockentry.oprworkcenter"));
        beforeEntry.set("beforeworkstation", (Object)this.getLongValue(stockEntryData, "stockentry.workstation"));
        beforeEntry.set("beforeparentmaterial", (Object)this.getLongValue(stockEntryData, "stockentry.parentmaterial"));
        beforeEntry.set("beforejumplevel", (Object)this.getBooleanValue(stockEntryData, "stockentry.isjumplevel"));
        beforeEntry.set("beforestockseq", (Object)this.getIntValue(stockEntryData, "stockentry.seq"));
        beforeEntry.set("beforedemanddate", stockEntryData.get("stockentry.demanddate"));
        beforeEntry.set("beforereplaceplan", (Object)this.getLongValue(stockEntryData, "stockentry.replaceplan"));
        beforeEntry.set("beforeisreplaceplanmm", (Object)this.getBooleanValue(stockEntryData, "stockentry.ismainreplace"));
        beforeEntry.set("beforereppriority", (Object)this.getIntValue(stockEntryData, "stockentry.priority"));
        return beforeEntry;
    }

    public DynamicObject addBeforeEntryDataB(Map<String, Object> dataMap, DynamicObject head, DynamicObject entry, List<Map<String, Object>> sfcManftechDataList) {
        Long sfcManftechEntryId = this.getSfcManfTechEntryId(dataMap);
        if (PlatformUtils.isNullLong((Long)sfcManftechEntryId)) {
            return null;
        }
        DynamicObject beforeEntry = this.getExistBeforeEntryObject(dataMap, entry, "B");
        if (beforeEntry != null) {
            return beforeEntry;
        }
        Map<String, Object> sfcManftechEntryData = this.getSfcManftechEntryData(sfcManftechEntryId, sfcManftechDataList);
        if (sfcManftechEntryData == null) {
            throw new KDBizException(new ErrorCode("addBeforeEntryDataB", String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u5206\u5f55ID\u4e3a[%1$s]\u7684\u5de5\u5e8f\u8ba1\u5212\u6570\u636e\uff0c\u65e0\u6cd5\u4ea7\u751f\u5f71\u54cd\u8bb0\u5f55\u8868\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8fdb\u884c\u5206\u6790\u5904\u7406\u3002", (String)"AddEffectOrderBillBusiness_14", (String)"mmc-pdm-business", (Object[])new Object[0]), sfcManftechEntryId)), new Object[0]);
        }
        beforeEntry = this.buildNewBeforeEntryObject(entry);
        beforeEntry.set("beforeorderbillno", (Object)this.getStringValue(sfcManftechEntryData, "mftentryseq.headbillno"));
        beforeEntry.set("beforetechno", (Object)this.getStringValue(sfcManftechEntryData, "billno"));
        beforeEntry.set("beforetechentryid", (Object)this.getLongValue(sfcManftechEntryData, "oprentryentity"));
        beforeEntry.set("beforetechid", (Object)this.getLongValue(sfcManftechEntryData, "id"));
        beforeEntry.set("beforeorderqty", (Object)this.getBigDecimalValue(sfcManftechEntryData, "qty"));
        beforeEntry.set("beforeworkcenter", (Object)this.getLongValue(sfcManftechEntryData, "oprentryentity.oprworkcenter"));
        beforeEntry.set("beforerouteentryid", (Object)this.getRouteEntryId(sfcManftechEntryData));
        beforeEntry.set("beforeoprparent", (Object)this.getStringValue(sfcManftechEntryData, "oprentryentity.oprparent"));
        beforeEntry.set("beforeoperationno", (Object)this.getStringValue(sfcManftechEntryData, "oprentryentity.oprno"));
        beforeEntry.set("beforeoperation", (Object)this.getLongValue(sfcManftechEntryData, "oprentryentity.oproperation"));
        beforeEntry.set("beforeoprctrlstrategy", (Object)this.getLongValue(sfcManftechEntryData, "oprentryentity.oprctrlstrategy"));
        beforeEntry.set("beforemachiningtype", (Object)this.getStringValue(sfcManftechEntryData, "oprentryentity.machiningtype"));
        beforeEntry.set("beforeproductionorg", (Object)this.getLongValue(sfcManftechEntryData, "oprentryentity.oprorg"));
        beforeEntry.set("beforeoperationunit", (Object)this.getLongValue(sfcManftechEntryData, "oprentryentity.oprunit"));
        beforeEntry.set("beforeheadunit", (Object)this.getLongValue(sfcManftechEntryData, "oprentryentity.headunit"));
        beforeEntry.set("beforeheadqty", (Object)this.getBigDecimalValue(sfcManftechEntryData, "oprentryentity.headqty"));
        beforeEntry.set("beforeoperationqty", (Object)this.getBigDecimalValue(sfcManftechEntryData, "oprentryentity.operationqty"));
        beforeEntry.set("beforeoprqty", (Object)this.getBigDecimalValue(sfcManftechEntryData, "oprentryentity.oprqty"));
        beforeEntry.set("beforebasebatchqty", (Object)this.getBigDecimalValue(sfcManftechEntryData, "oprentryentity.basebatchqty"));
        beforeEntry.set("beforecollaborative", (Object)this.getBooleanValue(sfcManftechEntryData, "oprentryentity.collaborative"));
        beforeEntry.set("beforeismilestoneprocess", (Object)this.getBooleanValue(sfcManftechEntryData, "oprentryentity.ismilestoneprocess"));
        beforeEntry.set("beforestoragepoint", (Object)this.getBooleanValue(sfcManftechEntryData, "oprentryentity.storagepoint"));
        return beforeEntry;
    }

    public Long getRouteEntryId(Map<String, Object> techData) {
        Long routeEntryId = 0L;
        String routeEntryIds = this.getStringValue(techData, "oprentryentity.oprsourceentryid");
        if (routeEntryIds != null && !"".equals(routeEntryIds)) {
            routeEntryId = Long.parseLong(routeEntryIds);
        }
        return routeEntryId;
    }

    private Map<String, Object> getStockEntryData(String orderType, Long stockEntryId, List<Map<String, Object>> pomStockDataList, List<Map<String, Object>> omStockDataList) {
        if ("A".equals(orderType)) {
            return this.getStockEntryDataById(stockEntryId, pomStockDataList);
        }
        return this.getStockEntryDataById(stockEntryId, omStockDataList);
    }

    private Map<String, Object> getStockEntryDataById(Long stockEntryId, List<Map<String, Object>> stockDataList) {
        for (int i = 0; i < stockDataList.size(); ++i) {
            Map<String, Object> stockDataMap = stockDataList.get(i);
            Long stockEntryIdRow = this.getLongValue(stockDataMap, "stockentry");
            if (!stockEntryIdRow.equals(stockEntryId)) continue;
            return stockDataMap;
        }
        return null;
    }

    private Map<String, Object> getSfcManftechEntryData(Long sfcManftechEntryId, List<Map<String, Object>> sfcManftechDataList) {
        return this.getSfcManftechEntryDataById(sfcManftechEntryId, sfcManftechDataList);
    }

    private Map<String, Object> getSfcManftechEntryDataById(Long sfcManftechEntryId, List<Map<String, Object>> sfcManftechDataList) {
        for (int i = 0; i < sfcManftechDataList.size(); ++i) {
            Map<String, Object> techDataMap = sfcManftechDataList.get(i);
            Long techEntryIdRow = this.getLongValue(techDataMap, "oprentryentity");
            if (!techEntryIdRow.equals(sfcManftechEntryId)) continue;
            return techDataMap;
        }
        return null;
    }

    private Long getMftStockEntryId(Map<String, Object> dataMap) {
        String changeType = PlatformUtils.getStringValue(dataMap, (String)"changetype");
        if ("C".equals(changeType)) {
            return 0L;
        }
        return this.getLongValue(dataMap, "stockentryid");
    }

    private Long getSfcManfTechEntryId(Map<String, Object> dataMap) {
        String changeType = PlatformUtils.getStringValue(dataMap, (String)"changetypesfc");
        if ("A".equals(changeType)) {
            return 0L;
        }
        return this.getLongValue(dataMap, "techentryidsfc");
    }

    private DynamicObject addAfterEntryData(Map<String, Object> dataMap, DynamicObject head, DynamicObject entry, boolean isTransmit) {
        DynamicObject afterEntry = this.buildNewAfterEntry(entry);
        boolean isRouteChange = this.isRouteChange(head.getString("updateobject"));
        afterEntry.set("updatetype", (Object)"A");
        if (isRouteChange) {
            boolean isDisableData = "E".equals(this.getStringValue(dataMap, "entrymodesfc"));
            String changeType = PlatformUtils.getStringValue(dataMap, (String)"changetypesfc");
            afterEntry.set("afterorderbillno", (Object)this.getStringValue(dataMap, "orderbillnosfc"));
            afterEntry.set("afterorderid", (Object)this.getLongValue(dataMap, "orderidsfc"));
            afterEntry.set("afterorderentryid", (Object)this.getLongValue(dataMap, "orderentryidsfc"));
            afterEntry.set("afterorderqty", (Object)this.getBigDecimalValue(dataMap, "orderqtysfc"));
            afterEntry.set("oprchangetype", (Object)this.getStringValue(dataMap, "changetypesfc"));
            afterEntry.set("aftertechno", (Object)this.getStringValue(dataMap, "technosfc"));
            afterEntry.set("aftertechid", (Object)this.getLongValue(dataMap, "techidsfc"));
            afterEntry.set("aftertechentryid", (Object)this.getSfcManfTechEntryId(dataMap));
            afterEntry.set("afterrouteentryid", (Object)this.getLongValue(dataMap, "oprsourceentryidsfc"));
            afterEntry.set("afteroperationunit", (Object)this.getLongValue(dataMap, "oprunitsfc"));
            afterEntry.set("afterheadunit", (Object)this.getLongValue(dataMap, "headunitsfc"));
            afterEntry.set("afterheadqty", (Object)this.getBigDecimalValue(dataMap, "headqtysfc"));
            afterEntry.set("afteroperationqty", (Object)this.getBigDecimalValue(dataMap, "operationqtysfc"));
            afterEntry.set("afterbasebatchqty", (Object)this.getBigDecimalValue(dataMap, "basebatchqtysfc"));
            afterEntry.set("afteroprqty", (Object)this.getBigDecimalValue(dataMap, "oprqtysfc"));
            afterEntry.set("afterplanbegintime", dataMap.get("oprplanbegintimesfc"));
            afterEntry.set("afterplanfinishtime", dataMap.get("oprplanfinishtimesfc"));
            afterEntry.set("afteroprstatus", (Object)this.getStringValue(dataMap, "oprstatussfc"));
            afterEntry.set("afterworkcenter", (Object)this.getLongValue(dataMap, "afteroprworkcentersfc"));
            afterEntry.set("changeremark", (Object)this.getStringValue(dataMap, "remarksfc"));
            afterEntry.set("aftertransactiontype", (Object)this.getLongValue(dataMap, "transactiontypesfc"));
            afterEntry.set("afterprocessentry", (Object)this.getLongValue(dataMap, "oprsourceentryidsfc"));
            if (isDisableData && !"A".equals(changeType)) {
                afterEntry.set("afteroprparent", (Object)this.getStringValue(dataMap, "beforeoprparentsfc"));
                afterEntry.set("afteroperationno", (Object)this.getStringValue(dataMap, "beforeoprnosfc"));
                afterEntry.set("afteroperation", (Object)this.getLongValue(dataMap, "beforeoproperationsfc"));
                afterEntry.set("afteroprctrlstrategy", (Object)this.getLongValue(dataMap, "beforeoprctrlstrategysfc"));
                afterEntry.set("aftermachiningtype", (Object)this.getStringValue(dataMap, "beforemachiningtypesfc"));
                afterEntry.set("afterproductionorg", (Object)this.getLongValue(dataMap, "beforeoprorgsfc"));
                afterEntry.set("afterstoragepoint", (Object)this.getBooleanValue(dataMap, "beforestoragepointsfc"));
                afterEntry.set("aftercollaborative", (Object)this.getBooleanValue(dataMap, "beforecollaborativesfc"));
                afterEntry.set("afterismilestoneprocess", (Object)this.getBooleanValue(dataMap, "beforeismilestonesfc"));
            } else {
                afterEntry.set("afteroprparent", (Object)this.getStringValue(dataMap, "afteroprparentsfc"));
                afterEntry.set("afteroperationno", (Object)this.getStringValue(dataMap, "afteroprnosfc"));
                afterEntry.set("afteroperation", (Object)this.getLongValue(dataMap, "afteroproperationsfc"));
                afterEntry.set("afteroprctrlstrategy", (Object)this.getLongValue(dataMap, "afteroprctrlstrategysfc"));
                afterEntry.set("aftermachiningtype", (Object)this.getStringValue(dataMap, "aftermachiningtypesfc"));
                afterEntry.set("afterproductionorg", (Object)this.getLongValue(dataMap, "afteroprorgsfc"));
                afterEntry.set("afterstoragepoint", (Object)this.getBooleanValue(dataMap, "afterstoragepointsfc"));
                afterEntry.set("aftercollaborative", (Object)this.getBooleanValue(dataMap, "aftercollaborativesfc"));
                afterEntry.set("afterismilestoneprocess", (Object)this.getBooleanValue(dataMap, "afterismilestonesfc"));
            }
        } else {
            afterEntry.set("afterorderbillno", (Object)this.getStringValue(dataMap, "orderbillno"));
            afterEntry.set("afterorderid", (Object)this.getLongValue(dataMap, "orderid"));
            afterEntry.set("afterorderentryid", (Object)this.getLongValue(dataMap, "orderentryid"));
            afterEntry.set("afterorderqty", (Object)this.getBigDecimalValue(dataMap, "orderqty"));
            afterEntry.set("afterstockid", (Object)this.getLongValue(dataMap, "stockid"));
            afterEntry.set("afterstockentryid", (Object)this.getLongValue(dataMap, "stockentryid"));
            afterEntry.set("aftermaterialid", (Object)this.getLongValue(dataMap, "materialmasterid"));
            afterEntry.set("aftermaterial", (Object)this.getLongValue(dataMap, "material"));
            afterEntry.set("afterunit", (Object)this.getLongValue(dataMap, "unit"));
            afterEntry.set("afterworkcenter", (Object)this.getLongValue(dataMap, "bomworkcenter"));
            afterEntry.set("afterworkstation", (Object)this.getLongValue(dataMap, "bomchildversion"));
            afterEntry.set("afterconfiguredcode", (Object)this.getLongValue(dataMap, "configuredcode"));
            afterEntry.set("afterauxproperties", (Object)this.getLongValue(dataMap, "auxproperties"));
            afterEntry.set("afterbomversion", (Object)this.getLongValue(dataMap, "bomchildversion"));
            afterEntry.set("afterbomentryid", (Object)this.getLongValue(dataMap, "bomentryid"));
            afterEntry.set("afterstockseq", (Object)this.getIntValue(dataMap, "stockseq"));
            afterEntry.set("afterstockno", (Object)this.getStringValue(dataMap, "stockno"));
            afterEntry.set("aftertransactiontype", (Object)this.getLongValue(dataMap, "transactiontype"));
            afterEntry.set("afterparentmaterial", (Object)this.getLongValue(dataMap, "parentmaterial"));
            afterEntry.set("changetype", (Object)this.getStringValue(dataMap, "changetype"));
            afterEntry.set("afterqtynumerator", (Object)this.getBigDecimalValue(dataMap, "qtynumerator"));
            afterEntry.set("afterqtydenominator", (Object)this.getBigDecimalValue(dataMap, "qtydenominator"));
            afterEntry.set("afterdemandqty", (Object)this.getBigDecimalValue(dataMap, "demandqty"));
            afterEntry.set("afterfixscrap", (Object)this.getBigDecimalValue(dataMap, "fixscrap"));
            afterEntry.set("afterscraprate", (Object)this.getBigDecimalValue(dataMap, "scraprate"));
            if (!PlatformUtils.isNullLong((Long)this.getLongValue(dataMap, "parentstockentryid"))) {
                afterEntry.set("updatetype", (Object)"B");
            }
            afterEntry.set("samebatchid", (Object)this.getLongValue(dataMap, "samebatchid"));
            afterEntry.set("afterqtytype", (Object)this.getStringValue(dataMap, "entryqtytype"));
            afterEntry.set("afterisjumplevel", (Object)this.getBooleanValue(dataMap, "isjumplevel"));
            afterEntry.set("afterchildbom", (Object)this.getLongValue(dataMap, "childbomid"));
            afterEntry.set("afterreplaceplan", (Object)this.getLongValue(dataMap, "afterreplaceplan"));
            afterEntry.set("afterisreplaceplanmm", (Object)this.getBooleanValue(dataMap, "afterisreplaceplanmm"));
            afterEntry.set("afterreppriority", (Object)this.getIntValue(dataMap, "afterreppriority"));
            afterEntry.set("parentstockentryid", (Object)this.getLongValue(dataMap, "pstockentryid"));
            afterEntry.set("changeremark", (Object)this.getStringValue(dataMap, "remark"));
        }
        afterEntry.set("updateresult", (Object)"A");
        afterEntry.set("updatetime", null);
        afterEntry.set("errorreason", (Object)"");
        afterEntry.set("updatetype", (Object)"A");
        afterEntry.set("nextbillno", (Object)"");
        afterEntry.set("nextbillid", (Object)0L);
        afterEntry.set("nextbillentityname", (Object)"");
        afterEntry.set("isuntransmit", (Object)(!isTransmit ? 1 : 0));
        return afterEntry;
    }

    private boolean isTransmit(DynamicObject orderStatus, DynamicObject filter) {
        String untransmitrange = filter.getString("untransmitrange");
        if ("A".equals(untransmitrange)) {
            String planStatus = orderStatus.getString("planstatus");
            return "C".equals(planStatus);
        }
        if ("B".equals(untransmitrange)) {
            String billStatus = orderStatus.getString("billstatus");
            return "C".equals(billStatus);
        }
        return true;
    }

    private Map<Object, DynamicObject> getEcoFilterData(Set<Long> filterIdSet) {
        return BusinessDataServiceHelper.loadFromCache((String)"pdm_ecorequirefilter", (String)"untransmitrange", (QFilter[])new QFilter[]{new QFilter("id", "in", filterIdSet)});
    }

    private DynamicObject buildNewAfterEntry(DynamicObject entry) {
        DynamicObjectCollection coll = entry.getDynamicObjectCollection("subentryentityafter");
        return coll.addNew();
    }

    public OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        option.setVariableValue("batchop_batchsize", "50");
        option.setVariableValue("needlog", String.valueOf(true));
        return option;
    }

    private Long getLongValue(Map<String, Object> data, String field) {
        return PlatformUtils.getLongValue(data, (String)field);
    }

    private int getIntValue(Map<String, Object> data, String field) {
        return PlatformUtils.getIntValue(data, (String)field);
    }

    private BigDecimal getBigDecimalValue(Map<String, Object> data, String field) {
        return PlatformUtils.getBigDecimalValue(data, (String)field);
    }

    private String getStringValue(Map<String, Object> data, String field) {
        return PlatformUtils.getStringValue(data, (String)field);
    }

    private boolean getBooleanValue(Map<String, Object> data, String field) {
        return PlatformUtils.getBooleanValue(data, (String)field);
    }

    private Map<Object, DynamicObject> getMasterIdByMftId(Set<Long> mftIdSet) {
        return BusinessDataServiceHelper.loadFromCache((String)"bd_materialmftinfo", (String)"masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", mftIdSet)});
    }

    public DataSet getPomMftStockDataSet(QFilter qFilter) {
        long startTime = System.currentTimeMillis();
        String selectProperties = GetEcoEffectOrderBusiness.getStockSelectProperties("pom_mftstock", null);
        DataSet pomMftStockDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoxKeyString("getPomMftStockDataSet"), (String)"pom_mftstock", (String)selectProperties, (QFilter[])new QFilter[]{qFilter}, (String)"id");
        pomMftStockDataSet = pomMftStockDataSet.addField("'A'", "ordertype");
        long enddate = System.currentTimeMillis() - startTime;
        log.info("getPomMftStockDataSet,cost:" + enddate + "ms,qFilter=" + qFilter.toString());
        return pomMftStockDataSet;
    }

    public DataSet getSfcManftechDataSet(QFilter qFilter) {
        long startTime = System.currentTimeMillis();
        String selectProperties = GetEcoEffectManuftechBusiness.getTechSelectProperties("sfc_manftech", null);
        DataSet sfcManftechDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoxKeyString("getSfcManftechDataSet"), (String)"sfc_manftech", (String)selectProperties, (QFilter[])new QFilter[]{qFilter}, (String)"id");
        sfcManftechDataSet = sfcManftechDataSet.addField("'A'", "ordertype");
        long enddate = System.currentTimeMillis() - startTime;
        log.info("getSfcManftechDataSet,cost:" + enddate + "ms,qFilter=" + qFilter.toString());
        return sfcManftechDataSet;
    }

    private DataSet getOmMftStockDataSet(QFilter qFilter) {
        long startTime = System.currentTimeMillis();
        String selectProperties = GetEcoEffectOrderBusiness.getStockSelectProperties("om_mftstock", null);
        DataSet omMftstockDataSet = QueryServiceHelper.queryDataSet((String)this.getAlgoxKeyString("getOmMftStockDataSet"), (String)"om_mftstock", (String)selectProperties, (QFilter[])new QFilter[]{qFilter}, (String)"id");
        omMftstockDataSet = omMftstockDataSet.addField("'B'", "ordertype");
        long enddate = System.currentTimeMillis() - startTime;
        log.info("getOmMftStockDataSet,cost:" + enddate + "ms,qFilter=" + qFilter.toString());
        return omMftstockDataSet;
    }

    public String getAlgoxKeyString(String paramString) {
        return AddEffectOrderBillBusiness.class.getName() + "_" + paramString;
    }
}

