/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.fmm.business.bom.BomSyncCostUtils;
import kd.mmc.pdm.business.ecoplatform.ECNUpdateRouteBusiness;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.business.ecoplatform.ext.ECNUpdateBomExtPlugin;
import kd.mmc.pdm.business.ecoplatform.ext.IECNUpdateBomExt;
import kd.mmc.pdm.business.ecoplatform.service.AbstractECNUpdateService;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.bom.ecoroute.EcoCommonHelper;
import kd.mmc.pdm.common.util.BOMVersionUtil;

public class ECNUpdateBomBusiness
extends AbstractECNUpdateService {
    private static final Log log = LogFactory.getLog(ECNUpdateRouteBusiness.class);
    public static final String EXT_PLGUIN_NUMBER = "PDM_ECN_UPDATEBOM_EXT";
    private static ECNUpdateBomBusiness impl;

    public static ECNUpdateBomBusiness getInstance() {
        if (impl == null) {
            impl = new ECNUpdateBomBusiness();
        }
        return impl;
    }

    @Override
    public String execUpdate(DynamicObject ecnBill) {
        DynamicObjectCollection pentryColl = ecnBill.getDynamicObjectCollection("pentry");
        int psize = pentryColl.size();
        HashSet<Long> ecoBomIdSet = new HashSet<Long>(16);
        HashSet<Long> bomIdSet = new HashSet<Long>(16);
        for (int i = 0; i < psize; ++i) {
            DynamicObject pentry = (DynamicObject)pentryColl.get(i);
            String chkMsg = this.checkData(ecnBill, pentry);
            if (!StringUtils.isEmpty((String)chkMsg)) {
                throw new KDBizException(new ErrorCode("checkDataError", chkMsg), new Object[0]);
            }
            Long ecnBomid = pentry.getLong("ecobomid");
            ecoBomIdSet.add(ecnBomid);
            DynamicObject pentryBom = pentry.getDynamicObject("pentrybom");
            Long bomId = pentryBom == null ? 0L : pentryBom.getLong("id");
            if (PlatformUtils.isNullLong((Long)bomId)) continue;
            bomIdSet.add(bomId);
        }
        Map<Long, DynamicObject> ecoBomMap = this.queryDynamicObjectMap(ecoBomIdSet, "pdm_ecobom");
        Map<Long, DynamicObject> bomMap = this.queryDynamicObjectMap(bomIdSet, "pdm_mftbom");
        ArrayList updateBomList = new ArrayList(16);
        ArrayList<DynamicObject> addBomList = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < psize; ++i) {
            String bomNumber;
            DynamicObject bom;
            DynamicObject pentry = (DynamicObject)pentryColl.get(i);
            DynamicObject pentryBom = pentry.getDynamicObject("pentrybom");
            String entryversioncontrol = pentry.getString("entryversioncontrol");
            Long ecoBomId = pentry.getLong("ecobomid");
            DynamicObject newVersion = pentry.getDynamicObject("pentrynewversion");
            DynamicObject ecoBom = ecoBomMap.get(ecoBomId);
            if (ecoBom == null) continue;
            DynamicObjectCollection ecoBomEntryColl = ecoBom.getDynamicObjectCollection("entry");
            DynamicObjectCollection ecoBomCopEntryColl = ecoBom.getDynamicObjectCollection("copentry");
            if (PlatformUtils.isNullCollection((DynamicObjectCollection)ecoBomEntryColl) && PlatformUtils.isNullCollection((DynamicObjectCollection)ecoBomCopEntryColl)) continue;
            for (DynamicObject ecoBomEntry : ecoBomEntryColl) {
                if (this.isAddMode(ecoBomEntry, "entrymode") || this.isChangeAfterMode(ecoBomEntry, "entrymode")) {
                    if ("A".equals(entryversioncontrol) || "B".equals(entryversioncontrol)) {
                        bom = bomMap.get((Long)pentryBom.getPkValue());
                        this.addMftBomEntry(bom, ecnBill, ecoBom, ecoBomEntry);
                        if ("B".equals(entryversioncontrol)) {
                            bom.set("version", (Object)newVersion);
                            bom.set("id", ecoBom.getPkValue());
                            bomNumber = bom.getString("number");
                            if (StringUtils.isEmpty((String)bomNumber)) {
                                bom.set("number", (Object)(ecoBom.getPkValue() + ""));
                            }
                            PlatformUtils.addList(addBomList, (DynamicObject)bom);
                            continue;
                        }
                        PlatformUtils.addList(updateBomList, (DynamicObject)bom);
                        continue;
                    }
                    if (!this.isAddMode(ecoBomEntry, "entrymode")) continue;
                    bom = this.findFromList(addBomList, (Long)ecoBom.getPkValue());
                    if (bom == null) {
                        bom = this.addBomHead(ecnBill, pentry, ecoBom);
                    }
                    this.addMftBomEntry(bom, ecnBill, ecoBom, ecoBomEntry);
                    PlatformUtils.addList(addBomList, (DynamicObject)bom);
                    continue;
                }
                if (this.isDisableMode(ecoBomEntry, "entrymode")) {
                    bom = bomMap.get(pentryBom.getPkValue());
                    this.disableBomEntry(bom, ecnBill, ecoBom, ecoBomEntry);
                    if ("B".equals(entryversioncontrol)) {
                        bom.set("version", (Object)newVersion);
                        bom.set("id", ecoBom.getPkValue());
                        String rtNumber = bom.getString("number");
                        if (StringUtils.isEmpty((String)rtNumber)) {
                            bom.set("number", (Object)(ecoBom.getPkValue() + ""));
                        }
                        PlatformUtils.addList(addBomList, (DynamicObject)bom);
                        continue;
                    }
                    PlatformUtils.addList(updateBomList, (DynamicObject)bom);
                    continue;
                }
                ecoBomEntry.set("bomentry", ecoBomEntry.get("entrybomentryid"));
            }
            for (DynamicObject ecoBomCopEntry : ecoBomCopEntryColl) {
                if (this.isAddMode(ecoBomCopEntry, "copentrymode") || this.isChangeAfterMode(ecoBomCopEntry, "copentrymode")) {
                    if ("A".equals(entryversioncontrol) || "B".equals(entryversioncontrol)) {
                        bom = bomMap.get((Long)pentryBom.getPkValue());
                        this.addMftBomCopEntry(bom, ecnBill, ecoBom, ecoBomCopEntry);
                        if ("B".equals(entryversioncontrol)) {
                            bom.set("version", (Object)newVersion);
                            bom.set("id", ecoBom.getPkValue());
                            bomNumber = bom.getString("number");
                            if (StringUtils.isEmpty((String)bomNumber)) {
                                bom.set("number", (Object)(ecoBom.getPkValue() + ""));
                            }
                            PlatformUtils.addList(addBomList, (DynamicObject)bom);
                            continue;
                        }
                        PlatformUtils.addList(updateBomList, (DynamicObject)bom);
                        continue;
                    }
                    if (!this.isAddMode(ecoBomCopEntry, "copentrymode")) continue;
                    bom = this.findFromList(addBomList, (Long)ecoBom.getPkValue());
                    if (bom == null) {
                        bom = this.addBomHead(ecnBill, pentry, ecoBom);
                    }
                    this.addMftBomCopEntry(bom, ecnBill, ecoBom, ecoBomCopEntry);
                    PlatformUtils.addList(addBomList, (DynamicObject)bom);
                    continue;
                }
                if (this.isDisableMode(ecoBomCopEntry, "copentrymode")) {
                    bom = bomMap.get(pentryBom.getPkValue());
                    this.disableBomCopEntry(bom, ecnBill, ecoBom, ecoBomCopEntry);
                    if ("B".equals(entryversioncontrol)) {
                        bom.set("version", (Object)newVersion);
                        bom.set("id", ecoBom.getPkValue());
                        bomNumber = bom.getString("number");
                        if (StringUtils.isEmpty((String)bomNumber)) {
                            bom.set("number", (Object)(ecoBom.getPkValue() + ""));
                        }
                        PlatformUtils.addList(addBomList, (DynamicObject)bom);
                        continue;
                    }
                    PlatformUtils.addList(updateBomList, (DynamicObject)bom);
                    continue;
                }
                ecoBomCopEntry.set("newcopentryid", ecoBomCopEntry.get("oldcopentryid"));
            }
        }
        PluginProxy<IECNUpdateBomExt> extPlugin = this.genExtPluginxy();
        boolean isUpdateEcnBill = Boolean.FALSE;
        if (!PlatformUtils.isNullList(addBomList)) {
            int addSize = addBomList.size();
            long[] addIds = ORM.create().genLongIds("pdm_mftbom", addSize);
            DynamicObject bomA = (DynamicObject)addBomList.get(0);
            String orgId = String.valueOf(bomA.getDynamicObject("createorg").getPkValue());
            String[] newNumbers = CodeRuleServiceHelper.getBatchNumber((String)"pdm_mftbom", (DynamicObject)bomA, (String)orgId, (int)addSize);
            ArrayList<DynamicObject> newAddBomList = new ArrayList<DynamicObject>(addSize);
            long userId = RequestContext.get().getCurrUserId();
            Date currentDate = new Date();
            for (int i = 0; i < addSize; ++i) {
                Object addEntry2;
                DynamicObject addBom = (DynamicObject)addBomList.get(i);
                Long ecoBomId = addBom.getLong("id");
                String oldNumber = addBom.getString("number");
                boolean isInitVersion = Boolean.TRUE;
                if (!StringUtils.isEmpty((String)oldNumber)) {
                    Map<String, Long> cacheOldEntryIdMap = this.cacheOldEntryIdMap(addBom);
                    addBom = (DynamicObject)OrmUtils.clone((Object)addBom, (IDataEntityType)addBom.getDataEntityType(), (boolean)false, (boolean)true);
                    isInitVersion = Boolean.FALSE;
                    this.setPrimaryKey(addBom);
                    DynamicObject ecoBom = ecoBomMap.get(ecoBomId);
                    this.reSetNewEntryIdByRef(ecoBom, cacheOldEntryIdMap, addBom);
                }
                Long newBomid = addIds[i];
                String newNumber = this.getNewNumber(newNumbers, i, newBomid, "ECN_");
                addBom.set("id", (Object)newBomid);
                addBom.set("masterid", (Object)newBomid);
                addBom.set("number", (Object)newNumber);
                addBom.set("enable", (Object)"1");
                addBom.set("status", (Object)"A");
                addBom.set("creator", (Object)userId);
                addBom.set("modifier", (Object)userId);
                addBom.set("auditor", (Object)userId);
                addBom.set("createtime", (Object)currentDate);
                addBom.set("modifytime", (Object)currentDate);
                addBom.set("ctrlstrategy", (Object)this.getDefaultCt("pdm_mftbom", orgId));
                DynamicObjectCollection addColl = addBom.getDynamicObjectCollection("entry");
                for (Object addEntry2 : addColl) {
                    addEntry2.set("entryecnid", ecnBill.getPkValue());
                    addEntry2.set("entryecnno", (Object)ecnBill.getString("billno"));
                }
                DynamicObjectCollection addCopColl = addBom.getDynamicObjectCollection("copentry");
                addEntry2 = addCopColl.iterator();
                while (addEntry2.hasNext()) {
                    DynamicObject addEntry3 = (DynamicObject)addEntry2.next();
                    addEntry3.set("copentryecnno", (Object)ecnBill.getString("billno"));
                }
                this.reSetReplaceGroup(addBom);
                this.setIsCoprouct(addBom);
                newAddBomList.add(addBom);
                if (isInitVersion) {
                    DynamicObject ecoBom = ecoBomMap.get(ecoBomId);
                    ecoBom.set("bomid", (Object)newBomid);
                    ecoBom.set("number", (Object)newNumber);
                    for (int j = 0; j < psize; ++j) {
                        DynamicObject pentry = (DynamicObject)pentryColl.get(j);
                        Long ecnBomid = pentry.getLong("ecobomid");
                        if (!ecnBomid.equals(ecoBom.getLong("id"))) continue;
                        pentry.set("pentrybom", (Object)addBom);
                        isUpdateEcnBill = Boolean.TRUE;
                    }
                }
                this.checkBomReplaceData(ecnBill, addBom);
            }
            this.beforeSubmitByAddBom(ecnBill, newAddBomList, extPlugin);
            this.submitAndAuditBom(newAddBomList, ecnBill.getString("billno"));
            for (DynamicObject newBom : newAddBomList) {
                Long newPkId = newBom.getLong("id");
                for (Map.Entry<Long, DynamicObject> entrys : ecoBomMap.entrySet()) {
                    DynamicObject ecoBom = entrys.getValue();
                    if (!newPkId.equals(ecoBom.getLong("bomid"))) continue;
                    ecoBom.set("number", (Object)newBom.getString("number"));
                }
            }
            this.afterAuditByAddBom(ecnBill, newAddBomList, extPlugin);
        }
        if (!PlatformUtils.isNullList(updateBomList)) {
            long userId = RequestContext.get().getCurrUserId();
            Date currentDate = new Date();
            for (DynamicObject bom : updateBomList) {
                this.reSetSeq(bom);
                this.setIsCoprouct(bom);
                bom.set("modifier", (Object)userId);
                bom.set("modifytime", (Object)currentDate);
                this.checkBomReplaceData(ecnBill, bom);
            }
            DynamicObject[] updateDatas = updateBomList.toArray(new DynamicObject[updateBomList.size()]);
            this.beforeUpdateByEditBom(ecnBill, updateDatas, extPlugin);
            SaveServiceHelper.save((DynamicObject[])updateDatas);
            this.afterUpdateByEditBom(ecnBill, updateDatas, extPlugin);
            Long orgId = ecnBill.getDynamicObject("org").getLong("id");
            EcoUtils.refreshBaseDataCache("pdm_mftbom", orgId);
            BomSyncCostUtils.syncCost((DynamicObject[])updateDatas, (String)ecnBill.getString("billno"));
        }
        this.saveEcoDynamicObject(ecoBomMap);
        if (isUpdateEcnBill) {
            SaveServiceHelper.update((DynamicObject)ecnBill);
        }
        return "";
    }

    public void submitAndAuditBom(List<DynamicObject> addBomList, String ecnBillNo) {
        this.submitAndAuditData(addBomList, "pdm_mftbom", ecnBillNo);
    }

    private void reSetSeq(DynamicObject obj) {
        DynamicObjectCollection objCol = obj.getDynamicObjectCollection("entry");
        for (int i = 0; i < objCol.size(); ++i) {
            ((DynamicObject)objCol.get(i)).set("seq", (Object)(i + 1));
            ((DynamicObject)objCol.get(i)).set("entryseq", (Object)(i + 1));
        }
        DynamicObjectCollection objCopCol = obj.getDynamicObjectCollection("copentry");
        for (int i = 0; i < objCopCol.size(); ++i) {
            ((DynamicObject)objCopCol.get(i)).set("seq", (Object)(i + 1));
            ((DynamicObject)objCopCol.get(i)).set("copentryseq", (Object)(i + 1));
        }
    }

    private DynamicObject addBomHead(DynamicObject ecnBill, DynamicObject pentry, DynamicObject ecoBom) {
        DynamicObject newBom = BusinessDataServiceHelper.newDynamicObject((String)"pdm_mftbom");
        EcoCommonHelper.putHeadProperties((DynamicObject)ecoBom, (DynamicObject)newBom, this.getUnIncludeFieldSetC());
        newBom.set("id", ecoBom.getPkValue());
        newBom.set("number", (Object)"");
        if (newBom.getDynamicObject("version") == null) {
            newBom.set("version", pentry.get("pentrynewversion"));
        }
        return newBom;
    }

    private int findSeqIndex(DynamicObjectCollection coll, Long entryId) {
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = (DynamicObject)coll.get(i);
            Long currentId = 0L;
            if (entry.getPkValue() != null) {
                currentId = (Long)entry.getPkValue();
            }
            if (!currentId.equals(entryId)) continue;
            return i;
        }
        return -1;
    }

    private void addMftBomEntry(DynamicObject bom, DynamicObject ecnBill, DynamicObject ecoBom, DynamicObject ecoBomEntry) {
        DynamicObjectCollection bomEntryColl = bom.getDynamicObjectCollection("entry");
        Set<String> unUpdateFieldSet = this.getUnIncludeFieldSetB();
        boolean isChangeAfterMode = this.isChangeAfterMode(ecoBomEntry, "entrymode");
        DynamicObject changeBeforeEntry = null;
        DynamicObject addEntry = null;
        if (isChangeAfterMode) {
            Long oldBomEntryId = ecoBomEntry.getLong("entrybomentryid");
            changeBeforeEntry = this.getEntryById(bomEntryColl, oldBomEntryId);
            if (changeBeforeEntry == null) {
                String msg = String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\uff1a\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u4ef6\u5206\u5f55ID\u201c%2$s\u201d\uff0c\u5bf9\u5e94\u7684\u7ec4\u4ef6\u7f16\u7801\u4e3a\u201c%3$s\u201d\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"ECNUpdateBomBusiness_8", (String)"mmc-pdm-business", (Object[])new Object[0]), bom.getString("number"), oldBomEntryId, this.getMaterialMsg(ecoBomEntry));
                throw new KDBizException(new ErrorCode("validateBomEntryData", msg), new Object[0]);
            }
            int oldSeq = this.findSeqIndex(bomEntryColl, oldBomEntryId);
            if (oldSeq >= 0) {
                addEntry = (DynamicObject)OrmUtils.clone((Object)changeBeforeEntry, (IDataEntityType)changeBeforeEntry.getDataEntityType(), (boolean)false, (boolean)true);
                bomEntryColl.add(oldSeq + 1, addEntry);
            }
        }
        if (addEntry == null) {
            addEntry = bomEntryColl.addNew();
        }
        EcoCommonHelper.putAllProperties((DynamicObject)ecoBomEntry, (DynamicObject)addEntry, unUpdateFieldSet);
        Long id = ORM.create().genLongId("pdm_mftbom.entry");
        addEntry.set("id", (Object)id);
        ecoBomEntry.set("bomentry", (Object)id);
        Date acttime = ecoBomEntry.getDate("acttime");
        addEntry.set("entryvaliddate", (Object)acttime);
        addEntry.set("entryecnid", ecnBill.getPkValue());
        addEntry.set("entryecnno", (Object)ecnBill.getString("billno"));
        this.validateBomEntryDate(bom, addEntry);
        if (isChangeAfterMode && changeBeforeEntry != null) {
            changeBeforeEntry.set("entryinvaliddate", (Object)PlatformUtils.addSecond((Date)acttime, (int)-1));
            changeBeforeEntry.set("entryecnid", ecnBill.getPkValue());
            changeBeforeEntry.set("entryecnno", (Object)ecnBill.getString("billno"));
            this.validateBomEntryDate(bom, changeBeforeEntry);
        }
    }

    private void disableBomEntry(DynamicObject bom, DynamicObject ecnBill, DynamicObject ecoBom, DynamicObject ecoBomEntry) {
        Long oldBomEntryId;
        DynamicObjectCollection mftBomEntryColl = bom.getDynamicObjectCollection("entry");
        DynamicObject disableEntry = this.getEntryById(mftBomEntryColl, oldBomEntryId = Long.valueOf(ecoBomEntry.getLong("entrybomentryid")));
        if (disableEntry == null) {
            String msg = String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\uff1a\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u4ef6\u5206\u5f55ID\u201c%2$s\u201d\uff0c\u5bf9\u5e94\u7684\u7ec4\u4ef6\u7f16\u7801\u4e3a\u201c%3$s\u201d\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"ECNUpdateBomBusiness_8", (String)"mmc-pdm-business", (Object[])new Object[0]), bom.getString("number"), oldBomEntryId, this.getMaterialMsg(ecoBomEntry));
            throw new KDBizException(new ErrorCode("validateBomEntryData", msg), new Object[0]);
        }
        Date acttime = ecoBomEntry.getDate("acttime");
        disableEntry.set("entryinvaliddate", (Object)PlatformUtils.addSecond((Date)acttime, (int)-1));
        disableEntry.set("entryecnid", ecnBill.getPkValue());
        disableEntry.set("entryecnno", (Object)ecnBill.getString("billno"));
        ecoBomEntry.set("bomentry", disableEntry.getPkValue());
        this.validateBomEntryDate(bom, disableEntry);
    }

    private String getMaterialMsg(DynamicObject ecoBomEntry) {
        DynamicObject material = ecoBomEntry.getDynamicObject("entrymaterialid");
        DynamicObject featureType = ecoBomEntry.getDynamicObject("featuretype");
        return material != null ? material.getString("number") : (featureType != null ? featureType.getString("number") : "");
    }

    private String getCopMaterialMsg(DynamicObject ecoBomCopEntry) {
        DynamicObject material = ecoBomCopEntry.getDynamicObject("copentrymaterialid");
        return material != null ? material.getString("number") : "";
    }

    private void addMftBomCopEntry(DynamicObject bom, DynamicObject ecnBill, DynamicObject ecoBom, DynamicObject ecoBomCopEntry) {
        DynamicObjectCollection bomCopEntryColl = bom.getDynamicObjectCollection("copentry");
        Set<String> unUpdateFieldSet = this.getUnIncludeFieldSetA();
        boolean isChangeAfterMode = this.isChangeAfterMode(ecoBomCopEntry, "copentrymode");
        DynamicObject changeBeforeEntry = null;
        DynamicObject addEntry = null;
        if (isChangeAfterMode) {
            Long oldBomCopEntryId = ecoBomCopEntry.getLong("oldcopentryid");
            changeBeforeEntry = this.getEntryById(bomCopEntryColl, oldBomCopEntryId);
            if (changeBeforeEntry == null) {
                String msg = String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\uff1a\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u8054\u526f\u4ea7\u54c1\u5206\u5f55ID\u201c%2$s\u201d\uff0c\u5bf9\u5e94\u7684\u8054\u526f\u4ea7\u54c1\u7f16\u7801\u4e3a\u201c%3$s\u201d\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"ECNUpdateBomBusiness_9", (String)"mmc-pdm-business", (Object[])new Object[0]), bom.getString("number"), oldBomCopEntryId, this.getCopMaterialMsg(ecoBomCopEntry));
                throw new KDBizException(new ErrorCode("validateBomEntryData", msg), new Object[0]);
            }
            int oldSeq = this.findSeqIndex(bomCopEntryColl, oldBomCopEntryId);
            if (oldSeq >= 0) {
                addEntry = (DynamicObject)OrmUtils.clone((Object)changeBeforeEntry, (IDataEntityType)changeBeforeEntry.getDataEntityType(), (boolean)false, (boolean)true);
                bomCopEntryColl.add(oldSeq + 1, addEntry);
            }
        }
        if (addEntry == null) {
            addEntry = bomCopEntryColl.addNew();
        }
        EcoCommonHelper.putAllProperties((DynamicObject)ecoBomCopEntry, (DynamicObject)addEntry, unUpdateFieldSet);
        Long id = ORM.create().genLongId("pdm_mftbom.copentry");
        addEntry.set("id", (Object)id);
        ecoBomCopEntry.set("newcopentryid", (Object)id);
        Date acttime = ecoBomCopEntry.getDate("copacttime");
        addEntry.set("copentryvaliddate", (Object)acttime);
        addEntry.set("copentryecnno", (Object)ecnBill.getString("billno"));
        this.validateBomCopEntryDate(bom, addEntry);
        if (isChangeAfterMode && changeBeforeEntry != null) {
            changeBeforeEntry.set("copentryinvaliddate", (Object)PlatformUtils.addSecond((Date)acttime, (int)-1));
            changeBeforeEntry.set("copentryecnno", (Object)ecnBill.getString("billno"));
            this.validateBomCopEntryDate(bom, changeBeforeEntry);
        }
    }

    private void disableBomCopEntry(DynamicObject bom, DynamicObject ecnBill, DynamicObject ecoBom, DynamicObject ecoBomCopEntry) {
        Long oldBomCopEntryId;
        DynamicObjectCollection mftBomCopEntryColl = bom.getDynamicObjectCollection("copentry");
        DynamicObject disableEntry = this.getEntryById(mftBomCopEntryColl, oldBomCopEntryId = Long.valueOf(ecoBomCopEntry.getLong("oldcopentryid")));
        if (disableEntry == null) {
            String msg = String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\uff1a\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u8054\u526f\u4ea7\u54c1\u5206\u5f55ID\u201c%2$s\u201d\uff0c\u5bf9\u5e94\u7684\u8054\u526f\u4ea7\u54c1\u7f16\u7801\u4e3a\u201c%3$s\u201d\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"ECNUpdateBomBusiness_9", (String)"mmc-pdm-business", (Object[])new Object[0]), bom.getString("number"), oldBomCopEntryId, this.getCopMaterialMsg(ecoBomCopEntry));
            throw new KDBizException(new ErrorCode("validateBomEntryData", msg), new Object[0]);
        }
        Date acttime = ecoBomCopEntry.getDate("copacttime");
        disableEntry.set("copentryinvaliddate", (Object)PlatformUtils.addSecond((Date)acttime, (int)-1));
        disableEntry.set("copentryecnno", (Object)ecnBill.getString("billno"));
        ecoBomCopEntry.set("newcopentryid", disableEntry.getPkValue());
        this.validateBomCopEntryDate(bom, disableEntry);
    }

    private void validateBomEntryDate(DynamicObject bom, DynamicObject bomEntry) {
        Date inValideDate;
        Date valideDate = bomEntry.getDate("entryvaliddate");
        if (valideDate.compareTo(inValideDate = bomEntry.getDate("entryinvaliddate")) > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String msg = String.format(ResManager.loadKDString((String)"BOM[%1$s]:\u7b2c[%2$s]\u884c\u7ec4\u4ef6\u5206\u5f55\u7684\u751f\u6548\u65e5\u671f[%3$s]\u5927\u4e8e\u5931\u6548\u65e5\u671f[%4$s]\u3002", (String)"ECNUpdateBomBusiness_5", (String)"mmc-pdm-business", (Object[])new Object[0]), bom.getString("number"), bomEntry.getString("seq"), sdf.format(valideDate), sdf.format(inValideDate));
            throw new KDBizException(new ErrorCode("validateBomEntryDate", msg), new Object[0]);
        }
    }

    private void validateBomCopEntryDate(DynamicObject bom, DynamicObject bomCopEntry) {
        Date inValideDate;
        Date valideDate = bomCopEntry.getDate("copentryvaliddate");
        if (valideDate.compareTo(inValideDate = bomCopEntry.getDate("copentryinvaliddate")) > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String msg = String.format(ResManager.loadKDString((String)"BOM[%1$s]:\u7b2c[%2$s]\u884c\u8054\u526f\u4ea7\u54c1\u5206\u5f55\u7684\u751f\u6548\u65e5\u671f[%3$s]\u5927\u4e8e\u5931\u6548\u65e5\u671f[%4$s]\u3002", (String)"ECNUpdateBomBusiness_6", (String)"mmc-pdm-business", (Object[])new Object[0]), bom.getString("number"), bomCopEntry.getString("seq"), sdf.format(valideDate), sdf.format(inValideDate));
            throw new KDBizException(new ErrorCode("validateBomEntryDate", msg), new Object[0]);
        }
    }

    private Set<String> getUnIncludeFieldSetB() {
        HashSet<String> fieldSet = new HashSet<String>(16);
        fieldSet.add("id");
        fieldSet.add("seq");
        fieldSet.add("entryecnno");
        fieldSet.add("entryecnid");
        fieldSet.add("entrybomentryid");
        fieldSet.add("bomentry");
        fieldSet.add("entrymode");
        fieldSet.add("acttime");
        fieldSet.add("minacttime");
        fieldSet.add("estimatestatus");
        fieldSet.add("esremark");
        fieldSet.add("groupkey");
        fieldSet.add("refkey");
        fieldSet.add("usedqty");
        fieldSet.add("iscanestimate");
        fieldSet.add("continuouspoint");
        fieldSet.add("entrygroupno");
        fieldSet.add("entryrefno");
        fieldSet.add("hasbom");
        return fieldSet;
    }

    private Set<String> getUnIncludeFieldSetA() {
        HashSet<String> fieldSet = new HashSet<String>(16);
        fieldSet.add("id");
        fieldSet.add("seq");
        fieldSet.add("copentryecnno");
        fieldSet.add("copentrymode");
        fieldSet.add("oldcopentryid");
        fieldSet.add("newcopentryid");
        fieldSet.add("copacttime");
        fieldSet.add("copestimatestatus");
        fieldSet.add("copesremark");
        return fieldSet;
    }

    private Set<String> getUnIncludeFieldSetC() {
        HashSet<String> fieldSet = new HashSet<String>(16);
        fieldSet.add("id");
        fieldSet.add("masterid");
        fieldSet.add("number");
        fieldSet.add("pentryvaliddate");
        fieldSet.add("productno");
        fieldSet.add("bomid");
        fieldSet.add("sourcedata");
        fieldSet.add("bitindex");
        fieldSet.add("srcindex");
        return fieldSet;
    }

    private String checkData(DynamicObject ecnBill, DynamicObject pentry) {
        DynamicObject pentryBom = pentry.getDynamicObject("pentrybom");
        String entryversioncontrol = pentry.getString("entryversioncontrol");
        DynamicObject materialMaster = pentry.getDynamicObject("proentrymaterialid");
        int seq = pentry.getInt("seq");
        String billno = ecnBill.getString("billno");
        if (!"A".equals(ecnBill.getString("changetype"))) {
            return String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355%1$s\u7684\u53d8\u66f4\u5bf9\u8c61\u4e0d\u4e3aBOM\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u53d8\u66f4\u64cd\u4f5c\u3002", (String)"ECNUpdateBomBusiness_1", (String)"mmc-pdm-business", (Object[])new Object[0]), billno, seq + 1);
        }
        if ("D".equals(entryversioncontrol) && materialMaster == null) {
            return String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355%1$s\u7684\u7b2c%2$s\u884c\u4ea7\u54c1\u5206\u5f55\u6570\u636e\u4e2d\uff0c\u521d\u59cb\u7248\u672c\u4f46\u672a\u5f55\u5165\u4ea7\u54c1\u7f16\u7801\u3002", (String)"ECNUpdateBomBusiness_2", (String)"mmc-pdm-business", (Object[])new Object[0]), billno, seq + 1);
        }
        if (("A".equals(entryversioncontrol) || "B".equals(entryversioncontrol)) && pentryBom == null) {
            return String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355%1$s\u7684\u7b2c%2$s\u884c\u4ea7\u54c1\u5206\u5f55\u6570\u636e\u4e2d\uff0c\u672a\u5f55\u5165BOM\u3002", (String)"ECNUpdateBomBusiness_3", (String)"mmc-pdm-business", (Object[])new Object[0]), billno, seq + 1);
        }
        if (pentry.getDynamicObject("pentrynewversion") == null && ("D".equals(entryversioncontrol) && BOMVersionUtil.isNeedVersion((boolean)true, (DynamicObject)ecnBill, (DynamicObject)pentry) || "B".equals(entryversioncontrol))) {
            return String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355%1$s\u7684\u7b2c%2$s\u884c\u4ea7\u54c1\u5206\u5f55\u6570\u636e\u4e2d\uff0c\u672a\u5f55\u5165\u65b0BOM\u7248\u672c\u3002", (String)"ECNUpdateBomBusiness_4", (String)"mmc-pdm-business", (Object[])new Object[0]), billno, seq + 1);
        }
        return "";
    }

    private void beforeSubmitByAddBom(DynamicObject ecnBill, List<DynamicObject> addBomList, PluginProxy<IECNUpdateBomExt> pluginProxy) {
        if (pluginProxy != null) {
            pluginProxy.callReplace(p -> {
                p.beforeSubmitByAddBom(ecnBill, addBomList);
                return null;
            });
        }
    }

    private void afterAuditByAddBom(DynamicObject ecnBill, List<DynamicObject> addBomList, PluginProxy<IECNUpdateBomExt> pluginProxy) {
        if (pluginProxy != null) {
            pluginProxy.callReplace(p -> {
                p.afterAuditByAddBom(ecnBill, addBomList);
                return null;
            });
        }
    }

    private void beforeUpdateByEditBom(DynamicObject ecnBill, DynamicObject[] editBoms, PluginProxy<IECNUpdateBomExt> pluginProxy) {
        if (pluginProxy != null) {
            pluginProxy.callReplace(p -> {
                p.beforeUpdateByEditBom(ecnBill, editBoms);
                return null;
            });
        }
    }

    private void afterUpdateByEditBom(DynamicObject ecnBill, DynamicObject[] editBoms, PluginProxy<IECNUpdateBomExt> pluginProxy) {
        if (pluginProxy != null) {
            pluginProxy.callReplace(p -> {
                p.afterUpdateByEditBom(ecnBill, editBoms);
                return null;
            });
        }
    }

    private String genReplaceGroup(DynamicObject bomEntry) {
        String seq = bomEntry.getString("seq");
        return ORM.create().genLongId("mpdm_replaceplan") + "_" + seq;
    }

    private void reSetReplaceGroup(DynamicObject bom) {
        DynamicObjectCollection entrys = bom.getDynamicObjectCollection("entry");
        HashMap<String, String> replaceGroupMap = new HashMap<String, String>(16);
        for (DynamicObject entry : entrys) {
            DynamicObject replacePlan;
            String oldReplaceGroup = entry.getString("entryreplacegroup");
            if (StringUtils.isEmpty((String)oldReplaceGroup) || (replacePlan = entry.getDynamicObject("entryreplaceplan")) == null) continue;
            String newReplaceGroup = (String)replaceGroupMap.get(oldReplaceGroup);
            if (StringUtils.isEmpty((String)newReplaceGroup)) {
                newReplaceGroup = this.genReplaceGroup(entry);
                replaceGroupMap.put(oldReplaceGroup, newReplaceGroup);
            }
            entry.set("entryreplacegroup", (Object)newReplaceGroup);
        }
    }

    private PluginProxy<IECNUpdateBomExt> genExtPluginxy() {
        ECNUpdateBomExtPlugin extPluginClass = new ECNUpdateBomExtPlugin();
        return PluginProxy.create((Object)extPluginClass, IECNUpdateBomExt.class, (String)EXT_PLGUIN_NUMBER, null);
    }

    private void checkBomReplaceData(DynamicObject ecnBill, DynamicObject bom) {
        DynamicObjectCollection entrys = bom.getDynamicObjectCollection("entry");
        HashMap repMaterialMap = new HashMap(16);
        for (DynamicObject entry : entrys) {
            DynamicObject material;
            String replaceGroupNo = entry.getString("entryreplacegroup");
            if (StringUtils.isEmpty((String)replaceGroupNo) || entry.get("entryreplaceplan") == null || (material = entry.getDynamicObject("entrymaterialid")) == null) continue;
            HashSet<Long> materialIdSet = (HashSet<Long>)repMaterialMap.get(replaceGroupNo);
            if (materialIdSet == null) {
                materialIdSet = new HashSet<Long>(16);
            }
            if (materialIdSet.add(material.getLong("id"))) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355[%1$s]\u5bf9\u5e94\u7684BOM[%2$s]\u7ec4\u4ef6\u5206\u5f55\u4e2d:\u5b58\u5728\u76f8\u540c\u66ff\u4ee3\u7ec4\u53f7\u4e14\u7ec4\u4ef6\u7f16\u7801[%3$s]\u4e00\u81f4\u7684\u66ff\u4ee3\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u3002", (String)"ECNUpdateBomBusiness_7", (String)"mmc-pdm-business", (Object[])new Object[0]), ecnBill.getString("billno"), bom.getString("number"), material.getString("number"));
            throw new KDBizException(new ErrorCode("checkBomReplaceData", msg), new Object[0]);
        }
    }

    private void setIsCoprouct(DynamicObject bom) {
        DynamicObjectCollection bomcopentry = bom.getDynamicObjectCollection("copentry");
        if (!bomcopentry.isEmpty()) {
            bom.set("iscoproduct", (Object)true);
        }
    }
}

