/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.fmm.business.bom.BomSyncCostUtils;
import kd.mmc.pdm.business.ecoplatform.ActTimeCopBean;
import kd.mmc.pdm.business.ecoplatform.ActTimeCopValidataBusiness;
import kd.mmc.pdm.business.ecoplatform.AddEcoLogUtils;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;

public class EcoCopUtils {
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    private static final Log log = LogFactory.getLog(EcoCopUtils.class);

    public static String getAduitEcnBill(Set<Long> mftBomCopEntryIdSet, Long currentECNId, String entryMode) {
        if (PlatformUtils.isNullSet(mftBomCopEntryIdSet)) {
            return null;
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" h.fid as fecnid ", new Object[0]);
        sb.append(",h.fbillno as fbillno ", new Object[0]);
        sb.append(" from t_fmm_ecobomcopentry a ", new Object[0]);
        sb.append(" inner join t_pdm_bomecopentry b on a.fid = b.fecobomid ", new Object[0]);
        sb.append(" inner join t_pdm_bom_eco h on h.fid = b.fid ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("a.foldcopentryid", mftBomCopEntryIdSet.toArray());
        sb.append(" and h.fbillstatus = 'C' ", new Object[0]);
        sb.append(" and b.fentryversioncontrol = 'A' ", new Object[0]);
        if ("E".equalsIgnoreCase(entryMode)) {
            sb.append(" and a.fentrymode = 'E' ", new Object[0]);
        } else if ("A".equalsIgnoreCase(entryMode)) {
            sb.append(" and a.fentrymode = 'A' ", new Object[0]);
        } else if ("B".equalsIgnoreCase(entryMode)) {
            sb.append(" and a.fentrymode = 'B' ", new Object[0]);
        } else {
            sb.append(" and a.fentrymode = 'C' ", new Object[0]);
        }
        String fbillno = "";
        try (DataSet ds = DB.queryDataSet((String)(EcoCopUtils.class.getName() + "_getAduitEcnBill"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                Long fecnid = row.getLong("fecnid");
                if (!PlatformUtils.isNullLong((Long)currentECNId) && currentECNId.equals(fecnid)) continue;
                fbillno = row.getString("fbillno");
            }
        }
        return fbillno;
    }

    public static String getMftBomCopEntrySelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("entryid ");
        sb.append(",copentryvaliddate ");
        sb.append(",copentryinvaliddate ");
        sb.append(",copentrytype ");
        sb.append(",copentrymaterial ");
        sb.append(",copentrymaterialid ");
        sb.append(",copentryqty ");
        sb.append(",bomid");
        sb.append(",entryseq");
        return sb.toString();
    }

    public static Map<Long, DynamicObject> getMftBomCopEntryData(Set<Long> mftBomCopEntryIdSet) {
        DynamicObject[] coll;
        if (mftBomCopEntryIdSet.isEmpty()) {
            return new HashMap<Long, DynamicObject>(16);
        }
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(mftBomCopEntryIdSet.size());
        QFilter filter = new QFilter("entryid", "in", mftBomCopEntryIdSet);
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = EcoCopUtils.getMftBomCopEntrySelectProperties();
        for (DynamicObject dy : coll = BusinessDataServiceHelper.load((String)"pdm_mftbomcopentry", (String)selectProperties, (QFilter[])qFilters)) {
            dataMap.put(dy.getLong("entryid"), dy);
        }
        return dataMap;
    }

    public static Set<Long> getEcoBomCopEntryById(Set<Long> ecoBomIdSet) {
        QFilter filter = new QFilter("ecobomid", "in", ecoBomIdSet);
        DynamicObject[] coll = BusinessDataServiceHelper.load((String)"pdm_ecobomcopentry_f7", (String)"entryid", (QFilter[])new QFilter[]{filter});
        HashSet<Long> ecoBomEntryIdSet = new HashSet<Long>(16);
        if (coll == null || coll.length < 1) {
            return ecoBomEntryIdSet;
        }
        for (int i = 0; i < coll.length; ++i) {
            ecoBomEntryIdSet.add(coll[i].getLong("entryid"));
        }
        return ecoBomEntryIdSet;
    }

    public static void updateStatusAndActTime(Set<Long> ecoBomIdSet, DynamicObject ecoBill) {
        if (PlatformUtils.isNullSet(ecoBomIdSet)) {
            return;
        }
        Set<Long> ecoBomCopEntryIdSet = EcoCopUtils.getEcoBomCopEntryById(ecoBomIdSet);
        if (!ecoBomCopEntryIdSet.isEmpty()) {
            EcoCopUtils.updateRefDataActtime(ecoBomCopEntryIdSet, "auditecn");
        }
    }

    public static String getEcoBomCopEntryDataSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append(" entryid ");
        sb.append(",copentrymode ");
        sb.append(",copentrymaterial ");
        sb.append(",copentrymaterialid ");
        sb.append(",copentryversion ");
        sb.append(",copentryunit ");
        sb.append(",copentrytype ");
        sb.append(",ecobomid ");
        sb.append(",copacttime ");
        sb.append(",entryseq ");
        sb.append(",copentryvaliddate ");
        sb.append(",copentryinvaliddate ");
        sb.append(",copentryqty ");
        sb.append(",estimatestatus ");
        sb.append(",esremark ");
        sb.append(",oldcopentryid ");
        sb.append(",newcopentryid ");
        return sb.toString();
    }

    public static DynamicObject[] getAllEcoBomCopEntryDynamicObject(Set<Long> ecoBomCopEntryIdSet) {
        QFilter filter = new QFilter("entryid", "in", ecoBomCopEntryIdSet);
        String selectProperties = EcoCopUtils.getEcoBomCopEntryDataSelectProperties();
        return BusinessDataServiceHelper.load((String)"pdm_ecobomcopentry_f7", (String)selectProperties, (QFilter[])new QFilter[]{filter});
    }

    public static Map<Long, DynamicObject> getKeyEcoBomCopEntry(Set<Long> ecoBomCopEntryIdSet, Map<Long, Set<Long>> cacheAllRefIdMap) {
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(ecoBomCopEntryIdSet.size());
        HashMap<Long, DynamicObject> allDataMap = new HashMap<Long, DynamicObject>(ecoBomCopEntryIdSet.size());
        for (Long ecoBomCopEntryId : ecoBomCopEntryIdSet) {
            DynamicObject keyDy = (DynamicObject)allDataMap.get(ecoBomCopEntryId);
            if (keyDy != null) {
                dataMap.put(ecoBomCopEntryId, keyDy);
                continue;
            }
            Set<Long> allIdSet = EcoCopUtils.getAllEcoBomCopEntryIdSet(ecoBomCopEntryId, cacheAllRefIdMap);
            if (PlatformUtils.isNullSet(allIdSet)) {
                allIdSet = new HashSet<Long>(16);
                allIdSet.add(ecoBomCopEntryId);
            }
            DynamicObject[] dycoll = EcoCopUtils.getAllEcoBomCopEntryDynamicObject(allIdSet);
            keyDy = EcoCopUtils.findKeyDynamicObject(dycoll);
            dataMap.put(ecoBomCopEntryId, keyDy);
            for (Long id : allIdSet) {
                allDataMap.put(id, keyDy);
            }
        }
        return dataMap;
    }

    public static DynamicObject findKeyDynamicObject(DynamicObject[] dycoll) {
        int size = dycoll.length;
        if (size == 1) {
            return dycoll[0];
        }
        DynamicObject keyDy = null;
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = dycoll[i];
            String entrymode = entry.getString("copentrymode");
            if (!"B".equals(entrymode)) continue;
            keyDy = entry;
            break;
        }
        if (keyDy == null) {
            keyDy = dycoll[0];
        }
        return keyDy;
    }

    public static Set<Long> getAllEcoBomCopEntryIdSet(Long ecoBomCopEntryId, Map<Long, Set<Long>> cacheAllRefIdMap) {
        Set<Long> allRefIdSet = null;
        if (cacheAllRefIdMap != null && (allRefIdSet = cacheAllRefIdMap.get(ecoBomCopEntryId)) != null) {
            return allRefIdSet;
        }
        HashSet<Long> ecoBomCopEntryIdSet = new HashSet<Long>(16);
        ecoBomCopEntryIdSet.add(ecoBomCopEntryId);
        allRefIdSet = EcoCopUtils.getAllEcoBomCopEntryIdSet(ecoBomCopEntryIdSet);
        if (cacheAllRefIdMap != null) {
            cacheAllRefIdMap.put(ecoBomCopEntryId, allRefIdSet);
        }
        return allRefIdSet;
    }

    public static DataSet genEcoBomDataByCopEntryId(Set<Long> ecoBomCopEntryIdSet) {
        String algoKey = EcoCopUtils.class.getName() + "_genEcoBomDataByCopEntryId";
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select a.fentryid as ecobomcopentryid ", new Object[0]);
        sb.append(" ,a.fid as ecobomid ", new Object[0]);
        sb.append(" ,b.fentryid as ecobomcopentryid2 ", new Object[0]);
        sb.append(" from t_fmm_ecobomcopentry a ", new Object[0]);
        sb.append(" left outer join t_fmm_ecobomcopentry b on a.fid = b.fid and a.foldcopentryid = b.foldcopentryid and a.fentryid <> b.fentryid and a.foldcopentryid > 0  ", new Object[0]);
        sb.append(" where ", new Object[0]);
        sb.appendIn("a.fentryid", ecoBomCopEntryIdSet.toArray());
        return DB.queryDataSet((String)algoKey, (DBRoute)scmDBRoute, (SqlBuilder)sb);
    }

    public static Set<Long> getAllEcoBomCopEntryIdSet(Set<Long> ecoBomCopEntryIdSet) {
        if (PlatformUtils.isNullSet(ecoBomCopEntryIdSet)) {
            return new HashSet<Long>(16);
        }
        HashSet<Long> allEcoBomCopEntryIdSet = new HashSet<Long>(64);
        try (DataSet ds = EcoCopUtils.genEcoBomDataByCopEntryId(ecoBomCopEntryIdSet);){
            while (ds.hasNext()) {
                Row arow = ds.next();
                Long ecobomCopEntryid = arow.getLong("ecobomcopentryid");
                Long ecobomCopEntryid2 = arow.getLong("ecobomcopentryid2");
                allEcoBomCopEntryIdSet.add(ecobomCopEntryid);
                if (PlatformUtils.isNullLong((Long)ecobomCopEntryid2)) continue;
                allEcoBomCopEntryIdSet.add(ecobomCopEntryid2);
            }
        }
        return allEcoBomCopEntryIdSet;
    }

    public static List<DynamicObject> updateRefDataActtime(Set<Long> ecoBomCopEntryIdSet, String fromType) {
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(16);
        String esremark1 = ResManager.loadKDString((String)"\u5b9e\u65bd\u65f6\u95f4\u6ee1\u8db3\u53d8\u66f4\u7c7b\u578b\u7684\u5904\u7406\u5929\u6570\u6761\u4ef6\uff0c\u8fd0\u7b97\u540e\u66f4\u65b0\u4e3a\u8bc4\u4f30\u5b8c\u6bd5\u3002", (String)"EcoCopUtils_1", (String)"mmc-pdm-business", (Object[])new Object[0]);
        String esremark2 = ResManager.loadKDString((String)"\u5b9e\u65bd\u65f6\u95f4\u4e0d\u6ee1\u8db3\u53d8\u66f4\u7c7b\u578b\u7684\u5904\u7406\u5929\u6570\u6761\u4ef6\uff0c\u8fd0\u7b97\u540e\u66f4\u65b0\u4e3a\u8bc4\u4f30\u4e2d\u3002", (String)"EcoCopUtils_2", (String)"mmc-pdm-business", (Object[])new Object[0]);
        String esremark3 = ResManager.loadKDString((String)"\u4f9d\u636e\u53d8\u66f4\u7c7b\u578b\u81ea\u52a8\u5b8c\u6210\u8bc4\u4f30\u3002", (String)"EcoCopUtils_3", (String)"mmc-pdm-business", (Object[])new Object[0]);
        HashSet<Long> execEndIdSet = new HashSet<Long>(16);
        Date currentDate = DateUtils.getEndOfDay((Date)new Date());
        HashMap<Long, Set<Long>> cacheAllRefIdMap = new HashMap<Long, Set<Long>>(16);
        Map<Long, DynamicObject> dataMap = EcoCopUtils.getKeyEcoBomCopEntry(ecoBomCopEntryIdSet, cacheAllRefIdMap);
        HashMap<Long, DynamicObject> ecoTypeMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> ecoBillMap = new HashMap<Long, DynamicObject>(16);
        ArrayList<DynamicObject> ecoRecordLogList = new ArrayList<DynamicObject>(16);
        HashMap<String, DynamicObject> ecoRecordLogMap = new HashMap<String, DynamicObject>(16);
        for (Map.Entry<Long, DynamicObject> entrys : dataMap.entrySet()) {
            Set<Long> allRefDataSet;
            DynamicObject keyDy = entrys.getValue();
            Long ecoBomEntryId = entrys.getKey();
            if (!execEndIdSet.add(ecoBomEntryId) || (allRefDataSet = EcoCopUtils.getAllEcoBomCopEntryIdSet(ecoBomEntryId, cacheAllRefIdMap)).isEmpty()) continue;
            DynamicObject[] refDyColl = EcoCopUtils.getAllEcoBomCopEntryDynamicObject(allRefDataSet);
            for (int i = 0; i < refDyColl.length; ++i) {
                String acttimevalidResult;
                String statustype;
                DynamicObject updateDy = refDyColl[i];
                Long ecoBomId = updateDy.getLong("ecobomid");
                DynamicObject ecoBill = EcoUtils.getEcoBillDynamicObject(ecoBomId, ecoBillMap);
                DynamicObject ecoType = EcoUtils.getEcoType(ecoBill, ecoBomId, ecoTypeMap);
                DynamicObject ecoPEntry = EcoUtils.getEcoPEntry(ecoBill, ecoBomId);
                Date oldActtime = updateDy.getDate("copacttime");
                String oldEstimateStatus = updateDy.getString("estimatestatus");
                boolean isAdjustActTime = EcoUtils.isAdjustActTime(ecoType);
                if (isAdjustActTime) {
                    updateDy.set("copacttime", keyDy.get("copacttime"));
                    if ("A".equals(updateDy.getString("copentrymode"))) {
                        updateDy.set("copentryvaliddate", keyDy.get("copacttime"));
                    }
                }
                Long currentEcoBomCopEntryId = updateDy.getLong("entryid");
                Date beforeDate = null;
                if (ecoType != null) {
                    int extendDay = ecoType.getInt("estimatestatusday");
                    beforeDate = PlatformUtils.addDay((Date)currentDate, (int)extendDay);
                }
                String string = statustype = ecoType == null ? "B" : ecoType.getString("statustype");
                if (beforeDate != null && "B".equals(statustype) && !"updatebom".equals(fromType) && ("auditecn".equals(fromType) || !"auditecn".equals(fromType))) {
                    if (updateDy.getDate("copacttime").before(beforeDate)) {
                        updateDy.set("estimatestatus", (Object)"C");
                        updateDy.set("esremark", (Object)esremark1);
                    } else if (!updateDy.getString("estimatestatus").equals("C")) {
                        updateDy.set("estimatestatus", (Object)"B");
                        updateDy.set("esremark", (Object)esremark2);
                    }
                }
                if ("A".equals(statustype)) {
                    updateDy.set("estimatestatus", (Object)"C");
                    updateDy.set("esremark", (Object)esremark3);
                }
                if ("auditecn".equals(fromType) && "B".equals(statustype)) {
                    updateDy.set("estimatestatus", (Object)"A");
                    updateDy.set("esremark", (Object)"");
                }
                if (!StringUtils.isEmpty((String)(acttimevalidResult = ActTimeCopValidataBusiness.getInstance().checkValidData(EcoCopUtils.genActtimeCopBean(updateDy, ecoBill, refDyColl))))) {
                    throw new KDBizException(acttimevalidResult);
                }
                execEndIdSet.add(currentEcoBomCopEntryId);
                PlatformUtils.addList(updateList, (DynamicObject)updateDy);
                if (!EcoCopUtils.isDiff(updateDy, oldActtime, oldEstimateStatus) || ecoPEntry == null) continue;
                String logRemark = AddEcoLogUtils.getLogRemark(fromType, ecoBomCopEntryIdSet, updateDy);
                AddEcoLogUtils.addEcoLogByActtime(updateDy, ecoBill, ecoPEntry, ecoRecordLogMap, ecoRecordLogList, logRemark, oldActtime, oldEstimateStatus);
            }
        }
        if (!updateList.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]), (OperateOption)OperateOption.create());
        }
        if (!ecoRecordLogList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])ecoRecordLogList.toArray(new DynamicObject[ecoRecordLogList.size()]), (OperateOption)OperateOption.create());
        }
        return updateList;
    }

    private static ActTimeCopBean genActtimeCopBean(DynamicObject ecoBomCopEntry, DynamicObject ecoBill, DynamicObject[] refDyColl) {
        Date actTime = ecoBomCopEntry.getDate("copacttime");
        Date entryValidDate = ecoBomCopEntry.getDate("copentryvaliddate");
        Date entryInValidDate = ecoBomCopEntry.getDate("copentryinvaliddate");
        String entrymode = ecoBomCopEntry.getString("copentrymode");
        Long mftBomCopEntryId = ecoBomCopEntry.getLong("oldcopentryid");
        Long mftBomCopEntryAfterId = 0L;
        if ("B".equals(entrymode) && "C".equals(ecoBill.getString("billstatus"))) {
            mftBomCopEntryAfterId = EcoCopUtils.getMftBomCopEntryAfterId(ecoBomCopEntry, refDyColl);
        }
        Long materialId = ecoBomCopEntry.getDynamicObject("copentrymaterialid").getLong("id");
        return new ActTimeCopBean(actTime, entryValidDate, entryInValidDate, mftBomCopEntryId, mftBomCopEntryAfterId, ecoBill.getLong("id"), ecoBill.getString("billno"), entrymode, ecoBill.getString("billstatus"), materialId);
    }

    public static Long getMftBomCopEntryAfterId(DynamicObject ecoBomCopEntry, DynamicObject[] refDyColl) {
        Long mftBomCopEntryId = ecoBomCopEntry.getLong("oldcopentryid");
        Long id = ecoBomCopEntry.getLong("entryid");
        Long mftBomCopEntryAfterId = 0L;
        for (int i = 0; i < refDyColl.length; ++i) {
            DynamicObject updateDy = refDyColl[i];
            Long ecoBomId = updateDy.getLong("ecobomid");
            if (!ecoBomId.equals(ecoBomCopEntry.getLong("ecobomid")) || !mftBomCopEntryId.equals(updateDy.getLong("oldcopentryid")) || id.equals(updateDy.getLong("entryid"))) continue;
            mftBomCopEntryAfterId = updateDy.getLong("newcopentryid");
            break;
        }
        if (mftBomCopEntryAfterId == null || mftBomCopEntryAfterId.equals(0L)) {
            HashSet<Long> ecoBomCopEntryIdSet = new HashSet<Long>(16);
            ecoBomCopEntryIdSet.add(ecoBomCopEntry.getLong("entryid"));
            Map<Long, Long> afterMap = EcoCopUtils.getMftBomCopEntryIdMap(ecoBomCopEntryIdSet);
            mftBomCopEntryAfterId = afterMap.get(mftBomCopEntryId);
        }
        return mftBomCopEntryAfterId;
    }

    public static Map<Long, Long> getMftBomCopEntryIdMap(Set<Long> ecoBomCopEntryIdSet) {
        if (PlatformUtils.isNullSet(ecoBomCopEntryIdSet)) {
            return new HashMap<Long, Long>(16);
        }
        String algoKey = EcoCopUtils.class.getName() + "_getMftBomCopEntryIdMap";
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select b.foldcopentryid as mftcopbomentryid ", new Object[0]);
        sb.append(" ,b.fnewcopentryid as mftbomcopentryafterid ", new Object[0]);
        sb.append(" from t_fmm_ecobomcopentry a ", new Object[0]);
        sb.append(" inner join t_fmm_ecobomcopentry b on a.fid = b.fid and a.foldcopentryid = b.foldcopentryid and a.fentryid <> b.fentryid and a.foldcopentryid > 0  ", new Object[0]);
        sb.append(" where ", new Object[0]);
        sb.appendIn("a.fentryid", ecoBomCopEntryIdSet.toArray());
        sb.append(" and a.fentrymode = 'B' ", new Object[0]);
        sb.append(" and b.fentrymode = 'C' ", new Object[0]);
        HashMap<Long, Long> dataMap = new HashMap<Long, Long>(16);
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            while (ds.hasNext()) {
                Row arow = ds.next();
                dataMap.put(arow.getLong("mftcopbomentryid"), arow.getLong("mftbomcopentryafterid"));
            }
        }
        return dataMap;
    }

    private static boolean isDiff(DynamicObject ecoBomCopEntry, Date oldActTime, String oldEstimateStatus) {
        Date newActTime = ecoBomCopEntry.getDate("copacttime");
        String newEstimatestatus = ecoBomCopEntry.getString("estimatestatus");
        return PlatformUtils.isDiffDate((Date)oldActTime, (Date)newActTime) || PlatformUtils.isDiffString((String)oldEstimateStatus, (String)newEstimatestatus);
    }

    public static Set<Long> getMftBomCopEntryByECN(List<DynamicObject> ecoBomCopEntryList) {
        int size = ecoBomCopEntryList.size();
        HashSet<Long> mftBomCopEntryIdSet = new HashSet<Long>(size);
        for (int i = 0; i < size; ++i) {
            DynamicObject ecoBomCopEntry = ecoBomCopEntryList.get(i);
            Long oldMftBomCopEntryId = ecoBomCopEntry.getLong("oldcopentryid");
            Long newMftBomCopEntryId = ecoBomCopEntry.getLong("newcopentryid");
            if ("A".equals(ecoBomCopEntry.getString("copentrymode"))) {
                if (PlatformUtils.isNullLong((Long)newMftBomCopEntryId)) continue;
                mftBomCopEntryIdSet.add(newMftBomCopEntryId);
                continue;
            }
            if (!PlatformUtils.isNullLong((Long)newMftBomCopEntryId)) {
                mftBomCopEntryIdSet.add(newMftBomCopEntryId);
            }
            if (PlatformUtils.isNullLong((Long)oldMftBomCopEntryId)) continue;
            mftBomCopEntryIdSet.add(oldMftBomCopEntryId);
        }
        return mftBomCopEntryIdSet;
    }

    public static List<DynamicObject> updateMftBomData(List<DynamicObject> ecoBomCopEntryList, String fromType) {
        if (ecoBomCopEntryList == null || ecoBomCopEntryList.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Long> mftBomCopEntryIdSet = EcoCopUtils.getMftBomCopEntryByECN(ecoBomCopEntryList);
        Map<Long, DynamicObject> mftBomCopEntryDataMap = EcoCopUtils.getMftBomCopEntryData(mftBomCopEntryIdSet);
        int size = ecoBomCopEntryList.size();
        ArrayList<DynamicObject> updateMftBomCopEntryList = new ArrayList<DynamicObject>(size);
        HashMap<Long, Boolean> cacheMap = new HashMap<Long, Boolean>(16);
        HashSet<String> execedIdSet = new HashSet<String>(16);
        HashMap<Long, DynamicObject> ecoBillCacheMap = new HashMap<Long, DynamicObject>(16);
        HashSet<Long> mftBomIds = new HashSet<Long>(16);
        HashMap<Long, ArrayList<Long>> orgBomIdMap = new HashMap<Long, ArrayList<Long>>(16);
        String ecnbillno = "";
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        for (int i = 0; i < size; ++i) {
            Date lastActtime;
            DynamicObject ecoBomCopEntry = ecoBomCopEntryList.get(i);
            Long ecoBomId = ecoBomCopEntry.getLong("ecobomid");
            boolean isAuditStatus = EcoUtils.checkEcoIsAudit(ecoBomId, cacheMap);
            if (!isAuditStatus) continue;
            Long mftBomCopEntryId = ecoBomCopEntry.getLong("oldcopentryid");
            Long mftBomCopEntryAfterId = ecoBomCopEntry.getLong("newcopentryid");
            String entrymode = ecoBomCopEntry.getString("copentrymode");
            Date acttime = ecoBomCopEntry.getDate("copacttime");
            if (acttime == null) continue;
            DynamicObject beforeMftBomCopEntry = mftBomCopEntryDataMap.get(mftBomCopEntryId);
            if (beforeMftBomCopEntry == null) {
                mftBomCopEntryId = mftBomCopEntryAfterId;
                beforeMftBomCopEntry = mftBomCopEntryDataMap.get(mftBomCopEntryId);
            }
            Long bomId = 0L;
            DynamicObject afterMftBomCopEntry = null;
            if ("B".equals(entrymode) && !mftBomCopEntryAfterId.equals(mftBomCopEntryId)) {
                afterMftBomCopEntry = mftBomCopEntryDataMap.get(mftBomCopEntryAfterId);
            }
            if ("C".equals(entrymode) && !mftBomCopEntryAfterId.equals(0L)) {
                afterMftBomCopEntry = mftBomCopEntryDataMap.get(mftBomCopEntryAfterId);
            }
            if (beforeMftBomCopEntry != null && "A".equals(entrymode) && acttime != null && execedIdSet.add("entryvaliddate" + beforeMftBomCopEntry.getLong("id")) && PlatformUtils.isDiffDate((Date)beforeMftBomCopEntry.getDate("copentryvaliddate"), (Date)acttime)) {
                beforeMftBomCopEntry.set("copentryvaliddate", (Object)acttime);
                EcoCopUtils.checkMftBomValiDate(beforeMftBomCopEntry, ecoBomCopEntry);
                PlatformUtils.addList(updateMftBomCopEntryList, (DynamicObject)beforeMftBomCopEntry);
                bomId = beforeMftBomCopEntry.getLong("bomid");
            }
            if (beforeMftBomCopEntry != null && "E".equals(entrymode) && acttime != null && execedIdSet.add("entryinvaliddate" + beforeMftBomCopEntry.getLong("id"))) {
                lastActtime = PlatformUtils.addSecond((Date)acttime, (int)-1);
                if (PlatformUtils.isDiffDate((Date)beforeMftBomCopEntry.getDate("copentryinvaliddate"), (Date)lastActtime)) {
                    beforeMftBomCopEntry.set("copentryinvaliddate", (Object)lastActtime);
                    EcoCopUtils.checkMftBomValiDate(beforeMftBomCopEntry, ecoBomCopEntry);
                    PlatformUtils.addList(updateMftBomCopEntryList, (DynamicObject)beforeMftBomCopEntry);
                    bomId = beforeMftBomCopEntry.getLong("bomid");
                }
            }
            if ("B".equals(entrymode) && acttime != null) {
                if (afterMftBomCopEntry != null && execedIdSet.add("entryvaliddate" + afterMftBomCopEntry.getLong("id")) && PlatformUtils.isDiffDate((Date)afterMftBomCopEntry.getDate("copentryvaliddate"), (Date)acttime)) {
                    afterMftBomCopEntry.set("copentryvaliddate", (Object)acttime);
                    EcoCopUtils.checkMftBomValiDate(afterMftBomCopEntry, ecoBomCopEntry);
                    PlatformUtils.addList(updateMftBomCopEntryList, (DynamicObject)afterMftBomCopEntry);
                    bomId = afterMftBomCopEntry.getLong("bomid");
                }
                lastActtime = PlatformUtils.addSecond((Date)acttime, (int)-1);
                if (beforeMftBomCopEntry != null && execedIdSet.add("entryinvaliddate" + beforeMftBomCopEntry.getLong("id")) && PlatformUtils.isDiffDate((Date)beforeMftBomCopEntry.getDate("copentryinvaliddate"), (Date)lastActtime)) {
                    beforeMftBomCopEntry.set("copentryinvaliddate", (Object)lastActtime);
                    EcoCopUtils.checkMftBomValiDate(beforeMftBomCopEntry, ecoBomCopEntry);
                    PlatformUtils.addList(updateMftBomCopEntryList, (DynamicObject)beforeMftBomCopEntry);
                    bomId = beforeMftBomCopEntry.getLong("bomid");
                }
            }
            if ("C".equals(entrymode) && acttime != null && afterMftBomCopEntry != null && execedIdSet.add("entryvaliddate" + afterMftBomCopEntry.getLong("id")) && PlatformUtils.isDiffDate((Date)afterMftBomCopEntry.getDate("copentryvaliddate"), (Date)acttime)) {
                afterMftBomCopEntry.set("copentryvaliddate", (Object)acttime);
                EcoCopUtils.checkMftBomValiDate(afterMftBomCopEntry, ecoBomCopEntry);
                PlatformUtils.addList(updateMftBomCopEntryList, (DynamicObject)afterMftBomCopEntry);
                bomId = afterMftBomCopEntry.getLong("bomid");
            }
            if (bomId.equals(0L) || !mftBomIds.add(bomId)) continue;
            DynamicObject ecoBill = EcoUtils.getEcoBillDynamicObject(ecoBomId, ecoBillCacheMap);
            Long orgId = ecoBill.getDynamicObject("org").getLong("id");
            ArrayList<Long> bomIdList = (ArrayList<Long>)orgBomIdMap.get(orgId);
            if (bomIdList == null) {
                bomIdList = new ArrayList<Long>(16);
            }
            bomIdList.add(bomId);
            orgBomIdMap.put(orgId, bomIdList);
            ecnbillno = ecoBill.getString("billno");
            orgIdSet.add(orgId);
        }
        if (!updateMftBomCopEntryList.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateMftBomCopEntryList.toArray(new DynamicObject[updateMftBomCopEntryList.size()]), (OperateOption)OperateOption.create());
            EcoCopUtils.updateMftBomModifyer(updateMftBomCopEntryList);
            if (!"estimatecompute".equals(fromType) && !"auditecn".equals(fromType)) {
                for (Long orgId : orgIdSet) {
                    EcoUtils.refreshBaseDataCache("pdm_mftbom", orgId);
                }
            }
            if (!mftBomIds.isEmpty()) {
                for (Map.Entry boms : orgBomIdMap.entrySet()) {
                    BomSyncCostUtils.syncCost((Long)((Long)boms.getKey()), (List)((List)boms.getValue()), (String)ecnbillno, (String)"");
                }
            }
        }
        return updateMftBomCopEntryList;
    }

    public static void checkMftBomValiDate(DynamicObject mftBomCopEntry, DynamicObject ecoBomCopEntry) {
        Date entryvaliddate = mftBomCopEntry.getDate("copentryvaliddate");
        Date entryinvaliddate = mftBomCopEntry.getDate("copentryinvaliddate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (sdf.format(entryvaliddate).compareTo(sdf.format(entryinvaliddate)) > 0) {
            String bomNumber = EcoUtils.getBomNumber(mftBomCopEntry.getLong("bomid"));
            String materialNumber = EcoUtils.getMaterialNumber(mftBomCopEntry, "copentrymaterialid");
            HashMap<String, Object> cacheMap = new HashMap<String, Object>(16);
            String ecoBillNumber = EcoUtils.getEcoBillNo(ecoBomCopEntry.getLong("ecobomid"), cacheMap);
            String errorStr = String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355[%1$s]\u5bf9\u5e94\u7684BOM\u7f16\u7801[%2$s]\u4e0b\u7684\u8054\u526f\u4ea7\u54c1\u7f16\u7801[%3$s],\u751f\u6548\u65f6\u95f4[%4$s]\u5927\u4e8e\u5931\u6548\u65f6\u95f4[%5$s]", (String)"EcoCopUtils_4", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, bomNumber, materialNumber, sdf.format(entryvaliddate), sdf.format(entryinvaliddate));
            throw new KDBizException(errorStr);
        }
    }

    public static void updateMftBomModifyer(List<DynamicObject> updateMftBomCopEntryList) {
        DynamicObject[] dys;
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject dy : updateMftBomCopEntryList) {
            idSet.add(dy.getLong("bomid"));
        }
        Long userId = RequestContext.get().getCurrUserId();
        Date newDate = new Date();
        for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)"pdm_mftbom", (String)"id,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)})) {
            dy.set("modifier", (Object)userId);
            dy.set("modifytime", (Object)newDate);
        }
        SaveServiceHelper.update((DynamicObject[])dys);
    }

    public static boolean updateEcoBomValues(DynamicObject ecoBom, DynamicObject ecnBill, boolean isupdate) {
        DynamicObjectCollection coll = ecoBom.getDynamicObjectCollection("copentry");
        if (coll == null || coll.isEmpty()) {
            return Boolean.FALSE;
        }
        boolean isUpdateValue = false;
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject ecoBomCopEntry = (DynamicObject)coll.get(i);
            int copentryseq = ecoBomCopEntry.getInt("copentryseq");
            int seq = ecoBomCopEntry.getInt("seq");
            if (copentryseq != 0 && (copentryseq == seq || seq <= 0)) continue;
            ecoBomCopEntry.set("copentryseq", (Object)seq);
            isUpdateValue = true;
        }
        if (isupdate && isUpdateValue) {
            SaveServiceHelper.update((DynamicObject)ecoBom);
        }
        return isUpdateValue;
    }
}

