/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.fmm.business.route.RouteSyncCostUtils;
import kd.mmc.fmm.common.util.DateCommonUtils;
import kd.mmc.pdm.business.ecoplatform.ActTimeRouteBean;
import kd.mmc.pdm.business.ecoplatform.ActTimeRouteValidataBusiness;
import kd.mmc.pdm.business.ecoplatform.AddEcoLogUtils;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;

public class EcoRouteUtils {
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    private static final Log log = LogFactory.getLog(EcoRouteUtils.class);

    public static String getAduitEcnBill(Set<Long> processEntryIdSet, Long currentECNId, String entryMode) {
        if (processEntryIdSet == null || processEntryIdSet.isEmpty()) {
            return null;
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" h.fid as fecnid ", new Object[0]);
        sb.append(",h.fbillno as fbillno ", new Object[0]);
        sb.append(" from t_pdm_ecorouteoperation a ", new Object[0]);
        sb.append(" inner join t_pdm_bomecopentry b on a.fid = b.fecorouteid ", new Object[0]);
        sb.append(" inner join t_pdm_bom_eco h on h.fid = b.fid ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("a.foldprocessentryid", processEntryIdSet.toArray());
        sb.append(" and h.fbillstatus = 'C' ", new Object[0]);
        sb.append(" and b.fentryversioncontrol = 'A' ", new Object[0]);
        if ("E".equalsIgnoreCase(entryMode)) {
            sb.append(" and a.fentrymode = 'E' ", new Object[0]);
        } else if ("A".equalsIgnoreCase(entryMode)) {
            sb.append(" and a.fentrymode = 'A' ", new Object[0]);
        } else if ("B".equalsIgnoreCase(entryMode)) {
            sb.append(" and a.fentrymode = 'B' ", new Object[0]);
        } else {
            sb.append(" and a.fentrymode = 'C' ", new Object[0]);
        }
        String fbillno = "";
        try (DataSet ds = DB.queryDataSet((String)(EcoRouteUtils.class.getName() + "_getAduitRouteEcnBill"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                Long fecnid = row.getLong("fecnid");
                if (!PlatformUtils.isNullLong((Long)currentECNId) && currentECNId.equals(fecnid)) continue;
                fbillno = row.getString("fbillno");
            }
        }
        return fbillno;
    }

    public static Map<Long, DynamicObject> getRouteEntryData(Set<Long> processEntryIdSet) {
        DynamicObject[] coll;
        if (processEntryIdSet.isEmpty()) {
            return new HashMap<Long, DynamicObject>(16);
        }
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(processEntryIdSet.size());
        QFilter filter = new QFilter("entryid", "in", processEntryIdSet);
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = EcoRouteUtils.getProcessEntrySelectProperties();
        for (DynamicObject dy : coll = BusinessDataServiceHelper.load((String)"pdm_route_processentry", (String)selectProperties, (QFilter[])qFilters)) {
            dataMap.put(dy.getLong("entryid"), dy);
        }
        return dataMap;
    }

    public static List<DynamicObject> getRouteEntryDataByOp(String processSeq, String operationNo, Long routeId) {
        DynamicObject[] coll;
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(16);
        QFilter filter = new QFilter("routeid", "=", (Object)routeId);
        filter.and(new QFilter("parent", "=", (Object)processSeq));
        filter.and(new QFilter("operationno", "=", (Object)operationNo));
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = EcoRouteUtils.getProcessEntrySelectProperties();
        for (DynamicObject dy : coll = BusinessDataServiceHelper.load((String)"pdm_route_processentry", (String)selectProperties, (QFilter[])qFilters)) {
            dataList.add(dy);
        }
        return dataList;
    }

    public static List<DynamicObject> getRouteEntryInstorePoint(Long routeId) {
        DynamicObject[] coll;
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(16);
        QFilter filter = new QFilter("routeid", "=", (Object)routeId);
        filter.and(new QFilter("storagepoint", "=", (Object)"1"));
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = EcoRouteUtils.getProcessEntrySelectProperties();
        for (DynamicObject dy : coll = BusinessDataServiceHelper.load((String)"pdm_route_processentry", (String)selectProperties, (QFilter[])qFilters)) {
            dataList.add(dy);
        }
        return dataList;
    }

    public static String getProcessEntrySelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("entryid ");
        sb.append(",entryvaliddate ");
        sb.append(",entryinvaliddate ");
        sb.append(",parent ");
        sb.append(",operation ");
        sb.append(",operationno ");
        sb.append(",routeid");
        sb.append(",entryseq");
        sb.append(",storagepoint");
        return sb.toString();
    }

    public static Map<String, Object> getEcnEntryNoEnd(Set<Long> processEntryId, Long ecoBillId) {
        if (processEntryId == null || processEntryId.isEmpty()) {
            return new HashMap<String, Object>(16);
        }
        HashMap<String, Object> refMap = new HashMap<String, Object>(16);
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" h.fid ", new Object[0]);
        sb.append(",h.fbillno ", new Object[0]);
        sb.append(",d2.foldprocessentryid as fprocessentryid ", new Object[0]);
        sb.append(",d2.foperationno as foperationno ", new Object[0]);
        sb.append(" from t_pdm_bom_eco h ", new Object[0]);
        sb.append(" inner join t_pdm_bomecopentry d on h.fid = d.fid  ", new Object[0]);
        sb.append(" inner join t_pdm_ecorouteoperation d2 on d2.fid = d.fecorouteid  ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("d2.foldprocessentryid", processEntryId.toArray());
        sb.append(" and d2.festimatestatus <> 'C'  ", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)(EcoRouteUtils.class.getName() + "_getEcnRouteEntryNoEnd"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                Long thisEcoId = row.getLong("fid");
                if (ecoBillId != null && thisEcoId.equals(ecoBillId)) continue;
                String ecoBillNo = row.getString("fbillno");
                String entrydesc = row.getString("foperationno");
                refMap.put("ecobillno", ecoBillNo);
                refMap.put("entrydesc", entrydesc);
                refMap.put("processentryid", row.getLong("fprocessentryid"));
                break;
            }
        }
        return refMap;
    }

    public static Set<Long> getEcoRouteEntryById(Set<Long> ecoRouteIdSet) {
        QFilter filter = new QFilter("ecorouteid", "in", ecoRouteIdSet);
        DynamicObject[] coll = BusinessDataServiceHelper.load((String)"pdm_ecoroute_entryf7", (String)"entryid", (QFilter[])new QFilter[]{filter});
        HashSet<Long> ecoRouteEntryIdSet = new HashSet<Long>(16);
        if (coll == null || coll.length < 1) {
            return ecoRouteEntryIdSet;
        }
        for (int i = 0; i < coll.length; ++i) {
            ecoRouteEntryIdSet.add(coll[i].getLong("entryid"));
        }
        return ecoRouteEntryIdSet;
    }

    public static void updateStatusAndActTime(Set<Long> ecoRouteIdSet, DynamicObject ecoBill) {
        if (PlatformUtils.isNullSet(ecoRouteIdSet)) {
            return;
        }
        Set<Long> ecoRouteEntryIdSet = EcoRouteUtils.getEcoRouteEntryById(ecoRouteIdSet);
        if (!ecoRouteEntryIdSet.isEmpty()) {
            EcoRouteUtils.updateRefDataActtime(ecoRouteEntryIdSet, "auditecn");
        }
    }

    private static String getEcoRouteEntryDataSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append(" entryid ");
        sb.append(",entrymode ");
        sb.append(",parent ");
        sb.append(",operationno ");
        sb.append(",machiningtype ");
        sb.append(",productionorg ");
        sb.append(",workcenter ");
        sb.append(",operation ");
        sb.append(",entryvaliddate ");
        sb.append(",entryinvaliddate ");
        sb.append(",operationdesc ");
        sb.append(",oprctrlstrategy ");
        sb.append(",basebatchqty ");
        sb.append(",operationunit ");
        sb.append(",ecorouteid ");
        sb.append(",acttime ");
        sb.append(",oldprocessentryid ");
        sb.append(",newprocessentryid ");
        sb.append(",estimatestatus ");
        sb.append(",esremark ");
        sb.append(",entryseq ");
        sb.append(",minacttime ");
        return sb.toString();
    }

    public static DynamicObject[] getAllEcoRouteEntryDynamicObject(Set<Long> ecoRouteEntryIdSet) {
        QFilter filter = new QFilter("entryid", "in", ecoRouteEntryIdSet);
        String selectProperties = EcoRouteUtils.getEcoRouteEntryDataSelectProperties();
        return BusinessDataServiceHelper.load((String)"pdm_ecoroute_entryf7", (String)selectProperties, (QFilter[])new QFilter[]{filter});
    }

    private static DynamicObject getEcoBillDynamicObject(Long ecoRouteId, Map<Long, DynamicObject> cacheMap) {
        if (cacheMap.containsKey(ecoRouteId)) {
            return cacheMap.get(ecoRouteId);
        }
        HashSet<Long> ecoRouteIdSet = new HashSet<Long>(16);
        ecoRouteIdSet.add(ecoRouteId);
        DynamicObject[] ecoBills = EcoRouteUtils.getEcoChangeBillData(ecoRouteIdSet);
        cacheMap.put(ecoRouteId, ecoBills[0]);
        return ecoBills[0];
    }

    public static DynamicObject[] getEcoChangeBillData(Set<Long> ecoRouteIdSet) {
        QFilter filter = new QFilter("pentry.ecorouteid", "in", ecoRouteIdSet);
        QFilter[] qFilters = new QFilter[]{filter};
        return BusinessDataServiceHelper.load((String)"pdm_bom_eco", (String)EcoRouteUtils.getECOBillSelectFields(), (QFilter[])qFilters);
    }

    private static String getECOBillSelectFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("id  ");
        sb.append(",org  ");
        sb.append(",billno  ");
        sb.append(",name  ");
        sb.append(",billstatus  ");
        sb.append(",changetype  ");
        sb.append(",pentry.ecorouteid  ");
        sb.append(",pentry.id ");
        sb.append(",pentry.pentryroute ");
        sb.append(",pentry.ecotype ");
        sb.append(",pentry.proentrymaterial ");
        sb.append(",pentry.proentrymaterialid ");
        return sb.toString();
    }

    public static DynamicObject getEcoPEntry(DynamicObject changeBill, Long ecoRouteId) {
        DynamicObjectCollection pcoll = changeBill.getDynamicObjectCollection("pentry");
        for (int i = 0; i < pcoll.size(); ++i) {
            DynamicObject entry = (DynamicObject)pcoll.get(i);
            if (!ecoRouteId.equals(entry.getLong("ecorouteid"))) continue;
            return entry;
        }
        return null;
    }

    public static List<DynamicObject> updateRefDataActtime(Set<Long> ecoRouteEntryIdSet, String fromType) {
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(16);
        String esremark1 = ResManager.loadKDString((String)"\u5b9e\u65bd\u65f6\u95f4\u6ee1\u8db3\u53d8\u66f4\u7c7b\u578b\u7684\u5904\u7406\u5929\u6570\u6761\u4ef6\uff0c\u8fd0\u7b97\u540e\u66f4\u65b0\u4e3a\u8bc4\u4f30\u5b8c\u6bd5\u3002", (String)"EcoRouteUtils_0", (String)"mmc-pdm-business", (Object[])new Object[0]);
        String esremark2 = ResManager.loadKDString((String)"\u5b9e\u65bd\u65f6\u95f4\u4e0d\u6ee1\u8db3\u53d8\u66f4\u7c7b\u578b\u7684\u5904\u7406\u5929\u6570\u6761\u4ef6\uff0c\u8fd0\u7b97\u540e\u66f4\u65b0\u4e3a\u8bc4\u4f30\u4e2d\u3002", (String)"EcoRouteUtils_1", (String)"mmc-pdm-business", (Object[])new Object[0]);
        String esremark3 = ResManager.loadKDString((String)"\u4f9d\u636e\u53d8\u66f4\u7c7b\u578b\u81ea\u52a8\u5b8c\u6210\u8bc4\u4f30\u3002", (String)"EcoRouteUtils_2", (String)"mmc-pdm-business", (Object[])new Object[0]);
        Date currentDate = DateUtils.getEndOfDay((Date)new Date());
        HashSet<Long> execEndIdSet = new HashSet<Long>(16);
        HashMap<Long, DynamicObject> ecoTypeMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> ecoBillMap = new HashMap<Long, DynamicObject>(16);
        ArrayList<DynamicObject> ecoRecordLogList = new ArrayList<DynamicObject>(16);
        HashMap<String, DynamicObject> ecoRecordLogMap = new HashMap<String, DynamicObject>(16);
        HashMap<Long, Set<Long>> cacheAllRefIdMap = new HashMap<Long, Set<Long>>(16);
        Map<Long, DynamicObject> dataMap = EcoRouteUtils.getKeyEcoRouteEntry(ecoRouteEntryIdSet, cacheAllRefIdMap);
        for (Map.Entry<Long, DynamicObject> entrys : dataMap.entrySet()) {
            Set<Long> allRefDataSet;
            DynamicObject keyDy = entrys.getValue();
            Long ecoRouteEntryId = entrys.getKey();
            if (!execEndIdSet.add(ecoRouteEntryId) || (allRefDataSet = EcoRouteUtils.getAllEcoRouteEntryIdSet(ecoRouteEntryId, cacheAllRefIdMap)).isEmpty()) continue;
            DynamicObject[] refDyColl = EcoRouteUtils.getAllEcoRouteEntryDynamicObject(allRefDataSet);
            for (int i = 0; i < refDyColl.length; ++i) {
                String acttimevalidResult;
                String statustype;
                DynamicObject updateDy = refDyColl[i];
                Long ecoRouteId = updateDy.getLong("ecorouteid");
                DynamicObject ecoBill = EcoRouteUtils.getEcoBillDynamicObject(ecoRouteId, ecoBillMap);
                DynamicObject ecoType = EcoUtils.getEcoType(ecoBill, ecoRouteId, ecoTypeMap);
                DynamicObject ecoPEntry = EcoRouteUtils.getEcoPEntry(ecoBill, ecoRouteId);
                Date oldActtime = updateDy.getDate("acttime");
                String oldEstimateStatus = updateDy.getString("estimatestatus");
                boolean isAdjustActTime = EcoUtils.isAdjustActTime(ecoType);
                if (isAdjustActTime) {
                    updateDy.set("acttime", keyDy.get("acttime"));
                    if ("A".equals(updateDy.getString("entrymode"))) {
                        updateDy.set("entryvaliddate", keyDy.get("acttime"));
                    }
                }
                Long currentEcoRouteEntryId = updateDy.getLong("entryid");
                Date beforeDate = null;
                if (ecoType != null) {
                    int extendDay = ecoType.getInt("estimatestatusday");
                    beforeDate = PlatformUtils.addDay((Date)currentDate, (int)extendDay);
                }
                String string = statustype = ecoType == null ? "B" : ecoType.getString("statustype");
                if (beforeDate != null && "B".equals(statustype) && !"updatebom".equals(fromType) && ("auditecn".equals(fromType) || !"auditecn".equals(fromType))) {
                    if (updateDy.getDate("acttime").before(beforeDate)) {
                        updateDy.set("estimatestatus", (Object)"C");
                        updateDy.set("esremark", (Object)esremark1);
                    } else if (!updateDy.getString("estimatestatus").equals("C")) {
                        updateDy.set("estimatestatus", (Object)"B");
                        updateDy.set("esremark", (Object)esremark2);
                    }
                }
                if ("A".equals(statustype)) {
                    updateDy.set("estimatestatus", (Object)"C");
                    updateDy.set("esremark", (Object)esremark3);
                }
                if ("auditecn".equals(fromType) && "B".equals(statustype)) {
                    updateDy.set("estimatestatus", (Object)"A");
                    updateDy.set("esremark", (Object)"");
                }
                if (!StringUtils.isEmpty((String)(acttimevalidResult = ActTimeRouteValidataBusiness.getInstance().checkValidData(EcoRouteUtils.genActtimeBean(updateDy, ecoBill, refDyColl))))) {
                    throw new KDBizException(acttimevalidResult);
                }
                EcoUtils.setMinActtime(updateDy);
                execEndIdSet.add(currentEcoRouteEntryId);
                PlatformUtils.addList(updateList, (DynamicObject)updateDy);
                if (!EcoRouteUtils.isDiff(updateDy, oldActtime, oldEstimateStatus) || ecoPEntry == null) continue;
                String logRemark = AddEcoLogUtils.getLogRemark(fromType, ecoRouteEntryIdSet, updateDy);
                AddEcoLogUtils.addEcoLogByActtime(updateDy, ecoBill, ecoPEntry, ecoRecordLogMap, ecoRecordLogList, logRemark, oldActtime, oldEstimateStatus);
            }
        }
        if (!updateList.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]), (OperateOption)OperateOption.create());
        }
        if (!ecoRecordLogList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])ecoRecordLogList.toArray(new DynamicObject[ecoRecordLogList.size()]), (OperateOption)OperateOption.create());
        }
        return updateList;
    }

    public static Map<Long, DynamicObject> getKeyEcoRouteEntry(Set<Long> ecoRouteEntryIdSet, Map<Long, Set<Long>> cacheAllRefIdMap) {
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(ecoRouteEntryIdSet.size());
        HashMap<Long, DynamicObject> allDataMap = new HashMap<Long, DynamicObject>(ecoRouteEntryIdSet.size());
        for (Long ecoRouteEntryId : ecoRouteEntryIdSet) {
            DynamicObject keyDy = (DynamicObject)allDataMap.get(ecoRouteEntryId);
            if (keyDy != null) {
                dataMap.put(ecoRouteEntryId, keyDy);
                continue;
            }
            Set<Long> allIdSet = EcoRouteUtils.getAllEcoRouteEntryIdSet(ecoRouteEntryId, cacheAllRefIdMap);
            if (PlatformUtils.isNullSet(allIdSet)) {
                allIdSet = new HashSet<Long>(16);
                allIdSet.add(ecoRouteEntryId);
            }
            DynamicObject[] dycoll = EcoRouteUtils.getAllEcoRouteEntryDynamicObject(allIdSet);
            keyDy = EcoRouteUtils.findKeyDynamicObject(dycoll);
            dataMap.put(ecoRouteEntryId, keyDy);
            for (Long id : allIdSet) {
                allDataMap.put(id, keyDy);
            }
        }
        return dataMap;
    }

    public static DynamicObject findKeyDynamicObject(DynamicObject[] dycoll) {
        int size = dycoll.length;
        if (size == 1) {
            return dycoll[0];
        }
        DynamicObject keyDy = null;
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = dycoll[i];
            String entrymode = entry.getString("entrymode");
            if (!"B".equals(entrymode)) continue;
            keyDy = entry;
            break;
        }
        if (keyDy == null && dycoll.length > 0) {
            keyDy = dycoll[0];
        }
        return keyDy;
    }

    public static DataSet genEcoRouteDataByEntryId(Set<Long> ecoRouteEntryIdSet) {
        String algoKey = EcoRouteUtils.class.getName() + "genEcoRouteDataByEntryId";
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select a.fentryid as ecorouteentryid ", new Object[0]);
        sb.append(" ,a.fid as ecorouteid ", new Object[0]);
        sb.append(" ,b.fentryid as ecorouteentryid2 ", new Object[0]);
        sb.append(" from t_pdm_ecorouteoperation a ", new Object[0]);
        sb.append(" left outer join t_pdm_ecorouteoperation b on a.fid = b.fid and a.foldprocessentryid = b.foldprocessentryid and a.fentryid <> b.fentryid and a.foldprocessentryid > 0  ", new Object[0]);
        sb.append(" where ", new Object[0]);
        sb.appendIn("a.fentryid", ecoRouteEntryIdSet.toArray());
        return DB.queryDataSet((String)algoKey, (DBRoute)scmDBRoute, (SqlBuilder)sb);
    }

    public static Set<Long> getAllEcoRouteEntryIdSet(Long ecoRouteEntryId, Map<Long, Set<Long>> cacheAllRefIdMap) {
        Set<Long> allRefIdSet = null;
        if (cacheAllRefIdMap != null && (allRefIdSet = cacheAllRefIdMap.get(ecoRouteEntryId)) != null) {
            return allRefIdSet;
        }
        HashSet<Long> ecoRouteEntryIdSet = new HashSet<Long>(16);
        ecoRouteEntryIdSet.add(ecoRouteEntryId);
        allRefIdSet = EcoRouteUtils.getAllEcoRouteEntryIdSet(ecoRouteEntryIdSet);
        if (cacheAllRefIdMap != null) {
            cacheAllRefIdMap.put(ecoRouteEntryId, allRefIdSet);
        }
        return allRefIdSet;
    }

    public static Set<Long> getAllEcoRouteEntryIdSet(Set<Long> ecoRouteEntryIdSet) {
        if (PlatformUtils.isNullSet(ecoRouteEntryIdSet)) {
            return new HashSet<Long>(16);
        }
        HashSet<Long> allEcoRouteEntryIdSet = new HashSet<Long>(16);
        try (DataSet ds = EcoRouteUtils.genEcoRouteDataByEntryId(ecoRouteEntryIdSet);){
            while (ds.hasNext()) {
                Row arow = ds.next();
                Long ecorouteentryid = arow.getLong("ecorouteentryid");
                Long ecorouteentryid2 = arow.getLong("ecorouteentryid2");
                allEcoRouteEntryIdSet.add(ecorouteentryid);
                if (PlatformUtils.isNullLong((Long)ecorouteentryid2)) continue;
                allEcoRouteEntryIdSet.add(ecorouteentryid2);
            }
        }
        return allEcoRouteEntryIdSet;
    }

    private static boolean isDiff(DynamicObject ecoRouteEntry, Date oldActTime, String oldEstimateStatus) {
        Date newActTime = ecoRouteEntry.getDate("acttime");
        String newEstimatestatus = ecoRouteEntry.getString("estimatestatus");
        return PlatformUtils.isDiffDate((Date)oldActTime, (Date)newActTime) || PlatformUtils.isDiffString((String)oldEstimateStatus, (String)newEstimatestatus);
    }

    public static void refreshBaseDataCache(String entityname, Long orgId) {
        String cacheType = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        String key = entityname + orgId;
        BaseDataCtrlCacheMrg.clearCache((String)cacheType, (String)key);
        BaseDataService baseDataService = new BaseDataService();
        baseDataService.clearBaseDataFilterCache(entityname, orgId);
        EcoRouteUtils.refreshRouteEntryCache(BusinessDataServiceHelper.newDynamicObject((String)"pdm_route"));
    }

    public static void refreshRouteEntryCache(DynamicObject route) {
        DynamicObjectCollection entryEntity = route.getDynamicObjectCollection("processentry");
        if (!entryEntity.isEmpty()) {
            IDataEntityType dataEntityType = ((DynamicObject)entryEntity.get(0)).getDataEntityType();
            DataEntityCacheManager cacheManager = new DataEntityCacheManager(dataEntityType);
            cacheManager.removeByDt();
        }
    }

    public static ActTimeRouteBean genActtimeBean(DynamicObject ecoRouteEntry, DynamicObject ecoBill, DynamicObject[] refDyColl) {
        Date actTime = ecoRouteEntry.getDate("acttime");
        Date entryValidDate = ecoRouteEntry.getDate("entryvaliddate");
        Date entryInValidDate = ecoRouteEntry.getDate("entryinvaliddate");
        String entrymode = ecoRouteEntry.getString("entrymode");
        Long routeEntryId = ecoRouteEntry.getLong("oldprocessentryid");
        Long routeEntryAfterId = 0L;
        if ("B".equals(entrymode) && "C".equals(ecoBill.getString("billstatus"))) {
            routeEntryAfterId = EcoRouteUtils.getRouteEntryAfterId(ecoRouteEntry, refDyColl);
        }
        return new ActTimeRouteBean(actTime, entryValidDate, entryInValidDate, routeEntryId, routeEntryAfterId, ecoBill.getLong("id"), ecoBill.getString("billno"), entrymode, ecoBill.getString("billstatus"), ecoRouteEntry.getString("operationno"), ecoRouteEntry.getString("parent"));
    }

    public static Long getRouteEntryAfterId(DynamicObject ecoRouteEntry, DynamicObject[] refDyColl) {
        Long routeEntryId = ecoRouteEntry.getLong("oldprocessentryid");
        Long id = ecoRouteEntry.getLong("entryid");
        Long routeEntryAfterId = 0L;
        for (int i = 0; i < refDyColl.length; ++i) {
            DynamicObject updateDy = refDyColl[i];
            Long ecoRouteId = updateDy.getLong("ecorouteid");
            if (!ecoRouteId.equals(ecoRouteEntry.getLong("ecorouteid")) || !routeEntryId.equals(updateDy.getLong("oldprocessentryid")) || id.equals(updateDy.getLong("entryid"))) continue;
            routeEntryAfterId = updateDy.getLong("newprocessentryid");
            break;
        }
        if (routeEntryAfterId == null || routeEntryAfterId.equals(0L)) {
            HashSet<Long> ecoRouteEntryIdSet = new HashSet<Long>(16);
            ecoRouteEntryIdSet.add(ecoRouteEntry.getLong("entryid"));
            Map<Long, Long> afterMap = EcoRouteUtils.getRouteEntryIdMap(ecoRouteEntryIdSet);
            routeEntryAfterId = afterMap.get(routeEntryId);
        }
        return routeEntryAfterId;
    }

    public static Map<Long, Long> getRouteEntryIdMap(Set<Long> ecoRouteEntryIdSet) {
        if (PlatformUtils.isNullSet(ecoRouteEntryIdSet)) {
            return new HashMap<Long, Long>(16);
        }
        String algoKey = EcoRouteUtils.class.getName() + "_getRouteEntryIdMap";
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select b.foldprocessentryid as oldrouteentryid ", new Object[0]);
        sb.append(" ,b.fnewprocessentryid as newrouteentryid ", new Object[0]);
        sb.append(" from t_pdm_ecorouteoperation a ", new Object[0]);
        sb.append(" inner join t_pdm_ecorouteoperation b on a.fid = b.fid and a.foldprocessentryid = b.foldprocessentryid and a.fentryid <> b.fentryid and a.foldprocessentryid > 0  ", new Object[0]);
        sb.append(" where ", new Object[0]);
        sb.appendIn("a.fentryid", ecoRouteEntryIdSet.toArray());
        sb.append(" and a.fentrymode = 'B' ", new Object[0]);
        sb.append(" and b.fentrymode = 'C' ", new Object[0]);
        HashMap<Long, Long> dataMap = new HashMap<Long, Long>(16);
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            while (ds.hasNext()) {
                Row arow = ds.next();
                dataMap.put(arow.getLong("oldrouteentryid"), arow.getLong("newrouteentryid"));
            }
        }
        return dataMap;
    }

    public static Set<Long> getRouteEntryByECN(List<DynamicObject> ecoRouteEntryList) {
        int size = ecoRouteEntryList.size();
        HashSet<Long> routeEntryIdSet = new HashSet<Long>(size);
        for (int i = 0; i < size; ++i) {
            DynamicObject ecoRouteEntry = ecoRouteEntryList.get(i);
            Long oldRouteEntryId = ecoRouteEntry.getLong("oldprocessentryid");
            Long newRouteEntryId = ecoRouteEntry.getLong("newprocessentryid");
            if ("A".equals(ecoRouteEntry.getString("entrymode"))) {
                if (PlatformUtils.isNullLong((Long)newRouteEntryId)) continue;
                routeEntryIdSet.add(newRouteEntryId);
                continue;
            }
            if (!PlatformUtils.isNullLong((Long)newRouteEntryId)) {
                routeEntryIdSet.add(newRouteEntryId);
            }
            if (PlatformUtils.isNullLong((Long)oldRouteEntryId)) continue;
            routeEntryIdSet.add(oldRouteEntryId);
        }
        return routeEntryIdSet;
    }

    public static boolean checkEcoIsAudit(Long ecoRouteId, Map<Long, Boolean> cacheMap) {
        if (cacheMap == null) {
            cacheMap = new HashMap<Long, Boolean>(16);
        }
        if (cacheMap.containsKey(ecoRouteId)) {
            return cacheMap.get(ecoRouteId);
        }
        HashSet<Long> ecoRouteIdSet = new HashSet<Long>(16);
        ecoRouteIdSet.add(ecoRouteId);
        DynamicObject[] ecoBills = EcoRouteUtils.getEcoChangeBillData(ecoRouteIdSet);
        boolean isAuditStatus = "C".equals(ecoBills[0].getString("billstatus"));
        cacheMap.put(ecoRouteId, isAuditStatus);
        return isAuditStatus;
    }

    public static List<DynamicObject> updateRouteEntryData(List<DynamicObject> ecoRouteEntryList, String fromType) {
        if (ecoRouteEntryList == null || ecoRouteEntryList.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Long> routeEntryIdSet = EcoRouteUtils.getRouteEntryByECN(ecoRouteEntryList);
        Map<Long, DynamicObject> routeEntryDataMap = EcoRouteUtils.getRouteEntryData(routeEntryIdSet);
        int size = ecoRouteEntryList.size();
        ArrayList<DynamicObject> updateRouteEntryList = new ArrayList<DynamicObject>(size);
        HashMap<Long, Boolean> cacheMap = new HashMap<Long, Boolean>(16);
        HashSet<String> execedIdSet = new HashSet<String>(16);
        HashMap<Long, DynamicObject> ecoBillCacheMap = new HashMap<Long, DynamicObject>(16);
        ArrayList<Long> routeIds = new ArrayList<Long>(16);
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        String ecnbillno = "";
        for (int i = 0; i < size; ++i) {
            Date lastActtime;
            DynamicObject ecoRouteEntry = ecoRouteEntryList.get(i);
            Long ecoRouteId = ecoRouteEntry.getLong("ecorouteid");
            boolean isAuditStatus = EcoRouteUtils.checkEcoIsAudit(ecoRouteId, cacheMap);
            if (!isAuditStatus) continue;
            Long routeEntryId = ecoRouteEntry.getLong("oldprocessentryid");
            Long routeEntryAfterId = ecoRouteEntry.getLong("newprocessentryid");
            String entrymode = ecoRouteEntry.getString("entrymode");
            Date acttime = ecoRouteEntry.getDate("acttime");
            if (acttime == null) continue;
            DynamicObject beforeRouteEntry = routeEntryDataMap.get(routeEntryId);
            if (beforeRouteEntry == null) {
                routeEntryId = routeEntryAfterId;
                beforeRouteEntry = routeEntryDataMap.get(routeEntryId);
            }
            Long routeId = 0L;
            DynamicObject afterRouteEntry = null;
            if ("B".equals(entrymode) && !routeEntryAfterId.equals(routeEntryId)) {
                afterRouteEntry = routeEntryDataMap.get(routeEntryAfterId);
            }
            if ("C".equals(entrymode) && !routeEntryAfterId.equals(0L)) {
                afterRouteEntry = routeEntryDataMap.get(routeEntryAfterId);
            }
            if (beforeRouteEntry != null && "A".equals(entrymode) && acttime != null && execedIdSet.add("entryvaliddate" + beforeRouteEntry.getLong("id")) && PlatformUtils.isDiffDate((Date)beforeRouteEntry.getDate("entryvaliddate"), (Date)acttime)) {
                beforeRouteEntry.set("entryvaliddate", (Object)acttime);
                EcoRouteUtils.checkRouteValiDate(beforeRouteEntry, ecoRouteEntry);
                PlatformUtils.addList(updateRouteEntryList, (DynamicObject)beforeRouteEntry);
                routeId = beforeRouteEntry.getLong("routeid");
            }
            if (beforeRouteEntry != null && "E".equals(entrymode) && acttime != null && execedIdSet.add("entryinvaliddate" + beforeRouteEntry.getLong("id"))) {
                lastActtime = PlatformUtils.addSecond((Date)acttime, (int)-1);
                if (PlatformUtils.isDiffDate((Date)beforeRouteEntry.getDate("entryinvaliddate"), (Date)lastActtime)) {
                    beforeRouteEntry.set("entryinvaliddate", (Object)lastActtime);
                    EcoRouteUtils.checkRouteValiDate(beforeRouteEntry, ecoRouteEntry);
                    PlatformUtils.addList(updateRouteEntryList, (DynamicObject)beforeRouteEntry);
                    routeId = beforeRouteEntry.getLong("routeid");
                }
            }
            if ("B".equals(entrymode) && acttime != null) {
                if (afterRouteEntry != null && execedIdSet.add("entryvaliddate" + afterRouteEntry.getLong("id")) && PlatformUtils.isDiffDate((Date)afterRouteEntry.getDate("entryvaliddate"), (Date)acttime)) {
                    afterRouteEntry.set("entryvaliddate", (Object)acttime);
                    EcoRouteUtils.checkRouteValiDate(afterRouteEntry, ecoRouteEntry);
                    PlatformUtils.addList(updateRouteEntryList, (DynamicObject)afterRouteEntry);
                    routeId = afterRouteEntry.getLong("routeid");
                }
                lastActtime = PlatformUtils.addSecond((Date)acttime, (int)-1);
                if (beforeRouteEntry != null && execedIdSet.add("entryinvaliddate" + beforeRouteEntry.getLong("id")) && PlatformUtils.isDiffDate((Date)beforeRouteEntry.getDate("entryinvaliddate"), (Date)lastActtime)) {
                    beforeRouteEntry.set("entryinvaliddate", (Object)lastActtime);
                    EcoRouteUtils.checkRouteValiDate(beforeRouteEntry, ecoRouteEntry);
                    PlatformUtils.addList(updateRouteEntryList, (DynamicObject)beforeRouteEntry);
                    routeId = beforeRouteEntry.getLong("routeid");
                }
            }
            if ("C".equals(entrymode) && acttime != null && afterRouteEntry != null && execedIdSet.add("entryvaliddate" + afterRouteEntry.getLong("id")) && PlatformUtils.isDiffDate((Date)afterRouteEntry.getDate("entryvaliddate"), (Date)acttime)) {
                afterRouteEntry.set("entryvaliddate", (Object)acttime);
                EcoRouteUtils.checkRouteValiDate(afterRouteEntry, ecoRouteEntry);
                PlatformUtils.addList(updateRouteEntryList, (DynamicObject)afterRouteEntry);
                routeId = afterRouteEntry.getLong("routeid");
            }
            if (routeId.equals(0L)) continue;
            routeIds.add(routeId);
            DynamicObject ecoBill = EcoRouteUtils.getEcoBillDynamicObject(ecoRouteId, ecoBillCacheMap);
            Long orgId = ecoBill.getDynamicObject("org").getLong("id");
            ecnbillno = ecoBill.getString("billno");
            orgIdSet.add(orgId);
        }
        if (!updateRouteEntryList.isEmpty()) {
            if (!"unittest".equals(fromType)) {
                SaveServiceHelper.update((DynamicObject[])updateRouteEntryList.toArray(new DynamicObject[updateRouteEntryList.size()]), (OperateOption)OperateOption.create());
            }
            EcoRouteUtils.updateRouteModifyer(updateRouteEntryList);
            if (!"estimatecompute".equals(fromType) && !"auditecn".equals(fromType)) {
                for (Long orgId : orgIdSet) {
                    EcoRouteUtils.refreshBaseDataCache("pdm_route", orgId);
                }
            }
            if (!routeIds.isEmpty()) {
                String routeSelectProperties = "id,createorg,number";
                DynamicObject[] routes = BusinessDataServiceHelper.load((String)"pdm_route", (String)routeSelectProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", routeIds)});
                RouteSyncCostUtils.syncCost((DynamicObject[])routes, (String)ecnbillno);
            }
        }
        return updateRouteEntryList;
    }

    public static void checkRouteValiDate(List<DynamicObject> updateRouteEntryList) {
        HashSet<Long> routeIdSet = new HashSet<Long>(16);
        HashSet<String> processSeqSet = new HashSet<String>(16);
        HashSet<String> operationNoSet = new HashSet<String>(16);
        HashMap<Long, DynamicObject> newRouteEntryMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject routeEntry : updateRouteEntryList) {
            Long routeId = routeEntry.getLong("routeid");
            String processSeq = routeEntry.getString("parent");
            String operationNo = routeEntry.getString("operationno");
            routeIdSet.add(routeId);
            processSeqSet.add(processSeq);
            operationNoSet.add(operationNo);
            Long entryId = routeEntry.getLong("entryid");
            newRouteEntryMap.put(entryId, routeEntry);
        }
        QFilter filter = new QFilter("routeid", "in", routeIdSet);
        filter.and(new QFilter("parent", "in", processSeqSet));
        filter.and(new QFilter("operationno", "in", operationNoSet));
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = EcoRouteUtils.getProcessEntrySelectProperties();
        DynamicObject[] coll = BusinessDataServiceHelper.load((String)"pdm_route_processentry", (String)selectProperties, (QFilter[])qFilters);
        HashMap opMap = new HashMap(16);
        for (DynamicObject dy : coll) {
            Long entryId = dy.getLong("entryid");
            DynamicObject newEntry = (DynamicObject)newRouteEntryMap.get(entryId);
            if (newEntry == null) {
                newEntry = dy;
            }
            Date entryvaliddate = newEntry.getDate("entryvaliddate");
            Date entryinvaliddate = newEntry.getDate("entryinvaliddate");
            Long routeId = newEntry.getLong("routeid");
            String processSeq = newEntry.getString("parent");
            String operationNo = newEntry.getString("operationno");
            String opKey = routeId + "_" + processSeq + "_" + operationNo;
            ArrayList<DynamicObject> oldList = (ArrayList<DynamicObject>)opMap.get(opKey);
            if (oldList == null) {
                oldList = new ArrayList<DynamicObject>(16);
            }
            for (int i = 0; i < oldList.size(); ++i) {
                Date entryinvaliddate2;
                DynamicObject oldEntry = (DynamicObject)oldList.get(i);
                Date entryvaliddate2 = oldEntry.getDate("entryvaliddate");
                if (!DateCommonUtils.DateIsUnion((Date)entryvaliddate, (Date)entryinvaliddate, (Date)entryvaliddate2, (Date)(entryinvaliddate2 = oldEntry.getDate("entryinvaliddate")))) continue;
                String routeNumber = EcoRouteUtils.getRouteNumber(routeId);
                String errorStr = String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u7f16\u7801[%1$s]\u4e0b\u7684\u5de5\u5e8f\u5e8f\u5217[%2$s]\u3001\u5de5\u5e8f\u53f7[%3$s],\u751f\u6548\u65f6\u95f4\u548c\u5931\u6548\u65f6\u95f4\u533a\u95f4\u91cd\u53e0,\u4e0d\u5141\u8bb8\u8c03\u6574\u3002", (String)"EcoRouteUtils_11", (String)"mmc-pdm-business", (Object[])new Object[0]), routeNumber, processSeq, operationNo);
                throw new KDBizException(errorStr);
            }
            oldList.add(newEntry);
            opMap.put(opKey, oldList);
        }
    }

    public static void checkRouteValiDate(DynamicObject routeEntry, DynamicObject ecoRouteEntry) {
        Date entryvaliddate = routeEntry.getDate("entryvaliddate");
        Date entryinvaliddate = routeEntry.getDate("entryinvaliddate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (sdf.format(entryvaliddate).compareTo(sdf.format(entryinvaliddate)) > 0) {
            String routeNumber = EcoRouteUtils.getRouteNumber(routeEntry.getLong("routeid"));
            String processseq = routeEntry.getString("parent");
            String operationNo = routeEntry.getString("operationno");
            HashMap<String, Object> cacheMap = new HashMap<String, Object>(16);
            String ecoBillNumber = EcoRouteUtils.getEcoBillNo(ecoRouteEntry.getLong("ecorouteid"), cacheMap);
            String errorStr = String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u201c%1$s\u201d\u5bf9\u5e94\u7684\u5de5\u827a\u8def\u7ebf\u7f16\u7801\u201c%2$s\u201d\u4e0b\u7684\u5de5\u5e8f\u5e8f\u5217\u201c%3$s\u201d\u3001\u5de5\u5e8f\u53f7\u201c%4$s\u201d\u751f\u6548\u65f6\u95f4\u201c%5$s\u201d\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u5931\u6548\u65f6\u95f4\u201c%6$s\u201d\u3002", (String)"EcoRouteUtils_10", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, routeNumber, processseq, operationNo, sdf.format(entryvaliddate), sdf.format(entryinvaliddate));
            throw new KDBizException(errorStr);
        }
    }

    public static String getEcoBillNo(Long ecoBomId, Map<String, Object> cacheMap) {
        String ecoBomIds = String.valueOf(ecoBomId);
        if (cacheMap.containsKey(ecoBomIds)) {
            return (String)cacheMap.get(ecoBomIds);
        }
        HashSet<Long> ecoBomIdSet = new HashSet<Long>(16);
        ecoBomIdSet.add(ecoBomId);
        DynamicObject[] ecoBills = EcoRouteUtils.getEcoChangeBillData(ecoBomIdSet);
        String ecoBillNo = ecoBills[0].getString("billno");
        cacheMap.put(ecoBomIds, ecoBillNo);
        return ecoBillNo;
    }

    public static String getRouteNumber(Long routeId) {
        DynamicObject route = BusinessDataServiceHelper.loadSingle((Object)routeId, (String)"pdm_route", (String)"id,number");
        return route.getString("number");
    }

    public static Set<Long> getRouteIdByList(List<DynamicObject> updateRouteEntryList) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject dy : updateRouteEntryList) {
            idSet.add(dy.getLong("routeid"));
        }
        return idSet;
    }

    public static void updateRouteModifyer(List<DynamicObject> updateRouteEntryList) {
        DynamicObject[] dys;
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject dy : updateRouteEntryList) {
            idSet.add(dy.getLong("routeid"));
        }
        Long userId = RequestContext.get().getCurrUserId();
        Date newDate = new Date();
        for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)"pdm_route", (String)"id,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)})) {
            dy.set("modifier", (Object)userId);
            dy.set("modifytime", (Object)newDate);
        }
        SaveServiceHelper.update((DynamicObject[])dys);
    }
}

