/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.fmm.business.bom.BomSyncCostUtils;
import kd.mmc.pdm.business.ecoplatform.ActTimeBean;
import kd.mmc.pdm.business.ecoplatform.ActTimeValidataBusiness;
import kd.mmc.pdm.business.ecoplatform.AddEcoLogUtils;
import kd.mmc.pdm.business.ecoplatform.ext.AbstractEstimateEndExtPlugin;
import kd.mmc.pdm.business.ecoplatform.ext.EcoEstimateStatusUpdateUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.ECNNewUtil;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.PDMAppParamLoadUtil;
import kd.mmc.pdm.common.util.PdmParamSetHelper;

public class EcoUtils {
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    private static final Log log = LogFactory.getLog(EcoUtils.class);
    private static final String UPDATESQL_ECN_ENTRYDATE = "update t_fmm_ecobomentry set fvaliddate = ?,finvaliddate = ? where fentryid = ?";

    public static boolean isEditModeChange(DynamicObject oldEcoType, DynamicObject newEcoType, String fieldType) {
        String newValue;
        if (oldEcoType == null && newEcoType == null) {
            return false;
        }
        String oldValue = oldEcoType == null ? "" : oldEcoType.getString(fieldType);
        String string = newValue = newEcoType == null ? "" : newEcoType.getString(fieldType);
        if (oldValue.equals(newValue)) {
            return false;
        }
        return "C".equals(oldValue) && !"C".equals(newValue) || !"C".equals(oldValue) && "C".equals(newValue);
    }

    public static String getEstimateStatusByEcoType(DynamicObject ecoType, String oldValue) {
        String value;
        if (ecoType == null) {
            return oldValue == null || "".equals(oldValue) ? "A" : oldValue;
        }
        if (!ecoType.containsProperty("statustype")) {
            ecoType = BusinessDataServiceHelper.loadSingleFromCache((Object)ecoType.getPkValue(), (String)ecoType.getDynamicObjectType().getName());
        }
        if ("A".equals(value = ecoType.getString("statustype"))) {
            return "C";
        }
        return oldValue == null || "".equals(oldValue) ? "A" : oldValue;
    }

    public static boolean isEditMode(DynamicObject ecoType, String fieldType) {
        if (ecoType == null) {
            return false;
        }
        if (!ecoType.containsProperty(fieldType)) {
            ecoType = BusinessDataServiceHelper.loadSingleFromCache((Object)ecoType.getPkValue(), (String)ecoType.getDynamicObjectType().getName());
        }
        String value = ecoType.getString(fieldType);
        return "C".equals(value);
    }

    public static boolean isMinMode(DynamicObject ecoType, String fieldType) {
        if (ecoType == null) {
            return false;
        }
        if (!ecoType.containsProperty(fieldType)) {
            ecoType = BusinessDataServiceHelper.loadSingleFromCache((Object)ecoType.getPkValue(), (String)ecoType.getDynamicObjectType().getName());
        }
        String value = ecoType.getString(fieldType);
        return "B".equals(value);
    }

    public static boolean isMaxMode(DynamicObject ecoType, String fieldType) {
        if (ecoType == null) {
            return false;
        }
        if (!ecoType.containsProperty(fieldType)) {
            ecoType = BusinessDataServiceHelper.loadSingleFromCache((Object)ecoType.getPkValue(), (String)ecoType.getDynamicObjectType().getName());
        }
        String value = ecoType.getString(fieldType);
        return "A".equals(value);
    }

    public static boolean isAdjustActTime(DynamicObject ecoType) {
        if (ecoType == null) {
            return false;
        }
        return ecoType.getBoolean("adjustacttime");
    }

    public static BigDecimal getTranQty(DynamicObject ecoBomEntry) {
        BigDecimal fz = ecoBomEntry.getBigDecimal("entryqtynumerator");
        BigDecimal fm = ecoBomEntry.getBigDecimal("entryqtydenominator");
        BigDecimal tranqty = ecoBomEntry.get("tranqty") == null ? BigDecimal.ZERO : ecoBomEntry.getBigDecimal("tranqty");
        return MMCUtils.multiplyAndDivide((BigDecimal)tranqty, (BigDecimal)fm, (BigDecimal)fz);
    }

    public static void updateEcoBomKeyByEcoBomId(Set<Long> ecoBomIdSet, Map<Long, Set<String>> ecoBomRefNoMap, String updateSource) {
        int i;
        QFilter filter = new QFilter("id", "in", ecoBomIdSet);
        QFilter[] qFilters = new QFilter[]{filter};
        DynamicObject[] ecoBoms = BusinessDataServiceHelper.load((String)"pdm_ecobom", (String)EcoUtils.getEcoBomSic(), (QFilter[])qFilters);
        DynamicObject[] changes = EcoUtils.getEcoChangeBillData(ecoBomIdSet);
        HashMap<Long, DynamicObject> ecoTypeMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> cacheMap = new HashMap<Long, DynamicObject>(16);
        for (i = 0; i < changes.length; ++i) {
            DynamicObject ecoBill = changes[i];
            DynamicObjectCollection pentrys = ecoBill.getDynamicObjectCollection("pentry");
            for (int j = 0; j < pentrys.size(); ++j) {
                if (((DynamicObject)pentrys.get(j)).getDynamicObject("ecotype") == null) continue;
                Long ecoTypeId = ((DynamicObject)pentrys.get(j)).getDynamicObject("ecotype").getLong("id");
                DynamicObject ecoType = EcoUtils.getEcoTypeFromCache(ecoTypeId, cacheMap);
                ecoTypeMap.put(((DynamicObject)pentrys.get(j)).getLong("ecobomid"), ecoType);
            }
        }
        for (i = 0; i < ecoBoms.length; ++i) {
            DynamicObject ecoBom = ecoBoms[i];
            DynamicObject ecoType = (DynamicObject)ecoTypeMap.get(ecoBom.getLong("id"));
            if (ecoType == null) continue;
            Set<String> clearRefNoSet = ecoBomRefNoMap.get(ecoBom.getLong("id"));
            EcoUtils.updateEcoBomKey(ecoType, ecoBom, true, clearRefNoSet, updateSource);
        }
    }

    public static DynamicObject getEcoTypeFromCache(Long ecoTypeId, Map<Long, DynamicObject> cacheMap) {
        DynamicObject ecoType;
        if (cacheMap == null) {
            cacheMap = new HashMap<Long, DynamicObject>(16);
        }
        if ((ecoType = cacheMap.get(ecoTypeId)) == null) {
            ecoType = BusinessDataServiceHelper.loadSingleFromCache((Object)ecoTypeId, (String)"pdm_ecotype");
            cacheMap.put(ecoTypeId, ecoType);
        }
        return ecoType;
    }

    private static boolean isCreateLog(String updateSource) {
        return "updatebom".equals(updateSource);
    }

    public static DynamicObject updateEcoBomKey(DynamicObject ecoType, DynamicObject ecoBom, boolean isupdate, Set<String> clearRefNoSet, String updateSource) {
        boolean isupdatedata;
        DynamicObjectCollection coll = ecoBom.getDynamicObjectCollection("entry");
        if (coll == null || coll.isEmpty()) {
            return ecoBom;
        }
        boolean needLog = EcoUtils.isCreateLog(updateSource);
        DynamicObject ecoBomOld = null;
        if (needLog) {
            ecoBomOld = (DynamicObject)OrmUtils.clone((Object)ecoBom, (IDataEntityType)ecoBom.getDataEntityType(), (boolean)false, (boolean)false);
        }
        if (EcoUtils.isMaxMode(ecoType, "groupkeytype") || EcoUtils.isMinMode(ecoType, "groupkeytype")) {
            HashMap<String, DynamicObject> aMap = new HashMap<String, DynamicObject>(16);
            isupdatedata = false;
            Map<String, List<DynamicObject>> transQtyDataMap = EcoUtils.initTransQtyMap(coll);
            Map<String, BigDecimal> transQtyMap = EcoUtils.computeTransQtyMap(transQtyDataMap);
            for (int i = 0; i < coll.size(); ++i) {
                BigDecimal tranQty;
                DynamicObject ecoBomEntry = (DynamicObject)coll.get(i);
                String entryGroupNo = ecoBomEntry.getString("entrygroupno");
                if (PlatformUtils.isNullString((String)entryGroupNo)) {
                    if (!ecoBomEntry.getBoolean("groupkey")) continue;
                    ecoBomEntry.set("groupkey", (Object)false);
                    isupdatedata = true;
                    continue;
                }
                if ("C".equals(ecoBomEntry.getString("estimatestatus"))) continue;
                if (ecoBomEntry.getBoolean("groupkey")) {
                    ecoBomEntry.set("groupkey", (Object)false);
                    isupdatedata = true;
                }
                if (!"E".equals(ecoBomEntry.getString("entrymode"))) continue;
                DynamicObject olde = (DynamicObject)aMap.get(entryGroupNo);
                if (olde == null) {
                    aMap.put(entryGroupNo, ecoBomEntry);
                    continue;
                }
                String keys = EcoUtils.getEcoBomEntryKeys(entryGroupNo, ecoBomEntry);
                String oldkeys = EcoUtils.getEcoBomEntryKeys(entryGroupNo, olde);
                BigDecimal oldTranQty = transQtyMap.get(oldkeys) == null ? BigDecimal.ZERO : transQtyMap.get(oldkeys);
                BigDecimal bigDecimal = tranQty = transQtyMap.get(keys) == null ? BigDecimal.ZERO : transQtyMap.get(keys);
                if (EcoUtils.isMaxMode(ecoType, "groupkeytype")) {
                    if (oldTranQty.compareTo(tranQty) >= 0) continue;
                    aMap.put(entryGroupNo, ecoBomEntry);
                    continue;
                }
                if (!EcoUtils.isMinMode(ecoType, "groupkeytype") || oldTranQty.compareTo(tranQty) <= 0) continue;
                aMap.put(entryGroupNo, ecoBomEntry);
            }
            if (aMap != null && !aMap.isEmpty()) {
                for (Map.Entry entrys : aMap.entrySet()) {
                    DynamicObject ecoBomEntry = (DynamicObject)entrys.getValue();
                    if (ecoBomEntry.getBoolean("groupkey")) continue;
                    ecoBomEntry.set("groupkey", (Object)true);
                    isupdatedata = true;
                }
            }
            if (isupdate && isupdatedata) {
                if (needLog) {
                    EcoUtils.addLogByEcoBomKey(ecoBomOld, ecoBom, "groupkey", updateSource);
                }
                SaveServiceHelper.update((DynamicObject)ecoBom);
            }
        }
        if (EcoUtils.isMaxMode(ecoType, "refkeytype") || EcoUtils.isMinMode(ecoType, "refkeytype")) {
            HashSet<String> refIdSet = new HashSet<String>(16);
            isupdatedata = false;
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject ecoBomEntry = (DynamicObject)coll.get(i);
                String refNo = ecoBomEntry.getString("entryrefno");
                if (PlatformUtils.isNullString((String)refNo)) {
                    if (!ecoBomEntry.getBoolean("refkey")) continue;
                    ecoBomEntry.set("refkey", (Object)false);
                    isupdatedata = true;
                    continue;
                }
                if ("C".equals(ecoBomEntry.getString("estimatestatus"))) continue;
                refIdSet.add(refNo);
            }
            if (isupdatedata) {
                if (needLog) {
                    EcoUtils.addLogByEcoBomKey(ecoBomOld, ecoBom, "refkey", updateSource);
                }
                SaveServiceHelper.update((DynamicObject)ecoBom);
            }
            if (clearRefNoSet != null && !clearRefNoSet.isEmpty()) {
                refIdSet.addAll(clearRefNoSet);
            }
            EcoUtils.updateEcoBomRefnoKey(refIdSet, ecoType, updateSource);
        }
        return ecoBom;
    }

    private static String getEcoBomEntryKeys(String refId, DynamicObject ecoBomEntry) {
        DynamicObject material = ecoBomEntry.getDynamicObject("entrymaterialid");
        DynamicObject feature = ecoBomEntry.getDynamicObject("featuretype");
        DynamicObject version = ecoBomEntry.getDynamicObject("entryversion");
        DynamicObject auxproperty = ecoBomEntry.getDynamicObject("entryauxproperty");
        return refId + "_" + (material == null ? 0L : (Long)material.getPkValue()) + "_" + (feature == null ? 0L : (Long)feature.getPkValue()) + "_" + (version == null ? 0L : (Long)version.getPkValue()) + "_" + (auxproperty == null ? 0L : (Long)auxproperty.getPkValue());
    }

    private static Map<String, List<DynamicObject>> initTransQtyMap(DynamicObject[] refEcoBoms, Set<String> refIdSet) {
        HashMap<String, List<DynamicObject>> dataMap = new HashMap<String, List<DynamicObject>>(16);
        for (String refId : refIdSet) {
            for (int i = 0; i < refEcoBoms.length; ++i) {
                DynamicObject refEcoBom = refEcoBoms[i];
                DynamicObjectCollection refColl = refEcoBom.getDynamicObjectCollection("entry");
                if (refColl == null || refColl.isEmpty()) continue;
                for (int j = 0; j < refColl.size(); ++j) {
                    DynamicObject ecoBomEntry = (DynamicObject)refColl.get(j);
                    String refNo = ecoBomEntry.getString("entryrefno");
                    if (PlatformUtils.isNullString((String)refNo)) {
                        ecoBomEntry.set("refkey", (Object)false);
                        continue;
                    }
                    if ("C".equals(ecoBomEntry.getString("estimatestatus")) || !refId.equals(refNo) || !"E".equals(ecoBomEntry.getString("entrymode"))) continue;
                    String keys = EcoUtils.getEcoBomEntryKeys(refId, ecoBomEntry);
                    ArrayList<DynamicObject> ds = (ArrayList<DynamicObject>)dataMap.get(keys);
                    if (ds == null) {
                        ds = new ArrayList<DynamicObject>(16);
                    }
                    ds.add(ecoBomEntry);
                    dataMap.put(keys, ds);
                }
            }
        }
        return dataMap;
    }

    private static Map<String, List<DynamicObject>> initTransQtyMap(DynamicObjectCollection coll) {
        HashMap<String, List<DynamicObject>> dataMap = new HashMap<String, List<DynamicObject>>(16);
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject ecoBomEntry = (DynamicObject)coll.get(i);
            String entryGroupNo = ecoBomEntry.getString("entrygroupno");
            if (PlatformUtils.isNullString((String)entryGroupNo) || "C".equals(ecoBomEntry.getString("estimatestatus")) || !"E".equals(ecoBomEntry.getString("entrymode"))) continue;
            String keys = EcoUtils.getEcoBomEntryKeys(entryGroupNo, ecoBomEntry);
            ArrayList<DynamicObject> ds = (ArrayList<DynamicObject>)dataMap.get(keys);
            if (ds == null) {
                ds = new ArrayList<DynamicObject>(16);
            }
            ds.add(ecoBomEntry);
            dataMap.put(keys, ds);
        }
        return dataMap;
    }

    private static Map<String, BigDecimal> computeTransQtyMap(Map<String, List<DynamicObject>> dataMap) {
        HashMap<String, BigDecimal> aMap = new HashMap<String, BigDecimal>(16);
        if (!dataMap.isEmpty()) {
            for (Map.Entry<String, List<DynamicObject>> datas : dataMap.entrySet()) {
                String keys = datas.getKey();
                List<DynamicObject> list = datas.getValue();
                if (PlatformUtils.isNullList(list)) {
                    aMap.put(keys, BigDecimal.ZERO);
                    continue;
                }
                if (list.size() == 1) {
                    aMap.put(keys, EcoUtils.getTranQty(list.get(0)));
                    continue;
                }
                BigDecimal allTransQty = BigDecimal.ZERO;
                BigDecimal allFz = BigDecimal.ZERO;
                for (DynamicObject ecoBomEntry : list) {
                    BigDecimal fz = ecoBomEntry.getBigDecimal("entryqtynumerator");
                    BigDecimal fm = ecoBomEntry.getBigDecimal("entryqtydenominator");
                    BigDecimal tranqty = ecoBomEntry.get("tranqty") == null ? BigDecimal.ZERO : ecoBomEntry.getBigDecimal("tranqty");
                    allTransQty = allTransQty.add(tranqty);
                    allFz = allFz.add(MMCUtils.divide((BigDecimal)fz, (BigDecimal)fm));
                }
                allFz = allFz.multiply(new BigDecimal(list.size()));
                aMap.put(keys, MMCUtils.divide((BigDecimal)allTransQty, (BigDecimal)allFz));
            }
        }
        return aMap;
    }

    private static boolean isMulKeys(Map<String, List<DynamicObject>> transQtyDataMap, String keys) {
        if (!transQtyDataMap.isEmpty()) {
            List<DynamicObject> list = transQtyDataMap.get(keys);
            return list != null && list.size() > 1;
        }
        return false;
    }

    private static Set<Long> getAuditEcoBomIdSet(DynamicObject[] refEcoBoms) {
        HashSet<Long> ecoBomIdSet = new HashSet<Long>(16);
        for (DynamicObject ecoBom : refEcoBoms) {
            ecoBomIdSet.add((Long)ecoBom.getPkValue());
        }
        HashSet<Long> auditEcoBomIdSet = new HashSet<Long>(16);
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select d.fecobomid ", new Object[0]);
        sql.append(" from t_pdm_bomecopentry d", new Object[0]);
        sql.append(" inner join t_pdm_bom_eco h on h.fid = d.fid", new Object[0]);
        sql.append(" where h.fbillstatus  = 'C' and ", new Object[0]);
        sql.appendIn(" d.fecobomid ", ecoBomIdSet.toArray());
        try (DataSet ds = DB.queryDataSet((String)(EcoUtils.class.getName() + "_getAuditEcoBomIdSet"), (DBRoute)scmDBRoute, (SqlBuilder)sql);){
            while (ds.hasNext()) {
                auditEcoBomIdSet.add(ds.next().getLong("fecobomid"));
            }
        }
        return auditEcoBomIdSet;
    }

    public static void updateEcoBomRefnoKey(Set<String> refIdSet, DynamicObject ecoType, String updateSource) {
        HashMap<String, DynamicObject> aMap = new HashMap<String, DynamicObject>(16);
        if (!refIdSet.isEmpty()) {
            DynamicObject[] refEcoBoms = EcoUtils.getRefEcoBom(refIdSet);
            Map<String, List<DynamicObject>> transQtyDataMap = EcoUtils.initTransQtyMap(refEcoBoms, refIdSet);
            Map<String, BigDecimal> transQtyMap = EcoUtils.computeTransQtyMap(transQtyDataMap);
            boolean needLog = EcoUtils.isCreateLog(updateSource);
            HashMap<Long, DynamicObject> oldMap = new HashMap<Long, DynamicObject>(16);
            Set<Long> auditEcoBomIdSet = EcoUtils.getAuditEcoBomIdSet(refEcoBoms);
            for (String string : refIdSet) {
                for (int i = 0; i < refEcoBoms.length; ++i) {
                    DynamicObject refEcoBom = refEcoBoms[i];
                    Long ecoBomId = refEcoBom.getLong("id");
                    DynamicObjectCollection refColl = refEcoBom.getDynamicObjectCollection("entry");
                    if (refColl == null || refColl.isEmpty()) continue;
                    DynamicObject refEcoBomOld = null;
                    if (needLog || auditEcoBomIdSet.contains(ecoBomId)) {
                        refEcoBomOld = (DynamicObject)OrmUtils.clone((Object)refEcoBom, (IDataEntityType)refEcoBom.getDataEntityType(), (boolean)false, (boolean)false);
                        oldMap.put(ecoBomId, refEcoBomOld);
                    }
                    for (int j = 0; j < refColl.size(); ++j) {
                        BigDecimal tranQty;
                        DynamicObject ecoBomEntry = (DynamicObject)refColl.get(j);
                        String refNo = ecoBomEntry.getString("entryrefno");
                        if (PlatformUtils.isNullString((String)refNo)) {
                            ecoBomEntry.set("refkey", (Object)false);
                            continue;
                        }
                        if ("C".equals(ecoBomEntry.getString("estimatestatus")) || !string.equals(refNo)) continue;
                        ecoBomEntry.set("refkey", (Object)false);
                        if (!"E".equals(ecoBomEntry.getString("entrymode"))) continue;
                        DynamicObject olde = (DynamicObject)aMap.get(string);
                        if (olde == null) {
                            aMap.put(string, ecoBomEntry);
                            continue;
                        }
                        String keys = EcoUtils.getEcoBomEntryKeys(string, ecoBomEntry);
                        String oldkeys = EcoUtils.getEcoBomEntryKeys(string, olde);
                        BigDecimal oldTranQty = transQtyMap.get(oldkeys) == null ? BigDecimal.ZERO : transQtyMap.get(oldkeys);
                        BigDecimal bigDecimal = tranQty = transQtyMap.get(keys) == null ? BigDecimal.ZERO : transQtyMap.get(keys);
                        if (EcoUtils.isMaxMode(ecoType, "refkeytype")) {
                            if (oldTranQty.compareTo(tranQty) < 0) {
                                aMap.put(string, ecoBomEntry);
                                continue;
                            }
                            if (oldTranQty.compareTo(tranQty) != 0 || !keys.equals(oldkeys) || !EcoUtils.isMulKeys(transQtyDataMap, keys) || (oldTranQty = EcoUtils.getTranQty(olde)).compareTo(tranQty = EcoUtils.getTranQty(ecoBomEntry)) >= 0) continue;
                            aMap.put(string, ecoBomEntry);
                            continue;
                        }
                        if (!EcoUtils.isMinMode(ecoType, "refkeytype")) continue;
                        if (oldTranQty.compareTo(tranQty) > 0) {
                            aMap.put(string, ecoBomEntry);
                            continue;
                        }
                        if (oldTranQty.compareTo(tranQty) != 0 || !keys.equals(oldkeys) || !EcoUtils.isMulKeys(transQtyDataMap, keys) || (oldTranQty = EcoUtils.getTranQty(olde)).compareTo(tranQty = EcoUtils.getTranQty(ecoBomEntry)) <= 0) continue;
                        aMap.put(string, ecoBomEntry);
                    }
                }
            }
            for (Map.Entry entry : aMap.entrySet()) {
                DynamicObject ecoBomEntry = (DynamicObject)entry.getValue();
                String refNo = ecoBomEntry.getString("entryrefno");
                if (PlatformUtils.isNullString((String)refNo)) {
                    ecoBomEntry.set("refkey", (Object)false);
                    continue;
                }
                ecoBomEntry.set("refkey", (Object)true);
            }
            if (oldMap != null && !oldMap.isEmpty()) {
                for (int i = 0; i < refEcoBoms.length; ++i) {
                    DynamicObject dynamicObject = refEcoBoms[i];
                    EcoUtils.addLogByEcoBomKey((DynamicObject)oldMap.get(dynamicObject.getLong("id")), dynamicObject, "refkey", updateSource);
                }
            }
            SaveServiceHelper.update((DynamicObject[])refEcoBoms);
        }
    }

    public static String getEcoBomSic() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",entry.id");
        sb.append(",entry.entrymaterialid");
        sb.append(",entry.entrymaterial");
        sb.append(",entry.featuretype");
        sb.append(",entry.entryversion");
        sb.append(",entry.entryauxproperty");
        sb.append(",entry.entryqtynumerator");
        sb.append(",entry.entryqtydenominator");
        sb.append(",entry.refkey");
        sb.append(",entry.estimatestatus");
        sb.append(",entry.esremark");
        sb.append(",entry.entrymode");
        sb.append(",entry.entrygroupno");
        sb.append(",entry.acttime");
        sb.append(",entry.minacttime");
        sb.append(",entry.tranqty");
        sb.append(",entry.transtartdate");
        sb.append(",entry.groupkey");
        sb.append(",entry.entryrefno");
        sb.append(",entry.bomentry");
        sb.append(",entry.entrybomentryid");
        sb.append(",entry.iscanestimate");
        sb.append(",entry.entrybomentryid");
        sb.append(",entry.configproperties");
        sb.append(",entry.entrymaterialattr");
        sb.append(",entry.entryisjumplevel");
        sb.append(",entry.seq");
        sb.append(",entry.entryseq");
        sb.append(",entry.entryecnid");
        sb.append(",entry.entryecnno");
        sb.append(",entry.entrynumber");
        sb.append(",copentry.id");
        sb.append(",copentry.seq");
        sb.append(",copentry.copentryseq");
        sb.append(",iscoproduct");
        return sb.toString();
    }

    public static DynamicObject[] getRefEcoBom(Set<String> refDyIdSet) {
        QFilter filter = new QFilter("entry.entryrefno", "in", refDyIdSet);
        filter.and(new QFilter("entry.estimatestatus", "<>", (Object)"C"));
        return BusinessDataServiceHelper.load((String)"pdm_ecobom", (String)EcoUtils.getEcoBomSic(), (QFilter[])new QFilter[]{filter});
    }

    public static Map<String, Date> getRefEcoBomKeyActtime(Set<String> refDyIdSet) {
        if (refDyIdSet == null || refDyIdSet.isEmpty()) {
            return new HashMap<String, Date>(16);
        }
        HashMap<String, Date> refMap = new HashMap<String, Date>(16);
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" fentryrefnos ", new Object[0]);
        sb.append(",facttime ", new Object[0]);
        sb.append(" from t_fmm_ecobomentry ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("fentryrefnos", refDyIdSet.toArray());
        sb.append(" and festimatestatus <> 'C' ", new Object[0]);
        sb.append(" and frefkey = '1'  ", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)(EcoUtils.class.getName() + "_getRefEcoBomKeyActtime"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                String fentryrefnos = row.getString("fentryrefnos");
                Date facttime = row.getDate("facttime");
                refMap.put(fentryrefnos, facttime);
            }
        }
        return refMap;
    }

    public static Date getGroupNoEcoBomKeyActtime(Long pentryId, String groupNo) {
        HashSet<Long> pentryIdSet = new HashSet<Long>(16);
        HashSet<String> groupNoSet = new HashSet<String>(16);
        pentryIdSet.add(pentryId);
        groupNoSet.add(groupNo);
        Map<String, Date> dataMap = EcoUtils.getGroupNoEcoBomKeyActtime(pentryIdSet, groupNoSet);
        Date result = null;
        if (dataMap != null && !dataMap.isEmpty()) {
            for (Map.Entry<String, Date> entrys : dataMap.entrySet()) {
                result = entrys.getValue();
            }
        }
        return result;
    }

    public static Map<String, Date> getGroupNoEcoBomKeyActtime(Set<Long> pentryIdSet, Set<String> groupNoSet) {
        if (pentryIdSet == null || pentryIdSet.isEmpty() || groupNoSet == null || groupNoSet.isEmpty()) {
            return new HashMap<String, Date>(16);
        }
        HashMap<String, Date> refMap = new HashMap<String, Date>(16);
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" b.fentryid as fpentryid ", new Object[0]);
        sb.append(",a.fentrygroupnos as fentrygroupno ", new Object[0]);
        sb.append(",a.facttime as facttime ", new Object[0]);
        sb.append(" from t_fmm_ecobomentry a ", new Object[0]);
        sb.append(" inner join t_pdm_bomecopentry b on a.fid = b.fecobomid ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("b.fentryid", pentryIdSet.toArray());
        sb.append(" and  ", new Object[0]);
        sb.appendIn("a.fentrygroupnos", groupNoSet.toArray());
        sb.append(" and a.fgroupkey = '1'  ", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)(EcoUtils.class.getName() + "_getGroupNoEcoBomKeyActtime"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                Long fpentryid = row.getLong("fpentryid");
                String fentrygroupno = row.getString("fentrygroupno");
                Date facttime = row.getDate("facttime");
                refMap.put(PlatformUtils.getUnionString((Object)fpentryid, (Object)fentrygroupno), facttime);
            }
        }
        return refMap;
    }

    public static Map<Long, String> getRefKeyEntryIdSet(Set<String> refDyIdSet) {
        HashMap<Long, String> aMap = new HashMap<Long, String>(refDyIdSet.size());
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" fentryid ", new Object[0]);
        sb.append(" ,fentryrefnos ", new Object[0]);
        sb.append(" from t_fmm_ecobomentry ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("fentryrefnos", refDyIdSet.toArray());
        sb.append(" and festimatestatus not in('C')  ", new Object[0]);
        sb.append(" and frefkey = '1'  ", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)(EcoUtils.class.getName() + "_getRefKeyEntryIdSet"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                aMap.put(row.getLong("fentryid"), row.getString("fentryrefnos"));
            }
        }
        return aMap;
    }

    public static Set<String> checkRefnoIsEnd(Set<String> refDyIdSet, boolean ispgz) {
        HashSet<String> existsRefNoSet = new HashSet<String>(refDyIdSet.size());
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" fentryrefnos ", new Object[0]);
        sb.append(" from t_fmm_ecobomentry ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("fentryrefnos", refDyIdSet.toArray());
        if (ispgz) {
            sb.append(" and festimatestatus in('B','C')  ", new Object[0]);
        } else {
            sb.append(" and festimatestatus in('C')  ", new Object[0]);
        }
        try (DataSet ds = DB.queryDataSet((String)(EcoUtils.class.getName() + "_checkRefnoIsEnd"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                existsRefNoSet.add(row.getString("fentryrefnos"));
            }
        }
        return existsRefNoSet;
    }

    public static void updateStatusAndActTime(Set<Long> ecoBomIdSet, DynamicObject ecoBill) {
        List<DynamicObject> updateRefDataList;
        if (PlatformUtils.isNullSet(ecoBomIdSet)) {
            return;
        }
        Set<Long> ecoBomEntryIdSet = EcoUtils.getEcoBomEntryById(ecoBomIdSet);
        if (!ecoBomEntryIdSet.isEmpty() && !(updateRefDataList = EcoUtils.updateRefDataActtime(ecoBomEntryIdSet, "auditecn")).isEmpty()) {
            Long ecoBomId;
            DynamicObject ecoBomEntry;
            int i;
            Set<Long> currentEcoBomIdSet = EcoUtils.getEcoBomIdSet(ecoBill);
            ArrayList<DynamicObject> otherDataList = new ArrayList<DynamicObject>(16);
            HashMap<Long, Boolean> cacheMap = new HashMap<Long, Boolean>(16);
            for (i = 0; i < updateRefDataList.size(); ++i) {
                ecoBomEntry = updateRefDataList.get(i);
                if (!"E".equals(ecoBomEntry.getString("entrymode")) && !"B".equals(ecoBomEntry.getString("entrymode")) || currentEcoBomIdSet.contains(ecoBomId = Long.valueOf(ecoBomEntry.getLong("ecobomid"))) || !EcoUtils.checkEcoIsAudit(ecoBomId, cacheMap)) continue;
                otherDataList.add(ecoBomEntry);
            }
            for (i = 0; i < updateRefDataList.size(); ++i) {
                ecoBomEntry = updateRefDataList.get(i);
                if ("E".equals(ecoBomEntry.getString("entrymode")) || "B".equals(ecoBomEntry.getString("entrymode")) || currentEcoBomIdSet.contains(ecoBomId = Long.valueOf(ecoBomEntry.getLong("ecobomid"))) || !EcoUtils.checkEcoIsAudit(ecoBomId, cacheMap)) continue;
                otherDataList.add(ecoBomEntry);
            }
            if (!otherDataList.isEmpty()) {
                EcoUtils.updateMftBomData(otherDataList, "auditecn");
            }
        }
    }

    private static Set<Long> getEcoBomIdSet(DynamicObject ecoBill) {
        DynamicObjectCollection pentrys = ecoBill.getDynamicObjectCollection("pentry");
        HashSet<Long> currentEcoBomIdSet = new HashSet<Long>(16);
        for (int i = 0; i < pentrys.size(); ++i) {
            currentEcoBomIdSet.add(((DynamicObject)pentrys.get(i)).getLong("ecobomid"));
        }
        return currentEcoBomIdSet;
    }

    public static boolean checkEcoIsAudit(Long ecoBomId, Map<Long, Boolean> cacheMap) {
        if (cacheMap == null) {
            cacheMap = new HashMap<Long, Boolean>(16);
        }
        if (cacheMap.containsKey(ecoBomId)) {
            return cacheMap.get(ecoBomId);
        }
        HashSet<Long> ecoBomIdSet = new HashSet<Long>(16);
        ecoBomIdSet.add(ecoBomId);
        DynamicObject[] ecoBills = EcoUtils.getEcoChangeBillData(ecoBomIdSet);
        boolean isAuditStatus = "C".equals(ecoBills[0].getString("billstatus"));
        cacheMap.put(ecoBomId, isAuditStatus);
        return isAuditStatus;
    }

    public static Map<String, List<DynamicObject>> getAllGroupNoData(Set<Long> ecoBomIdSet, Set<String> groupNoSet) {
        QFilter filter = new QFilter("ecobomid", "in", ecoBomIdSet);
        filter.and(new QFilter("entrygroupno", "in", groupNoSet));
        String selectProperties = EcoUtils.getEcoBomEntryDataSelectProperties();
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_ecobom_entryf7", (String)selectProperties, (QFilter[])new QFilter[]{filter});
        if (coll == null || coll.isEmpty()) {
            return new HashMap<String, List<DynamicObject>>(16);
        }
        int size = coll.size();
        HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>(size);
        for (int i = 0; i < size; ++i) {
            String groupNo;
            DynamicObject dy = (DynamicObject)coll.get(i);
            Long ecoBomId = dy.getLong("ecobomid");
            String keyString = PlatformUtils.getUnionString((Object)ecoBomId, (Object)(groupNo = dy.getString("entrygroupno")));
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)resultMap.get(keyString);
            if (list == null) {
                list = new ArrayList<DynamicObject>(16);
            }
            list.add(dy);
            resultMap.put(keyString, list);
        }
        return resultMap;
    }

    public static Set<Long> convertObjectToLong(Set<Object> set) {
        if (set == null || set.isEmpty()) {
            return new HashSet<Long>(16);
        }
        HashSet<Long> result = new HashSet<Long>(set.size());
        for (Object datas : set) {
            if (datas instanceof Long) {
                result.add((Long)datas);
                continue;
            }
            result.add(Long.parseLong(datas.toString()));
        }
        return result;
    }

    public static Set<String> convertObjectToString(Set<Object> set) {
        if (set == null || set.isEmpty()) {
            return new HashSet<String>(16);
        }
        HashSet<String> result = new HashSet<String>(set.size());
        for (Object datas : set) {
            if (datas instanceof String) {
                result.add((String)datas);
                continue;
            }
            result.add(datas.toString());
        }
        return result;
    }

    public static DataSet genEcoBomDataByEntryId(Set<Long> ecoBomEntryIdSet) {
        String algoKey = EcoUtils.class.getName() + "_genEcoBomDataByEntryId";
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select a.fentryid as ecobomentryid ", new Object[0]);
        sb.append(" ,a.fentryrefnos as refno ", new Object[0]);
        sb.append(" ,a.fid as ecobomid ", new Object[0]);
        sb.append(" ,a.fentrygroupnos as groupno  ", new Object[0]);
        sb.append(" ,b.fentryid as ecobomentryid2 ", new Object[0]);
        sb.append(" ,b.fentryrefnos as refno2 ", new Object[0]);
        sb.append(" ,b.fentrygroupnos as groupno2  ", new Object[0]);
        sb.append(" ,c.fentryid as ecobomentryid3 ", new Object[0]);
        sb.append(" ,c.fentryrefnos as refno3 ", new Object[0]);
        sb.append(" from t_fmm_ecobomentry a ", new Object[0]);
        sb.append(" left outer join t_fmm_ecobomentry b on a.fid = b.fid and a.fbomentryid = b.fbomentryid and a.fentryid <> b.fentryid and a.fbomentryid > 0  ", new Object[0]);
        sb.append(" left outer join t_fmm_ecobomentry c on a.fid = c.fid and a.fentrygroupnos = c.fentrygroupnos and a.fentryid <> c.fentryid and c.fentrygroupnos <> ' '   ", new Object[0]);
        sb.append(" where ", new Object[0]);
        sb.appendIn("a.fentryid", ecoBomEntryIdSet.toArray());
        return DB.queryDataSet((String)algoKey, (DBRoute)scmDBRoute, (SqlBuilder)sb);
    }

    public static DataSet genEcoBomDataByRefNo(Set<String> refNoSet) {
        String algoKey = EcoUtils.class.getName() + "_genEcoBomDataByRefNo";
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select a.fentryid as ecobomentryid ", new Object[0]);
        sb.append(" ,a.fentrygroupnos as groupno  ", new Object[0]);
        sb.append(" from t_fmm_ecobomentry a ", new Object[0]);
        sb.append(" where ", new Object[0]);
        sb.appendIn("a.fentryrefnos", refNoSet.toArray());
        return DB.queryDataSet((String)algoKey, (DBRoute)scmDBRoute, (SqlBuilder)sb);
    }

    public static List<DynamicObject> updateRefDataActtime(Set<Long> ecoBomEntryIdSet, String fromType) {
        return EcoUtils.updateRefDataActtime(ecoBomEntryIdSet, fromType, "");
    }

    public static List<DynamicObject> updateRefDataActtime(Set<Long> ecoBomEntryIdSet, String fromType, String remark) {
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(16);
        String esremark1 = ResManager.loadKDString((String)"\u5b9e\u65bd\u65f6\u95f4\u6ee1\u8db3\u53d8\u66f4\u7c7b\u578b\u7684\u5904\u7406\u5929\u6570\u6761\u4ef6\uff0c\u8fd0\u7b97\u540e\u66f4\u65b0\u4e3a\u8bc4\u4f30\u5b8c\u6bd5\u3002", (String)"EcoUtils_9", (String)"mmc-pdm-business", (Object[])new Object[0]);
        String esremark2 = ResManager.loadKDString((String)"\u5b9e\u65bd\u65f6\u95f4\u4e0d\u6ee1\u8db3\u53d8\u66f4\u7c7b\u578b\u7684\u5904\u7406\u5929\u6570\u6761\u4ef6\uff0c\u8fd0\u7b97\u540e\u66f4\u65b0\u4e3a\u8bc4\u4f30\u4e2d\u3002", (String)"EcoUtils_10", (String)"mmc-pdm-business", (Object[])new Object[0]);
        String esremark3 = ResManager.loadKDString((String)"\u4f9d\u636e\u53d8\u66f4\u7c7b\u578b\u81ea\u52a8\u5b8c\u6210\u8bc4\u4f30\u3002", (String)"EcoUtils_11", (String)"mmc-pdm-business", (Object[])new Object[0]);
        HashSet<Long> execEndIdSet = new HashSet<Long>(16);
        Date currentDate = DateUtils.getEndOfDay((Date)new Date());
        HashSet<Long> extSet = new HashSet<Long>(16);
        HashMap<Long, Set<Long>> cacheAllRefIdMap = new HashMap<Long, Set<Long>>(16);
        Map<Long, DynamicObject> dataMap = EcoUtils.getKeyEcoBomEntry(ecoBomEntryIdSet, cacheAllRefIdMap);
        HashMap<Long, DynamicObject> ecoTypeMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> ecoBillMap = new HashMap<Long, DynamicObject>(16);
        ArrayList<DynamicObject> ecoRecordLogList = new ArrayList<DynamicObject>(16);
        HashMap<String, DynamicObject> ecoRecordLogMap = new HashMap<String, DynamicObject>(16);
        for (Map.Entry<Long, DynamicObject> entrys : dataMap.entrySet()) {
            Set<Long> allRefDataSet;
            DynamicObject keyDy = entrys.getValue();
            Long ecoBomEntryId = entrys.getKey();
            if (!execEndIdSet.add(ecoBomEntryId) || (allRefDataSet = EcoUtils.getAllEcoBomEntryIdSet(ecoBomEntryId, cacheAllRefIdMap)).isEmpty()) continue;
            DynamicObject[] refDyColl = EcoUtils.getAllEcoBomEntryDynamicObject(allRefDataSet);
            for (int i = 0; i < refDyColl.length; ++i) {
                String acttimevalidResult;
                DynamicObject updateDy = refDyColl[i];
                Long ecoBomId = updateDy.getLong("ecobomid");
                DynamicObject ecoBill = EcoUtils.getEcoBillDynamicObject(ecoBomId, ecoBillMap);
                DynamicObject ecoType = EcoUtils.getEcoType(ecoBill, ecoBomId, ecoTypeMap);
                DynamicObject ecoPEntry = EcoUtils.getEcoPEntry(ecoBill, ecoBomId);
                Date oldActtime = updateDy.getDate("acttime");
                String oldEstimateStatus = updateDy.getString("estimatestatus");
                boolean isAdjustActTime = EcoUtils.isAdjustActTime(ecoType);
                if (isAdjustActTime) {
                    updateDy.set("acttime", keyDy.get("acttime"));
                    if ("A".equals(updateDy.getString("entrymode"))) {
                        updateDy.set("entryvaliddate", keyDy.get("acttime"));
                    }
                }
                Long currentEcoBomEntryId = updateDy.getLong("entryid");
                Date beforeDate = null;
                if (ecoType != null) {
                    int extendDay = ecoType.getInt("estimatestatusday");
                    beforeDate = PlatformUtils.addDay((Date)currentDate, (int)extendDay);
                }
                String statustype = ecoType == null ? "B" : ecoType.getString("statustype");
                boolean isCurrent = ecoBomEntryIdSet.contains(currentEcoBomEntryId);
                if (beforeDate != null && "B".equals(statustype) && !"updatebom".equals(fromType) && (isCurrent && "auditecn".equals(fromType) || !"auditecn".equals(fromType))) {
                    if (updateDy.getDate("acttime").before(beforeDate)) {
                        updateDy.set("estimatestatus", (Object)"C");
                        updateDy.set("esremark", (Object)esremark1);
                    } else if (!updateDy.getString("estimatestatus").equals("C")) {
                        updateDy.set("estimatestatus", (Object)"B");
                        updateDy.set("esremark", (Object)esremark2);
                    }
                }
                if ("A".equals(statustype)) {
                    updateDy.set("estimatestatus", (Object)"C");
                    updateDy.set("esremark", (Object)esremark3);
                }
                if (isCurrent && "auditecn".equals(fromType) && "B".equals(statustype)) {
                    updateDy.set("estimatestatus", (Object)"A");
                    updateDy.set("esremark", (Object)"");
                }
                if (!StringUtils.isEmpty((String)(acttimevalidResult = ActTimeValidataBusiness.getInstance().checkValidData(EcoUtils.genActtimeBean(updateDy, ecoBill, refDyColl))))) {
                    throw new KDBizException(acttimevalidResult);
                }
                EcoUtils.setMinActtime(updateDy);
                execEndIdSet.add(currentEcoBomEntryId);
                extSet.add(currentEcoBomEntryId);
                PlatformUtils.addList(updateList, (DynamicObject)updateDy);
                if (!EcoUtils.isDiff(updateDy, oldActtime, oldEstimateStatus) || ecoPEntry == null) continue;
                String logRemark = AddEcoLogUtils.getLogRemark(fromType, ecoBomEntryIdSet, updateDy, remark);
                AddEcoLogUtils.addEcoLogByActtime(updateDy, ecoBill, ecoPEntry, ecoRecordLogMap, ecoRecordLogList, logRemark, oldActtime, oldEstimateStatus);
            }
        }
        if (!updateList.isEmpty()) {
            List<DynamicObject> pointList = EcoUtils.updateContinuityPointEcnData(updateList, fromType, execEndIdSet);
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]), (OperateOption)OperateOption.create());
            if (!PlatformUtils.isNullList(pointList)) {
                EcoUtils.updateRefDataByPoint(pointList, execEndIdSet, updateList);
            }
        }
        if (!ecoRecordLogList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])ecoRecordLogList.toArray(new DynamicObject[ecoRecordLogList.size()]), (OperateOption)OperateOption.create());
        }
        if (!extSet.isEmpty()) {
            EcoEstimateStatusUpdateUtils.addEsEndRecord(extSet);
            String extClassPlugin = PdmParamSetHelper.getStringParamValue((String)"ECNEstimateEndExecPlugin");
            if (!StringUtils.isEmpty((String)extClassPlugin)) {
                try {
                    Object object = Class.forName(extClassPlugin).newInstance();
                    if (AbstractEstimateEndExtPlugin.class.isInstance(object)) {
                        long startTime = System.currentTimeMillis();
                        String extResult = ((AbstractEstimateEndExtPlugin)object).exec(extSet);
                        long exextimelong = System.currentTimeMillis() - startTime;
                        log.info(" end exec extplugin:" + extClassPlugin + ",extResult=" + extResult + ",costs=" + exextimelong + "ms");
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    log.error((Throwable)e);
                }
            }
        }
        return updateList;
    }

    public static void updateRefDataByPoint(List<DynamicObject> pointList, Set<Long> execEndIdSet, List<DynamicObject> allUpdateList) {
        String extClassPlugin;
        boolean isOpenCP;
        if (execEndIdSet == null) {
            execEndIdSet = new HashSet<Long>(16);
        }
        if (!(isOpenCP = PdmParamSetHelper.getBooleanParamValue((String)"ECNOpeContinuesPoint"))) {
            return;
        }
        HashMap<Long, Set<Long>> cacheAllRefIdMap = new HashMap<Long, Set<Long>>(16);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(16);
        HashSet<Long> extSet = new HashSet<Long>(16);
        HashMap<Long, DynamicObject> ecoBillMap = new HashMap<Long, DynamicObject>(16);
        ArrayList<DynamicObject> ecoRecordLogList = new ArrayList<DynamicObject>(16);
        HashMap<String, DynamicObject> ecoRecordLogMap = new HashMap<String, DynamicObject>(16);
        HashMap<Long, DynamicObject> ecoTypeMap = new HashMap<Long, DynamicObject>(16);
        String logRemark = ResManager.loadKDString((String)"\u8fde\u7eed\u65ad\u70b9\u66f4\u65b0\u5173\u8054\u884c\u7684\u5b9e\u65bd\u65f6\u95f4\u53ca\u8bc4\u4f30\u72b6\u6001\u3002", (String)"EcoUtils_08", (String)"mmc-pdm-business", (Object[])new Object[0]);
        for (DynamicObject dy : pointList) {
            String esRemark = dy.getString("esremark");
            Date acttime = dy.getDate("acttime");
            Long ecoBomEntryId = dy.getLong("entryid");
            if (!execEndIdSet.add(ecoBomEntryId)) continue;
            String pointEstimateStatus = dy.getString("estimatestatus");
            Set<Long> allRefDataSet = EcoUtils.getAllEcoBomEntryIdSet(ecoBomEntryId, cacheAllRefIdMap);
            if (allRefDataSet.isEmpty()) continue;
            DynamicObject[] refDyColl = EcoUtils.getAllEcoBomEntryDynamicObject(allRefDataSet);
            for (int i = 0; i < refDyColl.length; ++i) {
                DynamicObject updateDy = refDyColl[i];
                if ("C".equals(updateDy.getString("estimatestatus"))) continue;
                Long ecoBomId = updateDy.getLong("ecobomid");
                DynamicObject ecoBill = EcoUtils.getEcoBillDynamicObject(ecoBomId, ecoBillMap);
                DynamicObject ecoPEntry = EcoUtils.getEcoPEntry(ecoBill, ecoBomId);
                Date oldActtime = updateDy.getDate("acttime");
                String oldEstimateStatus = updateDy.getString("estimatestatus");
                DynamicObject ecoType = EcoUtils.getEcoType(ecoBill, ecoBomId, ecoTypeMap);
                boolean isAdjustActTime = EcoUtils.isAdjustActTime(ecoType);
                if (isAdjustActTime) {
                    updateDy.set("acttime", (Object)acttime);
                    if ("A".equals(updateDy.getString("entrymode"))) {
                        updateDy.set("entryvaliddate", (Object)acttime);
                    }
                }
                if ("C".equals(pointEstimateStatus)) {
                    updateDy.set("estimatestatus", (Object)"C");
                }
                updateDy.set("esremark", (Object)esRemark);
                String acttimevalidResult = ActTimeValidataBusiness.getInstance().checkValidData(EcoUtils.genActtimeBean(updateDy, ecoBill, refDyColl));
                if (!StringUtils.isEmpty((String)acttimevalidResult)) {
                    throw new KDBizException(acttimevalidResult);
                }
                EcoUtils.setMinActtime(updateDy);
                execEndIdSet.add(updateDy.getLong("entryid"));
                extSet.add(updateDy.getLong("entryid"));
                PlatformUtils.addList(updateList, (DynamicObject)updateDy);
                if (!EcoUtils.isDiff(updateDy, oldActtime, oldEstimateStatus) || ecoPEntry == null) continue;
                AddEcoLogUtils.addEcoLogByActtime(updateDy, ecoBill, ecoPEntry, ecoRecordLogMap, ecoRecordLogList, logRemark, oldActtime, oldEstimateStatus);
            }
        }
        if (!updateList.isEmpty()) {
            List<DynamicObject> pointList2 = EcoUtils.updateContinuityPointEcnData(updateList, "", execEndIdSet);
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]), (OperateOption)OperateOption.create());
            if (!PlatformUtils.isNullList(pointList2)) {
                EcoUtils.updateRefDataByPoint(pointList2, execEndIdSet, allUpdateList);
            }
        }
        if (!extSet.isEmpty()) {
            EcoEstimateStatusUpdateUtils.addEsEndRecord(extSet);
        }
        if (!ecoRecordLogList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])ecoRecordLogList.toArray(new DynamicObject[ecoRecordLogList.size()]), (OperateOption)OperateOption.create());
        }
        if (!StringUtils.isEmpty((String)(extClassPlugin = PdmParamSetHelper.getStringParamValue((String)"ECNEstimateEndExecPlugin")))) {
            try {
                Object object = Class.forName(extClassPlugin).newInstance();
                if (AbstractEstimateEndExtPlugin.class.isInstance(object)) {
                    long startTime = System.currentTimeMillis();
                    String extResult = ((AbstractEstimateEndExtPlugin)object).exec(extSet);
                    long exextimelong = System.currentTimeMillis() - startTime;
                    log.info(" end exec extplugin:" + extClassPlugin + ",extResult=" + extResult + ",costs=" + exextimelong + "ms");
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.error((Throwable)e);
            }
        }
        if (!updateList.isEmpty()) {
            for (DynamicObject dyadd : updateList) {
                PlatformUtils.addList(allUpdateList, (DynamicObject)dyadd);
            }
        }
    }

    private static String getMftBomEntrySelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("entryid ");
        sb.append(",entryvaliddate ");
        sb.append(",entryinvaliddate ");
        sb.append(",entrymaterialid ");
        sb.append(",bomid");
        sb.append(",entryseq");
        return sb.toString();
    }

    public static Map<Long, DynamicObject> getMftBomEntryData(Set<Long> mftBomEntryIdSet) {
        DynamicObject[] coll;
        if (mftBomEntryIdSet.isEmpty()) {
            return new HashMap<Long, DynamicObject>(16);
        }
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(mftBomEntryIdSet.size());
        QFilter filter = new QFilter("entryid", "in", mftBomEntryIdSet);
        QFilter[] qFilters = new QFilter[]{filter};
        String selectProperties = EcoUtils.getMftBomEntrySelectProperties();
        for (DynamicObject dy : coll = BusinessDataServiceHelper.load((String)"pdm_mftbomentry", (String)selectProperties, (QFilter[])qFilters)) {
            dataMap.put(dy.getLong("entryid"), dy);
        }
        return dataMap;
    }

    public static Set<Long> getMftBomEntryByECN(List<DynamicObject> ecoBomEntryList) {
        int size = ecoBomEntryList.size();
        HashSet<Long> mftBomEntryIdSet = new HashSet<Long>(size);
        for (int i = 0; i < size; ++i) {
            DynamicObject ecoBomEntry = ecoBomEntryList.get(i);
            Long oldMftBomEntryId = ecoBomEntry.getLong("entrybomentryid");
            Long newMftBomEntryId = ecoBomEntry.getLong("bomentry");
            if ("A".equals(ecoBomEntry.getString("entrymode"))) {
                if (PlatformUtils.isNullLong((Long)newMftBomEntryId)) continue;
                mftBomEntryIdSet.add(newMftBomEntryId);
                continue;
            }
            if (!PlatformUtils.isNullLong((Long)newMftBomEntryId)) {
                mftBomEntryIdSet.add(newMftBomEntryId);
            }
            if (PlatformUtils.isNullLong((Long)oldMftBomEntryId)) continue;
            mftBomEntryIdSet.add(oldMftBomEntryId);
        }
        return mftBomEntryIdSet;
    }

    public static List<DynamicObject> updateMftBomData(List<DynamicObject> ecoBomEntryList, String fromType) {
        if (ecoBomEntryList == null || ecoBomEntryList.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Long> mftBomEntryIdSet = EcoUtils.getMftBomEntryByECN(ecoBomEntryList);
        Map<Long, DynamicObject> mftBomEntryDataMap = EcoUtils.getMftBomEntryData(mftBomEntryIdSet);
        int size = ecoBomEntryList.size();
        ArrayList<DynamicObject> updateMftBomEntryList = new ArrayList<DynamicObject>(size);
        HashMap<Long, Boolean> cacheMap = new HashMap<Long, Boolean>(16);
        HashSet<String> execedIdSet = new HashSet<String>(16);
        HashMap<Long, DynamicObject> ecoBillCacheMap = new HashMap<Long, DynamicObject>(16);
        HashSet<Long> mftBomIds = new HashSet<Long>(16);
        HashMap<Long, ArrayList<Long>> orgBomIdMap = new HashMap<Long, ArrayList<Long>>(16);
        String ecnbillno = "";
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        for (int i = 0; i < size; ++i) {
            Date lastActtime;
            DynamicObject ecoBomEntry = ecoBomEntryList.get(i);
            Long ecoBomId = ecoBomEntry.getLong("ecobomid");
            boolean isAuditStatus = EcoUtils.checkEcoIsAudit(ecoBomId, cacheMap);
            if (!isAuditStatus) continue;
            Long mftBomEntryId = ecoBomEntry.getLong("entrybomentryid");
            Long mftBomEntryAfterId = ecoBomEntry.getLong("bomentry");
            String entrymode = ecoBomEntry.getString("entrymode");
            Date acttime = ecoBomEntry.getDate("acttime");
            if (acttime == null) continue;
            DynamicObject beforeMftBomEntry = mftBomEntryDataMap.get(mftBomEntryId);
            if (beforeMftBomEntry == null) {
                mftBomEntryId = mftBomEntryAfterId;
                beforeMftBomEntry = mftBomEntryDataMap.get(mftBomEntryId);
            }
            Long bomId = 0L;
            DynamicObject afterMftBomEntry = null;
            if ("B".equals(entrymode) && !mftBomEntryAfterId.equals(mftBomEntryId)) {
                afterMftBomEntry = mftBomEntryDataMap.get(mftBomEntryAfterId);
            }
            if ("C".equals(entrymode) && !mftBomEntryAfterId.equals(0L)) {
                afterMftBomEntry = mftBomEntryDataMap.get(mftBomEntryAfterId);
            }
            if (beforeMftBomEntry != null && "A".equals(entrymode) && acttime != null && execedIdSet.add("entryvaliddate" + beforeMftBomEntry.getLong("id")) && PlatformUtils.isDiffDate((Date)beforeMftBomEntry.getDate("entryvaliddate"), (Date)acttime)) {
                beforeMftBomEntry.set("entryvaliddate", (Object)acttime);
                EcoUtils.checkMftBomValiDate(beforeMftBomEntry, ecoBomEntry);
                PlatformUtils.addList(updateMftBomEntryList, (DynamicObject)beforeMftBomEntry);
                bomId = beforeMftBomEntry.getLong("bomid");
            }
            if (beforeMftBomEntry != null && "E".equals(entrymode) && acttime != null && execedIdSet.add("entryinvaliddate" + beforeMftBomEntry.getLong("id"))) {
                lastActtime = PlatformUtils.addSecond((Date)acttime, (int)-1);
                if (PlatformUtils.isDiffDate((Date)beforeMftBomEntry.getDate("entryinvaliddate"), (Date)lastActtime)) {
                    beforeMftBomEntry.set("entryinvaliddate", (Object)lastActtime);
                    EcoUtils.checkMftBomValiDate(beforeMftBomEntry, ecoBomEntry);
                    PlatformUtils.addList(updateMftBomEntryList, (DynamicObject)beforeMftBomEntry);
                    bomId = beforeMftBomEntry.getLong("bomid");
                }
            }
            if ("B".equals(entrymode) && acttime != null) {
                if (afterMftBomEntry != null && execedIdSet.add("entryvaliddate" + afterMftBomEntry.getLong("id")) && PlatformUtils.isDiffDate((Date)afterMftBomEntry.getDate("entryvaliddate"), (Date)acttime)) {
                    afterMftBomEntry.set("entryvaliddate", (Object)acttime);
                    EcoUtils.checkMftBomValiDate(afterMftBomEntry, ecoBomEntry);
                    PlatformUtils.addList(updateMftBomEntryList, (DynamicObject)afterMftBomEntry);
                    bomId = afterMftBomEntry.getLong("bomid");
                }
                lastActtime = PlatformUtils.addSecond((Date)acttime, (int)-1);
                if (beforeMftBomEntry != null && execedIdSet.add("entryinvaliddate" + beforeMftBomEntry.getLong("id")) && PlatformUtils.isDiffDate((Date)beforeMftBomEntry.getDate("entryinvaliddate"), (Date)lastActtime)) {
                    beforeMftBomEntry.set("entryinvaliddate", (Object)lastActtime);
                    EcoUtils.checkMftBomValiDate(beforeMftBomEntry, ecoBomEntry);
                    PlatformUtils.addList(updateMftBomEntryList, (DynamicObject)beforeMftBomEntry);
                    bomId = beforeMftBomEntry.getLong("bomid");
                }
            }
            if ("C".equals(entrymode) && acttime != null && afterMftBomEntry != null && execedIdSet.add("entryvaliddate" + afterMftBomEntry.getLong("id")) && PlatformUtils.isDiffDate((Date)afterMftBomEntry.getDate("entryvaliddate"), (Date)acttime)) {
                afterMftBomEntry.set("entryvaliddate", (Object)acttime);
                EcoUtils.checkMftBomValiDate(afterMftBomEntry, ecoBomEntry);
                PlatformUtils.addList(updateMftBomEntryList, (DynamicObject)afterMftBomEntry);
                bomId = afterMftBomEntry.getLong("bomid");
            }
            if (bomId.equals(0L) || !mftBomIds.add(bomId)) continue;
            DynamicObject ecoBill = EcoUtils.getEcoBillDynamicObject(ecoBomId, ecoBillCacheMap);
            Long orgId = ecoBill.getDynamicObject("org").getLong("id");
            ArrayList<Long> bomIdList = (ArrayList<Long>)orgBomIdMap.get(orgId);
            if (bomIdList == null) {
                bomIdList = new ArrayList<Long>(16);
            }
            bomIdList.add(bomId);
            orgBomIdMap.put(orgId, bomIdList);
            ecnbillno = ecoBill.getString("billno");
            orgIdSet.add(orgId);
        }
        if (!updateMftBomEntryList.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateMftBomEntryList.toArray(new DynamicObject[updateMftBomEntryList.size()]), (OperateOption)OperateOption.create());
            EcoUtils.updateMftBomModifyer(updateMftBomEntryList);
            if (!"estimatecompute".equals(fromType) && !"auditecn".equals(fromType)) {
                for (Long orgId : orgIdSet) {
                    EcoUtils.refreshBaseDataCache("pdm_mftbom", orgId);
                }
            }
            if (!mftBomIds.isEmpty()) {
                for (Map.Entry boms : orgBomIdMap.entrySet()) {
                    BomSyncCostUtils.syncCost((Long)((Long)boms.getKey()), (List)((List)boms.getValue()), (String)ecnbillno, (String)"");
                }
            }
        }
        return updateMftBomEntryList;
    }

    public static boolean chkSyncCostBom(Long orgId, Map<Long, Boolean> dataCacheMap) {
        if (dataCacheMap.containsKey(orgId)) {
            return dataCacheMap.get(orgId);
        }
        boolean flag = PDMAppParamLoadUtil.isSyncCostBom((long)orgId);
        dataCacheMap.put(orgId, flag);
        return flag;
    }

    public static void checkMftBomValiDate(DynamicObject mftBomEntry, DynamicObject ecoBomEntry) {
        Date entryvaliddate = mftBomEntry.getDate("entryvaliddate");
        Date entryinvaliddate = mftBomEntry.getDate("entryinvaliddate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (sdf.format(entryvaliddate).compareTo(sdf.format(entryinvaliddate)) > 0) {
            String bomNumber = EcoUtils.getBomNumber(mftBomEntry.getLong("bomid"));
            String materialNumber = EcoUtils.getMaterialNumber(mftBomEntry, "entrymaterialid");
            HashMap<String, Object> cacheMap = new HashMap<String, Object>(16);
            String ecoBillNumber = EcoUtils.getEcoBillNo(ecoBomEntry.getLong("ecobomid"), cacheMap);
            String errorStr = "";
            errorStr = !StringUtils.isEmpty((String)materialNumber) ? String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u201c%1$s\u201d\u5bf9\u5e94\u7684BOM\u7f16\u7801\u201c%2$s\u201d\u4e0b\u7684\u7ec4\u4ef6\u5e8f\u53f7\u201c%3$s\u201d\uff0c\u751f\u6548\u65f6\u95f4\u201c%4$s\u201d\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u5931\u6548\u65f6\u95f4\u201c%5$s\u201d\u3002", (String)"EcoUtils_12", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, bomNumber, materialNumber, sdf.format(entryvaliddate), sdf.format(entryinvaliddate)) : String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u201c%1$s\u201d\u5bf9\u5e94\u7684BOM\u7f16\u7801\u201c%2$s\u201d\u4e0b\u7684\u7ec4\u4ef6\u5e8f\u53f7\u201c%3$s\u201d\uff0c\u751f\u6548\u65f6\u95f4\u201c%4$s\u201d\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u5931\u6548\u65f6\u95f4\u201c%5$s\u201d\u3002", (String)"EcoUtils_13", (String)"mmc-pdm-business", (Object[])new Object[0]), ecoBillNumber, bomNumber, mftBomEntry.getLong("entryseq"), sdf.format(entryvaliddate), sdf.format(entryinvaliddate));
            throw new KDBizException(errorStr);
        }
    }

    public static String getBomNumber(Long bomId) {
        DynamicObject bom = BusinessDataServiceHelper.loadSingle((Object)bomId, (String)"pdm_mftbom", (String)"id,number");
        return bom.getString("number");
    }

    public static Map<Long, DynamicObject> getKeyEcoBomEntry(Set<Long> ecoBomEntryIdSet, Map<Long, Set<Long>> cacheAllRefIdMap) {
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(ecoBomEntryIdSet.size());
        HashMap<Long, DynamicObject> allDataMap = new HashMap<Long, DynamicObject>(ecoBomEntryIdSet.size());
        for (Long ecoBomEntryId : ecoBomEntryIdSet) {
            DynamicObject keyDy = (DynamicObject)allDataMap.get(ecoBomEntryId);
            if (keyDy != null) {
                dataMap.put(ecoBomEntryId, keyDy);
                continue;
            }
            Set<Long> allIdSet = EcoUtils.getAllEcoBomEntryIdSet(ecoBomEntryId, cacheAllRefIdMap);
            if (PlatformUtils.isNullSet(allIdSet)) {
                allIdSet = new HashSet<Long>(16);
                allIdSet.add(ecoBomEntryId);
            }
            DynamicObject[] dycoll = EcoUtils.getAllEcoBomEntryDynamicObject(allIdSet);
            keyDy = EcoUtils.findKeyDynamicObject(dycoll);
            dataMap.put(ecoBomEntryId, keyDy);
            for (Long id : allIdSet) {
                allDataMap.put(id, keyDy);
            }
        }
        return dataMap;
    }

    public static DynamicObject findKeyDynamicObject(DynamicObject[] dycoll) {
        DynamicObject entry;
        int i;
        int size = dycoll.length;
        if (size == 1) {
            return dycoll[0];
        }
        DynamicObject keyDy = null;
        for (i = 0; i < size; ++i) {
            entry = dycoll[i];
            if (!entry.getBoolean("refkey")) continue;
            String groupNo = entry.getString("entrygroupno");
            if (!PlatformUtils.isNullString((String)groupNo)) {
                String groupKeyString = PlatformUtils.getUnionString((Object)entry.getLong("ecobomid"), (Object)groupNo);
                keyDy = EcoUtils.findGroupKeyDynamicObject(dycoll, groupKeyString);
                if (keyDy != null) break;
                keyDy = entry;
                break;
            }
            keyDy = entry;
            break;
        }
        if (keyDy == null) {
            for (i = 0; i < size; ++i) {
                entry = dycoll[i];
                if (!entry.getBoolean("groupkey")) continue;
                keyDy = entry;
                break;
            }
        }
        if (keyDy == null) {
            for (i = 0; i < size; ++i) {
                entry = dycoll[i];
                String entrymode = entry.getString("entrymode");
                if (!"B".equals(entrymode)) continue;
                keyDy = entry;
                break;
            }
        }
        if (keyDy == null) {
            keyDy = dycoll[0];
        }
        return keyDy;
    }

    public static DynamicObject findGroupKeyDynamicObject(DynamicObject[] dycoll, String groupKeyString) {
        for (DynamicObject entry : dycoll) {
            String groupKeyString2;
            String groupNo = entry.getString("entrygroupno");
            if (PlatformUtils.isNullString((String)groupNo) || !(groupKeyString2 = PlatformUtils.getUnionString((Object)entry.getLong("ecobomid"), (Object)groupNo)).equals(groupKeyString) || !entry.getBoolean("groupkey")) continue;
            return entry;
        }
        return null;
    }

    public static Set<Long> getAllEcoBomEntryIdSet(Long ecoBomEntryId, Map<Long, Set<Long>> cacheAllRefIdMap) {
        Set<Long> allRefIdSet = null;
        if (cacheAllRefIdMap != null && (allRefIdSet = cacheAllRefIdMap.get(ecoBomEntryId)) != null) {
            return allRefIdSet;
        }
        HashSet<Long> ecoBomEntryIdSet = new HashSet<Long>(16);
        ecoBomEntryIdSet.add(ecoBomEntryId);
        allRefIdSet = EcoUtils.getAllEcoBomEntryIdSet(ecoBomEntryIdSet);
        if (cacheAllRefIdMap != null) {
            cacheAllRefIdMap.put(ecoBomEntryId, allRefIdSet);
        }
        return allRefIdSet;
    }

    public static Set<Long> getAllEcoBomEntryIdSet(Set<Long> ecoBomEntryIdSet) {
        Long ecobomentryid;
        Row arow3;
        Throwable throwable;
        DataSet ds;
        Long ecobomentryid2;
        if (PlatformUtils.isNullSet(ecoBomEntryIdSet)) {
            return new HashSet<Long>(16);
        }
        HashSet<Long> allEcoBomEntryIdSet = new HashSet<Long>(64);
        HashSet<String> refNoSet = new HashSet<String>(16);
        try (DataSet ds2 = EcoUtils.genEcoBomDataByEntryId(ecoBomEntryIdSet);){
            while (ds2.hasNext()) {
                Row arow2 = ds2.next();
                Long ecobomentryid3 = arow2.getLong("ecobomentryid");
                String refno = arow2.getString("refno");
                ecobomentryid2 = arow2.getLong("ecobomentryid2");
                String refno2 = arow2.getString("refno2");
                Long ecobomentryid32 = arow2.getLong("ecobomentryid3");
                String refno3 = arow2.getString("refno3");
                allEcoBomEntryIdSet.add(ecobomentryid3);
                if (!PlatformUtils.isNullLong((Long)ecobomentryid2)) {
                    allEcoBomEntryIdSet.add(ecobomentryid2);
                }
                if (!PlatformUtils.isNullLong((Long)ecobomentryid32)) {
                    allEcoBomEntryIdSet.add(ecobomentryid32);
                }
                if (!PlatformUtils.isNullString((String)refno)) {
                    refNoSet.add(refno);
                }
                if (!PlatformUtils.isNullString((String)refno2)) {
                    refNoSet.add(refno2);
                }
                if (PlatformUtils.isNullString((String)refno3)) continue;
                refNoSet.add(refno3);
            }
        }
        HashSet<Long> refNoEcoBomEntryIdSet = new HashSet<Long>(16);
        if (refNoSet != null && !refNoSet.isEmpty()) {
            ds = EcoUtils.genEcoBomDataByRefNo(refNoSet);
            throwable = null;
            try {
                while (ds.hasNext()) {
                    arow3 = ds.next();
                    ecobomentryid = arow3.getLong("ecobomentryid");
                    if (allEcoBomEntryIdSet.contains(ecobomentryid)) continue;
                    allEcoBomEntryIdSet.add(ecobomentryid);
                    String groupno = arow3.getString("groupno");
                    if (PlatformUtils.isNullString((String)groupno)) continue;
                    refNoEcoBomEntryIdSet.add(ecobomentryid);
                }
            }
            catch (Throwable arow3) {
                throwable = arow3;
                throw arow3;
            }
            finally {
                if (ds != null) {
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable arow3) {
                            throwable.addSuppressed(arow3);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        if (refNoEcoBomEntryIdSet != null && !refNoEcoBomEntryIdSet.isEmpty()) {
            ds = EcoUtils.genEcoBomDataByEntryId(refNoEcoBomEntryIdSet);
            throwable = null;
            try {
                while (ds.hasNext()) {
                    arow3 = ds.next();
                    ecobomentryid = arow3.getLong("ecobomentryid");
                    allEcoBomEntryIdSet.add(ecobomentryid);
                    ecobomentryid2 = arow3.getLong("ecobomentryid2");
                    Long ecobomentryid3 = arow3.getLong("ecobomentryid3");
                    if (!PlatformUtils.isNullLong((Long)ecobomentryid2)) {
                        allEcoBomEntryIdSet.add(ecobomentryid2);
                    }
                    if (PlatformUtils.isNullLong((Long)ecobomentryid3)) continue;
                    allEcoBomEntryIdSet.add(ecobomentryid3);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds != null) {
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        return allEcoBomEntryIdSet;
    }

    public static DynamicObject[] getAllEcoBomEntryDynamicObject(Set<Long> ecoBomEntryIdSet) {
        QFilter filter = new QFilter("entryid", "in", ecoBomEntryIdSet);
        String selectProperties = EcoUtils.getEcoBomEntryDataSelectProperties();
        return BusinessDataServiceHelper.load((String)"pdm_ecobom_entryf7", (String)selectProperties, (QFilter[])new QFilter[]{filter});
    }

    public static Set<Long> getEcoBomEntryById(Set<Long> ecoBomIdSet) {
        QFilter filter = new QFilter("ecobomid", "in", ecoBomIdSet);
        DynamicObject[] coll = BusinessDataServiceHelper.load((String)"pdm_ecobom_entryf7", (String)"entryid", (QFilter[])new QFilter[]{filter});
        HashSet<Long> ecoBomEntryIdSet = new HashSet<Long>(16);
        if (coll == null || coll.length < 1) {
            return ecoBomEntryIdSet;
        }
        for (int i = 0; i < coll.length; ++i) {
            ecoBomEntryIdSet.add(coll[i].getLong("entryid"));
        }
        return ecoBomEntryIdSet;
    }

    public static DynamicObject getEcoBomEntryByEntryId(Long entryId) {
        QFilter filter = new QFilter("entryid", "=", (Object)entryId);
        String selectProperties = EcoUtils.getEcoBomEntryDataSelectProperties();
        return BusinessDataServiceHelper.loadSingle((String)"pdm_ecobom_entryf7", (String)selectProperties, (QFilter[])new QFilter[]{filter});
    }

    private static String getECOBillSelectFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("id  ");
        sb.append(",org  ");
        sb.append(",billno  ");
        sb.append(",name  ");
        sb.append(",billstatus  ");
        sb.append(",changetype  ");
        sb.append(",pentry.ecobomid  ");
        sb.append(",pentry.id ");
        sb.append(",pentry.pentrybom ");
        sb.append(",pentry.pentryroute ");
        sb.append(",pentry.ecotype ");
        sb.append(",pentry.proentrymaterial ");
        sb.append(",pentry.proentrymaterialid ");
        return sb.toString();
    }

    private static boolean isBomChange(DynamicObject changeBill) {
        return "A".equals(changeBill.getString("changetype"));
    }

    private static boolean isRouteChange(DynamicObject changeBill) {
        return "B".equals(changeBill.getString("changetype"));
    }

    public static DynamicObject getEcoPEntry(DynamicObject changeBill, Long ecoBomId) {
        DynamicObjectCollection pcoll = changeBill.getDynamicObjectCollection("pentry");
        boolean isRouteChange = EcoUtils.isRouteChange(changeBill);
        boolean isBomChange = EcoUtils.isBomChange(changeBill);
        for (int i = 0; i < pcoll.size(); ++i) {
            DynamicObject entry = (DynamicObject)pcoll.get(i);
            Long currentEcoBomId = isBomChange ? entry.getLong("ecobomid") : (isRouteChange ? entry.getLong("ecorouteid") : 0L);
            if (!ecoBomId.equals(currentEcoBomId)) continue;
            return entry;
        }
        return null;
    }

    public static DynamicObject[] getEcoChangeBillData(Set<Long> ecoBomIdSet) {
        QFilter filter = new QFilter("pentry.ecobomid", "in", ecoBomIdSet);
        QFilter[] qFilters = new QFilter[]{filter};
        return BusinessDataServiceHelper.load((String)"pdm_bom_eco", (String)EcoUtils.getECOBillSelectFields(), (QFilter[])qFilters);
    }

    private static String getEcoBomEntryDataSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append(" entryid ");
        sb.append(",entrymode ");
        sb.append(",entrymaterial ");
        sb.append(",featuretype ");
        sb.append(",entryunit ");
        sb.append(",tranqty ");
        sb.append(",transtartdate ");
        sb.append(",acttime ");
        sb.append(",minacttime ");
        sb.append(",entryvaliddate ");
        sb.append(",entryinvaliddate ");
        sb.append(",entryqtynumerator ");
        sb.append(",entryqtydenominator ");
        sb.append(",entryfixscrap ");
        sb.append(",entryscraprate ");
        sb.append(",entryconfiguredcode ");
        sb.append(",entryqtytype ");
        sb.append(",entryauxproperty ");
        sb.append(",bomentry ");
        sb.append(",entrybomentryid ");
        sb.append(",ecobomid ");
        sb.append(",entrygroupno ");
        sb.append(",entryrefno ");
        sb.append(",estimatestatus ");
        sb.append(",esremark ");
        sb.append(",groupkey ");
        sb.append(",refkey ");
        sb.append(",entryseq ");
        sb.append(",continuouspoint ");
        sb.append(",iscanestimate ");
        return sb.toString();
    }

    public static boolean checkHasGroupKey(Long pentryId, String groupNo, Set<Long> includeIdSet) {
        StringBuilder sb = new StringBuilder();
        sb.append(" select");
        sb.append(" a.fentryid as fecobomentryid ");
        sb.append(" from t_fmm_ecobomentry a ");
        sb.append(" inner join t_pdm_bomecopentry b on a.fid = b.fecobomid ");
        sb.append(" where  b.fentryid = ? ");
        sb.append(" and  a.fentrygroupnos = ? ");
        sb.append(" and  a.fgroupkey = '1' ");
        boolean isfind = false;
        try (DataSet ds = DB.queryDataSet((String)(EcoUtils.class.getName() + "_checkHasGroupKey"), (DBRoute)scmDBRoute, (String)sb.toString(), (Object[])new Object[]{pentryId, groupNo});){
            for (Row row : ds) {
                Long fecobomentryid = row.getLong("fecobomentryid");
                if (includeIdSet != null && includeIdSet.contains(fecobomentryid)) continue;
                isfind = true;
            }
        }
        return isfind;
    }

    public static boolean checkHasRefKey(String refno, Set<Long> includeIdSet) {
        StringBuilder sb = new StringBuilder();
        sb.append(" select ");
        sb.append(" a.fentryid as fecobomentryid ");
        sb.append(" from t_fmm_ecobomentry a ");
        sb.append(" where  a.fentryrefnos = ? ");
        sb.append(" and  a.frefkey = '1' ");
        boolean isfind = false;
        try (DataSet ds = DB.queryDataSet((String)(EcoUtils.class.getName() + "_checkHasRefKey"), (DBRoute)scmDBRoute, (String)sb.toString(), (Object[])new Object[]{refno});){
            for (Row row : ds) {
                Long fecobomentryid = row.getLong("fecobomentryid");
                if (includeIdSet != null && includeIdSet.contains(fecobomentryid)) continue;
                isfind = true;
            }
        }
        return isfind;
    }

    public static Map<String, Object> getEcnBomEntryNoEnd(Set<Long> mftBomEntryId, Long ecoBillId) {
        if (mftBomEntryId == null || mftBomEntryId.isEmpty()) {
            return new HashMap<String, Object>(16);
        }
        HashMap<String, Object> refMap = new HashMap<String, Object>(16);
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" h.fid ", new Object[0]);
        sb.append(",h.fbillno ", new Object[0]);
        sb.append(",d2.fbomentryid as fbomentryid ", new Object[0]);
        sb.append(",d2.fmaterialid as fmaterialid ", new Object[0]);
        sb.append(",d2.fentrymatid as fentrymatid ", new Object[0]);
        sb.append(",d2.ffeaturetype as ffeaturetype ", new Object[0]);
        sb.append(",d2.ftype as fentrytype ", new Object[0]);
        sb.append(" from t_pdm_bom_eco h ", new Object[0]);
        sb.append(" inner join t_pdm_bomecopentry d on h.fid = d.fid  ", new Object[0]);
        sb.append(" inner join t_fmm_ecobomentry d2 on d2.fid = d.fecobomid  ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("d2.fbomentryid", mftBomEntryId.toArray());
        sb.append(" and d2.festimatestatus <> 'C'  ", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)(EcoUtils.class.getName() + "_getRefEcoBomKeyActtime"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                Long thisEcoId = row.getLong("fid");
                if (ecoBillId != null && thisEcoId.equals(ecoBillId)) continue;
                String ecoBillNo = row.getString("fbillno");
                String fentrytype = row.getString("fentrytype");
                String entrydesc = "";
                if ("A".equals(fentrytype)) {
                    Long fmaterialid = row.getLong("fmaterialid");
                    if (fmaterialid == null || fmaterialid.equals(0L)) {
                        fmaterialid = row.getLong("fentrymatid");
                        DynamicObject material = MaterialQueryHelper.getDataCacheByID((Object)fmaterialid);
                        entrydesc = material.getString("number");
                    } else {
                        DynamicObject material = MaterialMftQueryHelper.getDataCacheByID((Object)fmaterialid);
                        entrydesc = material.getDynamicObject("masterid").getString("number");
                    }
                } else {
                    Long ffeaturetype = row.getLong("ffeaturetype");
                    DynamicObject ft = BusinessDataServiceHelper.loadSingleFromCache((Object)ffeaturetype, (String)"mpdm_featuretype");
                    entrydesc = ft.getString("name");
                }
                refMap.put("ecobillno", ecoBillNo);
                refMap.put("entrydesc", entrydesc);
                refMap.put("bomentryid", row.getLong("fbomentryid"));
                break;
            }
        }
        return refMap;
    }

    public static Map<String, Map<String, String>> getOtherGroupNos(Set<Long> pentryIdSet, Set<Long> excludeBomEntryIdSet, Set<Long> noGroupNoEntryIdSet) {
        if (pentryIdSet == null || pentryIdSet.isEmpty()) {
            return new HashMap<String, Map<String, String>>(16);
        }
        HashMap<String, Map<String, String>> typeMap = new HashMap<String, Map<String, String>>(16);
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" b.fentryid as fpentryid ", new Object[0]);
        sb.append(",a.fentryid as fecobomentryid ", new Object[0]);
        sb.append(",a.fentrymode as fentrymode ", new Object[0]);
        sb.append(",a.fentrygroupnos as fentrygroupno ", new Object[0]);
        sb.append(",a.facttime as facttime ", new Object[0]);
        sb.append(" from t_fmm_ecobomentry a ", new Object[0]);
        sb.append(" inner join t_pdm_bomecopentry b on a.fid = b.fecobomid ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("b.fentryid", pentryIdSet.toArray());
        sb.append(" and a.fentrymode in('A','E') ", new Object[0]);
        sb.append(" and a.fentrygroupnos <> ' ' ", new Object[0]);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try (DataSet ds = DB.queryDataSet((String)(EcoUtils.class.getName() + "getOtherGroupNos"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                String fentrygroupno;
                Long fpentryid = row.getLong("fpentryid");
                Long fecobomentryid = row.getLong("fecobomentryid");
                if (excludeBomEntryIdSet.contains(fecobomentryid) || noGroupNoEntryIdSet != null && noGroupNoEntryIdSet.contains(fecobomentryid) || StringUtils.isEmpty((String)(fentrygroupno = row.getString("fentrygroupno")))) continue;
                String fentrymode = row.getString("fentrymode");
                Date facttime = row.getDate("facttime");
                HashMap<String, String> refMap = (HashMap<String, String>)typeMap.get(fentrymode);
                if (refMap == null) {
                    refMap = new HashMap<String, String>(16);
                }
                refMap.put(PlatformUtils.getUnionString((Object)fpentryid, (Object)fentrygroupno), facttime == null ? "" : sdf.format(facttime));
                typeMap.put(fentrymode, refMap);
            }
        }
        return typeMap;
    }

    public static void addToMap(Map<String, String> fromMap, Map<String, String> toMap) {
        if (fromMap == null || fromMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entrys : fromMap.entrySet()) {
            toMap.put(entrys.getKey(), entrys.getValue());
        }
    }

    public static Map<Long, Set<Long>> getContinuityEcnIdMap(Set<Long> ecoBomEntryIdSet) {
        if (PlatformUtils.isNullSet(ecoBomEntryIdSet)) {
            return new HashMap<Long, Set<Long>>(16);
        }
        String algoKey = EcoUtils.class.getName() + "_getContinuityEcnIdSet";
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select b.fentryid as fecobomentryid ", new Object[0]);
        sb.append(" ,a.fentryid as fsourceecobomentryid ", new Object[0]);
        sb.append(" from t_fmm_ecobomentry a ", new Object[0]);
        sb.append(" inner join t_fmm_ecobomentry b on a.fbomentry = b.fbomentry and a.fentryid <> b.fentryid ", new Object[0]);
        sb.append(" inner join t_pdm_bomecopentry c on b.fid = c.fecobomid  ", new Object[0]);
        sb.append(" inner join t_pdm_bom_eco d on d.fid = c.fid ", new Object[0]);
        sb.append(" where ", new Object[0]);
        sb.appendIn("a.fentryid", ecoBomEntryIdSet.toArray());
        sb.append(" and d.fbillstatus = 'C' ", new Object[0]);
        sb.append(" and b.festimatestatus <> 'C' ", new Object[0]);
        sb.append(" and a.fbomentry > 0 ", new Object[0]);
        sb.append(" and a.fentrymode in('E') ", new Object[0]);
        sb.append(" and b.fentrymode in('A') ", new Object[0]);
        HashMap<Long, Set<Long>> ecnMap = new HashMap<Long, Set<Long>>(16);
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            while (ds.hasNext()) {
                Row arow = ds.next();
                Long fecobomentryid = arow.getLong("fecobomentryid");
                if (ecoBomEntryIdSet.contains(fecobomentryid)) continue;
                Long fsourceecobomentryid = arow.getLong("fsourceecobomentryid");
                HashSet<Long> entryIdSet = (HashSet<Long>)ecnMap.get(fsourceecobomentryid);
                if (entryIdSet == null) {
                    entryIdSet = new HashSet<Long>(16);
                }
                entryIdSet.add(fecobomentryid);
                ecnMap.put(fsourceecobomentryid, entryIdSet);
            }
        }
        return ecnMap;
    }

    public static List<DynamicObject> updateContinuityPointEcnData(List<DynamicObject> updateList, String fromType, Set<Long> execEndIdSet) {
        Map<Long, Set<Long>> ecnMap;
        HashSet<Long> ecoBomEntryIdSet = new HashSet<Long>(updateList.size());
        boolean isOpenCP = PdmParamSetHelper.getBooleanParamValue((String)"ECNOpeContinuesPoint");
        if (!isOpenCP) {
            return null;
        }
        for (DynamicObject dy : updateList) {
            ecoBomEntryIdSet.add(dy.getLong("entryid"));
        }
        if (execEndIdSet == null) {
            execEndIdSet = new HashSet<Long>(16);
        }
        if ((ecnMap = EcoUtils.getContinuityEcnIdMap(ecoBomEntryIdSet)) == null || ecnMap.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Long> continuityEcnEntryIdSet = new HashSet<Long>(16);
        for (Map.Entry<Long, Set<Long>> ecns : ecnMap.entrySet()) {
            DynamicObject[] ecnsEntryIdSet = ecns.getValue();
            continuityEcnEntryIdSet.addAll((Collection<Long>)ecnsEntryIdSet);
        }
        DynamicObject[] conEcns = EcoUtils.getAllEcoBomEntryDynamicObject(continuityEcnEntryIdSet);
        if (conEcns == null || conEcns.length < 1) {
            return Collections.emptyList();
        }
        HashMap<Long, DynamicObject> conEcnMap = new HashMap<Long, DynamicObject>(conEcns.length);
        for (DynamicObject ecn : conEcns) {
            conEcnMap.put(ecn.getLong("entryid"), ecn);
        }
        ArrayList<DynamicObject> pointList = new ArrayList<DynamicObject>(16);
        String esremark = ResManager.loadKDString((String)"\u8fde\u7eed\u5f3a\u65ad\u66f4\u65b0\u4e3a\u8bc4\u4f30\u5b8c\u6210,\u5bf9\u5e94ECN\u5355\u53f7\u201c%1$s\u201d,\u7ec4\u4ef6\u201c%2$s\u201d\u3002", (String)"EcoUtils_14", (String)"mmc-pdm-business", (Object[])new Object[0]);
        String esremark2 = ResManager.loadKDString((String)"\u975e\u8fde\u7eed\u5f3a\u65ad\u66f4\u65b0\u524d\u4e00\u8fde\u7eed\u65ad\u70b9\u7684\u5b9e\u65bd\u65f6\u95f4\u4e3a(-1)\u79d2,\u5bf9\u5e94ECN\u5355\u53f7[%1$s],\u7ec4\u4ef6[%2$s]", (String)"EcoUtils_15", (String)"mmc-pdm-business", (Object[])new Object[0]);
        if ("handEstimateEnd".equals(fromType)) {
            esremark = ResManager.loadKDString((String)"\u624b\u5de5\u8bc4\u4f30\u5b8c\u6bd5,\u8fde\u7eed\u5f3a\u65ad\u66f4\u65b0\u4e3a\u8bc4\u4f30\u5b8c\u6210,\u5bf9\u5e94ECN\u5355\u53f7\u201c%1$s\u201d,\u7ec4\u4ef6\u201c%2$s\u201d\u3002", (String)"EcoUtils_16", (String)"mmc-pdm-business", (Object[])new Object[0]);
        }
        ArrayList<DynamicObject> ecoRecordLogList = new ArrayList<DynamicObject>(16);
        HashMap<String, DynamicObject> ecoRecordLogMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, Object> cacheMap = new HashMap<String, Object>(16);
        ArrayList addContinuityUpList = new ArrayList(16);
        HashMap<Long, DynamicObject> ecoBillMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> ecoTypeMap = new HashMap<Long, DynamicObject>(16);
        HashSet<Long> currentExecSet = new HashSet<Long>(16);
        for (DynamicObject dy : updateList) {
            Long sourceEcoEntryId = dy.getLong("entryid");
            Set<Long> ecnsEntryIdSet = ecnMap.get(sourceEcoEntryId);
            if (PlatformUtils.isNullSet(ecnsEntryIdSet)) continue;
            String estimatestatus = dy.getString("estimatestatus");
            Date acttime = PlatformUtils.addSecond((Date)dy.getDate("acttime"), (int)-1);
            for (Long targetEcoEntryId : ecnsEntryIdSet) {
                DynamicObject ecoPEntry;
                String logremark;
                String materialnumber;
                String ecnBillno;
                Date oldActtime;
                boolean isSameActtime;
                DynamicObject targetEcnEntry;
                if (ecoBomEntryIdSet.contains(targetEcoEntryId) || !currentExecSet.add(targetEcoEntryId) || !execEndIdSet.add(targetEcoEntryId) || (targetEcnEntry = (DynamicObject)conEcnMap.get(targetEcoEntryId)) == null || "C".equals(targetEcnEntry.getString("estimatestatus"))) continue;
                Long ecoBomId = targetEcnEntry.getLong("ecobomid");
                DynamicObject ecoBill = EcoUtils.getEcoBillDynamicObject(ecoBomId, ecoBillMap);
                DynamicObject ecoType = EcoUtils.getEcoType(ecoBill, ecoBomId, ecoTypeMap);
                boolean isAdjustActTime = EcoUtils.isAdjustActTime(ecoType);
                String oldEstimateStatus = targetEcnEntry.getString("estimatestatus");
                if ("C".equals(estimatestatus)) {
                    isSameActtime = EcoUtils.chkIsSameActtime(targetEcnEntry, acttime);
                    if (isSameActtime && EcoUtils.isContinuousB(targetEcnEntry)) continue;
                    oldActtime = targetEcnEntry.getDate("acttime");
                    ecnBillno = EcoUtils.getEcoBillNo(dy.getLong("ecobomid"), cacheMap);
                    materialnumber = EcoUtils.getMaterialNumber(dy, "entrymaterial");
                    logremark = String.format(esremark, ecnBillno, materialnumber);
                    if (EcoUtils.isContinuousA(targetEcnEntry) && EcoUtils.isContinuousC(dy)) {
                        targetEcnEntry.set("iscanestimate", (Object)true);
                    } else {
                        if (EcoUtils.isContinuousA(targetEcnEntry)) {
                            targetEcnEntry.set("continuouspoint", (Object)"B");
                        }
                        if (isAdjustActTime) {
                            targetEcnEntry.set("acttime", (Object)acttime);
                            targetEcnEntry.set("esremark", (Object)logremark);
                        }
                        pointList.add(targetEcnEntry);
                        execEndIdSet.remove(targetEcoEntryId);
                    }
                    targetEcnEntry.set("estimatestatus", (Object)"C");
                    ecoPEntry = EcoUtils.getEcoPEntry(ecoBill, ecoBomId);
                    if (ecoPEntry != null) {
                        AddEcoLogUtils.addEcoLogByActtime(targetEcnEntry, ecoBill, ecoPEntry, ecoRecordLogMap, ecoRecordLogList, logremark, oldActtime, oldEstimateStatus);
                    }
                    PlatformUtils.addList(addContinuityUpList, (DynamicObject)targetEcnEntry);
                    continue;
                }
                if (EcoUtils.isContinuousB(targetEcnEntry) || EcoUtils.isContinuousA(targetEcnEntry) && EcoUtils.isContinuousC(dy) && dy.getBoolean("iscanestimate") && !targetEcnEntry.getBoolean("iscanestimate")) continue;
                targetEcnEntry.set("continuouspoint", (Object)"C");
                if (targetEcnEntry.getBoolean("iscanestimate")) {
                    dy.set("iscanestimate", (Object)false);
                }
                if (!(isSameActtime = EcoUtils.chkIsSameActtime(targetEcnEntry, acttime))) {
                    oldActtime = targetEcnEntry.getDate("acttime");
                    ecnBillno = EcoUtils.getEcoBillNo(dy.getLong("ecobomid"), cacheMap);
                    materialnumber = EcoUtils.getMaterialNumber(dy, "entrymaterial");
                    logremark = String.format(esremark2, ecnBillno, materialnumber);
                    if (isAdjustActTime) {
                        targetEcnEntry.set("acttime", (Object)acttime);
                        targetEcnEntry.set("esremark", (Object)logremark);
                    }
                    pointList.add(targetEcnEntry);
                    execEndIdSet.remove(targetEcoEntryId);
                    if (!isSameActtime && (ecoPEntry = EcoUtils.getEcoPEntry(ecoBill, ecoBomId)) != null) {
                        AddEcoLogUtils.addEcoLogByActtime(targetEcnEntry, ecoBill, ecoPEntry, ecoRecordLogMap, ecoRecordLogList, logremark, oldActtime, targetEcnEntry.getString("estimatestatus"));
                    }
                }
                PlatformUtils.addList(addContinuityUpList, (DynamicObject)targetEcnEntry);
            }
        }
        if (!addContinuityUpList.isEmpty()) {
            for (int i = 0; i < addContinuityUpList.size(); ++i) {
                EcoUtils.setMinActtime((DynamicObject)addContinuityUpList.get(i));
                updateList.add((DynamicObject)addContinuityUpList.get(i));
            }
        }
        if (!ecoRecordLogList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])ecoRecordLogList.toArray(new DynamicObject[ecoRecordLogList.size()]), (OperateOption)OperateOption.create());
        }
        return pointList;
    }

    private static boolean isContinuousB(DynamicObject ecoBomEntry) {
        String continuouspoint = ecoBomEntry.getString("continuouspoint");
        return continuouspoint != null && "B".equals(continuouspoint);
    }

    private static boolean isContinuousC(DynamicObject ecoBomEntry) {
        String continuouspoint = ecoBomEntry.getString("continuouspoint");
        return continuouspoint != null && "C".equals(continuouspoint);
    }

    private static boolean isContinuousA(DynamicObject ecoBomEntry) {
        String continuouspoint = ecoBomEntry.getString("continuouspoint");
        return continuouspoint == null || "A".equals(continuouspoint) || "".equals(continuouspoint) || " ".equals(continuouspoint);
    }

    private static boolean chkIsSameActtime(DynamicObject ecoBomEntry, Date newActtime) {
        Date oldActtime = ecoBomEntry.getDate("acttime");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return oldActtime != null && sdf.format(oldActtime).equals(sdf.format(newActtime));
    }

    public static String getEcoBillNo(Long ecoBomId, Map<String, Object> cacheMap) {
        String ecoBomIds = String.valueOf(ecoBomId);
        if (cacheMap.containsKey(ecoBomIds)) {
            return (String)cacheMap.get(ecoBomIds);
        }
        HashSet<Long> ecoBomIdSet = new HashSet<Long>(16);
        ecoBomIdSet.add(ecoBomId);
        DynamicObject[] ecoBills = EcoUtils.getEcoChangeBillData(ecoBomIdSet);
        String ecoBillNo = ecoBills[0].getString("billno");
        cacheMap.put(ecoBomIds, ecoBillNo);
        return ecoBillNo;
    }

    public static DynamicObject getEcoBillDynamicObject(Long ecoBomId, Map<Long, DynamicObject> cacheMap) {
        if (cacheMap.containsKey(ecoBomId)) {
            return cacheMap.get(ecoBomId);
        }
        HashSet<Long> ecoBomIdSet = new HashSet<Long>(16);
        ecoBomIdSet.add(ecoBomId);
        DynamicObject[] ecoBills = EcoUtils.getEcoChangeBillData(ecoBomIdSet);
        cacheMap.put(ecoBomId, ecoBills[0]);
        return ecoBills[0];
    }

    public static String getMaterialNumber(DynamicObject ecoBomEntry, String fieldName) {
        DynamicObject material = ecoBomEntry.getDynamicObject(fieldName == null ? "entrymaterial" : fieldName);
        String materialNumber = "";
        if (material != null) {
            if (material.containsProperty("number") && material.getString("number") != null) {
                materialNumber = material.getString("number");
            }
            if (StringUtils.isEmpty((String)materialNumber)) {
                Long materialId = material.getLong("id");
                material = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material", (String)"number");
                materialNumber = material.getString("number");
            }
            return materialNumber;
        }
        return "featuretype";
    }

    public static String getAduitEcnBill(Set<Long> mftBomEntrIdSet, Long currentECNId, String entryMode) {
        if (PlatformUtils.isNullSet(mftBomEntrIdSet)) {
            return null;
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" h.fid as fecnid ", new Object[0]);
        sb.append(",h.fbillno as fbillno ", new Object[0]);
        sb.append(" from t_fmm_ecobomentry a ", new Object[0]);
        sb.append(" inner join t_pdm_bomecopentry b on a.fid = b.fecobomid ", new Object[0]);
        sb.append(" inner join t_pdm_bom_eco h on h.fid = b.fid ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("a.fbomentryid", mftBomEntrIdSet.toArray());
        sb.append(" and h.fbillstatus = 'C' ", new Object[0]);
        sb.append(" and b.fentryversioncontrol = 'A' ", new Object[0]);
        if ("E".equalsIgnoreCase(entryMode)) {
            sb.append(" and a.fentrymode = 'E' ", new Object[0]);
        } else if ("A".equalsIgnoreCase(entryMode)) {
            sb.append(" and a.fentrymode = 'A' ", new Object[0]);
        } else if ("B".equalsIgnoreCase(entryMode)) {
            sb.append(" and a.fentrymode = 'B' ", new Object[0]);
        } else {
            sb.append(" and a.fentrymode = 'C' ", new Object[0]);
        }
        String fbillno = "";
        try (DataSet ds = DB.queryDataSet((String)(EcoUtils.class.getName() + "_getAduitEcnBill"), (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            for (Row row : ds) {
                Long fecnid = row.getLong("fecnid");
                if (!PlatformUtils.isNullLong((Long)currentECNId) && currentECNId.equals(fecnid)) continue;
                fbillno = row.getString("fbillno");
            }
        }
        return fbillno;
    }

    public static Map<Long, String> getRefNoContinuPointEcnData(String refNo, Set<Long> mftBomEntrIdSet, Long currentECNId) {
        if (mftBomEntrIdSet == null || mftBomEntrIdSet.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" select");
        sb.append(" h.fid as fecnid ");
        sb.append(",h.fbillno as fbillno ");
        sb.append(",a.fbomentry as fbomentryid ");
        sb.append(" from t_fmm_ecobomentry a ");
        sb.append(" inner join t_pdm_bomecopentry b on a.fid = b.fecobomid ");
        sb.append(" inner join t_pdm_bom_eco h on h.fid = b.fid ");
        sb.append(" where a.fbomentry in ( ");
        ArrayList<Object> paramList = new ArrayList<Object>(16);
        int size = mftBomEntrIdSet.size();
        for (Long id : mftBomEntrIdSet) {
            paramList.add(id);
            sb.append(" ? ");
            if (paramList.size() == size) continue;
            sb.append(" , ");
        }
        sb.append(" ) and h.fbillstatus = 'C' ");
        sb.append(" and a.fentryrefnos = ? ");
        paramList.add(refNo);
        sb.append(" and a.fentrymode in('A','E') ");
        sb.append(" and a.fentryrefnos <> ' ' ");
        HashMap<Long, String> refMaps = new HashMap<Long, String>(16);
        try (DataSet ds = DB.queryDataSet((String)(EcoUtils.class.getName() + "_getAuditSameRefNoEcnData"), (DBRoute)scmDBRoute, (String)sb.toString(), (Object[])paramList.toArray());){
            for (Row row : ds) {
                Long fecnid = row.getLong("fecnid");
                if (!PlatformUtils.isNullLong((Long)currentECNId) && currentECNId.equals(fecnid)) continue;
                String fbillno = row.getString("fbillno");
                Long fbomentryid = row.getLong("fbomentryid");
                refMaps.put(fbomentryid, fbillno);
            }
        }
        return refMaps;
    }

    public static DynamicObject getEcoType(DynamicObject ecoBill, Long ecoBomId, Map<Long, DynamicObject> ecoTypeMap) {
        DynamicObject ecoType;
        DynamicObject pentry = EcoUtils.getEcoPEntry(ecoBill, ecoBomId);
        DynamicObject dynamicObject = ecoType = pentry == null ? null : pentry.getDynamicObject("ecotype");
        if (ecoType != null) {
            DynamicObject cacheData = ecoTypeMap.get(ecoType.getLong("id"));
            if (cacheData != null) {
                return cacheData;
            }
            Long ecoTypeId = ecoType.getLong("id");
            ecoType = EcoUtils.getEcoTypeFromCache(ecoTypeId, ecoTypeMap);
            ecoTypeMap.put(ecoTypeId, ecoType);
        }
        return ecoType;
    }

    private static ActTimeBean genActtimeBean(DynamicObject ecoBomEntry, DynamicObject ecoBill, DynamicObject[] refDyColl) {
        Date actTime = ecoBomEntry.getDate("acttime");
        Date entryValidDate = ecoBomEntry.getDate("entryvaliddate");
        Date entryInValidDate = ecoBomEntry.getDate("entryinvaliddate");
        String entrymode = ecoBomEntry.getString("entrymode");
        Long mftBomEntryId = ecoBomEntry.getLong("entrybomentryid");
        Long mftBomEntryAfterId = 0L;
        if ("B".equals(entrymode) && "C".equals(ecoBill.getString("billstatus"))) {
            mftBomEntryAfterId = EcoUtils.getMftBomEntryAfterId(ecoBomEntry, refDyColl);
        }
        Long materialId = ecoBomEntry.getDynamicObject("entrymaterial") == null ? 0L : ecoBomEntry.getDynamicObject("entrymaterial").getLong("id");
        return new ActTimeBean(actTime, entryValidDate, entryInValidDate, mftBomEntryId, mftBomEntryAfterId, ecoBill.getLong("id"), ecoBill.getString("billno"), entrymode, ecoBill.getString("billstatus"), materialId);
    }

    private static Long getMftBomEntryAfterId(DynamicObject ecoBomEntry, DynamicObject[] refDyColl) {
        Long mftBomEntryId = ecoBomEntry.getLong("entrybomentryid");
        Long id = ecoBomEntry.getLong("entryid");
        Long mftBomEntryAfterId = 0L;
        for (int i = 0; i < refDyColl.length; ++i) {
            DynamicObject updateDy = refDyColl[i];
            Long ecoBomId = updateDy.getLong("ecobomid");
            if (!ecoBomId.equals(ecoBomEntry.getLong("ecobomid")) || !mftBomEntryId.equals(updateDy.getLong("entrybomentryid")) || id.equals(updateDy.getLong("entryid"))) continue;
            mftBomEntryAfterId = updateDy.getLong("bomentry");
            break;
        }
        if (mftBomEntryAfterId == null || mftBomEntryAfterId.equals(0L)) {
            HashSet<Long> ecoBomEntryIdSet = new HashSet<Long>(16);
            ecoBomEntryIdSet.add(ecoBomEntry.getLong("entryid"));
            Map<Long, Long> afterMap = EcoUtils.getMftBomEntryIdMap(ecoBomEntryIdSet);
            mftBomEntryAfterId = afterMap.get(mftBomEntryId);
        }
        return mftBomEntryAfterId;
    }

    public static Map<Long, Long> getMftBomEntryIdMap(Set<Long> ecoBomEntryIdSet) {
        if (PlatformUtils.isNullSet(ecoBomEntryIdSet)) {
            return new HashMap<Long, Long>(16);
        }
        String algoKey = EcoUtils.class.getName() + "_getMftBomEntryIdMap";
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select b.fbomentryid as mftbomentryid ", new Object[0]);
        sb.append(" ,b.fbomentry as mftbomentryafterid ", new Object[0]);
        sb.append(" from t_fmm_ecobomentry a ", new Object[0]);
        sb.append(" inner join t_fmm_ecobomentry b on a.fid = b.fid and a.fbomentryid = b.fbomentryid and a.fentryid <> b.fentryid and a.fbomentryid > 0  ", new Object[0]);
        sb.append(" where ", new Object[0]);
        sb.appendIn("a.fentryid", ecoBomEntryIdSet.toArray());
        sb.append(" and a.fentrymode = 'B' ", new Object[0]);
        sb.append(" and b.fentrymode = 'C' ", new Object[0]);
        HashMap<Long, Long> dataMap = new HashMap<Long, Long>(16);
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            while (ds.hasNext()) {
                Row arow = ds.next();
                dataMap.put(arow.getLong("mftbomentryid"), arow.getLong("mftbomentryafterid"));
            }
        }
        return dataMap;
    }

    public static Map<String, Map<Long, Long>> getRefnoEcoTypeMap(Set<String> refnoSet, Set<Long> unIncludeEcoBomIdSet) {
        if (PlatformUtils.isNullSet(refnoSet)) {
            return new HashMap<String, Map<Long, Long>>(16);
        }
        String algoKey = EcoUtils.class.getName() + "_getMftBomEntryIdMap";
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" a.fid as fecobomid ", new Object[0]);
        sb.append(",a.fentryrefnos as fentryrefno ", new Object[0]);
        sb.append(",b.fecotype as fecotypeid ", new Object[0]);
        sb.append(" from t_fmm_ecobomentry a ", new Object[0]);
        sb.append(" inner join t_pdm_bomecopentry b on a.fid = b.fecobomid ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("a.fentryrefnos", refnoSet.toArray());
        sb.append(" and a.festimatestatus <> 'C'  ", new Object[0]);
        HashMap<String, Map<Long, Long>> dataMap = new HashMap<String, Map<Long, Long>>(16);
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)scmDBRoute, (SqlBuilder)sb);){
            while (ds.hasNext()) {
                Row arow = ds.next();
                String refno = arow.getString("fentryrefno");
                Long ecobomid = arow.getLong("fecobomid");
                if (unIncludeEcoBomIdSet != null && unIncludeEcoBomIdSet.contains(ecobomid)) continue;
                Long ecotypeid = arow.getLong("fecotypeid");
                HashMap<Long, Long> ecoMap = (HashMap<Long, Long>)dataMap.get(refno);
                if (ecoMap == null) {
                    ecoMap = new HashMap<Long, Long>(16);
                }
                ecoMap.put(ecobomid, ecotypeid);
                dataMap.put(refno, ecoMap);
            }
        }
        return dataMap;
    }

    private static boolean isDiff(DynamicObject ecoBomEntry, Date oldActTime, String oldEstimateStatus) {
        Date newActTime = ecoBomEntry.getDate("acttime");
        String newEstimatestatus = ecoBomEntry.getString("estimatestatus");
        return PlatformUtils.isDiffDate((Date)oldActTime, (Date)newActTime) || PlatformUtils.isDiffString((String)oldEstimateStatus, (String)newEstimatestatus);
    }

    public static void refreshBaseDataCache(String entityname, Long orgId) {
        String cacheType = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        String key = entityname + orgId;
        BaseDataCtrlCacheMrg.clearCache((String)cacheType, (String)key);
        BaseDataService baseDataService = new BaseDataService();
        baseDataService.clearBaseDataFilterCache(entityname, orgId);
        ECNNewUtil.refreshBomEntryCache((DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"pdm_mftbom"));
    }

    public static DynamicObject getDefaultEcoType(Long orgId) {
        DynamicObject paramSetValue = EcoUtils.getParamSetEcoType("A");
        if (paramSetValue != null) {
            return paramSetValue;
        }
        QFilter filter = new QFilter("isdefault", "=", (Object)true);
        return EcoUtils.getEcoType(orgId, filter);
    }

    private static String getParamSetField(String changeType) {
        if ("B".equals(changeType)) {
            return "routedefecotype";
        }
        if ("C".equals(changeType)) {
            return "promatdefecotype";
        }
        return "bomdefecotype";
    }

    private static DynamicObject getParamSetEcoType(String changeType) {
        String selectProperties = EcoUtils.getParamSetField(changeType);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_ecotypeparamset", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong("1839983312026846208"))});
        Long ecoTypeId = PlatformUtils.isNullCollection((DynamicObjectCollection)coll) ? 0L : ((DynamicObject)coll.get(0)).getLong(selectProperties);
        if (PlatformUtils.isNullLong((Long)ecoTypeId)) {
            return null;
        }
        QFilter filter = new QFilter("id", "=", (Object)ecoTypeId);
        return EcoUtils.getEcoType(null, filter);
    }

    public static DynamicObject getDefaultEcoTypeByRt(Long orgId) {
        DynamicObject paramSetValue = EcoUtils.getParamSetEcoType("B");
        if (paramSetValue != null) {
            return paramSetValue;
        }
        QFilter filter = new QFilter("statustype", "=", (Object)"A");
        filter.and(new QFilter("isdefault", "=", (Object)true));
        return EcoUtils.getEcoType(orgId, filter);
    }

    private static DynamicObject getEcoType(Long orgId, QFilter otherQfilter) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        if (orgId != null) {
            qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"pdm_ecotype", (Long)orgId));
        }
        if (otherQfilter != null) {
            qFilter.and(otherQfilter);
        }
        return BusinessDataServiceHelper.loadSingleFromCache((String)"pdm_ecotype", (QFilter[])new QFilter[]{qFilter});
    }

    public static boolean updateEcoBomValues(DynamicObject ecoBom, DynamicObject ecnBill, boolean isupdate) {
        DynamicObjectCollection coll = ecoBom.getDynamicObjectCollection("entry");
        if (coll == null || coll.isEmpty()) {
            return Boolean.FALSE;
        }
        HashSet<Object> materialIdSet = new HashSet<Object>(16);
        HashSet<Object> materialMftIdSet = new HashSet<Object>(16);
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject ecoBomEntry = (DynamicObject)coll.get(i);
            DynamicObject entrymaterialId = ecoBomEntry.getDynamicObject("entrymaterialid");
            DynamicObject entrymaterial = ecoBomEntry.getDynamicObject("entrymaterial");
            if (entrymaterialId != null) {
                materialIdSet.add(entrymaterialId.getPkValue());
            }
            if (entrymaterial == null) continue;
            materialMftIdSet.add(entrymaterial.getPkValue());
        }
        Map materials = new HashMap(16);
        if (!materialIdSet.isEmpty()) {
            materials = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id,number,configproperties", (QFilter[])new QFilter[]{new QFilter("id", "in", materialIdSet)});
        }
        Map materialMfts = new HashMap(16);
        if (!materialMftIdSet.isEmpty()) {
            materialMfts = BusinessDataServiceHelper.loadFromCache((String)"bd_materialmftinfo", (String)"id,materialattr", (QFilter[])new QFilter[]{new QFilter("id", "in", materialMftIdSet)});
        }
        boolean isUpdateValue = false;
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject newMaterialMft;
            DynamicObject ecoBomEntry = (DynamicObject)coll.get(i);
            DynamicObject entrymaterialId = ecoBomEntry.getDynamicObject("entrymaterialid");
            DynamicObject entrymaterial = ecoBomEntry.getDynamicObject("entrymaterial");
            if (entrymaterialId != null && materials != null) {
                DynamicObject newMaterial = (DynamicObject)materials.get(entrymaterialId.getPkValue());
                if (newMaterial != null && PlatformUtils.isDiffString((String)ecoBomEntry.getString("configproperties"), (String)newMaterial.getString("configproperties"))) {
                    ecoBomEntry.set("configproperties", newMaterial.get("configproperties"));
                    isUpdateValue = true;
                }
                if (newMaterial != null && PlatformUtils.isDiffString((String)ecoBomEntry.getString("entrynumber"), (String)newMaterial.getString("number"))) {
                    ecoBomEntry.set("entrynumber", newMaterial.get("number"));
                    isUpdateValue = true;
                }
            }
            if (entrymaterial != null && materialMfts != null && (newMaterialMft = (DynamicObject)materialMfts.get(entrymaterial.getPkValue())) != null && PlatformUtils.isDiffString((String)ecoBomEntry.getString("entrymaterialattr"), (String)newMaterialMft.getString("materialattr"))) {
                ecoBomEntry.set("entrymaterialattr", newMaterialMft.get("materialattr"));
                if ("10020".equals(newMaterialMft.get("materialattr"))) {
                    ecoBomEntry.set("entryisjumplevel", (Object)Boolean.TRUE);
                } else if ("10040".equals(newMaterialMft.get("materialattr"))) {
                    ecoBomEntry.set("entryisjumplevel", (Object)Boolean.FALSE);
                }
                isUpdateValue = true;
            }
            int entryseq = ecoBomEntry.getInt("entryseq");
            int seq = ecoBomEntry.getInt("seq");
            if (entryseq == 0 || entryseq != seq && seq > 0) {
                ecoBomEntry.set("entryseq", (Object)seq);
                isUpdateValue = true;
            }
            if (PlatformUtils.isDiffString((String)ecnBill.getString("id"), (String)ecoBomEntry.getString("entryecnid"))) {
                ecoBomEntry.set("entryecnid", (Object)ecnBill.getString("id"));
                isUpdateValue = true;
            }
            if (!PlatformUtils.isDiffString((String)ecnBill.getString("billno"), (String)ecoBomEntry.getString("entryecnno"))) continue;
            ecoBomEntry.set("entryecnno", (Object)ecnBill.getString("billno"));
            isUpdateValue = true;
        }
        if (isupdate && isUpdateValue) {
            SaveServiceHelper.update((DynamicObject)ecoBom);
        }
        return isUpdateValue;
    }

    public static boolean updateEcoBomEntry(DynamicObject ecoBom, boolean isupdate) {
        DynamicObjectCollection coll = ecoBom.getDynamicObjectCollection("entry");
        if (coll == null || coll.isEmpty()) {
            return Boolean.FALSE;
        }
        HashSet<Object> materialIdSet = new HashSet<Object>(16);
        HashSet<Object> materialMftIdSet = new HashSet<Object>(16);
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject ecoBomEntry = (DynamicObject)coll.get(i);
            DynamicObject entrymaterialId = ecoBomEntry.getDynamicObject("entrymaterialid");
            DynamicObject entrymaterial = ecoBomEntry.getDynamicObject("entrymaterial");
            if (entrymaterialId != null) {
                materialIdSet.add(entrymaterialId.getPkValue());
            }
            if (entrymaterial == null) continue;
            materialMftIdSet.add(entrymaterial.getPkValue());
        }
        Map materials = new HashMap(16);
        if (!materialIdSet.isEmpty()) {
            materials = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id,configproperties", (QFilter[])new QFilter[]{new QFilter("id", "in", materialIdSet)});
        }
        Map materialMfts = new HashMap(16);
        if (!materialMftIdSet.isEmpty()) {
            materialMfts = BusinessDataServiceHelper.loadFromCache((String)"bd_materialmftinfo", (String)"id,materialattr", (QFilter[])new QFilter[]{new QFilter("id", "in", materialMftIdSet)});
        }
        boolean isUpdateValue = false;
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject newMaterialMft;
            DynamicObject newMaterial;
            DynamicObject ecoBomEntry = (DynamicObject)coll.get(i);
            DynamicObject entrymaterialId = ecoBomEntry.getDynamicObject("entrymaterialid");
            DynamicObject entrymaterial = ecoBomEntry.getDynamicObject("entrymaterial");
            if (entrymaterialId != null && materials != null && (newMaterial = (DynamicObject)materials.get(entrymaterialId.getPkValue())) != null && PlatformUtils.isDiffString((String)ecoBomEntry.getString("configproperties"), (String)newMaterial.getString("configproperties"))) {
                ecoBomEntry.set("configproperties", newMaterial.get("configproperties"));
                isUpdateValue = true;
            }
            if (entrymaterial != null && materialMfts != null && (newMaterialMft = (DynamicObject)materialMfts.get(entrymaterial.getPkValue())) != null && PlatformUtils.isDiffString((String)ecoBomEntry.getString("entrymaterialattr"), (String)newMaterialMft.getString("materialattr"))) {
                ecoBomEntry.set("entrymaterialattr", newMaterialMft.get("materialattr"));
                if ("10020".equals(newMaterialMft.get("materialattr"))) {
                    ecoBomEntry.set("entryisjumplevel", (Object)Boolean.TRUE);
                } else if ("10040".equals(newMaterialMft.get("materialattr"))) {
                    ecoBomEntry.set("entryisjumplevel", (Object)Boolean.FALSE);
                }
                isUpdateValue = true;
            }
            int entryseq = ecoBomEntry.getInt("entryseq");
            int seq = ecoBomEntry.getInt("seq");
            if (entryseq != 0 && (entryseq == seq || seq <= 0)) continue;
            ecoBomEntry.set("entryseq", (Object)seq);
            isUpdateValue = true;
        }
        if (isupdate && isUpdateValue) {
            SaveServiceHelper.update((DynamicObject)ecoBom);
        }
        return isUpdateValue;
    }

    public static void setMinActtime(DynamicObject ecoBomEntry) {
        Date minActtime = ecoBomEntry.getDate("minacttime");
        Date acttime = ecoBomEntry.getDate("acttime");
        if (acttime != null && (minActtime == null || minActtime.compareTo(acttime) > 0)) {
            ecoBomEntry.set("minacttime", (Object)acttime);
        }
    }

    public static void updateMftBomModifyer(List<DynamicObject> updateMftBomEntryList) {
        DynamicObject[] dys;
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (DynamicObject dy : updateMftBomEntryList) {
            idSet.add(dy.getLong("bomid"));
        }
        Long userId = RequestContext.get().getCurrUserId();
        Date newDate = new Date();
        for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)"pdm_mftbom", (String)"id,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)})) {
            dy.set("modifier", (Object)userId);
            dy.set("modifytime", (Object)newDate);
        }
        SaveServiceHelper.update((DynamicObject[])dys);
    }

    private static String getUpdateSourceName(String updateSource) {
        return ResManager.loadKDString((String)"\u53d8\u66f4\u5de5\u4f5c\u53f0\u8fdb\u884c\u5b9e\u65bd\u8c03\u6574\u65f6\u89e6\u53d1\u4e3b\u952e\u91cd\u65b0\u8ba1\u7b97\u540e\u66f4\u65b0", (String)"EcoUtils_17", (String)"mmc-pdm-business", (Object[])new Object[0]);
    }

    public static String getFieldName(String keyField) {
        if ("groupkey".equals(keyField)) {
            return ResManager.loadKDString((String)"\u6210\u7ec4\u4e3b\u952e", (String)"EcoBomPlatFormQueryPlugin_88", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        }
        if ("refkey".equals(keyField)) {
            return ResManager.loadKDString((String)"\u5173\u8054\u4e3b\u952e", (String)"EcoBomPlatFormQueryPlugin_89", (String)"mmc-pdm-formplugin", (Object[])new Object[0]);
        }
        return keyField;
    }

    private static void addLogByEcoBomKey(DynamicObject oldEcoBom, DynamicObject newEcoBom, String filedNumber, String updateSource) {
        if (oldEcoBom == null) {
            return;
        }
        String logRemark = EcoUtils.getUpdateSourceName(updateSource);
        String fieldName = EcoUtils.getFieldName(filedNumber);
        DynamicObjectCollection collA = oldEcoBom.getDynamicObjectCollection("entry");
        DynamicObjectCollection collB = newEcoBom.getDynamicObjectCollection("entry");
        HashMap<Long, DynamicObject> newEntryMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject entryB : collB) {
            Long ecoBomEntryId = (Long)entryB.getPkValue();
            newEntryMap.put(ecoBomEntryId, entryB);
        }
        HashMap<Long, DynamicObject> ecoBillMap = new HashMap<Long, DynamicObject>(16);
        ArrayList<DynamicObject> ecoRecordLogList = new ArrayList<DynamicObject>(16);
        HashMap<String, DynamicObject> ecoRecordLogMap = new HashMap<String, DynamicObject>(16);
        Long ecoBomId = newEcoBom.getLong("id");
        DynamicObject ecoBill = EcoUtils.getEcoBillDynamicObject(ecoBomId, ecoBillMap);
        DynamicObject ecoPEntry = EcoUtils.getEcoPEntry(ecoBill, ecoBomId);
        for (DynamicObject entryA : collA) {
            Long ecoBomEntryId = (Long)entryA.getPkValue();
            DynamicObject entryB = (DynamicObject)newEntryMap.get(ecoBomEntryId);
            if (entryB == null || !PlatformUtils.isDiffBoolean((boolean)entryA.getBoolean(filedNumber), (boolean)entryB.getBoolean(filedNumber))) continue;
            DynamicObject ecoBomEntry = EcoUtils.getEcoBomEntryByEntryId(ecoBomEntryId);
            AddEcoLogUtils.addEcoLogByField(ecoBomEntry, entryA.getBoolean(filedNumber), entryB.getBoolean(filedNumber), filedNumber, fieldName, ecoBill, ecoPEntry, ecoRecordLogMap, ecoRecordLogList, logRemark);
        }
        if (!ecoRecordLogList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])ecoRecordLogList.toArray(new DynamicObject[ecoRecordLogList.size()]), (OperateOption)OperateOption.create());
        }
    }

    public static void resetEcoBomEntryDate(Set<Long> ecnBillIdSet) {
        if (!PdmParamSetHelper.getBooleanParamValue((String)"ECNSubmitAuditReSetDate")) {
            return;
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        SqlBuilder sql = new SqlBuilder();
        sql.append(" select d.fvaliddate ,d1.fentryid ,d1.fentrymode ,d1.fbomentryid, ", new Object[0]);
        sql.append(" d1.fvaliddate as fecnvaliddate,d1.finvaliddate  as fencinvaliddate, ", new Object[0]);
        sql.append(" d2.fvaliddate as fbomvaliddate,d2.finvaliddate  as fbominvaliddate ", new Object[0]);
        sql.append(" from t_pdm_bom_eco h  ", new Object[0]);
        sql.append(" inner join t_pdm_bomecopentry d  on h.fid = d.fid  ", new Object[0]);
        sql.append(" inner join t_fmm_ecobomentry d1 on d1.fid = d.fecobomid  ", new Object[0]);
        sql.append(" inner join t_pdm_mftbomentry d2 on d2.fentryid = d1.fbomentryid  ", new Object[0]);
        sql.append(" where  ", new Object[0]);
        sql.appendIn("h.fid", ecnBillIdSet.toArray());
        try (DataSet ds = DB.queryDataSet((String)(EcoUtils.class.getName() + "_resetEcoBomEntryDate"), (DBRoute)scmDBRoute, (SqlBuilder)sql);){
            for (Row arow : ds) {
                Long ecoBomEntryId = arow.getLong("fentryid");
                String fentrymode = arow.getString("fentrymode");
                Date fecnvaliddate = arow.getDate("fecnvaliddate");
                Date fencinvaliddate = arow.getDate("fencinvaliddate");
                Date fNewecnvaliddate = EcoUtils.getMftBomValidDate(arow.getDate("fvaliddate"), fentrymode, arow.getDate("fbomvaliddate"));
                Date fNewencinvaliddate = EcoUtils.getMftBomInValidDate(fentrymode, arow.getDate("fbominvaliddate"));
                if (!EcoUtils.isDifferentDateByNull(fecnvaliddate, fNewecnvaliddate) && !EcoUtils.isDifferentDateByNull(fencinvaliddate, fNewencinvaliddate)) continue;
                paramList.add(new Object[]{fNewecnvaliddate, fNewencinvaliddate, ecoBomEntryId});
            }
        }
        if (!paramList.isEmpty()) {
            DB.executeBatch((DBRoute)scmDBRoute, (String)UPDATESQL_ECN_ENTRYDATE, paramList);
        }
    }

    private static boolean isDifferentDateByNull(Date fvaliddateA, Date fvaliddateB) {
        if (fvaliddateB == null) {
            return false;
        }
        return fvaliddateA == null || fvaliddateA.compareTo(fvaliddateB) != 0;
    }

    private static Date getMftBomValidDate(Date fvaliddate, String fentrymode, Date fbomvaliddate) {
        return "E".equals(fentrymode) || "B".equals(fentrymode) ? fbomvaliddate : ("C".equals(fentrymode) ? fvaliddate : null);
    }

    private static Date getMftBomInValidDate(String fentrymode, Date fbominvaliddate) {
        return "E".equals(fentrymode) || "B".equals(fentrymode) ? fbominvaliddate : ("C".equals(fentrymode) ? fbominvaliddate : null);
    }
}

