/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bd.mpdm.common.mftorderbom.utils.BomBaseData;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.ext.mmc.business.query.helper.MmcCommonHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;

public class ExpandBomByMfgBom {
    private static final Log logger = LogFactory.getLog(ExpandBomByMfgBom.class);

    public List<BomBaseData> expandBom(Long bomId, BigDecimal qty, Date expendbomtime, String type, Long routeId, Map<String, String> bomResultCacheMap) {
        String result = this.getExpandBomResult(bomId, qty, expendbomtime, type, routeId, bomResultCacheMap);
        return this.convetToObject(result);
    }

    private String getExpandBomResult(Long bomId, BigDecimal qty, Date expendbomtime, String type, Long routeId, Map<String, String> bomResultCacheMap) {
        String resStr;
        if (bomResultCacheMap == null) {
            bomResultCacheMap = new HashMap<String, String>(16);
        }
        if (bomResultCacheMap.containsKey(resStr = this.getFilterParamKeyString(bomId, qty, expendbomtime, type, routeId))) {
            String result = bomResultCacheMap.get(resStr);
            logger.info("getbomresultfrommap\uff1a" + result);
            return result;
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-fmm-bomsearch");
        String res = "";
        JSONObject paramJson = this.getBomFilterJson(bomId, qty, expendbomtime, type, routeId);
        Long startdate = System.currentTimeMillis();
        JSONArray filterArray = new JSONArray(16);
        filterArray.add((Object)paramJson);
        String bomResult = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"BOMSearchService", (String)"allLevelForwardSearch", (Object[])new Object[]{filterArray.toString()});
        Long enddate = System.currentTimeMillis() - startdate;
        if (bomResult.indexOf("true") >= 0) {
            res = (String)cache.get(resStr);
            bomResultCacheMap.put(resStr, res);
            cache.remove(resStr);
        }
        logger.info(String.format("ExpandBomByMfgBom.getExpandBomResult params:%s,cost:%s,result:%s,getbomresultfrombomexpand:%s", paramJson.toString(), enddate, bomResult, res));
        return res;
    }

    private List<BomBaseData> convetToObject(String res) {
        if (StringUtils.isEmpty((String)res)) {
            return new ArrayList<BomBaseData>(16);
        }
        JSONArray resArray = JSONArray.parseArray((String)res);
        ArrayList<BomBaseData> bbdList = new ArrayList<BomBaseData>(resArray.size());
        if (!resArray.isEmpty()) {
            for (int i = 0; i < resArray.size(); ++i) {
                JSONObject resJson = (JSONObject)resArray.get(i);
                bbdList.add(CreateStockByBomUtils.getBomBaseData((JSONObject)resJson));
            }
        }
        return bbdList;
    }

    private String getFilterParamKeyString(Long bomId, BigDecimal qty, Date expandtime, String type, Long routeId) {
        boolean isBomExpandTime = MmcCommonHelper.IsBomExpandTime();
        if (!isBomExpandTime) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return bomId + "-" + qty + "-" + sdf.format(expandtime) + "-" + type + "-" + routeId;
        }
        return bomId + "-" + qty + "-" + expandtime.getTime() + "-" + type + "-" + routeId;
    }

    private JSONObject getBomFilterJson(Long bomId, BigDecimal qty, Date expendbomtime, String type, Long routeId) {
        JSONObject filterJson = new JSONObject();
        filterJson.put("id", (Object)bomId);
        filterJson.put("num", (Object)qty);
        filterJson.put("time", (Object)expendbomtime);
        filterJson.put("type", (Object)type);
        filterJson.put("routeId", (Object)routeId);
        return filterJson;
    }
}

