/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.estimate.step;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.estimate.step.EcoEstimateBaseStep;
import kd.mmc.pdm.business.ecoplatform.estimate.step.EcoEstimateGetSupplyData;
import kd.mmc.pdm.business.ecoplatform.estimate.step.EstimateUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mpscmm.msplan.mservice.service.datafetch.util.DataSourceFetchDataUtil;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;

public class EcoEffectRangeGetRequireData
extends EcoEstimateBaseStep {
    private static final Log log = LogFactory.getLog(EcoEffectRangeGetRequireData.class);

    @Override
    public String doWork(ExecutionEnv env, int stepIdx) {
        super.doWork(env, stepIdx);
        try {
            int dataAmount = 0;
            DynamicObject planProgram = this.getPlanProgram();
            String ecoBomEntryIds = this.getCacheValue(EstimateUtils.genRedisEcoBomEntryIdKey(env.getCtxId()));
            String ecoBomCopEntryIds = this.getCacheValue(EstimateUtils.genRedisEcoBomCopEntryIdKey(env.getCtxId()));
            String ecnPEntryIds = this.getCacheValue(EstimateUtils.genRedisEcnPEntryIdKey(env.getCtxId()));
            String isParentQuerys = this.getCacheValue(EstimateUtils.genRedisIsParentQueryKey(env.getCtxId()));
            Set ecoBomEntryIdSet = PlatformUtils.ParseStringToLongSet((String)ecoBomEntryIds);
            Set ecoBomCopEntryIdSet = PlatformUtils.ParseStringToLongSet((String)ecoBomCopEntryIds);
            Set ecoPEntryIdSet = PlatformUtils.ParseStringToLongSet((String)ecnPEntryIds);
            boolean isParentQuery = "true".equals(isParentQuerys);
            if (!isParentQuery && PlatformUtils.isNullSet((Set)ecoBomEntryIdSet) && PlatformUtils.isNullSet((Set)ecoBomCopEntryIdSet)) {
                return ResManager.loadKDString((String)"\u672a\u5728Redis\u7f13\u5b58\u4e2d\u627e\u5230\u5de5\u7a0b\u53d8\u66f4\u5355\u5206\u5f55\u6570\u636e\u3002", (String)"EcoEffectRangeGetRequireData_0", (String)"mmc-pdm-business", (Object[])new Object[0]);
            }
            DataSet dataSet = this.fetchDataBySetId(planProgram, ecoBomEntryIdSet, ecoBomCopEntryIdSet, ecoPEntryIdSet, isParentQuery);
            if (dataSet == null) {
                return ResManager.loadKDString((String)"\u672a\u627e\u5230\u9700\u6c42\u6570\u636e\u3002", (String)"EcoEffectRangeGetRequireData_1", (String)"mmc-pdm-business", (Object[])new Object[0]);
            }
            dataSet = this.formatEntryEntity(dataSet);
            HashSet<Object> materialIdSet = new HashSet<Object>(128);
            HashSet<String> rsSet = new HashSet<String>(128);
            JSONObject reqObject = new JSONObject();
            RowMeta rowMeta = dataSet.getRowMeta();
            String[] fieldNames = rowMeta.getFieldNames();
            HashSet<String> fieldNameSet = new HashSet<String>(Arrays.asList(fieldNames));
            String[] keyFieldNames = this.getRequireCacheRedisKeyField(planProgram);
            HashMap<String, Set<Long>> featureMaterialCacheMap = new HashMap<String, Set<Long>>(16);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                if (row.getDate("billdate") == null) continue;
                Object featureType = 0L;
                if (fieldNameSet.contains("featuretype")) {
                    featureType = row.getLong("featuretype");
                }
                Long orgId = row.getLong("productionorgunit");
                Set<Object> fmIdSet = new HashSet<Long>(16);
                if (!PlatformUtils.isNullLong((Long)featureType)) {
                    fmIdSet = this.getFeatureMaterial((Long)featureType, orgId, featureMaterialCacheMap);
                } else {
                    fmIdSet.add(row.getLong("material"));
                }
                if (fmIdSet.isEmpty()) {
                    log.info("---------EcoEffectRangeGetRequireData not find material -------------row:" + row.toString());
                    continue;
                }
                for (Long l : fmIdSet) {
                    String cacheKeyString = this.getRowKeyString(row, keyFieldNames, l);
                    JSONObject dataObject = new JSONObject();
                    for (int keySize = 0; keySize < fieldNames.length; ++keySize) {
                        String fieldName = fieldNames[keySize];
                        Object value = row.get(fieldName);
                        dataObject.put(fieldName, value);
                    }
                    dataObject.put("exceptiontype", (Object)"A");
                    dataObject.put("exceptioninfo", (Object)"");
                    dataObject.put("material", (Object)l);
                    dataObject.put("supandreqkey", (Object)cacheKeyString);
                    JSONArray list = reqObject.getJSONArray(cacheKeyString);
                    if (list == null) {
                        list = new JSONArray();
                    }
                    list.add((Object)dataObject);
                    reqObject.put(cacheKeyString, (Object)list);
                    rsSet.add(cacheKeyString);
                }
                materialIdSet.addAll(fmIdSet);
                ++dataAmount;
            }
            dataSet.close();
            int redisTimeLong = this.getRedisTimeLong();
            this.setCacheValue(env, this.getMaterialIdCacheString(), ((Object)materialIdSet).toString(), redisTimeLong);
            this.setCacheValue(env, this.getReqSupCacheString(), ((Object)rsSet).toString(), redisTimeLong);
            for (String cacheKeyString : rsSet) {
                JSONArray list = reqObject.getJSONArray(cacheKeyString);
                if (list == null || list.isEmpty()) continue;
                this.setCacheValue(env, this.getRequireCacheString(cacheKeyString), list.toJSONString(), redisTimeLong);
            }
            this.updateLogCount(stepIdx, dataAmount);
            String resultStr = String.format(ResManager.loadKDString((String)"\u9700\u6c42%1$s\u6761\uff0c\u7269\u6599\u6570%2$s\u6761\u3002", (String)"EcoEffectRangeGetRequireData_2", (String)"mmc-pdm-business", (Object[])new Object[0]), dataAmount, materialIdSet.size());
            return resultStr;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.clearCacheValue(env);
            throw e;
        }
    }

    private boolean isCopQuery(String materialField) {
        return "pentry.ecobomdata.copentry.copentrymaterialid".equalsIgnoreCase(materialField);
    }

    private DataSet fetchDataBySetId(DynamicObject planProgram, Set<Long> ecoBomEntryIdSet, Set<Long> ecoBomCopEntryIdSet, Set<Long> ecoPEntryIdSet, boolean isParentQuery) {
        DataSet dataSet = null;
        DynamicObjectCollection collection = planProgram.getDynamicObjectCollection("entryentity");
        ArrayList<Long> modelIds = new ArrayList<Long>(16);
        HashMap<Long, String> rsTypeMap = new HashMap<Long, String>(16);
        for (DynamicObject entry : collection) {
            if (!entry.getBoolean("entryismrpoperat")) continue;
            Long rsId = entry.getLong("resourceregister.id");
            String demandType = entry.getString("entrydemandtype");
            if (isParentQuery && "A".equals(demandType)) continue;
            rsTypeMap.put(rsId, demandType);
            modelIds.add(rsId);
        }
        if (modelIds.isEmpty()) {
            return dataSet;
        }
        int planOutLookDay = this.getPlanOutLook(planProgram);
        int supplyDelayPeriod = this.getRequireDelayPeriod(planProgram);
        Set<Long> demandOrgs = this.getRequirorgs(planProgram);
        Date currentDate = new Date();
        Date toDate = PlatformUtils.addDay((Date)currentDate, (int)planOutLookDay);
        Date fromDate = PlatformUtils.addDay((Date)currentDate, (int)(0 - supplyDelayPeriod));
        Map<Long, String> srcMaterialFieldMap = this.getMaterialSrcFieldMap(modelIds);
        for (Long modelId : modelIds) {
            String getDataType = (String)rsTypeMap.get(modelId);
            if (StringUtils.isEmpty((String)getDataType)) {
                getDataType = "A";
            }
            String materialField = srcMaterialFieldMap.get(modelId);
            QFilter qfilter = new QFilter("org", "in", demandOrgs);
            if ("A".equals(getDataType)) {
                if (this.isCopQuery(materialField)) {
                    if (ecoBomCopEntryIdSet.isEmpty()) continue;
                    qfilter.and(new QFilter("pentry.ecobomdata.copentry.id", "in", ecoBomCopEntryIdSet));
                } else {
                    if (ecoBomEntryIdSet.isEmpty()) continue;
                    qfilter.and(new QFilter("pentry.ecobomdata.entry.id", "in", ecoBomEntryIdSet));
                }
            } else if ("B".equals(getDataType)) {
                qfilter.and(new QFilter("pentry.id", "in", ecoPEntryIdSet));
            }
            if (!"1".equals(planProgram.getString("outofdate"))) {
                qfilter.and(new QFilter("createtime", ">=", (Object)fromDate));
                qfilter.and(new QFilter("createtime", "<=", (Object)toDate));
            }
            DataSet dsItem = null;
            dsItem = DataSourceFetchDataUtil.getDataSetByModel((Long)modelId, null, (QFilter)qfilter);
            dsItem = dsItem.addField("cast (" + modelId + " as long) ", "srcdatasource");
            dsItem.print(true);
            dsItem = dsItem.addField("'" + getDataType + "'", "getdatatype");
            if (dataSet == null) {
                dataSet = dsItem;
                continue;
            }
            RowMeta leftRowMeta = dataSet.getRowMeta();
            RowMeta rightRowMeta = dsItem.getRowMeta();
            Field[] leftFields = leftRowMeta.getFields();
            Field[] rightFields = rightRowMeta.getFields();
            HashSet<String> allFieldName = new HashSet<String>(16);
            HashSet<String> leftName = new HashSet<String>(16);
            HashSet<String> rightName = new HashSet<String>(16);
            for (Field leftField : leftFields) {
                allFieldName.add(leftField.getName());
                leftName.add(leftField.getName());
            }
            for (Field rightField : rightFields) {
                allFieldName.add(rightField.getName());
                rightName.add(rightField.getName());
            }
            for (String fieldName : allFieldName) {
                if (!leftName.contains(fieldName)) {
                    dataSet = dataSet.addNullField(fieldName);
                }
                if (rightName.contains(fieldName)) continue;
                dsItem = dsItem.addNullField(fieldName);
            }
            dataSet = dataSet.select(allFieldName.toArray(new String[0]));
            dsItem = dsItem.select(allFieldName.toArray(new String[0]));
            dataSet = dataSet.union(dsItem);
        }
        return dataSet;
    }

    private Set<Long> getFeatureMaterial(Long featureTypeId, Long orgId, Map<String, Set<Long>> featureMaterialCacheMap) {
        String keyString = featureTypeId + "_" + orgId;
        if (featureMaterialCacheMap.containsKey(keyString)) {
            return featureMaterialCacheMap.get(keyString);
        }
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        String selectProperties = "masterid";
        QFilter filter = new QFilter("featureinfo.featuretype", "=", (Object)featureTypeId);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and(BaseDataServiceHelper.getBaseDataFilter((String)"pdm_proconfigscheme", (Long)orgId));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(EcoEstimateGetSupplyData.class.getName() + "_getFeatureMaterial"), (String)"pdm_proconfigscheme", (String)selectProperties, (QFilter[])new QFilter[]{filter}, (String)"");){
            while (ds.hasNext()) {
                Row arow = ds.next();
                Long materialId = arow.getLong("masterid");
                materialIdSet.add(materialId);
            }
        }
        featureMaterialCacheMap.put(keyString, materialIdSet);
        return materialIdSet;
    }
}

