/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.estimate.step;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.pdm.business.ecoplatform.estimate.step.EcoEstimateBaseStep;
import kd.mmc.pdm.business.ecoplatform.estimate.step.batchtask.EstimateBatchTaskEvent;
import kd.mmc.pdm.business.ecoplatform.estimate.step.exec.EffectRangeSRMatchExecImpl;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTask;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;

public class EcoEffectRangeSRMatch
extends EcoEstimateBaseStep {
    private static final Log log = LogFactory.getLog(EcoEffectRangeSRMatch.class);
    private static final int DEFBATCHSIZE = 100;

    @Override
    public String doWork(ExecutionEnv env, int stepIdx) {
        super.doWork(env, stepIdx);
        try {
            String supAndReqKeys = this.getCacheValue(this.getReqSupCacheString());
            Set supAndReqKeySet = PlatformUtils.ParseStringToSet((String)supAndReqKeys);
            if (supAndReqKeySet == null || supAndReqKeySet.isEmpty()) {
                return ResManager.loadKDString((String)"\u6682\u65e0\u4f9b\u9700\u5339\u914d\u6570\u636e\u3002", (String)"EcoEffectRangeSRMatch_0", (String)"mmc-pdm-business", (Object[])new Object[0]);
            }
            List<Set<String>> supAndReqKeyList = this.splitData(env, supAndReqKeySet);
            String resultStr = this.batchExecute(env, supAndReqKeyList, stepIdx);
            return resultStr;
        }
        catch (Exception e) {
            this.clearCacheValue(env);
            throw e;
        }
    }

    public int getOneBatchCount() {
        return this.getMateriaBatchCount();
    }

    public List<Set<String>> splitData(ExecutionEnv env, Set<String> supAndReqKeySet) {
        ArrayList<Set<String>> splitKeys = new ArrayList<Set<String>>(64);
        boolean isBatchCompute = this.isBatchCompute();
        int subSize = 100;
        if (isBatchCompute && (subSize = this.getOneBatchCount()) == 0) {
            subSize = 100;
        }
        JSONArray allRequireArray = this.getAllRequireArray(supAndReqKeySet);
        int reqSize = allRequireArray.size();
        HashMap<Long, HashSet<String>> groupMap = new HashMap<Long, HashSet<String>>(16);
        for (int i = 0; i < reqSize; ++i) {
            JSONObject reqObject = allRequireArray.getJSONObject(i);
            Long ecoBomEntryId = reqObject.getLong("ecobomentryid");
            String supAndReqKey = reqObject.getString("supandreqkey");
            HashSet<String> set = (HashSet<String>)groupMap.get(ecoBomEntryId);
            if (set == null) {
                set = new HashSet<String>(16);
            }
            set.add(supAndReqKey);
            groupMap.put(ecoBomEntryId, set);
        }
        HashSet subSupAndReqKeySet = new HashSet(subSize);
        int i = 0;
        for (Map.Entry entrys : groupMap.entrySet()) {
            Set subKeys = (Set)entrys.getValue();
            subSupAndReqKeySet.addAll(subKeys);
            if (++i != subSize) continue;
            splitKeys.add(subSupAndReqKeySet);
            subSupAndReqKeySet = new HashSet(subSize);
            i = 0;
        }
        if (i > 0) {
            splitKeys.add(subSupAndReqKeySet);
        }
        log.info("-----------EcoEffectRangeSRMatch-----splitData---------subSize:" + subSize + ",splitKeys.size=" + splitKeys.size() + ",supAndReqKeySet.size=" + supAndReqKeySet.size());
        return splitKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String batchExecute(ExecutionEnv env, List<Set<String>> supAndReqKeyList, int stepIdx) {
        boolean isBatchCompute = this.isBatchCompute();
        int dataAmount = 0;
        int resultListSize = 0;
        int size = supAndReqKeyList.size();
        if (!isBatchCompute || this.getOneBatchCount() <= 0) {
            for (int i = 0; i < size; ++i) {
                Set<String> subKeySet = supAndReqKeyList.get(i);
                Map<String, Object> result = EffectRangeSRMatchExecImpl.getInstance().exec(env, null, null, null, subKeySet, false);
                int subDataAmount = (Integer)result.get("dataAmount");
                int subResultListSize = (Integer)result.get("resultListSize");
                dataAmount += subDataAmount;
                resultListSize += subResultListSize;
            }
            this.updateLogCount(stepIdx, dataAmount);
            String resultStr = String.format(ResManager.loadKDString((String)"\u4f9b\u9700\u5339\u914d\u7ed3\u679c\u5171%1$s\u6761\u3002", (String)"EcoEffectRangeSRMatch_1", (String)"mmc-pdm-business", (Object[])new Object[0]), resultListSize);
            return resultStr;
        }
        BatchTask task = BatchTask.create((String)"EcoEffectRangeSRMatch");
        String taskId = task.getCalcId();
        task.setQueueName(this.getConsumerQueue());
        task.registBizClass(EstimateBatchTaskEvent.class);
        task.setTimeOut(TASKTIMEOUTLONG.longValue());
        int batch = 0;
        int allDataSize = 0;
        DynamicObject planProgram = this.getPlanProgram(env);
        for (int i = 0; i < size; ++i) {
            Set<String> subKeySet = supAndReqKeyList.get(i);
            ++batch;
            allDataSize += subKeySet.size();
            HashMap<String, Object> batchParams = new HashMap<String, Object>(16);
            batchParams.put("subKeySet", subKeySet);
            batchParams.put("envCacheMap", env.getParams());
            batchParams.put("taskname", "EffectRange_SRMatch");
            batchParams.put("runLog", env.getRunLog());
            batchParams.put("planProgram", planProgram);
            batchParams.put("batch", batch);
            task.addEvent(batchParams);
        }
        this.addTaskLog(taskId);
        long startTime = System.currentTimeMillis();
        boolean successful = true;
        String errorMsg = "";
        try {
            log.info(String.format(ResManager.loadKDString((String)"EcoEstimateSRBalance_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u5f00\u59cb\uff0c[%1$s]\u4e2a\u5339\u914d\u53f7\u5206\u53d1\u4e3a\u5171[%2$s]\u4e2a\u4efb\u52a1...", (String)"EcoEffectRangeSRMatch_3", (String)"mmc-pdm-business", (Object[])new Object[0]), allDataSize, batch));
            log.info(String.format(ResManager.loadKDString((String)"EcoEstimateSRBalance_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u5f00\u59cb\uff0c[%1$s]\u4e2a\u5339\u914d\u53f7\u5206\u53d1\u4e3a\u5171[%2$s]\u4e2a\u4efb\u52a1...", (String)"EcoEffectRangeSRMatch_3", (String)"mmc-pdm-business", (Object[])new Object[0]), allDataSize, batch));
            task.startTask();
            log.info(ResManager.loadKDString((String)"EcoEstimateSRBalance_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u7ed3\u675f...", (String)"EcoEffectRangeSRMatch_4", (String)"mmc-pdm-business", (Object[])new Object[0]));
            log.info(ResManager.loadKDString((String)"EcoEstimateSRBalance_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u7ed3\u675f...", (String)"EcoEffectRangeSRMatch_4", (String)"mmc-pdm-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error(ResManager.loadKDString((String)"EcoEstimateSRBalance_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u51fa\u9519\uff1a", (String)"EcoEffectRangeSRMatch_5", (String)"mmc-pdm-business", (Object[])new Object[0]) + e.getMessage(), (Throwable)e);
            log.error(ResManager.loadKDString((String)"EcoEstimateSRBalance_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u51fa\u9519\uff1a", (String)"EcoEffectRangeSRMatch_5", (String)"mmc-pdm-business", (Object[])new Object[0]) + e.getMessage(), (Throwable)e);
            successful = false;
            errorMsg = PlatformUtils.getExceptionString((Exception)e);
        }
        finally {
            task.terminate();
        }
        if (!successful) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f71\u54cd\u8303\u56f4\uff1a\u4f9b\u9700\u5339\u914d\u6570\u636e\u5339\u914d\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff1a\u201c%1$s\u201d\u3002", (String)"EcoEffectRangeSRMatch_2", (String)"mmc-pdm-business", (Object[])new Object[0]), errorMsg));
        }
        long enddate = System.currentTimeMillis() - startTime;
        log.info(String.format(ResManager.loadKDString((String)"EcoEstimateSRBalance_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u5b8c\u6bd5,allDataSize.size = %1$s,cost: %2$s ms", (String)"EcoEffectRangeSRMatch_6", (String)"mmc-pdm-business", (Object[])new Object[0]), allDataSize, enddate));
        log.info(String.format(ResManager.loadKDString((String)"EcoEstimateSRBalance_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u5b8c\u6bd5,allDataSize.size = %1$s,cost: %2$s ms", (String)"EcoEffectRangeSRMatch_6", (String)"mmc-pdm-business", (Object[])new Object[0]), allDataSize, enddate));
        dataAmount = this.getIntegerCacheValue(this.getSRResultCacheString01());
        resultListSize = this.getIntegerCacheValue(this.getSRResultCacheString02());
        this.updateLogCount(stepIdx, dataAmount);
        String resultStr = String.format(ResManager.loadKDString((String)"\u4f9b\u9700\u5339\u914d\u7ed3\u679c\u5171%1$s\u6761\u3002", (String)"EcoEffectRangeSRMatch_1", (String)"mmc-pdm-business", (Object[])new Object[0]), resultListSize);
        return resultStr;
    }
}

