/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.estimate.step;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.business.ecoplatform.estimate.step.EcoEstimateBaseStep;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;

public class EcoEstimateClearData
extends EcoEstimateBaseStep {
    private static final Log log = LogFactory.getLog(EcoEstimateClearData.class);

    @Override
    public String doWork(ExecutionEnv paramExecutionEnv, int paramInt) {
        StringBuilder msg = new StringBuilder();
        super.doWork(paramExecutionEnv, paramInt);
        int dataAmount = 0;
        int logSaveDay = PdmParamSetHelper.getIntParamValue((String)"ECNLogSaveDays");
        if (logSaveDay < 99999) {
            DynamicObject planProgram = this.getPlanProgram();
            Date currentDate = new Date();
            Date delToDate = PlatformUtils.addDay((Date)currentDate, (int)(0 - logSaveDay));
            this.updateLogCount(paramInt, dataAmount += this.deleteResultData(paramExecutionEnv, delToDate, planProgram, msg));
        }
        this.clearCacheValue(paramExecutionEnv);
        return msg.toString();
    }

    public int deleteResultData(ExecutionEnv paramExecutionEnv, Date delToDate, DynamicObject planProgram, StringBuilder sb) {
        String errorMsg;
        Map<String, Object> returnMap;
        String selectProperties = "id,ecocallog";
        HashSet<Long> delResultIdSet = new HashSet<Long>(16);
        HashSet<Long> delRunLogIdSet = new HashSet<Long>(16);
        QFilter filter = new QFilter("org", "=", planProgram.getDynamicObject("createorg").getPkValue());
        filter.and(new QFilter("createtime", "<=", (Object)delToDate));
        filter.and(new QFilter("planprogram", "=", planProgram.getPkValue()));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(EcoEstimateClearData.class.getName() + "_deleteResultData"), (String)"pdm_ecoestimate_result", (String)selectProperties, (QFilter[])new QFilter[]{filter}, (String)"");){
            while (ds.hasNext()) {
                Row arow = ds.next();
                delResultIdSet.add(arow.getLong("id"));
                delRunLogIdSet.add(arow.getLong("ecocallog"));
            }
        }
        String resultStr = "";
        if (!delResultIdSet.isEmpty()) {
            returnMap = this.executeOperation(delResultIdSet, "delete", "pdm_ecoestimate_result");
            errorMsg = "";
            if (returnMap != null && returnMap.get("msg") != null) {
                errorMsg = returnMap.get("msg").toString();
                if (!PlatformUtils.isNullString((String)errorMsg)) {
                    log.info(errorMsg);
                    resultStr = String.format(ResManager.loadKDString((String)"\u5220\u9664\u8fd0\u7b97\u7ed3\u679c\u8868\u53d1\u751f\u5f02\u5e38\uff1a%1$s\u3002", (String)"EcoEstimateClearData_0", (String)"mmc-pdm-business", (Object[])new Object[0]), errorMsg);
                } else {
                    resultStr = String.format(ResManager.loadKDString((String)"\u5df2\u5220\u9664%1$s\u6761\u8fd0\u7b97\u7ed3\u679c\u8868\u6570\u636e\u3002", (String)"EcoEstimateClearData_1", (String)"mmc-pdm-business", (Object[])new Object[0]), delResultIdSet.size());
                }
            }
        }
        if (!delRunLogIdSet.isEmpty()) {
            returnMap = this.executeOperation(delRunLogIdSet, "delete", "mrp_caculate_log");
            errorMsg = "";
            if (returnMap != null && returnMap.get("msg") != null) {
                errorMsg = returnMap.get("msg").toString();
                if (!PlatformUtils.isNullString((String)errorMsg)) {
                    log.info(errorMsg);
                    resultStr = resultStr + String.format(ResManager.loadKDString((String)"\u5220\u9664\u8fd0\u7b97\u65e5\u5fd7\u8868\u53d1\u751f\u5f02\u5e38\uff0c%1$s\u3002", (String)"EcoEstimateClearData_2", (String)"mmc-pdm-business", (Object[])new Object[0]), errorMsg);
                } else {
                    resultStr = resultStr + String.format(ResManager.loadKDString((String)"\u5df2\u5220\u9664%1$s\u6761\u8fd0\u7b97\u65e5\u5fd7\u8868\u6570\u636e\u3002", (String)"EcoEstimateClearData_3", (String)"mmc-pdm-business", (Object[])new Object[0]), delRunLogIdSet.size());
                }
            }
        }
        sb.append(resultStr);
        return delResultIdSet.size() + delRunLogIdSet.size();
    }
}

