/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.estimate.step;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.GetEcoEffectOrderBusiness;
import kd.mmc.pdm.business.ecoplatform.estimate.step.EcoEstimateBaseStep;
import kd.mmc.pdm.business.ecoplatform.estimate.step.batchtask.EstimateBatchTaskEvent;
import kd.mmc.pdm.business.ecoplatform.estimate.step.exec.SRBalanceExecImpl;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTask;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;

public class EcoEstimateSRBalance
extends EcoEstimateBaseStep {
    private static final Log log = LogFactory.getLog(GetEcoEffectOrderBusiness.class);
    private static final int DEFBATCHSIZE = 100;

    @Override
    public String doWork(ExecutionEnv env, int stepIdx) {
        super.doWork(env, stepIdx);
        try {
            String supAndReqKeys = this.getCacheValue(this.getReqSupCacheString());
            Set supAndReqKeySet = PlatformUtils.ParseStringToSet((String)supAndReqKeys);
            if (supAndReqKeySet == null || supAndReqKeySet.isEmpty()) {
                return ResManager.loadKDString((String)"\u6682\u65e0\u4f9b\u9700\u5339\u914d\u6570\u636e\u3002", (String)"EcoEstimateSRBalance_0", (String)"mmc-pdm-business", (Object[])new Object[0]);
            }
            JSONArray allSupplyArray = this.getAllSupplyArray(supAndReqKeySet);
            List<Set<String>> supAndReqKeyList = this.splitData(env, allSupplyArray);
            String resultStr = this.batchExecute(env, supAndReqKeyList, stepIdx);
            return resultStr;
        }
        catch (Exception e) {
            this.clearCacheValue(env);
            throw e;
        }
    }

    public Map<String, Set<String>> initSameGroupData(ExecutionEnv env, JSONArray supplyArray) {
        String refNo;
        String groupNo;
        Long pentryId;
        Long ecoBomEntryId;
        Long materialId;
        JSONObject supObject;
        int i;
        int supSize = supplyArray.size();
        HashMap<String, HashSet<String>> groupNoMap = new HashMap<String, HashSet<String>>(16);
        HashMap<String, Set<String>> sameBatchMap = new HashMap<String, Set<String>>(supSize);
        HashSet<String> execEndIdSet = new HashSet<String>(supSize);
        HashSet<String> execSupAndReqKeySet = new HashSet<String>(64);
        for (i = 0; i < supSize; ++i) {
            supObject = supplyArray.getJSONObject(i);
            materialId = supObject.getLong("material");
            ecoBomEntryId = supObject.getLong("ecobomentryid");
            pentryId = supObject.getLong("billentryid");
            groupNo = supObject.getString("entrygroupno");
            refNo = supObject.getString("entryrefno");
            boolean isException = this.isExceptionError(supObject);
            String supAndReqKey = supObject.getString("supandreqkey");
            String keyString = "";
            if (isException && StringUtils.isEmpty((String)groupNo) && StringUtils.isEmpty((String)refNo)) {
                keyString = "error_" + ecoBomEntryId;
            } else if (StringUtils.isEmpty((String)groupNo)) {
                keyString = !StringUtils.isEmpty((String)refNo) ? "refno_" + refNo : "self_" + ecoBomEntryId;
            } else {
                String groupKeyString = "groupno_" + PlatformUtils.getUnionString((Object)pentryId, (Object)groupNo);
                HashSet<String> refNoSet = (HashSet<String>)groupNoMap.get(groupKeyString);
                if (refNoSet == null) {
                    refNoSet = new HashSet<String>(16);
                }
                if (!StringUtils.isEmpty((String)refNo)) {
                    refNoSet.add(refNo);
                }
                groupNoMap.put(groupKeyString, refNoSet);
                continue;
            }
            HashSet<String> sameBatchSet = (HashSet<String>)sameBatchMap.get(keyString);
            if (sameBatchSet == null) {
                sameBatchSet = new HashSet<String>(16);
            }
            if (execSupAndReqKeySet.add(supAndReqKey)) {
                sameBatchSet.add(supAndReqKey);
            }
            sameBatchMap.put(keyString, sameBatchSet);
            execEndIdSet.add(PlatformUtils.getUnionString((Object)ecoBomEntryId, (Object)materialId));
        }
        if (groupNoMap != null && !groupNoMap.isEmpty()) {
            for (i = 0; i < supSize; ++i) {
                HashSet<String> sameBatchSet;
                supObject = supplyArray.getJSONObject(i);
                materialId = supObject.getLong("material");
                ecoBomEntryId = supObject.getLong("ecobomentryid");
                pentryId = supObject.getLong("billentryid");
                groupNo = supObject.getString("entrygroupno");
                refNo = supObject.getString("entryrefno");
                String supAndReqKey = supObject.getString("supandreqkey");
                if (!execEndIdSet.add(PlatformUtils.getUnionString((Object)ecoBomEntryId, (Object)materialId))) continue;
                String groupKeyString = "groupno_" + PlatformUtils.getUnionString((Object)pentryId, (Object)groupNo);
                Set refNoSet = (Set)groupNoMap.get(groupKeyString);
                String keyString = "self_" + ecoBomEntryId;
                if (refNoSet != null) {
                    if (refNoSet.isEmpty()) {
                        keyString = groupKeyString;
                    } else {
                        if (StringUtils.isEmpty((String)refNo)) {
                            refNo = (String)refNoSet.iterator().next();
                        }
                        keyString = "refno_" + refNo;
                    }
                }
                if ((sameBatchSet = (HashSet<String>)sameBatchMap.get(keyString)) == null) {
                    sameBatchSet = new HashSet<String>(16);
                }
                if (execSupAndReqKeySet.add(supAndReqKey)) {
                    sameBatchSet.add(supAndReqKey);
                }
                sameBatchMap.put(keyString, sameBatchSet);
            }
        }
        return sameBatchMap;
    }

    public List<Set<String>> splitData(ExecutionEnv env, JSONArray supplyArray) {
        Map<String, Set<String>> sameBatchMap = this.initSameGroupData(env, supplyArray);
        ArrayList<Set<String>> splitKeys = new ArrayList<Set<String>>(64);
        boolean isBatchCompute = this.isBatchCompute();
        int subSize = 100;
        if (isBatchCompute && (subSize = this.getSRBatchCount()) == 0) {
            subSize = 100;
        }
        HashSet<String> supAndReqKeySet = new HashSet<String>(subSize);
        int i = 0;
        for (Map.Entry<String, Set<String>> entrys : sameBatchMap.entrySet()) {
            Set<String> subSet = entrys.getValue();
            if (PlatformUtils.isNullSet(subSet)) continue;
            supAndReqKeySet.addAll(subSet);
            if (++i != subSize) continue;
            splitKeys.add(supAndReqKeySet);
            supAndReqKeySet = new HashSet(subSize);
            i = 0;
        }
        if (i > 0) {
            splitKeys.add(supAndReqKeySet);
        }
        log.info("-----------EcoEstimateSRBalance-----splitData---------subSize:" + subSize + ",splitKeys.size=" + splitKeys.size() + ",supplyArray.size=" + supplyArray.size());
        return splitKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String batchExecute(ExecutionEnv env, List<Set<String>> supAndReqKeyList, int stepIdx) {
        boolean isBatchCompute = this.isBatchCompute();
        int dataAmount = 0;
        int resultListSize = 0;
        int pgzCount = 0;
        int pgwbCount = 0;
        int size = supAndReqKeyList.size();
        if (!isBatchCompute || this.getSRBatchCount() <= 0) {
            for (int i = 0; i < size; ++i) {
                Set<String> subKeySet = supAndReqKeyList.get(i);
                Map<String, Object> result = SRBalanceExecImpl.getInstance().exec(env, null, null, null, subKeySet, false);
                int subDataAmount = (Integer)result.get("dataAmount");
                int subResultListSize = (Integer)result.get("resultListSize");
                int subPgzCount = (Integer)result.get("pgzCount");
                int subPgwbCount = (Integer)result.get("pgwbCount");
                dataAmount += subDataAmount;
                resultListSize += subResultListSize;
                pgzCount += subPgzCount;
                pgwbCount += subPgwbCount;
            }
            this.updateLogCount(stepIdx, dataAmount);
            String resultStr = String.format(ResManager.loadKDString((String)"\u8bc4\u4f30\u7ed3\u679c\uff1a%1$s\u6761\uff1b\u8bc4\u4f30\u4e2d\uff1a%2$s\u6761\uff1b\u8bc4\u4f30\u5b8c\u6210\uff1a%3$s\u6761\u3002", (String)"EcoEstimateSRBalance_1", (String)"mmc-pdm-business", (Object[])new Object[0]), resultListSize, pgzCount, pgwbCount);
            return resultStr;
        }
        BatchTask task = BatchTask.create((String)"EcoEstimateSRBalance");
        String taskId = task.getCalcId();
        task.setQueueName(this.getConsumerQueue());
        task.registBizClass(EstimateBatchTaskEvent.class);
        task.setTimeOut(TASKTIMEOUTLONG.longValue());
        int batch = 0;
        int allDataSize = 0;
        DynamicObject planProgram = this.getPlanProgram(env);
        for (int i = 0; i < size; ++i) {
            Set<String> subKeySet = supAndReqKeyList.get(i);
            ++batch;
            allDataSize += subKeySet.size();
            HashMap<String, Object> batchParams = new HashMap<String, Object>(16);
            batchParams.put("subKeySet", subKeySet);
            batchParams.put("envCacheMap", env.getParams());
            batchParams.put("taskname", "Estimate_SRBalance");
            batchParams.put("runLog", env.getRunLog());
            batchParams.put("planProgram", planProgram);
            batchParams.put("batch", batch);
            task.addEvent(batchParams);
        }
        this.addTaskLog(taskId);
        long startTime = System.currentTimeMillis();
        boolean successful = true;
        String errorMsg = "";
        try {
            log.info(String.format(ResManager.loadKDString((String)"EcoEstimateSRBalance_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u5f00\u59cb\uff0c[%1$s]\u4e2a\u5339\u914d\u53f7\u5206\u53d1\u4e3a\u5171[%2$s]\u4e2a\u4efb\u52a1...", (String)"EcoEstimateSRBalance_3", (String)"mmc-pdm-business", (Object[])new Object[0]), allDataSize, batch));
            log.info(String.format(ResManager.loadKDString((String)"EcoEstimateSRBalance_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u5f00\u59cb\uff0c[%1$s]\u4e2a\u5339\u914d\u53f7\u5206\u53d1\u4e3a\u5171[%2$s]\u4e2a\u4efb\u52a1...", (String)"EcoEstimateSRBalance_3", (String)"mmc-pdm-business", (Object[])new Object[0]), allDataSize, batch));
            task.startTask();
            log.info(ResManager.loadKDString((String)"EcoEstimateSRBalance_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u7ed3\u675f...", (String)"EcoEstimateSRBalance_4", (String)"mmc-pdm-business", (Object[])new Object[0]));
            log.info(ResManager.loadKDString((String)"EcoEstimateSRBalance_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u7ed3\u675f...", (String)"EcoEstimateSRBalance_4", (String)"mmc-pdm-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error(ResManager.loadKDString((String)"EcoEstimateSRBalance_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u51fa\u9519\uff1a", (String)"EcoEstimateSRBalance_5", (String)("mmc-pdm-business" + e.getMessage()), (Object[])new Object[]{e}));
            log.error(ResManager.loadKDString((String)"EcoEstimateSRBalance_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u51fa\u9519\uff1a", (String)"EcoEstimateSRBalance_5", (String)("mmc-pdm-business" + e.getMessage()), (Object[])new Object[]{e}));
            successful = false;
            errorMsg = PlatformUtils.getExceptionString((Exception)e);
        }
        finally {
            task.terminate();
        }
        if (!successful) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u4f9b\u9700\u5e73\u8861\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\uff1a\u201c%1$s\u201d\u3002", (String)"EcoEstimateSRBalance_2", (String)"mmc-pdm-business", (Object[])new Object[0]), errorMsg));
        }
        long enddate = System.currentTimeMillis() - startTime;
        dataAmount = this.getIntegerCacheValue(this.getSRResultCacheString01());
        resultListSize = this.getIntegerCacheValue(this.getSRResultCacheString02());
        pgzCount = this.getIntegerCacheValue(this.getSRResultCacheString03());
        pgwbCount = this.getIntegerCacheValue(this.getSRResultCacheString04());
        this.updateLogCount(stepIdx, dataAmount);
        String resultStr = String.format(ResManager.loadKDString((String)"\u8bc4\u4f30\u7ed3\u679c\uff1a%1$s\u6761\uff1b\u8bc4\u4f30\u4e2d\uff1a%2$s\u6761\uff1b\u8bc4\u4f30\u5b8c\u6210\uff1a%3$s\u6761\u3002", (String)"EcoEstimateSRBalance_1", (String)"mmc-pdm-business", (Object[])new Object[0]), resultListSize, pgzCount, pgwbCount);
        return resultStr;
    }
}

