/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.estimate.step;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.AddEcoLogUtils;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.business.ecoplatform.estimate.step.EcoEstimateBaseStep;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;

public class EcoEstimateWriteData
extends EcoEstimateBaseStep {
    private static final Log log = LogFactory.getLog(EcoEstimateWriteData.class);
    private static final String updateSql1 = " update t_fmm_ecobomentry set facttime = ?,fusedqty = ?,festimatestatus = ? where fentryid  = ? ";
    private static final String updateSql2 = " update t_fmm_ecobomentry set fusedqty = ? ,festimatestatus = ? where fentryid  = ? ";
    private static final String updateSql3 = " update t_fmm_ecobomentry set fvaliddate = ?,facttime = ?,fusedqty = ?,festimatestatus = ? where fentryid  = ? ";
    private static final String updateSql4 = " update T_PDM_ESTIMATERESULT set fupdateecoresultmsg = ?,FUPDATEECORESULT = ? where fid  = ? ";

    private String getResultSelectPropertirs() {
        StringBuilder sb = new StringBuilder();
        sb.append("org");
        sb.append(",").append("id");
        sb.append(",").append("billno");
        sb.append(",").append("planprogram");
        sb.append(",").append("material");
        sb.append(",").append("featuretype");
        sb.append(",").append("supplyorg");
        sb.append(",").append("supplybilltype");
        sb.append(",").append("supplyqty");
        sb.append(",").append("supplydate");
        sb.append(",").append("supplybillid");
        sb.append(",").append("supplybillno");
        sb.append(",").append("supplyentryid");
        sb.append(",").append("supplyseq");
        sb.append(",").append("ecobomentryid");
        sb.append(",").append("ecobomid");
        sb.append(",").append("ecotype");
        sb.append(",").append("bomid");
        sb.append(",").append("entrymode");
        sb.append(",").append("groupkeynumbers");
        sb.append(",").append("refkeynumbers");
        sb.append(",").append("entrygroupno");
        sb.append(",").append("entryrefno");
        sb.append(",").append("oldestimatestatus");
        sb.append(",").append("estimatestatus");
        sb.append(",").append("useqty");
        sb.append(",").append("groupuseqty");
        sb.append(",").append("refuseqty");
        sb.append(",").append("exceptiontype");
        sb.append(",").append("exceptioninfo");
        sb.append(",").append("ecocallog");
        sb.append(",").append("entryvaliddate");
        sb.append(",").append("entryinvaliddate");
        sb.append(",").append("initacttime");
        sb.append(",").append("oldacttime");
        sb.append(",").append("groupacttime");
        sb.append(",").append("refacttime");
        sb.append(",").append("afteracttime");
        sb.append(",").append("afteruseqty");
        return sb.toString();
    }

    @Override
    public String doWork(ExecutionEnv env, int stepIdx) {
        super.doWork(env, stepIdx);
        QFilter qfilter = new QFilter("ecocallog.id", "=", (Object)env.getCtxId());
        qfilter.and(new QFilter("exceptiontype", "in", Arrays.asList("A", "B")));
        DynamicObjectCollection resultColl = QueryServiceHelper.query((String)"pdm_ecoestimate_result", (String)this.getResultSelectPropertirs(), (QFilter[])new QFilter[]{qfilter});
        if (resultColl == null || resultColl.isEmpty()) {
            return ResManager.loadKDString((String)"\u672a\u627e\u5230\u8bc4\u4f30\u7ed3\u679c\u6570\u636e\u3002", (String)"EcoEstimateWriteData_0", (String)"mmc-pdm-business", (Object[])new Object[0]);
        }
        int dataAmount = resultColl.size();
        HashMap<Long, DynamicObject> ecoTypeMap = new HashMap<Long, DynamicObject>(16);
        long execTimeLong1 = 0L;
        long startTime1 = 0L;
        Map<String, List<DynamicObject>> sameBatchMap = this.initSameBatchData(resultColl);
        Date currentDate = new Date();
        startTime1 = System.currentTimeMillis();
        HashSet ecoBomEntryIdSet = new HashSet(64);
        int errorcount = 0;
        for (Map.Entry<String, List<DynamicObject>> entrys : sameBatchMap.entrySet()) {
            List<DynamicObject> sameBatchResultList = entrys.getValue();
            Map<String, Object> retMap = this.updateEcoBill(sameBatchResultList, ecoTypeMap, currentDate);
            boolean isSuccess = (Boolean)retMap.get("success");
            if (!isSuccess) {
                errorcount += sameBatchResultList.size();
                continue;
            }
            HashSet succEntryIdSet = (HashSet)retMap.get("ecoBomEntryIdSet");
            if (PlatformUtils.isNullSet((Set)succEntryIdSet)) continue;
            ecoBomEntryIdSet.addAll(succEntryIdSet);
        }
        execTimeLong1 = System.currentTimeMillis() - startTime1;
        this.updateLogCount(stepIdx, dataAmount);
        String resultStr = String.format(ResManager.loadKDString((String)"\u8bc4\u4f30\u7ed3\u679c\u5171\u201c%1$s\u201d\u6761\uff0c\u53cd\u5199ECN\u5355\u636e\u53d1\u751f\u9519\u8bef\u201c%2$s\u201d\u6761\uff0c\u66f4\u65b0\u5de5\u7a0b\u53d8\u66f4\u5355\u53caBOM\u6570\u636e\u8017\u65f6\u201c%3$s\u201dms\u3002", (String)"EcoEstimateWriteData_1", (String)"mmc-pdm-business", (Object[])new Object[0]), dataAmount, errorcount, execTimeLong1);
        if (!ecoBomEntryIdSet.isEmpty()) {
            this.setCacheValue(env, this.getEffectOrderIdCacheString(), ((Object)ecoBomEntryIdSet).toString(), this.getRedisTimeLong());
            log.info("-----------EcoEstimateWriteData----effectOrderEcoBomEntryIds---------ecoBomEntryIdSet.size:" + ecoBomEntryIdSet.size());
        }
        return resultStr;
    }

    private Map<String, Object> updateEcoBill(List<DynamicObject> resultList, Map<Long, DynamicObject> ecoTypeMap, Date runLogDate) {
        int size = resultList.size();
        ArrayList<Object[]> paramList1 = new ArrayList<Object[]>(size);
        ArrayList<Object[]> paramList2 = new ArrayList<Object[]>(size);
        ArrayList<Object[]> paramList3 = new ArrayList<Object[]>(size);
        HashSet<Long> ecoBomEntryIdSet = new HashSet<Long>(size);
        String errorDetialString = "";
        String errorSimpleString = "";
        DynamicObject result00 = resultList.get(0);
        String logremark = String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u8bc4\u4f30\u8fd0\u7b97\uff1a%1$s\u3002", (String)"EcoEstimateWriteData_2", (String)"mmc-pdm-business", (Object[])new Object[0]), result00.getString("billno"));
        try (TXHandle required = TX.required((String)"EcoEstimateWriteData-updateEcoBill");){
            try {
                HashSet<Long> updateOthersEntryIdSet = new HashSet<Long>(size);
                ArrayList<DynamicObject> ecoRecordLogList = new ArrayList<DynamicObject>(size);
                HashMap<String, DynamicObject> ecoRecordLogMap = new HashMap<String, DynamicObject>(size);
                for (int i = 0; i < size; ++i) {
                    Object[] param;
                    DynamicObject result = resultList.get(i);
                    if (this.isExceptionError(result)) continue;
                    Long entryId = result.getLong("ecobomentryid");
                    Date actTime = this.getActTime(result);
                    String estimateStatus = result.getString("estimatestatus");
                    String oldEstimateStatus = result.getString("oldestimatestatus");
                    if (StringUtils.isEmpty((String)estimateStatus)) {
                        estimateStatus = oldEstimateStatus;
                    }
                    if (StringUtils.isEmpty((String)estimateStatus)) {
                        estimateStatus = "A";
                    }
                    Long ecoTypeId = this.getEcoTypeId(result);
                    if ("C".equals(oldEstimateStatus)) {
                        estimateStatus = "C";
                    } else if ("B".equals(oldEstimateStatus) && "A".equals(estimateStatus)) {
                        estimateStatus = "B";
                    }
                    BigDecimal useQty = this.getUseQty(result);
                    if (actTime == null) {
                        param = new Object[]{useQty, estimateStatus, entryId};
                        paramList2.add(param);
                    } else if ("A".equals(result.getString("entrymode"))) {
                        param = new Object[]{actTime, actTime, useQty, estimateStatus, entryId};
                        paramList3.add(param);
                    } else {
                        param = new Object[]{actTime, useQty, estimateStatus, entryId};
                        paramList1.add(param);
                    }
                    updateOthersEntryIdSet.add(entryId);
                    if (actTime != null && !PlatformUtils.isNullLong((Long)ecoTypeId) && this.isUpdateOrder(ecoTypeId, ecoTypeMap)) {
                        ecoBomEntryIdSet.add(entryId);
                    }
                    this.addEcoLog(result, ecoRecordLogMap, ecoRecordLogList, logremark, actTime, estimateStatus);
                }
                if (!paramList1.isEmpty()) {
                    DB.executeBatch((DBRoute)scmDBRoute, (String)updateSql1, paramList1);
                }
                if (!paramList2.isEmpty()) {
                    DB.executeBatch((DBRoute)scmDBRoute, (String)updateSql2, paramList2);
                }
                if (!paramList3.isEmpty()) {
                    DB.executeBatch((DBRoute)scmDBRoute, (String)updateSql3, paramList3);
                }
                if (!ecoRecordLogList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])ecoRecordLogList.toArray(new DynamicObject[ecoRecordLogList.size()]), (OperateOption)OperateOption.create());
                }
                if (!updateOthersEntryIdSet.isEmpty()) {
                    List<DynamicObject> othersEcoBomEntryList = EcoUtils.updateRefDataActtime(updateOthersEntryIdSet, "estimatecompute", logremark);
                    EcoUtils.updateMftBomData(othersEcoBomEntryList, "estimatecompute");
                }
            }
            catch (KDException e) {
                log.error((Throwable)e);
                errorDetialString = this.getExceptionString((Exception)((Object)e));
                errorSimpleString = this.getExceptionSampleString((Exception)((Object)e));
                required.markRollback();
            }
            catch (Exception e) {
                log.error((Throwable)e);
                errorDetialString = this.getExceptionString(e);
                errorSimpleString = this.getExceptionSampleString(e);
                required.markRollback();
            }
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>(16);
        if (!StringUtils.isEmpty((String)errorDetialString)) {
            this.updateErrorInfo(resultList, errorDetialString, errorSimpleString);
            ecoBomEntryIdSet.clear();
            retMap.put("success", false);
        } else {
            retMap.put("success", true);
        }
        retMap.put("ecoBomEntryIdSet", ecoBomEntryIdSet);
        return retMap;
    }

    private boolean isUpdateOrder(Long ecoId, Map<Long, DynamicObject> dyMap) {
        DynamicObject dy;
        if (dyMap == null) {
            dyMap = new HashMap<Long, DynamicObject>(16);
        }
        if ((dy = dyMap.get(ecoId)) == null) {
            dy = BusinessDataServiceHelper.loadSingleFromCache((Object)ecoId, (String)"pdm_ecotype");
            dyMap.put(ecoId, dy);
        }
        return dy.getBoolean("autoupdateorder");
    }

    private Date getActTime(DynamicObject result) {
        return result.getDate("afteracttime") == null ? result.getDate("initacttime") : result.getDate("afteracttime");
    }

    private BigDecimal getUseQty(DynamicObject result) {
        return result.getBigDecimal("afteruseqty");
    }

    private Long getEcoTypeId(DynamicObject result) {
        Object ecoType = result.get("ecotype");
        if (ecoType == null) {
            return 0L;
        }
        if (ecoType instanceof DynamicObject) {
            return ((DynamicObject)ecoType).getLong("id");
        }
        return (Long)ecoType;
    }

    private int getEstimatestatusday(Long ecoId, Map<Long, DynamicObject> dyMap) {
        DynamicObject dy;
        if (dyMap == null) {
            dyMap = new HashMap<Long, DynamicObject>(16);
        }
        if ((dy = dyMap.get(ecoId)) == null) {
            dy = BusinessDataServiceHelper.loadSingleFromCache((Object)ecoId, (String)"pdm_ecotype");
            dyMap.put(ecoId, dy);
        }
        return dy.getInt("estimatestatusday");
    }

    private Map<String, List<DynamicObject>> initSameBatchData(DynamicObjectCollection resultColl) {
        String pentryId;
        String groupNo;
        String refno;
        Long resultId;
        HashMap<String, List<DynamicObject>> sameBatchMap = new HashMap<String, List<DynamicObject>>(resultColl.size());
        HashMap<String, HashSet<String>> groupNoMap = new HashMap<String, HashSet<String>>(16);
        HashSet<Long> execEndIdSet = new HashSet<Long>(resultColl.size());
        log.info("------EcoEstimateWriteData.initSameBatchData begin,resultColl.size =" + resultColl.size());
        for (DynamicObject result : resultColl) {
            resultId = result.getLong("id");
            refno = result.get("entryrefno") == null ? "" : result.getString("entryrefno");
            groupNo = result.getString("entrygroupno");
            pentryId = result.getString("supplyentryid");
            String keyString = "";
            if (StringUtils.isEmpty((String)groupNo)) {
                keyString = !StringUtils.isEmpty((String)refno) ? "refno_" + refno : "self_" + resultId;
            } else {
                String groupKeyString = "groupno_" + PlatformUtils.getUnionString((Object)pentryId, (Object)groupNo);
                HashSet<String> refNoSet = (HashSet<String>)groupNoMap.get(groupKeyString);
                if (refNoSet == null) {
                    refNoSet = new HashSet<String>(16);
                }
                if (!StringUtils.isEmpty((String)refno)) {
                    refNoSet.add(refno);
                }
                groupNoMap.put(groupKeyString, refNoSet);
                continue;
            }
            ArrayList<DynamicObject> sameBatchDynamicObjectList = (ArrayList<DynamicObject>)sameBatchMap.get(keyString);
            if (sameBatchDynamicObjectList == null) {
                sameBatchDynamicObjectList = new ArrayList<DynamicObject>(16);
            }
            execEndIdSet.add(resultId);
            sameBatchDynamicObjectList.add(result);
            sameBatchMap.put(keyString, sameBatchDynamicObjectList);
        }
        if (groupNoMap != null && !groupNoMap.isEmpty()) {
            log.info("------EcoEstimateWriteData.initSameBatchData exec groupno,groupNoMap.size =" + groupNoMap.size());
            for (DynamicObject result : resultColl) {
                ArrayList<DynamicObject> sameBatchDynamicObjectList;
                resultId = result.getLong("id");
                if (!execEndIdSet.add(resultId)) continue;
                refno = result.get("entryrefno") == null ? "" : result.getString("entryrefno");
                groupNo = result.getString("entrygroupno");
                pentryId = result.getString("supplyentryid");
                String groupKeyString = "groupno_" + PlatformUtils.getUnionString((Object)pentryId, (Object)groupNo);
                Set refNoSet = (Set)groupNoMap.get(groupKeyString);
                String keyString = "self_" + resultId;
                if (refNoSet != null) {
                    if (refNoSet.isEmpty()) {
                        keyString = groupKeyString;
                    } else {
                        if (StringUtils.isEmpty((String)refno)) {
                            refno = (String)refNoSet.iterator().next();
                        }
                        keyString = "refno_" + refno;
                    }
                }
                if ((sameBatchDynamicObjectList = (ArrayList<DynamicObject>)sameBatchMap.get(keyString)) == null) {
                    sameBatchDynamicObjectList = new ArrayList<DynamicObject>(16);
                }
                sameBatchDynamicObjectList.add(result);
                sameBatchMap.put(keyString, sameBatchDynamicObjectList);
            }
        }
        log.info("------EcoEstimateWriteData.initSameBatchData end,sameBatchMap.size =" + sameBatchMap.size());
        return sameBatchMap;
    }

    public void updateErrorInfo(List<DynamicObject> resultList, String detialErrorString, String simpleErrorString) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(resultList.size());
        for (DynamicObject dy : resultList) {
            Long resultId = dy.getLong("id");
            paramList.add(new Object[]{simpleErrorString, detialErrorString, resultId});
        }
        DB.executeBatch((DBRoute)scmDBRoute, (String)updateSql4, paramList);
    }

    public String getExceptionSampleString(Exception ex) {
        String msg = ex.getMessage();
        if (msg != null && msg.length() > 240) {
            msg = msg.substring(0, 240);
        }
        return String.format(ResManager.loadKDString((String)"\u5931\u8d25:%1$s\u3002", (String)"EcoEstimateWriteData_3", (String)"mmc-pdm-business", (Object[])new Object[0]), msg);
    }

    public String getExceptionString(Exception ex) {
        String sOut = PlatformUtils.getExceptionString((Exception)ex);
        if (sOut.length() > 1999) {
            sOut = sOut.substring(0, 1998);
        }
        return sOut;
    }

    private void addEcoLog(DynamicObject result, Map<String, DynamicObject> ecoRecordLogMap, List<DynamicObject> ecoRecordLogList, String logremark, Date newActTime, String newEstimatestatus) {
        Date oldActTime = result.getDate("initacttime");
        String oldEstimateStatus = result.getString("oldestimatestatus");
        if (PlatformUtils.isDiffDate((Date)oldActTime, (Date)newActTime) || PlatformUtils.isDiffString((String)oldEstimateStatus, (String)newEstimatestatus)) {
            AddEcoLogUtils.addEcoLogByEstimate(result, ecoRecordLogMap, ecoRecordLogList, logremark, oldActTime, oldEstimateStatus, newActTime, newEstimatestatus);
        }
    }
}

