/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.estimate.step.exec;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.estimate.step.EcoEstimateBaseStep;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;

public class EffectRangeSRMatchExecImpl
extends EcoEstimateBaseStep {
    private static final Log log = LogFactory.getLog(EffectRangeSRMatchExecImpl.class);
    private static EffectRangeSRMatchExecImpl impl;

    public static EffectRangeSRMatchExecImpl getInstance() {
        if (impl == null) {
            impl = new EffectRangeSRMatchExecImpl();
        }
        return impl;
    }

    public Map<String, Object> exec(ExecutionEnv env, DynamicObject planProgram, DynamicObject runLog, Map<String, String> envCacheMap, Set<String> supAndReqKeySet, boolean isCache) {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(supAndReqKeySet.size());
        if (env != null) {
            this.init(env);
            envCacheMap = env.getParams();
            runLog = env.getRunLog();
            planProgram = this.getPlanProgram(env);
        } else {
            this.init(runLog);
        }
        int dataAmount = 0;
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(16);
        HashMap<String, DynamicObject> resultEntryMap = new HashMap<String, DynamicObject>(16);
        Map<String, String> redisMap = this.loadRedisCacheData(supAndReqKeySet);
        log.info("EffectRangeSRMatchExecImpl-supAndReqKeySet.size = " + supAndReqKeySet.size());
        HashMap<Long, JSONArray> supplyMap = new HashMap<Long, JSONArray>(64);
        HashMap<Long, JSONArray> requireMap = new HashMap<Long, JSONArray>(64);
        this.initGroupByEcoBomEntry(supAndReqKeySet, redisMap, supplyMap, requireMap);
        for (Map.Entry reqs : requireMap.entrySet()) {
            JSONArray supplyArray;
            Long ecoBomEntryId = (Long)reqs.getKey();
            JSONArray requireArray = (JSONArray)reqs.getValue();
            if (requireArray == null || requireArray.isEmpty() || (supplyArray = (JSONArray)supplyMap.get(ecoBomEntryId)) == null || supplyArray.isEmpty()) continue;
            int supSize = supplyArray.size();
            int reqSize = requireArray.size();
            if (supSize > 1) {
                supplyArray.sort(Comparator.comparing(obj -> ((JSONObject)obj).getDate("billdate"), Comparator.nullsFirst(Comparator.naturalOrder())));
            }
            for (int i = 0; i < reqSize; ++i) {
                ++dataAmount;
                JSONObject reqObject = requireArray.getJSONObject(i);
                Long materialId = reqObject.getLong("material");
                DynamicObject result = (DynamicObject)resultMap.get(ecoBomEntryId);
                if (result == null) {
                    result = this.addResultHeadData(resultList, reqObject, runLog, planProgram);
                    resultMap.put(ecoBomEntryId, result);
                }
                this.genMulMaterialValue(materialId, result);
                for (int j = 0; j < supSize; ++j) {
                    ++dataAmount;
                    JSONObject supObject = supplyArray.getJSONObject(j);
                    Long billEntryId = supObject.getLong("billentryid");
                    String billEntryIds = "";
                    if (PlatformUtils.isNullLong((Long)billEntryId)) {
                        billEntryId = supObject.getLong("billid");
                        billEntryIds = String.valueOf(billEntryId) + "_" + String.valueOf(supObject.getLong("material") + "_" + String.valueOf(supObject.getLong("materialflexprops")));
                    } else {
                        billEntryIds = String.valueOf(billEntryId);
                    }
                    String entryDyKeyString = PlatformUtils.getUnionString((Object)ecoBomEntryId, (Object)billEntryIds);
                    DynamicObject entry = (DynamicObject)resultEntryMap.get(entryDyKeyString);
                    if (entry != null) continue;
                    entry = this.addResultEntryData(result, supObject, runLog);
                    resultEntryMap.put(entryDyKeyString, entry);
                }
            }
        }
        log.info("EffectRangeSRMatchExecImpl-resultList.size = " + resultList.size());
        try (TXHandle required = TX.required();){
            this.saveResult(resultList);
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        returnMap.put("dataAmount", dataAmount);
        returnMap.put("resultListSize", resultList.size());
        if (isCache) {
            int redisTimeLong = this.getRedisTimeLong();
            String sr01 = this.getSRResultCacheString01();
            String sr02 = this.getSRResultCacheString02();
            this.getAndSetAddCacheValueLock(envCacheMap, sr01, dataAmount, redisTimeLong);
            this.getAndSetAddCacheValueLock(envCacheMap, sr02, resultList.size(), redisTimeLong);
        }
        return returnMap;
    }

    public Map<String, String> loadRedisCacheData(Set<String> supAndReqKeySet) {
        if (supAndReqKeySet == null || supAndReqKeySet.isEmpty()) {
            return new HashMap<String, String>(16);
        }
        HashMap<String, String> dataMap = new HashMap<String, String>(supAndReqKeySet.size());
        for (String cacheKeyString : supAndReqKeySet) {
            String supplyKeys = this.getSupplyCacheString(cacheKeyString);
            String requireKeys = this.getRequireCacheString(cacheKeyString);
            String supplys = this.getCacheValue(supplyKeys);
            String requires = this.getCacheValue(requireKeys);
            dataMap.put(supplyKeys, supplys);
            dataMap.put(requireKeys, requires);
        }
        return dataMap;
    }

    public void initGroupByEcoBomEntry(Set<String> supAndReqKeySet, Map<String, String> redisMap, Map<Long, JSONArray> supplyMap, Map<Long, JSONArray> requireMap) {
        for (String cacheKeyString : supAndReqKeySet) {
            JSONArray requireArray;
            String requires = redisMap.get(this.getRequireCacheString(cacheKeyString));
            if (StringUtils.isEmpty((String)requires) || (requireArray = JSONObject.parseArray((String)requires)) == null || requireArray.isEmpty()) continue;
            String supplys = redisMap.get(this.getSupplyCacheString(cacheKeyString));
            JSONArray supplyArray = new JSONArray();
            if (!StringUtils.isEmpty((String)supplys)) {
                supplyArray = JSONObject.parseArray((String)supplys);
            }
            int reqSize = requireArray.size();
            int supSize = supplyArray.size();
            for (int i = 0; i < reqSize; ++i) {
                JSONObject reqObject = requireArray.getJSONObject(i);
                Long ecoBomEntryId = this.getRequireKeyId(reqObject);
                JSONArray newRequireArray = requireMap.get(ecoBomEntryId);
                if (newRequireArray == null) {
                    newRequireArray = new JSONArray();
                }
                newRequireArray.add((Object)reqObject);
                requireMap.put(ecoBomEntryId, newRequireArray);
                JSONArray newSupplyArray = supplyMap.get(ecoBomEntryId);
                if (newSupplyArray == null) {
                    newSupplyArray = new JSONArray();
                }
                for (int j = 0; j < supSize; ++j) {
                    JSONObject supObject = supplyArray.getJSONObject(j);
                    if (!this.isDataSourceMatch(reqObject, supObject)) continue;
                    newSupplyArray.add((Object)supObject);
                }
                supplyMap.put(ecoBomEntryId, newSupplyArray);
            }
        }
    }

    private boolean isDataSourceMatch(JSONObject reqObject, JSONObject supObject) {
        Long reqDsId = reqObject.getLong("srcdatasource");
        if (PlatformUtils.isNullLong((Long)reqDsId)) {
            return Boolean.TRUE;
        }
        String srcReqDsIds = supObject.getString("srcdatasourceids");
        if (PlatformUtils.isNullString((String)srcReqDsIds)) {
            return Boolean.TRUE;
        }
        if (srcReqDsIds.indexOf(String.valueOf(reqDsId)) >= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Long getRequireKeyId(JSONObject reqObject) {
        Long ecoBomEntryId = reqObject.getLong("ecobomentryid");
        if (PlatformUtils.isNullLong((Long)ecoBomEntryId)) {
            ecoBomEntryId = reqObject.getLong("billentryid");
        }
        if (PlatformUtils.isNullLong((Long)ecoBomEntryId)) {
            ecoBomEntryId = reqObject.getLong("billid");
        }
        return ecoBomEntryId;
    }

    public DynamicObject addResultHeadData(List<DynamicObject> resultList, JSONObject reqObject, DynamicObject runLog, DynamicObject planProgram) {
        DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)"pdm_ecoestimate_result");
        result.set("org", (Object)runLog.getDynamicObject("createorg"));
        result.set("billno", (Object)runLog.getString("number"));
        result.set("billstatus", (Object)"A");
        result.set("planprogram", (Object)planProgram);
        result.set("material", (Object)reqObject.getLong("material"));
        result.set("featuretype", (Object)reqObject.getLong("featuretype"));
        result.set("baseunit", (Object)reqObject.getLong("baseunit"));
        result.set("materialattr", (Object)reqObject.getString("materialattr"));
        result.set("supplyorg", (Object)reqObject.getLong("productionorgunit"));
        result.set("supplybilltype", (Object)reqObject.getLong("billtype"));
        result.set("supplyqty", (Object)reqObject.getBigDecimal("demandqty"));
        result.set("supplydate", (Object)reqObject.getDate("billdate"));
        result.set("supplybillid", (Object)reqObject.getLong("billid"));
        result.set("supplybillno", (Object)reqObject.getString("billnumber"));
        result.set("supplyentryid", (Object)reqObject.getLong("billentryid"));
        result.set("ecobomentryid", (Object)reqObject.getLong("ecobomentryid"));
        result.set("ecobomid", (Object)reqObject.getLong("ecobomid"));
        result.set("supplyseq", (Object)reqObject.getInteger("billentryseq"));
        result.set("supplyauxproperty", (Object)reqObject.getLong("materialflexprops"));
        result.set("version", (Object)reqObject.getLong("bomreversion"));
        result.set("ecotype", (Object)reqObject.getLong("ecotypeid"));
        result.set("bomnumber", (Object)reqObject.getString("bomnumber"));
        result.set("bomentryid", (Object)reqObject.getLong("bomentryid"));
        result.set("entrymode", (Object)reqObject.getString("entrymode"));
        result.set("useqty", (Object)BigDecimal.ZERO);
        result.set("exceptiontype", (Object)reqObject.getString("exceptiontype"));
        result.set("exceptioninfo", (Object)reqObject.getString("exceptioninfo"));
        result.set("ecocallog", (Object)runLog);
        result.set("entryvaliddate", (Object)reqObject.getDate("entryvaliddate"));
        result.set("entryinvaliddate", (Object)reqObject.getDate("entryinvaliddate"));
        result.set("creator", (Object)RequestContext.get().getCurrUserId());
        result.set("srcdatasource", (Object)reqObject.getLong("srcdatasource"));
        result.set("getdatatype", (Object)(StringUtils.isEmpty((String)reqObject.getString("getdatatype")) ? "A" : reqObject.getString("getdatatype")));
        resultList.add(result);
        return result;
    }

    public DynamicObject addResultEntryData(DynamicObject head, JSONObject supObject, DynamicObject runLog) {
        DynamicObjectCollection coll = head.getDynamicObjectCollection("entryentity");
        DynamicObject entry = coll.addNew();
        entry.set("requirebillno", (Object)supObject.getString("billnumber"));
        entry.set("requirebillid", (Object)supObject.getLong("billid"));
        entry.set("requirebillentryid", (Object)supObject.getLong("billentryid"));
        entry.set("requirebillentryseq", (Object)supObject.getInteger("billentryseq"));
        entry.set("requireqty", (Object)supObject.getBigDecimal("qty"));
        entry.set("requiredate", (Object)supObject.getDate("billdate"));
        entry.set("requirebilltype", (Object)supObject.getLong("billtype"));
        entry.set("requirebilltypename", (Object)this.getBillTypeName(supObject.getLong("billtype")));
        entry.set("requirematerial", (Object)supObject.getLong("material"));
        entry.set("requirekey", (Object)Boolean.FALSE);
        entry.set("requiregroupkey", (Object)Boolean.FALSE);
        entry.set("requirerefkey", (Object)Boolean.FALSE);
        entry.set("afterestimatekey", (Object)Boolean.FALSE);
        entry.set("usetype", (Object)"B");
        entry.set("sortseq", (Object)coll.size());
        entry.set("requirebaseunit", (Object)supObject.getLong("baseunit"));
        entry.set("warehouse", (Object)supObject.getLong("stock"));
        entry.set("location", (Object)supObject.getLong("stockindex"));
        entry.set("invstatus", (Object)supObject.getLong("stockstatus"));
        entry.set("invtype", (Object)supObject.getLong("stocktype"));
        entry.set("configurecode", (Object)supObject.getLong("configuredcode"));
        entry.set("project", (Object)supObject.getLong("projectnumber"));
        entry.set("tracknumber", (Object)supObject.getLong("tracknumber"));
        entry.set("requirebillstatus", (Object)supObject.getString("billstatusfield"));
        return entry;
    }
}

