/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.estimate.step.exec;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.estimate.step.EcoEstimateBaseStep;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mpscmm.msplan.mservice.service.datafetch.util.DataSourceFetchDataUtil;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;

public class GetRequireDataExecImpl
extends EcoEstimateBaseStep {
    private static final Log log = LogFactory.getLog(GetRequireDataExecImpl.class);
    private static GetRequireDataExecImpl impl;

    public static GetRequireDataExecImpl getInstance() {
        if (impl == null) {
            impl = new GetRequireDataExecImpl();
        }
        return impl;
    }

    public int exec(ExecutionEnv env, DynamicObject planProgram, DynamicObject runLog, Map<String, String> envCacheMap, Set<String> supAndReqKeySet, Set<Long> materialIdSet, Date minSupplyDate, List<Long> modelIds, boolean isCache) {
        if (env != null) {
            this.init(env);
            envCacheMap = env.getParams();
        } else {
            this.init(runLog);
        }
        int planOutLookDay = this.getPlanOutLook(planProgram);
        int supplyDelayPeriod = this.getRequireDelayPeriod(planProgram);
        Set<Long> demandOrgs = this.getSupplyOrgs(planProgram);
        Date currentDate = new Date();
        Date toDate = PlatformUtils.addDay((Date)currentDate, (int)planOutLookDay);
        Date fromDate = PlatformUtils.addDay((Date)currentDate, (int)(0 - supplyDelayPeriod));
        Date toMinDate = this.getDate(fromDate, true);
        Date toMaxDate = this.getDate(toDate, false);
        if (minSupplyDate != null && minSupplyDate.after(toMinDate)) {
            toMinDate = minSupplyDate;
        }
        boolean isMerge = this.isMergeRquireData();
        int dataAmount = 0;
        String[] keyFieldNames = this.getRequireCacheRedisKeyField(planProgram);
        int redisTimeLong = this.getRedisTimeLong();
        JSONObject reqObject = new JSONObject();
        Map<Long, String> srcEntityNameMap = this.getSrcEntityName(modelIds);
        Map<Long, String> srcOrgFieldMap = this.getReqOrgSrcFieldMap(modelIds);
        HashMap<String, JSONObject> mergeMap = new HashMap<String, JSONObject>(128);
        for (Long modelId : modelIds) {
            String srcEntityName = srcEntityNameMap.get(modelId);
            DataSet dsItem = null;
            QFilter filter = null;
            String orgFieldNumber = srcOrgFieldMap.get(modelId);
            if (StringUtils.isEmpty((String)orgFieldNumber)) {
                log.info("------------EcoEstimateGetRequireData------dsItem is null -------modelId=" + modelId + ",orgFieldNumber is null ,continue ");
                continue;
            }
            QFilter orgQFilter = new QFilter(orgFieldNumber, "in", demandOrgs);
            if ("pom_mftstock".equalsIgnoreCase(srcEntityName) || "om_mftstock".equalsIgnoreCase(srcEntityName)) {
                if (!"1".equals(planProgram.getString("outofdate"))) {
                    filter = new QFilter("stockentry.demanddate", ">=", (Object)toMinDate);
                    filter.and(new QFilter("stockentry.demanddate", "<=", (Object)toMaxDate));
                    dsItem = DataSourceFetchDataUtil.getDataSetByModel((Long)modelId, materialIdSet, (QFilter)filter.and(orgQFilter));
                } else if (minSupplyDate != null) {
                    filter = new QFilter("stockentry.demanddate", ">=", (Object)minSupplyDate);
                    dsItem = DataSourceFetchDataUtil.getDataSetByModel((Long)modelId, materialIdSet, (QFilter)filter.and(orgQFilter));
                } else {
                    dsItem = DataSourceFetchDataUtil.getDataSetByModel((Long)modelId, materialIdSet, (QFilter)orgQFilter);
                }
            } else {
                dsItem = DataSourceFetchDataUtil.getDataSetByModel((Long)modelId, materialIdSet, (QFilter)orgQFilter);
            }
            if (dsItem == null) {
                log.info("------------EcoEstimateGetRequireData------dsItem is null -------modelId=" + modelId + ",srcEntityName=" + srcEntityName + ",materialIdSet=" + materialIdSet.toString());
                if (filter != null) {
                    log.info("------------EcoEstimateGetRequireData------dsItem is null -------filter=" + filter);
                }
                log.info("------------EcoEstimateGetRequireData------dsItem is null -------orgQFilter=" + orgQFilter);
                continue;
            }
            dsItem = this.formatEntryEntity(dsItem);
            RowMeta rowMeta = dsItem.getRowMeta();
            String[] fieldNames = rowMeta.getFieldNames();
            while (dsItem.hasNext()) {
                JSONArray list;
                Row row = dsItem.next();
                String cacheKeyString = this.getRowKeyString(row, keyFieldNames, null);
                if (!supAndReqKeySet.contains(cacheKeyString)) continue;
                JSONObject dataObject = new JSONObject();
                for (int keySize = 0; keySize < fieldNames.length; ++keySize) {
                    String fieldName = fieldNames[keySize];
                    Object value = row.get(fieldName);
                    dataObject.put(fieldName, value);
                }
                dataObject.put("thisusedqty", (Object)BigDecimal.ZERO);
                if (isMerge) {
                    String mergeKeys = cacheKeyString + "_" + dataObject.getLongValue("billid") + "_" + dataObject.getDate("billdate").getTime();
                    JSONObject oldJson = (JSONObject)mergeMap.get(mergeKeys);
                    if (oldJson == null) {
                        mergeMap.put(mergeKeys, dataObject);
                    } else {
                        BigDecimal oldQty = oldJson.getBigDecimal("demandqty");
                        BigDecimal oldRecQty = oldJson.getBigDecimal("recqty");
                        BigDecimal newQty = dataObject.getBigDecimal("demandqty");
                        BigDecimal newRecQty = dataObject.getBigDecimal("recqty");
                        oldJson.put("demandqty", (Object)oldQty.add(newQty));
                        oldJson.put("recqty", (Object)oldRecQty.add(newRecQty));
                        ++dataAmount;
                        continue;
                    }
                }
                if ((list = reqObject.getJSONArray(cacheKeyString)) == null) {
                    list = new JSONArray(64);
                }
                list.add((Object)dataObject);
                reqObject.put(cacheKeyString, (Object)list);
                ++dataAmount;
            }
            dsItem.close();
        }
        for (String cacheKeyString : supAndReqKeySet) {
            JSONArray list = reqObject.getJSONArray(cacheKeyString);
            if (list == null || list.isEmpty()) continue;
            this.setCacheValue(envCacheMap, this.getRequireCacheString(cacheKeyString), list.toJSONString(), redisTimeLong);
        }
        if (isCache) {
            String requireDataAmountCacheStr = this.getRequireDataAmountCacheString();
            this.getAndSetAddCacheValueLock(envCacheMap, requireDataAmountCacheStr, dataAmount, redisTimeLong);
        }
        return dataAmount;
    }
}

