/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.estimate.step.exec;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.ActTimeBean;
import kd.mmc.pdm.business.ecoplatform.ActTimeValidataBusiness;
import kd.mmc.pdm.business.ecoplatform.estimate.step.EcoEstimateBaseStep;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;

public class SRBalanceExecImpl
extends EcoEstimateBaseStep {
    private static final Log log = LogFactory.getLog(SRBalanceExecImpl.class);
    private static SRBalanceExecImpl impl;

    public static SRBalanceExecImpl getInstance() {
        if (impl == null) {
            impl = new SRBalanceExecImpl();
        }
        return impl;
    }

    public Map<String, Object> exec(ExecutionEnv env, DynamicObject planProgram, DynamicObject runLog, Map<String, String> envCacheMap, Set<String> supAndReqKeySet, boolean isCache) {
        DynamicObject result;
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(supAndReqKeySet.size());
        if (env != null) {
            this.init(env);
            envCacheMap = env.getParams();
            runLog = env.getRunLog();
            planProgram = this.getPlanProgram(env);
        } else {
            this.init(runLog);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int dataAmount = 0;
        boolean isEstimateStatusUpdate = this.isEstimateStatus(planProgram);
        String shiftingtype = this.getShiftingType(planProgram);
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>(16);
        HashMap<String, DynamicObject> resultEntryMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> groupKeyMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> refKeyMap = new HashMap<String, DynamicObject>(16);
        Map<String, String> redisMap = this.loadRedisCacheData(supAndReqKeySet);
        HashMap<Long, JSONArray> supplyMap = new HashMap<Long, JSONArray>(64);
        HashMap<Long, JSONArray> requireMap = new HashMap<Long, JSONArray>(64);
        this.initGroupByEcoBomEntry(supAndReqKeySet, redisMap, supplyMap, requireMap);
        log.info("SRBalanceExecImpl-supAndReqKeySet.size = " + supAndReqKeySet.size());
        Map<Long, DynamicObject> ecoTypeMap = null;
        HashMap<String, DynamicObject> cacheValueMap = new HashMap<String, DynamicObject>(64);
        boolean isDisableGroupNo = PlatformUtils.isDisableGroupNo();
        for (int loop = 1; loop <= 4; ++loop) {
            if (isDisableGroupNo && (loop == 2 || loop == 4) || loop == 2 && (groupKeyMap == null || groupKeyMap.isEmpty()) || loop == 3 && (refKeyMap == null || refKeyMap.isEmpty()) || loop == 4 && (groupKeyMap == null || groupKeyMap.isEmpty() || refKeyMap == null || refKeyMap.isEmpty())) continue;
            for (Map.Entry sups : supplyMap.entrySet()) {
                Long supKeyId = (Long)sups.getKey();
                JSONArray supplyArray = (JSONArray)sups.getValue();
                if (supplyArray == null || supplyArray.isEmpty()) continue;
                JSONArray requireArray = (JSONArray)requireMap.get(supKeyId);
                if (requireArray == null) {
                    requireArray = new JSONArray();
                }
                int supSize = supplyArray.size();
                int reqSize = requireArray.size();
                if (reqSize > 1) {
                    requireArray.sort(Comparator.comparing(obj -> ((JSONObject)obj).getDate("billdate"), Comparator.nullsFirst(Comparator.naturalOrder())));
                }
                for (int i = 0; i < supSize; ++i) {
                    DynamicObject refNoResult;
                    ++dataAmount;
                    JSONObject supObject = supplyArray.getJSONObject(i);
                    Long materialId = supObject.getLong("material");
                    DynamicObject result2 = (DynamicObject)resultMap.get(supKeyId);
                    if (result2 == null) {
                        result2 = this.addResultHeadData(resultList, supObject, runLog, planProgram);
                        resultMap.put(supKeyId, result2);
                    }
                    this.genMulMaterialValue(materialId, result2);
                    if (this.isExceptionError(supObject) || this.isExceptionRepeat(supObject)) continue;
                    Date supplyDate = supObject.getDate("billdate");
                    BigDecimal supplyQty = supObject.getBigDecimal("qty");
                    String entryGroupNo = supObject.getString("entrygroupno");
                    Long ecoBillPentryId = supObject.getLong("billentryid");
                    String entryRefNo = supObject.getString("entryrefno");
                    String groupNoKeyString = PlatformUtils.getUnionString((Object)ecoBillPentryId, (Object)entryGroupNo);
                    if (supObject.getBoolean("groupkey").booleanValue() && loop == 1 && !PlatformUtils.isNullString((String)entryGroupNo)) {
                        groupKeyMap.put(groupNoKeyString, result2);
                    }
                    if (supObject.getBoolean("refkey").booleanValue() && loop == 1 && !PlatformUtils.isNullString((String)entryRefNo)) {
                        refKeyMap.put(entryRefNo, result2);
                    }
                    if (loop == 2 && PlatformUtils.isNullString((String)entryGroupNo) || loop == 3 && PlatformUtils.isNullString((String)entryRefNo) || loop == 4 && PlatformUtils.isNullString((String)entryRefNo)) continue;
                    String groupNoKeyNumbers = null;
                    Date groupNoKeyDate = null;
                    String refNoKeyNumbers = null;
                    Date refNoKeyDate = null;
                    if (loop == 2) {
                        DynamicObject groupNoResult = (DynamicObject)groupKeyMap.get(groupNoKeyString);
                        if (groupNoResult != null) {
                            groupNoKeyNumbers = this.getKeyNumbers(groupNoResult, cacheValueMap);
                            groupNoKeyDate = groupNoResult.getDate("oldacttime");
                        }
                    } else if (loop == 3) {
                        refNoResult = (DynamicObject)refKeyMap.get(entryRefNo);
                        if (refNoResult != null) {
                            refNoKeyNumbers = this.getKeyNumbers(refNoResult, cacheValueMap);
                            refNoKeyDate = this.getKeyDate(refNoResult, loop);
                        }
                    } else if (loop == 4 && (refNoResult = (DynamicObject)refKeyMap.get(entryRefNo)) != null) {
                        DynamicObject groupNoResult;
                        entryGroupNo = refNoResult.getString("entrygroupno");
                        ecoBillPentryId = refNoResult.getLong("supplyentryid");
                        groupNoKeyString = PlatformUtils.getUnionString((Object)ecoBillPentryId, (Object)entryGroupNo);
                        if (groupKeyMap != null && !PlatformUtils.isNullString((String)entryGroupNo) && (groupNoResult = (DynamicObject)groupKeyMap.get(groupNoKeyString)) != null) {
                            refNoKeyDate = this.getKeyDate(groupNoResult, 3);
                        }
                    }
                    if (!StringUtils.isEmpty(groupNoKeyNumbers)) {
                        result2.set("groupkeynumbers", (Object)groupNoKeyNumbers);
                    }
                    if (!StringUtils.isEmpty(refNoKeyNumbers)) {
                        result2.set("refkeynumbers", (Object)refNoKeyNumbers);
                    }
                    if (groupNoKeyDate != null) {
                        result2.set("groupacttime", (Object)groupNoKeyDate);
                    }
                    if (refNoKeyDate != null) {
                        result2.set("refacttime", (Object)refNoKeyDate);
                    }
                    BigDecimal syQty = supplyQty;
                    Date newTranStartDate = null;
                    Date beforeTranStartDate = null;
                    BigDecimal sumUsedQty = BigDecimal.ZERO;
                    if (loop == 2 && groupNoKeyDate == null || (loop == 3 || loop == 4) && refNoKeyDate == null) continue;
                    DynamicObject lastentry = null;
                    for (int j = 0; j < reqSize; ++j) {
                        ++dataAmount;
                        JSONObject reqObject = requireArray.getJSONObject(j);
                        Date reqDate = reqObject.getDate("billdate");
                        BigDecimal reqQty = reqObject.getBigDecimal("demandqty");
                        if (loop == 1 && "A".equals(shiftingtype)) {
                            reqQty = this.getAllRequireQty(requireArray, j);
                        }
                        if (reqDate.compareTo(supplyDate) < 0 || reqQty.compareTo(BigDecimal.ZERO) < 0 || groupNoKeyDate != null && reqDate.compareTo(groupNoKeyDate) > 0 || refNoKeyDate != null && reqDate.compareTo(refNoKeyDate) > 0) continue;
                        String entryDyKeyString = PlatformUtils.getUnionString((Object)supKeyId, (Object)reqObject.getLong("billentryid"));
                        DynamicObject entry = (DynamicObject)resultEntryMap.get(entryDyKeyString);
                        if (entry == null) {
                            entry = this.addResultEntryData(result2, supObject, reqObject, runLog);
                            resultEntryMap.put(entryDyKeyString, entry);
                        }
                        if (syQty.compareTo(BigDecimal.ZERO) > 0) {
                            if ((syQty = syQty.subtract(reqQty)).compareTo(BigDecimal.ZERO) <= 0) {
                                if (syQty.compareTo(BigDecimal.ZERO) < 0 && "A".equals(shiftingtype)) {
                                    if (beforeTranStartDate == null) {
                                        beforeTranStartDate = supplyDate;
                                    }
                                    if (newTranStartDate == null && beforeTranStartDate != null) {
                                        newTranStartDate = beforeTranStartDate;
                                        if (sdf.format(newTranStartDate).compareTo(sdf.format(reqDate)) == 0) {
                                            newTranStartDate = this.getLastDate(result2, newTranStartDate, supplyDate);
                                        }
                                        newTranStartDate = this.getActTimeNextSecond(newTranStartDate);
                                        if (loop != 1) continue;
                                        result2.set("oldacttime", (Object)newTranStartDate);
                                        continue;
                                    }
                                }
                                newTranStartDate = this.getActTimeNextSecond(reqDate);
                                if (loop == 1) {
                                    result2.set("oldacttime", (Object)newTranStartDate);
                                }
                            } else if (loop == 1) {
                                entry.set("usetype", (Object)"A");
                            }
                        }
                        beforeTranStartDate = reqDate;
                        lastentry = entry;
                    }
                    if (loop == 1) {
                        newTranStartDate = result2.getDate("oldacttime");
                        if (supplyQty.compareTo(BigDecimal.ZERO) <= 0) {
                            newTranStartDate = supplyDate;
                            result2.set("oldacttime", (Object)newTranStartDate);
                        }
                        sumUsedQty = this.getUsedQtyAndUpdateUseType(result2, newTranStartDate, loop);
                        result2.set("useqty", (Object)sumUsedQty);
                        result2.set("afteracttime", (Object)newTranStartDate);
                        result2.set("afteruseqty", (Object)sumUsedQty);
                        continue;
                    }
                    if (loop == 2) {
                        if (groupNoKeyDate == null) continue;
                        sumUsedQty = this.getUsedQtyAndUpdateUseType(result2, groupNoKeyDate, loop);
                        result2.set("groupuseqty", (Object)sumUsedQty);
                        result2.set("afteracttime", (Object)groupNoKeyDate);
                        result2.set("afteruseqty", (Object)sumUsedQty);
                        continue;
                    }
                    if (loop != 3 && loop != 4 || refNoKeyDate == null) continue;
                    sumUsedQty = this.getUsedQtyAndUpdateUseType(result2, refNoKeyDate, loop);
                    result2.set("refuseqty", (Object)sumUsedQty);
                    result2.set("afteracttime", (Object)refNoKeyDate);
                    result2.set("afteruseqty", (Object)sumUsedQty);
                }
            }
        }
        log.info("SRBalanceExecImpl-resultList.size = " + resultList.size());
        this.updateRepeatData(resultList);
        int pgzCount = 0;
        int pgwbCount = 0;
        Date currentDate = DateUtils.getEndOfDay((Date)new Date());
        if (isEstimateStatusUpdate) {
            for (int i = 0; i < resultList.size(); ++i) {
                result = (DynamicObject)resultList.get(i);
                if (this.isExceptionError(result)) continue;
                Date actTime = this.getActTime(result);
                if (!this.validateActTime(actTime, result)) {
                    this.updateGroupException(result, resultList);
                    continue;
                }
                Long ecoTypeId = result.getLong("ecotype");
                if (PlatformUtils.isNullLong((Long)ecoTypeId) || !this.isStatusTypeB(ecoTypeId, ecoTypeMap)) continue;
                int extendDay = this.getEstimatestatusday(ecoTypeId, ecoTypeMap);
                Date extendDate = PlatformUtils.addDay((Date)currentDate, (int)extendDay);
                if (actTime != null && actTime.before(extendDate)) {
                    result.set("estimatestatus", (Object)"C");
                    ++pgwbCount;
                    continue;
                }
                result.set("estimatestatus", (Object)"B");
                ++pgzCount;
            }
        }
        if (this.isClearRquireEntryData()) {
            for (int i = 0; i < resultList.size(); ++i) {
                result = (DynamicObject)resultList.get(i);
                if (!this.isNotEntryData(result)) continue;
                result.getDynamicObjectCollection("entryentity").clear();
            }
        }
        try (TXHandle required = TX.required();){
            this.saveResult(resultList);
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        returnMap.put("dataAmount", dataAmount);
        returnMap.put("resultListSize", resultList.size());
        returnMap.put("pgzCount", pgzCount);
        returnMap.put("pgwbCount", pgwbCount);
        if (isCache) {
            int redisTimeLong = this.getRedisTimeLong();
            String sr01 = this.getSRResultCacheString01();
            String sr02 = this.getSRResultCacheString02();
            String sr03 = this.getSRResultCacheString03();
            String sr04 = this.getSRResultCacheString04();
            this.getAndSetAddCacheValueLock(envCacheMap, sr01, dataAmount, redisTimeLong);
            this.getAndSetAddCacheValueLock(envCacheMap, sr02, resultList.size(), redisTimeLong);
            this.getAndSetAddCacheValueLock(envCacheMap, sr03, pgzCount, redisTimeLong);
            this.getAndSetAddCacheValueLock(envCacheMap, sr04, pgwbCount, redisTimeLong);
        }
        return returnMap;
    }

    public Map<String, String> loadRedisCacheData(Set<String> supAndReqKeySet) {
        if (supAndReqKeySet == null || supAndReqKeySet.isEmpty()) {
            return new HashMap<String, String>(16);
        }
        HashMap<String, String> dataMap = new HashMap<String, String>(supAndReqKeySet.size());
        for (String cacheKeyString : supAndReqKeySet) {
            String supplyKeys = this.getSupplyCacheString(cacheKeyString);
            String requireKeys = this.getRequireCacheString(cacheKeyString);
            String supplys = this.getCacheValue(supplyKeys);
            String requires = this.getCacheValue(requireKeys);
            dataMap.put(supplyKeys, supplys);
            dataMap.put(requireKeys, requires);
        }
        return dataMap;
    }

    public void initGroupByEcoBomEntry(Set<String> supAndReqKeySet, Map<String, String> redisMap, Map<Long, JSONArray> supplyMap, Map<Long, JSONArray> requireMap) {
        for (String cacheKeyString : supAndReqKeySet) {
            String supplys = redisMap.get(this.getSupplyCacheString(cacheKeyString));
            if (StringUtils.isEmpty((String)supplys)) continue;
            String requires = redisMap.get(this.getRequireCacheString(cacheKeyString));
            JSONArray supplyArray = JSONObject.parseArray((String)supplys);
            if (supplyArray == null || supplyArray.isEmpty()) continue;
            JSONArray requireArray = new JSONArray();
            if (!StringUtils.isEmpty((String)requires)) {
                requireArray = JSONObject.parseArray((String)requires);
            }
            int supSize = supplyArray.size();
            int reqSize = requireArray.size();
            for (int i = 0; i < supSize; ++i) {
                JSONObject supObject = supplyArray.getJSONObject(i);
                Long ecoBomEntryId = supObject.getLong("ecobomentryid");
                JSONArray newSupplyArray = supplyMap.get(ecoBomEntryId);
                if (newSupplyArray == null) {
                    newSupplyArray = new JSONArray();
                }
                newSupplyArray.add((Object)supObject);
                supplyMap.put(ecoBomEntryId, newSupplyArray);
                if (this.isExceptionError(supObject) || this.isExceptionRepeat(supObject)) continue;
                JSONArray newRequireArray = requireMap.get(ecoBomEntryId);
                if (newRequireArray == null) {
                    newRequireArray = new JSONArray();
                }
                Date supplyDate = supObject.getDate("billdate");
                for (int j = 0; j < reqSize; ++j) {
                    JSONObject reqObject = requireArray.getJSONObject(j);
                    Date reqDate = reqObject.getDate("billdate");
                    BigDecimal reqQty = reqObject.getBigDecimal("demandqty");
                    if (reqDate.compareTo(supplyDate) < 0 || reqQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    newRequireArray.add((Object)reqObject);
                }
                requireMap.put(ecoBomEntryId, newRequireArray);
            }
        }
    }

    public BigDecimal getAllRequireQty(JSONArray requireArray, int currentSeq) {
        int reqSize = requireArray.size();
        BigDecimal allQty = BigDecimal.ZERO;
        Date reqDate = requireArray.getJSONObject(currentSeq).getDate("billdate");
        int minRow = -1;
        for (int j = 0; j < reqSize; ++j) {
            JSONObject reqObject = requireArray.getJSONObject(j);
            Date reqDate2 = reqObject.getDate("billdate");
            if (reqDate.compareTo(reqDate2) != 0) continue;
            if (minRow == -1) {
                minRow = j;
            }
            BigDecimal reqQty = reqObject.getBigDecimal("demandqty");
            allQty = allQty.add(reqQty);
        }
        if (minRow < currentSeq) {
            return BigDecimal.ZERO;
        }
        return allQty;
    }

    private String getKeyNumbers(DynamicObject result, Map<String, DynamicObject> cacheValueMap) {
        Long featureType = result.getLong("featuretype");
        Long materialId = result.getLong("material");
        String resultStr = "";
        if (featureType == null || featureType.equals(0L)) {
            DynamicObject material = this.getMaterialById(materialId, cacheValueMap);
            resultStr = String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\uff1a%1$s", (String)"SRBalanceExecImpl_0", (String)"mmc-pdm-business", (Object[])new Object[0]), material.getString("number"));
        } else {
            DynamicObject featuretype = this.getFeatureTypeById(featureType, cacheValueMap);
            resultStr = String.format(ResManager.loadKDString((String)"\u7279\u5f81\u7c7b\u7f16\u7801\uff1a%1$s", (String)"SRBalanceExecImpl_1", (String)"mmc-pdm-business", (Object[])new Object[0]), featuretype.getString("number"));
        }
        return resultStr;
    }

    private DynamicObject getMaterialById(Long mid, Map<String, DynamicObject> cacheValueMap) {
        String keyString = "materialid" + String.valueOf(mid);
        DynamicObject material = cacheValueMap.get(keyString);
        if (material == null) {
            material = BusinessDataServiceHelper.loadSingleFromCache((Object)mid, (String)"bd_material", (String)"id,number");
            cacheValueMap.put(keyString, material);
        }
        return material;
    }

    private DynamicObject getFeatureTypeById(Long fid, Map<String, DynamicObject> cacheValueMap) {
        String keyString = "featuretypeid_" + String.valueOf(fid);
        DynamicObject material = cacheValueMap.get(keyString);
        if (material == null) {
            material = BusinessDataServiceHelper.loadSingleFromCache((Object)fid, (String)"mpdm_featuretype", (String)"id,number");
            cacheValueMap.put(keyString, material);
        }
        return material;
    }

    public DynamicObject addResultHeadData(List<DynamicObject> resultList, JSONObject supObject, DynamicObject runLog, DynamicObject planProgram) {
        DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)"pdm_ecoestimate_result");
        result.set("org", (Object)runLog.getDynamicObject("createorg"));
        result.set("billno", (Object)runLog.getString("number"));
        result.set("billstatus", (Object)"A");
        result.set("planprogram", (Object)planProgram);
        result.set("material", (Object)supObject.getLong("material"));
        result.set("featuretype", (Object)supObject.getLong("featuretype"));
        result.set("baseunit", (Object)supObject.getLong("baseunit"));
        result.set("materialattr", (Object)supObject.getString("materialattr"));
        result.set("supplyorg", (Object)supObject.getLong("supplyorgunit"));
        result.set("supplybilltype", (Object)supObject.getLong("billtype"));
        result.set("supplyqty", (Object)supObject.getBigDecimal("qty"));
        result.set("supplydate", (Object)supObject.getDate("billdate"));
        result.set("supplybillid", (Object)supObject.getLong("billid"));
        result.set("supplybillno", (Object)supObject.getString("billnumber"));
        result.set("supplyentryid", (Object)supObject.getLong("billentryid"));
        result.set("ecobomentryid", (Object)supObject.getLong("ecobomentryid"));
        result.set("ecobomid", (Object)supObject.getLong("ecobomid"));
        result.set("supplyseq", (Object)supObject.getInteger("billentryseq"));
        result.set("supplyauxproperty", (Object)supObject.getLong("materialflexprops"));
        result.set("version", (Object)supObject.getLong("bomreversion"));
        result.set("ecotype", (Object)supObject.getLong("ecotypeid"));
        result.set("bomnumber", (Object)supObject.getString("bomnumber"));
        result.set("bomid", (Object)supObject.getLong("bomid"));
        result.set("bomentryid", (Object)supObject.getLong("bomentryid"));
        result.set("entrymode", (Object)supObject.getString("entrymode"));
        result.set("groupkeynumbers", (Object)"");
        result.set("refkeynumbers", (Object)"");
        result.set("entrygroupno", (Object)supObject.getString("entrygroupno"));
        result.set("entryrefno", (Object)supObject.getString("entryrefno"));
        result.set("oldestimatestatus", (Object)supObject.getString("estimatestatus"));
        result.set("useqty", (Object)BigDecimal.ZERO);
        result.set("groupuseqty", (Object)BigDecimal.ZERO);
        result.set("refuseqty", (Object)BigDecimal.ZERO);
        result.set("exceptiontype", (Object)supObject.getString("exceptiontype"));
        result.set("exceptioninfo", (Object)supObject.getString("exceptioninfo"));
        result.set("ecocallog", (Object)runLog);
        result.set("entryvaliddate", (Object)supObject.getDate("entryvaliddate"));
        result.set("entryinvaliddate", (Object)supObject.getDate("entryinvaliddate"));
        result.set("initacttime", (Object)supObject.getDate("initacttime"));
        result.set("iscanestimate", (Object)supObject.getBoolean("iscanestimate"));
        result.set("continuouspoint", (Object)supObject.getString("continuouspoint"));
        result.set("refkey", (Object)supObject.getBoolean("refkey"));
        result.set("groupnokey", (Object)supObject.getBoolean("groupkey"));
        result.set("creator", (Object)RequestContext.get().getCurrUserId());
        result.set("estimatestatus", (Object)"A");
        result.set("srcdatasource", (Object)supObject.getLong("srcdatasource"));
        result.set("getdatatype", (Object)(StringUtils.isEmpty((String)supObject.getString("getdatatype")) ? "A" : supObject.getString("getdatatype")));
        resultList.add(result);
        return result;
    }

    public DynamicObject addResultEntryData(DynamicObject head, JSONObject supObject, JSONObject reqObject, DynamicObject runLog) {
        DynamicObjectCollection coll = head.getDynamicObjectCollection("entryentity");
        DynamicObject entry = coll.addNew();
        entry.set("requirebillno", (Object)reqObject.getString("billnumber"));
        entry.set("requirebillid", (Object)reqObject.getLong("billid"));
        entry.set("requirebillentryid", (Object)reqObject.getLong("billentryid"));
        entry.set("requirebillentryseq", (Object)reqObject.getInteger("billentryseq"));
        entry.set("requireqty", (Object)reqObject.getBigDecimal("demandqty"));
        entry.set("requiredate", (Object)reqObject.getDate("billdate"));
        entry.set("requirebilltype", (Object)reqObject.getLong("billtype"));
        entry.set("requirebilltypename", (Object)this.getBillTypeName(reqObject.getLong("billtype")));
        entry.set("requirematerial", (Object)reqObject.getLong("material"));
        entry.set("requirebaseunit", (Object)reqObject.getLong("baseunit"));
        entry.set("requirekey", (Object)Boolean.FALSE);
        entry.set("requiregroupkey", (Object)Boolean.FALSE);
        entry.set("requirerefkey", (Object)Boolean.FALSE);
        entry.set("afterestimatekey", (Object)Boolean.FALSE);
        entry.set("usetype", (Object)"B");
        entry.set("sortseq", (Object)coll.size());
        return entry;
    }

    @Override
    public void genMulMaterialValue(Long materialId, DynamicObject head) {
        DynamicObjectCollection dyColl = head.getDynamicObjectCollection("mulmaterial");
        if (dyColl == null) {
            dyColl = new DynamicObjectCollection();
        }
        for (int i = 0; i < dyColl.size(); ++i) {
            DynamicObject dy = (DynamicObject)dyColl.get(i);
            Long existsMaterialId = (Long)dy.getDynamicObject("fbasedataid").getPkValue();
            if (!existsMaterialId.equals(materialId)) continue;
            return;
        }
        DynamicObjectType dynamicObjectType = dyColl.getDynamicObjectType();
        DynamicObject mulBasedataDy = new DynamicObject(dynamicObjectType);
        DynamicObject payBizActDy = BusinessDataServiceHelper.newDynamicObject((String)"bd_material");
        payBizActDy.set("id", (Object)materialId);
        mulBasedataDy.set("fbasedataid", (Object)payBizActDy);
        dyColl.add((Object)mulBasedataDy);
        head.set("mulmaterial", (Object)dyColl);
    }

    public Date getKeyDate(DynamicObject result, int loop) {
        Date refNoKeyDate = null;
        if (loop == 4) {
            refNoKeyDate = result.getDate("refacttime");
        }
        if (refNoKeyDate == null && loop >= 3) {
            refNoKeyDate = result.getDate("groupacttime");
        }
        if (refNoKeyDate == null) {
            refNoKeyDate = result.getDate("oldacttime");
        }
        return refNoKeyDate;
    }

    public boolean validateActTime(Date actTime, DynamicObject result) {
        if (actTime == null) {
            return true;
        }
        if (actTime.equals(result.getDate("initacttime"))) {
            return true;
        }
        Date validDate = result.getDate("entryvaliddate");
        Date inValidDate = result.getDate("entryinvaliddate");
        if (validDate == null || inValidDate == null) {
            return true;
        }
        Long mftBomEntryId = result.getLong("bomentryid");
        ActTimeBean bean = new ActTimeBean(actTime, validDate, inValidDate, mftBomEntryId, 0L, result.getLong("supplybillid"), result.getString("supplybillno"), result.getString("entrymode"), "C", this.getRealMaterialId(result));
        String errorInfo = ActTimeValidataBusiness.getInstance().checkValidData(bean);
        if (StringUtils.isEmpty((String)errorInfo)) {
            return true;
        }
        result.set("exceptiontype", (Object)"C");
        result.set("exceptioninfo", (Object)errorInfo);
        return false;
    }

    public Long getRealMaterialId(DynamicObject result) {
        Long featureType = result.getLong("featuretype");
        Long materialId = result.getLong("material");
        return PlatformUtils.isNullLong((Long)featureType) ? materialId : featureType;
    }

    public void updateGroupException(DynamicObject errorResult, List<DynamicObject> resultList) {
        String groupNo = errorResult.getString("entrygroupno");
        String refNo = errorResult.getString("entryrefno");
        Long ecoBomId = errorResult.getLong("ecobomid");
        if (PlatformUtils.isNullString((String)groupNo) && PlatformUtils.isNullString((String)refNo)) {
            return;
        }
        String groupKeyString = PlatformUtils.getUnionString((Object)ecoBomId, (Object)groupNo);
        for (int i = 0; i < resultList.size(); ++i) {
            DynamicObject result = resultList.get(i);
            if (this.isExceptionError(result)) continue;
            String groupNo2 = result.getString("entrygroupno");
            String refNo2 = result.getString("entryrefno");
            Long ecoBomId2 = result.getLong("ecobomid");
            if (!PlatformUtils.isNullString((String)groupNo2) && !PlatformUtils.isNullString((String)groupNo) && groupKeyString.equals(PlatformUtils.getUnionString((Object)ecoBomId2, (Object)groupNo2))) {
                result.set("exceptioninfo", errorResult.get("exceptioninfo"));
                result.set("exceptiontype", errorResult.get("exceptiontype"));
            }
            if (PlatformUtils.isNullString((String)refNo2) || PlatformUtils.isNullString((String)refNo) || !refNo2.equals(refNo)) continue;
            result.set("exceptioninfo", errorResult.get("exceptioninfo"));
            result.set("exceptiontype", errorResult.get("exceptiontype"));
        }
    }

    public BigDecimal getUsedQtyAndUpdateUseType(DynamicObject result, Date maxRequireDate, int loop) {
        if (maxRequireDate == null) {
            if (loop == 1 || loop == 5) {
                return this.getUseTypeQty(result);
            }
            return BigDecimal.ZERO;
        }
        DynamicObjectCollection coll = result.getDynamicObjectCollection("entryentity");
        if (coll == null || coll.isEmpty()) {
            return BigDecimal.ZERO;
        }
        int size = coll.size();
        BigDecimal sumUsedQty = BigDecimal.ZERO;
        int keyRow1 = -1;
        int keyRow2 = -1;
        int keyRow3 = -1;
        int keyRow5 = -1;
        BigDecimal supQty = result.getBigDecimal("supplyqty");
        boolean existsUseTypeA = false;
        for (int j = 0; j < size; ++j) {
            DynamicObject entry = (DynamicObject)coll.get(j);
            Date requireDate = entry.getDate("requiredate");
            BigDecimal requireQty = entry.getBigDecimal("requireqty");
            if (loop == 5) {
                entry.set("afterestimatekey", (Object)Boolean.FALSE);
            }
            if (requireDate.compareTo(maxRequireDate) < 0) {
                sumUsedQty = sumUsedQty.add(requireQty);
                if (loop == 1 || loop == 5) {
                    entry.set("usetype", (Object)"A");
                }
                existsUseTypeA = true;
                continue;
            }
            if (loop == 1 || loop == 5) {
                entry.set("usetype", (Object)"B");
            }
            if (!existsUseTypeA) continue;
            if (loop == 1 && keyRow1 == -1) {
                keyRow1 = j - 1;
                continue;
            }
            if (loop == 2 && keyRow2 == -1) {
                keyRow2 = j - 1;
                continue;
            }
            if ((loop == 3 || loop == 4) && keyRow3 == -1) {
                keyRow3 = j - 1;
                continue;
            }
            if (loop != 5 || keyRow5 != -1) continue;
            keyRow5 = j - 1;
        }
        if (existsUseTypeA && loop == 5 && keyRow5 == -1) {
            keyRow5 = size - 1;
        }
        if (keyRow1 >= 0) {
            ((DynamicObject)coll.get(keyRow1)).set("requirekey", (Object)Boolean.TRUE);
        }
        if (keyRow2 >= 0) {
            ((DynamicObject)coll.get(keyRow2)).set("requiregroupkey", (Object)Boolean.TRUE);
        }
        if (keyRow3 >= 0) {
            ((DynamicObject)coll.get(keyRow3)).set("requirerefkey", (Object)Boolean.TRUE);
        }
        if (keyRow5 >= 0) {
            ((DynamicObject)coll.get(keyRow5)).set("afterestimatekey", (Object)Boolean.TRUE);
        }
        return sumUsedQty;
    }

    public BigDecimal getUseTypeQty(DynamicObject result) {
        DynamicObjectCollection coll = result.getDynamicObjectCollection("entryentity");
        if (coll == null || coll.isEmpty()) {
            return BigDecimal.ZERO;
        }
        int size = coll.size();
        BigDecimal sumUsedQty = BigDecimal.ZERO;
        for (int j = 0; j < size; ++j) {
            DynamicObject entry = (DynamicObject)coll.get(j);
            if (!"A".equals(entry.getString("usetype"))) continue;
            BigDecimal requireQty = entry.getBigDecimal("requireqty");
            sumUsedQty = sumUsedQty.add(requireQty);
        }
        return sumUsedQty;
    }

    public Date getLastDate(DynamicObject result, Date maxRequireDate, Date firstDate) {
        DynamicObject entry;
        Date requireDate;
        DynamicObjectCollection coll = result.getDynamicObjectCollection("entryentity");
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        int size = coll.size();
        Date lastDate = null;
        for (int j = 0; j < size && (requireDate = (entry = (DynamicObject)coll.get(j)).getDate("requiredate")).compareTo(maxRequireDate) < 0; ++j) {
            lastDate = requireDate;
        }
        return lastDate == null ? firstDate : lastDate;
    }

    public String getRepeatKeys(DynamicObject result) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder sb = new StringBuilder();
        sb.append(result.getLong("supplyorg"));
        sb.append("_");
        sb.append(this.getRealMaterialId(result));
        sb.append("_");
        sb.append(result.getLong("version"));
        sb.append("_");
        sb.append(result.getLong("supplyauxproperty"));
        sb.append("_");
        sb.append(result.getBigDecimal("supplyqty"));
        sb.append("_");
        sb.append(sdf.format(result.getDate("supplydate")));
        return sb.toString();
    }

    public boolean isStatusTypeB(Long ecoId, Map<Long, DynamicObject> dyMap) {
        DynamicObject dy;
        if (dyMap == null) {
            dyMap = new HashMap<Long, DynamicObject>(16);
        }
        if ((dy = dyMap.get(ecoId)) == null) {
            dy = BusinessDataServiceHelper.loadSingleFromCache((Object)ecoId, (String)"pdm_ecotype");
            dyMap.put(ecoId, dy);
        }
        return "B".equals(dy.getString("statustype"));
    }

    public int getEstimatestatusday(Long ecoId, Map<Long, DynamicObject> dyMap) {
        DynamicObject dy;
        if (dyMap == null) {
            dyMap = new HashMap<Long, DynamicObject>(16);
        }
        if ((dy = dyMap.get(ecoId)) == null) {
            dy = BusinessDataServiceHelper.loadSingleFromCache((Object)ecoId, (String)"pdm_ecotype");
            dyMap.put(ecoId, dy);
        }
        return dy.getInt("estimatestatusday");
    }

    public Date getActTimeNextSecond(Date actTime) {
        return PlatformUtils.addSecond((Date)actTime, (int)1);
    }

    public Date getActTime(DynamicObject result) {
        return result.getDate("afteracttime") == null ? result.getDate("initacttime") : result.getDate("afteracttime");
    }

    private void setAfterActTimeValue(DynamicObject result) {
        Date afterActtime;
        String refNo;
        String groupNo = result.getString("entrygroupno");
        if (!PlatformUtils.isNullString((String)groupNo) && result.getDate("groupacttime") == null) {
            result.set("afteracttime", result.get("initacttime"));
            result.set("afteruseqty", (Object)BigDecimal.ZERO);
        }
        if (!PlatformUtils.isNullString((String)(refNo = result.getString("entryrefno"))) && result.getDate("refacttime") == null) {
            result.set("afteracttime", result.get("initacttime"));
            result.set("afteruseqty", (Object)BigDecimal.ZERO);
        }
        if ((afterActtime = result.getDate("afteracttime")) == null) {
            afterActtime = result.getDate("initacttime");
            result.set("afteruseqty", (Object)BigDecimal.ZERO);
            result.set("afteracttime", (Object)afterActtime);
        }
        BigDecimal sumUsedQty = this.getUsedQtyAndUpdateUseType(result, afterActtime, 5);
        result.set("afteruseqty", (Object)sumUsedQty);
    }

    public void updateRepeatData(List<DynamicObject> resultList) {
        String repeatKeys;
        DynamicObject result;
        int i;
        int size = resultList.size();
        HashMap<String, DynamicObject> normalDataMap = new HashMap<String, DynamicObject>(size);
        for (i = 0; i < size; ++i) {
            result = resultList.get(i);
            if (this.isExceptionError(result)) continue;
            this.setAfterActTimeValue(result);
            if (!this.isExceptionNormal(result)) continue;
            repeatKeys = this.getRepeatKeys(result);
            normalDataMap.put(repeatKeys, result);
        }
        for (i = 0; i < size; ++i) {
            DynamicObject normalResult;
            result = resultList.get(i);
            if (!this.isExceptionRepeat(result) || (normalResult = (DynamicObject)normalDataMap.get(repeatKeys = this.getRepeatKeys(result))) == null) continue;
            result.set("oldacttime", normalResult.get("oldacttime"));
            result.set("useqty", normalResult.get("useqty"));
            result.set("groupacttime", normalResult.get("groupacttime"));
            result.set("groupuseqty", normalResult.get("groupuseqty"));
            result.set("refacttime", normalResult.get("refacttime"));
            result.set("refuseqty", normalResult.get("refuseqty"));
            result.set("afteracttime", normalResult.get("afteracttime"));
            result.set("afteruseqty", normalResult.get("afteruseqty"));
        }
    }

    public boolean isNotEntryData(DynamicObject result) {
        if (this.isExceptionError(result)) {
            return true;
        }
        return !result.getBoolean("refkey") && !result.getBoolean("groupnokey") && !"C".equals(result.getString("estimatestatus"));
    }
}

