/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.ext;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;

public class EcoEstimateStatusUpdateUtils {
    public static void addEsEndRecord(Set<Long> ecoBomEntryIdSet) {
        if (ecoBomEntryIdSet == null || ecoBomEntryIdSet.isEmpty()) {
            return;
        }
        if (!PdmParamSetHelper.getBooleanParamValue((String)"ECNEsEndAddRecord")) {
            return;
        }
        String selectFields = "id,entry.estimatestatus estimatestatus,entry.acttime acttime,entry.entrymaterialid.number materialnumber,materialid.number parentmaterialnumber ";
        QFilter filter = new QFilter("entry.id", "in", ecoBomEntryIdSet);
        filter.and(new QFilter("entry.estimatestatus", "=", (Object)"C"));
        QFilter[] qFilters = new QFilter[]{filter};
        DynamicObjectCollection ecoBomColl = QueryServiceHelper.query((String)"pdm_ecobom", (String)selectFields, (QFilter[])qFilters);
        if (ecoBomColl == null || ecoBomColl.isEmpty()) {
            return;
        }
        HashSet<Long> ecoBomIdSet = new HashSet<Long>(16);
        for (int i = 0; i < ecoBomColl.size(); ++i) {
            DynamicObject ecoBom = (DynamicObject)ecoBomColl.get(i);
            ecoBomIdSet.add(ecoBom.getLong("id"));
        }
        if (!ecoBomIdSet.isEmpty()) {
            selectFields = "id,billno,pentry.ecobomid ecobomid";
            filter = new QFilter("pentry.ecobomid", "in", ecoBomIdSet);
            qFilters = new QFilter[]{filter};
            DynamicObjectCollection ecoColl = QueryServiceHelper.query((String)"pdm_bom_eco", (String)selectFields, (QFilter[])qFilters);
            if (ecoColl == null || ecoColl.isEmpty()) {
                return;
            }
            long currentUserId = UserServiceHelper.getCurrentUserId();
            Date date = new Date();
            ArrayList<DynamicObject> addList = new ArrayList<DynamicObject>(ecoBomColl.size());
            for (int i = 0; i < ecoBomColl.size(); ++i) {
                DynamicObject ecoBom = (DynamicObject)ecoBomColl.get(i);
                Long ecoBomId = ecoBom.getLong("id");
                DynamicObject eco = null;
                for (int j = 0; j < ecoColl.size(); ++j) {
                    if (!ecoBomId.equals(((DynamicObject)ecoColl.get(j)).getLong("ecobomid"))) continue;
                    eco = (DynamicObject)ecoColl.get(j);
                    break;
                }
                if (eco == null) continue;
                DynamicObject recordBill = BusinessDataServiceHelper.newDynamicObject((String)"pdm_ecnesendrecord");
                recordBill.set("billno", (Object)eco.getString("billno"));
                recordBill.set("billstatus", (Object)"A");
                recordBill.set("creator", (Object)currentUserId);
                recordBill.set("createtime", (Object)date);
                recordBill.set("parentmaterialnumber", (Object)ecoBom.getString("parentmaterialnumber"));
                recordBill.set("materialnumber", (Object)ecoBom.getString("materialnumber"));
                recordBill.set("acttime", (Object)ecoBom.getDate("acttime"));
                recordBill.set("estimatestatus", (Object)ecoBom.getString("estimatestatus"));
                recordBill.set("dealstatus", (Object)"A");
                addList.add(recordBill);
            }
            if (!addList.isEmpty()) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("ignorewarn", String.valueOf(true));
                operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
                operateOption.setVariableValue("strictvalidation", String.valueOf(true));
                OperationResult operationResult = SaveServiceHelper.saveOperate((String)"pdm_ecnesendrecord", (DynamicObject[])addList.toArray(new DynamicObject[addList.size()]), (OperateOption)operateOption);
                String errorMsg = PlatformUtils.getErrorMsg((OperationResult)operationResult);
                if (errorMsg != null && !"".equals(errorMsg)) {
                    throw new KDBizException(new ErrorCode("addEsEndRecord", String.format(ResManager.loadKDString((String)"\u751f\u6210\u5de5\u7a0b\u53d8\u66f4\u5355\u8bc4\u4f30\u72b6\u6001\u8bb0\u5f55\u65f6\u53d1\u751f\u9519\u8bef\uff1a%1$s\u3002", (String)"EcoEstimateStatusUpdateUtils_01", (String)"mmc-pdm-business", (Object[])new Object[0]), errorMsg)), new Object[0]);
                }
            }
        }
    }
}

