/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.log;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorderbom.utils.BomBaseData;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.EcoRouteUtils;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.common.bom.bean.Fraction;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;

public class LogUtils {
    public static final String SPLITCHAR = "\r\n";
    public static final String APPNUMBER = "mmc-pdm-business";

    public static void genLogs1(StringBuilder sf, Map<Long, DynamicObject> ecobomEntryMap, Set<Long> ecoBomEntryIdSet, Set<Long> bomentryIdSet, Set<Long> childMaterialIdSet, Date minActTime, Date maxActTime, Date hisMinDate) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc00(ecoBomEntryIdSet.toString())).append(SPLITCHAR);
        sf.append(LogUtils.getDesc01(bomentryIdSet.toString())).append(SPLITCHAR);
        sf.append(LogUtils.getDesc02(childMaterialIdSet.toString())).append(SPLITCHAR);
        sf.append(LogUtils.getDesc03(minActTime == null ? "" : sdf.format(minActTime))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc04(maxActTime == null ? "" : sdf.format(maxActTime))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc05(LogUtils.getEcoBomEntryMaps(ecobomEntryMap))).append(SPLITCHAR);
    }

    private static String getDesc00(Object params) {
        return String.format(ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\uff1a\u5de5\u7a0b\u53d8\u66f4\u5355\u7684EcoBom\u5206\u5f55ID\uff1a%1$s", (String)"LogUtils_0", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc01(Object params) {
        return String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684BOM\u5206\u5f55ID\u6570\u636e\uff1a%1$s", (String)"LogUtils_1", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc02(Object params) {
        return String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684BOM\u7ec4\u4ef6\u7269\u6599ID\u6570\u636e\uff1a%1$s", (String)"LogUtils_2", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc03(Object params) {
        return String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u6700\u5c0f\u5b9e\u65bd\u65f6\u95f4\uff1a%1$s", (String)"LogUtils_3", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc04(Object params) {
        return String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u6700\u5927\u5b9e\u65bd\u65f6\u95f4\uff1a%1$s", (String)"LogUtils_4", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc05(Object params) {
        return String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5f85\u5206\u6790\u7684EcoBom\u6570\u636e\u60c5\u51b5\uff1a%1$s", (String)"LogUtils_5", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc06(Map<String, Object> stockDataMap, DynamicObject filterObj) {
        return String.format(ResManager.loadKDString((String)"%1$s\u5728\u4f9d\u636e\u5339\u914d\u7ef4\u5ea6\uff1a%2$s %3$s \u8fdb\u884c\u53cc\u8fb9\u5339\u914d\u65f6\u65e0\u6cd5\u6ee1\u8db3\u5339\u914d\u6761\u4ef6\uff0c\u81ea\u52a8\u8fc7\u6ee4\u6389\u3002", (String)"LogUtils_149", (String)APPNUMBER, (Object[])new Object[0]), LogUtils.getStockDatas(stockDataMap), filterObj.getString("number"), filterObj.getString("name"));
    }

    private static String getDesc07(Map<String, Object> stockDataMap, DynamicObject filterObj) {
        return String.format(ResManager.loadKDString((String)"%1$s\u5728\u4f9d\u636e\u5339\u914d\u7ef4\u5ea6\uff1a%2$s %3$s \u8fdb\u884c\u65f6\u95f4\u5339\u914d\u65f6\u65e0\u6cd5\u6ee1\u8db3\u5339\u914d\u6761\u4ef6\uff0c\u81ea\u52a8\u8fc7\u6ee4\u6389\u3002", (String)"LogUtils_205", (String)APPNUMBER, (Object[])new Object[0]), LogUtils.getStockDatas(stockDataMap), filterObj.getString("number"), filterObj.getString("name"));
    }

    public static String getEcoBomEntryMaps(Map<Long, DynamicObject> ecobomEntryMap) {
        if (ecobomEntryMap == null || ecobomEntryMap.isEmpty()) {
            return ResManager.loadKDString((String)"\u7a7a", (String)"LogUtils_6", (String)APPNUMBER, (Object[])new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Long, DynamicObject> entrys : ecobomEntryMap.entrySet()) {
            DynamicObject ecoBomEntry = entrys.getValue();
            sb.append(LogUtils.getEcoBomEntryStr(ecoBomEntry)).append(SPLITCHAR);
        }
        return sb.toString();
    }

    private static String getECNBillNo(Long ecobomid) {
        HashSet<Long> ecoBomIdSet = new HashSet<Long>(16);
        ecoBomIdSet.add(ecobomid);
        DynamicObject[] ecoBillNo = EcoUtils.getEcoChangeBillData(ecoBomIdSet);
        return ecoBillNo[0].getString("billno");
    }

    private static String getEntryMode(String entryMode) {
        return "A".equals(entryMode) ? ResManager.loadKDString((String)"\u65b0\u589e", (String)"LogUtils_7", (String)APPNUMBER, (Object[])new Object[0]) : ("B".equals(entryMode) ? ResManager.loadKDString((String)"\u4fee\u6539\u524d", (String)"LogUtils_8", (String)APPNUMBER, (Object[])new Object[0]) : ("C".equals(entryMode) ? ResManager.loadKDString((String)"\u4fee\u6539\u540e", (String)"LogUtils_9", (String)APPNUMBER, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5931\u6548", (String)"LogUtils_10", (String)APPNUMBER, (Object[])new Object[0])));
    }

    private static String getMaterialNumberByEcoBomEntryId(Long ecoBomEntryId) {
        String selectFields = "entrymaterial.number materialnumber,featuretype.number featuretypenumber ";
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_ecobom_entryf7", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ecoBomEntryId)});
        DynamicObject dy = (DynamicObject)coll.get(0);
        String materialNumber = dy.getString("materialnumber");
        String featuretypenumber = dy.getString("featuretypenumber");
        if (StringUtils.isEmpty((String)materialNumber)) {
            return featuretypenumber;
        }
        return materialNumber;
    }

    public static String getEcoBomEntryStr(DynamicObject ecoBomEntry) {
        StringBuilder sb = new StringBuilder();
        Long ecoBomEntryId = ecoBomEntry.getLong("entryid");
        String entrymode = ecoBomEntry.getString("entrymode");
        Long ecobomid = ecoBomEntry.getLong("ecobomid");
        sb.append(LogUtils.getDesc11(LogUtils.getECNBillNo(ecobomid), LogUtils.getEntryMode(entrymode), LogUtils.getMaterialNumberByEcoBomEntryId(ecoBomEntryId))).append(SPLITCHAR);
        return sb.toString();
    }

    private static String getDesc11(Object paramsa, Object paramsb, Object paramsc) {
        return String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u53f7\uff1a%1$s\uff0c%2$s\uff0c\u7ec4\u4ef6\u7f16\u7801\uff1a%3$s", (String)"LogUtils_11", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb, paramsc);
    }

    private static String getBomNuber(Long bomId) {
        DynamicObject bom = BusinessDataServiceHelper.loadSingleFromCache((Object)bomId, (String)"pdm_mftbom", (String)"number");
        return bom == null ? "" : bom.getString("number");
    }

    public static String getMaterialNumberByBomEntry(DynamicObject bomEntry) {
        Long entryid = bomEntry.getLong("entryid");
        Long childMaterialId = bomEntry.getLong("entrymaterialid");
        if (PlatformUtils.isNullLong((Long)childMaterialId)) {
            return LogUtils.getNumberByBomEntryId(entryid);
        }
        return LogUtils.getMaterialNumberById(childMaterialId);
    }

    private static String getNumberByBomEntryId(Long bomEntryId) {
        String selectFields = "entrymaterialid.number materialnumber,featuretype.number featuretypenumber ";
        int i = 0;
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"pdm_mftbomentry", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bomEntryId)});
        if (i < coll.size()) {
            DynamicObject dy = (DynamicObject)coll.get(i);
            String materialNumber = dy.getString("materialnumber");
            String featuretypenumber = dy.getString("featuretypenumber");
            if (StringUtils.isEmpty((String)materialNumber)) {
                return String.format(ResManager.loadKDString((String)"\u7279\u5f81\u7f16\u7801 %1$s", (String)"LogUtils_14", (String)APPNUMBER, (Object[])new Object[0]), featuretypenumber);
            }
            return materialNumber;
        }
        return "";
    }

    public static String getMftBomEntryStr(DynamicObject bomEntry) {
        StringBuilder sb = new StringBuilder();
        Long bomid = bomEntry.getLong("bomid");
        sb.append(LogUtils.getDesc15(LogUtils.getBomNuber(bomid), LogUtils.getMaterialNumberByBomEntry(bomEntry)));
        return sb.toString();
    }

    private static String getDesc15(Object paramsa, Object paramsb) {
        return String.format(ResManager.loadKDString((String)"BOM\u7f16\u7801\uff1a%1$s\uff0c\u7ec4\u4ef6\u7f16\u7801\uff1a%2$s", (String)"LogUtils_15", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb);
    }

    public static void genLogs2(StringBuilder sf, List<Map<String, Object>> stockDataList, QFilter qFilter, String stockEntityNumber) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc17(qFilter.toString())).append(SPLITCHAR);
        if ("pom_mftstock".equalsIgnoreCase(stockEntityNumber)) {
            sf.append(LogUtils.getDesc18(stockEntityNumber)).append(SPLITCHAR);
        } else {
            sf.append(LogUtils.getDesc19(stockEntityNumber)).append(SPLITCHAR);
        }
        String stocks = LogUtils.getStockDatas(stockDataList);
        if (stocks == null || "".equals(stocks)) {
            stocks = ResManager.loadKDString((String)"\u65e0", (String)"LogUtils_20", (String)APPNUMBER, (Object[])new Object[0]);
        }
        sf.append(LogUtils.getDesc21(stocks)).append(SPLITCHAR);
    }

    private static String getDesc17(Object params) {
        return String.format(ResManager.loadKDString((String)"\u6309Bom\u8868\u5934Id\u8fc7\u6ee4\u7ec4\u4ef6\u6e05\u5355\u7684\u6761\u4ef6\uff1a%1$s", (String)"LogUtils_17", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc18(Object params) {
        return String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u7ec4\u4ef6\u6e05\u5355\u5bf9\u8c61\uff1a\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355\uff1a%1$s", (String)"LogUtils_18", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc19(Object params) {
        return String.format(ResManager.loadKDString((String)"\u6309\u67e5\u8be2\u7684\u7ec4\u4ef6\u6e05\u5355\u5bf9\u8c61\uff1a\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\uff1a%1$s", (String)"LogUtils_19", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc21(Object params) {
        return String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u7684\u7ec4\u4ef6\u6e05\u5355\u6570\u636e\uff1a%1$s", (String)"LogUtils_21", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    public static String getMaterialNumberById(Object materialId) {
        if (materialId == null) {
            return ResManager.loadKDString((String)"\u53d1\u751f\u9519\u8bef\uff0c\u7269\u6599ID\u4e3a\u7a7a", (String)"LogUtils_22", (String)APPNUMBER, (Object[])new Object[0]);
        }
        Long materialIds = (Long)materialId;
        if (PlatformUtils.isNullLong((Long)materialIds)) {
            return ResManager.loadKDString((String)"\u53d1\u751f\u9519\u8bef\uff0c\u7269\u6599ID\u4e3a0\uff0c\u65e0\u6cd5\u83b7\u53d6\u7269\u6599\u4fe1\u606f", (String)"LogUtils_23", (String)APPNUMBER, (Object[])new Object[0]);
        }
        DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((Object)materialIds, (String)"bd_material", (String)"number");
        return material.getString("number");
    }

    public static String getMaterialNumberByMftId(Long mftId) {
        if (mftId == null || mftId.equals(0L)) {
            return ResManager.loadKDString((String)"\u7269\u6599\u751f\u4ea7\u4fe1\u606fID\u4e3a\u7a7a", (String)"LogUtils_24", (String)APPNUMBER, (Object[])new Object[0]);
        }
        DynamicObject mft = MaterialMftQueryHelper.getDataCacheByID((Object)mftId);
        return mft.getDynamicObject("masterid").getString("number");
    }

    public static String getFeatureTypeNumberById(Object featureTypeId) {
        DynamicObject featuretype = BusinessDataServiceHelper.loadSingleFromCache((Object)((Long)featureTypeId), (String)"mpdm_featuretype", (String)"number");
        return featuretype.getString("number");
    }

    public static String getStockDatas(List<Map<String, Object>> stockDataList) {
        if (stockDataList == null || stockDataList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stockDataList.size(); ++i) {
            Map<String, Object> stocks = stockDataList.get(i);
            sb.append(LogUtils.getStockDatas(stocks));
        }
        return sb.toString();
    }

    public static String getStockDatas(Map<String, Object> stocks) {
        StringBuilder sb = new StringBuilder();
        sb.append(LogUtils.getDesc25(stocks.get("billno"), stocks.get("stockentry.seq"), LogUtils.getMaterialNumberById(stocks.get("stockentry.materielmasterid"))));
        return sb.toString();
    }

    private static String getDesc25(Object paramsa, Object paramsb, Object paramsc) {
        return String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u53f7\uff1a%1$s\uff0c\u7ec4\u4ef6\u5e8f\u53f7\uff1a%2$s\uff0c\u7ec4\u4ef6\u7f16\u7801\uff1a%3$s", (String)"LogUtils_25", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb, paramsc);
    }

    public static String getStockNo(Map<String, Object> stocks) {
        StringBuilder sb = new StringBuilder();
        sb.append(LogUtils.getDesc26(stocks.get("billno"))).append(SPLITCHAR);
        return sb.toString();
    }

    private static String getDesc26(Object params) {
        return String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u53f7\uff1a%1$s", (String)"LogUtils_26", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    public static void genLogs3(StringBuilder sf, List<Map<String, Object>> stockDataList, QFilter qFilter, String stockEntityNumber) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc27(qFilter.toString())).append(SPLITCHAR);
        sf.append(SPLITCHAR);
        if ("pom_mftstock".equalsIgnoreCase(stockEntityNumber)) {
            sf.append(LogUtils.getDesc18(stockEntityNumber)).append(SPLITCHAR);
        } else {
            sf.append(LogUtils.getDesc19(stockEntityNumber)).append(SPLITCHAR);
        }
        sf.append(SPLITCHAR);
        sf.append(LogUtils.getDesc21(LogUtils.getStockDatas(stockDataList))).append(SPLITCHAR);
    }

    private static String getDesc27(Object params) {
        return String.format(ResManager.loadKDString((String)"\u6309Bom\u5206\u5f55Id\u8fc7\u6ee4\u7ec4\u4ef6\u6e05\u5355\u7684\u6761\u4ef6\uff1a%1$s", (String)"LogUtils_27", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    public static void genLogs4(StringBuilder sf, Map<String, Object> stockDataMap, DynamicObject bomentry, boolean isExistsData) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Long childMaterialId = bomentry.getLong("entrymaterialid");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc28(bomentry.getLong("entryid"))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc29(LogUtils.getMaterialNumberById(childMaterialId))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc30(LogUtils.getStockDatas(stockDataMap))).append(SPLITCHAR);
        if (isExistsData) {
            sf.append(ResManager.loadKDString((String)"\u8be5BOM\u7ec4\u4ef6\u5df2\u5b58\u5728\u4e8e\u7ec4\u4ef6\u6e05\u5355\u4e2d,\u672c\u6b21\u4e0d\u6267\u884c\u65b0\u589e\u64cd\u4f5c!", (String)"LogUtils_31", (String)APPNUMBER, (Object[])new Object[0])).append(SPLITCHAR);
        }
    }

    private static String getDesc28(Object params) {
        return String.format(ResManager.loadKDString((String)"\u5bf9BOM\u5206\u5f55\u6267\u884c\u65b0\u589e\u64cd\u4f5c:\u5206\u5f55ID\uff1a%1$s", (String)"LogUtils_28", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc29(Object params) {
        return String.format(ResManager.loadKDString((String)"BOM\u5206\u5f55\u7269\u6599\u4fe1\u606f\uff1a%1$s", (String)"LogUtils_29", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc30(Object params) {
        return String.format(ResManager.loadKDString((String)"\u672c\u6b21\u6267\u884c\u53c2\u8003\u7684\u7ec4\u4ef6\u6e05\u5355\u4fe1\u606f\uff1a%1$s", (String)"LogUtils_30", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    public static void genLogs5(StringBuilder sf, DynamicObject bomentry, String xBillNo) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc32(LogUtils.getMftBomEntryStr(bomentry), xBillNo)).append(SPLITCHAR);
    }

    private static String getDesc32(Object paramsa, Object paramsb) {
        return String.format(ResManager.loadKDString((String)"BOM\u5206\u5f55\uff1a%1$s \u5df2\u5b58\u5728\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355%2$s\u6570\u636e\uff0c\u672c\u6b21\u65b0\u589e\u4e0d\u6267\u884c\u3002", (String)"LogUtils_32", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb);
    }

    public static void genLogs6(StringBuilder sf, Long configeCodeId, Long productMaterialMasterId, Long transactionType, BigDecimal qty, Long routingId, List<BomBaseData> bbdList, Long productOrgId, Long pMaterialMasterId, boolean includeParent, Date expandBomDate) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc35(LogUtils.getConfiguredCodeNumberById(configeCodeId), LogUtils.getMaterialNumberById(productMaterialMasterId), LogUtils.getTransactionTypeNumberById(transactionType)));
        sf.append(LogUtils.getDesc36(qty, LogUtils.getRouteNumberById(routingId), LogUtils.getOrgNumberById(productOrgId)));
        sf.append(LogUtils.getDesc37(LogUtils.getMaterialNumberById(pMaterialMasterId), includeParent)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc43(sdf.format(expandBomDate))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc44(bbdList == null ? 0 : bbdList.size()));
        sf.append("bbdList=");
        if (!PlatformUtils.isNullList(bbdList)) {
            int i = 0;
            for (BomBaseData bd : bbdList) {
                sf.append(LogUtils.getDesc260(++i, LogUtils.getBBDDesc(bd))).append(SPLITCHAR);
            }
        }
    }

    private static String getDesc35(Object paramsa, Object paramsb, Object paramsc) {
        return String.format(ResManager.loadKDString((String)"\u8fdb\u884c\u914d\u7f6eBOM\u5c55\u5f00\uff0c\u914d\u7f6e\u53f7\uff1a%1$s\uff0c\u5de5\u5355\u4ea7\u54c1\u7269\u6599\uff1a%2$s\uff0c\u4e8b\u52a1\u7c7b\u578b\uff1a%3$s", (String)"LogUtils_35", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb, paramsc);
    }

    private static String getDesc36(Object paramsa, Object paramsb, Object paramsc) {
        return String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u6570\u91cf\uff1a%1$s\uff0c\u5de5\u827a\u8def\u7ebf\u53f7\uff1a%2$s\uff0c\u751f\u4ea7\u7ec4\u7ec7\uff1a%3$s", (String)"LogUtils_36", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb, paramsc);
    }

    private static String getDesc37(Object paramsa, Object paramsb) {
        return String.format(ResManager.loadKDString((String)"\u4e0b\u5c42\u4ea7\u54c1\u7269\u6599\uff1a%1$s\uff0c\u662f\u5426\u5305\u542b\u4e0b\u5c42\u4ea7\u54c1\u7269\u6599\u672c\u8eab\uff1a%2$s", (String)"LogUtils_37", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb);
    }

    private static String getDesc44(Object params) {
        return String.format(ResManager.loadKDString((String)"\u914d\u7f6eBOM\u5c55\u5f00\u7ed3\u679c\uff1abbdList.size\uff1a%1$s", (String)"LogUtils_44", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    public static void genLogs7(StringBuilder sf, Long expandBomId, BigDecimal qty, Long transactionType, Long routingId, List<BomBaseData> bbdList, Date expandBomDate) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc46(LogUtils.getBomNuber(expandBomId), LogUtils.getTransactionTypeNumberById(transactionType), qty, LogUtils.getRouteNumberById(routingId))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc43(sdf.format(expandBomDate))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc49(bbdList == null ? 0 : bbdList.size()));
        sf.append("bbdList=");
        if (!PlatformUtils.isNullList(bbdList)) {
            int i = 0;
            for (BomBaseData bd : bbdList) {
                sf.append(LogUtils.getDesc260(++i, LogUtils.getBBDDesc(bd))).append(SPLITCHAR);
            }
        }
        sf.append(SPLITCHAR);
    }

    private static String getDesc46(Object paramsa, Object paramsb, Object paramsc, Object paramsd) {
        return String.format(ResManager.loadKDString((String)"\u8fdb\u884c\u5236\u9020BOM\u5c55\u5f00\uff1a\u5236\u9020BOMID\uff1a%1$s\uff0c\u4e8b\u52a1\u7c7b\u578b\uff1a%2$s\uff0c\u4ea7\u54c1\u6570\u91cf\uff1a%3$s\uff0c\u5de5\u827a\u8def\u7ebf\u53f7\uff1a%4$s", (String)"LogUtils_46", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb, paramsc, paramsd);
    }

    private static String getDesc49(Object params) {
        return String.format(ResManager.loadKDString((String)"\u5236\u9020BOM\u5c55\u5f00\u7ed3\u679c\uff1abbdList.size\uff1a%1$s", (String)"LogUtils_49", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    public static void genLogs8(StringBuilder sf, Map<String, Object> stockDataMap, DynamicObject bomentry, Long bomWorkCenter, Long bomWorkStation) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc50(LogUtils.getMftBomEntryStr(bomentry), LogUtils.getStockNo(stockDataMap))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc53(LogUtils.getWorkcenterNumberById(bomWorkCenter), LogUtils.getWorkStationNumberById(bomWorkStation))).append(SPLITCHAR);
    }

    private static String getDesc50(Object paramsa, Object paramsb) {
        return String.format(ResManager.loadKDString((String)"BOM\u5c55\u5f00\u540e\u7684\u4e0b\u5c42\u5b50\u4ef6\u4fe1\u606f\uff1a%1$s\u5728\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355\uff1a%2$s\u4e2d\u5df2\u7ecf\u5b58\u5728\uff0c\u672c\u6b21\u4e0d\u6267\u884c\u65b0\u589e\u64cd\u4f5c\u3002", (String)"LogUtils_50", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb);
    }

    private static String getDesc53(Object paramsa, Object paramsb) {
        return String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u4e2d\u5fc3\uff1a%1$s\uff0c\u5de5\u4f4d\uff1a%2$s", (String)"LogUtils_53", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb);
    }

    public static void genLogs9(StringBuilder sf, Map<String, Object> refStockDataMap) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc55(refStockDataMap.get("orderno"))).append(SPLITCHAR);
    }

    private static String getDesc55(Object params) {
        return String.format(ResManager.loadKDString((String)"\u5de5\u5355%1$s\u5b58\u5728\u9519\u8bef\uff1a\u5176BOM\u5c55\u5f00\u65b9\u5f0f\u4e0d\u7b26\u5408\u914d\u7f6eBOM\u5c55\u5f00\u6761\u4ef6\uff0c\u65e0\u6cd5\u83b7\u53d6\u7279\u5f81\u9009\u9879\u7269\u6599\u6570\u636e\u3002", (String)"LogUtils_55", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    public static void genLogs10(StringBuilder sf, List<DynamicObject> bomentryList, DynamicObject bomentry) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        String materialNumber = "";
        if (!bomentryList.isEmpty()) {
            for (int i = 0; i < bomentryList.size(); ++i) {
                DynamicObject dy = bomentryList.get(i);
                Long materialId = dy.getLong("entrymaterialid");
                String mno = LogUtils.getMaterialNumberById(materialId);
                materialNumber = materialNumber == null || "".equals(materialNumber) ? mno : materialNumber + " " + mno;
            }
        }
        sf.append(LogUtils.getDesc57(bomentry.getLong("entryid"), bomentryList.size(), materialNumber)).append(SPLITCHAR);
    }

    private static String getDesc57(Object paramsa, Object paramsb, Object paramsc) {
        return String.format(ResManager.loadKDString((String)"BOM\u5206\u5f55\uff1a%1$s\u8fdb\u884c\u7279\u5f81\u7269\u6599\u5c55\u5f00\u540e\u5339\u914d\u5230\u7269\u6599\u6570\u4e3a%2$s\u4e2a\u3002\u7269\u6599\u7f16\u7801\u4e3a\uff1a%3$s", (String)"LogUtils_57", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb, paramsc);
    }

    public static void genLogs11(StringBuilder sf, Date expandBomDate, DynamicObject bomentry) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc60(sdf.format(expandBomDate))).append(SPLITCHAR);
        Date validDate = bomentry.getDate("entryvaliddate");
        Date inValidDate = bomentry.getDate("entryinvaliddate");
        sf.append(LogUtils.getDesc61(sdf.format(validDate), sdf.format(inValidDate), LogUtils.getMftBomEntryStr(bomentry))).append(SPLITCHAR);
    }

    private static String getDesc60(Object params) {
        return String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u672c\u6b21\u65b0\u589e\u53d8\u66f4\u7684\u5b9e\u65bd\u65f6\u95f4\u4e3a\uff1a%1$s", (String)"LogUtils_60", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc61(Object paramsa, Object paramsb, Object paramsc) {
        return String.format(ResManager.loadKDString((String)"\u5b9e\u65bd\u65f6\u95f4\u5728BOM\u7684\u751f\u6548\u65f6\u95f4%1$s~%2$s\u5916,\u6545\u4e0d\u6267\u884c\u672c\u6b21\u65b0\u589e\u64cd\u4f5c\u3002%3$s", (String)"LogUtils_61", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb, paramsc);
    }

    public static void genLogs12(StringBuilder sf, Long materialMatserId, Long bomVersionId, Long auxPropertyId, Map<String, Object> refStockDataMap, DynamicObject bomentry, String remark) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        String materialNumber = LogUtils.getMaterialNumberByBomEntry(bomentry);
        String parentMaterialNumber = LogUtils.getMaterialNumberById(materialMatserId);
        String orderNo = LogUtils.getStockNo(refStockDataMap);
        sf.append(LogUtils.getDesc63(remark)).append("   ");
        sf.append(LogUtils.getDesc64(materialNumber, parentMaterialNumber, orderNo)).append(SPLITCHAR);
    }

    public static void genLogs13(StringBuilder sf, Map<String, Object> refStockDataMap, DynamicObject bomentry, Long childMaterialId) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        String materialNumber = LogUtils.getMaterialNumberById(childMaterialId);
        String orderNo = LogUtils.getStockNo(refStockDataMap);
        sf.append(LogUtils.getDesc66(materialNumber, orderNo)).append(SPLITCHAR);
    }

    private static String getDesc64(Object paramsa, Object paramsb, Object paramsc) {
        return String.format(ResManager.loadKDString((String)"BOM\u5b50\u9879\u7269\u6599\uff1a%1$s\u5728\u8fdb\u884c\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u67e5\u8be2\u5230\u5bf9\u5e94\u7684BOM\u4ea7\u54c1\u7f16\u7801 %2$s \u5728\u7ec4\u4ef6\u6e05\u5355 %3$s\u4e0b\u7684\u5206\u5b50\u4e3a0\uff0c\u672c\u6b21\u4e0d\u6267\u884c\u65b0\u589e\u64cd\u4f5c\u3002", (String)"LogUtils_64", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb, paramsc);
    }

    private static String getDesc66(Object paramsa, Object paramsb) {
        return String.format(ResManager.loadKDString((String)"BOM\u5b50\u9879\u7269\u6599\uff1a%1$s\u5728\u7ec4\u4ef6\u6e05\u5355%2$s\u4e2d\u5df2\u7ecf\u5b58\u5728(\u540c\u4e00\u5de5\u4f4d\u3001\u5de5\u4f5c\u4e2d\u5fc3\u3001BOMentryID\u7b49)\uff0c\u672c\u6b21\u4e0d\u6267\u884c\u65b0\u589e\u64cd\u4f5c\u3002", (String)"LogUtils_66", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb);
    }

    public static void genLogs14(StringBuilder sf, Map<String, Object> refStockDataMap, String xBillNo) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc70(LogUtils.getStockDatas(refStockDataMap), xBillNo)).append(SPLITCHAR);
    }

    private static String getDesc70(Object paramsa, Object paramsb) {
        return String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\uff1a%1$s\u5df2\u5b58\u5728\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355 %2$s\u6570\u636e\uff0c\u672c\u6b21\u65b0\u589e\u4e0d\u6267\u884c\uff08\u7236\u9879\u4e3a\u8df3\u5c42\u4ef6\u65b0\u589e\uff0c\u4f46\u5b50\u9879\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355\uff09\u3002", (String)"LogUtils_70", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb);
    }

    public static void genLogs15(StringBuilder sf, Map<String, Object> refStockDataMap, List<Map<String, Object>> childStockEntryList, Long materialMasterId, Fraction diffFraction) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        String materialNumber = LogUtils.getMaterialNumberById(materialMasterId);
        String orderNo = LogUtils.getStockNo(refStockDataMap);
        sf.append(LogUtils.getDesc71(materialNumber, orderNo, diffFraction.getMole(), childStockEntryList.size())).append(SPLITCHAR);
    }

    private static String getDesc71(Object paramsa, Object paramsb, Object paramsc, Object paramsd) {
        return String.format(ResManager.loadKDString((String)"\u8df3\u5c42\u4ef6\u8fdb\u884cBOM\u5c55\u5f00\u540e\u7684\u4e0b\u5c42\u5b50\u9879\u7269\u6599\uff1a%1$s\uff0c\u5728\u7ec4\u4ef6\u6e05\u5355 %2$s \u4e2d\u5df2\u7ecf\u5b58\u5728\uff08\u540c\u4e00\u5de5\u4f4d\u3001\u5de5\u4f5c\u4e2d\u5fc3\u3001BOMentryID\u7b49\uff09\uff0c\u4e14\u5dee\u5f02\u6570\u91cf\u5b58\u5728\uff08\u5dee\u5f02\u5206\u5b50= %3$s\uff09 \uff0c\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355\u5206\u5f55\u884c\u5171 %4$s\u884c\uff09\uff0c\u672c\u6b21\u5c06\u6267\u884c\u4fee\u6539\u64cd\u4f5c\u64cd\u4f5c\u3002", (String)"LogUtils_71", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb, paramsc, paramsd);
    }

    public static void genLogs16(StringBuilder sf, Map<String, Object> refStockDataMap, String xBillNo) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc69(LogUtils.getStockDatas(refStockDataMap), xBillNo)).append(SPLITCHAR);
    }

    private static String getDesc69(Object paramsa, Object paramsb) {
        return String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\uff1a%1$s\u5df2\u5b58\u5728\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355 %2$s\u6570\u636e\uff0c\u672c\u6b21\u4fee\u6539\u4e0d\u6267\u884c\uff08\u7236\u9879\u4e3a\u8df3\u5c42\u4ef6\u65b0\u589e\uff0c\u5b50\u9879\u4e5f\u4e3a\u8df3\u5c42\u4ef6\u65b0\u589e\uff0c\u4f46\u5b50\u9879\u5df2\u5b58\u5728\u4e8e\u7ec4\u4ef6\u6e05\u5355\u4e2d\uff0c\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u6570\u91cf\u65f6\uff0c\u6821\u9a8c\u8be5\u5b50\u9879\u662f\u5426\u5df2\u5b58\u5728\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355\uff09\u3002", (String)"LogUtils_69", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb);
    }

    public static void genLogs17(StringBuilder sf, Long configeCodeId, Long productMaterialMasterId, Long transactionType, BigDecimal qty, Long routingId, List<BomBaseData> bbdList, Long productOrgId, Long pMaterialMasterId, boolean includeParent, Date expandBomDate, Long expandBomId) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc77(LogUtils.getBomNuber(expandBomId), LogUtils.getConfiguredCodeNumberById(configeCodeId), LogUtils.getMaterialNumberById(productMaterialMasterId), LogUtils.getTransactionTypeNumberById(transactionType)));
        sf.append(LogUtils.getDesc38(qty, LogUtils.getRouteNumberById(routingId), LogUtils.getOrgNumberById(productOrgId), LogUtils.getMaterialNumberById(pMaterialMasterId), includeParent)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc43(sdf.format(expandBomDate))).append(expandBomDate).append(SPLITCHAR);
        sf.append(LogUtils.getDesc79(bbdList == null ? 0 : bbdList.size()));
        sf.append("bbdList=");
        if (!PlatformUtils.isNullList(bbdList)) {
            int i = 0;
            for (BomBaseData bd : bbdList) {
                sf.append(LogUtils.getDesc260(++i, LogUtils.getBBDDesc(bd))).append(SPLITCHAR);
            }
        }
    }

    private static String getDesc77(Object paramsa, Object paramsb, Object paramsc, Object paramsd) {
        return String.format(ResManager.loadKDString((String)"\u8fdb\u884cBOM\u591a\u7c7b\u578b\u5c55\u5f00\uff0c\u5236\u9020BOMID\uff1a%1$s\uff0c\u914d\u7f6e\u53f7\uff1a %2$s\uff0c\u5de5\u5355\u4ea7\u54c1\u7269\u6599 \uff1a%3$s\uff0c\u4e8b\u52a1\u7c7b\u578b\uff1a %4$s", (String)"LogUtils_77", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb, paramsc, paramsd);
    }

    private static String getDesc38(Object paramsa, Object paramsb, Object paramsc, Object paramsd, Object paramse) {
        return String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u6570\u91cf\uff1a%1$s\uff0c\u5de5\u827a\u8def\u7ebf\u53f7\uff1a %2$s\uff0c\u751f\u4ea7\u7ec4\u7ec7\uff1a%3$s\uff0c\u4e0b\u5c42\u4ea7\u54c1\u7269\u6599 \uff1a%4$s\uff0c\u662f\u5426\u5305\u542b\u4e0b\u5c42\u4ea7\u54c1\u7269\u6599\u672c\u8eab\uff1a %5$s", (String)"LogUtils_38", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb, paramsc, paramsd, paramse);
    }

    private static String getDesc43(Object paramsa) {
        return String.format(ResManager.loadKDString((String)"BOM\u5c55\u5f00\u65f6\u95f4\uff1a%1$s", (String)"LogUtils_43", (String)APPNUMBER, (Object[])new Object[0]), paramsa);
    }

    private static String getDesc79(Object paramsa) {
        return String.format(ResManager.loadKDString((String)"\u591a\u7c7b\u578bBOM\u5c55\u5f00\u7ed3\u679c\uff1abbdList.size\uff1a%1$s", (String)"LogUtils_79", (String)APPNUMBER, (Object[])new Object[0]), paramsa);
    }

    public static String getWorkcenterNumberById(Long wcId) {
        if (wcId == null || wcId.equals(0L)) {
            return "";
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)wcId, (String)"mpdm_workcentre", (String)"number");
        return obj.getString("number");
    }

    public static String getOrgNumberById(Long orgId) {
        if (orgId == null || orgId.equals(0L)) {
            return "";
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)"number");
        return obj.getString("number");
    }

    public static String getConfiguredCodeNumberById(Long cId) {
        if (cId == null || cId.equals(0L)) {
            return "";
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)cId, (String)"bd_configuredcode", (String)"number");
        return obj.getString("number");
    }

    public static String getWorkStationNumberById(Long wsid) {
        if (wsid == null || wsid.equals(0L)) {
            return "";
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)wsid, (String)"mpdm_workstation", (String)"number");
        return obj.getString("number");
    }

    public static String getTransactionTypeNumberById(Long tid) {
        if (tid == null || tid.equals(0L)) {
            return "";
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)tid, (String)"mpdm_transactproduct", (String)"number");
        return obj.getString("number");
    }

    public static String getRouteNumberById(Long rtid) {
        if (rtid == null || rtid.equals(0L)) {
            return "";
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)rtid, (String)"pdm_route", (String)"number");
        return obj.getString("number");
    }

    public static String getChangeTypeName(String changeType) {
        if ("A".equals(changeType)) {
            return ResManager.loadKDString((String)"\u589e\u52a0\u6570\u91cf", (String)"LogUtils_80", (String)APPNUMBER, (Object[])new Object[0]);
        }
        if ("B".equals(changeType)) {
            return ResManager.loadKDString((String)"\u51cf\u5c11\u6570\u91cf", (String)"LogUtils_81", (String)APPNUMBER, (Object[])new Object[0]);
        }
        if ("C".equals(changeType)) {
            return ResManager.loadKDString((String)"\u65b0\u589e\u7269\u6599", (String)"LogUtils_82", (String)APPNUMBER, (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5176\u5b83\u8c03\u6574", (String)"LogUtils_83", (String)APPNUMBER, (Object[])new Object[0]);
    }

    public static String getRouteChangeTypeName(String changeType) {
        if ("A".equals(changeType)) {
            return ResManager.loadKDString((String)"\u65b0\u589e\u5de5\u5e8f", (String)"LogUtils_84", (String)APPNUMBER, (Object[])new Object[0]);
        }
        if ("B".equals(changeType)) {
            return ResManager.loadKDString((String)"\u4fee\u6539\u5de5\u5e8f", (String)"LogUtils_85", (String)APPNUMBER, (Object[])new Object[0]);
        }
        if ("C".equals(changeType)) {
            return ResManager.loadKDString((String)"\u5931\u6548\u5de5\u5e8f", (String)"LogUtils_86", (String)APPNUMBER, (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5176\u5b83\u8c03\u6574", (String)"LogUtils_83", (String)APPNUMBER, (Object[])new Object[0]);
    }

    public static String getResltDatas(Map<String, Object> dataMap) {
        StringBuilder sb = new StringBuilder();
        Object materialId = dataMap.get("materialmasterid");
        sb.append(LogUtils.getDesc87(dataMap.get("ecochangebillno"))).append(SPLITCHAR);
        sb.append(LogUtils.getDesc88(LogUtils.getChangeTypeName(dataMap.get("changetype").toString()))).append(SPLITCHAR);
        sb.append(LogUtils.getDesc89(dataMap.get("changeqtynumerator"))).append(SPLITCHAR);
        sb.append(LogUtils.getDesc25(dataMap.get("stockno"), dataMap.get("stockseq"), LogUtils.getMaterialNumberById(materialId))).append(SPLITCHAR);
        return sb.toString();
    }

    private static String getDesc89(Object params) {
        return String.format(ResManager.loadKDString((String)"\u53d8\u52a8\u5206\u5b50\uff1a%1$s", (String)"LogUtils_89", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    public static void genLogs9(StringBuilder sf, List<Map<String, Object>> gridList) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(SPLITCHAR);
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc91(gridList.size())).append(SPLITCHAR);
        for (int i = 0; i < gridList.size(); ++i) {
            Map<String, Object> dataMap = gridList.get(i);
            sf.append(LogUtils.getDesc204(i, LogUtils.getResltDatas(dataMap))).append(SPLITCHAR);
        }
    }

    private static String genXStockKeyString(String queryType, String stockId, String orderType, String bomentryId, String materialId) {
        return LogUtils.getUnionString(queryType, stockId, orderType, bomentryId, materialId);
    }

    private static String genXTechKeyString(String queryType, String techId, String orderType, String routeEntryId) {
        return PlatformUtils.getUnionString((Object)queryType, (Object)techId, (Object)orderType, (Object)routeEntryId);
    }

    public static String getUnionString(Object obj1, Object obj2, Object obj3, Object obj4, Object obj5) {
        return PlatformUtils.getUnionString((Object)PlatformUtils.getUnionString((Object)obj1, (Object)obj2, (Object)obj3, (Object)obj4), (Object)obj5);
    }

    public static void genLogs31(StringBuilder sf, Map<String, Object> stockDataMap, DynamicObject bomentry, DynamicObject ecoBomEntry, int isDisabledValue, Map<String, String> xstockMap) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc283(bomentry.getLong("entryid"))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc29(LogUtils.getMftBomEntryStr(bomentry))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc282(LogUtils.getStockDatas(stockDataMap))).append(SPLITCHAR);
        if (isDisabledValue != 0) {
            if (isDisabledValue == 1) {
                sf.append(LogUtils.getDesc281()).append(SPLITCHAR);
            } else if (isDisabledValue == 2) {
                sf.append(LogUtils.getDesc280()).append(SPLITCHAR);
            } else if (isDisabledValue == 3) {
                String stockEntryId = String.valueOf(stockDataMap.get("stockentry"));
                String orderType = String.valueOf(stockDataMap.get("ordertype"));
                String materialId = String.valueOf(stockDataMap.get("stockentry.materielmasterid"));
                String xStockString = LogUtils.genXStockKeyString("B", stockEntryId, orderType, "", materialId);
                String xChangeBillNo = xstockMap.get(xStockString);
                sf.append(LogUtils.getDesc97(xChangeBillNo)).append(SPLITCHAR);
            }
        }
    }

    private static String getDesc283(Object s) {
        return ResManager.loadKDString((String)"\u5bf9BOM\u5206\u5f55\u6267\u884c\u5931\u6548\u64cd\u4f5c\uff1a\u5206\u5f55ID\uff1a%s", (String)"LogUtils_93", (String)APPNUMBER, (Object[])new Object[]{s});
    }

    private static String getDesc282(Object s) {
        return ResManager.loadKDString((String)"\u672c\u6b21\u5f85\u5931\u6548\u7684\u7ec4\u4ef6\u6e05\u5355\u4fe1\u606f\uff1a%s", (String)"LogUtils_94", (String)APPNUMBER, (Object[])new Object[]{s});
    }

    private static String getDesc281() {
        return ResManager.loadKDString((String)"\u8be5\u7ec4\u4ef6\u5728\u7ec4\u4ef6\u6e05\u5355\u4e2d\u5df2\u7ecf\u5931\u6548(\u539f\u56e0\uff1a\u9700\u6c42\u6570\u91cf<=\u5b9e\u53d1\u6570\u91cf )\uff0c\u672c\u6b21\u4e0d\u6267\u884c\u5931\u6548\u64cd\u4f5c\u3002", (String)"LogUtils_95", (String)APPNUMBER, (Object[])new Object[0]);
    }

    private static String getDesc280() {
        return ResManager.loadKDString((String)"\u8be5\u7ec4\u4ef6\u5728\u7ec4\u4ef6\u6e05\u5355\u4e2d\u5df2\u7ecf\u5931\u6548(\u539f\u56e0\uff1a\u7ec4\u4ef6\u6e05\u5355\u7684\u5206\u5b50=0 )\uff0c\u672c\u6b21\u4e0d\u6267\u884c\u5931\u6548\u64cd\u4f5c\u3002", (String)"LogUtils_96", (String)APPNUMBER, (Object[])new Object[0]);
    }

    private static String getDesc97(Object params) {
        return String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u4ef6\u5728\u7ec4\u4ef6\u6e05\u5355\u4e2d\u5df2\u7ecf\u5931\u6548\uff08\u539f\u56e0\uff1a\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355\uff1a%1$s\uff09\uff0c\u672c\u6b21\u4e0d\u6267\u884c\u5931\u6548\u64cd\u4f5c\u3002", (String)"LogUtils_97", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    public static void genLogs32(StringBuilder sf, Map<String, Object> stockDataMap) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        Object seq = stockDataMap.get("stockentry.seq");
        Object parentStockEntryId = stockDataMap.get("stockentry");
        sf.append(LogUtils.getDesc26(stockDataMap.get("billno")));
        sf.append(LogUtils.getDesc279(seq, parentStockEntryId));
        sf.append(LogUtils.getDesc264(LogUtils.getMaterialNumberById(stockDataMap.get("stockentry.materielmasterid")))).append(SPLITCHAR);
    }

    private static String getDesc279(Object seq, Object parentStockEntryId) {
        return String.format(ResManager.loadKDString((String)"\u5931\u6548\u7684\u7ec4\u4ef6\u7269\u6599\u4e3a\u8df3\u5c42\u4ef6\uff0c\u5c06\u5bf9\u5176\u5b50\u5c42\u7684\u7ec4\u4ef6\u540c\u65f6\u6267\u884c\u5931\u6548\u64cd\u4f5c\u3002\u7236\u7ec4\u4ef6\u5e8f\u53f7\u4e3a\uff1a%1$s\uff0c\u7236\u7ec4\u4ef6\u5206\u5f55ID\uff1a%2$s", (String)"LogUtils_100", (String)APPNUMBER, (Object[])new Object[0]), seq, parentStockEntryId);
    }

    public static void genLogs33(StringBuilder sf, String billno, String orderType, Long pStockEntryId, List<Map<String, Object>> nextStockDataList) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        int size = nextStockDataList == null ? 0 : nextStockDataList.size();
        sf.append(LogUtils.getDesc278(billno, pStockEntryId));
        sf.append(LogUtils.getDesc277(size, pStockEntryId)).append(SPLITCHAR);
        if (size > 0) {
            sf.append(LogUtils.getDesc276());
            for (int i = 0; i < size; ++i) {
                Map<String, Object> dataMap = nextStockDataList.get(i);
                sf.append(i + 1).append(":").append(LogUtils.getStockDatas(dataMap));
            }
            sf.append(SPLITCHAR);
        }
    }

    private static String getDesc278(Object billno, Object parentMaterialNumber) {
        return String.format(ResManager.loadKDString((String)"\u4f9d\u636e\u7ec4\u4ef6\u6e05\u5355\u53f7%1$s\uff0c\u7236\u7ec4\u4ef6\u5206\u5f55ID\uff1a%2$s", (String)"LogUtils_101", (String)APPNUMBER, (Object[])new Object[0]), billno, parentMaterialNumber);
    }

    private static String getDesc277(int size, Long parentStockEntryId) {
        return String.format(ResManager.loadKDString((String)"\u8fdb\u884c\u4e0b\u5c42\u7ec4\u4ef6\u5206\u5f55\u67e5\u627e\u65f6\u7684\u7ed3\u679c\u4e3a%1$s\u6761\uff0c\u67e5\u627e\u65b9\u5f0f\u4e3a\uff1a\u540c\u4e00\u7ec4\u4ef6\u6e05\u5355\u5185\uff0c\u7236\u9879\u7ec4\u4ef6\u5206\u5f55ID(pstockentryid)\u7b49\u4e8e%2$s\u7684\u6570\u636e\u3002", (String)"LogUtils_105", (String)APPNUMBER, (Object[])new Object[0]), size, parentStockEntryId);
    }

    private static String getDesc276() {
        return ResManager.loadKDString((String)"\u5b50\u5c42\u6570\u636e\u5982\u4e0b\uff1a", (String)"LogUtils_107", (String)APPNUMBER, (Object[])new Object[0]);
    }

    public static void genLogs34(StringBuilder sf, int isDisabledValue, Map<String, String> xstockMap, Map<String, Object> stockDataMap) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc275(LogUtils.getStockDatas(stockDataMap)));
        if (isDisabledValue != 0) {
            if (isDisabledValue == 1) {
                sf.append(LogUtils.getDesc274()).append(SPLITCHAR);
            } else if (isDisabledValue == 2) {
                sf.append(LogUtils.getDesc273()).append(SPLITCHAR);
            } else if (isDisabledValue == 3) {
                String stockEntryId = String.valueOf(stockDataMap.get("stockentry"));
                String orderType = String.valueOf(stockDataMap.get("ordertype"));
                String materialId = String.valueOf(stockDataMap.get("stockentry.materielmasterid"));
                String xStockString = LogUtils.genXStockKeyString("B", stockEntryId, orderType, "", materialId);
                String xChangeBillNo = xstockMap.get(xStockString);
                sf.append(LogUtils.getDesc111(xChangeBillNo)).append(SPLITCHAR);
            }
        }
    }

    private static String getDesc275(Object paramsa) {
        return ResManager.loadKDString((String)"\u5b50\u5c42\u7ec4\u4ef6\u6e05\u5355\uff1a%s", (String)"LogUtils_108", (String)APPNUMBER, (Object[])new Object[]{paramsa});
    }

    private static String getDesc274() {
        return ResManager.loadKDString((String)"\u5df2\u7ecf\u5931\u6548\uff08\u539f\u56e0\uff1a\u9700\u6c42\u6570\u91cf<=\u5b9e\u53d1\u6570\u91cf \uff09\uff0c\u672c\u6b21\u4e0d\u6267\u884c\u5931\u6548\u64cd\u4f5c\u3002", (String)"LogUtils_109", (String)APPNUMBER, (Object[])new Object[0]);
    }

    private static String getDesc273() {
        return ResManager.loadKDString((String)"\u5df2\u7ecf\u5931\u6548\uff08\u539f\u56e0\uff1a\u7ec4\u4ef6\u6e05\u5355\u7684\u5206\u5b50=0 \uff09\uff0c\u672c\u6b21\u4e0d\u6267\u884c\u5931\u6548\u64cd\u4f5c\u3002", (String)"LogUtils_110", (String)APPNUMBER, (Object[])new Object[0]);
    }

    private static String getDesc111(Object params) {
        return String.format(ResManager.loadKDString((String)"\u5df2\u7ecf\u5931\u6548\uff08\u539f\u56e0\uff1a\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7ec4\u4ef6\u6e05\u5355\u53d8\u66f4\u5355\uff1a%1$s\uff09\uff0c\u672c\u6b21\u4e0d\u6267\u884c\u5931\u6548\u64cd\u4f5c\u3002", (String)"LogUtils_111", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    public static void genLogs35(StringBuilder sf, List<Map<String, Object>> gridList) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(SPLITCHAR);
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc112(gridList.size())).append(SPLITCHAR);
        for (int i = 0; i < gridList.size(); ++i) {
            Map<String, Object> dataMap = gridList.get(i);
            sf.append(LogUtils.getDesc204(i, LogUtils.getResltDatas(dataMap))).append(SPLITCHAR);
        }
    }

    public static void genLogs36(StringBuilder sf, Map<String, Object> stockDataMap, DynamicObject bomentry, DynamicObject ecoBomEntry, Date expandBomDate) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc272(sdf.format(expandBomDate))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc272(sdf.format(expandBomDate))).append(SPLITCHAR);
        Date validDate = bomentry.getDate("entryvaliddate");
        Date inValidDate = bomentry.getDate("entryinvaliddate");
        sf.append(LogUtils.getDesc271(sdf.format(validDate), sdf.format(inValidDate), LogUtils.getMftBomEntryStr(bomentry))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc271(sdf.format(validDate), sdf.format(inValidDate), LogUtils.getMftBomEntryStr(bomentry))).append(SPLITCHAR);
    }

    private static String getDesc272(Object paramsa) {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u672c\u6b21\u53d8\u66f4\u7684\u5b9e\u65bd\u65f6\u95f4\u4e3a\uff1a%s", (String)"LogUtils_90", (String)APPNUMBER, (Object[])new Object[]{paramsa});
    }

    private static String getDesc271(Object paramsa, Object paramsb, Object paramsc) {
        return String.format(ResManager.loadKDString((String)"\u5b9e\u65bd\u65f6\u95f4\u5728BOM\u7684\u751f\u6548\u65f6\u95f4%1$s~%2$s\u5185,\u6545\u672c\u6b21\u4e0d\u6267\u884c\u5931\u6548\u64cd\u4f5c\u3002%3$s", (String)"LogUtils_120", (String)APPNUMBER, (Object[])new Object[0]), paramsa, paramsb, paramsc);
    }

    public static void genLogs51(StringBuilder sf, DynamicObject bomEntryBefore, DynamicObject bomEntryAfter, DynamicObject childBom) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(SPLITCHAR);
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc270(childBom.getString("number")));
        sf.append(LogUtils.getDesc269()).append(SPLITCHAR);
        sf.append(LogUtils.getDesc268(LogUtils.getMaterialNumberByBomEntry(bomEntryBefore))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc267(LogUtils.getMaterialNumberByBomEntry(bomEntryAfter))).append(SPLITCHAR);
    }

    private static String getDesc270(Object material) {
        return ResManager.loadKDString((String)"\u5bf9BOM\u5206\u5f55\u6267\u884c\u4fee\u6539\u64cd\u4f5c:BOM\u7f16\u7801\uff1a%s\uff0c", (String)"LogUtils_113", (String)APPNUMBER, (Object[])new Object[]{material});
    }

    private static String getDesc269() {
        return ResManager.loadKDString((String)"\u53d8\u66f4\u524d\u7269\u6599\u4e0e\u53d8\u66f4\u540e\u7269\u6599\u4e0d\u4e00\u81f4\uff0c\u5206\u522b\u8fdb\u884c\u5931\u6548\u4e0e\u65b0\u589e\u64cd\u4f5c\u3002", (String)"LogUtils_114", (String)APPNUMBER, (Object[])new Object[0]);
    }

    private static String getDesc268(Object material) {
        return ResManager.loadKDString((String)"\u4fee\u6539\u524d\u7269\u6599\u7f16\u7801\uff1a%s", (String)"LogUtils_115", (String)APPNUMBER, (Object[])new Object[]{material});
    }

    private static String getDesc267(Object material) {
        return ResManager.loadKDString((String)"\u4fee\u6539\u540e\u7269\u6599\u7f16\u7801\uff1a%s", (String)"LogUtils_116", (String)APPNUMBER, (Object[])new Object[]{material});
    }

    public static void genLogs52(StringBuilder sf, List<Map<String, Object>> gridList) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(SPLITCHAR);
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc117(gridList.size())).append(SPLITCHAR);
        for (int i = 0; i < gridList.size(); ++i) {
            Map<String, Object> dataMap = gridList.get(i);
            sf.append(LogUtils.getDesc204(i, LogUtils.getResltDatas(dataMap))).append(SPLITCHAR);
        }
    }

    public static void genLogs53(StringBuilder sf, Map<String, Object> stockDataMap) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(SPLITCHAR);
        sf.append(sdf.format(new Date(startTime))).append(" ");
        Object seq = stockDataMap.get("stockentry.seq");
        Object parentStockEntryId = stockDataMap.get("stockentry");
        sf.append(LogUtils.getDesc266(stockDataMap.get("billno")));
        sf.append(LogUtils.getDesc265(seq, parentStockEntryId));
        sf.append(LogUtils.getDesc264(LogUtils.getMaterialNumberById(stockDataMap.get("stockentry.materielmasterid")))).append(SPLITCHAR);
    }

    private static String getDesc266(Object material) {
        return ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u53f7%s", (String)"LogUtils_99", (String)APPNUMBER, (Object[])new Object[]{material});
    }

    private static String getDesc265(Object seq, Object parentStockEntryId) {
        return String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4fee\u6539\u7684\u7ec4\u4ef6\u7269\u6599\u4e3a\u8df3\u5c42\u4ef6\uff0c\u5c06\u5bf9\u5176\u5b50\u5c42\u7684\u7ec4\u4ef6\u540c\u65f6\u6267\u884c\u4fee\u6539\u64cd\u4f5c\u3002\u7236\u7ec4\u4ef6\u5e8f\u53f7\u4e3a\uff1a%1$s\uff0c\u7236\u7ec4\u4ef6\u5206\u5f55ID\uff1a%2$s", (String)"LogUtils_118", (String)APPNUMBER, (Object[])new Object[0]), seq, parentStockEntryId);
    }

    private static String getDesc264(Object material) {
        return ResManager.loadKDString((String)"\u7236\u7269\u6599\u7f16\u7801%s", (String)"LogUtils_102", (String)APPNUMBER, (Object[])new Object[]{material});
    }

    public static void genLogs54(StringBuilder sf, String billno, String orderType, Long parentStockEntryId, Long parentMaterialId, List<Map<String, Object>> nextStockDataList) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        int size = nextStockDataList == null ? 0 : nextStockDataList.size();
        String parentMaterialNumber = LogUtils.getMaterialNumberById(parentMaterialId);
        sf.append(LogUtils.getDesc263(billno, parentMaterialNumber));
        sf.append(LogUtils.getDesc262(size, parentStockEntryId)).append(SPLITCHAR);
        if (size > 0) {
            sf.append(LogUtils.getDesc261());
            for (int i = 0; i < size; ++i) {
                Map<String, Object> dataMap = nextStockDataList.get(i);
                sf.append(i + 1).append(":").append(LogUtils.getStockDatas(dataMap));
            }
            sf.append(SPLITCHAR);
        }
    }

    private static String getDesc263(String billno, String parentMaterialNumber) {
        return String.format(ResManager.loadKDString((String)"\u4f9d\u636e\u7ec4\u4ef6\u6e05\u5355\u53f7%1$s,\u7236\u9879\u7ec4\u4ef6\u7f16\u7801\uff1a%2$s", (String)"LogUtils_103", (String)APPNUMBER, (Object[])new Object[0]), billno, parentMaterialNumber);
    }

    private static String getDesc262(int size, Long parentStockEntryId) {
        return String.format(ResManager.loadKDString((String)"\u8fdb\u884c\u4e0b\u5c42\u7ec4\u4ef6\u5206\u5f55\u67e5\u627e\u65f6\u7684\u7ed3\u679c\u4e3a%1$s\u6761\uff0c\u67e5\u627e\u65b9\u5f0f\u4e3a\uff1a\u540c\u4e00\u7ec4\u4ef6\u6e05\u5355\u5185\uff0c\u7236\u9879\u7ec4\u4ef6\u5206\u5f55ID\u7b49\u4e8e%2$s\u7684\u6570\u636e\u3002", (String)"LogUtils_104", (String)APPNUMBER, (Object[])new Object[0]), size, parentStockEntryId);
    }

    private static String getDesc261() {
        return ResManager.loadKDString((String)"\u5b50\u5c42\u6570\u636e\u5982\u4e0b\uff1a", (String)"LogUtils_107", (String)APPNUMBER, (Object[])new Object[0]);
    }

    public static void genLogs55(StringBuilder sf, Long configeCodeId, Long productMaterialMasterId, Long transactionType, BigDecimal qty, Long routingId, List<BomBaseData> bbdList, Long productOrgId, Date expandBomDate, String otherRemark) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc63(otherRemark)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc35(LogUtils.getConfiguredCodeNumberById(configeCodeId), LogUtils.getMaterialNumberById(productMaterialMasterId), LogUtils.getTransactionTypeNumberById(transactionType)));
        sf.append(LogUtils.getDesc36(qty, LogUtils.getRouteNumberById(routingId), LogUtils.getOrgNumberById(productOrgId))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc43(sdf.format(expandBomDate))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc44(bbdList == null ? 0 : bbdList.size())).append(SPLITCHAR);
        sf.append("bbdList=");
        if (bbdList != null && bbdList.size() > 0) {
            int i = 0;
            for (BomBaseData bd : bbdList) {
                sf.append(LogUtils.getDesc260(++i, LogUtils.getBBDDesc(bd))).append(SPLITCHAR);
            }
        }
    }

    private static String getDesc63(Object params) {
        return String.format(ResManager.loadKDString((String)"\u4ee3\u7801\u4f4d\u7f6e\uff1a%1$s", (String)"LogUtils_63", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    public static void genLogs56(StringBuilder sf, Long expandBomId, BigDecimal qty, Long transactionType, Long routingId, List<BomBaseData> bbdList, Date expandBomDate) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc46(LogUtils.getBomNuber(expandBomId), LogUtils.getTransactionTypeNumberById(transactionType), qty, LogUtils.getRouteNumberById(routingId))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc43(sdf.format(expandBomDate))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc49(bbdList == null ? 0 : bbdList.size()));
        sf.append("bbdList=");
        if (bbdList != null && bbdList.size() > 0) {
            int i = 0;
            for (BomBaseData bd : bbdList) {
                sf.append(LogUtils.getDesc260(++i, LogUtils.getBBDDesc(bd))).append(SPLITCHAR);
            }
        }
    }

    private static String getDesc260(int i, Object bd) {
        return String.format(ResManager.loadKDString((String)"\u5e8f\u53f7\uff1a%1$s:%2$s", (String)"LogUtils_124", (String)APPNUMBER, (Object[])new Object[0]), i, bd);
    }

    public static String getBBDDesc(BomBaseData bbd) {
        StringBuilder sf = new StringBuilder();
        Long bomEntryId = bbd.getBomEntryId();
        Long materialMasterId = bbd.getMaterilID();
        Object fz = bbd.getQtynumerator();
        boolean isJumpLevel = bbd.getIsJump();
        Long pmaterialid = bbd.getPMaterialid();
        sf.append(LogUtils.getDesc259(bomEntryId));
        sf.append(LogUtils.getDesc258(fz));
        sf.append(LogUtils.getDesc257(isJumpLevel));
        sf.append(LogUtils.getDesc256(LogUtils.getMaterialNumberById(materialMasterId)));
        sf.append(LogUtils.getDesc255(LogUtils.getMaterialNumberByMftId(pmaterialid)));
        return sf.toString();
    }

    private static String getDesc259(Object bomEntryId) {
        return ResManager.loadKDString((String)"BOM\u5206\u5f55\u7684ID=%s,", (String)"LogUtils_125", (String)APPNUMBER, (Object[])new Object[]{bomEntryId});
    }

    private static String getDesc258(Object fz) {
        return ResManager.loadKDString((String)"\u5206\u5b50=%s,", (String)"LogUtils_126", (String)APPNUMBER, (Object[])new Object[]{fz});
    }

    private static String getDesc257(boolean isJumpLevel) {
        return ResManager.loadKDString((String)"\u8df3\u5c42=%s,", (String)"LogUtils_127", (String)APPNUMBER, (Object[])new Object[]{LogUtils.getDesc285(isJumpLevel)});
    }

    private static String getDesc285(boolean isJumpLevel) {
        return isJumpLevel ? ResManager.loadKDString((String)"\u662f", (String)"LogUtils_128", (String)APPNUMBER, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"LogUtils_129", (String)APPNUMBER, (Object[])new Object[0]);
    }

    private static String getDesc256(String pmaterialid) {
        return ResManager.loadKDString((String)"\u7ec4\u4ef6\u7f16\u7801=%s,", (String)"LogUtils_139", (String)APPNUMBER, (Object[])new Object[]{pmaterialid});
    }

    private static String getDesc255(String pmaterialid) {
        return ResManager.loadKDString((String)"\u7236\u9879\u7269\u6599\u7f16\u7801=%s\u3002", (String)"LogUtils_133", (String)APPNUMBER, (Object[])new Object[]{pmaterialid});
    }

    public static void genLogs91(StringBuilder sf, int beforeSize, int afterSize) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc254(beforeSize, afterSize)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc253()).append(SPLITCHAR);
    }

    private static String getDesc254(int beforeSize, int afterSize) {
        return String.format(ResManager.loadKDString((String)"\u5168\u90e8\u5206\u6790\u5b8c\u6210\u540e\uff0c\u5bf9\u6570\u636e\u8fdb\u884c\u53bb\u91cd\u64cd\u4f5c\uff0c\u53bb\u91cd\u524d\u6570\u636e\u6761\u6570\uff1a%1$s\uff0c\u53bb\u91cd\u540e\u6570\u636e\u6761\u6570\uff1a%2$s", (String)"LogUtils_132", (String)APPNUMBER, (Object[])new Object[0]), beforeSize, afterSize);
    }

    private static String getDesc253() {
        return ResManager.loadKDString((String)"\u53bb\u91cd\u4f9d\u636e\uff1a\u540c\u4e00\u7ec4\u4ef6\u6e05\u5355\u3001\u7ec4\u4ef6\u7269\u6599\u7f16\u7801\u3001\u53d8\u66f4\u5355\u4ea7\u54c1\u5206\u5f55\u3001BOM\u5206\u5f55ID\uff0c\u5de5\u4f4d\u3001\u5de5\u4f5c\u4e2d\u5fc3\u7b49\u7ef4\u5ea6\u6570\u636e\u3002", (String)"LogUtils_134", (String)APPNUMBER, (Object[])new Object[0]);
    }

    public static void genLogs92(StringBuilder sf) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc252()).append(SPLITCHAR);
    }

    private static String getDesc252() {
        return ResManager.loadKDString((String)"\u672a\u627e\u5230\u5ba1\u6838\u53ef\u7528\u7684\u5de5\u7a0b\u53d8\u66f4\u5339\u914d\u7ef4\u5ea6\u6570\u636e\uff0c\u4e0d\u8fdb\u884c\u5f71\u54cd\u8ba2\u5355\u4e1a\u52a1\u5206\u6790\u3002", (String)"LogUtils_135", (String)APPNUMBER, (Object[])new Object[0]);
    }

    public static void genLogs93(StringBuilder sf, DynamicObject filterObj, String stockEntityNumber, boolean isForward, QFilter addOtherFilter, QFilter editOtherFilter, Set<Long> queryDbBomIdSet, Set<Long> queryDbBomEntryIdSet, List<Map<String, Object>> addStockList, List<Map<String, Object>> editStockList) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc251(filterObj)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc250(stockEntityNumber, isForward)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc223(addOtherFilter)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc222(editOtherFilter)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc249(queryDbBomIdSet, addStockList)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc248(queryDbBomEntryIdSet, editStockList)).append(SPLITCHAR);
    }

    private static String getDesc251(DynamicObject filterObj) {
        return String.format(ResManager.loadKDString((String)"\u4f9d\u636e\u5de5\u7a0b\u53d8\u66f4\u5339\u914d\u7ef4\u5ea6%1$s %2$s\u8fdb\u884c\u7ec4\u4ef6\u6e05\u5355\u6570\u636e\u67e5\u8be2:", (String)"LogUtils_137", (String)APPNUMBER, (Object[])new Object[0]), filterObj.getString("number"), filterObj.getString("name"));
    }

    private static String getDesc250(String stockEntityNumber, boolean isForward) {
        return String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u5b9e\u4f53\uff1a%1$s\uff0c\u6b63\u5411\u6807\u8bc6\uff1a%2$s\u3002", (String)"LogUtils_138", (String)APPNUMBER, (Object[])new Object[0]), stockEntityNumber, isForward ? ResManager.loadKDString((String)"\u662f", (String)"LogUtils_128", (String)APPNUMBER, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"LogUtils_129", (String)APPNUMBER, (Object[])new Object[0]));
    }

    private static String getDesc249(Set<Long> queryDbBomIdSet, List<Map<String, Object>> addStockList) {
        return String.format(ResManager.loadKDString((String)"\u4f9d\u636eBOM\u8868\u5934ID\u8fdb\u884c\u67e5\u8be2\u7684\u6570\u636e\u60c5\u51b5\uff1aqueryDbBomIdSet=%1$s\uff0c\u67e5\u8be2\u51fa\u6765\u7684\u7ec4\u4ef6\u6e05\u5355\u7684\u6570\u636e\u91cf=%2$s\u6761\u3002", (String)"LogUtils_142", (String)APPNUMBER, (Object[])new Object[0]), queryDbBomIdSet.toString(), addStockList == null ? 0 : addStockList.size());
    }

    private static String getDesc248(Set<Long> queryDbBomEntryIdSet, List<Map<String, Object>> editStockList) {
        return String.format(ResManager.loadKDString((String)"\u4f9d\u636eBOM\u5206\u5f55ID\u8fdb\u884c\u67e5\u8be2\u7684\u6570\u636e\u60c5\u51b5\uff1aqueryDbBomEntryIdSet=%1$s\uff0c\u67e5\u8be2\u51fa\u6765\u7684\u7ec4\u4ef6\u6e05\u5355\u7684\u6570\u636e\u91cf=%2$s\u6761\u3002", (String)"LogUtils_145", (String)APPNUMBER, (Object[])new Object[0]), queryDbBomEntryIdSet.toString(), editStockList == null ? 0 : editStockList.size());
    }

    public static void genLogs94(StringBuilder sf, DynamicObject filterObj, Map<String, Object> stockDataMap, DynamicObject ecoBomEntry) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc07(stockDataMap, filterObj)).append(SPLITCHAR);
        sf.append(LogUtils.getBomDesc217(ecoBomEntry));
        sf.append(LogUtils.getDesc219(sdf, ecoBomEntry)).append(SPLITCHAR);
    }

    public static void genLogs95(StringBuilder sf, DynamicObject filterObj, Map<String, Object> stockDataMap, DynamicObject ecoBomEntry) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc06(stockDataMap, filterObj)).append(SPLITCHAR);
        sf.append(LogUtils.getBomDesc217(ecoBomEntry)).append(SPLITCHAR);
    }

    public static void genLogs96(StringBuilder sf, DynamicObject filterObj) {
        sf.append(LogUtils.getDesc247(filterObj)).append(SPLITCHAR);
    }

    private static String getDesc247(DynamicObject filterObj) {
        return String.format(ResManager.loadKDString((String)"-------------------------\u5f00\u59cb\u5bf9\u6570\u636e\u6e90[%1$s %2$s]\u8fdb\u884c\u65e5\u5fd7\u5206\u6790-------------------------", (String)"LogUtils_152", (String)APPNUMBER, (Object[])new Object[0]), filterObj.getString("number"), filterObj.getString("name"));
    }

    public static void genLogs97(StringBuilder sf, DynamicObject filterObj) {
        sf.append(LogUtils.getDesc246(filterObj)).append(SPLITCHAR);
    }

    private static String getDesc246(DynamicObject filterObj) {
        return String.format(ResManager.loadKDString((String)"-------------------------\u5b8c\u6210\u5bf9\u6570\u636e\u6e90[%1$s %2$s]\u7684\u65e5\u5fd7\u5206\u6790-------------------------", (String)"LogUtils_154", (String)APPNUMBER, (Object[])new Object[0]), filterObj.getString("number"), filterObj.getString("name"));
    }

    public static void genLogs98(StringBuilder sf, DynamicObject filterObj, Map<String, Object> stockDataMap, DynamicObject ecoBomEntry) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc245(stockDataMap)).append(SPLITCHAR);
        sf.append(LogUtils.getBomDesc217(ecoBomEntry)).append(SPLITCHAR);
    }

    private static String getDesc245(Map<String, Object> stockDataMap) {
        return String.format(ResManager.loadKDString((String)"%1$s\u7684childBomId(%2$s)\u4e0e\u53d8\u66f4\u5355\u7684BOM\u7684ID\u4e0d\u4e00\u81f4\uff0c\u81ea\u52a8\u8fc7\u6ee4\u6389\u3002", (String)"LogUtils_156", (String)APPNUMBER, (Object[])new Object[0]), LogUtils.getStockDatas(stockDataMap), stockDataMap.get("stockentry.childbomid"));
    }

    public static void genLogs0(StringBuilder sf) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc244()).append(SPLITCHAR);
    }

    private static String getDesc244() {
        return ResManager.loadKDString((String)"-------------------------\u5f00\u59cb\u5206\u6790\u65e5\u5fd7-------------------------", (String)"LogUtils_158", (String)APPNUMBER, (Object[])new Object[0]);
    }

    public static void genLogs100(StringBuilder sf) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc243()).append(SPLITCHAR);
    }

    private static String getDesc243() {
        return ResManager.loadKDString((String)"-------------------------\u65e5\u5fd7\u5168\u90e8\u5206\u6790\u5b8c\u6210-------------------------", (String)"LogUtils_159", (String)APPNUMBER, (Object[])new Object[0]);
    }

    public static void genLogs101(StringBuilder sf, Map<Long, DynamicObject> ecoRouteEntryMap, Set<Long> ecoRouteEntryIdSet, Set<Long> routeEntryIdSet, Date minActTime, Date maxActTime, Date hisMinDate) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc242(ecoRouteEntryIdSet)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc241(routeEntryIdSet)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc03(minActTime == null ? "" : sdf.format(minActTime))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc04(maxActTime == null ? "" : sdf.format(maxActTime))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc240(ecoRouteEntryMap)).append(SPLITCHAR);
    }

    private static String getDesc242(Set<Long> ecoRouteEntryIdSet) {
        return ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\uff1a\u5de5\u7a0b\u53d8\u66f4\u5355\u7684EcoRoute\u5206\u5f55ID\uff1a%s", (String)"LogUtils_160", (String)APPNUMBER, (Object[])new Object[]{ecoRouteEntryIdSet.toString()});
    }

    private static String getDesc241(Set<Long> routeEntryIdSet) {
        return ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u5de5\u827a\u8def\u7ebf\u5206\u5f55ID\u6570\u636e\uff1a%s", (String)"LogUtils_161", (String)APPNUMBER, (Object[])new Object[]{routeEntryIdSet.toString()});
    }

    private static String getDesc240(Map<Long, DynamicObject> ecoRouteEntryMap) {
        return ResManager.loadKDString((String)"\u672c\u6b21\u5f85\u5206\u6790\u7684EcoRoute\u6570\u636e\u60c5\u51b5\uff1a%s", (String)"LogUtils_162", (String)APPNUMBER, (Object[])new Object[]{LogUtils.getEcoRouteEntryMaps(ecoRouteEntryMap)});
    }

    public static String getEcoRouteEntryMaps(Map<Long, DynamicObject> ecoRouteEntryMap) {
        String msgInfo = "";
        if (ecoRouteEntryMap == null || ecoRouteEntryMap.isEmpty()) {
            msgInfo = ResManager.loadKDString((String)"\u7a7a", (String)"LogUtils_6", (String)APPNUMBER, (Object[])new Object[0]);
            return msgInfo;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Long, DynamicObject> entrys : ecoRouteEntryMap.entrySet()) {
            DynamicObject ecoRouteEntry = entrys.getValue();
            sb.append(LogUtils.getEcoRouteEntryStr(ecoRouteEntry)).append(SPLITCHAR);
        }
        return sb.toString();
    }

    public static String getEcoRouteEntryStr(DynamicObject ecoRouteEntry) {
        StringBuilder sb = new StringBuilder();
        String entrymode = ecoRouteEntry.getString("entrymode");
        Long ecoRouteid = ecoRouteEntry.getLong("ecorouteid");
        sb.append(LogUtils.getDesc239());
        sb.append(LogUtils.getECNBillNoByEcoRouteId(ecoRouteid)).append(" ");
        sb.append(LogUtils.getEntryMode(entrymode)).append(" ");
        sb.append(LogUtils.getDesc238());
        sb.append(ecoRouteEntry.getString("parent")).append(" ");
        sb.append(LogUtils.getDesc237());
        sb.append(ecoRouteEntry.getString("operationno")).append(" ");
        sb.append(LogUtils.getDesc236());
        sb.append(ecoRouteEntry.getString("operationdesc")).append(" ").append(SPLITCHAR);
        return sb.toString();
    }

    private static String getDesc239() {
        return ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355\u53f7\uff1a", (String)"LogUtils_189", (String)APPNUMBER, (Object[])new Object[0]);
    }

    private static String getDesc238() {
        return ResManager.loadKDString((String)" \u5de5\u5e8f\u5e8f\u5217\uff1a", (String)"LogUtils_163", (String)APPNUMBER, (Object[])new Object[0]);
    }

    private static String getDesc237() {
        return ResManager.loadKDString((String)" \u5de5\u5e8f\u53f7\uff1a", (String)"LogUtils_164", (String)APPNUMBER, (Object[])new Object[0]);
    }

    private static String getDesc236() {
        return ResManager.loadKDString((String)" \u5de5\u5e8f\u8bf4\u660e\uff1a", (String)"LogUtils_165", (String)APPNUMBER, (Object[])new Object[0]);
    }

    private static String getECNBillNoByEcoRouteId(Long ecorouteid) {
        HashSet<Long> ecoRouteIdSet = new HashSet<Long>(16);
        ecoRouteIdSet.add(ecorouteid);
        DynamicObject[] ecoBillNo = EcoRouteUtils.getEcoChangeBillData(ecoRouteIdSet);
        return ecoBillNo[0].getString("billno");
    }

    public static void genLogs102(StringBuilder sf, List<Map<String, Object>> techDataList, QFilter qFilter, String techEntityNumber) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc235(qFilter)).append(SPLITCHAR);
        if ("sfc_manftech".equalsIgnoreCase(techEntityNumber)) {
            sf.append(LogUtils.getDesc228(techEntityNumber)).append(SPLITCHAR);
        } else {
            sf.append(LogUtils.getDesc227(techEntityNumber)).append(SPLITCHAR);
        }
        String techs = LogUtils.getTechDatas(techDataList);
        if (techs == null || "".equals(techs)) {
            techs = ResManager.loadKDString((String)"\u65e0", (String)"LogUtils_20", (String)APPNUMBER, (Object[])new Object[0]);
        }
        sf.append(LogUtils.getDesc226(techs)).append(SPLITCHAR);
    }

    private static String getDesc235(QFilter qFilter) {
        return ResManager.loadKDString((String)"\u6309\u5de5\u827a\u8def\u7ebf\u8868\u5934Id\u8fc7\u6ee4\u5de5\u5e8f\u8ba1\u5212\u7684\u6761\u4ef6\uff1a%s", (String)"LogUtils_166", (String)APPNUMBER, (Object[])new Object[]{qFilter.toString()});
    }

    public static String getTechDatas(List<Map<String, Object>> techDataList) {
        if (techDataList == null || techDataList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < techDataList.size(); ++i) {
            Map<String, Object> techs = techDataList.get(i);
            sb.append(LogUtils.getTechDatas(techs)).append(SPLITCHAR);
        }
        return sb.toString();
    }

    public static String getTechDatas(Map<String, Object> techs) {
        StringBuilder sb = new StringBuilder();
        sb.append(LogUtils.getDesc234(techs));
        sb.append(LogUtils.getDesc233(techs));
        sb.append(LogUtils.getDesc232(techs));
        sb.append(LogUtils.getDesc231(techs));
        return sb.toString();
    }

    private static String getDesc234(Map<String, Object> techs) {
        return String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5355\u53f7\uff1a%1$s", (String)"LogUtils_170", (String)APPNUMBER, (Object[])new Object[0]), techs.get("billno"));
    }

    private static String getDesc233(Map<String, Object> techs) {
        return String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5206\u5f55\u5e8f\u53f7\uff1a%1$s", (String)"LogUtils_171", (String)APPNUMBER, (Object[])new Object[0]), techs.get("oprentryentity.seq"));
    }

    private static String getDesc232(Map<String, Object> techs) {
        return String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u53f7\uff1a%1$s", (String)"LogUtils_172", (String)APPNUMBER, (Object[])new Object[0]), techs.get("oprentryentity.oprno"));
    }

    private static String getDesc231(Map<String, Object> techs) {
        return String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8bf4\u660e\uff1a%1$s", (String)"LogUtils_173", (String)APPNUMBER, (Object[])new Object[0]), techs.get("oprentryentity.oprdescription"));
    }

    public static String getTechNo(Map<String, Object> techs) {
        StringBuilder sb = new StringBuilder();
        sb.append(LogUtils.getDesc230(techs)).append(SPLITCHAR);
        return sb.toString();
    }

    private static String getDesc230(Map<String, Object> techs) {
        return String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5355\u53f7\uff1a%1$s", (String)"LogUtils_170", (String)APPNUMBER, (Object[])new Object[0]), techs.get("billno"));
    }

    public static void genLogs103(StringBuilder sf, List<Map<String, Object>> techDataList, QFilter qFilter, String techEntityNumber) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc229(qFilter)).append(SPLITCHAR);
        sf.append(SPLITCHAR);
        if ("sfc_manftech".equalsIgnoreCase(techEntityNumber)) {
            sf.append(LogUtils.getDesc228(techEntityNumber)).append(SPLITCHAR);
        } else {
            sf.append(LogUtils.getDesc227(techEntityNumber)).append(SPLITCHAR);
        }
        sf.append(SPLITCHAR);
        sf.append(LogUtils.getDesc226(LogUtils.getTechDatas(techDataList))).append(SPLITCHAR);
    }

    private static String getDesc229(QFilter qFilter) {
        return ResManager.loadKDString((String)"\u6309\u5de5\u827a\u8def\u7ebf\u5206\u5f55Id\u8fc7\u6ee4\u5de5\u5e8f\u8ba1\u5212\u7684\u6761\u4ef6\uff1a%s", (String)"LogUtils_174", (String)APPNUMBER, (Object[])new Object[]{qFilter.toString()});
    }

    private static String getDesc228(String techEntityNumber) {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u5de5\u5e8f\u8ba1\u5212\u5bf9\u8c61\uff1a\u751f\u4ea7\u5de5\u5e8f\u8ba1\u5212 %s", (String)"LogUtils_167", (String)APPNUMBER, (Object[])new Object[]{techEntityNumber});
    }

    private static String getDesc227(String techEntityNumber) {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u5de5\u5e8f\u8ba1\u5212\u5bf9\u8c61\uff1a\u59d4\u5916\u5de5\u5e8f\u8ba1\u5212 %s", (String)"LogUtils_168", (String)APPNUMBER, (Object[])new Object[]{techEntityNumber});
    }

    private static String getDesc226(String techDataList) {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5230\u7684\u5de5\u5e8f\u8ba1\u5212\u6570\u636e\uff1a%s", (String)"LogUtils_169", (String)APPNUMBER, (Object[])new Object[]{techDataList});
    }

    public static void genLogs193(StringBuilder sf, DynamicObject filterObj, String techEntityNumber, boolean isForward, QFilter addOtherFilter, QFilter editOtherFilter, Set<Long> queryDbRouteIdSet, Set<Long> queryDbRouteEntryIdSet, List<Map<String, Object>> addTechList, List<Map<String, Object>> editTechList) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc225(filterObj)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc224(techEntityNumber, isForward)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc223(addOtherFilter)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc222(editOtherFilter)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc221(queryDbRouteIdSet, addTechList)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc220(queryDbRouteEntryIdSet, editTechList)).append(SPLITCHAR);
    }

    private static String getDesc225(DynamicObject filterObj) {
        return String.format(ResManager.loadKDString((String)"\u4f9d\u636e\u5de5\u7a0b\u53d8\u66f4\u5339\u914d\u7ef4\u5ea6%1$s %2$s\u8fdb\u884c\u5de5\u5e8f\u8ba1\u5212\u6570\u636e\u67e5\u8be2:", (String)"LogUtils_136", (String)APPNUMBER, (Object[])new Object[0]), filterObj.getString("number"), filterObj.getString("name"));
    }

    private static String getDesc224(String techEntityNumber, boolean isForward) {
        return String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5b9e\u4f53\uff1a%1$s\uff0c\u6b63\u5411\u6807\u8bc6\uff1a%2$s\u3002", (String)"LogUtils_176", (String)APPNUMBER, (Object[])new Object[0]), techEntityNumber, isForward ? ResManager.loadKDString((String)"\u662f", (String)"LogUtils_128", (String)APPNUMBER, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"LogUtils_129", (String)APPNUMBER, (Object[])new Object[0]));
    }

    private static String getDesc223(QFilter addOtherFilter) {
        return ResManager.loadKDString((String)"\u884c\u6807\u8bc6\u4e3a\u65b0\u589e\u65f6\u7684\u8fc7\u6ee4\u6761\u4ef6\uff1a%s", (String)"LogUtils_140", (String)APPNUMBER, (Object[])new Object[]{addOtherFilter});
    }

    private static String getDesc222(QFilter editOtherFilter) {
        return ResManager.loadKDString((String)"\u884c\u6807\u8bc6\u4e3a\u4fee\u6539/\u5931\u6548\u65f6\u7684\u8fc7\u6ee4\u6761\u4ef6\uff1a%s", (String)"LogUtils_141", (String)APPNUMBER, (Object[])new Object[]{editOtherFilter});
    }

    private static String getDesc221(Set<Long> queryDbRouteIdSet, List<Map<String, Object>> addTechList) {
        return String.format(ResManager.loadKDString((String)"\u4f9d\u636e\u5de5\u827a\u8def\u7ebf\u8868\u5934ID\u8fdb\u884c\u67e5\u8be2\u7684\u6570\u636e\u60c5\u51b5\uff1aqueryDbRouteIdSet=%1$s\uff0c\u67e5\u8be2\u51fa\u6765\u7684\u5de5\u5e8f\u8ba1\u5212\u7684\u6570\u636e\u91cf=%2$s\u6761\u3002", (String)"LogUtils_177", (String)APPNUMBER, (Object[])new Object[0]), queryDbRouteIdSet.toString(), addTechList == null ? 0 : addTechList.size());
    }

    private static String getDesc220(Set<Long> queryDbRouteEntryIdSet, List<Map<String, Object>> editTechList) {
        return String.format(ResManager.loadKDString((String)"\u4f9d\u636e\u5de5\u827a\u8def\u7ebf\u5206\u5f55ID\u8fdb\u884c\u67e5\u8be2\u7684\u6570\u636e\u60c5\u51b5\uff1aqueryDbRouteEntryIdSet=%1$s\uff0c\u67e5\u8be2\u51fa\u6765\u7684\u5de5\u5e8f\u8ba1\u5212\u7684\u6570\u636e\u91cf=%2$s\u6761\u3002", (String)"LogUtils_179", (String)APPNUMBER, (Object[])new Object[0]), queryDbRouteEntryIdSet.toString(), editTechList == null ? 0 : editTechList.size());
    }

    public static void genLogs194(StringBuilder sf, DynamicObject filterObj, Map<String, Object> techData, DynamicObject ecoRouteEntry) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc216(filterObj, techData)).append(SPLITCHAR);
        sf.append(LogUtils.getRouteDesc217(ecoRouteEntry));
        sf.append(LogUtils.getDesc219(sdf, ecoRouteEntry)).append(SPLITCHAR);
    }

    private static String getDesc219(SimpleDateFormat sdf, DynamicObject ecoRouteEntry) {
        return ResManager.loadKDString((String)"\u5b9e\u65bd\u65f6\u95f4\u4e3a\uff1a%s", (String)"LogUtils_150", (String)APPNUMBER, (Object[])new Object[]{sdf.format(ecoRouteEntry.getDate("acttime"))});
    }

    public static void genLogs195(StringBuilder sf, DynamicObject filterObj, Map<String, Object> techDataMap, DynamicObject ecoRouteEntry) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc218(techDataMap, filterObj)).append(SPLITCHAR);
        sf.append(LogUtils.getRouteDesc217(ecoRouteEntry)).append(SPLITCHAR);
    }

    private static String getDesc218(Map<String, Object> techDataMap, DynamicObject filterObj) {
        return String.format(ResManager.loadKDString((String)"%1$s\u5728\u4f9d\u636e\u5339\u914d\u7ef4\u5ea6\uff1a%2$s %3$s \u8fdb\u884c\u53cc\u8fb9\u5339\u914d\u65f6\u65e0\u6cd5\u6ee1\u8db3\u5339\u914d\u6761\u4ef6\uff0c\u81ea\u52a8\u8fc7\u6ee4\u6389\u3002", (String)"LogUtils_149", (String)APPNUMBER, (Object[])new Object[0]), LogUtils.getTechDatas(techDataMap), filterObj.getString("number"), filterObj.getString("name"));
    }

    private static String getRouteDesc217(DynamicObject ecoRouteEntry) {
        return String.format(ResManager.loadKDString((String)"\u5176\u4e2d%1$s\uff0c\u884c\u6807\u8bc6\u4e3a\u3010%2$s\u3011", (String)"LogUtils_148", (String)APPNUMBER, (Object[])new Object[0]), LogUtils.getEcoRouteEntryStr(ecoRouteEntry), LogUtils.getEntryMode(ecoRouteEntry.getString("entrymode")));
    }

    private static String getBomDesc217(DynamicObject ecoBomEntry) {
        return String.format(ResManager.loadKDString((String)"\u5176\u4e2d%1$s\uff0c\u884c\u6807\u8bc6\u4e3a\u3010%2$s\u3011", (String)"LogUtils_148", (String)APPNUMBER, (Object[])new Object[0]), LogUtils.getEcoBomEntryStr(ecoBomEntry), LogUtils.getEntryMode(ecoBomEntry.getString("entrymode")));
    }

    public static void genLogs196(StringBuilder sf, DynamicObject filterObj, Map<String, Object> techData, DynamicObject ecoRouteEntry) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc216(filterObj, techData)).append(SPLITCHAR);
    }

    public static void genLogs197(StringBuilder sf, DynamicObject filterObj, Map<String, Object> techData, DynamicObject ecoRouteEntry) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc217(filterObj, techData)).append(SPLITCHAR);
    }

    private static String getDesc216(DynamicObject filterObj, Map<String, Object> techData) {
        return String.format(ResManager.loadKDString((String)"%1$s\u5728\u4f9d\u636e\u5339\u914d\u7ef4\u5ea6\uff1a%2$s %3$s\u8fdb\u884c\u5339\u914d\u65f6\uff0c\u7531\u4e8e\u5de5\u5e8f\u5206\u5f55\u72b6\u6001\u5df2\u4e0b\u8fbe\uff0c\u4e14\u672c\u6b21\u4e3a\u6b63\u5411\u5220\u9664\u6216\u53cd\u5411\u65b0\u589e\uff0c\u81ea\u52a8\u8fc7\u6ee4\u6389\u3002", (String)"LogUtils_146", (String)APPNUMBER, (Object[])new Object[0]), LogUtils.getTechDatas(techData), filterObj.getString("number"), filterObj.getString("name"));
    }

    private static String getDesc217(DynamicObject filterObj, Map<String, Object> techData) {
        return String.format(ResManager.loadKDString((String)"%1$s\u5728\u4f9d\u636e\u5339\u914d\u7ef4\u5ea6\uff1a%2$s %3$s\u8fdb\u884c\u5339\u914d\u65f6\uff0c\u672c\u6b21\u4e3a\u5931\u6548\u7684\u53cd\u5411\u64cd\u4f5c\uff0c\u4f46\u5728\u5de5\u5e8f\u8ba1\u5212\u53d8\u66f4\u5355\u4e2d\u65e0\u5bf9\u5e94\u7684\u5220\u9664\u884c\u7684\u53d8\u66f4\uff0c\u81ea\u52a8\u8fc7\u6ee4\u6389\u3002", (String)"LogUtils_204", (String)APPNUMBER, (Object[])new Object[0]), LogUtils.getTechDatas(techData), filterObj.getString("number"), filterObj.getString("name"));
    }

    public static void genLogs198(StringBuilder sf, DynamicObject filterObj, Map<String, Object> techDataMap, DynamicObject ecoRouteEntry) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc215(techDataMap)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc214(ecoRouteEntry)).append(SPLITCHAR);
    }

    private static String getDesc215(Map<String, Object> techDataMap) {
        return String.format(ResManager.loadKDString((String)"%1$s\u7684RouteId( %2$s )\u4e0e\u53d8\u66f4\u5355\u7684\u5de5\u827a\u8def\u7ebf\u7684ID\u4e0d\u4e00\u81f4\uff0c\u81ea\u52a8\u8fc7\u6ee4\u6389\u3002", (String)"LogUtils_181", (String)APPNUMBER, (Object[])new Object[0]), LogUtils.getTechDatas(techDataMap), techDataMap.get("processroute"));
    }

    private static String getDesc214(DynamicObject ecoRouteEntry) {
        return String.format(ResManager.loadKDString((String)"\u5176\u4e2d%1$s\uff0c\u884c\u6807\u8bc6\u4e3a\u3010%2$s\u3011", (String)"LogUtils_148", (String)APPNUMBER, (Object[])new Object[0]), LogUtils.getEcoRouteEntryStr(ecoRouteEntry), LogUtils.getEntryMode(ecoRouteEntry.getString("entrymode")));
    }

    public static void genLogs104(StringBuilder sf, Map<String, Object> techDataMap, DynamicObject routeEntry, boolean isExistsData) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc213(routeEntry)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc212(routeEntry)).append(SPLITCHAR);
        sf.append(LogUtils.getDesc211(techDataMap)).append(SPLITCHAR);
        if (isExistsData) {
            sf.append(LogUtils.getDesc210()).append(SPLITCHAR);
        }
    }

    private static String getDesc213(DynamicObject routeEntry) {
        return ResManager.loadKDString((String)"\u5bf9\u5de5\u827a\u8def\u7ebf\u5206\u5f55\u6267\u884c\u65b0\u589e\u64cd\u4f5c:\u5206\u5f55ID\uff1a%s", (String)"LogUtils_183", (String)APPNUMBER, (Object[])new Object[]{routeEntry.getLong("entryid")});
    }

    private static String getDesc212(DynamicObject routeEntry) {
        return String.format(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u5206\u5f55\u5de5\u5e8f\u53f7\uff1a%1$s ,\u5de5\u5e8f\u8bf4\u660e\uff1a%2$s", (String)"LogUtils_184", (String)APPNUMBER, (Object[])new Object[0]), routeEntry.get("operationno"), routeEntry.get("operationdesc"));
    }

    private static String getDesc211(Map<String, Object> techDataMap) {
        return ResManager.loadKDString((String)"\u672c\u6b21\u6267\u884c\u53c2\u8003\u7684\u5de5\u5e8f\u8ba1\u5212\u4fe1\u606f:%s", (String)"LogUtils_186", (String)APPNUMBER, (Object[])new Object[]{LogUtils.getTechDatas(techDataMap)});
    }

    private static String getDesc210() {
        return ResManager.loadKDString((String)"\u8be5\u5de5\u827a\u8def\u7ebf\u7684\u5de5\u5e8f\u5206\u5f55\u5df2\u5b58\u5728\u4e8e\u5de5\u5e8f\u8ba1\u5212\u4e2d,\u672c\u6b21\u4e0d\u6267\u884c\u65b0\u589e\u64cd\u4f5c!", (String)"LogUtils_187", (String)APPNUMBER, (Object[])new Object[0]);
    }

    public static void genLogs105(StringBuilder sf, DynamicObject routeEntry, String xBillNo) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(LogUtils.getDesc209(sdf, startTime, routeEntry, xBillNo));
        sf.append(SPLITCHAR);
    }

    private static String getDesc209(SimpleDateFormat sdf, long startTime, DynamicObject routeEntry, String xBillNo) {
        return String.format(ResManager.loadKDString((String)"%1$s \u5de5\u5e8f\u5206\u5f55\uff1a%2$s \u5df2\u5b58\u5728\u5de5\u5e8f\u8ba1\u5212\u53d8\u66f4\u5355 %3$s \u6570\u636e\uff0c\u672c\u6b21\u65b0\u589e\u4e0d\u6267\u884c\u3002", (String)"LogUtils_188", (String)APPNUMBER, (Object[])new Object[0]), sdf.format(new Date(startTime)), LogUtils.getRouteEntryStr(routeEntry), xBillNo);
    }

    public static String getRouteEntryStr(DynamicObject routeEntry) {
        StringBuilder sb = new StringBuilder();
        Long routeid = routeEntry.getLong("routeid");
        sb.append(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u7f16\u7801:", (String)"LogUtils_190", (String)APPNUMBER, (Object[])new Object[0]));
        sb.append(LogUtils.getRouteNumberById(routeid)).append(" ");
        sb.append(LogUtils.getDesc207(routeEntry));
        sb.append(LogUtils.getDesc208(routeEntry));
        return sb.toString();
    }

    private static String getDesc207(DynamicObject routeEntry) {
        return ResManager.loadKDString((String)" \u5de5\u5e8f\u53f7:%s", (String)"LogUtils_191", (String)APPNUMBER, (Object[])new Object[]{routeEntry.get("operationno")});
    }

    private static String getDesc208(DynamicObject routeEntry) {
        return ResManager.loadKDString((String)" \u5de5\u5e8f\u8bf4\u660e:%s", (String)"LogUtils_192", (String)APPNUMBER, (Object[])new Object[]{routeEntry.get("operationdesc")});
    }

    public static void genLogs111(StringBuilder sf, Date planStartTime, DynamicObject routeEntry) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc206(sdf, planStartTime)).append(SPLITCHAR);
        Date validDate = routeEntry.getDate("entryvaliddate");
        Date inValidDate = routeEntry.getDate("entryinvaliddate");
        sf.append(LogUtils.getDesc205(sdf, validDate, inValidDate, routeEntry)).append(SPLITCHAR);
    }

    private static String getDesc206(SimpleDateFormat sdf, Date planStartTime) {
        return ResManager.loadKDString((String)"\u83b7\u53d6\u672c\u6b21\u65b0\u589e\u53d8\u66f4\u7684\u8ba1\u5212\u5f00\u5de5\u65f6\u95f4\u4e3a\uff1a%s", (String)"LogUtils_193", (String)APPNUMBER, (Object[])new Object[]{sdf.format(planStartTime)});
    }

    private static String getDesc205(SimpleDateFormat sdf, Date validDate, Date inValidDate, DynamicObject routeEntry) {
        return String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u5728\u5de5\u827a\u8def\u7ebf\u5de5\u5e8f\u5206\u5f55\u7684\u751f\u6548\u65f6\u95f4 %1$s ~ %2$s \u5916,\u6545\u4e0d\u6267\u884c\u672c\u6b21\u65b0\u589e\u64cd\u4f5c\u3002%3$s", (String)"LogUtils_194", (String)APPNUMBER, (Object[])new Object[0]), sdf.format(validDate), sdf.format(inValidDate), LogUtils.getRouteEntryStr(routeEntry));
    }

    public static String getRouteResltDatas(Map<String, Object> dataMap) {
        StringBuilder sb = new StringBuilder();
        sb.append(LogUtils.getDesc87(dataMap.get("ecochangebillnosfc"))).append(SPLITCHAR);
        sb.append(LogUtils.getDesc88(LogUtils.getRouteChangeTypeName(dataMap.get("changetypesfc").toString()))).append(SPLITCHAR);
        sb.append(LogUtils.getDesc170(dataMap.get("technosfc"))).append(SPLITCHAR);
        sb.append(LogUtils.getDesc195(dataMap.get("afteroprparentsfc"))).append(SPLITCHAR);
        sb.append(LogUtils.getDesc172(dataMap.get("afteroprnosfc"))).append(SPLITCHAR);
        sb.append(LogUtils.getDesc173(dataMap.get("afteropdescsfc"))).append(SPLITCHAR);
        return sb.toString();
    }

    private static String getDesc87(Object params) {
        return String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u53f7\uff1a%1$s", (String)"LogUtils_87", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc88(Object params) {
        return String.format(ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b\uff1a%1$s", (String)"LogUtils_88", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc170(Object params) {
        return String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8ba1\u5212\u5355\u53f7\uff1a%1$s", (String)"LogUtils_170", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc195(Object params) {
        return String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u5e8f\u5217\uff1a%1$s", (String)"LogUtils_195", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc172(Object params) {
        return String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u53f7\uff1a%1$s", (String)"LogUtils_172", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc173(Object params) {
        return String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u8bf4\u660e\uff1a%1$s", (String)"LogUtils_173", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    public static void genLogs109(StringBuilder sf, List<Map<String, Object>> gridList) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(SPLITCHAR);
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc91(gridList.size())).append(SPLITCHAR);
        for (int i = 0; i < gridList.size(); ++i) {
            Map<String, Object> dataMap = gridList.get(i);
            sf.append(LogUtils.getDesc204(i, LogUtils.getRouteResltDatas(dataMap)));
            sf.append(SPLITCHAR);
        }
    }

    private static String getDesc91(Object params) {
        return String.format(ResManager.loadKDString((String)"\u672c\u6b21\u65b0\u589e\u53d8\u66f4\u540e\u4ea7\u751f\uff1a%1$s\u6761\u6570\u636e\u3002", (String)"LogUtils_91", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    public static void genLogs131(StringBuilder sf, Map<String, Object> techDataMap, DynamicObject routeEntry, int isDisabledValue, Map<String, String> xTechMap) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc196(routeEntry.getLong("entryid"))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc197(LogUtils.getRouteEntryStr(routeEntry))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc198(LogUtils.getTechDatas(techDataMap))).append(SPLITCHAR);
        if (isDisabledValue != 0) {
            if (isDisabledValue == 1) {
                sf.append(ResManager.loadKDString((String)"\u8be5\u5de5\u5e8f\u8ba1\u5212\u5de5\u5e8f\u5df2\u7ecf\u5904\u4e8e\u4f5c\u5e9f\u72b6\u6001\uff0c\u672c\u6b21\u4e0d\u6267\u884c\u5931\u6548\u64cd\u4f5c\u3002", (String)"LogUtils_199", (String)APPNUMBER, (Object[])new Object[0])).append(SPLITCHAR);
            } else if (isDisabledValue == 2) {
                String techEntryId = String.valueOf(techDataMap.get("oprentryentity"));
                String orderType = String.valueOf(techDataMap.get("ordertype"));
                String xTechString = LogUtils.genXTechKeyString("B", techEntryId, orderType, "");
                String xChangeBillNo = xTechMap.get(xTechString);
                sf.append(LogUtils.getDesc200(xChangeBillNo)).append(SPLITCHAR);
            }
        }
    }

    private static String getDesc200(Object params) {
        return String.format(ResManager.loadKDString((String)"\u8be5\u5de5\u5e8f\u8ba1\u5212\u7684\u5de5\u5e8f\u5df2\u7ecf\u5931\u6548\uff08\u539f\u56e0\uff1a\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5de5\u5e8f\u8ba1\u5212\u53d8\u66f4\u5355\uff1a%1$s\uff0c\u672c\u6b21\u4e0d\u6267\u884c\u5931\u6548\u64cd\u4f5c\uff09\u3002", (String)"LogUtils_200", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc196(Object params) {
        return String.format(ResManager.loadKDString((String)"\u5bf9\u5de5\u827a\u8def\u7ebf\u5206\u5f55\u6267\u884c\u5931\u6548\u64cd\u4f5c\uff1a\u5206\u5f55ID\uff1a%1$s", (String)"LogUtils_196", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc198(Object params) {
        return String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5f85\u5931\u6548\u7684\u5de5\u5e8f\u8ba1\u5212\u4fe1\u606f\uff1a%1$s", (String)"LogUtils_198", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    public static void genLogs135(StringBuilder sf, List<Map<String, Object>> gridList) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(SPLITCHAR);
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc112(gridList.size())).append(SPLITCHAR);
        for (int i = 0; i < gridList.size(); ++i) {
            Map<String, Object> dataMap = gridList.get(i);
            sf.append(LogUtils.getDesc204(i, LogUtils.getRouteResltDatas(dataMap))).append(SPLITCHAR);
        }
    }

    private static String getDesc112(Object params) {
        return String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5931\u6548\u53d8\u66f4\u540e\u4ea7\u751f\uff1a%1$s\u6761\u6570\u636e\u3002", (String)"LogUtils_112", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    public static void genLogs152(StringBuilder sf, List<Map<String, Object>> gridList) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(SPLITCHAR);
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc117(gridList.size())).append(SPLITCHAR);
        for (int i = 0; i < gridList.size(); ++i) {
            Map<String, Object> dataMap = gridList.get(i);
            sf.append(LogUtils.getDesc204(i, LogUtils.getRouteResltDatas(dataMap))).append(SPLITCHAR);
        }
    }

    private static String getDesc204(int i, String dataMap) {
        return String.format(ResManager.loadKDString((String)"\u5e8f\u53f7\uff1a%1$s %2$s", (String)"LogUtils_45", (String)APPNUMBER, (Object[])new Object[0]), i + 1, dataMap);
    }

    private static String getDesc117(Object params) {
        return String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4fee\u6539\u53d8\u66f4\u540e\u4ea7\u751f\uff1a%1$s\u6761\u6570\u636e\u3002", (String)"LogUtils_117", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    public static void genLogs136(StringBuilder sf, Map<String, Object> techDataMap, DynamicObject routeEntry, Map<String, String> xTechMap) {
        long startTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sf.append(sdf.format(new Date(startTime))).append(" ");
        sf.append(LogUtils.getDesc201(routeEntry.getLong("entryid"))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc197(LogUtils.getRouteEntryStr(routeEntry))).append(SPLITCHAR);
        sf.append(LogUtils.getDesc202(LogUtils.getTechDatas(techDataMap))).append(SPLITCHAR);
        String techEntryId = String.valueOf(techDataMap.get("oprentryentity"));
        String orderType = String.valueOf(techDataMap.get("ordertype"));
        String xTechString = LogUtils.genXTechKeyString("B", techEntryId, orderType, "");
        String xChangeBillNo = xTechMap.get(xTechString);
        sf.append(LogUtils.getDesc203(xChangeBillNo)).append(SPLITCHAR);
    }

    private static String getDesc201(Object params) {
        return String.format(ResManager.loadKDString((String)"\u5bf9\u5de5\u827a\u8def\u7ebf\u5206\u5f55\u6267\u884c\u4fee\u6539\u64cd\u4f5c\uff1a\u5206\u5f55ID\uff1a%1$s", (String)"LogUtils_201", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc197(Object params) {
        return String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u4fe1\u606f\uff1a%1$s", (String)"LogUtils_197", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc202(Object params) {
        return String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5f85\u4fee\u6539\u7684\u5de5\u5e8f\u8ba1\u5212\u4fe1\u606f\uff1a%1$s", (String)"LogUtils_202", (String)APPNUMBER, (Object[])new Object[0]), params);
    }

    private static String getDesc203(Object params) {
        return String.format(ResManager.loadKDString((String)"\u8be5\u5de5\u5e8f\u8ba1\u5212\u7684\u5de5\u5e8f\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5de5\u5e8f\u8ba1\u5212\u53d8\u66f4\u5355\uff1a%1$s\uff0c\u672c\u6b21\u4e0d\u6267\u884c\u4fee\u6539\u64cd\u4f5c\u3002", (String)"LogUtils_203", (String)APPNUMBER, (Object[])new Object[0]), params);
    }
}

