/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.ecoplatform.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.ecoplatform.service.IECNUpdateService;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;

public class AbstractECNUpdateService
implements IECNUpdateService {
    private static final Log log = LogFactory.getLog(AbstractECNUpdateService.class);

    @Override
    public String execUpdate(DynamicObject ecnBill) {
        return null;
    }

    public OperateOption getOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ignorewarn", String.valueOf(true));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        operateOption.setVariableValue("strictvalidation", String.valueOf(true));
        operateOption.setVariableValue("needlog", String.valueOf(true));
        return operateOption;
    }

    public String getDefaultCt(String entityNumber, String orgId) {
        String ctrlStrategy = BaseDataServiceHelper.getBdCtrlStrgy((String)entityNumber, (String)orgId);
        if (StringUtils.isEmpty((String)ctrlStrategy)) {
            DynamicObject defCtrlStrDO = BaseDataServiceHelper.getDefaultCtrlStrtgy((String)entityNumber);
            ctrlStrategy = defCtrlStrDO == null ? "5" : DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)defCtrlStrDO, (String)"defaultctrlstrategy");
        }
        return ctrlStrategy;
    }

    public Map<Long, DynamicObject> queryDynamicObjectMap(Set<Long> idSet, String entityNumber) {
        DynamicObject[] ecoRoutes;
        HashMap<Long, DynamicObject> maps = new HashMap<Long, DynamicObject>(16);
        if (PlatformUtils.isNullSet(idSet)) {
            return maps;
        }
        DynamicObject ecoRoute = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
        for (DynamicObject dy : ecoRoutes = BusinessDataServiceHelper.load((Object[])idSet.toArray(), (DynamicObjectType)ecoRoute.getDynamicObjectType())) {
            maps.put(dy.getLong("id"), dy);
        }
        return maps;
    }

    public boolean isAddMode(DynamicObject ecoEntry, String entryModeField) {
        return "A".equals(ecoEntry.getString(entryModeField));
    }

    public boolean isDisableMode(DynamicObject ecoEntry, String entryModeField) {
        return "E".equals(ecoEntry.getString(entryModeField));
    }

    public boolean isChangeAfterMode(DynamicObject ecoEntry, String entryModeField) {
        return "C".equals(ecoEntry.getString(entryModeField));
    }

    public DynamicObject getEntryById(DynamicObjectCollection entryColl, Long oldEntryId) {
        for (DynamicObject entry : entryColl) {
            Long entryId = (Long)entry.getPkValue();
            if (!entryId.equals(oldEntryId)) continue;
            return entry;
        }
        return null;
    }

    public DynamicObject findFromList(List<DynamicObject> addList, Long pkId) {
        for (DynamicObject rt : addList) {
            if (!pkId.equals(rt.getLong("id"))) continue;
            return rt;
        }
        return null;
    }

    public void saveEcoDynamicObject(Map<Long, DynamicObject> ecoDynamicObjectMap) {
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(16);
        for (Map.Entry<Long, DynamicObject> entrys : ecoDynamicObjectMap.entrySet()) {
            updateList.add(entrys.getValue());
        }
        if (!PlatformUtils.isNullList(updateList)) {
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
        }
    }

    public void setPrimaryKey(DynamicObject bill) {
        IDataEntityType type = bill.getDataEntityType();
        DBRoute rt = new DBRoute(type.getDBRouteKey());
        SequenceReader seqReader = new SequenceReader(rt);
        seqReader.autoSetPrimaryKey(new Object[]{bill}, type);
    }

    public void reSetNewEntryIdByRef(DynamicObject ecoBom, Map<String, Long> oldCacheMap, DynamicObject newBill) {
        if ("pdm_mftbom".equals(newBill.getDataEntityType().getName())) {
            this.setNewEntryIdRefByEntry(ecoBom, oldCacheMap, newBill, "entry");
            this.setNewEntryIdRefByEntry(ecoBom, oldCacheMap, newBill, "copentry");
        } else {
            this.setNewEntryIdRefByEntry(ecoBom, oldCacheMap, newBill, "processentry");
        }
    }

    private void setNewEntryIdRefByEntry(DynamicObject ecoBom, Map<String, Long> oldCacheMap, DynamicObject newBill, String entityEntry) {
        HashMap<Long, Long> oldAndNewMap = new HashMap<Long, Long>(64);
        DynamicObjectCollection coll = newBill.getDynamicObjectCollection(entityEntry);
        for (int i = 0; i < coll.size(); ++i) {
            String keys = entityEntry + (i + 1);
            Long newEntryId = (Long)((DynamicObject)coll.get(i)).getPkValue();
            Long oldEntryId = oldCacheMap.get(keys);
            if (oldEntryId == null || oldEntryId.equals(0L)) continue;
            oldAndNewMap.put(oldEntryId, newEntryId);
        }
        DynamicObjectCollection ecoColl = ecoBom.getDynamicObjectCollection(entityEntry);
        String field = this.getNewEntryIdFieldByEntity(ecoBom, entityEntry);
        for (int i = 0; i < ecoColl.size(); ++i) {
            DynamicObject ecoEntry = (DynamicObject)ecoColl.get(i);
            Long oldEntryId = ecoEntry.getLong(field);
            Long newEntryId = (Long)oldAndNewMap.get(oldEntryId);
            if (newEntryId == null || newEntryId.equals(0L)) continue;
            ecoEntry.set(field, (Object)newEntryId);
        }
    }

    private String getNewEntryIdFieldByEntity(DynamicObject ecoBom, String entityEntry) {
        if ("pdm_ecobom".equals(ecoBom.getDataEntityType().getName())) {
            if ("entry".equals(entityEntry)) {
                return "bomentry";
            }
            if ("copentry".equals(entityEntry)) {
                return "newcopentryid";
            }
        } else if ("processentry".equals(entityEntry)) {
            return "newprocessentryid";
        }
        return "";
    }

    public Map<String, Long> cacheOldEntryIdMap(DynamicObject bill) {
        HashMap<String, Long> cacheMap = new HashMap<String, Long>(64);
        if ("pdm_mftbom".equals(bill.getDataEntityType().getName())) {
            this.cacheOldEntryIdMap(bill, "entry", cacheMap);
            this.cacheOldEntryIdMap(bill, "copentry", cacheMap);
        } else {
            this.cacheOldEntryIdMap(bill, "processentry", cacheMap);
        }
        return cacheMap;
    }

    public void cacheOldEntryIdMap(DynamicObject bill, String entityEntry, Map<String, Long> cacheMap) {
        DynamicObjectCollection coll = bill.getDynamicObjectCollection(entityEntry);
        for (int i = 0; i < coll.size(); ++i) {
            String keys = entityEntry + (i + 1);
            cacheMap.put(keys, (Long)((DynamicObject)coll.get(i)).getPkValue());
        }
    }

    public String getNewNumber(String[] newNumbers, int seq, Long newid, String beforeChart) {
        int size = newNumbers == null ? 0 : newNumbers.length;
        String number = "";
        if (newNumbers != null && seq + 1 <= size) {
            number = newNumbers[seq];
        }
        if (StringUtils.isEmpty((String)number)) {
            number = beforeChart + String.valueOf(newid);
        }
        return number;
    }

    public void submitAndAuditData(List<DynamicObject> addList, String entityNumber, String ecnBillNo) {
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)"submit", (String)entityNumber, (DynamicObject[])addList.toArray(new DynamicObject[addList.size()]), (OperateOption)this.getOperateOption());
        String errorMsg = PlatformUtils.getErrorMsg((OperationResult)operationResult);
        List submitSuccessPkList = operationResult.getSuccessPkIds();
        if (!StringUtils.isEmpty((String)errorMsg)) {
            if (!PlatformUtils.isNullList((List)submitSuccessPkList)) {
                try (TXHandle h = TX.requiresNew();){
                    DeleteServiceHelper.delete((String)entityNumber, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)submitSuccessPkList)});
                }
            }
            throw new KDBizException(new ErrorCode("submitAndAuditData", this.genMsg(ecnBillNo, errorMsg)), new Object[0]);
        }
        if (submitSuccessPkList != null && !submitSuccessPkList.isEmpty() && !StringUtils.isEmpty((String)(errorMsg = PlatformUtils.getErrorMsg((OperationResult)(operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)entityNumber, (Object[])submitSuccessPkList.toArray(), (OperateOption)this.getOperateOption())))))) {
            try (TXHandle h = TX.requiresNew();){
                DeleteServiceHelper.delete((String)entityNumber, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)submitSuccessPkList)});
            }
            throw new KDBizException(new ErrorCode("submitAndAuditData", this.genMsg(ecnBillNo, errorMsg)), new Object[0]);
        }
    }

    public String genMsg(String ecnBillNo, String msg) {
        return String.format(ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5355[%1$s]:%2$s", (String)"AbstractECNUpdateService_1", (String)"mmc-pdm-business", (Object[])new Object[0]), ecnBillNo, msg);
    }
}

