/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.formula;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kd.mmc.pdm.business.formula.ExprContext;
import kd.mmc.pdm.business.formula.FormulaParseBusiness;
import kd.mmc.pdm.business.formula.IToken;
import kd.mmc.pdm.business.formula.ParseException;
import kd.mmc.pdm.business.formula.enums.OperatorType;
import kd.mmc.pdm.business.formula.enums.TokenType;
import kd.mmc.pdm.business.formula.node.MethodTokenNode;
import kd.mmc.pdm.business.formula.node.TableTokenNode;
import kd.mmc.pdm.business.formula.node.TokenNode;
import kd.mmc.pdm.business.formula.token.AttributeFetchToken;
import kd.mmc.pdm.business.formula.token.CalculatorToken;
import kd.mmc.pdm.business.formula.token.ConstToken;
import kd.mmc.pdm.business.formula.token.FieldToken;
import kd.mmc.pdm.business.formula.token.OperatorToken;
import kd.mmc.pdm.business.formula.token.ParamToken;
import kd.mmc.pdm.business.formula.token.PlaceHoldToken;

public class ConfigRuleExpr {
    private FormulaParseBusiness parsebusiness;
    private String[] formulaArray;
    private String ruleType;

    public ConfigRuleExpr(String exprStr, String ruleType) throws ParseException {
        if (exprStr == null) {
            return;
        }
        exprStr = exprStr.replaceAll("\n", "");
        this.formulaArray = exprStr.split(";");
        this.ruleType = ruleType;
    }

    public Object execute(ExprContext ctx) throws ParseException {
        Map<String, Object> resultObj = null;
        if (this.formulaArray == null) {
            return null;
        }
        int length = this.formulaArray.length;
        for (int i = 0; i < length; ++i) {
            TokenType tokenType;
            String formula = this.formulaArray[i];
            if (formula == null || "".equals(formula) || "\n".equals(formula)) continue;
            this.parsebusiness = new FormulaParseBusiness(formula, this.ruleType);
            TokenNode rootNode = this.parseTokens(this.parsebusiness.parse());
            rootNode.action(ctx);
            this.isIFRequire(rootNode, ctx);
            if (length <= 1 || i == length - 1 || !"3".equals(this.ruleType)) continue;
            Object retObj = ctx.getStack().pop();
            if (rootNode.isBracketNode()) {
                rootNode = rootNode.getLeft();
            }
            if (TokenType.IF != (tokenType = rootNode.getFirst().getType())) {
                Map<String, Object> params = this.addParams(retObj);
                ctx.addPreDefinedParam("params", params);
                continue;
            }
            JSONObject retJson = JSONObject.parseObject((String)retObj.toString());
            String val = retJson.getString("value");
            if (TokenType.IF != tokenType || val == null || "".equals(val)) continue;
            int index = this.getNotIfFormula(i);
            if (index == -1) {
                ctx.getStack().push(retObj);
                break;
            }
            i = index - 1;
            Map<String, Object> params = this.addParams(retObj);
            ctx.addPreDefinedParam("params", params);
        }
        resultObj = "3".equals(this.ruleType) ? this.addParams(ctx.getStack().pop()) : ctx.getStack().pop();
        return resultObj;
    }

    private void isIFRequire(TokenNode rootNode, ExprContext ctx) {
        TokenType tokenType;
        if (!"3".equals(this.ruleType)) {
            return;
        }
        if (rootNode.isBracketNode()) {
            rootNode = rootNode.getLeft();
        }
        if (TokenType.IF == (tokenType = rootNode.getFirst().getType())) {
            Object retObj = ctx.getStack().pop();
            Map params = (Map)ctx.getPreDefinedParam("params");
            Map<String, Object> result = this.addParams(retObj);
            Set<Map.Entry<String, Object>> entrySet = result.entrySet();
            boolean flag = false;
            for (Map.Entry<String, Object> entry : entrySet) {
                Object val = entry.getValue();
                if (val == null || "".equals(val)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                JSONObject paramObj = this.mapToJSONObj(params);
                ctx.getStack().push(paramObj);
            } else {
                ctx.getStack().push(retObj);
            }
        }
    }

    private JSONObject mapToJSONObj(Map<String, Object> params) {
        JSONObject retObj = new JSONObject();
        if (params == null || params.isEmpty()) {
            return retObj;
        }
        Set<Map.Entry<String, Object>> entrySet = params.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            retObj.put(entry.getKey(), entry.getValue());
        }
        return retObj;
    }

    private int getNotIfFormula(int index) throws ParseException {
        int retVal = -1;
        for (int i = index + 1; i < this.formulaArray.length; ++i) {
            TokenType tokenType;
            String formula = this.formulaArray[i];
            if (formula == null || "".equals(formula) || "\n".equals(formula)) continue;
            this.parsebusiness = new FormulaParseBusiness(formula, this.ruleType);
            TokenNode rootNode = this.parseTokens(this.parsebusiness.parse());
            if (rootNode.isBracketNode()) {
                rootNode = rootNode.getLeft();
            }
            if (TokenType.IF == (tokenType = rootNode.getFirst().getType())) continue;
            retVal = i;
            break;
        }
        return retVal;
    }

    private Map<String, Object> addParams(Object retObj) {
        HashMap<String, Object> requireData = new HashMap<String, Object>(64);
        if (retObj == null) {
            return requireData;
        }
        JSONObject params = JSONObject.parseObject((String)retObj.toString());
        if (params.containsKey((Object)"field") && params.containsKey((Object)"value")) {
            requireData.put(params.getString("field"), params.get((Object)"value"));
        } else {
            Set entrySet = params.entrySet();
            for (Map.Entry entry : entrySet) {
                requireData.put((String)entry.getKey(), entry.getValue());
            }
        }
        return requireData;
    }

    private TokenNode parseTokens(List<IToken> tokens) throws ParseException {
        Stack<TokenNode> bracketStack = new Stack<TokenNode>();
        Stack<TokenNode> middleBracketStack = new Stack<TokenNode>();
        TokenNode operatorNode = null;
        TokenNode operandNode = null;
        TokenNode connectNode = null;
        TokenNode returnNode = null;
        TokenNode ifNode = null;
        TokenNode calculatorNode = null;
        MethodTokenNode methodNode = null;
        TableTokenNode tableNode = null;
        ArrayList<IToken> returnSubTokens = new ArrayList<IToken>(0);
        block17: for (IToken token : tokens) {
            TokenNode node = new TokenNode(token);
            if (returnNode != null) {
                if (token.getType() != TokenType.SEMICOLON) {
                    returnSubTokens.add(token);
                    continue;
                }
                TokenNode ret = this.parseTokens(returnSubTokens);
                if (returnSubTokens.size() > 1) {
                    ret.addFirst((IToken)returnSubTokens.get(0));
                    ret.addOperand((IToken)returnSubTokens.get(returnSubTokens.size() - 1));
                }
                ret.addOperand(new ConstToken(";", TokenType.SEMICOLON));
                returnNode.setRight(ret);
                returnNode = null;
                returnSubTokens = new ArrayList(0);
                continue;
            }
            if (!middleBracketStack.isEmpty() && token.getType() != TokenType.RIGHTMIDDLEBRACKET) {
                middleBracketStack.push(node);
                continue;
            }
            switch (token.getType()) {
                case LEFTBRACKET: {
                    bracketStack.push(node);
                    break;
                }
                case RIGHTBRACKET: {
                    TokenNode t;
                    TokenNode top = (TokenNode)bracketStack.pop();
                    ArrayList<IToken> subTokens = new ArrayList();
                    ArrayList<TokenNode> childTokenNodeList = new ArrayList<TokenNode>(64);
                    if (top.isSingleTokenNode()) {
                        subTokens.add(0, top.getFirst());
                    } else {
                        subTokens.add(0, new PlaceHoldToken(top));
                    }
                    while (true) {
                        if ((top = (TokenNode)bracketStack.pop()).isBracketNode()) {
                            subTokens.add(0, new PlaceHoldToken(top));
                            continue;
                        }
                        if (top.getFirst().getType() == TokenType.COMMA) {
                            childTokenNodeList.add(this.parseTokens(subTokens));
                            subTokens = new ArrayList();
                            continue;
                        }
                        if (top.getFirst().getType() == TokenType.LEFTBRACKET) break;
                        if (top.isSingleTokenNode()) {
                            subTokens.add(0, top.getFirst());
                            continue;
                        }
                        subTokens.add(0, new PlaceHoldToken(top));
                    }
                    if (top.getFirst().getType() == TokenType.LEFTBRACKET && !subTokens.isEmpty()) {
                        childTokenNodeList.add(this.parseTokens(subTokens));
                    }
                    if (methodNode != null) {
                        for (int i = childTokenNodeList.size() - 1; i >= 0; --i) {
                            t = (TokenNode)childTokenNodeList.get(i);
                            methodNode.addOperand(t.getFirst());
                            if (i == 0) continue;
                            methodNode.addOperand(new ConstToken(",", TokenType.COMMA));
                        }
                        continue block17;
                    }
                    if (tableNode != null) {
                        for (int i = childTokenNodeList.size() - 1; i >= 0; --i) {
                            t = (TokenNode)childTokenNodeList.get(i);
                            tableNode.addSubNode(t);
                        }
                        continue block17;
                    }
                    node = new TokenNode(this.parseTokens(subTokens));
                    if (!bracketStack.isEmpty()) {
                        bracketStack.push(node);
                        break;
                    }
                    if (calculatorNode != null && !calculatorNode.isFull()) {
                        calculatorNode.setChild(node);
                        break;
                    }
                    if (operatorNode != null && !operatorNode.isFull()) {
                        operatorNode.setChild(node);
                        break;
                    }
                    if (connectNode != null) {
                        connectNode.setRight(node);
                        break;
                    }
                    if (operandNode != null) continue block17;
                    operandNode = node;
                    break;
                }
                case FIELD: 
                case ATTRIBUTEFETCHER: {
                    if (!bracketStack.isEmpty()) {
                        bracketStack.push(node);
                        continue block17;
                    }
                    operandNode = node;
                    if (calculatorNode == null || calculatorNode.isFull()) continue block17;
                    calculatorNode.setChild(operandNode);
                    operandNode = null;
                    if (!calculatorNode.isFull() || operatorNode == null) continue block17;
                    operatorNode.setChild(calculatorNode);
                    calculatorNode = null;
                    break;
                }
                case OPERATOR: {
                    if (!bracketStack.isEmpty()) {
                        bracketStack.push(node);
                        continue block17;
                    }
                    if (operatorNode == null) {
                        operatorNode = node;
                    }
                    if (!operatorNode.isFull()) {
                        if (calculatorNode != null) {
                            operatorNode.setChild(calculatorNode);
                            break;
                        }
                        OperatorType type = ((OperatorToken)operatorNode.getFirst()).getOperatorType();
                        if (type == OperatorType.SETVAL && operandNode != null) {
                            AttributeFetchToken attrToken = (AttributeFetchToken)operandNode.getFirst();
                            ParamToken paramToken = attrToken.getParam();
                            String paramName = paramToken.getParamName();
                            operandNode = new TokenNode(new FieldToken(paramName));
                        }
                        operatorNode.setChild(operandNode);
                        operandNode = null;
                        break;
                    }
                    if (((OperatorToken)node.getFirst()).getOperatorType().ordinal() <= ((OperatorToken)operatorNode.getFirst()).getOperatorType().ordinal()) continue block17;
                    node.setLeft(operatorNode.getRight());
                    operatorNode.setRight(node);
                    operatorNode = node;
                    break;
                }
                case CALCULATOR: {
                    if (!bracketStack.isEmpty()) {
                        bracketStack.push(node);
                        continue block17;
                    }
                    if (calculatorNode == null) {
                        calculatorNode = node;
                    }
                    if (!calculatorNode.isFull()) {
                        if (operatorNode != null && operatorNode.isFull()) {
                            TokenNode rightNode = operatorNode.getRight();
                            calculatorNode.setChild(rightNode);
                            break;
                        }
                        calculatorNode.setChild(operandNode);
                        operandNode = null;
                        break;
                    }
                    if (((CalculatorToken)node.getFirst()).getLevel() == 2) {
                        if (((CalculatorToken)node.getFirst()).getLevel() > ((CalculatorToken)calculatorNode.getFirst()).getLevel()) {
                            TokenNode rightNode = calculatorNode.getRight();
                            node.setLeft(rightNode);
                            calculatorNode.setRight(node);
                            calculatorNode = node;
                            break;
                        }
                        TokenNode parentNode = calculatorNode.getRoot();
                        if (((CalculatorToken)node.getFirst()).getLevel() > ((CalculatorToken)parentNode.getFirst()).getLevel()) {
                            TokenNode rightNode = parentNode.getRight();
                            node.setLeft(rightNode);
                            parentNode.setRight(node);
                            calculatorNode = node;
                            break;
                        }
                        node.setChild(calculatorNode);
                        calculatorNode = node;
                        break;
                    }
                    if (((CalculatorToken)node.getFirst()).getLevel() != 1) continue block17;
                    TokenNode parentNode = calculatorNode.getRoot();
                    if (parentNode != null && parentNode.equals(calculatorNode)) {
                        node.setChild(calculatorNode);
                    } else {
                        node.setChild(parentNode);
                    }
                    calculatorNode = node;
                    break;
                }
                case LEFTMIDDLEBRACKET: {
                    if (!middleBracketStack.isEmpty()) continue block17;
                    middleBracketStack.push(node);
                    break;
                }
                case RIGHTMIDDLEBRACKET: {
                    TokenNode top;
                    ArrayList<IToken> subTokens = new ArrayList<IToken>();
                    while (true) {
                        if ((top = (TokenNode)middleBracketStack.pop()).isBracketNode()) {
                            subTokens.add(0, new PlaceHoldToken(top));
                            continue;
                        }
                        if (top.getFirst().getType() == TokenType.LEFTMIDDLEBRACKET) break;
                        if (top.isSingleTokenNode()) {
                            subTokens.add(0, top.getFirst());
                            continue;
                        }
                        subTokens.add(0, new PlaceHoldToken(top));
                    }
                    operandNode = this.parseTokens(subTokens);
                    operandNode.setMiddleBracketNode(true);
                    if (middleBracketStack.isEmpty()) continue block17;
                    middleBracketStack.push(operandNode);
                    break;
                }
                case CONNECT: {
                    if (!bracketStack.isEmpty()) {
                        bracketStack.push(node);
                        continue block17;
                    }
                    if (connectNode == null) {
                        connectNode = node;
                    }
                    if (!connectNode.isFull()) {
                        if (operatorNode != null) {
                            if (!operatorNode.isFull() && calculatorNode != null) {
                                operatorNode.setChild(calculatorNode);
                                calculatorNode = null;
                            }
                            connectNode.setChild(operatorNode.getRoot());
                        } else if (operandNode != null) {
                            connectNode.setChild(operandNode.getRoot());
                        }
                    }
                    if (connectNode.isFull()) {
                        node.setLeft(connectNode);
                        connectNode = node;
                    }
                    operatorNode = null;
                    operandNode = null;
                    break;
                }
                case CONST: 
                case NUMBER: {
                    if (!bracketStack.isEmpty()) {
                        bracketStack.push(node);
                        continue block17;
                    }
                    if (operandNode == null) {
                        operandNode = node;
                    } else if (operandNode.getLast().getType() == TokenType.COMMA) {
                        operandNode.addOperand(node.getFirst());
                    } else {
                        operandNode = node;
                    }
                    if (calculatorNode != null && !calculatorNode.isFull()) {
                        calculatorNode.setChild(operandNode);
                        operandNode = null;
                        break;
                    }
                    if (operatorNode == null || operatorNode.isFull()) continue block17;
                    operatorNode.setChild(operandNode);
                    break;
                }
                case COMMA: {
                    if (!bracketStack.isEmpty()) {
                        if (token.getType() == TokenType.COMMA && operandNode != null) {
                            bracketStack.push(operandNode);
                            operandNode = null;
                        }
                        bracketStack.push(node);
                        continue block17;
                    }
                    if (operandNode == null) {
                        operandNode = node;
                        break;
                    }
                    operandNode.addOperand(node.getFirst());
                    break;
                }
                case PLACEHOLD: {
                    PlaceHoldToken tmp = (PlaceHoldToken)node.getFirst();
                    node = tmp.getNode();
                    if (operatorNode != null && !operatorNode.isFull()) {
                        operatorNode.setChild(node);
                        break;
                    }
                    if (connectNode != null && !connectNode.isFull()) {
                        connectNode.setChild(node);
                        break;
                    }
                    if (operandNode == null) {
                        operandNode = node;
                        break;
                    }
                    if (operandNode.getLast().getType() != TokenType.COMMA) continue block17;
                    operandNode.addOperand(tmp);
                    break;
                }
                case IF: {
                    if (!bracketStack.isEmpty()) {
                        bracketStack.push(node);
                        continue block17;
                    }
                    if (ifNode == null) {
                        ifNode = node;
                    }
                    if (!ifNode.isFull()) {
                        if (operatorNode != null) {
                            if (!operatorNode.isFull() && calculatorNode != null) {
                                operatorNode.setChild(calculatorNode);
                                calculatorNode = null;
                            }
                            ifNode.setChild(operatorNode.getRoot());
                            operatorNode = null;
                        } else if (methodNode != null) {
                            ifNode.setChild(methodNode.getRoot());
                            methodNode = null;
                        } else if (tableNode != null) {
                            ifNode.setChild(tableNode.getRoot());
                            tableNode = null;
                        }
                    }
                    if (ifNode.isFull()) {
                        node.setLeft(ifNode);
                        ifNode = node;
                    }
                    operandNode = null;
                    break;
                }
                case METHOD: {
                    methodNode = new MethodTokenNode(token);
                    break;
                }
                case TABLE: {
                    tableNode = new TableTokenNode(token);
                    break;
                }
                case RETURN: {
                    returnNode = node;
                    if (returnSubTokens == null) continue block17;
                    returnSubTokens.clear();
                    break;
                }
                default: {
                    throw new ParseException("unknown token type");
                }
            }
        }
        if (calculatorNode != null && operandNode != null) {
            calculatorNode.setRight(operandNode);
        }
        if (operatorNode != null) {
            if (operandNode != null) {
                operatorNode.setRight(operandNode);
            } else if (calculatorNode != null) {
                operatorNode.setRight(calculatorNode.getRoot());
            }
            this.isFieldOp(operatorNode);
        }
        if (methodNode != null) {
            return methodNode;
        }
        if (tableNode != null) {
            return tableNode;
        }
        if (connectNode != null && operatorNode != null) {
            connectNode.setRight(operatorNode.getRoot());
        }
        if (ifNode != null) {
            if (connectNode != null) {
                ifNode.setRight(connectNode);
            } else if (operatorNode != null) {
                ifNode.setRight(operatorNode);
            }
        }
        return ifNode == null ? (connectNode == null ? (operatorNode == null ? (calculatorNode == null ? operandNode : calculatorNode.getRoot()) : operatorNode.getRoot()) : connectNode.getRoot()) : ifNode.getRoot();
    }

    private void isFieldOp(TokenNode operatorNode) {
        if (operatorNode == null) {
            return;
        }
        TokenNode leftNode = operatorNode.getLeft();
        TokenNode rightNode = operatorNode.getRight();
        if (leftNode == null || leftNode.isBracketNode() || rightNode == null || rightNode.isBracketNode()) {
            return;
        }
        TokenType LeftType = leftNode.getFirst().getType();
        TokenType rightType = rightNode.getFirst().getType();
        if (TokenType.FIELD == LeftType && rightType == TokenType.FIELD) {
            operatorNode.getFirst().setIsFieldOp(true);
        }
    }

    private static void test() throws ParseException {
        ConfigRuleExpr test = new ConfigRuleExpr("1.5*2.523", "2");
        ExprContext ctx = new ExprContext();
        HashMap<String, BigDecimal> requireData = new HashMap<String, BigDecimal>();
        requireData.put("THP", new BigDecimal("2.5"));
        requireData.put("ZTHP_QTY", new BigDecimal("1.5"));
        ctx.addPreDefinedParam("params", requireData);
        test.execute(ctx);
        System.out.println(test);
    }

    public static void main(String[] args) throws ParseException {
        ConfigRuleExpr.test();
    }
}

