/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.formula.token;

import kd.mmc.pdm.business.formula.ExprContext;
import kd.mmc.pdm.business.formula.IToken;
import kd.mmc.pdm.business.formula.enums.ConnectType;
import kd.mmc.pdm.business.formula.enums.TokenType;

public class ConnectToken
implements IToken {
    private ConnectType type;

    public ConnectToken(ConnectType type) {
        this.type = type;
    }

    @Override
    public void action(ExprContext ctx) {
        Object left = ctx.getStack().pop();
        Object right = ctx.getStack().pop();
        if (left instanceof Boolean) {
            switch (this.type) {
                case AND: {
                    ctx.getStack().push((Boolean)left != false && (Boolean)right != false);
                    break;
                }
                case OR: {
                    ctx.getStack().push((Boolean)left != false || (Boolean)right != false);
                    break;
                }
            }
        }
    }

    public ConnectType getConnectType() {
        return this.type;
    }

    @Override
    public TokenType getType() {
        TokenType en = TokenType.CONNECT;
        return en;
    }

    public String toString() {
        switch (this.type) {
            case AND: {
                return " AND ";
            }
            case OR: {
                return " OR ";
            }
        }
        return "";
    }

    @Override
    public void setIsFieldOp(boolean isFieldOp) {
    }
}

