/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.formula.token;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import kd.mmc.pdm.business.formula.ExprContext;
import kd.mmc.pdm.business.formula.IToken;
import kd.mmc.pdm.business.formula.enums.OperatorType;
import kd.mmc.pdm.business.formula.enums.TokenType;
import org.json.JSONObject;

public class OperatorToken
implements IToken {
    private OperatorType type;
    public boolean isFieldOp = false;

    public OperatorToken(OperatorType type) {
        this.type = type;
    }

    @Override
    public void action(ExprContext ctx) {
        Object rightOperand = ctx.getStack().pop();
        Object leftOperand = null;
        if (this.type != OperatorType.ISNULL && this.type != OperatorType.ISNOTNULL && this.type != OperatorType.NOT) {
            leftOperand = ctx.getStack().pop();
        }
        Object compareValue = Boolean.FALSE;
        if (rightOperand == null) {
            if (this.type == OperatorType.ISNULL) {
                compareValue = Boolean.TRUE;
            }
        } else if (this.type == OperatorType.ISNOTNULL) {
            compareValue = Boolean.TRUE;
        }
        switch (this.type) {
            case SETVAL: {
                compareValue = this.setValue(rightOperand, leftOperand);
                break;
            }
            case EQUALS: {
                compareValue = this.isEquals(rightOperand, leftOperand);
                break;
            }
            case NOTEQUALS: {
                compareValue = !this.isEquals(rightOperand, leftOperand);
                break;
            }
            case NOT: {
                compareValue = !this.isEquals(rightOperand, Boolean.TRUE);
                break;
            }
            case LESS: {
                if (rightOperand == null && leftOperand == null) {
                    compareValue = Boolean.FALSE;
                    break;
                }
                if (rightOperand == null) {
                    compareValue = Boolean.FALSE;
                    break;
                }
                if (leftOperand == null) {
                    compareValue = Boolean.TRUE;
                    break;
                }
                if (leftOperand instanceof ArrayList) {
                    String val;
                    compareValue = false;
                    ArrayList paramsList = (ArrayList)leftOperand;
                    for (int i = 0; i < paramsList.size() && !((Boolean)(compareValue = Boolean.valueOf((val = paramsList.get(i).toString()).compareTo(rightOperand.toString()) < 0))).booleanValue(); ++i) {
                    }
                    break;
                }
                compareValue = leftOperand.toString().compareTo(rightOperand.toString()) < 0;
                break;
            }
            case EQUALSLESS: {
                if (rightOperand == null && leftOperand == null) {
                    compareValue = Boolean.TRUE;
                    break;
                }
                if (rightOperand == null) {
                    compareValue = Boolean.FALSE;
                    break;
                }
                if (leftOperand == null) {
                    compareValue = Boolean.TRUE;
                    break;
                }
                if (leftOperand instanceof ArrayList) {
                    String val;
                    compareValue = false;
                    ArrayList paramsList = (ArrayList)leftOperand;
                    for (int i = 0; i < paramsList.size() && !((Boolean)(compareValue = Boolean.valueOf((val = paramsList.get(i).toString()).compareTo(rightOperand.toString()) <= 0))).booleanValue(); ++i) {
                    }
                    break;
                }
                compareValue = leftOperand.toString().compareTo(rightOperand.toString()) <= 0;
                break;
            }
            case OVER: {
                BigDecimal right;
                BigDecimal left;
                if (rightOperand == null && leftOperand == null) {
                    compareValue = Boolean.FALSE;
                    break;
                }
                if (rightOperand == null) {
                    compareValue = Boolean.TRUE;
                    break;
                }
                if (leftOperand == null) {
                    compareValue = Boolean.FALSE;
                    break;
                }
                if (leftOperand instanceof ArrayList) {
                    String val;
                    compareValue = false;
                    ArrayList paramsList = (ArrayList)leftOperand;
                    for (int i = 0; i < paramsList.size() && !((Boolean)(compareValue = Boolean.valueOf((val = paramsList.get(i).toString()).compareTo(rightOperand.toString()) > 0))).booleanValue(); ++i) {
                    }
                    break;
                }
                try {
                    left = new BigDecimal(leftOperand.toString());
                    right = new BigDecimal(rightOperand.toString());
                }
                catch (NumberFormatException e) {
                    compareValue = leftOperand.toString().compareTo(rightOperand.toString()) > 0;
                    break;
                }
                compareValue = left.compareTo(right) > 0;
                break;
            }
            case EQUALSOVER: {
                if (rightOperand == null && leftOperand == null) {
                    compareValue = Boolean.TRUE;
                    break;
                }
                if (rightOperand == null) {
                    compareValue = Boolean.TRUE;
                    break;
                }
                if (leftOperand == null) {
                    compareValue = Boolean.FALSE;
                    break;
                }
                if (leftOperand instanceof ArrayList) {
                    String val;
                    compareValue = false;
                    ArrayList paramsList = (ArrayList)leftOperand;
                    for (int i = 0; i < paramsList.size() && !((Boolean)(compareValue = Boolean.valueOf((val = paramsList.get(i).toString()).compareTo(rightOperand.toString()) >= 0))).booleanValue(); ++i) {
                    }
                    break;
                }
                compareValue = leftOperand.toString().compareTo(rightOperand.toString()) >= 0;
                break;
            }
            case IN: {
                compareValue = this.in(rightOperand, leftOperand);
                break;
            }
            case NOTIN: {
                compareValue = !this.in(rightOperand, leftOperand);
                break;
            }
            case LIKE: {
                compareValue = this.like(rightOperand, leftOperand);
                break;
            }
            case NOTLIKE: {
                compareValue = !this.like(rightOperand, leftOperand);
                break;
            }
        }
        ctx.getStack().push(compareValue);
    }

    private Object setValue(Object rightOperand, Object leftOperand) {
        JSONObject retObj = new JSONObject();
        if (leftOperand != null) {
            retObj.put("field", (Object)leftOperand.toString());
            retObj.put("value", rightOperand == null ? "" : rightOperand);
        }
        if (this.getIsFieldOp()) {
            retObj.put("isFieldOp", true);
        } else {
            retObj.put("isFieldOp", false);
        }
        return retObj;
    }

    private boolean isEquals(Object rightOperand, Object leftOperand) {
        boolean compareValue;
        if (rightOperand == null && leftOperand == null) {
            compareValue = true;
        } else if (rightOperand == null || leftOperand == null) {
            compareValue = false;
        } else {
            ArrayList paramsList;
            if (rightOperand instanceof Boolean) {
                rightOperand = (Boolean)rightOperand != false ? Integer.valueOf(1) : Integer.valueOf(0);
            }
            if (leftOperand instanceof Boolean) {
                leftOperand = (Boolean)leftOperand != false ? Integer.valueOf(1) : Integer.valueOf(0);
            }
            compareValue = leftOperand instanceof ArrayList ? (paramsList = (ArrayList)leftOperand).contains(rightOperand) : rightOperand.toString().equals(leftOperand.toString());
        }
        return compareValue;
    }

    private boolean in(Object rightOperand, Object leftOperand) {
        boolean compareValue = false;
        int len = Array.getLength(rightOperand);
        for (int i = 0; i < len; ++i) {
            Object operand = Array.get(rightOperand, i);
            if (leftOperand == null || !leftOperand.equals(operand)) continue;
            compareValue = true;
            break;
        }
        return compareValue;
    }

    private boolean like(Object rightOperand, Object leftOperand) {
        String content = (String)leftOperand;
        String value = (String)rightOperand;
        boolean compareValue = value == null && content == null ? true : (value == null || content == null ? false : (value.startsWith("%") && value.endsWith("%") ? content.contains(value) : (value.startsWith("%") ? content.endsWith(value) : (value.endsWith("%") ? content.startsWith(value) : content.equals(value)))));
        return compareValue;
    }

    public OperatorType getOperatorType() {
        return this.type;
    }

    @Override
    public TokenType getType() {
        TokenType en = TokenType.OPERATOR;
        return en;
    }

    public boolean getIsFieldOp() {
        return this.isFieldOp;
    }

    @Override
    public void setIsFieldOp(boolean isFieldOp) {
        this.isFieldOp = isFieldOp;
    }

    public String toString() {
        switch (this.type) {
            case BETWEEN: {
                return " BETWEEN ";
            }
            case NOTBETWEEN: {
                return " NOT BETWEEN ";
            }
            case EQUALS: {
                return " == ";
            }
            case EQUALSLESS: {
                return " <= ";
            }
            case EQUALSOVER: {
                return " >= ";
            }
            case IN: {
                return " IN ";
            }
            case LESS: {
                return " < ";
            }
            case LIKE: {
                return " LIKE ";
            }
            case NOTEQUALS: {
                return " <> ";
            }
            case NOT: {
                return " ! ";
            }
            case NOTIN: {
                return " NOT IN ";
            }
            case NOTLIKE: {
                return " NOT LIKE ";
            }
            case OVER: {
                return " > ";
            }
            case PLUS: {
                return " + ";
            }
            case MINUS: {
                return " - ";
            }
            case MULTIPLE: {
                return " * ";
            }
            case DIVIDE: {
                return " / ";
            }
            case REMAINDER: {
                return " % ";
            }
            case ISNULL: {
                return " IS NULL";
            }
            case ISNOTNULL: {
                return " IS NOT NULL";
            }
            case SETVAL: {
                return " = ";
            }
        }
        return " __UNRESOLVED_OPERATOR_TYPE__";
    }
}

