/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.formula.token;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.mmc.pdm.business.formula.ExprContext;
import kd.mmc.pdm.business.formula.IToken;
import kd.mmc.pdm.business.formula.enums.TokenType;
import kd.mmc.pdm.business.proconfig.configMatrix.ConfigMatrixSearchBusiness;

public class TableToken
implements IToken {
    private String tableName;
    private boolean isAllField = false;

    public TableToken(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public void action(ExprContext ctx) {
        Object[] params = (Object[])ctx.pop();
        ArrayList<Object> newParamsList = new ArrayList<Object>(params.length);
        HashSet<String> filterFieldSet = new HashSet<String>(params.length);
        for (int i = 0; i < params.length; ++i) {
            String objStr = params[i].toString();
            if ("@ALL".equals(objStr)) {
                this.isAllField = true;
                continue;
            }
            JSONObject obj = JSONObject.parseObject((String)params[i].toString());
            boolean isFieldOp = obj.getBoolean("isFieldOp");
            if (!isFieldOp) {
                String field = obj.getString("field");
                filterFieldSet.add(field);
            }
            newParamsList.add(params[i]);
        }
        Object[] newParams = newParamsList.toArray(new Object[newParamsList.size()]);
        ConfigMatrixSearchBusiness business = new ConfigMatrixSearchBusiness(this.tableName);
        Map<String, List<Object>> retMap = business.findConfigMatrixByFieldAndVal(newParams);
        JSONObject retObj = new JSONObject();
        if (this.isAllField) {
            Set<Map.Entry<String, List<Object>>> ConfigMatrixSet = retMap.entrySet();
            for (Map.Entry<String, List<Object>> entry : ConfigMatrixSet) {
                String field = entry.getKey();
                if (filterFieldSet.contains(field)) continue;
                List<Object> valList = entry.getValue();
                if (valList == null) {
                    valList = new ArrayList<Object>();
                }
                retObj.put(field, valList);
            }
        } else {
            for (int i = 0; i < newParams.length; ++i) {
                JSONObject obj = JSONObject.parseObject((String)newParams[i].toString());
                boolean isFieldOp = obj.getBoolean("isFieldOp");
                if (!isFieldOp) continue;
                String field1 = obj.getString("field");
                String field2 = obj.getString("value");
                List<Object> featureNumList1 = retMap.get(field1);
                List<Object> featureNumList2 = retMap.get(field2);
                if (featureNumList1 == null && featureNumList2 != null) {
                    featureNumList1 = featureNumList2;
                } else if (featureNumList1 != null && featureNumList2 == null) {
                    featureNumList2 = featureNumList1;
                } else if (featureNumList1 == null && featureNumList2 == null) {
                    featureNumList1 = featureNumList2 = new ArrayList<Object>();
                }
                retObj.put(field1, featureNumList1);
                retObj.put(field2, featureNumList2);
            }
        }
        ctx.getStack().push(retObj);
    }

    @Override
    public TokenType getType() {
        return TokenType.TABLE;
    }

    public String toString() {
        return " table " + this.tableName;
    }

    @Override
    public void setIsFieldOp(boolean isFieldOp) {
    }
}

