/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.init;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.query.helper.OrgQueryHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.init.impl.AbstractInitBaseImpl;
import kd.mmc.pdm.business.init.impl.BizPlanInitImpl;
import kd.mmc.pdm.business.init.impl.CalPlanConfigInitImpl;
import kd.mmc.pdm.business.init.impl.EcoProgramPlanInitImpl;
import kd.mmc.pdm.business.init.impl.MatchFilterlInitImpl;
import kd.mmc.pdm.business.init.impl.ResourceModelInitImpl;

public class InitDataUtils {
    public static final String KEY_APP = "mmc-pdm-business";

    public static Set<Long> getOrgIdSet() {
        Set<Long> orgIds = InitDataUtils.getOrgIdsByProductView();
        Long uid = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)uid, (String)"15", (String)BizAppServiceHelp.getAppIdByAppNumber((String)"pdm"), (String)"pdm_initdata", (String)"40ANFWHX7BDE");
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(3);
        QFilter permFilter = null;
        if (!result.hasAllOrgPerm()) {
            permFilter = new QFilter("id", "in", (Object)result.getHasPermOrgs());
            qfilters.add(permFilter);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter pkFilter = new QFilter("id", "in", orgIds);
        qfilters.add(enableFilter);
        qfilters.add(pkFilter);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])qfilters.toArray(new QFilter[0]));
        return coll.stream().map(p -> p.getLong("id")).collect(Collectors.toSet());
    }

    public static Set<Long> getOrgIdsByProductView() {
        HashSet<Long> idSet = new HashSet<Long>(128);
        QFilter viewfilter = new QFilter("view", "=", (Object)4L);
        QFilter ctrlfilter = new QFilter("isctrlunit", "=", (Object)Boolean.TRUE);
        String selectProperties = "org,isctrlunit";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ProductViewOrgHelper", (String)"bos_org_structure", (String)selectProperties, (QFilter[])new QFilter[]{viewfilter, ctrlfilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long id = row.getLong("org");
                idSet.add(id);
            }
        }
        idSet.add(InitDataUtils.getRootOrg());
        return idSet;
    }

    public static long getRootOrg() {
        return OrgUnitServiceHelper.getRootOrgId();
    }

    public static boolean isRootOrg(Long orgId) {
        long rootOrgId = InitDataUtils.getRootOrg();
        return orgId.equals(rootOrgId);
    }

    private static String getSelectProperties() {
        StringBuilder sql = new StringBuilder();
        sql.append("id");
        sql.append(",org");
        sql.append(",number");
        sql.append(",initstatus");
        sql.append(",inituser");
        sql.append(",inititem");
        sql.append(",inititemdesc");
        sql.append(",initresult");
        sql.append(",initdate");
        sql.append(",orderseq");
        return sql.toString();
    }

    private static List<Map<String, Object>> buildInitItemData(boolean isRootOrg, Set<String> checkItemSet) {
        ArrayList<Map<String, Object>> itemList = new ArrayList<Map<String, Object>>(16);
        LocaleString inititem = new LocaleString();
        LocaleString inititemdesc = new LocaleString();
        if (isRootOrg) {
            inititem = ResManager.getLocaleString((String)"\u8d44\u6e90\u6a21\u578b\u521d\u59cb\u5316", (String)"InitDataUtils_01", (String)KEY_APP);
            inititemdesc = ResManager.getLocaleString((String)"\u5c55\u5f00\u8d44\u6e90\u6a21\u578b\u53ca\u5176\u9700\u8981\u7684\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u3001\u7b97\u6cd5\u6ce8\u518c\u6a21\u578b\u3001\u6570\u636e\u6e90\u7684\u521d\u59cb\u8bbe\u7f6e", (String)"InitDataUtils_02", (String)KEY_APP);
            itemList.add(InitDataUtils.buildInitItemDataMap(inititem, inititemdesc, "item01"));
            checkItemSet.add("item01");
        }
        inititem = ResManager.getLocaleString((String)"\u4e1a\u52a1\u65b9\u6848\u914d\u7f6e\u521d\u59cb\u5316", (String)"InitDataUtils_03", (String)KEY_APP);
        inititemdesc = ResManager.getLocaleString((String)"\u751f\u6210\u4e1a\u52a1\u65b9\u6848\u914d\u7f6e\u521d\u59cb\u5316\u79c1\u6709\u6570\u636e", (String)"InitDataUtils_04", (String)KEY_APP);
        itemList.add(InitDataUtils.buildInitItemDataMap(inititem, inititemdesc, "item02"));
        checkItemSet.add("item02");
        inititem = ResManager.getLocaleString((String)"\u8ba1\u7b97\u65b9\u6848\u914d\u7f6e\u521d\u59cb\u5316", (String)"InitDataUtils_05", (String)KEY_APP);
        inititemdesc = ResManager.getLocaleString((String)"\u751f\u6210\u8ba1\u7b97\u65b9\u6848\u914d\u7f6e\u521d\u59cb\u5316\u79c1\u6709\u6570\u636e", (String)"InitDataUtils_06", (String)KEY_APP);
        itemList.add(InitDataUtils.buildInitItemDataMap(inititem, inititemdesc, "item03"));
        checkItemSet.add("item03");
        inititem = ResManager.getLocaleString((String)"\u8bc4\u4f30\u65b9\u6848\u521d\u59cb\u5316", (String)"InitDataUtils_07", (String)KEY_APP);
        inititemdesc = ResManager.getLocaleString((String)"\u4ea7\u751f\u5de5\u7a0b\u53d8\u66f4\u8bc4\u4f30\u65b9\u6848\u3001\u5de5\u7a0b\u53d8\u66f4\u5f71\u54cd\u8303\u56f4\u7684\u521d\u59cb\u8bbe\u7f6e\u6570\u636e", (String)"InitDataUtils_08", (String)KEY_APP);
        itemList.add(InitDataUtils.buildInitItemDataMap(inititem, inititemdesc, "item04"));
        checkItemSet.add("item04");
        inititem = ResManager.getLocaleString((String)"\u5de5\u7a0b\u53d8\u66f4\u5339\u914d\u7ef4\u5ea6\u521d\u59cb\u5316", (String)"InitDataUtils_09", (String)KEY_APP);
        inititemdesc = ResManager.getLocaleString((String)"\u4ea7\u751f\u5de5\u7a0b\u53d8\u66f4\u5339\u914d\u7ef4\u5ea6\u7684\u521d\u59cb\u8bbe\u7f6e", (String)"InitDataUtils_10", (String)KEY_APP);
        itemList.add(InitDataUtils.buildInitItemDataMap(inititem, inititemdesc, "item05"));
        checkItemSet.add("item05");
        return itemList;
    }

    private static Map<String, Object> buildInitItemDataMap(LocaleString inititem, LocaleString inititemdesc, String number) {
        HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
        itemMap.put("inititem", inititem);
        itemMap.put("inititemdesc", inititemdesc);
        itemMap.put("number", number);
        return itemMap;
    }

    public static void getInitItemData(Long orgId) {
        DynamicObject org = OrgQueryHelper.getDataCacheByID((Object)orgId);
        QFilter qfilter = new QFilter("org", "=", (Object)orgId);
        String selectProperties = InitDataUtils.getSelectProperties();
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"pdm_initdata", (String)selectProperties, (QFilter[])new QFilter[]{qfilter});
        HashSet<Long> deleteIdSet = new HashSet<Long>(16);
        boolean isRootOrg = InitDataUtils.isRootOrg(orgId);
        HashSet<String> checkItemSet = new HashSet<String>(16);
        List<Map<String, Object>> itemList = InitDataUtils.buildInitItemData(isRootOrg, checkItemSet);
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < itemList.size(); ++i) {
            Map<String, Object> itemMap = itemList.get(i);
            String number = itemMap.get("number").toString();
            DynamicObject data = InitDataUtils.getExistsInitData(datas, number);
            if (data == null) {
                data = InitDataUtils.addInitData(org, itemMap, i + 1);
            } else {
                if (InitDataUtils.checkIsInit(data) || InitDataUtils.checkIsFail(data)) continue;
                InitDataUtils.updateInitData(data, itemMap, i + 1);
            }
            dataList.add(data);
        }
        if (!dataList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])dataList.toArray(new DynamicObject[dataList.size()]));
        }
        for (DynamicObject data : datas) {
            if (checkItemSet.contains(data.getString("number"))) continue;
            deleteIdSet.add((Long)data.getPkValue());
        }
        if (!deleteIdSet.isEmpty()) {
            DeleteServiceHelper.delete((String)"pdm_initdata", (QFilter[])new QFilter[]{new QFilter("id", "in", deleteIdSet)});
        }
    }

    private static boolean checkIsInit(DynamicObject data) {
        return "B".equals(data.getString("initstatus"));
    }

    private static boolean checkIsFail(DynamicObject data) {
        return "C".equals(data.getString("initstatus"));
    }

    private static DynamicObject addInitData(DynamicObject org, Map<String, Object> itemMap, int orderSeq) {
        DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"pdm_initdata");
        data.set("org", (Object)org);
        data.set("number", itemMap.get("number"));
        data.set("initstatus", (Object)"A");
        data.set("inituser", (Object)0L);
        data.set("inititem", itemMap.get("inititem"));
        data.set("inititemdesc", itemMap.get("inititemdesc"));
        data.set("initresult", (Object)"");
        data.set("initdate", null);
        data.set("orderseq", (Object)orderSeq);
        return data;
    }

    private static void updateInitData(DynamicObject data, Map<String, Object> itemMap, int orderSeq) {
        data.set("number", itemMap.get("number"));
        data.set("inituser", (Object)0L);
        data.set("inititem", itemMap.get("inititem"));
        data.set("inititemdesc", itemMap.get("inititemdesc"));
        data.set("initresult", (Object)"");
        data.set("initdate", null);
        data.set("orderseq", (Object)orderSeq);
    }

    private static DynamicObject getExistsInitData(DynamicObject[] datas, String number) {
        for (DynamicObject data : datas) {
            if (!number.equals(data.getString("number"))) continue;
            return data;
        }
        return null;
    }

    public static String getTipMsg(Long orgId, List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return "";
        }
        StringBuilder msg = new StringBuilder();
        QFilter qfilter = new QFilter("org", "=", (Object)orgId);
        qfilter.and(new QFilter("id", "in", ids));
        String selectProperties = "id,number,initstatus,inititem";
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"pdm_initdata", (String)selectProperties, (QFilter[])new QFilter[]{qfilter});
        block14: for (DynamicObject data : datas) {
            String checkItem;
            switch (checkItem = data.getString("number")) {
                case "item01": {
                    InitDataUtils.getTipMsgItem01(orgId, data, msg);
                    continue block14;
                }
                case "item02": {
                    InitDataUtils.getTipMsgItem02(orgId, data, msg);
                    continue block14;
                }
                case "item03": {
                    InitDataUtils.getTipMsgItem03(orgId, data, msg);
                    continue block14;
                }
                case "item04": {
                    InitDataUtils.getTipMsgItem04(orgId, data, msg);
                    continue block14;
                }
                case "item05": {
                    InitDataUtils.getTipMsgItem05(orgId, data, msg);
                    continue block14;
                }
            }
            msg.append(ResManager.loadKDString((String)"\u672a\u77e5\u521d\u59cb\u5316\u9879\u70b9\uff0c\u65e0\u6cd5\u8fdb\u884c\u521d\u59cb\u5316", (String)"InitDataUtils_11", (String)KEY_APP, (Object[])new Object[0]));
        }
        return msg.toString();
    }

    public static boolean execInitData(Long orgId, List<Long> ids) {
        DynamicObject[] datas;
        if (ids == null || ids.isEmpty()) {
            return true;
        }
        boolean isSuccess01 = true;
        boolean isSuccess02 = true;
        boolean isSuccess03 = true;
        boolean isSuccess04 = true;
        boolean isSuccess05 = true;
        QFilter qfilter = new QFilter("org", "=", (Object)orgId);
        qfilter.and(new QFilter("id", "in", ids));
        String selectProperties = InitDataUtils.getSelectProperties();
        block14: for (DynamicObject data : datas = BusinessDataServiceHelper.load((String)"pdm_initdata", (String)selectProperties, (QFilter[])new QFilter[]{qfilter}, (String)"orderseq")) {
            String checkItem;
            switch (checkItem = data.getString("number")) {
                case "item01": {
                    isSuccess01 = InitDataUtils.execInitDataItem01(orgId, data);
                    continue block14;
                }
                case "item02": {
                    isSuccess02 = InitDataUtils.execInitDataItem02(orgId, data);
                    continue block14;
                }
                case "item03": {
                    isSuccess03 = InitDataUtils.execInitDataItem03(orgId, data);
                    continue block14;
                }
                case "item04": {
                    isSuccess04 = InitDataUtils.execInitDataItem04(orgId, data);
                    continue block14;
                }
                case "item05": {
                    isSuccess05 = InitDataUtils.execInitDataItem05(orgId, data);
                    continue block14;
                }
                default: {
                    InitDataUtils.setResult(data, "C", ResManager.getLocaleString((String)"\u672a\u77e5\u521d\u59cb\u5316\u9879\u70b9\uff0c\u65e0\u6cd5\u8fdb\u884c\u521d\u59cb\u5316", (String)"InitDataUtils_11", (String)KEY_APP), false);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])datas);
        return isSuccess01 && isSuccess02 && isSuccess03 && isSuccess04 && isSuccess05;
    }

    private static void setResult(DynamicObject data, String initStatus, LocaleString initResult, boolean isTrue) {
        data.set("initstatus", (Object)(isTrue ? "B" : "C"));
        data.set("initresult", (Object)initResult);
        data.set("initdate", (Object)new Date());
        data.set("inituser", (Object)RequestContext.get().getCurrUserId());
    }

    private static LocaleString getSuccessMsg() {
        return ResManager.getLocaleString((String)"\u521d\u59cb\u5316\u6210\u529f", (String)"InitDataUtils_12", (String)KEY_APP);
    }

    private static boolean execInitDataItem01(Long orgId, DynamicObject data) {
        ResourceModelInitImpl business = ResourceModelInitImpl.getInstance(orgId);
        String msg = business.checkData();
        if (!StringUtils.isEmpty((String)msg)) {
            LocaleString ls = new LocaleString(msg);
            InitDataUtils.setResult(data, "C", ls, false);
            return false;
        }
        msg = business.execSqlData();
        if (!StringUtils.isEmpty((String)msg)) {
            LocaleString ls = new LocaleString(msg);
            InitDataUtils.setResult(data, "C", ls, false);
            return false;
        }
        InitDataUtils.setResult(data, "B", InitDataUtils.getSuccessMsg(), true);
        return true;
    }

    public static String getInitBizPlanEstimateName() {
        return ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u8bc4\u4f30\u4e1a\u52a1\u65b9\u6848\u914d\u7f6e", (String)"InitDataUtils_13", (String)KEY_APP, (Object[])new Object[0]);
    }

    public static String getInitBizPlanEffectRangeName() {
        return ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5f71\u54cd\u8303\u56f4\u65b9\u6848\u914d\u7f6e", (String)"InitDataUtils_14", (String)KEY_APP, (Object[])new Object[0]);
    }

    public static String getYsBizPlanEstimateName() {
        return ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u8bc4\u4f30\u4e1a\u52a1\u65b9\u6848\u914d\u7f6e", (String)"InitDataUtils_22", (String)KEY_APP, (Object[])new Object[0]);
    }

    public static String getYsBizPlanEffectRangeName() {
        return ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5f71\u54cd\u8303\u56f4\u65b9\u6848\u914d\u7f6e", (String)"InitDataUtils_23", (String)KEY_APP, (Object[])new Object[0]);
    }

    private static boolean execInitDataItem02(Long orgId, DynamicObject data) {
        BizPlanInitImpl businessA = BizPlanInitImpl.getInstance(orgId, "eco_eatimate_bizset_init", InitDataUtils.getInitBizPlanEstimateName());
        BizPlanInitImpl businessB = BizPlanInitImpl.getInstance(orgId, "eco_effectrange_bizset_init", InitDataUtils.getInitBizPlanEffectRangeName());
        return InitDataUtils.execPrivateData(businessA, businessB, data);
    }

    public static String getInitCalPlanConfigEstimateName() {
        return ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u8bc4\u4f30\u8ba1\u7b97\u65b9\u6848", (String)"InitDataUtils_15", (String)KEY_APP, (Object[])new Object[0]);
    }

    public static String getInitCalPlanConfigEffectRangeName() {
        return ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5f71\u54cd\u8303\u56f4\u65b9\u6848", (String)"InitDataUtils_16", (String)KEY_APP, (Object[])new Object[0]);
    }

    public static String getYsCalPlanConfigEstimateName() {
        return ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u8bc4\u4f30\u8ba1\u7b97\u65b9\u6848", (String)"InitDataUtils_24", (String)KEY_APP, (Object[])new Object[0]);
    }

    public static String getYsCalPlanConfigEffectRangeName() {
        return ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5f71\u54cd\u8303\u56f4\u65b9\u6848", (String)"InitDataUtils_25", (String)KEY_APP, (Object[])new Object[0]);
    }

    private static boolean execInitDataItem03(Long orgId, DynamicObject data) {
        CalPlanConfigInitImpl businessA = CalPlanConfigInitImpl.getInstance(orgId, "ecoestimate_init", InitDataUtils.getInitCalPlanConfigEstimateName());
        CalPlanConfigInitImpl businessB = CalPlanConfigInitImpl.getInstance(orgId, "ecoeffectrange_init", InitDataUtils.getInitCalPlanConfigEffectRangeName());
        return InitDataUtils.execPrivateData(businessA, businessB, data);
    }

    private static boolean execPrivateData(AbstractInitBaseImpl businessA, AbstractInitBaseImpl businessB, DynamicObject data) {
        String msg = businessA.checkData();
        if (!StringUtils.isEmpty((String)msg)) {
            LocaleString ls = new LocaleString(msg);
            InitDataUtils.setResult(data, "C", ls, false);
            return false;
        }
        msg = businessB.checkData();
        if (!StringUtils.isEmpty((String)msg)) {
            LocaleString ls = new LocaleString(msg);
            InitDataUtils.setResult(data, "C", ls, false);
            return false;
        }
        msg = businessA.execInitData();
        if (!StringUtils.isEmpty((String)msg)) {
            LocaleString ls = new LocaleString(msg);
            InitDataUtils.setResult(data, "C", ls, false);
            return false;
        }
        msg = businessB.execInitData();
        if (!StringUtils.isEmpty((String)msg)) {
            LocaleString ls = new LocaleString(msg);
            InitDataUtils.setResult(data, "C", ls, false);
            return false;
        }
        InitDataUtils.setResult(data, "B", InitDataUtils.getSuccessMsg(), true);
        return true;
    }

    public static String getInitPlanProgramEstimateName() {
        return ResManager.loadKDString((String)"BOM\u53d8\u66f4\u5b9e\u65bd\u65f6\u95f4\u8bc4\u4f30", (String)"InitDataUtils_20", (String)KEY_APP, (Object[])new Object[0]);
    }

    public static String getInitPlanProgramEffectRangeName() {
        return ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u5f71\u54cd\u8303\u56f4", (String)"InitDataUtils_21", (String)KEY_APP, (Object[])new Object[0]);
    }

    private static boolean execInitDataItem04(Long orgId, DynamicObject data) {
        EcoProgramPlanInitImpl businessA = EcoProgramPlanInitImpl.getInstance(orgId, "estimate_programplan_init", InitDataUtils.getInitPlanProgramEstimateName());
        EcoProgramPlanInitImpl businessB = EcoProgramPlanInitImpl.getInstance(orgId, "effectrange_programplan_init", InitDataUtils.getInitPlanProgramEffectRangeName());
        return InitDataUtils.execPrivateData(businessA, businessB, data);
    }

    private static boolean execInitDataItem05(Long orgId, DynamicObject data) {
        MatchFilterlInitImpl business = MatchFilterlInitImpl.getInstance(orgId);
        String msg = business.checkData();
        if (!StringUtils.isEmpty((String)msg)) {
            LocaleString ls = new LocaleString(msg);
            InitDataUtils.setResult(data, "C", ls, false);
            return false;
        }
        msg = business.execSqlData();
        if (!StringUtils.isEmpty((String)msg)) {
            LocaleString ls = new LocaleString(msg);
            InitDataUtils.setResult(data, "C", ls, false);
            return false;
        }
        InitDataUtils.setResult(data, "B", InitDataUtils.getSuccessMsg(), true);
        return true;
    }

    private static void getTipMsgItem01(Long orgId, DynamicObject data, StringBuilder msg) {
        ResourceModelInitImpl business;
        boolean istrue = InitDataUtils.checkIsEndInit(orgId, data, msg);
        if (istrue && (business = ResourceModelInitImpl.getInstance(orgId)).checkIsExistsData()) {
            msg.append(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u70b9[%1$s]\u5df2\u7ecf\u5b58\u5728\u672c\u751f\u4ea7\u7ec4\u7ec7[%2$s]\u4e0b\u7684\u6570\u636e\uff0c\u672c\u6b21\u64cd\u4f5c\u5c06\u6309\u521d\u59cb\u5316\u6570\u636e\u5bf9\u5176\u91cd\u65b0\u8986\u76d6\u66f4\u65b0\u3002", (String)"InitDataUtils_18", (String)KEY_APP, (Object[])new Object[0]), data.getString("inititem"), InitDataUtils.getOrgName(orgId)));
        }
    }

    private static void getTipMsgItem02(Long orgId, DynamicObject data, StringBuilder msg) {
        BizPlanInitImpl business;
        boolean istrue = InitDataUtils.checkIsEndInit(orgId, data, msg);
        if (istrue && (business = BizPlanInitImpl.getInstance(orgId, "eco_eatimate_bizset_init", InitDataUtils.getInitBizPlanEstimateName())).checkIsExistsData()) {
            msg.append(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u70b9[%1$s]\u5df2\u7ecf\u5b58\u5728\u672c\u751f\u4ea7\u7ec4\u7ec7[%2$s]\u4e0b\u7684\u6570\u636e\uff0c\u672c\u6b21\u64cd\u4f5c\u5c06\u6309\u521d\u59cb\u5316\u6570\u636e\u5bf9\u5176\u91cd\u65b0\u8986\u76d6\u66f4\u65b0\u3002", (String)"InitDataUtils_18", (String)KEY_APP, (Object[])new Object[0]), data.getString("inititem"), InitDataUtils.getOrgName(orgId)));
        }
    }

    private static void getTipMsgItem03(Long orgId, DynamicObject data, StringBuilder msg) {
        CalPlanConfigInitImpl business;
        boolean istrue = InitDataUtils.checkIsEndInit(orgId, data, msg);
        if (istrue && (business = CalPlanConfigInitImpl.getInstance(orgId, "ecoeffectrange_init", InitDataUtils.getInitBizPlanEstimateName())).checkIsExistsData()) {
            msg.append(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u70b9[%1$s]\u5df2\u7ecf\u5b58\u5728\u672c\u751f\u4ea7\u7ec4\u7ec7[%2$s]\u4e0b\u7684\u6570\u636e\uff0c\u672c\u6b21\u64cd\u4f5c\u5c06\u6309\u521d\u59cb\u5316\u6570\u636e\u5bf9\u5176\u91cd\u65b0\u8986\u76d6\u66f4\u65b0\u3002", (String)"InitDataUtils_18", (String)KEY_APP, (Object[])new Object[0]), data.getString("inititem"), InitDataUtils.getOrgName(orgId)));
        }
    }

    private static void getTipMsgItem04(Long orgId, DynamicObject data, StringBuilder msg) {
        MatchFilterlInitImpl business;
        boolean istrue = InitDataUtils.checkIsEndInit(orgId, data, msg);
        if (istrue && (business = MatchFilterlInitImpl.getInstance(orgId)).checkIsExistsData()) {
            msg.append(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u70b9[%1$s]\u5df2\u7ecf\u5b58\u5728\u672c\u751f\u4ea7\u7ec4\u7ec7[%2$s]\u4e0b\u7684\u6570\u636e\uff0c\u672c\u6b21\u64cd\u4f5c\u5c06\u6309\u521d\u59cb\u5316\u6570\u636e\u5bf9\u5176\u91cd\u65b0\u8986\u76d6\u66f4\u65b0\u3002", (String)"InitDataUtils_18", (String)KEY_APP, (Object[])new Object[0]), data.getString("inititem"), InitDataUtils.getOrgName(orgId)));
        }
    }

    private static void getTipMsgItem05(Long orgId, DynamicObject data, StringBuilder msg) {
        MatchFilterlInitImpl business;
        boolean istrue = InitDataUtils.checkIsEndInit(orgId, data, msg);
        if (istrue && (business = MatchFilterlInitImpl.getInstance(orgId)).checkIsExistsData()) {
            msg.append(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u70b9[%1$s]\u5df2\u7ecf\u5b58\u5728\u57fa\u7840\u6570\u636e\uff0c\u672c\u6b21\u64cd\u4f5c\u5c06\u6309\u521d\u59cb\u5316\u6570\u636e\u5bf9\u5176\u91cd\u65b0\u8986\u76d6\u66f4\u65b0\u3002", (String)"InitDataUtils_19", (String)KEY_APP, (Object[])new Object[0]), data.getString("inititem")));
        }
    }

    private static boolean checkIsEndInit(Long orgId, DynamicObject data, StringBuilder msg) {
        if (InitDataUtils.checkIsInit(data)) {
            msg.append(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u70b9[%1$s]\u5df2\u7ecf\u8fdb\u884c\u4e86\u521d\u59cb\u5316\uff0c\u672c\u6b21\u64cd\u4f5c\u5c06\u6309\u521d\u59cb\u5316\u6570\u636e\u5bf9\u5176\u91cd\u65b0\u8986\u76d6\u66f4\u65b0\u3002", (String)"InitDataUtils_17", (String)KEY_APP, (Object[])new Object[0]), data.getString("inititem")));
            return false;
        }
        return true;
    }

    public static String getOrgName(Long orgId) {
        DynamicObject org = OrgQueryHelper.getDataCacheByID((Object)orgId);
        return org.getString("name");
    }
}

