/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.init.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.business.init.InitDataUtils;
import kd.mmc.pdm.business.init.impl.AbstractInitBaseImpl;

public class BizPlanInitImpl
extends AbstractInitBaseImpl {
    private static final Log log = LogFactory.getLog(BizPlanInitImpl.class);

    public static BizPlanInitImpl getInstance(Long org, String initBaseNumber, String initBaseName) {
        return new BizPlanInitImpl(org, initBaseNumber, initBaseName);
    }

    public BizPlanInitImpl(Long orgId, String initBaseNumber, String initBaseName) {
        this.init(orgId, initBaseNumber, initBaseName, "mrp_businessplan");
    }

    @Override
    public String checkData() {
        String msg = super.checkData();
        String entityNumber = this.getEntityNumber();
        String defCtrl = this.getDefaultCt(entityNumber, String.valueOf(this.getOrgId()));
        if (!this.isPrivateCtrl(defCtrl)) {
            msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u65b9\u6848\u914d\u7f6e\u7684\u9ed8\u8ba4\u7ba1\u63a7\u7b56\u7565\u4e0d\u662f[\u79c1\u6709]\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"BizPlanInitImpl_01", (String)"mmc-pdm-business", (Object[])new Object[0]);
            return msg;
        }
        return msg;
    }

    @Override
    public String execInitData() {
        try {
            String number = this.getInitBaseNumber();
            String newnumber = this.getNumberByOrg(number);
            DynamicObject newObject = this.getDynamicObject(newnumber);
            newObject = this.buildDefault(this.getEntityNumber(), newObject);
            newObject.set("createorg", (Object)this.getOrgId());
            newObject.set("org", (Object)this.getOrgId());
            newObject.set("number", (Object)newnumber);
            newObject.set("name", (Object)this.getNameByOrg(number));
            newObject.set("fieldtype", (Object)"pdm");
            this.saveData(newObject);
            Long id = newObject.getLong("id");
            String xml_Tag = this.getXmlString(BizPlanInitImpl.isEn_US() ? this.enName(number) : number);
            String cellsdata_Tag = this.getTxtString(number + "_displayname");
            String updateSql = "update t_mrp_businessplan set fxml_tag = ?, fcellsdata_tag  = ? where fid = ?";
            DB.execute((DBRoute)this.getDBRoute(), (String)updateSql, (Object[])new Object[]{xml_Tag, cellsdata_Tag, id});
            this.clearCache();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return "error:" + e.getMessage();
        }
        return "";
    }

    @Override
    public boolean checkIsExistsData() {
        QFilter qfilter = new QFilter("number", "=", (Object)this.getNumberByOrg("eco_eatimate_bizset_init"));
        qfilter.and(new QFilter("createorg", "=", (Object)this.getOrgId()));
        boolean exists = QueryServiceHelper.exists((String)"mrp_businessplan", (QFilter[])new QFilter[]{qfilter});
        if (!exists) {
            qfilter = new QFilter("number", "=", (Object)this.getNumberByOrg("eco_effectrange_bizset_init"));
            qfilter.and(new QFilter("createorg", "=", (Object)this.getOrgId()));
            exists = QueryServiceHelper.exists((String)"mrp_businessplan", (QFilter[])new QFilter[]{qfilter});
        }
        return exists;
    }

    public String getNumberByOrg(String initNumber) {
        Long orgId = this.getOrgId();
        if (InitDataUtils.isRootOrg(orgId)) {
            return "eco_eatimate_bizset_init".equals(initNumber) ? "eco_eatimate_bizset_S" : "eco_effectrange_bizset_S";
        }
        return initNumber;
    }

    public String getNameByOrg(String initNumber) {
        Long orgId = this.getOrgId();
        if (InitDataUtils.isRootOrg(orgId)) {
            if ("eco_eatimate_bizset_init".equals(initNumber)) {
                return InitDataUtils.getYsBizPlanEstimateName();
            }
            return InitDataUtils.getYsBizPlanEffectRangeName();
        }
        return this.getInitBaseName();
    }
}

