/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.init.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.business.init.InitDataUtils;
import kd.mmc.pdm.business.init.impl.AbstractInitBaseImpl;

public class CalPlanConfigInitImpl
extends AbstractInitBaseImpl {
    private static final Log log = LogFactory.getLog(CalPlanConfigInitImpl.class);

    public static CalPlanConfigInitImpl getInstance(Long org, String initBaseNumber, String initBaseName) {
        return new CalPlanConfigInitImpl(org, initBaseNumber, initBaseName);
    }

    public CalPlanConfigInitImpl(Long orgId, String initBaseNumber, String initBaseName) {
        this.init(orgId, initBaseNumber, initBaseName, "mrp_calplanconfig");
    }

    @Override
    public String checkData() {
        String msg = super.checkData();
        String entityNumber = this.getEntityNumber();
        String defCtrl = this.getDefaultCt(entityNumber, String.valueOf(this.getOrgId()));
        if (!this.isPrivateCtrl(defCtrl)) {
            msg = ResManager.loadKDString((String)"\u8ba1\u7b97\u65b9\u6848\u914d\u7f6e\u7684\u9ed8\u8ba4\u7ba1\u63a7\u7b56\u7565\u4e0d\u662f[\u79c1\u6709]\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"CalPlanConfigInitImpl_01", (String)"mmc-pdm-business", (Object[])new Object[0]);
            return msg;
        }
        return msg;
    }

    @Override
    public String execInitData() {
        try {
            String newnumber = this.getNumberByOrg(this.getInitBaseNumber());
            DynamicObject newObject = this.getDynamicObject(newnumber);
            newObject = this.buildDefault(this.getEntityNumber(), newObject);
            newObject.set("createorg", (Object)this.getOrgId());
            newObject.set("org", (Object)this.getOrgId());
            newObject.set("number", (Object)newnumber);
            newObject.set("name", (Object)this.getNameByOrg(this.getInitBaseNumber()));
            newObject.set("fieldtype", (Object)"pdm");
            Long bizplanId = this.getDynamicObjectId("mrp_businessplan", this.getOrgId(), this.getBizPlanInitBaseNumber());
            if (bizplanId == null || bizplanId.equals(0L)) {
                throw new KDBizException(new ErrorCode("execInitData", String.format(ResManager.loadKDString((String)"\u5728\u7ec4\u7ec7[%1$s]\u4e0b\u65e0\u6cd5\u627e\u5230\u7f16\u7801\u4e3a[%2$s]\u7684\u4e1a\u52a1\u65b9\u6848\u914d\u7f6e\u6570\u636e\u3002", (String)"CalPlanConfigInitImpl_02", (String)"mmc-pdm-business", (Object[])new Object[0]), this.getOrgName(this.getOrgId()), this.getBizPlanInitBaseNumber())), new Object[0]);
            }
            if (!this.checkIsEnable("mrp_businessplan", bizplanId)) {
                throw new KDBizException(new ErrorCode("execInitData", String.format(ResManager.loadKDString((String)"\u5728\u7ec4\u7ec7[%1$s]\u4e0b\u7f16\u7801\u4e3a[%2$s]\u7684\u4e1a\u52a1\u65b9\u6848\u4e0d\u662f\u5ba1\u6838\u53ef\u7528\u72b6\u6001\u3002", (String)"CalPlanConfigInitImpl_03", (String)"mmc-pdm-business", (Object[])new Object[0]), this.getOrgName(this.getOrgId()), this.getBizPlanInitBaseNumber())), new Object[0]);
            }
            DynamicObjectCollection coll = newObject.getDynamicObjectCollection("entryentity");
            coll.clear();
            DynamicObject entry = coll.addNew();
            entry.set("bizplan", (Object)bizplanId);
            entry.set("runtype", (Object)this.getRunType());
            entry.set("seq", (Object)1);
            this.saveData(newObject);
            this.clearCache();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return "error:" + e.getMessage();
        }
        return "";
    }

    public String getBizPlanInitBaseNumber() {
        String calPlanConfigInitBaseNumber = this.getInitBaseNumber();
        boolean isRootOrg = InitDataUtils.isRootOrg(this.getOrgId());
        if ("ecoestimate_init".equalsIgnoreCase(calPlanConfigInitBaseNumber)) {
            return isRootOrg ? "eco_eatimate_bizset_S" : "eco_eatimate_bizset_init";
        }
        if ("ecoeffectrange_init".equalsIgnoreCase(calPlanConfigInitBaseNumber)) {
            return isRootOrg ? "eco_effectrange_bizset_S" : "eco_effectrange_bizset_init";
        }
        return "null";
    }

    public String getRunType() {
        String calPlanConfigInitBaseNumber = this.getInitBaseNumber();
        if ("ecoestimate_init".equalsIgnoreCase(calPlanConfigInitBaseNumber)) {
            return "pdm_ecoestimate_exec";
        }
        if ("ecoeffectrange_init".equalsIgnoreCase(calPlanConfigInitBaseNumber)) {
            return "pdm_ecoeffectrange_exec";
        }
        return "null";
    }

    @Override
    public boolean checkIsExistsData() {
        QFilter qfilter = new QFilter("number", "=", (Object)this.getNumberByOrg("ecoestimate_init"));
        qfilter.and(new QFilter("createorg", "=", (Object)this.getOrgId()));
        boolean exists = QueryServiceHelper.exists((String)"mrp_calplanconfig", (QFilter[])new QFilter[]{qfilter});
        if (!exists) {
            qfilter = new QFilter("number", "=", (Object)this.getNumberByOrg("ecoeffectrange_init"));
            qfilter.and(new QFilter("createorg", "=", (Object)this.getOrgId()));
            exists = QueryServiceHelper.exists((String)"mrp_calplanconfig", (QFilter[])new QFilter[]{qfilter});
        }
        return exists;
    }

    public String getNumberByOrg(String initNumber) {
        Long orgId = this.getOrgId();
        if (InitDataUtils.isRootOrg(orgId)) {
            return "ecoestimate_init".equals(initNumber) ? "ecoestimate_S" : "ecoeffectrange_S";
        }
        return initNumber;
    }

    public String getNameByOrg(String initNumber) {
        Long orgId = this.getOrgId();
        if (InitDataUtils.isRootOrg(orgId)) {
            if ("ecoestimate_init".equals(initNumber)) {
                return InitDataUtils.getYsCalPlanConfigEstimateName();
            }
            return InitDataUtils.getYsCalPlanConfigEffectRangeName();
        }
        return this.getInitBaseName();
    }
}

