/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.init.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.business.init.InitDataUtils;
import kd.mmc.pdm.business.init.impl.AbstractInitBaseImpl;

public class EcoProgramPlanInitImpl
extends AbstractInitBaseImpl {
    private static final Log log = LogFactory.getLog(EcoProgramPlanInitImpl.class);

    public static EcoProgramPlanInitImpl getInstance(Long org, String initBaseNumber, String initBaseName) {
        return new EcoProgramPlanInitImpl(org, initBaseNumber, initBaseName);
    }

    public EcoProgramPlanInitImpl(Long orgId, String initBaseNumber, String initBaseName) {
        this.init(orgId, initBaseNumber, initBaseName, "pdm_planprogram_eco");
    }

    @Override
    public String checkData() {
        String msg = super.checkData();
        String entityNumber = this.getEntityNumber();
        String defCtrl = this.getDefaultCt(entityNumber, String.valueOf(this.getOrgId()));
        if (!this.isPrivateCtrl(defCtrl)) {
            msg = ResManager.loadKDString((String)"\u5de5\u7a0b\u53d8\u66f4\u8bc4\u4f30\u65b9\u6848\u7684\u9ed8\u8ba4\u7ba1\u63a7\u7b56\u7565\u4e0d\u662f[\u79c1\u6709]\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"EcoProgramPlanInitImpl_01", (String)"mmc-pdm-business", (Object[])new Object[0]);
            return msg;
        }
        return msg;
    }

    @Override
    public String execInitData() {
        try {
            DynamicObject newObject = this.getDynamicObject(this.getInitBaseNumber());
            newObject = this.buildDefault(this.getEntityNumber(), newObject);
            newObject.set("createorg", (Object)this.getOrg());
            newObject.set("org", newObject.get("createorg"));
            newObject.set("number", (Object)this.getInitBaseNumber());
            newObject.set("name", (Object)this.getInitBaseName());
            newObject.set("planoutlook", (Object)999);
            newObject.set("enable", (Object)"1");
            newObject.set("status", (Object)"A");
            newObject.set("type", (Object)"A");
            newObject.set("isestimatestatus", (Object)true);
            newObject.set("estimatetype", (Object)this.getEstimateType());
            if ("B".equals(this.getEstimateType()) && this.checkIsExistsDataByB(this.getOrgId(), newObject.getLong("id"))) {
                throw new KDBizException(new ErrorCode("execInitData", String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%1$s]\u5df2\u7ecf\u5b58\u5728\u5ba1\u6838\u53ef\u7528\u7684\u5339\u914d\u7ef4\u5ea6\u4e3a\u5f71\u54cd\u8303\u56f4\u7684\u8bc4\u4f30\u65b9\u6848\u3002", (String)"EcoProgramPlanInitImpl_05", (String)"mmc-pdm-business", (Object[])new Object[0]), this.getOrgName(this.getOrgId()))), new Object[0]);
            }
            boolean isEstimate = this.isEstimate(newObject);
            newObject.set("estimatestatusday", (Object)0);
            newObject.set("shiftingtype", (Object)"A");
            newObject.set("isrefeco", (Object)true);
            newObject.set("refpktype", (Object)"A");
            newObject.set("grouppktype", (Object)"A");
            newObject.set("suppqtyexceptiontype", (Object)"A");
            newObject.set("adjusteffectset", (Object)"A");
            newObject.set("allowleadtime", (Object)0);
            newObject.set("earlytoler", (Object)0);
            newObject.set("allowdelaytime", (Object)0);
            newObject.set("delaytoler", (Object)0);
            newObject.set("considerbatchstr", (Object)false);
            newObject.set("safestockeffectset", (Object)"C");
            newObject.set("appmode", (Object)"A");
            newObject.set("computemode", (Object)"A");
            newObject.set("outofdate", (Object)"1");
            newObject.set("day", (Object)0);
            newObject.set("scoutofdate", (Object)"1");
            newObject.set("scday", (Object)0);
            newObject.set("demandmodel", (Object)this.getDemandmodel(isEstimate));
            newObject.set("supplymodel", (Object)this.getSupplymodel(isEstimate));
            newObject.set("relativetransfer", (Object)this.getRelativetransfer(isEstimate));
            DynamicObjectCollection orgentryentityColl = newObject.getDynamicObjectCollection("orgentryentity");
            orgentryentityColl.clear();
            DynamicObject orgentryentity = orgentryentityColl.addNew();
            orgentryentity.set("seq", (Object)1);
            orgentryentity.set("entrydemandorg", (Object)this.getOrgId());
            DynamicObjectCollection rearentryentityColl = newObject.getDynamicObjectCollection("rearentryentity");
            rearentryentityColl.clear();
            DynamicObjectCollection entryentityColl = newObject.getDynamicObjectCollection("entryentity");
            entryentityColl.clear();
            DynamicObjectCollection resDataConfigs = this.getResourceDataConfig(newObject.getDynamicObject("demandmodel").getPkValue(), null);
            for (int i = 0; i < resDataConfigs.size(); ++i) {
                DynamicObject dataSource = (DynamicObject)resDataConfigs.get(i);
                DynamicObject entryentity = entryentityColl.addNew();
                entryentity.set("seq", (Object)(i + 1));
                entryentity.set("entryismrpoperat", (Object)true);
                entryentity.set("resourceregister", dataSource.get("id"));
                entryentity.set("entrydemandsrc", dataSource.get("srcbill"));
                entryentity.set("entrydemandtype", (Object)this.getEntryDemandType(isEstimate, dataSource));
                DynamicObject rearentryentity = rearentryentityColl.addNew();
                rearentryentity.set("seq", (Object)rearentryentityColl.size());
                rearentryentity.set("entryentitytype", dataSource.get("srcbill"));
                rearentryentity.set("adjuststrategy", (Object)"B");
                rearentryentity.set("resulttype", (Object)"0,1,2");
            }
            DynamicObjectCollection scentryentityColl = newObject.getDynamicObjectCollection("scentryentity");
            scentryentityColl.clear();
            resDataConfigs = this.getResourceDataConfig(newObject.getDynamicObject("supplymodel").getPkValue(), null);
            for (int i = 0; i < resDataConfigs.size(); ++i) {
                DynamicObject dataSource = (DynamicObject)resDataConfigs.get(i);
                DynamicObject scentryentity = scentryentityColl.addNew();
                scentryentity.set("seq", (Object)(i + 1));
                scentryentity.set("entryisscmrpoperat", (Object)true);
                scentryentity.set("resourceregisters", dataSource.get("id"));
                scentryentity.set("entrysupplyres", dataSource.get("srcbill"));
                scentryentity.set("supplypriority", (Object)0);
                scentryentity.set("entryppdemandds", null);
                DynamicObject rearentryentity = rearentryentityColl.addNew();
                rearentryentity.set("seq", (Object)rearentryentityColl.size());
                rearentryentity.set("entryentitytype", dataSource.get("srcbill"));
                rearentryentity.set("adjuststrategy", (Object)"B");
                rearentryentity.set("resulttype", (Object)"0,1,2");
            }
            this.saveDataByOperator(newObject, true);
            this.clearCache();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return "error:" + e.getMessage();
        }
        return "";
    }

    public boolean isEstimate(DynamicObject newObject) {
        return "A".equals(newObject.getString("estimatetype"));
    }

    public String getEntryDemandType(boolean isEstimate, DynamicObject dataSource) {
        if (!isEstimate && "DS_er_p_pdm_eco_S".equalsIgnoreCase(dataSource.getString("number"))) {
            return "B";
        }
        return "A";
    }

    private DynamicObjectCollection getResourceDataConfig(Object resRegistId, QFilter qFilter) {
        QFilter qFilterId = new QFilter("cgnumber", "=", resRegistId);
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        String selectProPerty = "id,billfieldtransfer.srcbill srcbill,number";
        QFilter[] qFilters = qFilter == null ? new QFilter[]{qFilterId, qFilterEnable} : new QFilter[]{qFilterId, qFilterEnable, qFilter};
        return QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)selectProPerty, (QFilter[])qFilters);
    }

    public String getEstimateType() {
        String initBaseNumber = this.getInitBaseNumber();
        if ("estimate_programplan_init".equalsIgnoreCase(initBaseNumber)) {
            return "A";
        }
        if ("effectrange_programplan_init".equalsIgnoreCase(initBaseNumber)) {
            return "B";
        }
        return "A";
    }

    public DynamicObject getDemandmodel(boolean isEstimate) {
        long rootOrgId = InitDataUtils.getRootOrg();
        String resourceModelNumber = isEstimate ? "eco_estimate_require_S" : "eco_effectrange_demand_S";
        QFilter qfilter = new QFilter("number", "=", (Object)resourceModelNumber);
        qfilter.and(new QFilter("createorg", "=", (Object)rootOrgId));
        DynamicObject demandModel = BusinessDataServiceHelper.loadSingle((String)"mrp_resourceregister_cf", (QFilter[])new QFilter[]{qfilter});
        if (demandModel == null) {
            throw new KDBizException(new ErrorCode("execInitData", String.format(ResManager.loadKDString((String)"\u5728\u7ec4\u7ec7[%1$s]\u4e0b\u65e0\u6cd5\u627e\u5230\u7f16\u7801\u4e3a[%2$s]\u7684\u8d44\u6e90\u6ce8\u518c\u6a21\u578b\uff08\u9700\u6c42\uff09\u3002", (String)"EcoProgramPlanInitImpl_02", (String)"mmc-pdm-business", (Object[])new Object[0]), this.getOrgName(rootOrgId), resourceModelNumber)), new Object[0]);
        }
        return demandModel;
    }

    public DynamicObject getSupplymodel(boolean isEstimate) {
        long rootOrgId = InitDataUtils.getRootOrg();
        String resourceModelNumber = isEstimate ? "eco_estimate_sypply_S" : "eco_effectrange_supply_S";
        QFilter qfilter = new QFilter("number", "=", (Object)resourceModelNumber);
        qfilter.and(new QFilter("createorg", "=", (Object)rootOrgId));
        DynamicObject supplyModel = BusinessDataServiceHelper.loadSingle((String)"mrp_resourceregister_cf", (QFilter[])new QFilter[]{qfilter});
        if (supplyModel == null) {
            throw new KDBizException(new ErrorCode("execInitData", String.format(ResManager.loadKDString((String)"\u5728\u7ec4\u7ec7[%1$s]\u4e0b\u65e0\u6cd5\u627e\u5230\u7f16\u7801\u4e3a[%2$s]\u7684\u8d44\u6e90\u6ce8\u518c\u6a21\u578b\uff08\u4f9b\u5e94\uff09\u3002", (String)"EcoProgramPlanInitImpl_03", (String)"mmc-pdm-business", (Object[])new Object[0]), this.getOrgName(rootOrgId), resourceModelNumber)), new Object[0]);
        }
        return supplyModel;
    }

    public DynamicObject getRelativetransfer(boolean isEstimate) {
        long rootOrgId = InitDataUtils.getRootOrg();
        String resourceModelNumber = isEstimate ? "estimate_s_r_S" : "er_s_r_S";
        String selectProperties = "id,number,name";
        QFilter qfilter = new QFilter("number", "=", (Object)resourceModelNumber);
        qfilter.and(new QFilter("createorg", "=", (Object)rootOrgId));
        DynamicObject relativeTransfer = BusinessDataServiceHelper.loadSingle((String)"mrp_billfieldtransfer", (String)selectProperties, (QFilter[])new QFilter[]{qfilter});
        if (relativeTransfer == null) {
            throw new KDBizException(new ErrorCode("execInitData", String.format(ResManager.loadKDString((String)"\u5728\u7ec4\u7ec7[%1$s]\u4e0b\u65e0\u6cd5\u627e\u5230\u7f16\u7801\u4e3a[%2$s]\u7684\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\uff08\u5339\u914d\u7ef4\u5ea6\uff09\u3002", (String)"EcoProgramPlanInitImpl_04", (String)"mmc-pdm-business", (Object[])new Object[0]), this.getOrgName(rootOrgId), resourceModelNumber)), new Object[0]);
        }
        return relativeTransfer;
    }

    @Override
    public boolean checkIsExistsData() {
        QFilter qfilter = new QFilter("number", "=", (Object)"estimate_programplan_init");
        qfilter.and(new QFilter("createorg", "=", (Object)this.getOrgId()));
        boolean exists = QueryServiceHelper.exists((String)"pdm_planprogram_eco", (QFilter[])new QFilter[]{qfilter});
        if (!exists) {
            qfilter = new QFilter("number", "=", (Object)"effectrange_programplan_init");
            qfilter.and(new QFilter("createorg", "=", (Object)this.getOrgId()));
            exists = QueryServiceHelper.exists((String)"pdm_planprogram_eco", (QFilter[])new QFilter[]{qfilter});
        }
        return exists;
    }

    public boolean checkIsExistsDataByB(Long orgId, Long id) {
        QFilter qfilter = new QFilter("enable", "=", (Object)"1");
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        qfilter.and(new QFilter("estimatetype", "=", (Object)"B"));
        qfilter.and(new QFilter("orgentryentity.entrydemandorg", "=", (Object)this.getOrgId()));
        qfilter.and(new QFilter("id", "<>", (Object)id));
        return QueryServiceHelper.exists((String)"pdm_planprogram_eco", (QFilter[])new QFilter[]{qfilter});
    }
}

