/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.init.impl;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.init.impl.AbstractInitBaseImpl;

public class MatchFilterlInitImpl
extends AbstractInitBaseImpl {
    private static final Log log = LogFactory.getLog(MatchFilterlInitImpl.class);

    public static MatchFilterlInitImpl getInstance(Long org) {
        return new MatchFilterlInitImpl(org);
    }

    @Override
    public String checkData() {
        return "";
    }

    public static Set<String> getMatchFilterNumberSet() {
        HashSet<String> numberSet = new HashSet<String>(64);
        numberSet.add("om_mftstock");
        numberSet.add("om_mftstock_r");
        numberSet.add("pom_mftstock");
        numberSet.add("pom_mftstock_r");
        numberSet.add("sfc_manftech");
        numberSet.add("sfc_manftech_s");
        return numberSet;
    }

    @Override
    public boolean checkIsExistsData() {
        QFilter qfilter = new QFilter("number", "in", MatchFilterlInitImpl.getMatchFilterNumberSet());
        return QueryServiceHelper.exists((String)this.getEntityNumber(), (QFilter[])new QFilter[]{qfilter});
    }

    public MatchFilterlInitImpl(Long orgId) {
        this.setOrgId(orgId);
        this.setEntityNumber("pdm_ecorequirefilter");
    }

    @Override
    public String execSqlData() {
        String errorMsg = "";
        try (TXHandle required = TX.requiresNew((String)"MatchFilterlInitBusiness-execSqlData");){
            try {
                errorMsg = this.updateModelSqlData();
                if (!StringUtils.isEmpty((String)errorMsg)) {
                    required.markRollback();
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                errorMsg = "error:" + e.getMessage();
                required.markRollback();
            }
        }
        if (StringUtils.isEmpty((String)errorMsg)) {
            this.clearCache();
        }
        return errorMsg;
    }

    private String updateModelSqlData() {
        Set<String> numberSet;
        String errorMsg = "";
        int sqlLoop = 0;
        String fileName = "";
        DBRoute dbRoute = this.getScmDBRoute();
        Date currentTime = new Date();
        Long currentUserId = RequestContext.get().getCurrUserId();
        try {
            numberSet = MatchFilterlInitImpl.getMatchFilterNumberSet();
            for (String number : numberSet) {
                fileName = "matchfilter_" + number;
                sqlLoop = this.execSqlFieldData(dbRoute, fileName, sqlLoop, true);
                DB.execute((DBRoute)dbRoute, (String)"update t_pdm_ecorequirefillter set FMODIFIERID = ?,FMODIFYTIME = ? where fnumber = ? ", (Object[])new Object[]{currentUserId, currentTime, number});
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            errorMsg = String.format(ResManager.loadKDString((String)"\u6267\u884c\u5de5\u7a0b\u53d8\u66f4\u5339\u914d\u7ef4\u5ea6\u811a\u672c\u6587\u4ef6[%1$s]\u91cc\u7684\u521d\u59cb\u5316\u8bed\u53e5\u5931\u8d25\uff0c\u5f53\u524d\u6267\u884c\u5e8f\u53f7\uff1a%2$s\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a%3$s", (String)"MatchFilterlInitImpl_01", (String)"mmc-pdm-business", (Object[])new Object[0]), fileName, sqlLoop, e.getMessage());
            return errorMsg;
        }
        try {
            numberSet = MatchFilterlInitImpl.getMatchFilterNumberSet();
            for (String number : numberSet) {
                fileName = "matchfilter_" + number + "_updatelargetext";
                sqlLoop = this.execSqlFieldData(dbRoute, fileName, sqlLoop, false);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            errorMsg = String.format(ResManager.loadKDString((String)"\u6267\u884c\u5de5\u7a0b\u53d8\u66f4\u5339\u914d\u7ef4\u5ea6\u811a\u672c\u6587\u4ef6[%1$s]\u91cc\u7684\u521d\u59cb\u5316\u8bed\u53e5\u5931\u8d25\uff0c\u5f53\u524d\u6267\u884c\u5e8f\u53f7\uff1a%2$s\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a%3$s", (String)"MatchFilterlInitImpl_01", (String)"mmc-pdm-business", (Object[])new Object[0]), fileName, sqlLoop, e.getMessage());
            return errorMsg;
        }
        return "";
    }
}

