/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.mftbom.batch;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.pdm.common.util.CheckBOMUtils;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.MaterialUtil;

public class BatchBomEditBusiness {
    private static final Log logger = LogFactory.getLog(BatchBomEditBusiness.class);
    private static final String MASTERID = "masterid";
    private static final String CONFIG_CODE = "entryconfiguredcode";
    private static final String CHANGETYPE = "changetype";
    private static final String NEW_ENTRYMATERIAL = "new_entrymaterial";
    private static final String NEW_ENTRYMATERIAL_ID = "new_entrymaterialid";
    private static final String NEW_ENTRYVERSION = "new_entryversion";
    private static final String NEW_ENTRYAUXPROPERTY = "new_entryauxproperty";
    private Map<String, List<DynamicObject>> bomEntryRepalceMap = new HashMap<String, List<DynamicObject>>(32);
    public static final String PROP_ENTRYCONFIGPROPERTIES = "configproperties";

    public Map<String, List<DynamicObject>> getBomEntryRepalceMap() {
        return this.bomEntryRepalceMap;
    }

    public static void showTabPageWS(IFormView fv, IDataModel dm, int entryRowIndex) {
        String suffix = "_ws";
        DynamicObject entryObj = dm.getEntryRowEntity("entry", entryRowIndex);
        if (entryObj == null) {
            fv.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u7ec4\u4ef6\u3002", (String)"BatchBomEditBusiness_21", (String)"mmc-pdm-business", (Object[])new Object[0]));
            fv.setVisible(Boolean.valueOf(false), new String[]{"flex_workstation"});
            return;
        }
        dm.beginInit();
        dm.setValue("entrymaterial" + suffix, entryObj.get("entrymaterial"));
        dm.setValue("entryunit" + suffix, entryObj.get("entryunit"));
        dm.beginInit();
        fv.updateView("workstationtab");
        fv.updateView("fsp_workstation");
        fv.setVisible(Boolean.valueOf(true), new String[]{"flex_workstation"});
    }

    public static void showTabPage(IFormView fv, IDataModel dm, int entryRowIndex, String tabPageKey) {
        String suffix = "";
        if ("tabpage_matchctlentry".equals(tabPageKey)) {
            suffix = "_optctl";
        }
        if ("tabpage_chararule".equals(tabPageKey)) {
            suffix = "_rulctl";
        }
        DynamicObject entryObj = dm.getEntryRowEntity("entry", entryRowIndex);
        dm.beginInit();
        dm.setValue("entryseq" + suffix, (Object)(entryRowIndex + 1));
        dm.setValue("entrymaterial" + suffix, entryObj.get("entrymaterialid"));
        dm.setValue("entryunit" + suffix, entryObj.get("entryunit"));
        dm.beginInit();
        if ("_optctl".equals(suffix)) {
            BatchBomEditBusiness.showMatchCtlEntry(fv, dm, suffix, entryObj, entryRowIndex);
        }
        if ("_rulctl".equals(suffix)) {
            dm.setValue(CHANGETYPE + suffix, entryObj.get(CHANGETYPE));
        }
        fv.updateView("tabpage_matchctlentry");
        fv.updateView("fsp_chararule");
    }

    private static void showMatchCtlEntry(IFormView fv, IDataModel dm, String suffix, DynamicObject entryObj, int entryRowIndex) {
        dm.beginInit();
        dm.setValue("opt" + suffix, entryObj.get("opt"));
        dm.setValue("preferopt" + suffix, entryObj.get("preferopt"));
        dm.setValue("mutuexcopt" + suffix, entryObj.get("mutuexcopt"));
        dm.setValue("qtyopt" + suffix, entryObj.get("qtyopt"));
        dm.setValue("maxqtyopt" + suffix, entryObj.get("maxqtyopt"));
        dm.setValue("minqtyopt" + suffix, entryObj.get("minqtyopt"));
        dm.beginInit();
        DynamicObject entryMatoBJ = (DynamicObject)dm.getValue("entrymaterialid", entryRowIndex);
        if (entryMatoBJ == null) {
            fv.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7ec4\u4ef6\u7f16\u7801\u3002", (String)"BatchBomEditBusiness_22", (String)"mmc-pdm-business", (Object[])new Object[0]));
            return;
        }
        String configProperties = entryMatoBJ.getString(PROP_ENTRYCONFIGPROPERTIES);
        if ("2".equals(configProperties) || "3".equals(configProperties)) {
            fv.setEnable(Boolean.FALSE, new String[]{"opt_optctl"});
            fv.setEnable(Boolean.FALSE, new String[]{"preferopt_optctl"});
        } else {
            fv.setEnable(Boolean.TRUE, new String[]{"opt_optctl"});
            fv.setEnable(Boolean.TRUE, new String[]{"preferopt_optctl"});
        }
    }

    public void setEntryMaterialInfoByMaterial(IFormView fv, IDataModel dm, Long changeOrg, ChangeData changeData, String propertyName, String bomMFTInfoFiled) {
        Object newValue = changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        if (changeOrg <= 0L || newValue == null) {
            return;
        }
        if (NEW_ENTRYMATERIAL.equals(bomMFTInfoFiled)) {
            dm.setValue(NEW_ENTRYVERSION, null, rowIndex);
            dm.setValue(NEW_ENTRYAUXPROPERTY, null, rowIndex);
        } else {
            dm.setValue("entryversion", null, rowIndex);
            dm.setValue("entryauxproperty", null, rowIndex);
        }
        DynamicObject matObj = (DynamicObject)newValue;
        String changeType = MMCUtils.getDataModelStringData((IDataModel)dm, (String)CHANGETYPE, (int)changeData.getRowIndex());
        long matId = matObj.getLong("id");
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)changeOrg);
        QFilter matFilter = new QFilter(MASTERID, "=", (Object)matId);
        DynamicObject matInfo = BusinessDataServiceHelper.loadSingle((String)"bd_materialmftinfo", (QFilter[])new QFilter[]{orgFilter, matFilter});
        this.setEntryAuxPropertyMult(fv, dm, changeType, matObj, propertyName, rowIndex, changeOrg);
        if (!"C".equals(changeType) || !"entrymaterialid".equals(propertyName)) {
            DynamicObject baiscObj = matObj.getDynamicObject("baseunit");
            String configproperties = matObj.getString(PROP_ENTRYCONFIGPROPERTIES);
            dm.setValue("entryunit", (Object)baiscObj, rowIndex);
            dm.setValue("entryisjumplevel", (Object)false, rowIndex);
            dm.setValue("entryisbackflush", (Object)"A", rowIndex);
            dm.setValue("entryissuemode", (Object)"11010", rowIndex);
            dm.setValue(PROP_ENTRYCONFIGPROPERTIES, (Object)configproperties, rowIndex);
            if (matInfo != null) {
                String materialattr = matInfo.getString("materialattr");
                dm.setValue("entrymaterialattr", (Object)matInfo.getString("materialattr"), rowIndex);
                if ("10020".equals(materialattr)) {
                    dm.setValue("entryisjumplevel", (Object)"1");
                }
            }
        }
        dm.setValue(bomMFTInfoFiled, (Object)matInfo, rowIndex);
    }

    private void setEntryAuxPropertyMult(IFormView fv, IDataModel dm, String changeType, DynamicObject matObj, String propertyName, int rowIndex, Long changeOrg) {
        String auxFieldName = "entryauxproperty";
        DynamicObject createOrgObj = BusinessDataServiceHelper.loadSingle((Object)changeOrg, (String)"bos_org");
        boolean isAuxpMustInput = CheckBOMUtils.isAuxpMustInput((DynamicObject)matObj, null, (DynamicObject)createOrgObj);
        boolean isEnableAux = MaterialUtil.isUseAuxpty((DynamicObject)matObj);
        if (StringUtils.equals((CharSequence)changeType, (CharSequence)"C")) {
            switch (propertyName) {
                case "entrymaterialid": {
                    auxFieldName = "entryauxproperty";
                    break;
                }
                case "new_entrymaterialid": {
                    auxFieldName = NEW_ENTRYAUXPROPERTY;
                    break;
                }
            }
            BatchBomEditBusiness.setEntryAuxProperty(fv, dm, auxFieldName, isEnableAux, isAuxpMustInput, rowIndex);
        } else {
            BatchBomEditBusiness.setEntryAuxProperty(fv, dm, auxFieldName, isEnableAux, isAuxpMustInput, rowIndex);
        }
    }

    private static void setEntryAuxProperty(IFormView fv, IDataModel dm, String auxFieldName, boolean isEnableAux, boolean isAUXPTY, int rowIndex) {
        if (fv == null || dm == null || rowIndex < 0) {
            return;
        }
        dm.setValue(auxFieldName, null, rowIndex);
        fv.setEnable(Boolean.valueOf(isEnableAux), rowIndex, new String[]{auxFieldName});
        BatchBomEditBusiness.setControlMustInput(fv, auxFieldName, "", isAUXPTY, rowIndex);
        fv.updateView(auxFieldName, rowIndex);
    }

    public static void setControlMustInput(IFormView fv, String controlName, String tip, boolean isMustInput, int index) {
        FieldEdit fieldEdit = (FieldEdit)fv.getFlexControl(controlName, index);
        if (fieldEdit != null) {
            IDataEntityProperty dp = fieldEdit.getProperty();
            FieldProp var10000 = dp instanceof FieldProp ? (FieldProp)dp : null;
            if (dp instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)dp;
            } else {
                var10000 = null;
            }
            HashMap<String, String> itemMap = new HashMap<String, String>(1);
            HashMap<String, HashMap<String, String>> ctlMap = new HashMap<String, HashMap<String, String>>(1);
            fieldEdit.setMustInput(isMustInput);
            itemMap.put("emptytip", tip);
            ctlMap.put("item", itemMap);
            fv.updateControlMetadata(controlName, ctlMap);
        }
    }

    public void initRuleAndWorkControlV(IFormView fv, String changType) {
        if (fv == null) {
            return;
        }
        switch (changType) {
            case "A": 
            case "B": 
            case "F": 
            case "H": {
                fv.setVisible(Boolean.valueOf(true), new String[]{"tabpage_chararule"});
                fv.setVisible(Boolean.valueOf(true), new String[]{"workstationtab"});
                break;
            }
            case "C": 
            case "D": 
            case "E": 
            case "G": {
                fv.setVisible(Boolean.valueOf(false), new String[]{"tabpage_chararule"});
                fv.setVisible(Boolean.valueOf(false), new String[]{"workstationtab"});
                break;
            }
        }
    }

    public boolean handleDelEntry(DynamicObject bomInfo, DynamicObject delEntry, StringBuilder logEntryErrorMsg, List<String> modifyField, String opType, DynamicObject changeOrgDO) {
        if (bomInfo == null || delEntry == null) {
            return false;
        }
        DynamicObject modifyMateril = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)delEntry, (String)"entrymaterialid");
        String modifyMaterilNumber = MMCUtils.getDynamicObjectStringData((DynamicObject)modifyMateril, (String)"number");
        DynamicObjectCollection entryDOC = bomInfo.getDynamicObjectCollection("entry");
        DynamicObjectCollection modifyBomEntryDOC = new DynamicObjectCollection();
        String bomNumber = bomInfo.getString("number");
        if (entryDOC == null) {
            logEntryErrorMsg.append(this.getOpTypeMsg(opType));
            logEntryErrorMsg.append(String.format(ResManager.loadKDString((String)"\u5931\u8d25\uff0c%1$s\u4e0d\u5b58\u5728\u5206\u5f55\u3002", (String)"BatchBomEditBusiness_23", (String)"mmc-pdm-business", (Object[])new Object[0]), bomNumber));
            return false;
        }
        boolean existEntry = this.checkBomExistEntry(entryDOC, delEntry, modifyBomEntryDOC, opType);
        if (existEntry) {
            logEntryErrorMsg.append(this.getOpTypeMsg(opType));
            logEntryErrorMsg.append(String.format(ResManager.loadKDString((String)"\u5931\u8d25\uff0c%1$s\u5728BOM\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"BatchBomEditBusiness_24", (String)"mmc-pdm-business", (Object[])new Object[0]), modifyMaterilNumber));
            return false;
        }
        boolean confCode = this.checkBomEntryConfCode(delEntry, modifyBomEntryDOC);
        if (confCode) {
            logEntryErrorMsg.append(this.getOpTypeMsg(opType));
            logEntryErrorMsg.append(String.format(ResManager.loadKDString((String)"\u5931\u8d25\uff0c%1$s\u5bf9\u5e94\u914d\u7f6e\u5728BOM\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"BatchBomEditBusiness_25", (String)"mmc-pdm-business", (Object[])new Object[0]), modifyMaterilNumber));
            return false;
        }
        DynamicObject bomTypeDO = bomInfo.getDynamicObject("type");
        boolean isVersion = bomTypeDO.getBoolean("isversion");
        for (DynamicObject modifyBomEntryDO : modifyBomEntryDOC) {
            int seq;
            String checkValidDate = CheckBOMUtils.checkValidDate((DynamicObject)modifyBomEntryDO, (int)(seq = MMCUtils.getDynamicObjectIntegerData((DynamicObject)modifyBomEntryDO, (String)"seq").intValue()));
            if (!StringUtils.isEmpty((CharSequence)checkValidDate)) {
                logEntryErrorMsg.append(this.getOpTypeMsg(opType));
                logEntryErrorMsg.append(ResManager.loadKDString((String)"\u5931\u8d25\uff0c\u53d8\u66f4\u540e", (String)"BatchBomEditBusiness_11", (String)"mmc-pdm-business", (Object[])new Object[0])).append(checkValidDate);
                return false;
            }
            String entryInfo = CheckBOMUtils.checkEntry((DynamicObject)modifyBomEntryDO, (boolean)isVersion, (int)seq, (DynamicObject)changeOrgDO);
            if (StringUtils.isBlank((CharSequence)entryInfo)) continue;
            logEntryErrorMsg.append(this.getOpTypeMsg(opType));
            logEntryErrorMsg.append(ResManager.loadKDString((String)"\u540e\uff0cBOM", (String)"BatchBomEditBusiness_12", (String)"mmc-pdm-business", (Object[])new Object[0])).append(entryInfo);
            return false;
        }
        this.handleBomEntry(bomInfo, delEntry, opType, modifyBomEntryDOC, modifyField);
        return true;
    }

    private void handleBomEntry(DynamicObject bomInfo, DynamicObject batchEntry, String opType, DynamicObjectCollection opEntryDOC, List<String> modifyField) {
        DynamicObjectCollection bomEntryDOC = bomInfo.getDynamicObjectCollection("entry");
        DataEntityPropertyCollection properties = bomEntryDOC.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection newEntryProperties = batchEntry.getDynamicObjectType().getProperties();
        DynamicObjectType dynamicObjectType = bomEntryDOC.getDynamicObjectType();
        this.handleQtyEntryPK(batchEntry.getDynamicObjectCollection("qtyentry"));
        String bomNumber = bomInfo.getString("number");
        switch (opType) {
            case "E": 
            case "G": {
                this.bomInfoDelEntry(opEntryDOC, bomEntryDOC, bomNumber);
                break;
            }
            case "F": {
                this.bomInfoAddFeatureType(bomEntryDOC, properties, batchEntry, newEntryProperties);
                break;
            }
            case "H": {
                this.bomInfoUpdateFeatureType(opEntryDOC, bomEntryDOC, batchEntry, modifyField, properties);
            }
        }
    }

    private void bomInfoUpdateFeatureType(DynamicObjectCollection opEntryDOC, DynamicObjectCollection bomEntryDOC, DynamicObject batchEntry, List<String> modifyField, DataEntityPropertyCollection properties) {
        if (opEntryDOC == null || opEntryDOC.isEmpty()) {
            return;
        }
        int seq = bomEntryDOC.size();
        ArrayList<String> propList = new ArrayList<String>(32);
        modifyField.forEach(fieldName -> {
            if (StringUtils.contains((CharSequence)fieldName, (CharSequence)"_ctrl") || StringUtils.contains((CharSequence)fieldName, (CharSequence)"_qty") || StringUtils.contains((CharSequence)fieldName, (CharSequence)"_set")) {
                propList.add(fieldName.substring(0, fieldName.indexOf("_")));
            } else {
                propList.add((String)fieldName);
            }
        });
        ArrayList<String> mPropList = new ArrayList<String>(32);
        properties.forEach(property -> {
            if (propList.contains(property.getName())) {
                mPropList.add(property.getName());
            }
        });
        propList.add("entrymaterialid");
        logger.info(String.format("\u4fee\u6539\u5b57\u6bb5\uff1a%s", propList.toArray()));
        for (DynamicObject opEntry : opEntryDOC) {
            this.handlePropertyData(mPropList, batchEntry, opEntry, "H");
        }
    }

    private DynamicObject handlePropertyData(List<String> propField, DynamicObject newEntry, DynamicObject opEntry, String opType) {
        if (propField == null || newEntry == null || opEntry == null) {
            return null;
        }
        if (StringUtils.equals((CharSequence)opType, (CharSequence)"C")) {
            DynamicObject replaceMaterial = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)newEntry, (String)NEW_ENTRYMATERIAL);
            DynamicObject replaceVersion = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)newEntry, (String)NEW_ENTRYVERSION);
            DynamicObject replaceAux = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)newEntry, (String)NEW_ENTRYAUXPROPERTY);
            opEntry.set("entrymaterial", (Object)replaceMaterial);
            opEntry.set("entryversion", (Object)replaceVersion);
            opEntry.set("entryauxproperty", (Object)replaceAux);
        }
        for (String field : propField) {
            if ("qtyentry".equals(field) || "setupentry".equals(field) || StringUtils.equals((CharSequence)"subentryentity", (CharSequence)field) || StringUtils.equals((CharSequence)"workstationentry", (CharSequence)field)) {
                Object opQtyEntryObj = opEntry.get(field);
                Object newQtyEntryObj = newEntry.get(field);
                if (!(opQtyEntryObj instanceof DynamicObjectCollection) || !(newQtyEntryObj instanceof DynamicObjectCollection)) continue;
                this.updateChildEntry((DynamicObjectCollection)opQtyEntryObj, (DynamicObjectCollection)newQtyEntryObj, opType);
                continue;
            }
            opEntry.set(field, newEntry.get(field));
        }
        return opEntry;
    }

    private void updateChildEntry(DynamicObjectCollection opQtyEntryDOC, DynamicObjectCollection changeEntry, String type) {
        if (changeEntry == null || opQtyEntryDOC == null) {
            return;
        }
        DataEntityPropertyCollection properties = opQtyEntryDOC.getDynamicObjectType().getProperties();
        if (opQtyEntryDOC.size() > 0) {
            opQtyEntryDOC.clear();
        }
        for (DynamicObject dynamicObject : changeEntry) {
            if (properties == null) continue;
            DynamicObject addRow = opQtyEntryDOC.addNew();
            for (IDataEntityProperty proName : properties) {
                addRow.set(proName, dynamicObject.get(proName));
            }
        }
    }

    public void isConfigCodeEdit(List<String> propList, DynamicObject bomTypeDO) {
        boolean issalebom;
        if (propList == null || propList.isEmpty()) {
            return;
        }
        if (!(bomTypeDO == null || (issalebom = MMCUtils.getDynamicObjectBooleanData((DynamicObject)bomTypeDO, (String)"issalebom").booleanValue()) && propList.contains(CONFIG_CODE))) {
            propList.remove(CONFIG_CODE);
        }
    }

    private void bomInfoDelEntry(DynamicObjectCollection opEntryDOC, DynamicObjectCollection bomEntryDOC, String bomNumber) {
        if (opEntryDOC == null || opEntryDOC.isEmpty()) {
            return;
        }
        for (int i = 0; i < opEntryDOC.size(); ++i) {
            String entryReplaceGroup;
            DynamicObjectCollection removeReplaceEntery;
            String entryType;
            DynamicObject opEntryDO = (DynamicObject)opEntryDOC.get(i);
            if (bomEntryDOC.contains((Object)opEntryDO)) {
                bomEntryDOC.remove((Object)opEntryDO);
            }
            if ("B".equals(entryType = opEntryDO.getString("entrytype")) || (removeReplaceEntery = this.delBomReplaceEntry(entryReplaceGroup = opEntryDO.getString("entryreplacegroup"), bomEntryDOC, bomNumber)).isEmpty()) continue;
            bomEntryDOC.removeAll((Collection)removeReplaceEntery);
        }
    }

    private DynamicObjectCollection delBomReplaceEntry(String replaceGroupNo, DynamicObjectCollection bomEntryDOC, String bomNumber) {
        List bomEntrys = this.bomEntryRepalceMap.getOrDefault(bomNumber, new ArrayList(4));
        DynamicObjectCollection delRow = new DynamicObjectCollection();
        for (DynamicObject entryRow : bomEntryDOC) {
            String bomEntryReplaceGroupNo = entryRow.getString("entryreplacegroup");
            if (!StringUtils.equals((CharSequence)replaceGroupNo, (CharSequence)bomEntryReplaceGroupNo)) continue;
            boolean bomEntryIsReplace = entryRow.getBoolean("entryisreplace");
            bomEntrys.add(entryRow);
            if (bomEntryIsReplace) {
                delRow.add((Object)entryRow);
                continue;
            }
            entryRow.set("entryreplacegroup", (Object)" ");
            entryRow.set("entryreplaceplan", null);
            entryRow.set("entryisreplaceplanmm", (Object)false);
        }
        this.bomEntryRepalceMap.put(bomNumber, bomEntrys);
        return delRow;
    }

    private void bomInfoAddFeatureType(DynamicObjectCollection bomEntryDOC, DataEntityPropertyCollection properties, DynamicObject newEntry, DataEntityPropertyCollection newEntryProperties) {
        if (bomEntryDOC == null) {
            return;
        }
        DynamicObject addNew = bomEntryDOC.addNew();
        for (int i = 0; i < properties.size(); ++i) {
            String proName = ((IDataEntityProperty)properties.get(i)).getName();
            if (StringUtils.equals((CharSequence)"qtyentry", (CharSequence)proName) || StringUtils.equals((CharSequence)"setupentry", (CharSequence)proName) || StringUtils.equals((CharSequence)"subentryentity", (CharSequence)proName) || StringUtils.equals((CharSequence)"workstationentry", (CharSequence)proName)) {
                Object bomQtyEntryObj = addNew.get(proName);
                Object newQtyEntryObj = newEntry.get(proName);
                if (!(bomQtyEntryObj instanceof DynamicObjectCollection) || !(newQtyEntryObj instanceof DynamicObjectCollection)) continue;
                this.addQtyEntry((DynamicObjectCollection)bomQtyEntryObj, (DynamicObjectCollection)newQtyEntryObj);
                continue;
            }
            if (!newEntryProperties.containsKey((Object)proName)) continue;
            if (StringUtils.equals((CharSequence)proName, (CharSequence)"multilanguagetext")) {
                Object multiObj = newEntry.get(proName);
                if (!(multiObj instanceof LocaleDynamicObjectCollection)) continue;
                LocaleDynamicObjectCollection multiDOC = (LocaleDynamicObjectCollection)multiObj;
                for (DynamicObject multiDO : multiDOC) {
                    multiDO.set("pkid", null);
                }
                continue;
            }
            addNew.set(proName, newEntry.get(proName));
        }
        addNew.set("seq", (Object)bomEntryDOC.size());
    }

    private void addQtyEntry(DynamicObjectCollection bomQtyEntry, DynamicObjectCollection newQtyEntry) {
        if (newQtyEntry == null || bomQtyEntry == null) {
            return;
        }
        DataEntityPropertyCollection properties = bomQtyEntry.getDynamicObjectType().getProperties();
        for (DynamicObject dynamicObject : newQtyEntry) {
            DynamicObject addRow = bomQtyEntry.addNew();
            for (IDataEntityProperty proName : properties) {
                if (StringUtils.equals((CharSequence)"id", (CharSequence)proName.getName())) {
                    addRow.set(proName, null);
                    continue;
                }
                addRow.set(proName, dynamicObject.get(proName));
            }
        }
    }

    private void handleQtyEntryPK(DynamicObjectCollection dynamicObjectCollection) {
        if (dynamicObjectCollection == null) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            dynamicObject.set("id", null);
        }
    }

    public String getOpTypeMsg(String opKey) {
        String tips = "";
        switch (opKey) {
            case "A": {
                tips = ResManager.loadKDString((String)"\u65b0\u589e\u7ec4\u4ef6", (String)"BatchBomEditBusiness_0", (String)"mmc-pdm-business", (Object[])new Object[0]);
                break;
            }
            case "B": {
                tips = ResManager.loadKDString((String)"\u4fee\u6539\u7ec4\u4ef6", (String)"BatchBomEditBusiness_1", (String)"mmc-pdm-business", (Object[])new Object[0]);
                break;
            }
            case "C": {
                tips = ResManager.loadKDString((String)"\u66ff\u6362\u7ec4\u4ef6", (String)"BatchBomEditBusiness_2", (String)"mmc-pdm-business", (Object[])new Object[0]);
                break;
            }
            case "D": {
                tips = ResManager.loadKDString((String)"\u5931\u6548\u7ec4\u4ef6", (String)"BatchBomEditBusiness_3", (String)"mmc-pdm-business", (Object[])new Object[0]);
                break;
            }
            case "E": {
                tips = ResManager.loadKDString((String)"\u5220\u9664\u7ec4\u4ef6", (String)"BatchBomEditBusiness_4", (String)"mmc-pdm-business", (Object[])new Object[0]);
                break;
            }
            case "F": {
                tips = ResManager.loadKDString((String)"\u65b0\u589e\u9009\u9879\u7c7b", (String)"BatchBomEditBusiness_5", (String)"mmc-pdm-business", (Object[])new Object[0]);
                break;
            }
            case "G": {
                tips = ResManager.loadKDString((String)"\u5220\u9664\u9009\u9879\u7c7b", (String)"BatchBomEditBusiness_6", (String)"mmc-pdm-business", (Object[])new Object[0]);
                break;
            }
            case "H": {
                tips = ResManager.loadKDString((String)"\u4fee\u6539\u9009\u9879\u7c7b", (String)"BatchBomEditBusiness_7", (String)"mmc-pdm-business", (Object[])new Object[0]);
            }
        }
        return tips;
    }

    public boolean checkBomEntryConfCode(DynamicObject modifyEntry, DynamicObjectCollection modifyBomEntryDOC) {
        boolean flag = true;
        if (modifyEntry == null || modifyBomEntryDOC == null) {
            return flag;
        }
        DynamicObjectCollection mutexDOC = new DynamicObjectCollection();
        DynamicObject confCodeDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)modifyEntry, (String)CONFIG_CODE);
        long confCodePK = MMCUtils.getDynamicObjectPK((DynamicObject)confCodeDO);
        for (DynamicObject mEntryDO : modifyBomEntryDOC) {
            DynamicObject bomConfCodeDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)mEntryDO, (String)CONFIG_CODE);
            long bomConfCodePK = MMCUtils.getDynamicObjectPK((DynamicObject)bomConfCodeDO);
            if (bomConfCodePK == confCodePK) {
                flag = false;
                continue;
            }
            mutexDOC.add((Object)mEntryDO);
        }
        for (DynamicObject mutexDO : mutexDOC) {
            modifyBomEntryDOC.remove((Object)mutexDO);
        }
        return flag;
    }

    public boolean checkBomExistEntry(DynamicObjectCollection bomEntry, DynamicObject modifyEntry, DynamicObjectCollection modifyEntryDOC, String opKey) {
        if (bomEntry == null || modifyEntry == null) {
            return true;
        }
        boolean resultFlag = true;
        DynamicObject modifyMaterial = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)modifyEntry, (String)"entrymaterial");
        long mMaterialNumber = MMCUtils.getDynamicObjectPK((DynamicObject)modifyMaterial);
        DynamicObject modifyVersion = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)modifyEntry, (String)"entryversion");
        long mVersionNumber = MMCUtils.getDynamicObjectPK((DynamicObject)modifyVersion);
        DynamicObject modifyAuxproAO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)modifyEntry, (String)"entryauxproperty");
        long mAuxproAONumber = MMCUtils.getDynamicObjectPK((DynamicObject)modifyAuxproAO);
        StringBuilder modifyEntryStr = new StringBuilder();
        modifyEntryStr.append(mMaterialNumber).append(mVersionNumber).append(mAuxproAONumber);
        for (DynamicObject entry : bomEntry) {
            DynamicObject entryMaterial = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entrymaterial");
            long eMaterialNumber = MMCUtils.getDynamicObjectPK((DynamicObject)entryMaterial);
            DynamicObject entryVersion = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entryversion");
            long eVersionNumber = MMCUtils.getDynamicObjectPK((DynamicObject)entryVersion);
            DynamicObject entryAuxproAO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entryauxproperty");
            long eAuxproAONumber = MMCUtils.getDynamicObjectPK((DynamicObject)entryAuxproAO);
            StringBuilder entryEntryStr = new StringBuilder();
            entryEntryStr.append(eMaterialNumber).append(eVersionNumber).append(eAuxproAONumber);
            boolean isRepalce = MMCUtils.getDynamicObjectBooleanData((DynamicObject)entry, (String)"entryisreplace");
            if (!StringUtils.equals((CharSequence)modifyEntryStr, (CharSequence)entryEntryStr) || isRepalce) continue;
            boolean validdate = this.checkBomEntryValidDate(modifyEntry, entry, opKey);
            DynamicObject copyEntry = entry;
            if (validdate) continue;
            resultFlag = false;
            modifyEntryDOC.add((Object)copyEntry);
        }
        return resultFlag;
    }

    public boolean checkBomEntryValidDate(DynamicObject modifyEntry, DynamicObject bomEntry, String opKey) {
        if (modifyEntry == null || bomEntry == null) {
            return true;
        }
        boolean resultFlag = true;
        Date modifVaildDate = MMCUtils.getDynamicObjectDateData((DynamicObject)modifyEntry, (String)"entryvaliddate");
        Date bomEntryValidDate = MMCUtils.getDynamicObjectDateData((DynamicObject)bomEntry, (String)"entryvaliddate");
        Date bomEntryInvalidDate = MMCUtils.getDynamicObjectDateData((DynamicObject)bomEntry, (String)"entryinvaliddate");
        if (!modifVaildDate.before(bomEntryValidDate) && !modifVaildDate.after(bomEntryInvalidDate)) {
            if (StringUtils.equals((CharSequence)opKey, (CharSequence)"D")) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(modifVaildDate);
                int second = calendar.get(13) - 1;
                calendar.set(13, second);
                Date invalidDate = calendar.getTime();
                bomEntry.set("entryinvaliddate", (Object)invalidDate);
                logger.info(String.format("\u5931\u6548\u7ec4\u4ef6\uff1a\u539f\u5931\u6548\u65f6\u95f4\u4e3a%s\uff0c\u5931\u6548\u64cd\u4f5c\u540e\u5931\u6548\u65f6\u95f4\u4e3a%s\uff1b", bomEntryInvalidDate, invalidDate));
            }
            resultFlag = false;
        }
        return resultFlag;
    }

    public boolean handleFeatureTypeEntry(Long changeOrg, DynamicObject bomInfo, DynamicObject newFeatureTypeEntry, StringBuilder logEntryErrorMsg, List<String> modifyField, String opType, DynamicObject changeOrgDO) {
        if (bomInfo == null || newFeatureTypeEntry == null) {
            return false;
        }
        if (logEntryErrorMsg == null) {
            logEntryErrorMsg = new StringBuilder();
        }
        DynamicObjectCollection entryDOC = bomInfo.getDynamicObjectCollection("entry");
        DynamicObjectCollection modifyBomEntryDOC = new DynamicObjectCollection();
        DynamicObject bomTypeDO = bomInfo.getDynamicObject("type");
        boolean isVersion = bomTypeDO.getBoolean("isversion");
        int row = newFeatureTypeEntry.getInt("seq");
        DynamicObject materialOrFeatureTypeDO = null;
        String materialOrFeatureTypeNumber = "";
        String tipsMsg = "";
        switch (opType) {
            case "A": 
            case "B": 
            case "C": 
            case "D": 
            case "E": {
                materialOrFeatureTypeDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)newFeatureTypeEntry, (String)"entrymaterialid");
                materialOrFeatureTypeNumber = MMCUtils.getDynamicObjectStringData((DynamicObject)materialOrFeatureTypeDO, (String)"number");
                tipsMsg = ResManager.loadKDString((String)"\u7ec4\u4ef6\u7f16\u7801", (String)"BatchBomEditBusiness_14", (String)"mmc-pdm-business", (Object[])new Object[0]);
                break;
            }
            case "F": 
            case "G": 
            case "H": {
                materialOrFeatureTypeDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)newFeatureTypeEntry, (String)"featuretype");
                materialOrFeatureTypeNumber = MMCUtils.getDynamicObjectStringData((DynamicObject)materialOrFeatureTypeDO, (String)"name");
                tipsMsg = ResManager.loadKDString((String)"\u9009\u9879\u7c7b", (String)"BatchBomEditBusiness_15", (String)"mmc-pdm-business", (Object[])new Object[0]);
            }
        }
        if (this.checkHeaderEntryRepeat(bomInfo, newFeatureTypeEntry, opType)) {
            logEntryErrorMsg.append(this.getOpTypeMsg(opType));
            logEntryErrorMsg.append(String.format(ResManager.loadKDString((String)"\u5931\u8d25\uff0c\u7b2c\u201c%1$s\u201d\u884c\u201c%2$s\u201d\u201c%3$s\u201d\u4e0eBOM\u4e3b\u4ea7\u54c1\u4e00\u81f4\u3002", (String)"BatchBomEditBusiness_13", (String)"mmc-pdm-business", (Object[])new Object[0]), row, tipsMsg, materialOrFeatureTypeNumber));
            return false;
        }
        Boolean coIsProduct = MMCUtils.getDynamicObjectBooleanData((DynamicObject)bomInfo, (String)"iscoproduct");
        boolean checkCoProduct = false;
        if (coIsProduct.booleanValue()) {
            DynamicObjectCollection coProductDOC = bomInfo.getDynamicObjectCollection("copentry");
            DynamicObject bomVersionDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)bomInfo, (String)"version");
            checkCoProduct = this.checkNewEntryCoproduct(coProductDOC, newFeatureTypeEntry, bomVersionDO, opType);
        }
        if (checkCoProduct) {
            logEntryErrorMsg.append(this.getOpTypeMsg(opType));
            logEntryErrorMsg.append(String.format(ResManager.loadKDString((String)"\u5931\u8d25\uff0c\u7b2c\u201c%1$s\u201d\u201c%2$s\u201d\u201c%3$s\u201d\u4e0eBOM\u4e3b\u4ea7\u54c1\u4e00\u81f4\u3002", (String)"BatchBomEditBusiness_16", (String)"mmc-pdm-business", (Object[])new Object[0]), row, tipsMsg, materialOrFeatureTypeNumber));
            return false;
        }
        modifyBomEntryDOC = this.findHandleEntryToBOM(entryDOC, newFeatureTypeEntry, opType);
        if ((modifyBomEntryDOC == null || modifyBomEntryDOC.isEmpty()) && !this.writeFailTips(logEntryErrorMsg, opType, row, tipsMsg, materialOrFeatureTypeNumber)) {
            return false;
        }
        String entryInfo = CheckBOMUtils.checkEntry((DynamicObject)newFeatureTypeEntry, (boolean)isVersion, (int)row, (DynamicObject)changeOrgDO);
        if (!StringUtils.isBlank((CharSequence)entryInfo)) {
            logEntryErrorMsg.append(entryInfo);
            return false;
        }
        this.handleBomEntry(bomInfo, newFeatureTypeEntry, opType, modifyBomEntryDOC, modifyField);
        return true;
    }

    private boolean writeFailTips(StringBuilder logEntryErrorMsg, String opType, int row, String tipsMsg, String materialOrFeatureTypeNumber) {
        if (logEntryErrorMsg == null) {
            return true;
        }
        if (StringUtils.equals((CharSequence)"H", (CharSequence)opType) || StringUtils.equals((CharSequence)"G", (CharSequence)opType)) {
            logEntryErrorMsg.append(this.getOpTypeMsg(opType));
            logEntryErrorMsg.append(String.format(ResManager.loadKDString((String)"\u5931\u8d25\uff0c\u7b2c\u201c%1$s\u201d\u884c\u201c%2$s\u201d\u201c%3$s\u201d\u5728BOM\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"BatchBomEditBusiness_18", (String)"mmc-pdm-business", (Object[])new Object[0]), row, tipsMsg, materialOrFeatureTypeNumber));
            return false;
        }
        return true;
    }

    private DynamicObjectCollection findHandleEntryToBOM(DynamicObjectCollection bomEntryDOC, DynamicObject batchEntryDO, String opType) {
        DynamicObjectCollection handleEntryDOC = new DynamicObjectCollection();
        if (bomEntryDOC == null || StringUtils.equals((CharSequence)"F", (CharSequence)opType) || StringUtils.equals((CharSequence)"A", (CharSequence)opType)) {
            return handleEntryDOC;
        }
        DynamicObject batchEntryFeatureTypeDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)batchEntryDO, (String)"featuretype");
        DynamicObject batchEntryMaterialDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)batchEntryDO, (String)"entrymaterialid");
        for (DynamicObject bomEntryDO : bomEntryDOC) {
            DynamicObject bomEntryFeatureTypeDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)bomEntryDO, (String)"featuretype");
            if (!StringUtils.equals((CharSequence)"G", (CharSequence)opType) && !StringUtils.equals((CharSequence)"H", (CharSequence)opType) || batchEntryFeatureTypeDO == null || bomEntryFeatureTypeDO == null) continue;
            Long batchEntryTypePK = MMCUtils.getDynamicObjectPK((DynamicObject)batchEntryFeatureTypeDO);
            Long bomEntryTypePK = MMCUtils.getDynamicObjectPK((DynamicObject)bomEntryFeatureTypeDO);
            if (batchEntryTypePK.longValue() != bomEntryTypePK.longValue()) continue;
            handleEntryDOC.add((Object)bomEntryDO);
        }
        return handleEntryDOC;
    }

    private String getOrgName(Long changeOrg) {
        String org = "";
        try {
            QFilter orgQFilter = new QFilter("id", "in", (Object)changeOrg);
            DynamicObject queryOne = QueryServiceHelper.queryOne((String)"bos_org", (String)"number,name", (QFilter[])new QFilter[]{orgQFilter});
            org = MMCUtils.getDynamicObjectStringData((DynamicObject)queryOne, (String)"name");
            return org;
        }
        catch (KDBizException e) {
            logger.info("query org error, Please contact the system administrator.");
            return org;
        }
    }

    public boolean checkNewEntryCoproduct(DynamicObjectCollection coproductDOC, DynamicObject newEntry, DynamicObject bomVersionDO, String opType) {
        DynamicObject materialInfo;
        if (coproductDOC == null || newEntry == null) {
            return false;
        }
        if (StringUtils.equals((CharSequence)"F", (CharSequence)opType) || StringUtils.equals((CharSequence)"G", (CharSequence)opType) || StringUtils.equals((CharSequence)"H", (CharSequence)opType)) {
            return false;
        }
        String changeType = MMCUtils.getDynamicObjectStringData((DynamicObject)newEntry, (String)CHANGETYPE, (String)"A");
        String materialField = "entrymaterialid";
        if (StringUtils.equals((CharSequence)changeType, (CharSequence)"C")) {
            materialField = NEW_ENTRYMATERIAL_ID;
        }
        if ((materialInfo = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)newEntry, (String)materialField)) == null) {
            return false;
        }
        StringBuilder materialMsg = new StringBuilder();
        materialMsg.append(materialInfo.getPkValue());
        for (DynamicObject coproductInfo : coproductDOC) {
            StringBuilder copMaterialMsg = new StringBuilder();
            DynamicObject copMaterialDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)coproductInfo, (String)"copentrymaterial");
            if (copMaterialDO != null) {
                copMaterialMsg.append(copMaterialDO.getPkValue());
            }
            if (!StringUtils.equals((CharSequence)copMaterialMsg.toString(), (CharSequence)materialMsg.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean checkHeaderEntryRepeat(DynamicObject bomInfo, DynamicObject newEntry, String opType) {
        DynamicObject materialInfo;
        if (bomInfo == null || newEntry == null) {
            return false;
        }
        if (StringUtils.equals((CharSequence)"F", (CharSequence)opType) || StringUtils.equals((CharSequence)"G", (CharSequence)opType) || StringUtils.equals((CharSequence)"H", (CharSequence)opType)) {
            return false;
        }
        String materialField = "entrymaterialid";
        if (StringUtils.equals((CharSequence)opType, (CharSequence)"C")) {
            materialField = NEW_ENTRYMATERIAL_ID;
        }
        if ((materialInfo = newEntry.getDynamicObject(materialField)) == null) {
            return false;
        }
        StringBuilder materialMsg = new StringBuilder();
        StringBuilder bomMsg = new StringBuilder();
        materialMsg.append(materialInfo.getPkValue());
        DynamicObject masterMaterialDO = bomInfo.getDynamicObject("materialid");
        if (masterMaterialDO != null) {
            bomMsg.append(masterMaterialDO.getPkValue());
        }
        return StringUtils.equals((CharSequence)materialMsg.toString(), (CharSequence)bomMsg.toString());
    }

    public void setDefaultValueByFeatureType(IDataModel dm, ChangeData changeData, int rowIndex) {
        Object newValue = changeData.getNewValue();
        if (newValue == null) {
            return;
        }
        DynamicObject featureTypeObj = (DynamicObject)newValue;
        DynamicObject basicUnit = featureTypeObj.getDynamicObject("basicunit");
        dm.setValue("entryunit", (Object)basicUnit);
        dm.setValue("entryisjumplevel", (Object)false, rowIndex);
        dm.setValue("entryisbackflush", (Object)"A", rowIndex);
        dm.setValue("entryissuemode", (Object)"11010", rowIndex);
    }

    public boolean checkBomTypeEntryType(DynamicObject bomDO, String changeTypeParam) {
        boolean isSuccess = false;
        if (bomDO != null) {
            DynamicObject typeDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)bomDO, (String)"type");
            String purpose = MMCUtils.getDynamicObjectStringData((DynamicObject)typeDO, (String)"purpose");
            String configType = MMCUtils.getDynamicObjectStringData((DynamicObject)typeDO, (String)"configtype");
            if (!(!StringUtils.equals((CharSequence)"F", (CharSequence)changeTypeParam) && !StringUtils.equals((CharSequence)"G", (CharSequence)changeTypeParam) && !StringUtils.equals((CharSequence)"H", (CharSequence)changeTypeParam) || StringUtils.equals((CharSequence)"B", (CharSequence)purpose) && StringUtils.equals((CharSequence)"B", (CharSequence)configType))) {
                isSuccess = true;
            }
        }
        return isSuccess;
    }

    public boolean checkBomMatMftInfo(DynamicObject bomTypeDO, DynamicObject changeEntry, String opKey, StringBuilder logEntryErrorMsg, String changeType) {
        boolean isCheckMatMftInfo = false;
        String purpose = MMCUtils.getDynamicObjectStringData((DynamicObject)bomTypeDO, (String)"purpose");
        DynamicObject entryMaterialDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)changeEntry, (String)"entrymaterial");
        DynamicObject materialDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)changeEntry, (String)"entrymaterialid");
        if ("C".equals(changeType)) {
            entryMaterialDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)changeEntry, (String)NEW_ENTRYMATERIAL);
            materialDO = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)changeEntry, (String)NEW_ENTRYMATERIAL_ID);
        }
        if (("A".equals(purpose) || "C".equals(purpose)) && entryMaterialDO == null) {
            String materBumber = MMCUtils.getDynamicObjectStringData((DynamicObject)materialDO, (String)"number");
            int row = MMCUtils.getDynamicObjectIntegerData((DynamicObject)changeEntry, (String)"seq");
            isCheckMatMftInfo = true;
            logEntryErrorMsg.append(String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff0c\u7b2c%2$s\u884c\u7ec4\u4ef6\u7f16\u7801%3$s\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"BatchBomEditBusiness_20", (String)"mmc-pdm-business", (Object[])new Object[0]), this.getOpTypeMsg(opKey), row, materBumber));
        }
        return isCheckMatMftInfo;
    }

    public static String checkEntryLegal(String purpose, DynamicObject entry, String changeType) {
        StringBuilder msg = new StringBuilder();
        if (!"A".equals(purpose)) {
            return msg.toString();
        }
        DynamicObject entryMat = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entrymaterialid");
        if ("C".equals(changeType)) {
            entryMat = MMCUtils.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)NEW_ENTRYMATERIAL_ID);
        }
        String configProp = MMCUtils.getDynamicObjectStringData((DynamicObject)entryMat, (String)PROP_ENTRYCONFIGPROPERTIES);
        String number = MMCUtils.getDynamicObjectStringData((DynamicObject)entryMat, (String)"number");
        if ("2".equals(configProp) || "3".equals(configProp)) {
            msg.append(String.format(ResManager.loadKDString((String)"%1$s\u4e3a\u914d\u7f6e\u4ef6\u6216\u7279\u5f81\u4ef6\uff0c\u5236\u9020BOM\u4e0d\u5141\u8bb8\u7ef4\u62a4\u914d\u7f6e\u4ef6\u6216\u8005\u7279\u5f81\u4ef6\u3002", (String)"BatchBomEditBusiness_19", (String)"mmc-pdm-business", (Object[])new Object[0]), number));
        }
        return msg.toString();
    }
}

