/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.mftbom.bomsearch;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMVersionFilterBusiness;
import kd.mmc.pdm.common.util.MMCUtils;

public class BOMExpandConfigBusiness {
    private static final Log logger = LogFactory.getLog(BOMExpandConfigBusiness.class);
    public static final Long DEF_EXPANDCONFIGID = 1637711947497568256L;

    public static Map<String, TreeMap<Integer, Object>> getBomExpandConfig(long expandConfigId) {
        HashMap<String, TreeMap<Integer, Object>> retMap = new HashMap<String, TreeMap<Integer, Object>>(64);
        QFilter filter = new QFilter("id", "=", (Object)expandConfigId);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        String fields = "id,auxbomtype,verconfig,wbsrule,replacenorule,entryentity.purpose purpose,entryentity.bomtype bomtype,entryentity.priority priority";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BOMExpandConfigBusiness", (String)"mpdm_bomexpandconfig", (String)fields, (QFilter[])new QFilter[]{filter, enable, status}, null);){
            long auxBomType = 0L;
            long bomExpandId = 0L;
            String verconfig = "";
            String wbsrule = "";
            String replacenorule = "";
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String purpose = row.getString("purpose");
                verconfig = row.getString("verconfig");
                wbsrule = row.getString("wbsrule");
                replacenorule = row.getString("replacenorule");
                long bomtype = row.getLong("bomtype");
                bomExpandId = row.getLong("id");
                auxBomType = row.getLong("auxbomtype");
                Integer priority = row.getInteger("priority");
                TreeMap<Integer, Long> treeMap = (TreeMap<Integer, Long>)retMap.get(purpose);
                if (treeMap == null) {
                    treeMap = new TreeMap<Integer, Long>();
                }
                if (!treeMap.containsKey(priority)) {
                    treeMap.put(priority, bomtype);
                }
                retMap.put(purpose, treeMap);
            }
            TreeMap<Integer, Long> auxTreeMap = new TreeMap<Integer, Long>();
            auxTreeMap.put(1, auxBomType);
            retMap.put("auxbomtype", auxTreeMap);
            TreeMap<Integer, Long> idTreeMap = new TreeMap<Integer, Long>();
            idTreeMap.put(1, bomExpandId);
            retMap.put("id", idTreeMap);
            TreeMap<Integer, String> verTreeMap = new TreeMap<Integer, String>();
            verTreeMap.put(1, verconfig);
            retMap.put("verconfig", verTreeMap);
            TreeMap<Integer, String> wbsTreeMap = new TreeMap<Integer, String>();
            wbsTreeMap.put(1, wbsrule);
            retMap.put("wbsrule", wbsTreeMap);
            TreeMap<Integer, String> repTreeMap = new TreeMap<Integer, String>();
            repTreeMap.put(1, replacenorule);
            retMap.put("replacenorule", repTreeMap);
        }
        catch (Exception e) {
            logger.info(e.toString());
            throw e;
        }
        return retMap;
    }

    public static Map<String, TreeMap<Integer, Object>> getBomExpandConfigByConfigPlan(long configPlanId) {
        QFilter filter = new QFilter("id", "=", (Object)configPlanId);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        String fields = "id,bomexpandconfig";
        long expandConfigId = 0L;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BOMExpandConfigBusiness", (String)"pdm_proconfigscheme", (String)fields, (QFilter[])new QFilter[]{filter, enable, status}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long bomExpandIdTmp = row.getLong("bomexpandconfig");
                if (bomExpandIdTmp != 0L) {
                    expandConfigId = bomExpandIdTmp;
                }
                if (expandConfigId == 0L) continue;
                break;
            }
        }
        if (expandConfigId == 0L) {
            return new HashMap<String, TreeMap<Integer, Object>>(1);
        }
        return BOMExpandConfigBusiness.getBomExpandConfig(expandConfigId);
    }

    public static Map<String, TreeMap<Integer, Object>> getBomExpandConfigByNum(String number) {
        HashMap<String, TreeMap<Integer, Object>> retMap = new HashMap<String, TreeMap<Integer, Object>>(64);
        QFilter filter = new QFilter("number", "=", (Object)number);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        String fields = "id,auxbomtype,verconfig,wbsrule,replacenorule,entryentity.purpose purpose,entryentity.bomtype bomtype,entryentity.priority priority";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BOMExpandConfigBusiness", (String)"mpdm_bomexpandconfig", (String)fields, (QFilter[])new QFilter[]{filter, enable, status}, null);){
            long auxBomType = 0L;
            long bomExpandId = 0L;
            String verconfig = "";
            String wbsrule = "";
            String replacenorule = "";
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String purpose = row.getString("purpose");
                verconfig = row.getString("verconfig");
                wbsrule = row.getString("wbsrule");
                replacenorule = row.getString("replacenorule");
                long bomtype = row.getLong("bomtype");
                bomExpandId = row.getLong("id");
                auxBomType = row.getLong("auxbomtype");
                Integer priority = row.getInteger("priority");
                TreeMap<Integer, Long> treeMap = (TreeMap<Integer, Long>)retMap.get(purpose);
                if (treeMap == null) {
                    treeMap = new TreeMap<Integer, Long>();
                }
                if (!treeMap.containsKey(priority)) {
                    treeMap.put(priority, bomtype);
                }
                retMap.put(purpose, treeMap);
            }
            TreeMap<Integer, Long> auxTreeMap = new TreeMap<Integer, Long>();
            auxTreeMap.put(1, auxBomType);
            retMap.put("auxbomtype", auxTreeMap);
            TreeMap<Integer, Long> idTreeMap = new TreeMap<Integer, Long>();
            idTreeMap.put(1, bomExpandId);
            retMap.put("id", idTreeMap);
            TreeMap<Integer, String> verTreeMap = new TreeMap<Integer, String>();
            verTreeMap.put(1, verconfig);
            retMap.put("verconfig", verTreeMap);
            TreeMap<Integer, String> wbsTreeMap = new TreeMap<Integer, String>();
            wbsTreeMap.put(1, wbsrule);
            retMap.put("wbsrule", wbsTreeMap);
            TreeMap<Integer, String> repTreeMap = new TreeMap<Integer, String>();
            repTreeMap.put(1, replacenorule);
            retMap.put("replacenorule", repTreeMap);
        }
        catch (Exception e) {
            logger.info(e.toString());
            throw e;
        }
        return retMap;
    }

    public static Set<Long> getBomTypeOfPurpose(Map<String, TreeMap<Integer, Object>> map, String purpose) {
        if (map == null) {
            return new HashSet<Long>(1);
        }
        HashSet<Long> retSet = new HashSet<Long>(map.size());
        TreeMap<Integer, Object> treeMap = map.get(purpose);
        if (treeMap == null) {
            return retSet;
        }
        Set<Map.Entry<Integer, Object>> entrySet = treeMap.entrySet();
        for (Map.Entry<Integer, Object> entry : entrySet) {
            long bomtypeId = BOMExpandConfigBusiness.getLongValue(entry.getValue());
            retSet.add(bomtypeId);
        }
        if (retSet.isEmpty()) {
            retSet.add(-1L);
        }
        return retSet;
    }

    public static Set<Long> getFirstBomTypeOfPurpose(Map<String, TreeMap<Integer, Object>> map, String materialKeys, Set<Long> queryBomIdSet, Map<String, Set<Long>> cacheBomTypeMap) {
        HashSet<Long> typeSet = new HashSet<Long>(16);
        if (map == null) {
            return typeSet;
        }
        if (cacheBomTypeMap.containsKey(materialKeys)) {
            return cacheBomTypeMap.get(materialKeys);
        }
        block0: for (int i = 0; i < 3; ++i) {
            String purpose = i == 0 ? "A" : (i == 1 ? "B" : "C");
            TreeMap<Integer, Object> treeMap = map.get(purpose);
            if (treeMap == null) continue;
            Set<Map.Entry<Integer, Object>> entrySet = treeMap.entrySet();
            for (Map.Entry<Integer, Object> entry : entrySet) {
                if (!queryBomIdSet.contains(BOMExpandConfigBusiness.getLongValue(entry.getValue()))) continue;
                typeSet.add(BOMExpandConfigBusiness.getLongValue(entry.getValue()));
                continue block0;
            }
        }
        cacheBomTypeMap.put(materialKeys, typeSet);
        return typeSet;
    }

    public static List<Map<String, Object>> priorityFilter(List<Map<String, Object>> dataList, long matId, long auxp, long wbs, long configCode, Map<String, TreeMap<Integer, Object>> expandConfigMap, String purpose, String no) {
        if (dataList == null || dataList.isEmpty() || expandConfigMap == null || expandConfigMap.isEmpty()) {
            return new ArrayList<Map<String, Object>>(1);
        }
        long expandBomType = BOMExpandConfigBusiness.getPriorityBomType(dataList, matId, auxp, configCode, expandConfigMap, purpose, no);
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(128);
        if (expandBomType == -1L) {
            return retList;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            Map<String, Object> dataMap = dataList.get(i);
            long bomType = BOMExpandConfigBusiness.getLongValue(dataMap.get("type" + no));
            if (expandBomType != bomType) continue;
            retList.add(dataMap);
        }
        return retList;
    }

    public static List<Map<String, Object>> firstLevelPriorityFilterByType(List<Map<String, Object>> dataList, Map<String, TreeMap<Integer, Object>> expandConfigMap, String purpose, String no) {
        if (dataList == null || dataList.isEmpty() || expandConfigMap == null || expandConfigMap.isEmpty()) {
            return new ArrayList<Map<String, Object>>(1);
        }
        long expandBomType = BOMExpandConfigBusiness.getFirstLeavePriorityBomType(dataList, expandConfigMap, purpose, no);
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(dataList.size());
        if (expandBomType == -1L) {
            return retList;
        }
        String type = "type" + no;
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> dataMap = dataList.get(i);
            long bomType = BOMExpandConfigBusiness.getLongValue(dataMap.get(type));
            if (expandBomType != bomType) continue;
            retList.add(dataMap);
        }
        return retList;
    }

    public static List<Map<String, Object>> firstLevelPriorityFilterByReplaceNo(List<Map<String, Object>> dataList, Map<String, TreeMap<Integer, Object>> expandConfigMap, long filterReplaceNo, String no) {
        if (dataList == null || dataList.isEmpty()) {
            return new ArrayList<Map<String, Object>>(1);
        }
        String repNp = "replaceno" + no;
        int size = dataList.size();
        ArrayList<Map<String, Object>> retListA = new ArrayList<Map<String, Object>>(size);
        ArrayList<Map<String, Object>> retListB = new ArrayList<Map<String, Object>>(size);
        String replaceConfig = BOMExpandConfigBusiness.getExpandReplaceConfig(expandConfigMap);
        boolean isFullMatch = "A".equals(replaceConfig);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> dataMap = dataList.get(i);
            long replaceno = BOMExpandConfigBusiness.getLongValue(dataMap.get(repNp));
            if (replaceno == filterReplaceNo) {
                retListA.add(dataMap);
            }
            if (replaceno != 0L || filterReplaceNo == 0L) continue;
            retListB.add(dataMap);
        }
        return isFullMatch ? retListA : (retListA.isEmpty() ? retListB : retListA);
    }

    public static List<Map<String, Object>> firstLevelPriorityFilterByWBS(List<Map<String, Object>> dataList, Map<String, TreeMap<Integer, Object>> expandConfigMap, long filterWbsId, String no) {
        if (dataList == null || dataList.isEmpty()) {
            return new ArrayList<Map<String, Object>>(1);
        }
        String wbsNo = "wbs" + no;
        int size = dataList.size();
        ArrayList<Map<String, Object>> retListA = new ArrayList<Map<String, Object>>(size);
        ArrayList<Map<String, Object>> retListB = new ArrayList<Map<String, Object>>(size);
        String wbsRule = BOMExpandConfigBusiness.getExpandWbsRule(expandConfigMap);
        boolean isFullMatch = "A".equals(wbsRule);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> dataMap = dataList.get(i);
            long wbs = BOMExpandConfigBusiness.getLongValue(dataMap.get(wbsNo));
            if (wbs == filterWbsId) {
                retListA.add(dataMap);
            }
            if (wbs != 0L || filterWbsId == 0L) continue;
            retListB.add(dataMap);
        }
        return isFullMatch ? retListA : (retListA.isEmpty() ? retListB : retListA);
    }

    public static DynamicObject firstLevelPriorityFilter(DynamicObject[] dataArray, Map<String, TreeMap<Integer, Object>> expandConfigMap, String purpose) {
        if (dataArray == null || dataArray.length <= 0 || expandConfigMap == null || expandConfigMap.isEmpty()) {
            return null;
        }
        long expandBomType = BOMExpandConfigBusiness.getFirstLeavePriorityBomType(dataArray, expandConfigMap, purpose);
        ArrayList<DynamicObject> retList = new ArrayList<DynamicObject>(128);
        if (expandBomType == -1L) {
            return null;
        }
        for (int i = 0; i < dataArray.length; ++i) {
            long bomType;
            DynamicObject dataObj = dataArray[i];
            DynamicObject typeObj = dataObj.getDynamicObject("type");
            long l = bomType = typeObj == null ? 0L : typeObj.getLong("id");
            if (expandBomType != bomType) continue;
            retList.add(dataObj);
        }
        if (retList.isEmpty()) {
            return null;
        }
        return (DynamicObject)retList.get(0);
    }

    public static DynamicObject bomTypePriorityFilter(DynamicObject[] bomArray, Map<String, TreeMap<Integer, Object>> expandConfigMap, String purpose) {
        if (bomArray == null || bomArray.length <= 0 || expandConfigMap == null || expandConfigMap.isEmpty()) {
            return null;
        }
        DynamicObject retObj = null;
        TreeMap<Integer, Object> bomtypeMap = expandConfigMap.get(purpose);
        Set<Map.Entry<Integer, Object>> entrySet = bomtypeMap.entrySet();
        boolean flag = false;
        for (Map.Entry<Integer, Object> entry : entrySet) {
            long expandBomTypeTmp = BOMExpandConfigBusiness.getLongValue(entry.getValue());
            for (DynamicObject bomObj : bomArray) {
                DynamicObject typeObj = bomObj.getDynamicObject("type");
                long typeId = typeObj.getLong("id");
                if (expandBomTypeTmp != typeId) continue;
                retObj = bomObj;
                flag = true;
                break;
            }
            if (!flag) continue;
            break;
        }
        return retObj;
    }

    public static List<Map<String, Object>> bomTypeFilter(List<Map<String, Object>> dataList, long bomType, String no) {
        if (dataList == null || dataList.isEmpty()) {
            return new ArrayList<Map<String, Object>>(1);
        }
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(dataList.size());
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> dataMap = dataList.get(i);
            long childBomType = (Long)dataMap.get("type" + no);
            if (bomType != childBomType) continue;
            retList.add(dataMap);
        }
        return retList;
    }

    public static long getPriorityBomType(List<Map<String, Object>> dataList, long matId, long auxp, long configCode, Map<String, TreeMap<Integer, Object>> expandConfigMap, String purpose, String no) {
        TreeMap<Integer, Object> bomtypeMap = expandConfigMap.get(purpose);
        if (bomtypeMap == null || bomtypeMap.isEmpty() || dataList.isEmpty()) {
            return -1L;
        }
        Set<Map.Entry<Integer, Object>> entrySet = bomtypeMap.entrySet();
        long expandBomType = -1L;
        String type = "type" + no;
        int size = dataList.size();
        for (Map.Entry<Integer, Object> entry : entrySet) {
            long expandBomTypeTmp = BOMExpandConfigBusiness.getLongValue(entry.getValue());
            for (int i = 0; i < size; ++i) {
                Map<String, Object> dataMap = dataList.get(i);
                long bomType = BOMExpandConfigBusiness.getLongValue(dataMap.get(type));
                long childMaterialId = 0L;
                childMaterialId = dataMap.containsKey("materialId" + no) ? ((Long)dataMap.get("materialId" + no)).longValue() : ((Long)dataMap.get("pmaterial" + no)).longValue();
                long childAuxp = 0L;
                childAuxp = dataMap.containsKey("auxproperty" + no) ? ((Long)dataMap.get("auxproperty" + no)).longValue() : ((Long)dataMap.get("pauxproperty" + no)).longValue();
                long childConfigCode = 0L;
                if (dataMap.containsKey("configCode" + no)) {
                    childConfigCode = (Long)dataMap.get("configCode" + no);
                }
                if (matId != childMaterialId || auxp != childAuxp || configCode != childConfigCode || bomType != expandBomTypeTmp) continue;
                expandBomType = expandBomTypeTmp;
                break;
            }
            if (expandBomType == -1L) continue;
            break;
        }
        return expandBomType;
    }

    public static long getFirstLeavePriorityBomType(List<Map<String, Object>> dataList, Map<String, TreeMap<Integer, Object>> expandConfigMap, String purpose, String no) {
        TreeMap<Integer, Object> bomtypeMap = expandConfigMap.get(purpose);
        if (bomtypeMap == null || bomtypeMap.isEmpty()) {
            return -1L;
        }
        Set<Map.Entry<Integer, Object>> entrySet = bomtypeMap.entrySet();
        long expandBomType = -1L;
        String field = "type" + no;
        int size = dataList.size();
        for (Map.Entry<Integer, Object> entry : entrySet) {
            long expandBomTypeTmp = BOMExpandConfigBusiness.getLongValue(entry.getValue());
            for (int i = 0; i < size; ++i) {
                Map<String, Object> dataMap = dataList.get(i);
                long bomType = BOMExpandConfigBusiness.getLongValue(dataMap.get(field));
                if (bomType != expandBomTypeTmp) continue;
                expandBomType = expandBomTypeTmp;
                break;
            }
            if (expandBomType == -1L) continue;
            break;
        }
        return expandBomType;
    }

    public static long getFirstLeavePriorityBomType(DynamicObject[] dataArray, Map<String, TreeMap<Integer, Object>> expandConfigMap, String purpose) {
        TreeMap<Integer, Object> bomtypeMap = expandConfigMap.get(purpose);
        if (bomtypeMap == null || bomtypeMap.isEmpty()) {
            return -1L;
        }
        Set<Map.Entry<Integer, Object>> entrySet = bomtypeMap.entrySet();
        long expandBomType = -1L;
        for (Map.Entry<Integer, Object> entry : entrySet) {
            long expandBomTypeTmp = BOMExpandConfigBusiness.getLongValue(entry.getValue());
            for (int i = 0; i < dataArray.length; ++i) {
                long bomType;
                DynamicObject dataObj = dataArray[i];
                DynamicObject typeObj = dataObj.getDynamicObject("type");
                long l = bomType = typeObj == null ? 0L : typeObj.getLong("id");
                if (bomType != expandBomTypeTmp) continue;
                expandBomType = expandBomTypeTmp;
                break;
            }
            if (expandBomType == -1L) continue;
            break;
        }
        return expandBomType;
    }

    public static String getExpandVerConfig(Map<String, TreeMap<Integer, Object>> expandConfigMap) {
        if (expandConfigMap == null || expandConfigMap.isEmpty()) {
            return null;
        }
        TreeMap<Integer, Object> verMap = expandConfigMap.get("verconfig");
        if (verMap == null || verMap.isEmpty()) {
            return null;
        }
        String verConfig = String.valueOf(verMap.get(1));
        return verConfig;
    }

    public static String getExpandWbsRule(Map<String, TreeMap<Integer, Object>> expandConfigMap) {
        if (expandConfigMap == null || expandConfigMap.isEmpty()) {
            return null;
        }
        TreeMap<Integer, Object> wbsMap = expandConfigMap.get("wbsrule");
        if (wbsMap == null || wbsMap.isEmpty()) {
            return null;
        }
        String wbsConfig = String.valueOf(wbsMap.get(1));
        return wbsConfig;
    }

    public static String getExpandReplaceConfig(Map<String, TreeMap<Integer, Object>> expandConfigMap) {
        if (expandConfigMap == null || expandConfigMap.isEmpty()) {
            return null;
        }
        TreeMap<Integer, Object> verMap = expandConfigMap.get("replacenorule");
        if (verMap == null || verMap.isEmpty()) {
            return null;
        }
        String repalceConfig = String.valueOf(verMap.get(1));
        return repalceConfig;
    }

    public static List<Map<String, Object>> replaceNoFilter(List<Map<String, Object>> dataList, Map<String, TreeMap<Integer, Object>> bomExpandMap, long replaceNo) {
        if (dataList == null || dataList.isEmpty()) {
            return new ArrayList<Map<String, Object>>(1);
        }
        int size = dataList.size();
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(dataList.size());
        String repConfig = BOMExpandConfigBusiness.getExpandReplaceConfig(bomExpandMap);
        ArrayList<Map<String, Object>> tmpChildList1 = new ArrayList<Map<String, Object>>(size);
        ArrayList<Map<String, Object>> tmpChildList2 = new ArrayList<Map<String, Object>>(size);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> childMap = dataList.get(i);
            long childReplaceNo = (Long)childMap.get("replaceno");
            if (replaceNo == childReplaceNo) {
                tmpChildList1.add(childMap);
            }
            if (childReplaceNo != 0L) continue;
            tmpChildList2.add(childMap);
        }
        if ("A".equals(repConfig)) {
            retList = tmpChildList1;
        } else if ("B".equals(repConfig)) {
            ArrayList<Map<String, Object>> retChildListTmp = tmpChildList1;
            retList = replaceNo != 0L && retChildListTmp.isEmpty() ? tmpChildList2 : retChildListTmp;
        }
        return retList;
    }

    public static List<Map<String, Object>> wbsFilter(List<Map<String, Object>> dataList, Map<String, TreeMap<Integer, Object>> bomExpandMap, long wbs) {
        if (dataList == null || dataList.isEmpty()) {
            return new ArrayList<Map<String, Object>>(1);
        }
        int size = dataList.size();
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(dataList.size());
        String wbsRule = BOMExpandConfigBusiness.getExpandWbsRule(bomExpandMap);
        ArrayList<Map<String, Object>> tmpChildList1 = new ArrayList<Map<String, Object>>(size);
        ArrayList<Map<String, Object>> tmpChildList2 = new ArrayList<Map<String, Object>>(size);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> childMap = dataList.get(i);
            long childWbs = (Long)childMap.get("wbs");
            if (wbs == childWbs) {
                tmpChildList1.add(childMap);
            }
            if (childWbs != 0L) continue;
            tmpChildList2.add(childMap);
        }
        if ("A".equals(wbsRule)) {
            retList = tmpChildList1;
        } else if ("B".equals(wbsRule)) {
            ArrayList<Map<String, Object>> retChildListTmp = tmpChildList1;
            retList = wbs != 0L && retChildListTmp.isEmpty() ? tmpChildList2 : retChildListTmp;
        }
        return retList;
    }

    public static List<Map<String, Object>> replaceGroupFilter(List<Map<String, Object>> dataList, Date searchTime, String no) {
        if (dataList == null || dataList.isEmpty() || searchTime == null) {
            return new ArrayList<Map<String, Object>>(1);
        }
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(dataList.size());
        Set<String> groupSet = BOMExpandConfigBusiness.getRemoveRepGroup(dataList, searchTime, no);
        if (groupSet.isEmpty()) {
            return dataList;
        }
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> dataMap = dataList.get(i);
            String entryisreplace = String.valueOf(dataMap.get("entryisreplace" + no));
            Object replaceGroupObj = dataMap.get("entryreplacegroup" + no);
            String replaceGroup = String.valueOf(replaceGroupObj);
            if (groupSet.contains(replaceGroup) && "true".equals(entryisreplace)) continue;
            retList.add(dataMap);
        }
        return retList;
    }

    public static Set<String> getRemoveRepGroup(List<Map<String, Object>> dataList, Date searchTime, String no) {
        if (dataList == null || dataList.isEmpty() || searchTime == null) {
            return new HashSet<String>(1);
        }
        HashSet<String> replaceGroupSet = new HashSet<String>(dataList.size());
        int size = dataList.size();
        HashSet<Long> bomIdSet = new HashSet<Long>(16);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> dataMap = dataList.get(i);
            Object replaceGroupObj = dataMap.get("entryreplacegroup" + no);
            if (replaceGroupObj == null || "".equals(replaceGroupObj)) continue;
            String replaceGroup = String.valueOf(replaceGroupObj);
            replaceGroupSet.add(replaceGroup);
            bomIdSet.add(BOMExpandConfigBusiness.getLongValue(dataMap.get("id")));
        }
        if (replaceGroupSet.isEmpty()) {
            return new HashSet<String>(1);
        }
        HashSet<String> retSet = new HashSet<String>(dataList.size());
        QFilter filter = new QFilter("id", "in", bomIdSet);
        filter.and(new QFilter("entry.entryreplacegroup", "in", replaceGroupSet));
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        StringBuilder field = new StringBuilder("entry.entryreplacegroup as entryreplacegroup");
        field.append(",entry.entryvaliddate entryvaliddate");
        field.append(",entry.entryinvaliddate entryinvaliddate");
        field.append(",entry.entryisreplace as entryisreplace");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BOMExpandConfigBusiness", (String)"pdm_mftbom", (String)field.toString(), (QFilter[])new QFilter[]{filter, status, enable}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Date validdate = row.getDate("entryvaliddate");
                Date invaliddate = row.getDate("entryinvaliddate");
                String replacGroup = row.getString("entryreplacegroup");
                boolean isreplace = row.getBoolean("entryisreplace");
                if (isreplace || !searchTime.before(validdate) && !searchTime.after(invaliddate)) continue;
                retSet.add(replacGroup);
            }
        }
        return retSet;
    }

    public static long getLongValue(Object value) {
        return value == null ? 0L : (value instanceof Integer ? Long.parseLong(value.toString()) : (value instanceof Long ? (Long)value : Long.parseLong(value.toString())));
    }

    public static Set<Long> getBomType(Map<String, TreeMap<Integer, Object>> map) {
        Set<Map.Entry<Integer, Object>> entrySet;
        if (map == null) {
            return new HashSet<Long>(1);
        }
        HashSet<Long> retSet = new HashSet<Long>(map.size());
        TreeMap<Integer, Object> treeMap = map.get("A");
        if (treeMap != null && treeMap.size() > 0) {
            entrySet = treeMap.entrySet();
            for (Map.Entry<Integer, Object> entry : entrySet) {
                retSet.add(BOMExpandConfigBusiness.getLongValue(entry.getValue()));
            }
        }
        if ((treeMap = map.get("B")) != null && treeMap.size() > 0) {
            entrySet = treeMap.entrySet();
            for (Map.Entry<Integer, Object> entry : entrySet) {
                retSet.add(BOMExpandConfigBusiness.getLongValue(entry.getValue()));
            }
        }
        if ((treeMap = map.get("C")) != null && treeMap.size() > 0) {
            entrySet = treeMap.entrySet();
            for (Map.Entry<Integer, Object> entry : entrySet) {
                retSet.add(BOMExpandConfigBusiness.getLongValue(entry.getValue()));
            }
        }
        if (retSet.isEmpty()) {
            retSet.add(-1L);
        }
        return retSet;
    }

    public static String getPurPose(DynamicObject materialObj, DynamicObject configcodeObj, Long configcodeId) {
        String purpose = "A";
        String configproperties = materialObj.getString("configproperties");
        if ("2".equals(configproperties) || "3".equals(configproperties)) {
            purpose = configcodeObj != null || configcodeId != null && !configcodeId.equals(0L) ? "C" : "B";
        }
        return purpose;
    }

    public static String getPurPose(Long materialId, Long configcodeId, Map<Long, DynamicObject> materialCacheMap) {
        DynamicObject materialObj = BOMExpandConfigBusiness.getMaterial(materialId, materialCacheMap);
        return BOMExpandConfigBusiness.getPurPose(materialObj, null, configcodeId);
    }

    public static DynamicObject getMaterial(Long materialId, Map<Long, DynamicObject> materialCacheMap) {
        DynamicObject mat = null;
        if (materialCacheMap != null) {
            mat = materialCacheMap.get(materialId);
        }
        if (mat == null) {
            mat = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material", (String)"configproperties");
            if (materialCacheMap != null) {
                materialCacheMap.put(materialId, mat);
            }
        }
        return mat;
    }

    private static void deleteRetList(List<Map<String, Object>> retList, List<Map<String, Object>> removeList) {
        if (!removeList.isEmpty()) {
            for (Map<String, Object> dataMap : removeList) {
                retList.remove(dataMap);
            }
            removeList.clear();
        }
    }

    public static DataSet backFilterByExpandConfig(DataSet dataSet, Date searchTime, Long insteadId, Long wbs, Map<String, TreeMap<Integer, Object>> bomExpandMap) {
        long materialId;
        long versionId;
        RowMeta meta = dataSet.getRowMeta();
        List firstList = MMCUtils.parseToList((DataSet)dataSet);
        String repConfig = BOMExpandConfigBusiness.getExpandReplaceConfig(bomExpandMap);
        Set<Long> bomTypeIdSet = BOMExpandConfigBusiness.getBomType(bomExpandMap);
        long replaceNo = insteadId == null ? 0L : insteadId;
        boolean isFullMatchRep = "A".equals(repConfig);
        String verConfig = BOMExpandConfigBusiness.getExpandVerConfig(bomExpandMap);
        boolean isNewVersion = "B".equals(verConfig);
        HashMap<String, Map> wbsMap = new HashMap<String, Map>(16);
        ArrayList<Map<String, Object>> removeList = new ArrayList<Map<String, Object>>(16);
        int size = firstList.size();
        String wbsRule = BOMExpandConfigBusiness.getExpandWbsRule(bomExpandMap);
        long queryWbsId = wbs == null ? 0L : wbs;
        boolean isFullMatchWbs = "A".equals(wbsRule);
        HashMap<String, Set<Long>> cacheBomTypeMap = new HashMap<String, Set<Long>>(16);
        HashMap<String, HashSet<Long>> queryBomTypeIdMap = new HashMap<String, HashSet<Long>>(16);
        Set<Long> allEnableVersionIdSet = new HashSet<Long>(16);
        for (Map dataMap : firstList) {
            long bomTypeId = BOMExpandConfigBusiness.getLongValue(dataMap.get("type"));
            long versionId2 = BOMExpandConfigBusiness.getLongValue(dataMap.get("version"));
            long materialId2 = BOMExpandConfigBusiness.getLongValue(dataMap.get("materialId"));
            long auxproperty = BOMExpandConfigBusiness.getLongValue(dataMap.get("auxproperty"));
            if (!bomTypeIdSet.contains(bomTypeId)) continue;
            String materialKeys = materialId2 + "_" + auxproperty;
            HashSet<Long> typeIdSet = (HashSet<Long>)queryBomTypeIdMap.get(materialKeys);
            if (typeIdSet == null) {
                typeIdSet = new HashSet<Long>(16);
            }
            typeIdSet.add(bomTypeId);
            queryBomTypeIdMap.put(materialKeys, typeIdSet);
            if (versionId2 == 0L) continue;
            allEnableVersionIdSet.add(versionId2);
        }
        if (!allEnableVersionIdSet.isEmpty()) {
            allEnableVersionIdSet = BOMVersionFilterBusiness.getIsEnableVersionIdSet(allEnableVersionIdSet, searchTime);
        }
        HashSet<Long> versionIdSet = new HashSet(16);
        ArrayList<Map<String, Object>> retList1 = new ArrayList<Map<String, Object>>(size);
        for (Map dataMap : firstList) {
            String materialKeys;
            Set<Long> firstBomTypeIdSet;
            long bomTypeId = BOMExpandConfigBusiness.getLongValue(dataMap.get("type"));
            versionId = BOMExpandConfigBusiness.getLongValue(dataMap.get("version"));
            materialId = BOMExpandConfigBusiness.getLongValue(dataMap.get("materialId"));
            long auxproperty = BOMExpandConfigBusiness.getLongValue(dataMap.get("auxproperty"));
            long pconfigCode = BOMExpandConfigBusiness.getLongValue(dataMap.get("pconfigCode"));
            long wbsId = BOMExpandConfigBusiness.getLongValue(dataMap.get("wbs"));
            if (!bomTypeIdSet.contains(bomTypeId) || versionId != 0L && !allEnableVersionIdSet.contains(versionId) || !(firstBomTypeIdSet = BOMExpandConfigBusiness.getFirstBomTypeOfPurpose(bomExpandMap, materialKeys = materialId + "_" + auxproperty, (Set)queryBomTypeIdMap.get(materialKeys), cacheBomTypeMap)).contains(bomTypeId)) continue;
            if (isFullMatchWbs) {
                if (queryWbsId != wbsId) {
                    continue;
                }
            } else {
                if (queryWbsId != wbsId && (wbsId != 0L || queryWbsId == 0L)) continue;
                String materialkeys = bomTypeId + "_" + materialId + "_" + auxproperty + "_" + pconfigCode;
                Map wbsDataMap = (Map)wbsMap.get(materialkeys);
                if (wbsDataMap == null) {
                    wbsMap.put(materialkeys, dataMap);
                } else if (BOMExpandConfigBusiness.getLongValue(wbsDataMap.get("wbs")) == 0L && wbsId != 0L) {
                    removeList.add(wbsDataMap);
                    wbsMap.put(materialkeys, dataMap);
                } else if (BOMExpandConfigBusiness.getLongValue(wbsDataMap.get("wbs")) != 0L && wbsId == 0L) continue;
            }
            retList1.add(dataMap);
        }
        BOMExpandConfigBusiness.deleteRetList(retList1, removeList);
        firstList.clear();
        if (isNewVersion) {
            ArrayList<Map> retList2 = new ArrayList<Map>(retList1.size());
            versionIdSet = retList1.stream().map(p -> Long.parseLong(p.get("version").toString())).collect(Collectors.toSet());
            Map<Long, List<Long>> materialVersionMap = BOMVersionFilterBusiness.getNewBomVersionIdList(versionIdSet, searchTime);
            for (Map map : retList1) {
                long newVersionId;
                versionId = BOMExpandConfigBusiness.getLongValue(map.get("version"));
                materialId = BOMExpandConfigBusiness.getLongValue(map.get("materialId"));
                List<Long> sortVersionIdList = materialVersionMap.get(materialId);
                long l = newVersionId = sortVersionIdList == null || sortVersionIdList.isEmpty() ? 0L : sortVersionIdList.get(0);
                if (newVersionId != versionId) continue;
                retList2.add(map);
            }
            retList1.clear();
            retList1.addAll(retList2);
        }
        BOMExpandConfigBusiness.filterReplaceNo(retList1, isFullMatchRep, replaceNo);
        return MMCUtils.parseToDataSet((Object)BOMExpandConfigBusiness.class.getName(), retList1, (RowMeta)meta);
    }

    private static void filterReplaceNo(List<Map<String, Object>> retList, boolean isFullMatchRep, long queryReplaceNo) {
        HashMap<String, Map<String, Object>> repMap = new HashMap<String, Map<String, Object>>(16);
        ArrayList<Map<String, Object>> removeList = new ArrayList<Map<String, Object>>(16);
        ArrayList<Map<String, Object>> retList2 = new ArrayList<Map<String, Object>>(retList.size());
        for (Map<String, Object> dataMap : retList) {
            long bomTypeId = BOMExpandConfigBusiness.getLongValue(dataMap.get("type"));
            long replacenoId = BOMExpandConfigBusiness.getLongValue(dataMap.get("replaceno"));
            long versionId = BOMExpandConfigBusiness.getLongValue(dataMap.get("version"));
            long materialId = BOMExpandConfigBusiness.getLongValue(dataMap.get("materialId"));
            long auxproperty = BOMExpandConfigBusiness.getLongValue(dataMap.get("auxproperty"));
            long pconfigCode = BOMExpandConfigBusiness.getLongValue(dataMap.get("pconfigCode"));
            if (isFullMatchRep) {
                if (queryReplaceNo != replacenoId) {
                    continue;
                }
            } else {
                if (queryReplaceNo != replacenoId && (replacenoId != 0L || queryReplaceNo == 0L)) continue;
                String materialkeys = bomTypeId + "_" + versionId + "_" + materialId + "_" + auxproperty + "_" + pconfigCode;
                Map repDataMap = (Map)repMap.get(materialkeys);
                if (repDataMap == null) {
                    repMap.put(materialkeys, dataMap);
                } else if (BOMExpandConfigBusiness.getLongValue(repDataMap.get("replaceno")) == 0L && replacenoId != 0L) {
                    removeList.add(repDataMap);
                    repDataMap.put(materialkeys, dataMap);
                } else if (BOMExpandConfigBusiness.getLongValue(repDataMap.get("replaceno")) != 0L && replacenoId == 0L) continue;
            }
            retList2.add(dataMap);
        }
        retList.clear();
        BOMExpandConfigBusiness.deleteRetList(retList2, removeList);
        retList.addAll(retList2);
    }
}

