/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.mftbom.bomsearch;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BOMReportFromProConfigBusiness {
    private static final Log logger = LogFactory.getLog(BOMReportFromProConfigBusiness.class);
    private Map<String, String> fieldMap;
    private DataSet firstDataSet;

    public BOMReportFromProConfigBusiness(String no) {
        this.initFieldOrm(no);
    }

    public DataSet parseToDataSetFromJson(RowMeta rowMeta, JSONObject retObj, long configCode) {
        return this.parseToDataSetFromJson(rowMeta, retObj, configCode, true);
    }

    public DataSet parseToDataSetFromJson(RowMeta rowMeta, JSONObject retObj, long configCode, boolean throwNotBomError) {
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        String[] names = rowMeta.getFieldNames();
        JSONArray treeentryentity = this.getTreeEntry(retObj, configCode, throwNotBomError);
        if (treeentryentity == null) {
            this.setFirstDataSet(null, rowMeta);
            return builder.build();
        }
        String firstLevelNodeId = this.getFirstLevelId(treeentryentity);
        ArrayList<Object[]> firstLevelData = new ArrayList<Object[]>();
        for (int i = 0; i < treeentryentity.size(); ++i) {
            JSONObject treeEntryObj = treeentryentity.getJSONObject(i);
            if ("0".equals(treeEntryObj.getString("pid"))) continue;
            Object[] objArray = new Object[names.length];
            String level = "";
            String pid = treeEntryObj.getString("pid");
            for (int k = 0; k < names.length; ++k) {
                String fieldName = names[k];
                if (this.fieldMap.get(fieldName) == null) continue;
                if ("level".equals(fieldName)) {
                    String levelSeq = treeEntryObj.getString(this.fieldMap.get(fieldName));
                    level = this.getNewLevel(levelSeq);
                    objArray[k] = level;
                    continue;
                }
                if ("randomId".equals(fieldName)) {
                    String id = treeEntryObj.getString("id");
                    if (level.indexOf(45) < 0) {
                        objArray[k] = id;
                        continue;
                    }
                    objArray[k] = pid + "-" + id;
                    continue;
                }
                objArray[k] = treeEntryObj.get((Object)this.fieldMap.get(fieldName));
            }
            if (firstLevelNodeId != null && !"".equals(firstLevelNodeId) && firstLevelNodeId.equals(pid)) {
                firstLevelData.add(objArray);
            }
            builder.append(objArray);
        }
        this.setFirstDataSet(firstLevelData, rowMeta);
        return (AbstractDataSet)builder.build();
    }

    public String getFirstLevelId(JSONArray treeentryentity) {
        String firstLevelNodeId = null;
        for (int i = 0; i < treeentryentity.size(); ++i) {
            JSONObject treeEntryObj = treeentryentity.getJSONObject(i);
            if (!"0".equals(treeEntryObj.getString("pid"))) continue;
            firstLevelNodeId = treeEntryObj.getString("id");
        }
        return firstLevelNodeId;
    }

    public JSONArray getTreeEntry(JSONObject retObj, long configCode, boolean throwNotBomError) {
        if (retObj == null) {
            return null;
        }
        String status = retObj.getString("status");
        if ("failed".equals(status)) {
            return null;
        }
        JSONObject data = retObj.getJSONObject("data");
        if (data == null || data.isEmpty()) {
            return null;
        }
        JSONObject obj = data.getJSONObject(String.valueOf(configCode));
        if (obj == null) {
            return null;
        }
        String configCodeStatus = obj.getString("status");
        if ("failed".equals(configCodeStatus)) {
            String msgTig;
            String errorMsg = obj.getString("errorMsg");
            if (!throwNotBomError && errorMsg.indexOf(msgTig = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5ba1\u6838\u4e14\u53ef\u7528\u7684BOM", (String)"BOMReportFromProConfigBusiness_01", (String)"mmc-pdm-business", (Object[])new Object[0])) >= 0) {
                return null;
            }
            KDBizException e = new KDBizException(errorMsg);
            e.setStackTrace((StackTraceElement[])obj.get((Object)"StackTrace"));
            throw e;
        }
        return obj.getJSONArray("treeentryentity");
    }

    public String getNewLevel(String levelSeq) {
        String retStr = "";
        if (levelSeq == null || "".equals(levelSeq)) {
            return levelSeq;
        }
        String[] levelSeqArray = levelSeq.split("[.]");
        int length = levelSeqArray.length;
        StringBuilder sb = new StringBuilder();
        if (length > 2) {
            for (int i = 3; i <= length; ++i) {
                sb.append("--");
            }
        }
        retStr = sb.append(String.valueOf(length - 1)).toString();
        return retStr;
    }

    public final void initFieldOrm(String no) {
        this.fieldMap = new HashMap<String, String>(100);
        this.fieldMap.put("level", "entryseq");
        this.fieldMap.put("isauxbom", "isauxbom");
        this.fieldMap.put("bomlevel" + no, "entryseq");
        this.fieldMap.put("materialId" + no, "pmaterial");
        this.fieldMap.put("materialname" + no, "pmaterial");
        this.fieldMap.put("bomVer" + no, "pversion");
        this.fieldMap.put("auxproperty" + no, "pauxproperty");
        this.fieldMap.put("entrymaterialId" + no, "entrymaterial_id");
        this.fieldMap.put("entrymaterialname" + no, "entrymaterial_id");
        this.fieldMap.put("entrymaterialattr" + no, "entrymaterialattr");
        this.fieldMap.put("entryversion" + no, "entryversion");
        this.fieldMap.put("entryConfigCode" + no, "configcode");
        this.fieldMap.put("entryunit" + no, "entryunit");
        this.fieldMap.put("entryqtynumerator" + no, "entryqtynumerator");
        this.fieldMap.put("entryqtydenominator" + no, "entryqtydenominator");
        this.fieldMap.put("entryunitqty" + no, "entryunitqty");
        this.fieldMap.put("commonused" + no, "entryqty");
        this.fieldMap.put("convertrate" + no, "convertrate");
        this.fieldMap.put("entryqtytype" + no, "entryqtytype");
        this.fieldMap.put("entryauxproperty" + no, "entryauxproperty");
        this.fieldMap.put("randomId" + no, "id");
        this.fieldMap.put("entry_Id" + no, "superbomentryid");
        this.fieldMap.put("productMaterialId" + no, "pmaterial");
        this.fieldMap.put("number" + no, "number");
        this.fieldMap.put("entryinvaliddate" + no, "entryinvaliddate");
        this.fieldMap.put("entryvaliddate" + no, "entryvaliddate");
        this.fieldMap.put("entrytype" + no, "entrytype");
        this.fieldMap.put("createorg" + no, "createorg");
        this.fieldMap.put("pcommonused" + no, "parentqty");
        this.fieldMap.put("entryscraprate" + no, "entryscraprate");
        this.fieldMap.put("entryfixscrap" + no, "entryfixscrap");
        this.fieldMap.put("entryisjumplevel" + no, "entryisjumplevel");
        this.fieldMap.put("entryisreplace" + no, "entryisreplace");
        this.fieldMap.put("entryreplaceplan" + no, "entryreplaceplan");
        this.fieldMap.put("entryisreplaceplanmm" + no, "entryisreplaceplanmm");
        this.fieldMap.put("entryreplacegroup" + no, "entryreplacegroup");
        this.fieldMap.put("reppriority" + no, "reppriority");
        this.fieldMap.put("wbs" + no, "wbs");
    }

    public DataSet getFirstDataSet() {
        return this.firstDataSet;
    }

    public void setFirstDataSet(List<Object[]> dataArray, RowMeta rowMeta) {
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        if (dataArray == null || dataArray.isEmpty()) {
            this.firstDataSet = builder.build();
            return;
        }
        for (int i = 0; i < dataArray.size(); ++i) {
            Object[] objArray = dataArray.get(i);
            builder.append(objArray);
        }
        this.firstDataSet = builder.build();
    }

    public void setFieldMap(Map<String, String> fieldMap) {
        this.fieldMap = fieldMap;
    }

    public Map<String, String> getFieldMap() {
        return this.fieldMap;
    }
}

