/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.mftbom.bomsearch;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMExpandConfigBusiness;

public class BOMVersionFilterBusiness {
    public static List<Map<String, Object>> versionFilter(List<Map<String, Object>> dataList, long verId, Date searchTime, String no) {
        if (dataList == null || dataList.isEmpty()) {
            return new ArrayList<Map<String, Object>>(1);
        }
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(dataList.size());
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> dataMap = dataList.get(i);
            Long bomVerId = BOMExpandConfigBusiness.getLongValue(dataMap.get("bomVer" + no));
            String configBomVersion = "pversion" + no;
            if (dataMap.containsKey(configBomVersion)) {
                bomVerId = BOMExpandConfigBusiness.getLongValue(dataMap.get(configBomVersion));
            }
            if (bomVerId != verId) continue;
            retList.add(dataMap);
        }
        return retList;
    }

    public static Map<Long, Boolean> isVerEnable(List<Map<String, Object>> dataList, Date searchTime, String no) {
        if (dataList == null || dataList.isEmpty()) {
            return new HashMap<Long, Boolean>(1);
        }
        HashMap<Long, Boolean> retMap = new HashMap<Long, Boolean>(dataList.size());
        HashSet<Long> bomVerSet = new HashSet<Long>(dataList.size());
        for (int i = 0; i < dataList.size(); ++i) {
            long entryVerId;
            Map<String, Object> dataMap = dataList.get(i);
            long l = entryVerId = dataMap.get("entryversion" + no) == null ? 0L : Long.parseLong(dataMap.get("entryversion" + no).toString());
            if (entryVerId == 0L) continue;
            bomVerSet.add(entryVerId);
        }
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter idFilter = new QFilter("id", "in", bomVerSet);
        String fields = "id,effectdate,invaliddate";
        DynamicObjectCollection bomVerCol = QueryServiceHelper.query((String)"bd_bomversion_new", (String)fields, (QFilter[])new QFilter[]{idFilter, status, enable});
        for (DynamicObject bomVer : bomVerCol) {
            long id = bomVer.getLong("id");
            Date effectdate = bomVer.getDate("effectdate");
            Date invaliddate = bomVer.getDate("invaliddate");
            if (searchTime.before(invaliddate) && searchTime.after(effectdate)) {
                retMap.put(id, true);
                continue;
            }
            retMap.put(id, false);
        }
        return retMap;
    }

    public static boolean isVerEnable(long bomVerId, Date searchTime, String no) {
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter idFilter = new QFilter("id", "=", (Object)bomVerId);
        QFilter startTime = new QFilter("effectdate", "<=", (Object)searchTime);
        QFilter endTime = new QFilter("invaliddate", ">", (Object)searchTime);
        return QueryServiceHelper.exists((String)"bd_bomversion_new", (QFilter[])new QFilter[]{idFilter, status, enable, startTime, endTime});
    }

    public static long getTheLastVerOfMaterial(List<Map<String, Object>> dataList, Date searchTime, String no) {
        long retVerId = 0L;
        Set<Long> bomVerSet = BOMVersionFilterBusiness.getBomVsrsionIdSet(dataList, no);
        if (bomVerSet.isEmpty()) {
            return retVerId;
        }
        long longSearchTime = searchTime.getTime();
        long timeTmp = 0L;
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter idFilter = new QFilter("id", "in", bomVerSet);
        QFilter startTime = new QFilter("effectdate", "<=", (Object)searchTime);
        QFilter endTime = new QFilter("invaliddate", ">", (Object)searchTime);
        String fields = "id,effectdate,invaliddate";
        DynamicObjectCollection bomVerCol = QueryServiceHelper.query((String)"bd_bomversion_new", (String)fields, (QFilter[])new QFilter[]{idFilter, startTime, endTime, status, enable});
        for (DynamicObject bomVer : bomVerCol) {
            long id = bomVer.getLong("id");
            Date effectdate = bomVer.getDate("effectdate");
            long longEffectTime = effectdate.getTime();
            long betweenTime = longSearchTime - longEffectTime;
            if (timeTmp != 0L && timeTmp < betweenTime) continue;
            timeTmp = betweenTime;
            retVerId = id;
        }
        return retVerId;
    }

    public static Set<Long> getIsEnableVersionIdSet(Set<Long> bomVerIdSet, Date searchTime) {
        if (bomVerIdSet == null || bomVerIdSet.isEmpty()) {
            return bomVerIdSet;
        }
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter idFilter = new QFilter("id", "in", bomVerIdSet);
        QFilter startTime = new QFilter("effectdate", "<=", (Object)searchTime);
        QFilter endTime = new QFilter("invaliddate", ">", (Object)searchTime);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_bomversion_new", (String)"id", (QFilter[])new QFilter[]{idFilter, status, enable, startTime, endTime});
        return coll.stream().map(p -> p.getLong("id")).collect(Collectors.toSet());
    }

    private static Set<Long> getBomVsrsionIdSet(List<Map<String, Object>> dataList, String no) {
        if (dataList == null || dataList.isEmpty()) {
            return new HashSet<Long>(16);
        }
        int size = dataList.size();
        HashSet<Long> bomVerSet = new HashSet<Long>(size);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> dataMap = dataList.get(i);
            String configBomVersion = "pversion" + no;
            long bomVerId = BOMExpandConfigBusiness.getLongValue(dataMap.get("bomVer" + no));
            if (dataMap.containsKey(configBomVersion)) {
                bomVerId = BOMExpandConfigBusiness.getLongValue(dataMap.get(configBomVersion));
            }
            if (bomVerId == 0L) continue;
            bomVerSet.add(bomVerId);
        }
        return bomVerSet;
    }

    public static long getTheLastVerOfMaterial(List<Map<String, Object>> dataList, Date searchTime, String no, Set<Long> enableVersionIds) {
        long retVerId = 0L;
        Set<Long> bomVerSet = BOMVersionFilterBusiness.getBomVsrsionIdSet(dataList, no);
        if (bomVerSet.isEmpty()) {
            return retVerId;
        }
        long longSearchTime = searchTime.getTime();
        long timeTmp = 0L;
        QFilter idFilter = new QFilter("id", "in", bomVerSet);
        String fields = "id,effectdate,invaliddate";
        DynamicObjectCollection bomVerCol = QueryServiceHelper.query((String)"bd_bomversion_new", (String)fields, (QFilter[])new QFilter[]{idFilter});
        for (DynamicObject bomVer : bomVerCol) {
            long id = bomVer.getLong("id");
            if (!enableVersionIds.contains(id)) continue;
            Date effectdate = bomVer.getDate("effectdate");
            long longEffectTime = effectdate.getTime();
            long betweenTime = longSearchTime - longEffectTime;
            if (timeTmp != 0L && timeTmp < betweenTime) continue;
            timeTmp = betweenTime;
            retVerId = id;
        }
        return retVerId;
    }

    public static Map<Long, List<Long>> getNewBomVersionIdList(Set<Long> bomVerIdSet, Date searchTime) {
        HashMap<Long, List<Long>> matVersionMap = new HashMap<Long, List<Long>>(16);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter idFilter = new QFilter("id", "in", bomVerIdSet);
        QFilter startTime = new QFilter("effectdate", "<=", (Object)searchTime);
        QFilter endTime = new QFilter("invaliddate", ">", (Object)searchTime);
        String orderBy = "material asc,effectdate desc";
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_bomversion_new", (String)"id,material,effectdate", (QFilter[])new QFilter[]{idFilter, status, enable, startTime, endTime}, (String)orderBy);
        for (DynamicObject version : coll) {
            Long materialId = version.getLong("material");
            Long versionId = version.getLong("id");
            ArrayList<Long> versionIdList = (ArrayList<Long>)matVersionMap.get(materialId);
            if (versionIdList == null) {
                versionIdList = new ArrayList<Long>(16);
            }
            versionIdList.add(versionId);
            matVersionMap.put(materialId, versionIdList);
        }
        return matVersionMap;
    }
}

