/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.mftbom.bomsearch;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMExpandConfigBusiness;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;

public class BomBackwardSearchBusiness {
    private static final Log logger = LogFactory.getLog(BomBackwardSearchBusiness.class);
    private Map<String, DataSet> lastDataSetMap = Collections.synchronizedMap(new Hashtable());
    private List<Row> lastDataSetList = Collections.synchronizedList(new ArrayList());
    private Map<Long, List<JSONObject>> qtyEntrymap = Collections.synchronizedMap(new Hashtable());
    private Set<String> lastLevelIds = new HashSet<String>();
    private String isLeaf = "false";
    private BigDecimal demandCount = BigDecimal.ONE;
    private boolean isTreeInit = false;
    private int levelCount = 30;
    private Map<String, TreeMap<Integer, Object>> expandConfigMap;

    public BomBackwardSearchBusiness(String isLeaf, BigDecimal demandCount) {
        this.demandCount = demandCount;
        this.isLeaf = isLeaf;
    }

    public BomBackwardSearchBusiness(String isLeaf, BigDecimal demandCount, boolean isTreeInit) {
        this.demandCount = demandCount;
        this.isLeaf = isLeaf;
        this.isTreeInit = isTreeInit;
    }

    public BomBackwardSearchBusiness(String isLeaf, BigDecimal demandCount, boolean isTreeInit, int levelCount) {
        this.demandCount = demandCount;
        this.isLeaf = isLeaf;
        this.isTreeInit = isTreeInit;
        this.levelCount = levelCount;
        this.expandConfigMap = BOMExpandConfigBusiness.getBomExpandConfig(BOMExpandConfigBusiness.DEF_EXPANDCONFIGID);
    }

    public BomBackwardSearchBusiness(String isLeaf, BigDecimal demandCount, boolean isTreeInit, int levelCount, DynamicObject bomExpandConfig) {
        this.demandCount = demandCount;
        this.isLeaf = isLeaf;
        this.isTreeInit = isTreeInit;
        this.levelCount = levelCount;
        this.expandConfigMap = BOMExpandConfigBusiness.getBomExpandConfig(bomExpandConfig == null ? -1L : bomExpandConfig.getLong("id"));
    }

    public List<Map<String, Object>> getBomLevelSearch(QFilter[] allDataFilter, QFilter[] globalDataFilter, QFilter[] featureDataFilter, String showType, boolean isshowlast, Date searchDate, DynamicObject insteadObj, String rondomId, boolean isConvent, Set<Long> matIdSet, long bomVerId, Long wbsId) {
        ArrayList<Map<String, Object>> retList = new ArrayList(100);
        try (DataSet dataSet = null;){
            dataSet = this.getDataSet(allDataFilter, globalDataFilter, featureDataFilter, showType, isshowlast, searchDate, insteadObj, rondomId, isConvent, matIdSet, bomVerId, wbsId);
            retList = MMCUtils.parseToList((DataSet)dataSet);
        }
        return retList;
    }

    public DataSet getLeverDate(QFilter[] allDataFilter, UUID uuid) {
        String formNum = "pdm_mftbom";
        String randomId = uuid.toString().replace("-", "");
        String selectItems = this.getSelectItems("1");
        String isFixed = "0";
        selectItems = selectItems + ",'" + randomId + "' randomId,entry.entryversion tmpver,'" + isFixed + "' isFixed";
        return QueryServiceHelper.queryDataSet((String)"BOMBackForwardSearchReportPlugin", (String)formNum, (String)selectItems, (QFilter[])allDataFilter, null).orderBy(new String[]{"entrySeq"});
    }

    public DataSet getFirstLevelData(QFilter[] globalDataFilter, QFilter[] featureDataFilter) {
        UUID uuid = UUID.randomUUID();
        DataSet matDataSet = null;
        DataSet featureSet = null;
        if (globalDataFilter != null) {
            matDataSet = this.getLeverDate(globalDataFilter, uuid);
        }
        if (featureDataFilter != null) {
            featureSet = this.getLeverDate(featureDataFilter, uuid);
        }
        if (matDataSet == null && featureSet == null) {
            QFilter material = new QFilter("entry.id", "=", (Object)-1L);
            globalDataFilter = new QFilter[]{material};
            return this.getLeverDate(globalDataFilter, uuid);
        }
        if (matDataSet == null) {
            return featureSet;
        }
        if (featureSet == null) {
            return matDataSet;
        }
        DataSet ds = matDataSet.union(featureSet);
        matDataSet.close();
        featureSet.close();
        return ds;
    }

    public DataSet getDataSet(QFilter[] allDataFilter, QFilter[] globalDataFilter, QFilter[] featureDataFilter, String showType, boolean isshowlast, Date searchDate, DynamicObject insteadObj, String rondomId, boolean isConvent, Set<Long> matIdSet, long bomVerId, Long wbsId) throws Exception {
        DataSet retDataSet = null;
        Long insteadId = insteadObj == null ? 0L : insteadObj.getLong("id");
        QFilter insteadNum = new QFilter("replaceno", "=", (Object)insteadId);
        DataSet globalTmpSet = this.getFirstLevelData(globalDataFilter, featureDataFilter);
        globalTmpSet = BOMExpandConfigBusiness.backFilterByExpandConfig(globalTmpSet, searchDate, insteadId, wbsId, this.expandConfigMap);
        DataSet globalDataSet = null;
        DataSet globalTmpSet1 = globalTmpSet.copy();
        try {
            globalDataSet = "true".equals(this.isLeaf) ? globalTmpSet1.filter(" randomId = 'leaf' ") : globalTmpSet1.copy();
        }
        catch (Exception e) {
            logger.info(e.toString());
            throw e;
        }
        finally {
            globalTmpSet.close();
            globalTmpSet1.close();
        }
        RowMeta rowMeta = globalDataSet.getRowMeta();
        List<Map<String, Object>> firstLevelList = MMCUtils.parseToList((DataSet)globalDataSet);
        if (isConvent) {
            firstLevelList = this.featureTypeToMat(firstLevelList, matIdSet);
        }
        this.getQtyEntry(firstLevelList);
        globalDataSet = this.firstLevelCommonUsed(firstLevelList, rowMeta);
        if (firstLevelList == null || firstLevelList.isEmpty()) {
            return globalDataSet;
        }
        ExecutorService exec = ThreadPools.newCachedExecutorService((String)("bomPool_foward_" + UUID.randomUUID()));
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        try {
            builder = this.getEntryDataSet(allDataFilter, builder, globalDataSet.copy(), exec, 0, searchDate, insteadNum, bomVerId, wbsId);
        }
        catch (MoreLevleException e1) {
            logger.info(e1.toString());
            ErrorCode errorCode = new ErrorCode("mmc.pdm.searchDeadCycle", ResManager.loadKDString((String)"\u67e5\u8be2\u76ee\u6807\u51fa\u73b0\u6b7b\u5faa\u73af\u3002", (String)"BomBackwardSearchBusiness_1", (String)"mmc-pdm-business", (Object[])new Object[0]));
            throw new KDBizException((Throwable)e1, errorCode, new Object[]{e1.getMessage()});
        }
        catch (Exception e) {
            logger.info(e.toString());
            throw e;
        }
        finally {
            try {
                exec.shutdown();
                exec.awaitTermination(5L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        DataSet searchDataSet = builder.build();
        if ("A".equals(showType)) {
            retDataSet = this.getShowData(globalDataSet, searchDataSet, searchDate);
        } else if ("B".equals(showType)) {
            retDataSet = globalDataSet.copy();
            globalDataSet.close();
        } else if ("C".equals(showType)) {
            String showItems = this.getShowTogeterItems();
            DataSet lastLevelDataSet = this.getLastLevelSet(globalDataSet);
            retDataSet = lastLevelDataSet.groupBy(showItems.split(",")).sum("commonused").finish().orderBy(new String[]{"materialId"});
        }
        return retDataSet;
    }

    public DataSet firstLevelCommonUsed(List<Map<String, Object>> firstLevelList, RowMeta rowMeta) {
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>();
        int size = firstLevelList.size();
        for (int i = 0; i < size; ++i) {
            UUID uuid = UUID.randomUUID();
            String randomId = uuid.toString().replace("-", "");
            Map<String, Object> firstLevelMap = firstLevelList.get(i);
            BigDecimal childEntryQtyNumerator = (BigDecimal)firstLevelMap.get("entryqtynumerator");
            BigDecimal childEntryQtyDenominator = (BigDecimal)firstLevelMap.get("entryqtydenominator");
            BigDecimal childEntryQtyFixscrap = (BigDecimal)firstLevelMap.get("entryfixscrap");
            BigDecimal childEntryQtyScraprate = (BigDecimal)firstLevelMap.get("entryscraprate");
            String issolid = (String)firstLevelMap.get("issolid");
            long childEntryId = (Long)firstLevelMap.get("entry_Id");
            String entryqtytype = (String)firstLevelMap.get("entryqtytype");
            firstLevelMap.put("randomId", randomId);
            BigDecimal childCommonused = BigDecimal.ZERO;
            if ("C".equals(entryqtytype)) {
                Map<String, Object> retQtyMap = this.getQtyEntryCommonused(childEntryId, this.demandCount, childEntryQtyNumerator, childEntryQtyDenominator);
                childEntryQtyNumerator = (BigDecimal)retQtyMap.get("entryNumerator");
                childEntryQtyDenominator = (BigDecimal)retQtyMap.get("entryDenominator");
                childEntryQtyFixscrap = (BigDecimal)retQtyMap.get("entryfixscrap");
                childEntryQtyScraprate = (BigDecimal)retQtyMap.get("entryscraprate");
                issolid = (String)retQtyMap.get("issolid");
                childCommonused = (BigDecimal)retQtyMap.get("childCommonused");
                firstLevelMap.put("entryqtynumerator", childEntryQtyNumerator);
                firstLevelMap.put("entryqtydenominator", childEntryQtyDenominator);
                firstLevelMap.put("entryfixscrap", childEntryQtyFixscrap);
                firstLevelMap.put("entryscraprate", childEntryQtyScraprate);
                firstLevelMap.put("issolid", issolid);
                firstLevelMap.put("commonused", childCommonused);
                firstLevelMap.put("isFixed", "0");
                retList.add(firstLevelMap);
                continue;
            }
            if ("B".equals(entryqtytype)) {
                childCommonused = MMCUtils.divide((BigDecimal)childEntryQtyNumerator, (BigDecimal)childEntryQtyDenominator);
                firstLevelMap.put("entryqtynumerator", childEntryQtyNumerator);
                firstLevelMap.put("entryqtydenominator", childEntryQtyDenominator);
                firstLevelMap.put("commonused", childCommonused);
                firstLevelMap.put("isFixed", "1");
                retList.add(firstLevelMap);
                continue;
            }
            retList.add(firstLevelMap);
        }
        return MMCUtils.parseToDataSet((Object)this, retList, (RowMeta)rowMeta);
    }

    public DataSet getShowData(DataSet globalDataSet, DataSet searchDataSet, Date searchDate) {
        DataSet retDataSet = searchDataSet.union(globalDataSet);
        searchDataSet.close();
        globalDataSet.close();
        retDataSet = retDataSet.orderBy(new String[]{"orderNo asc"});
        return retDataSet;
    }

    public DataSetBuilder getEntryDataSet(QFilter[] allDataFilter, DataSetBuilder builder, DataSet globalDataSet, ExecutorService exec, int level, Date searchDate, QFilter insteadNum, long bomVerId, Long wbsId) throws Exception {
        block40: {
            try {
                DataSetBuilder childDataMap;
                DataSet leverDataOfMat;
                if (++level > 30) {
                    throw new MoreLevleException(ResManager.loadKDString((String)"\u5c42\u7ea7\u8d85\u8fc730\u5c42\uff0c\u5224\u5b9a\u4e3a\u6b7b\u5faa\u73af\u3002", (String)"BomBackwardSearchBusiness_5", (String)"mmc-pdm-business", (Object[])new Object[0]));
                }
                if (level == this.levelCount) {
                    DataSetBuilder dataSetBuilder = builder;
                    return dataSetBuilder;
                }
                RowMeta rowMeta = globalDataSet.getRowMeta();
                ArrayList<FutureTask<List<Map<String, Object>>>> taskList = new ArrayList<FutureTask<List<Map<String, Object>>>>(50);
                HashSet<Long> mids = new HashSet<Long>(1024);
                try (DataSet tmpGLDataSet = globalDataSet.copy();){
                    Row tmpRow;
                    while (tmpGLDataSet.hasNext()) {
                        tmpRow = tmpGLDataSet.next();
                        if (tmpRow == null) continue;
                        long materialId = tmpRow.getLong("materialId");
                        if (materialId <= 0L) {
                            String number = tmpRow.getString("number");
                            throw new KDBizException(ResManager.loadKDString((String)"BOM\u201c%s\u201d\u5bf9\u5e94\u4e3b\u7269\u6599\u51fa\u73b0\u7a7a\u503c\u3002", (String)"BomBackwardSearchBusiness_3", (String)"mmc-pdm-business", (Object[])new Object[]{number}));
                        }
                        mids.add(materialId);
                    }
                    if (mids.size() <= 0) {
                        tmpRow = builder;
                        return tmpRow;
                    }
                }
                UUID uuid = UUID.randomUUID();
                QFilter material = new QFilter("entry.entrymaterialid", "in", mids);
                DataSet leverData = leverDataOfMat = this.getLeverDate((QFilter[])ArrayUtils.add((Object[])allDataFilter, (Object)material), uuid);
                Set<Long> featureIds = this.getFeatureTypeByMat(mids);
                if (!featureIds.isEmpty()) {
                    QFilter featureType = new QFilter("entry.featuretype", "in", featureIds);
                    DataSet leverDataOfType = this.getLeverDate((QFilter[])ArrayUtils.add((Object[])allDataFilter, (Object)featureType), uuid);
                    leverData = leverDataOfMat.union(leverDataOfType);
                    leverDataOfType.close();
                    leverDataOfMat.close();
                }
                leverData = BOMExpandConfigBusiness.backFilterByExpandConfig(leverData, searchDate, Long.parseLong(insteadNum.getValue() + ""), wbsId, this.expandConfigMap);
                Algo algo = Algo.create((String)this.getClass().getName());
                DataSetBuilder childLeverBuild = algo.createDataSetBuilder(rowMeta);
                DataSet childLeverData = childLeverBuild.build();
                int threadCount = PdmParamSetHelper.getIntParamValue((String)"bombacksearch-thread-count");
                try {
                    List<Map<String, Object>> childList = MMCUtils.parseToList((DataSet)leverData);
                    if (childList.isEmpty()) {
                        DataSetBuilder dataSetBuilder = builder;
                        return dataSetBuilder;
                    }
                    childList = this.featureTypeToMat(childList, mids);
                    this.getQtyEntry(childList);
                    boolean isNewVsersionMode = this.isNewVersionMode();
                    childDataMap = this.buildMap(childList);
                    tmpGLDataSet = globalDataSet.copy();
                    while (tmpGLDataSet.hasNext()) {
                        String keyString;
                        ArrayList<Map<String, Object>> newChildList;
                        Row tmpRow = tmpGLDataSet.next();
                        if (this.isRepeatBom(tmpRow)) {
                            throw new MoreLevleException(ResManager.loadKDString((String)"\u5c42\u7ea7\u8d85\u8fc730\u5c42\uff0c\u5224\u5b9a\u4e3a\u6b7b\u5faa\u73af\u3002", (String)"BomBackwardSearchBusiness_5", (String)"mmc-pdm-business", (Object[])new Object[0]));
                        }
                        long entrymaterialId = tmpRow.getLong("materialId");
                        long entryConfigCode = tmpRow.getLong("pconfigCode");
                        long entryauxproperty = tmpRow.getLong("auxproperty");
                        long entryversion = tmpRow.getLong("version");
                        if (isNewVsersionMode) {
                            entryversion = 0L;
                        }
                        if ((newChildList = (ArrayList<Map<String, Object>>)childDataMap.get(keyString = this.buildKeyString(entrymaterialId, entryConfigCode, entryauxproperty, entryversion))) == null) {
                            newChildList = new ArrayList<Map<String, Object>>(16);
                        }
                        FutureTask<List<Map<String, Object>>> ft = new FutureTask<List<Map<String, Object>>>(new DateSetTask(newChildList, tmpRow, level, insteadNum, wbsId));
                        taskList.add(ft);
                        exec.submit(ft);
                        if (taskList.size() % threadCount != 0) continue;
                        DataSet childTmpData = this.getThreadResult(taskList, rowMeta, builder);
                        DataSet childLeverDataTmp = childLeverData.union(childTmpData);
                        taskList.clear();
                        childTmpData.close();
                        childLeverData.close();
                        childLeverData = childLeverDataTmp;
                    }
                }
                catch (Exception e) {
                    logger.info("\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
                    throw e;
                }
                finally {
                    tmpGLDataSet.close();
                    leverData.close();
                }
                DataSet childTmpData = this.getThreadResult(taskList, rowMeta, builder);
                DataSet childLeverDataTmp = childLeverData.union(childTmpData);
                taskList.clear();
                childTmpData.close();
                childLeverData.close();
                childLeverData = childLeverDataTmp;
                if (!childLeverData.hasNext()) {
                    childDataMap = builder;
                    return childDataMap;
                }
                DataSet nextleverData = childLeverData.copy();
                if (childLeverData != null) {
                    childLeverData.close();
                }
                if (nextleverData == null || !nextleverData.hasNext()) break block40;
                try {
                    DataSet nextLevelDataSet = nextleverData.copy();
                    this.lastDataSetMap.put("lastLevel2", nextLevelDataSet);
                    builder = this.getEntryDataSet(allDataFilter, builder, nextLevelDataSet.copy(), exec, level, searchDate, insteadNum, bomVerId, wbsId);
                }
                catch (Exception e) {
                    logger.info("\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
                    throw e;
                }
                finally {
                    nextleverData.close();
                }
            }
            catch (Exception e) {
                logger.info("\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
                throw e;
            }
            finally {
                globalDataSet.close();
            }
        }
        return builder;
    }

    private DataSet getThreadResult(List<FutureTask<List<Map<String, Object>>>> taskList, RowMeta rowMeta, DataSetBuilder builder) throws Exception {
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSetBuilder curbuilder = algo.createDataSetBuilder(rowMeta);
        for (int i = 0; i < taskList.size(); ++i) {
            FutureTask<List<Map<String, Object>>> futureTask = taskList.get(i);
            if (futureTask == null) continue;
            try {
                List<Map<String, Object>> childList = futureTask.get();
                if (childList == null) continue;
                curbuilder = this.unionDataChild(childList, rowMeta, builder, curbuilder);
                continue;
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw e;
            }
        }
        DataSet childLeverData = curbuilder.build();
        return childLeverData;
    }

    public DataSetBuilder unionDataChild(List<Map<String, Object>> childList, RowMeta rowMeta, DataSetBuilder builder, DataSetBuilder curbuilder) {
        if (!childList.isEmpty()) {
            String[] names = rowMeta.getFieldNames();
            for (int i = 0; i < childList.size(); ++i) {
                Map<String, Object> map = childList.get(i);
                Object[] objArray = new Object[map.size()];
                for (int k = 0; k < names.length; ++k) {
                    Object value;
                    String fiedName = names[k];
                    objArray[k] = value = map.get(fiedName);
                }
                builder.append(objArray);
                curbuilder.append(objArray);
            }
        }
        return curbuilder;
    }

    public Map<String, Object> getQtyEntryCommonused(long entryId, BigDecimal parentCommonused, BigDecimal entryNumerator, BigDecimal entryDenominator) {
        BigDecimal childCommonused = BigDecimal.ONE;
        HashMap<String, Object> retMap = new HashMap<String, Object>(100);
        List<JSONObject> list = this.qtyEntrymap.get(entryId);
        if (list == null) {
            retMap.put("childCommonused", childCommonused);
            retMap.put("entryNumerator", entryNumerator);
            retMap.put("entryDenominator", entryDenominator);
            return retMap;
        }
        JSONObject bomQtyObj = null;
        for (int i = 0; i < list.size(); ++i) {
            JSONObject bomObj = list.get(i);
            BigDecimal startqty = bomObj.getBigDecimal("qtyentrybatchstartqty");
            BigDecimal endtqty = bomObj.getBigDecimal("qtyentrybatchendqty");
            if (startqty.compareTo(parentCommonused) > 0 || endtqty.compareTo(parentCommonused) <= 0) continue;
            bomQtyObj = bomObj;
            break;
        }
        if (bomQtyObj == null) {
            childCommonused = MMCUtils.multiplyAndDivide((BigDecimal)parentCommonused, (BigDecimal)entryNumerator, (BigDecimal)entryDenominator);
            retMap.put("childCommonused", childCommonused);
            retMap.put("entryNumerator", entryNumerator);
            retMap.put("entryDenominator", entryDenominator);
            return retMap;
        }
        BigDecimal qtyentryqtynumerator = bomQtyObj.getBigDecimal("qtyentryqtynumerator");
        BigDecimal qtyentryqtydenominator = bomQtyObj.getBigDecimal("qtyentryqtydenominator");
        BigDecimal qtyentryfixscrap = bomQtyObj.getBigDecimal("qtyentryfixscrap");
        BigDecimal qtyentryscraprate = bomQtyObj.getBigDecimal("qtyentryscraprate");
        boolean isstepfix = bomQtyObj.getBoolean("qtyentryisstepfix");
        if (isstepfix) {
            childCommonused = MMCUtils.divide((BigDecimal)qtyentryqtynumerator, (BigDecimal)qtyentryqtydenominator);
            retMap.put("childCommonused", childCommonused);
            retMap.put("entryNumerator", qtyentryqtynumerator);
            retMap.put("entryDenominator", qtyentryqtydenominator);
            retMap.put("entryfixscrap", qtyentryfixscrap);
            retMap.put("entryscraprate", qtyentryscraprate);
            retMap.put("issolid", "true");
            return retMap;
        }
        childCommonused = MMCUtils.multiplyAndDivide((BigDecimal)parentCommonused, (BigDecimal)qtyentryqtynumerator, (BigDecimal)qtyentryqtydenominator);
        retMap.put("childCommonused", childCommonused);
        retMap.put("entryNumerator", qtyentryqtynumerator);
        retMap.put("entryDenominator", qtyentryqtydenominator);
        retMap.put("entryfixscrap", qtyentryfixscrap);
        retMap.put("entryscraprate", qtyentryscraprate);
        retMap.put("issolid", "false");
        return retMap;
    }

    public void getQtyEntry(List<Map<String, Object>> levelList) {
        if (levelList == null) {
            return;
        }
        HashSet<Long> entryIdSet = new HashSet<Long>(100);
        for (int i = 0; i < levelList.size(); ++i) {
            Map<String, Object> childMap = levelList.get(i);
            String entryqtytype = String.valueOf(childMap.get("entryqtytype"));
            long entryId = Long.parseLong(childMap.get("entry_Id").toString());
            if (!"C".equals(entryqtytype)) continue;
            entryIdSet.add(entryId);
        }
        if (entryIdSet.isEmpty()) {
            return;
        }
        String entryIdSetStr = ((Object)entryIdSet).toString();
        entryIdSetStr = entryIdSetStr.replace('[', '(');
        entryIdSetStr = entryIdSetStr.replace(']', ')');
        StringBuilder sql = new StringBuilder("select fbatchstartqty as qtyentrybatchstartqty ");
        sql.append(",fbatchendqty as qtyentrybatchendqty");
        sql.append(",fisstepfix as qtyentryisstepfix");
        sql.append(",fqtynumerator as qtyentryqtynumerator");
        sql.append(",fqtydenominator as qtyentryqtydenominator");
        sql.append(",ffixscrap as qtyentryfixscrap");
        sql.append(",fscraprate as qtyentryscraprate");
        sql.append(",fentryid as entryId");
        sql.append(" from t_pdm_mftbomqtyentry ");
        sql.append(" where fentryid in ");
        sql.append(entryIdSetStr);
        DB.query((DBRoute)new DBRoute("scm"), (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    long entryId = rs.getLong("entryId");
                    BigDecimal qtyentrybatchstartqty = rs.getBigDecimal("qtyentrybatchstartqty");
                    BigDecimal qtyentrybatchendqty = rs.getBigDecimal("qtyentrybatchendqty");
                    boolean qtyentryisstepfix = rs.getBoolean("qtyentryisstepfix");
                    BigDecimal qtyentryqtynumerator = rs.getBigDecimal("qtyentryqtynumerator");
                    BigDecimal qtyentryqtydenominator = rs.getBigDecimal("qtyentryqtydenominator");
                    BigDecimal qtyentryfixscrap = rs.getBigDecimal("qtyentryfixscrap");
                    BigDecimal qtyentryscraprate = rs.getBigDecimal("qtyentryscraprate");
                    JSONObject json = new JSONObject();
                    json.put("qtyentrybatchstartqty", (Object)qtyentrybatchstartqty);
                    json.put("qtyentrybatchendqty", (Object)qtyentrybatchendqty);
                    json.put("qtyentryisstepfix", (Object)qtyentryisstepfix);
                    json.put("qtyentryqtynumerator", (Object)qtyentryqtynumerator);
                    json.put("qtyentryqtydenominator", (Object)qtyentryqtydenominator);
                    json.put("qtyentryfixscrap", (Object)qtyentryfixscrap);
                    json.put("qtyentryscraprate", (Object)qtyentryscraprate);
                    ArrayList<JSONObject> list = (ArrayList<JSONObject>)BomBackwardSearchBusiness.this.qtyEntrymap.get(entryId);
                    if (list == null) {
                        list = new ArrayList<JSONObject>();
                    }
                    list.add(json);
                    BomBackwardSearchBusiness.this.qtyEntrymap.put(entryId, list);
                }
                rs.close();
                return null;
            }
        });
    }

    public List<Map<String, Object>> featureTypeToMat(List<Map<String, Object>> dataMapList, Set<Long> matIdSet) {
        if (dataMapList == null || dataMapList.isEmpty()) {
            return dataMapList;
        }
        HashSet<Long> featureTypeSet = new HashSet<Long>(16);
        int size = dataMapList.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> dataMap = dataMapList.get(i);
            String entryType = String.valueOf(dataMap.get("entrytype"));
            if (!"B".equals(entryType)) continue;
            Object featureTypeObj = dataMap.get("featuretype");
            long featureTypeId = BOMExpandConfigBusiness.getLongValue(featureTypeObj);
            featureTypeSet.add(featureTypeId);
        }
        if (featureTypeSet.isEmpty()) {
            return dataMapList;
        }
        HashSet<Long> featureMatIdSet = new HashSet<Long>(16);
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(4);
        QFilter filter = new QFilter("featureinfo.featuretype", "in", featureTypeSet);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BOMForwardSearchReportPlugin", (String)"pdm_proconfigscheme", (String)"materielnum,featureinfo.featuretype featureTypeId", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long material = row.getLong("materielnum");
                long featureTypeId = row.getLong("featureTypeId");
                HashSet<Long> set = (HashSet<Long>)map.get(featureTypeId);
                if (set == null) {
                    set = new HashSet<Long>(16);
                }
                if (matIdSet != null && matIdSet.contains(material)) {
                    set.add(material);
                }
                map.put(featureTypeId, set);
                featureMatIdSet.add(material);
            }
        }
        Map<Long, Map<String, Object>> retMatMap = this.getFeatureTypeMaterial(featureMatIdSet);
        return this.createFeatureTypeEntry(dataMapList, map, retMatMap);
    }

    private Map<Long, Map<String, Object>> getFeatureTypeMaterial(Set<Long> matIdSet) {
        if (matIdSet.isEmpty()) {
            return new HashMap<Long, Map<String, Object>>(1);
        }
        HashMap<Long, Map<String, Object>> retMatMap = new HashMap<Long, Map<String, Object>>(matIdSet.size());
        QFilter filter = new QFilter("id", "in", matIdSet);
        QFilter statusQFilter = new QFilter("status", "=", (Object)"C");
        QFilter useQFilter = new QFilter("enable", "=", (Object)"1");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BOMForwardSearchReportPlugin", (String)"bd_material", (String)"id,number,baseunit", (QFilter[])new QFilter[]{filter.and(statusQFilter).and(useQFilter)}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long matId = row.getLong("id");
                String matNum = row.getString("number");
                long baseUnit = row.getLong("baseunit");
                HashMap<String, Object> matMap = new HashMap<String, Object>(16);
                matMap.put("number", matNum);
                matMap.put("baseunit", baseUnit);
                retMatMap.put(matId, matMap);
            }
        }
        return retMatMap;
    }

    private List<Map<String, Object>> createFeatureTypeEntry(List<Map<String, Object>> dataMapList, Map<Long, Set<Long>> map, Map<Long, Map<String, Object>> matMap) {
        List<Map<String, Object>> retLiist = Collections.synchronizedList(new ArrayList(100));
        if (dataMapList == null || map == null) {
            return dataMapList;
        }
        for (int i = 0; i < dataMapList.size(); ++i) {
            Set<Long> matSet;
            Map<String, Object> dataMap = dataMapList.get(i);
            String entryType = String.valueOf(dataMap.get("entrytype"));
            Object featureTypeObj = dataMap.get("featuretype");
            if (!"B".equals(entryType)) {
                retLiist.add(dataMap);
                continue;
            }
            long featureTypeId = BOMExpandConfigBusiness.getLongValue(featureTypeObj);
            if (featureTypeId == 0L && "B".equals(entryType) || (matSet = map.get(featureTypeId)) == null) continue;
            this.loadFeatureType(retLiist, matSet, dataMap, matMap);
        }
        return retLiist;
    }

    private void loadFeatureType(List<Map<String, Object>> retLiist, Set<Long> matSet, Map<String, Object> dataMap, Map<Long, Map<String, Object>> matMap) {
        ORM orm = ORM.create();
        long[] newEntryIds = orm.genLongIds("pdm_mftbom.entry", matSet.size());
        int i = 0;
        for (long entryMatId : matSet) {
            Map<String, Object> matObj = matMap.get(entryMatId);
            if (matObj == null) continue;
            Object baseUnit = matObj.get("baseunit");
            Map newMap = MMCUtils.mapCopy(dataMap);
            if (newMap == null || newMap.isEmpty()) continue;
            long newEntryId = newEntryIds[i++];
            newMap.put("entrymaterialId", entryMatId);
            newMap.put("entrymaterialname", entryMatId);
            String orderNo = String.valueOf(newMap.get("orderNo").toString());
            String entryId = String.valueOf(newMap.get("bomId").toString());
            String seq = String.valueOf(newMap.get("seq").toString());
            String olderOrderNo = entryId + seq;
            String newOrderNo = newEntryId + seq;
            orderNo = orderNo.replace(olderOrderNo, newOrderNo);
            newMap.put("orderNo", orderNo);
            newMap.put("entry_Id", newEntryId);
            newMap.put("unit", baseUnit);
            retLiist.add(newMap);
        }
    }

    public boolean isRepeatBom(Row row) {
        boolean retFlag = false;
        String longnumber = row.getString("longnumber");
        long parentId = row.getLong("id");
        String lastEntryId = String.valueOf(parentId);
        int lastEntryIndex = longnumber.lastIndexOf(lastEntryId);
        if (longnumber.indexOf(lastEntryId) < lastEntryIndex) {
            QFilter filter = new QFilter("id", "=", (Object)row.getLong("entrymaterialId"));
            DataSet materialMtfDataSet = QueryServiceHelper.queryDataSet((String)"BomFowordSearchReportTreePlugin", (String)"bd_material", (String)"id,number", (QFilter[])new QFilter[]{filter}, null);
            try {
                try {
                    if (materialMtfDataSet.hasNext()) {
                        Row tmpRow = materialMtfDataSet.next();
                        String number = tmpRow.getString("number");
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5728\u8282\u70b9\u201c%s\u201d\u5904\u51fa\u73b0\u6b7b\u5faa\u73af\u3002", (String)"BomBackwardSearchBusiness_4", (String)"mmc-pdm-business", (Object[])new Object[0]), number));
                    }
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5728\u8282\u70b9\u201c%s\u201d\u5904\u51fa\u73b0\u6b7b\u5faa\u73af\u3002", (String)"BomBackwardSearchBusiness_4", (String)"mmc-pdm-business", (Object[])new Object[0]), ""));
                }
                catch (Exception e) {
                    logger.info("\u6570\u636e\u51fa\u73b0\u6b7b\u5faa\u73af\u6216\u8005\u67e5\u8be2\u62a5\u9519", (Object)e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                materialMtfDataSet.close();
                throw throwable;
            }
        }
        return retFlag;
    }

    public Set<Long> getFeatureTypeByMat(Set<Long> matIdSet) {
        HashSet<Long> featureTypeSet = new HashSet<Long>(16);
        QFilter matFilter = new QFilter("materielnum", "in", matIdSet);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pdm_proconfigscheme", (String)"id,featureinfo.id as entryid,featureinfo.featuretype as featuretype", (QFilter[])new QFilter[]{matFilter}, null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            long featuretype = row.getLong("featuretype");
            if (featuretype == 0L) continue;
            featureTypeSet.add(featuretype);
        }
        return featureTypeSet;
    }

    public Set<Long> getFeatureTypeByMat(long featureTypeId) {
        HashSet<Long> matIdSet = new HashSet<Long>(64);
        QFilter typeFilter = new QFilter("featureinfo.featuretype", "=", (Object)featureTypeId);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pdm_proconfigscheme", (String)"id,materielnum", (QFilter[])new QFilter[]{typeFilter}, null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            long matId = row.getLong("materielnum");
            matIdSet.add(matId);
        }
        return matIdSet;
    }

    public String getSelectItems(String bomLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append(" concat('',entry.seq) entrySeq");
        sb.append(",concat('-',id) id");
        sb.append(",id as bomId ");
        sb.append(",number ");
        sb.append(",version version");
        sb.append(",type");
        sb.append(",auxproperty auxproperty ");
        sb.append(",replaceno ");
        sb.append(",wbs ");
        sb.append(",concat('-',entry.id) entryId");
        sb.append(",entry.id entry_Id");
        sb.append(",material materialInfo");
        sb.append(",materialid materialId");
        sb.append(",materialid materialname");
        sb.append(",material.materialattr materialattr");
        sb.append(",configuredcode pconfigCode ");
        sb.append(",entry.entrytype entrytype");
        sb.append(",entry.featuretype featuretype");
        sb.append(",entry.featuretype featuretypename");
        sb.append(",entry.entrymaterial entrymaterialInfo");
        sb.append(",entry.entrymaterialid entrymaterialId");
        sb.append(",entry.entrymaterialid entrymaterialname");
        sb.append(",entry.entrymaterialattr entrymaterialattr");
        sb.append(",entry.entryconfiguredcode entryConfigCode");
        sb.append(",entry.entryunit unit");
        sb.append(",entry.entryversion entryversion");
        sb.append(",entry.entryqtynumerator entryqtynumerator");
        sb.append(",entry.entryqtydenominator entryqtydenominator");
        sb.append(",entry.entryfixscrap entryfixscrap");
        sb.append(",entry.entryscraprate entryscraprate");
        sb.append(",entry.entryqtytype entryqtytype");
        sb.append(",\"false\" as issolid");
        sb.append(",entry.entryauxproperty entryauxproperty");
        sb.append(",entry.entryvaliddate entryvaliddate");
        sb.append(",entry.entryinvaliddate entryinvaliddate");
        sb.append(',');
        sb.append(this.demandCount);
        sb.append("*entry.entryqtynumerator/entry.entryqtydenominator commonused");
        sb.append(',');
        sb.append(this.demandCount.setScale(20));
        sb.append(" pcommonused");
        sb.append(",concat('',entry.seq) bomlevel");
        sb.append(",'1' level");
        sb.append(",concat('',id) longnumber");
        sb.append(",concat(concat('',id),entry.seq) orderNo");
        sb.append(",concat('',entry.seq) seq");
        sb.append(",entry.entryisreplace as entryisreplace");
        sb.append(",entry.entryreplaceplan as entryreplaceplan");
        sb.append(",entry.entryisreplaceplanmm as entryisreplaceplanmm");
        sb.append(",entry.entryreplacegroup as entryreplacegroup");
        sb.append(",entry.reppriority as reppriority");
        return sb.toString();
    }

    public String getShowTogeterItems() {
        StringBuilder sb = new StringBuilder();
        sb.append("materialId");
        sb.append(",materialname");
        sb.append(",featuretype");
        sb.append(",materialattr");
        sb.append(",version");
        sb.append(",auxproperty");
        sb.append(",entryqtytype");
        sb.append(",entryauxproperty");
        sb.append(",tmpver");
        sb.append(",wbs");
        return sb.toString();
    }

    public List<Object> getMaterialInfo(DynamicObject material) {
        ArrayList<Object> ids = new ArrayList<Object>();
        if (material == null) {
            return ids;
        }
        long matetialId = material.getLong("id");
        QFilter matetial = new QFilter("masterid", "=", (Object)matetialId);
        DynamicObjectCollection materialInfoCol = QueryServiceHelper.query((String)"bd_materialmftinfo", (String)"id", (QFilter[])new QFilter[]{matetial});
        for (DynamicObject materialInfo : materialInfoCol) {
            ids.add(materialInfo.get("id"));
        }
        return ids;
    }

    public DataSet getLastLevelSet(DataSet globalDataSet) {
        DataSet lastLevelDataSet = this.lastDataSetMap.get("lastLevel2");
        Algo algo = Algo.create((String)this.getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(globalDataSet.getRowMeta());
        for (int i = 0; i < this.lastDataSetList.size(); ++i) {
            Row row = this.lastDataSetList.get(i);
            builder.append(row);
        }
        DataSet lastLevelSet = builder.build();
        if (lastLevelDataSet == null) {
            lastLevelDataSet = lastLevelSet;
        } else if (lastLevelSet != null) {
            lastLevelDataSet = lastLevelDataSet.union(lastLevelSet);
        }
        if (lastLevelDataSet == null || lastLevelDataSet.isEmpty()) {
            lastLevelDataSet = globalDataSet.copy();
        }
        DataSet tmpDataSet = lastLevelDataSet.copy();
        while (tmpDataSet.hasNext()) {
            Row row = tmpDataSet.next();
            long materialId = row.getLong("materialId");
            long version = row.getLong("version");
            String lastLevelId = Long.toString(materialId) + Long.toString(version);
            this.lastLevelIds.add(lastLevelId);
        }
        return lastLevelDataSet;
    }

    public Set<String> getLastIds() {
        return this.lastLevelIds;
    }

    private boolean isNewVersionMode() {
        if (this.expandConfigMap != null) {
            String verConfig = BOMExpandConfigBusiness.getExpandVerConfig(this.expandConfigMap);
            return "B".equals(verConfig);
        }
        return false;
    }

    private Map<String, List<Map<String, Object>>> buildMap(List<Map<String, Object>> childList) {
        int size = childList.size();
        HashMap<String, List<Map<String, Object>>> dataMap = new HashMap<String, List<Map<String, Object>>>(64);
        boolean isNewVsersionMode = this.isNewVersionMode();
        for (int i = 0; i < size; ++i) {
            String keyString;
            ArrayList<Map<String, Object>> list;
            Map<String, Object> childMap = childList.get(i);
            long childMaterialId = (Long)childMap.get("entrymaterialId");
            long childConfigCode = (Long)childMap.get("entryConfigCode");
            long auxproperty = (Long)childMap.get("entryauxproperty");
            long versionid = (Long)childMap.get("entryversion");
            if (isNewVsersionMode) {
                versionid = 0L;
            }
            if ((list = (ArrayList<Map<String, Object>>)dataMap.get(keyString = this.buildKeyString(childMaterialId, childConfigCode, auxproperty, versionid))) == null) {
                list = new ArrayList<Map<String, Object>>(16);
            }
            list.add(childMap);
            dataMap.put(keyString, list);
        }
        return dataMap;
    }

    private String buildKeyString(Long childMaterialId, Long childConfigCode, Long auxproperty, Long childVersionId) {
        return childMaterialId + "_" + childConfigCode + "_" + auxproperty + "_" + childVersionId;
    }

    private static class MoreLevleException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public MoreLevleException(String msg) {
            super(msg);
        }
    }

    private class DateSetTask
    implements Callable<List<Map<String, Object>>> {
        private Row row = null;
        private List<Map<String, Object>> childList = null;
        private int level = 0;
        private QFilter insteadNum = null;
        private Long wbsId = 0L;

        public DateSetTask(List<Map<String, Object>> childList, Row row, int level, QFilter insteadNum, Long wbs) {
            this.childList = childList;
            this.row = row;
            this.level = level;
            this.insteadNum = insteadNum;
            this.wbsId = wbs;
        }

        @Override
        public List<Map<String, Object>> call() throws Exception {
            int wbsSetSize;
            ++this.level;
            String levelStr = "";
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < this.level - 1; ++i) {
                str.append("--");
            }
            levelStr = str.append(this.level).toString();
            long materialId = this.row.getLong("materialId");
            long version = this.row.getLong("version");
            long auxproperty = this.row.getLong("auxproperty");
            long entrymaterialId = this.row.getLong("entrymaterialId");
            String entryversion = String.valueOf(this.row.get("entryversion"));
            String bomlevel = String.valueOf(this.row.get("bomlevel"));
            BigDecimal commonused = this.row.getBigDecimal("commonused");
            String longnumber = this.row.getString("longnumber");
            String orderNo = this.row.getString("orderNo");
            String randomId = this.row.getString("randomId");
            long tmpver = this.row.getLong("tmpver");
            String isFixed = this.row.getString("isFixed");
            long configCode = this.row.getLong("pconfigCode");
            List<Map<String, Object>> retChildList = Collections.synchronizedList(new ArrayList());
            HashSet<Long> replacenoSet = new HashSet<Long>(16);
            HashSet<Long> wbsIdSet = new HashSet<Long>(16);
            for (int i = 0; i < this.childList.size(); ++i) {
                Map childMap = this.childList.get(i);
                long childEntryMaterialId = (Long)childMap.get("entrymaterialId");
                long childEntryVersionId = (Long)childMap.get("entryversion");
                long childAuxproperty = (Long)childMap.get("entryauxproperty");
                long childConfigCode = (Long)childMap.get("entryConfigCode");
                BigDecimal childEntryQtyNumerator = (BigDecimal)childMap.get("entryqtynumerator");
                BigDecimal childEntryQtyDenominator = (BigDecimal)childMap.get("entryqtydenominator");
                BigDecimal childEntryQtyFixscrap = (BigDecimal)childMap.get("entryfixscrap");
                BigDecimal childEntryQtyScraprate = (BigDecimal)childMap.get("entryscraprate");
                String issolid = (String)childMap.get("issolid");
                String parentId = (String)childMap.get("id");
                String seq = (String)childMap.get("seq");
                String childEntrySeq = (String)childMap.get("entrySeq");
                String entryqtytype = (String)childMap.get("entryqtytype");
                String parentFixed = "0";
                long entryId = (Long)childMap.get("entry_Id");
                childMap = MMCUtils.mapCopy(childMap);
                BigDecimal parentCommonused = BigDecimal.ZERO;
                if ("C".equals(entryqtytype)) {
                    Map<String, Object> retQtyMap = BomBackwardSearchBusiness.this.getQtyEntryCommonused(entryId, commonused, childEntryQtyNumerator, childEntryQtyDenominator);
                    childEntryQtyNumerator = (BigDecimal)retQtyMap.get("entryNumerator");
                    childEntryQtyDenominator = (BigDecimal)retQtyMap.get("entryDenominator");
                    childEntryQtyFixscrap = (BigDecimal)retQtyMap.get("entryfixscrap");
                    childEntryQtyScraprate = (BigDecimal)retQtyMap.get("entryscraprate");
                    issolid = (String)retQtyMap.get("issolid");
                    parentCommonused = (BigDecimal)retQtyMap.get("childCommonused");
                    childMap.put("entryqtynumerator", childEntryQtyNumerator);
                    childMap.put("entryqtydenominator", childEntryQtyDenominator);
                    childMap.put("entryfixscrap", childEntryQtyFixscrap);
                    childMap.put("entryscraprate", childEntryQtyScraprate);
                    childMap.put("issolid", issolid);
                } else if ("B".equals(entryqtytype)) {
                    parentCommonused = MMCUtils.divide((BigDecimal)childEntryQtyNumerator, (BigDecimal)childEntryQtyDenominator);
                    parentFixed = "1";
                } else {
                    parentCommonused = MMCUtils.multiplyAndDivide((BigDecimal)commonused, (BigDecimal)childEntryQtyNumerator, (BigDecimal)childEntryQtyDenominator);
                }
                UUID uuid = UUID.randomUUID();
                String randomId2 = uuid.toString().replace("-", "");
                String parentBomlevel = bomlevel + "-" + childEntrySeq;
                String parentLongNumber = longnumber + parentId;
                String parentOrderNo = orderNo + parentId + seq;
                String childRandomId = randomId + "-" + randomId2;
                if ("0".equals(isFixed)) {
                    childMap.put("commonused", parentCommonused);
                } else {
                    childMap.put("commonused", commonused);
                    parentFixed = "1";
                }
                childMap.put("pcommonused", commonused);
                childMap.put("bomlevel", parentBomlevel);
                childMap.put("level", levelStr);
                childMap.put("longnumber", parentLongNumber);
                childMap.put("orderNo", parentOrderNo);
                childMap.put("randomId", childRandomId);
                childMap.put("tmpver", tmpver);
                childMap.put("isFixed", parentFixed);
                replacenoSet.add((Long)childMap.get("replaceno"));
                wbsIdSet.add((Long)childMap.get("wbs"));
                retChildList.add(childMap);
            }
            if (retChildList.isEmpty()) {
                BomBackwardSearchBusiness.this.lastDataSetList.add(this.row);
                return null;
            }
            if (wbsIdSet.isEmpty()) {
                wbsIdSet.add(0L);
            }
            if ((wbsSetSize = wbsIdSet.size()) > 1 || wbsSetSize == 1 && !wbsIdSet.contains(this.wbsId)) {
                int size = retChildList.size();
                ArrayList<Map> tmpChildList1 = new ArrayList<Map>(size);
                ArrayList<Map> tmpChildList2 = new ArrayList<Map>(size);
                for (int i = 0; i < size; ++i) {
                    Map childMap = (Map)retChildList.get(i);
                    long childWBS = (Long)childMap.get("wbs");
                    if (this.wbsId == childWBS) {
                        tmpChildList1.add(childMap);
                    }
                    if (childWBS != 0L) continue;
                    tmpChildList2.add(childMap);
                }
                retChildList = !tmpChildList1.isEmpty() ? Collections.synchronizedList(tmpChildList1) : Collections.synchronizedList(tmpChildList2);
            }
            if (replacenoSet.isEmpty()) {
                replacenoSet.add(0L);
            }
            int replacenoSetSize = replacenoSet.size();
            long replaceno = Long.parseLong(this.insteadNum.getValue() + "");
            if (replacenoSetSize > 1 || replacenoSetSize == 1 && !replacenoSet.contains(replaceno)) {
                int size = retChildList.size();
                ArrayList<Map<String, Object>> tmpChildList1 = new ArrayList<Map<String, Object>>(size);
                ArrayList<Map<String, Object>> tmpChildList2 = new ArrayList<Map<String, Object>>(size);
                for (int i = 0; i < size; ++i) {
                    Map<String, Object> childMap = retChildList.get(i);
                    long childReplaceNo = (Long)childMap.get("replaceno");
                    if (replaceno == childReplaceNo) {
                        tmpChildList1.add(childMap);
                    }
                    if (childReplaceNo != 0L) continue;
                    tmpChildList2.add(childMap);
                }
                retChildList = !tmpChildList1.isEmpty() ? Collections.synchronizedList(tmpChildList1) : Collections.synchronizedList(tmpChildList2);
            }
            return retChildList;
        }
    }
}

