/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.mftbom.bomsearch.batch;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMExpandConfigBusiness;
import kd.mmc.pdm.business.mftbom.bomsearch.BOMReportFromProConfigBusiness;
import kd.mmc.pdm.business.mftbom.bomsearch.BomBackwardSearchBusiness;
import kd.mmc.pdm.business.mftbom.bomsearch.BomForwardSearchBusiness;
import kd.mmc.pdm.business.proconfig.proconfiglist.ProductConifgListBusiness;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;

public class BomBatchSearchImpl {
    private static final Log log = LogFactory.getLog(BomBatchSearchImpl.class);
    private static BomBatchSearchImpl impl;
    private static final String FALSEVALUE = "false";
    public static final String REDIS_PATCH = "mmc-pdm-bombatchsearch";
    DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-pdm-bombatchsearch");

    public static BomBatchSearchImpl getInstance() {
        if (impl == null) {
            impl = new BomBatchSearchImpl();
        }
        return impl;
    }

    public JSONObject exec(Map<String, Object> paramMap) {
        String errorMsg;
        String uuid = this.getStringValueFromMap(paramMap, "uuid");
        String cacheId = "";
        String message = "";
        DataSet dataSet = null;
        boolean isCacheRedis = this.isCacheRedis(paramMap);
        if (this.isForwardSearch(paramMap)) {
            try {
                dataSet = this.bomForwardSearch(paramMap);
                if (PlatformUtils.isNullDataSet((DataSet)dataSet)) {
                    message = ResManager.loadKDString((String)"\u5c55\u5f00\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"BomBatchSearchImpl_05", (String)"mmc-pdm-business", (Object[])new Object[0]);
                } else if (isCacheRedis) {
                    cacheId = this.cacheDataSet(dataSet);
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                errorMsg = PlatformUtils.getSimpleExceptionString((Exception)e);
                message = String.format(ResManager.loadKDString((String)"BOM\u5c55\u5f00\u9519\u8bef:%1$s\u3002", (String)"BomBatchSearchImpl_04", (String)"mmc-pdm-business", (Object[])new Object[0]), errorMsg);
            }
        } else if (this.isBackSearch(paramMap)) {
            try {
                dataSet = this.bomBackSearch(paramMap);
                if (PlatformUtils.isNullDataSet((DataSet)dataSet)) {
                    message = ResManager.loadKDString((String)"\u53cd\u67e5\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"BomBatchSearchImpl_06", (String)"mmc-pdm-business", (Object[])new Object[0]);
                } else if (isCacheRedis) {
                    cacheId = this.cacheDataSet(dataSet);
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                errorMsg = PlatformUtils.getSimpleExceptionString((Exception)e);
                message = String.format(ResManager.loadKDString((String)"BOM\u53cd\u67e5\u9519\u8bef:%1$s\u3002", (String)"BomBatchSearchImpl_07", (String)"mmc-pdm-business", (Object[])new Object[0]), errorMsg);
            }
        }
        JSONObject result = this.buildReturnJson(message, cacheId, uuid);
        if (isCacheRedis) {
            String queryType = PlatformUtils.getStringValue(paramMap, (String)"querytype");
            this.setRedisCache(queryType + "_" + uuid, result.toJSONString());
        } else {
            result.put("dataset", (Object)dataSet);
        }
        return result;
    }

    private String cacheDataSet(DataSet dataSet) {
        CacheHint hint = new CacheHint();
        hint.setTimeout(3600000L);
        CachedDataSet cache = dataSet.cache(hint);
        dataSet.close();
        return cache.getCacheId();
    }

    private Map<String, TreeMap<Integer, Object>> genBomExpandMap(DynamicObject bomExpandConfigObj) {
        return BOMExpandConfigBusiness.getBomExpandConfig(bomExpandConfigObj.getLong("id"));
    }

    private DynamicObject genBomExpandConfig(Map<String, Object> paramMap) {
        Long bomExpandConfigId = this.getLongValueFromMap(paramMap, "bomexpandConfigId");
        DynamicObject bomExpandConfigObj = BusinessDataServiceHelper.newDynamicObject((String)"mpdm_bomexpandconfig");
        bomExpandConfigObj.set("id", (Object)bomExpandConfigId);
        return bomExpandConfigObj;
    }

    private DataSet bomForwardSearch(Map<String, Object> paramMap) throws Exception {
        DataSet set;
        long replaceNo;
        boolean isNullConfigurecode;
        Long orgId = this.getLongValueFromMap(paramMap, "orgid");
        DynamicObject bomExpandConfigObj = this.genBomExpandConfig(paramMap);
        Map<String, TreeMap<Integer, Object>> bomExpandMap = this.genBomExpandMap(bomExpandConfigObj);
        Long materialId = this.getLongValueFromMap(paramMap, "materialid");
        Long bomVersionId = this.getLongValueFromMap(paramMap, "bomversionid");
        Long insteadNumId = this.getLongValueFromMap(paramMap, "insteadnumid");
        Long wbsId = this.getLongValueFromMap(paramMap, "wbsid");
        DynamicObject insteadObj = this.getReplaceNoObj(insteadNumId);
        Long configureCodeId = this.getLongValueFromMap(paramMap, "configurecodeid");
        String configProperties = this.getStringValueFromMap(paramMap, "configproperties");
        boolean isOpenVer = this.getBooleanValueFromMap(paramMap, "isenablematerialversion");
        String showType = this.getStringValueFromMap(paramMap, "showtype");
        boolean isshowlast = this.getBooleanValueFromMap(paramMap, "isshowlast");
        boolean purchaseExpand = this.getBooleanValueFromMap(paramMap, "purchaseexpand");
        boolean jumpLevelExpand = this.getBooleanValueFromMap(paramMap, "jumplevelexpand");
        BigDecimal demandCount = this.getBigDecimalValueFromMap(paramMap, "demandcount");
        Date searchDate = this.getDateValueFromMap(paramMap, "searchdate");
        String verConfig = BOMExpandConfigBusiness.getExpandVerConfig(bomExpandMap);
        int levelCount = this.getIntValueFromMap(paramMap, "levelcount");
        QFilter ids = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_mftbom", (Long)orgId);
        String purpose = BOMExpandConfigBusiness.getPurPose(materialId, configureCodeId, null);
        Set<Long> bomTypeSet = BOMExpandConfigBusiness.getBomTypeOfPurpose(bomExpandMap, purpose);
        QFilter material = new QFilter("materialid", "=", (Object)materialId);
        QFilter bomType = new QFilter("type", "in", bomTypeSet);
        QFilter version = new QFilter("version", "=", (Object)bomVersionId);
        QFilter configCode = new QFilter("configuredcode", "=", (Object)configureCodeId);
        QFilter effect = new QFilter("entry.entryvaliddate", "<=", (Object)searchDate);
        QFilter invalid = new QFilter("entry.entryinvaliddate", ">=", (Object)searchDate);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        Object[] allDataFilter = new QFilter[]{status, enable, effect, invalid, ids};
        Object[] globalDataFilter = (QFilter[])allDataFilter.clone();
        globalDataFilter = (QFilter[])ArrayUtils.add((Object[])globalDataFilter, (Object)bomType);
        globalDataFilter = (QFilter[])ArrayUtils.add((Object[])globalDataFilter, (Object)material);
        if (bomVersionId != null && !bomVersionId.equals(0L)) {
            globalDataFilter = (QFilter[])ArrayUtils.add((Object[])globalDataFilter, (Object)version);
        }
        if (!((isNullConfigurecode = PlatformUtils.isNullLong((Long)configureCodeId)) || "".equals(configProperties) || "1".equals(configProperties))) {
            globalDataFilter = (QFilter[])ArrayUtils.add((Object[])globalDataFilter, (Object)configCode);
        }
        String isLeaf = FALSEVALUE;
        String rondomId = "";
        BomForwardSearchBusiness forwardBusiness = new BomForwardSearchBusiness(FALSEVALUE, demandCount, false, bomExpandConfigObj, purchaseExpand, purpose, levelCount, jumpLevelExpand);
        long l = replaceNo = insteadObj == null ? 0L : insteadObj.getLong("id");
        if (!isNullConfigurecode) {
            if ("true".equals(isLeaf) || QueryServiceHelper.exists((String)"pdm_mftbom", (QFilter[])globalDataFilter)) {
                set = forwardBusiness.getDataSet((QFilter[])allDataFilter, (QFilter[])globalDataFilter, showType, isshowlast, searchDate, insteadObj, rondomId, verConfig, bomVersionId, wbsId, true);
                String expandTypeName = ResManager.loadKDString((String)"\u8ba2\u5355BOM", (String)"BomBatchSearchImpl_01", (String)"mmc-pdm-business", (Object[])new Object[0]);
                log.error("--------------BomBatchSearchImpl.bomForwardSearch------query by :" + expandTypeName + ",allDataFilter=" + Arrays.toString(allDataFilter) + ",globalDataFilter=" + Arrays.toString(globalDataFilter) + ",searchDate=" + searchDate + ",insteadObj=" + (insteadObj == null ? "0" : insteadObj.getPkValue().toString()));
            } else {
                ArrayList<Long> list = new ArrayList<Long>();
                list.add(configureCodeId);
                JSONObject params = new JSONObject();
                params.put("searchTime", (Object)searchDate);
                params.put("isNeedProRoute", (Object)false);
                params.put("model", (Object)"model_pdm");
                params.put("configCodeList", list);
                params.put("org", (Object)orgId);
                params.put("matId", (Object)materialId);
                params.put("wbs", (Object)wbsId);
                params.put("bomVer", (Object)bomVersionId);
                params.put("replaceNo", (Object)replaceNo);
                params.put("purchaseExpand", (Object)purchaseExpand);
                params.put("num", (Object)demandCount);
                params.put("levelCount", (Object)levelCount);
                params.put("jumplevelExpand", (Object)jumpLevelExpand);
                JSONObject retObj = ProductConifgListBusiness.getInstance().getProdConfigListByFeature(params.toJSONString());
                RowMeta rowMeta = this.getRowMeta(forwardBusiness);
                BOMReportFromProConfigBusiness business = new BOMReportFromProConfigBusiness("");
                set = business.parseToDataSetFromJson(rowMeta, retObj, configureCodeId, false);
                if ("B".equals(showType)) {
                    String showItems = forwardBusiness.getShowTogeterItems();
                    set = set.groupBy(showItems.split(",")).sum("commonused").finish().orderBy(new String[]{"entrymaterialId"});
                }
                String expandTypeName = String.format(ResManager.loadKDString((String)"\u914d\u7f6eBOM\uff08\u914d\u7f6e\u53f7\uff1a%1$s\uff09\u3002", (String)"BomBatchSearchImpl_02", (String)"mmc-pdm-business", (Object[])new Object[0]), configureCodeId);
                log.error("--------------BomBatchSearchImpl.bomForwardSearch------query by :" + expandTypeName + ",allDataFilter=" + Arrays.toString(allDataFilter) + ",globalDataFilter=" + Arrays.toString(globalDataFilter) + ",searchDate=" + searchDate + ",insteadObj=" + (insteadObj == null ? "0" : insteadObj.getPkValue().toString()) + ",configureCodeId=" + configureCodeId + ",wbsId=" + wbsId);
            }
        } else {
            set = forwardBusiness.getDataSet((QFilter[])allDataFilter, (QFilter[])globalDataFilter, showType, isshowlast, searchDate, insteadObj, rondomId, verConfig, bomVersionId, wbsId, true);
            String expandTypeName = ResManager.loadKDString((String)"\u5236\u9020BOM", (String)"BomBatchSearchImpl_03", (String)"mmc-pdm-business", (Object[])new Object[0]);
            log.error("--------------BomBatchSearchImpl.bomForwardSearch------query by :" + expandTypeName + ",allDataFilter=" + Arrays.toString(allDataFilter) + ",globalDataFilter=" + Arrays.toString(globalDataFilter) + ",searchDate=" + searchDate + ",insteadObj=" + (insteadObj == null ? "0" : insteadObj.getPkValue().toString()) + ",wbsId=" + wbsId);
        }
        if (set != null && !set.isEmpty()) {
            set = set.addFields(new String[]{configureCodeId + "L", materialId + "L", bomVersionId + "L", insteadNumId + "L", wbsId + "L"}, new String[]{"rootconfigcode", "rootmaterialid", "rootbomversion", "rootinsteadnum", "rootwbs"});
            set = this.setAddFieldType(set, "bombatchforwardsearch");
        }
        return set;
    }

    private DataSet bomBackSearch(Map<String, Object> paramMap) throws Exception {
        QFilter material;
        Long orgId = this.getLongValueFromMap(paramMap, "orgid");
        Long materialId = this.getLongValueFromMap(paramMap, "materialid");
        Long bomVersionId = this.getLongValueFromMap(paramMap, "bomversionid");
        Long insteadNumId = this.getLongValueFromMap(paramMap, "insteadnumid");
        Long wbsId = this.getLongValueFromMap(paramMap, "wbsid");
        DynamicObject insteadObj = this.getReplaceNoObj(insteadNumId);
        Long featureTypeId = this.getLongValueFromMap(paramMap, "featuretypeid");
        String showType = this.getStringValueFromMap(paramMap, "showtype");
        BigDecimal demandCount = this.getBigDecimalValueFromMap(paramMap, "demandcount");
        Date searchDate = this.getDateValueFromMap(paramMap, "searchdate");
        DynamicObject bomExpandConfigObj = this.genBomExpandConfig(paramMap);
        Map<String, TreeMap<Integer, Object>> bomExpandMap = this.genBomExpandMap(bomExpandConfigObj);
        int levelCount = this.getIntValueFromMap(paramMap, "levelcount");
        String rondomId = "";
        QFilter ids = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_mftbom", (Long)orgId);
        QFilter version = new QFilter("entry.entryversion", "=", (Object)bomVersionId);
        QFilter effect = new QFilter("entry.entryvaliddate", "<=", (Object)searchDate);
        QFilter invalid = new QFilter("entry.entryinvaliddate", ">=", (Object)searchDate);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        Object[] allDataFilter = new QFilter[]{status, enable, effect, invalid, ids};
        Object[] matDataFilter = (QFilter[])ArrayUtils.add((Object[])allDataFilter, (Object)version);
        Object[] featureDataFilter = (QFilter[])allDataFilter.clone();
        String isLeaf = FALSEVALUE;
        BomBackwardSearchBusiness backwardSearchBusiness = new BomBackwardSearchBusiness(isLeaf, demandCount, false, levelCount, bomExpandConfigObj);
        Set<Long> matIdSet = new HashSet<Long>(10);
        Set<Object> featureTypeSet = new HashSet(10);
        if (!PlatformUtils.isNullLong((Long)materialId)) {
            matIdSet.add(materialId);
            featureTypeSet = backwardSearchBusiness.getFeatureTypeByMat(matIdSet);
            material = new QFilter("entry.entrymaterialid", "in", matIdSet);
            log.error("--------------BomBatchSearchImpl.bomBackSearch------query by material:" + materialId + ",featureTypeSet=" + (featureTypeSet == null ? "" : Arrays.toString(featureTypeSet.toArray())));
        } else if (!PlatformUtils.isNullLong((Long)featureTypeId)) {
            matIdSet = backwardSearchBusiness.getFeatureTypeByMat(featureTypeId);
            featureTypeSet.add(featureTypeId);
            material = new QFilter("entry.entrymaterialid", "=", (Object)-1L);
            log.error("--------------BomBatchSearchImpl.bomBackSearch------query by featuretype:" + featureTypeId + ",matIdSet=" + (matIdSet == null ? "" : Arrays.toString(matIdSet.toArray())));
        } else {
            material = new QFilter("entry.entrymaterialid", "=", (Object)-1L);
        }
        QFilter featureType = new QFilter("entry.featuretype", "in", featureTypeSet);
        matDataFilter = (QFilter[])ArrayUtils.add((Object[])matDataFilter, (Object)material);
        featureDataFilter = (QFilter[])ArrayUtils.add((Object[])featureDataFilter, (Object)featureType);
        DataSet set = backwardSearchBusiness.getDataSet((QFilter[])allDataFilter, (QFilter[])matDataFilter, (QFilter[])featureDataFilter, showType, false, searchDate, insteadObj, rondomId, true, matIdSet, bomVersionId, wbsId);
        log.error("--------------BomBatchSearchImpl.bomBackSearch------query end,allDataFilter=" + Arrays.toString(allDataFilter) + ",matDataFilter=" + Arrays.toString(matDataFilter) + ",featureDataFilter=" + Arrays.toString(featureDataFilter) + ",searchDate=" + searchDate + ",insteadObj=" + (insteadObj == null ? "0" : insteadObj.getPkValue().toString()) + ",matIdSet=" + (matIdSet == null ? "" : Arrays.toString(matIdSet.toArray())));
        if (set != null && !set.isEmpty()) {
            set = set.addFields(new String[]{featureTypeId + "L", materialId + "L", bomVersionId + "L", insteadNumId + "L", wbsId + "L"}, new String[]{"rootfeaturetype", "rootmaterialid", "rootbomversion", "rootinsteadnum", "rootwbs"});
            set = this.setAddFieldType(set, "bombatchbacksearch");
        }
        return set;
    }

    private DataSet setAddFieldType(DataSet ds, String expandType) {
        Map<String, DataType> fieldTypeMap = this.getAddFieldType(expandType);
        for (Map.Entry<String, DataType> fieldTypes : fieldTypeMap.entrySet()) {
            ds.getRowMeta().getField(fieldTypes.getKey()).setDataType(fieldTypes.getValue());
        }
        return ds;
    }

    private Map<String, DataType> getAddFieldType(String expandType) {
        HashMap<String, DataType> fieldTypeMap = new HashMap<String, DataType>(16);
        fieldTypeMap.put("rootmaterialid", (DataType)DataType.LongType);
        fieldTypeMap.put("rootbomversion", (DataType)DataType.LongType);
        fieldTypeMap.put("rootinsteadnum", (DataType)DataType.LongType);
        fieldTypeMap.put("rootwbs", (DataType)DataType.LongType);
        if ("bombatchforwardsearch".equals(expandType)) {
            fieldTypeMap.put("rootconfigcode", (DataType)DataType.LongType);
        } else if ("bombatchbacksearch".equals(expandType)) {
            fieldTypeMap.put("rootfeaturetype", (DataType)DataType.LongType);
        }
        return fieldTypeMap;
    }

    private String getStringValueFromMap(Map<String, Object> paramMap, String fieldNumber) {
        return PlatformUtils.getStringValue(paramMap, (String)fieldNumber);
    }

    private Long getLongValueFromMap(Map<String, Object> paramMap, String fieldNumber) {
        return PlatformUtils.getLongValue(paramMap, (String)fieldNumber);
    }

    private int getIntValueFromMap(Map<String, Object> paramMap, String fieldNumber) {
        return PlatformUtils.getIntValue(paramMap, (String)fieldNumber);
    }

    private boolean getBooleanValueFromMap(Map<String, Object> paramMap, String fieldNumber) {
        return PlatformUtils.getBooleanValue(paramMap, (String)fieldNumber);
    }

    private Date getDateValueFromMap(Map<String, Object> paramMap, String fieldNumber) {
        return PlatformUtils.getDateValue(paramMap, (String)fieldNumber);
    }

    private BigDecimal getBigDecimalValueFromMap(Map<String, Object> paramMap, String fieldNumber) {
        return PlatformUtils.getBigDecimalValue(paramMap, (String)fieldNumber);
    }

    private JSONObject buildReturnJson(String message, String cacheId, String uuid) {
        JSONObject result = new JSONObject(16);
        result.put("cacheid", (Object)cacheId);
        result.put("message", (Object)message);
        result.put("uuid", (Object)uuid);
        return result;
    }

    private boolean isForwardSearch(Map<String, Object> paramMap) {
        String queryType = PlatformUtils.getStringValue(paramMap, (String)"querytype");
        return queryType != null && "bombatchforwardsearch".equals(queryType);
    }

    private boolean isCacheRedis(Map<String, Object> paramMap) {
        String queryType = PlatformUtils.getStringValue(paramMap, (String)"cacheredis");
        return queryType != null && "true".equals(queryType);
    }

    private boolean isBackSearch(Map<String, Object> paramMap) {
        String queryType = PlatformUtils.getStringValue(paramMap, (String)"querytype");
        return queryType != null && "bombatchbacksearch".equals(queryType);
    }

    public DynamicObject getReplaceNoObj(Long insteadId) {
        if (PlatformUtils.isNullLong((Long)insteadId)) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)insteadId, (String)"mpdm_replaceno", (String)"id");
    }

    public DynamicObject getBomExpandConfigObj(Long expandid) {
        if (PlatformUtils.isNullLong((Long)expandid)) {
            return null;
        }
        String selectProperties = "id,number,superbomtype.id,probomtype.id,orderbomtype.id,isopenauxbom,auxbomtype";
        return BusinessDataServiceHelper.loadSingleFromCache((Object)expandid, (String)"mpdm_bomexpandconfig", (String)selectProperties);
    }

    public RowMeta getRowMeta(BomForwardSearchBusiness forwardBusiness) {
        String formNum = "pdm_mftbom";
        UUID uuid = UUID.randomUUID();
        String randomId = uuid.toString().replace("-", "");
        String selectItems = forwardBusiness.getSelectItems("1");
        selectItems = selectItems + ",concat('" + randomId + "',version) randomId,version tmpver";
        RowMeta meta = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BOMForwardSearchReportPlugin", (String)formNum, (String)selectItems, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)-1L)}, null);){
            meta = dataSet.getRowMeta();
        }
        return meta;
    }

    private void setRedisCache(String keyString, String value) {
        this.redisCache.put(keyString, (Object)value, 1200);
    }
}

