/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.mftbom.replace;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.bom.ReplacePlanBusiness;
import kd.bd.mpdm.common.query.helper.MaterialMftQueryHelper;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.query.helper.OrgQueryHelper;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.fmm.business.bom.AbstractReplacePlanUpdateBomExtPlugin;
import kd.mmc.fmm.business.bom.BomSyncCostUtils;
import kd.mmc.fmm.business.bom.ext.IReplacePlanUpdateBomExt;
import kd.mmc.fmm.business.bom.ext.ReplacePlanUpdateBomExtPlugin;
import kd.mmc.pdm.business.ecoplatform.EcoUtils;
import kd.mmc.pdm.common.bom.ecoplatform.PlatformUtils;
import kd.mmc.pdm.common.bom.replace.BomReplaceConsts;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;

public class ReplacePlanUpdateBomBusiness {
    private static final Log log = LogFactory.getLog(ReplacePlanUpdateBomBusiness.class);
    public static final String EXT_PLGUIN_NUMBER = "FMM_REPLACEPLAN_UPDATEBOM_EXT";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject updateBom(Long bomId, Set<Long> bomEntryIdSet, String replaceGroupNo, Long replacePlanId, String updateType) {
        log.info("mmc_pdm_ReplacePlanUpdateBomBusiness_updateBom:bomId=" + bomId + ",replaceGroupNo =" + replaceGroupNo + ",replacePlanId = " + replacePlanId + ",bomEntryIdSet=" + bomEntryIdSet.toString());
        DynamicObject replacePlan = this.getReplacePlan(replacePlanId);
        String msg = "";
        String msg_tag = "";
        JSONObject resultData = this.buildResultData("", true, "");
        String lockKeys = "mmc.pdm.materialreplaceplanUpdate_" + bomId;
        DLock lock = DLock.create((String)lockKeys, (String)lockKeys);
        lock.lock();
        try {
            DynamicObject bom = BusinessDataServiceHelper.loadSingle((Object)bomId, (String)"pdm_mftbom");
            log.info("mmc_pdm_ReplacePlanUpdateBomBusiness_updateBom:bom.number=" + bom.getString("number") + ",bom.status =" + bom.getString("status") + ",replacePlan.number = " + replacePlan.getString("number"));
            DynamicObject bomRepConfig = this.getBomRepConfig();
            log.info("mmc_pdm_ReplacePlanUpdateBomBusiness_updateBom:updateType=" + updateType);
            if (("A".equals(updateType) || "B".equals(updateType) || "D".equals(updateType)) && !StringUtils.isEmpty((String)(msg = this.checkBomAndReplacePlan(replacePlan, bom)))) {
                JSONObject jSONObject = this.buildResultData(msg, false, msg);
                return jSONObject;
            }
            if ("A".equals(updateType)) {
                boolean isMatch = this.checkIsFullMatch(bomEntryIdSet, replacePlan);
                if (!isMatch) {
                    msg = ResManager.loadKDString((String)"BOM\u7ec4\u4ef6\u5206\u5f55\u4e0a\u7684\u66ff\u4ee3\u4e3b\u6599\u4e0e\u672c\u65b9\u6848\u7684\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u65b0\u589e\u66ff\u4ee3\u3002", (String)"ReplacePlanUpdateBomBusiness_06", (String)"mmc-pdm-business", (Object[])new Object[0]);
                    JSONObject jSONObject = this.buildResultData(msg, false, msg);
                    return jSONObject;
                }
                resultData = this.addBomReplacePlan(bom, bomEntryIdSet, replaceGroupNo, replacePlan, bomRepConfig);
            } else if ("B".equals(updateType) || "D".equals(updateType)) {
                DynamicObject oldReplacePlan = this.getOldReplacePlan(bom, bomEntryIdSet);
                if (oldReplacePlan == null) {
                    msg = ResManager.loadKDString((String)"BOM\u7ec4\u4ef6\u5206\u5f55\u4e0a\u65e0\u66ff\u4ee3\u65b9\u6848\uff0c\u8bf7\u5237\u65b0\u540e\u5904\u7406\u3002", (String)"ReplacePlanUpdateBomBusiness_10", (String)"mmc-pdm-business", (Object[])new Object[0]);
                    JSONObject jSONObject = this.buildResultData(msg, false, msg);
                    return jSONObject;
                }
                Map<String, Long> entryIdOldMap = this.deleteBomReplacePlan(bom, replaceGroupNo, oldReplacePlan, bomRepConfig);
                boolean isMatch = this.checkIsFullMatch(bomEntryIdSet, replacePlan);
                if (!isMatch) {
                    msg = ResManager.loadKDString((String)"BOM\u7ec4\u4ef6\u5206\u5f55\u4e0a\u7684\u66ff\u4ee3\u4e3b\u6599\u4e0e\u672c\u66ff\u4ee3\u65b9\u6848\u7684\u66ff\u4ee3\u4e3b\u6599\u4e0d\u5339\u914d\uff0c\u4e0d\u8fdb\u884c\u66f4\u65b0\u5904\u7406\u3002", (String)"ReplacePlanUpdateBomBusiness_03", (String)"mmc-pdm-business", (Object[])new Object[0]);
                    JSONObject jSONObject = this.buildResultData(msg, false, msg);
                    return jSONObject;
                }
                resultData = this.addBomReplacePlan(bom, bomEntryIdSet, replaceGroupNo, replacePlan, bomRepConfig);
                this.resetBomEntryId(bom, replaceGroupNo, replacePlan, bomRepConfig, entryIdOldMap);
                log.info("mmc_pdm_ReplacePlanUpdateBomBusiness_updateBom:isMatch=" + isMatch);
            } else {
                if (replacePlan == null) {
                    msg = ResManager.loadKDString((String)"BOM\u7ec4\u4ef6\u5206\u5f55\u4e0a\u65e0\u66ff\u4ee3\u65b9\u6848\uff0c\u8bf7\u5237\u65b0\u540e\u5904\u7406\u3002", (String)"ReplacePlanUpdateBomBusiness_10", (String)"mmc-pdm-business", (Object[])new Object[0]);
                    JSONObject jSONObject = this.buildResultData(msg, false, msg);
                    return jSONObject;
                }
                this.deleteBomReplacePlan(bom, replaceGroupNo, replacePlan, bomRepConfig);
            }
            if (this.isError(resultData)) {
                JSONObject jSONObject = resultData;
                return jSONObject;
            }
            msg = this.saveBom(bom);
            if (!StringUtils.isEmpty((String)msg)) {
                JSONObject jSONObject = this.buildResultData(msg, false, msg);
                return jSONObject;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            msg = PlatformUtils.getSimpleExceptionString((Exception)e);
            msg_tag = PlatformUtils.getExceptionString((Exception)e);
            JSONObject jSONObject = this.buildResultData(msg, false, msg_tag);
            return jSONObject;
        }
        finally {
            lock.unlock();
        }
        return resultData;
    }

    private JSONObject addBomReplacePlan(DynamicObject bom, Set<Long> bomEntryIdSet, String replaceGroupNo, DynamicObject replacePlan, DynamicObject bomRepConfig) {
        String checkMaterialMsg = this.checkMaterialValidData(replacePlan, bom);
        if (checkMaterialMsg.length() > 0) {
            return this.buildResultData(checkMaterialMsg, false, checkMaterialMsg);
        }
        DynamicObjectCollection bomEntryColl = bom.getDynamicObjectCollection("entry");
        String errorString = "";
        DynamicObjectCollection mmEntryColl = this.getReplacePlanMMEntry(replacePlan);
        DynamicObjectCollection repEntryColl = this.getReplacePlanRMEntry(replacePlan);
        Map<String, DynamicObject> replacePlanMMEntryMap = this.getReplacePlanMainMaterialKeys(mmEntryColl, bomRepConfig);
        Map<Integer, DynamicObject> repPriorityMap = this.getRepEntrtPriorityMap(repEntryColl);
        ORM orm = ORM.create();
        boolean isOpt = this.isEntryOpt(bom);
        DynamicObject bomEntry = null;
        BigDecimal bomMole = BigDecimal.ZERO;
        BigDecimal bomDone = BigDecimal.ZERO;
        BigDecimal mole = BigDecimal.ZERO;
        BigDecimal deno = BigDecimal.ZERO;
        DynamicObject replacePlanMMEntry = null;
        DynamicObject bomEntryReplacePlanMMRow = null;
        Object extPluginObject = this.getExtPlugin();
        PluginProxy<IReplacePlanUpdateBomExt> newExtPlugin = this.genExtPluginxy();
        for (int i = 0; i < bomEntryColl.size(); ++i) {
            Long bomEntryId = ((DynamicObject)bomEntryColl.get(i)).getLong("id");
            if (!bomEntryIdSet.contains(bomEntryId)) continue;
            bomEntry = (DynamicObject)bomEntryColl.get(i);
            DynamicObject bomReplacePlan = bomEntry.getDynamicObject("entryreplaceplan");
            replacePlanMMEntry = this.getReplacePlanMMEntry(bomEntry, replacePlanMMEntryMap, bomRepConfig);
            DynamicObject materialMaster = bomEntry.getDynamicObject("entrymaterialid");
            boolean isReplaceMM = false;
            if (replacePlanMMEntry != null && (isReplaceMM = replacePlanMMEntry.getBoolean("isreplace"))) {
                bomEntryReplacePlanMMRow = bomEntry;
            }
            if (bomReplacePlan == null) {
                if (replacePlanMMEntry == null) {
                    errorString = String.format(ResManager.loadKDString((String)"BOM\u7f16\u7801\uff1a%1$s\u7b2c\u201c%2$s\u201d\u884c\u7ec4\u4ef6\u5206\u5f55\u7269\u6599\u201c%3$s\u201d\uff0c\u65e0\u6cd5\u5728\u66ff\u4ee3\u65b9\u6848\u201c%4$s\u201d\u4e2d\u627e\u5230\u5bf9\u5e94\u7684\u4e3b\u7269\u6599\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002\u00a0", (String)"ReplacePlanUpdateBomBusiness_01", (String)"mmc-pdm-business", (Object[])new Object[0]), bom.getString("number"), bomEntry.get("seq"), materialMaster.getString("number"), replacePlan.getString("number"));
                    return this.buildResultData(errorString, false, errorString);
                }
                bomEntry.set("entryisreplaceplanmm", (Object)isReplaceMM);
                bomEntry.set("entryreplaceplan", (Object)replacePlan);
                bomEntry.set("entryreplacegroup", (Object)replaceGroupNo);
                bomEntry.set("entryisreplace", (Object)Boolean.FALSE);
                if (!isReplaceMM) continue;
                bomMole = bomEntry.getBigDecimal("entryqtynumerator");
                bomDone = bomEntry.getBigDecimal("entryqtydenominator");
                mole = replacePlanMMEntry.getBigDecimal("mole");
                deno = replacePlanMMEntry.getBigDecimal("deno");
                continue;
            }
            String msg = ResManager.loadKDString((String)"BOM\u7ec4\u4ef6\u5206\u5f55\u5df2\u8fdb\u884c\u66ff\u4ee3\u5904\u7406\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"ReplacePlanUpdateBomBusiness_11", (String)"mmc-pdm-business", (Object[])new Object[0]);
            return this.buildResultData(msg, false, msg);
        }
        if (replacePlanMMEntry != null && bomEntry != null && bomDone.compareTo(BigDecimal.ZERO) > 0) {
            int addIndex = 0;
            int bomSeq = bomEntry.getInt("seq");
            for (Map.Entry<Integer, DynamicObject> repEntrys : repPriorityMap.entrySet()) {
                int repPriorityKey = repEntrys.getKey();
                DynamicObject repEntryKey = repEntrys.getValue();
                BigDecimal repMainmole = this.getReplaceMaterialEntryMole(repEntryKey);
                BigDecimal repMaindeno = this.getReplaceMaterialEntryDeno(repEntryKey);
                BigDecimal newMainMole = MMCUtils.multiply((BigDecimal)MMCUtils.multiply((BigDecimal)repMainmole, (BigDecimal)bomMole), (BigDecimal)deno);
                BigDecimal newMainDone = MMCUtils.multiply((BigDecimal)MMCUtils.multiply((BigDecimal)repMaindeno, (BigDecimal)bomDone), (BigDecimal)mole);
                for (int j = 0; j < repEntryColl.size(); ++j) {
                    DynamicObject repEntry = (DynamicObject)repEntryColl.get(j);
                    int repPriority = repEntry.getInt("reppriority");
                    if (repPriorityKey != repPriority) continue;
                    BigDecimal repmole = this.getReplaceMaterialEntryMole(repEntry);
                    BigDecimal repdeno = this.getReplaceMaterialEntryDeno(repEntry);
                    if (repEntry.getPkValue().equals(repEntryKey.getPkValue())) {
                        BigDecimal pointNum = this.getMultiplyNumber(newMainMole, newMainDone, bomRepConfig);
                        newMainMole = MMCUtils.multiply((BigDecimal)newMainMole, (BigDecimal)pointNum);
                        newMainDone = MMCUtils.multiply((BigDecimal)newMainDone, (BigDecimal)pointNum);
                        BigDecimal commomDivisor = this.getCommomDivisor(newMainMole, newMainDone, bomRepConfig);
                        newMainMole = MMCUtils.divide((BigDecimal)newMainMole, (BigDecimal)commomDivisor);
                        newMainDone = MMCUtils.divide((BigDecimal)newMainDone, (BigDecimal)commomDivisor);
                    } else {
                        BigDecimal com = MMCUtils.multiply((BigDecimal)repMainmole, (BigDecimal)repMaindeno);
                        BigDecimal newMole = MMCUtils.multiplyAndDivide((BigDecimal)newMainMole, (BigDecimal)repmole, (BigDecimal)repMainmole);
                        BigDecimal newDone = MMCUtils.multiplyAndDivide((BigDecimal)newMainDone, (BigDecimal)repdeno, (BigDecimal)repMaindeno);
                        BigDecimal pointNum = this.getMultiplyNumber(newMole, newDone, bomRepConfig);
                        newMole = MMCUtils.multiply((BigDecimal)newMole, (BigDecimal)pointNum);
                        newDone = MMCUtils.multiply((BigDecimal)newDone, (BigDecimal)pointNum);
                        BigDecimal commomDivisor = this.getCommomDivisor(newMole, newDone, bomRepConfig);
                        newMole = MMCUtils.divide((BigDecimal)newMole, (BigDecimal)commomDivisor);
                        newDone = MMCUtils.divide((BigDecimal)newDone, (BigDecimal)commomDivisor);
                        newMainMole = newMole;
                        newMainDone = newDone;
                    }
                    this.addBomEntry(bom, bomEntry, repEntry, newMainMole, newMainDone, bomSeq + addIndex, bomRepConfig.getBoolean("iscalculate"), orm, isOpt, extPluginObject, bomEntryReplacePlanMMRow, newExtPlugin);
                    ++addIndex;
                }
            }
        }
        return this.buildResultData("", true, "");
    }

    private DynamicObject getOldReplacePlan(DynamicObject bom, Set<Long> bomentryIdSet) {
        DynamicObjectCollection bomEntryColl = bom.getDynamicObjectCollection("entry");
        for (int i = 0; i < bomEntryColl.size(); ++i) {
            DynamicObject bomEntry = (DynamicObject)bomEntryColl.get(i);
            DynamicObject bomReplacePlan = bomEntry.getDynamicObject("entryreplaceplan");
            if (!bomentryIdSet.contains((Long)bomEntry.getPkValue())) continue;
            return bomReplacePlan;
        }
        return null;
    }

    private Map<String, Long> deleteBomReplacePlan(DynamicObject bom, String replaceGroupNo, DynamicObject replacePlan, DynamicObject bomRepConfig) {
        if (replacePlan == null) {
            return new HashMap<String, Long>(16);
        }
        DynamicObjectCollection bomEntryColl = bom.getDynamicObjectCollection("entry");
        HashMap<String, Long> oldMap = new HashMap<String, Long>(16);
        ArrayList<DynamicObject> replaceList = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < bomEntryColl.size(); ++i) {
            DynamicObject bomEntry = (DynamicObject)bomEntryColl.get(i);
            DynamicObject bomReplacePlan = bomEntry.getDynamicObject("entryreplaceplan");
            String replaceGroup = bomEntry.getString("entryreplacegroup");
            boolean isReplace = bomEntry.getBoolean("entryisreplace");
            if (bomReplacePlan == null || !bomReplacePlan.getPkValue().equals(replacePlan.getPkValue()) || !StringUtils.isEmpty((String)replaceGroup) && !replaceGroup.equals(replaceGroupNo)) continue;
            if (!isReplace) {
                bomEntry.set("entryisreplace", (Object)Boolean.FALSE);
                bomEntry.set("entryreplaceplan", null);
                bomEntry.set("entryreplacegroup", (Object)"");
                bomEntry.set("entryisreplaceplanmm", (Object)Boolean.FALSE);
                continue;
            }
            replaceList.add(bomEntry);
        }
        if (!replaceList.isEmpty()) {
            for (DynamicObject bomEntry : replaceList) {
                Long bomEntryId = bomEntry.getLong("id");
                String materialKeys = this.genKeysByBomEntry(bomEntry, bomRepConfig);
                oldMap.put(materialKeys, bomEntryId);
                bomEntryColl.remove((Object)bomEntry);
            }
        }
        return oldMap;
    }

    private void resetBomEntryId(DynamicObject bom, String replaceGroupNo, DynamicObject replacePlan, DynamicObject bomRepConfig, Map<String, Long> entryIdOldMap) {
        if (entryIdOldMap == null || entryIdOldMap.isEmpty()) {
            return;
        }
        DynamicObjectCollection bomEntryColl = bom.getDynamicObjectCollection("entry");
        HashSet<Long> execIdSet = new HashSet<Long>(16);
        for (int i = 0; i < bomEntryColl.size(); ++i) {
            String materialKeys;
            Long oldBomEntryId;
            DynamicObject bomEntry = (DynamicObject)bomEntryColl.get(i);
            DynamicObject bomReplacePlan = bomEntry.getDynamicObject("entryreplaceplan");
            String replaceGroup = bomEntry.getString("entryreplacegroup");
            boolean isReplace = bomEntry.getBoolean("entryisreplace");
            if (bomReplacePlan == null || !bomReplacePlan.getPkValue().equals(replacePlan.getPkValue()) || !StringUtils.isEmpty((String)replaceGroup) && !replaceGroup.equals(replaceGroupNo) || !isReplace || (oldBomEntryId = entryIdOldMap.get(materialKeys = this.genKeysByBomEntry(bomEntry, bomRepConfig))) == null || oldBomEntryId.equals(0L) || !execIdSet.add(oldBomEntryId)) continue;
            bomEntry.set("id", (Object)oldBomEntryId);
        }
    }

    private boolean isEntryOpt(DynamicObject bom) {
        String configProp;
        DynamicObject bomType = bom.getDynamicObject("type");
        String optionCtl = bom.get("optioncontrol") == null ? "" : bom.getString("optioncontrol");
        DynamicObject matObj = bom.getDynamicObject("materialid");
        String configType = bomType.getString("configtype");
        return "A".equals(configType) && matObj != null && "3".equals(configProp = matObj.getString("configproperties")) && "A".equals(optionCtl);
    }

    private String saveBom(DynamicObject bom) {
        DynamicObjectCollection entrys = bom.getDynamicObjectCollection("entry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            entry.set("seq", (Object)(i + 1));
        }
        String status = bom.getString("status");
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(16);
        saveList.add(bom);
        log.info("mmc_pdm_ReplacePlanUpdateBomBusiness_saveBom:status=" + status);
        if ("A".equals(status)) {
            String errorString;
            OperateOption option = this.getOperateOption();
            option.setVariableValue("ignoreValidation", "true");
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"pdm_mftbom", (DynamicObject[])saveList.toArray(new DynamicObject[saveList.size()]), (OperateOption)option);
            if (saveResult.getAllErrorOrValidateInfo() != null && !StringUtils.isEmpty((String)(errorString = this.getErrorMsg(saveResult)))) {
                return String.format(ResManager.loadKDString((String)"BOM\u4fdd\u5b58\u9519\u8bef\uff1a%1$s\u3002", (String)"ReplacePlanUpdateBomBusiness_12", (String)"mmc-pdm-business", (Object[])new Object[0]), errorString);
            }
        } else {
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[saveList.size()]));
            Long orgId = (Long)bom.getDynamicObject("org").getPkValue();
            EcoUtils.refreshBaseDataCache("pdm_mftbom", orgId);
            if ("C".equals(status)) {
                BomSyncCostUtils.syncCost((Long)orgId, (Long)((Long)bom.getPkValue()), (String)"");
            }
        }
        return "";
    }

    private void addBomEntry(DynamicObject bom, DynamicObject bomEnrtyMainObj, DynamicObject repObj, BigDecimal mole, BigDecimal done, int addIndex, boolean isCalculate, ORM orm, boolean isOpt, Object extPluginObject, DynamicObject bomEntryReplacePlanMMRow, PluginProxy<IReplacePlanUpdateBomExt> newExtPlugin) {
        if (!isCalculate) {
            mole = this.getReplaceMaterialEntryMole(repObj);
            done = this.getReplaceMaterialEntryDeno(repObj);
        }
        DynamicObjectCollection bomColl = bom.getDynamicObjectCollection("entry");
        DynamicObject bomentry = orm.newDynamicObject(bomColl.getDynamicObjectType());
        bomColl.add(addIndex, bomentry);
        DynamicObject typeObj = bom.getDynamicObject("type");
        String purpose = typeObj.getString("purpose");
        bomentry.setParent((Object)bom);
        bomentry.set("entrytype", (Object)"A");
        bomentry.set("seq", (Object)addIndex);
        DynamicObject repMaterialMft = repObj.getDynamicObject("repmaterial");
        repMaterialMft = MaterialMftQueryHelper.getDataCacheByID((Object)repMaterialMft.getPkValue());
        DynamicObject repMaterial = MaterialQueryHelper.getDataCacheByID((Object)repMaterialMft.getDynamicObject("masterid").getPkValue());
        bomentry.set("entrymaterialid", (Object)repMaterial);
        bomentry.set("entryunit", repMaterial.get("baseunit"));
        bomentry.set("entrymaterial", (Object)repMaterialMft);
        bomentry.set("entryunit", repMaterialMft.get("mftunit"));
        Date entryValidDate = bomEntryReplacePlanMMRow != null ? bomEntryReplacePlanMMRow.getDate("entryvaliddate") : repObj.getDate("repeffectdate");
        Date entryInvalidDate = bomEntryReplacePlanMMRow != null ? bomEntryReplacePlanMMRow.getDate("entryinvaliddate") : repObj.getDate("repinvaliddate");
        bomentry.set("entryqtytype", repObj.get("repqtytype"));
        bomentry.set("entryisreplace", (Object)true);
        bomentry.set("entryqtynumerator", (Object)mole);
        bomentry.set("entryqtydenominator", (Object)done);
        bomentry.set("entryqty", (Object)MMCUtils.divide((BigDecimal)mole, (BigDecimal)done));
        bomentry.set("entryfixscrap", repObj.get("repfixscrap"));
        bomentry.set("entryscraprate", repObj.get("repscraprate"));
        bomentry.set("entryversion", repObj.get("repbomversion"));
        bomentry.set("entryreplaceplan", bomEnrtyMainObj.get("entryreplaceplan"));
        bomentry.set("entryreplacegroup", bomEnrtyMainObj.get("entryreplacegroup"));
        bomentry.set("entryisreplaceplanmm", (Object)repObj.getString("isrep"));
        bomentry.set("entryauxproperty", repObj.get("repauxpty"));
        bomentry.set("reppriority", repObj.get("reppriority"));
        bomentry.set("entrymaterialattr", (Object)repMaterialMft.getString("materialattr"));
        bomentry.set("entryisjumplevel", (Object)("10020".equals(repMaterialMft.getString("materialattr")) ? Boolean.TRUE : Boolean.FALSE));
        bomentry.set("entryprocessseq", bomEnrtyMainObj.get("entryprocessseq"));
        bomentry.set("entryoperationnumber", bomEnrtyMainObj.get("entryoperationnumber"));
        bomentry.set("entryecn", bomEnrtyMainObj.get("entryecn"));
        bomentry.set("entryvaliddate", (Object)entryValidDate);
        bomentry.set("entryinvaliddate", (Object)entryInvalidDate);
        bomentry.set("entryownertype", (Object)"bos_org");
        bomentry.set("entryissuemode", repMaterialMft.get("issuemode"));
        bomentry.set("entryiskey", repMaterialMft.get("iskeypart"));
        bomentry.set("entryisstockalloc", repMaterialMft.get("isstockallot"));
        bomentry.set("entryoutorg", repMaterialMft.get("outstorageunit"));
        bomentry.set("entryoutwarehouse", repMaterialMft.get("outwarehouse"));
        bomentry.set("entryoutlocation", repMaterialMft.get("outwarelocation"));
        bomentry.set("entryisbulkmaterial", repMaterialMft.get("isbulkmaterial"));
        bomentry.set("entryisbackflush", repMaterialMft.get("isbackflush"));
        bomentry.set("entryleadtime", (Object)0);
        bomentry.set("entrytimeunit", (Object)"D");
        bomentry.set("entrysupplytype", bomEnrtyMainObj.get("entrysupplytype"));
        bomentry.set("entrysupplyorg", repMaterialMft.get("supplyorgunitid"));
        bomentry.set("entrysupplymode", bomEnrtyMainObj.get("entrysupplymode"));
        bomentry.set("entrywarehouse", repMaterialMft.get("warehouse"));
        bomentry.set("entrylocation", repMaterialMft.get("location"));
        bomentry.set("entrynumber", repMaterial.get("number"));
        bomentry.set("configproperties", repMaterial.get("configproperties"));
        if ("3".equals(repMaterial.getString("configproperties"))) {
            bomentry.set("opt", (Object)Boolean.FALSE);
            bomentry.set("preferopt", (Object)Boolean.FALSE);
        }
        if (isOpt) {
            bomentry.set("opt", (Object)Boolean.TRUE);
        }
        this.addQtyEntry(repObj, bomentry);
        this.afterAddBomEntry(extPluginObject, bom, bomentry, bomEnrtyMainObj, repObj, newExtPlugin);
    }

    private void afterAddBomEntry(Object extPlugin, DynamicObject bom, DynamicObject bomentry, DynamicObject bomEnrtyMainObj, DynamicObject repObj, PluginProxy<IReplacePlanUpdateBomExt> pluginProxy) {
        if (extPlugin != null) {
            ((AbstractReplacePlanUpdateBomExtPlugin)extPlugin).afterUpdateBom(bom, bomentry, bomEnrtyMainObj, repObj);
        } else if (pluginProxy != null) {
            pluginProxy.callReplace(p -> {
                p.afterUpdateBom(bom, bomentry, bomEnrtyMainObj, repObj);
                return null;
            });
        }
    }

    private PluginProxy<IReplacePlanUpdateBomExt> genExtPluginxy() {
        ReplacePlanUpdateBomExtPlugin extPluginClass = new ReplacePlanUpdateBomExtPlugin();
        return PluginProxy.create((Object)extPluginClass, IReplacePlanUpdateBomExt.class, (String)EXT_PLGUIN_NUMBER, null);
    }

    private void addQtyEntry(DynamicObject repObj, DynamicObject bomentry) {
        DynamicObjectCollection qtyEntryColl = repObj.getDynamicObjectCollection("qtyentry");
        DynamicObjectCollection bomQtyEntryColl = bomentry.getDynamicObjectCollection("qtyentry");
        if (!qtyEntryColl.isEmpty()) {
            int qtyEntrySize = qtyEntryColl.size();
            for (int i = 0; i < qtyEntrySize; ++i) {
                DynamicObject qtyEntry = (DynamicObject)qtyEntryColl.get(i);
                DynamicObject addQtyEntry = bomQtyEntryColl.addNew();
                for (String fields : BomReplaceConsts.QTYENTRYBOMFIELDS) {
                    if (!qtyEntry.containsProperty(fields) || !addQtyEntry.containsProperty(fields)) continue;
                    addQtyEntry.set(fields, qtyEntry.get(fields));
                }
            }
        }
    }

    private DynamicObject getReplacePlan(Long replacePlanId) {
        QFilter qfilter = new QFilter("id", "=", (Object)replacePlanId);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_replaceplan", (QFilter[])new QFilter[]{qfilter});
    }

    private DynamicObject getBomRepConfig() {
        String selectProperties = "createorg,entrymaterial,entryver,auxproperties,numrate,isreduction,iscalculate";
        QFilter qfilter = new QFilter("id", "=", (Object)BomReplaceConsts.BOMREPCONFIGID);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_bomrepconfig", (String)selectProperties, (QFilter[])new QFilter[]{qfilter});
    }

    private JSONObject buildResultData(String msg, boolean isSuccessful, String msg_tag) {
        JSONObject resultJson = new JSONObject(16);
        resultJson.put("msg", (Object)msg);
        resultJson.put("result", (Object)isSuccessful);
        resultJson.put("msg_tag", (Object)msg_tag);
        return resultJson;
    }

    private DynamicObjectCollection getReplacePlanMMEntry(DynamicObject replacePlan) {
        return replacePlan.getDynamicObjectCollection("mainmaterentry");
    }

    private DynamicObjectCollection getReplacePlanRMEntry(DynamicObject replacePlan) {
        return replacePlan.getDynamicObjectCollection("repmaterentry");
    }

    private DynamicObject getReplacePlanMMEntry(DynamicObject bomEntry, Map<String, DynamicObject> replacePlanMMEntryMap, DynamicObject bomRepConfig) {
        String bomMaterialKeys = this.genKeysByBomEntry(bomEntry, bomRepConfig);
        return replacePlanMMEntryMap.get(bomMaterialKeys);
    }

    private String genKeysByBomEntry(DynamicObject bomEntry, DynamicObject bomRepConfig) {
        Long materialId = (Long)bomEntry.getDynamicObject("entrymaterialid").getPkValue();
        Long bomVersionId = 0L;
        if (bomEntry.getDynamicObject("entryversion") != null) {
            bomVersionId = (Long)bomEntry.getDynamicObject("entryversion").getPkValue();
        }
        Long bomAuxId = 0L;
        if (bomEntry.getDynamicObject("entryauxproperty") != null) {
            bomAuxId = (Long)bomEntry.getDynamicObject("entryauxproperty").getPkValue();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(materialId);
        sb.append("_");
        if (bomRepConfig.getBoolean("entryver")) {
            sb.append(bomVersionId == null ? "0" : bomVersionId);
        } else {
            sb.append("0");
        }
        sb.append("_");
        if (bomRepConfig.getBoolean("auxproperties")) {
            sb.append(bomAuxId == null ? "0" : bomAuxId);
        } else {
            sb.append("0");
        }
        return sb.toString();
    }

    private Map<String, DynamicObject> getReplacePlanMainMaterialKeys(DynamicObjectCollection coll, DynamicObject bomRepConfig) {
        HashMap<String, DynamicObject> mmKeyMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject entry : coll) {
            DynamicObject materialMft = entry.getDynamicObject("material");
            if (materialMft == null || materialMft.getDynamicObject("masterid") == null) continue;
            mmKeyMap.put(this.genReplacePlanKeys(entry, bomRepConfig), entry);
        }
        return mmKeyMap;
    }

    private String genReplacePlanKeys(DynamicObject entry, DynamicObject bomRepConfig) {
        StringBuilder sb = new StringBuilder();
        DynamicObject materialMft = entry.getDynamicObject("material");
        sb.append(materialMft.getDynamicObject("masterid").getPkValue());
        sb.append("_");
        if (bomRepConfig.getBoolean("entryver")) {
            DynamicObject bomVersion = entry.getDynamicObject("bomversion");
            sb.append(bomVersion == null ? "0" : bomVersion.getPkValue());
        } else {
            sb.append("0");
        }
        sb.append("_");
        if (bomRepConfig.getBoolean("auxproperties")) {
            DynamicObject auxpty = entry.getDynamicObject("auxpty");
            sb.append(auxpty == null ? "0" : auxpty.getPkValue());
        } else {
            sb.append("0");
        }
        return sb.toString();
    }

    private Map<Integer, DynamicObject> getRepEntrtPriorityMap(DynamicObjectCollection repEntryCol) {
        LinkedHashMap<Integer, DynamicObject> repMainObjMap = new LinkedHashMap<Integer, DynamicObject>(16);
        for (int i = 0; i < repEntryCol.size(); ++i) {
            DynamicObject repObj = (DynamicObject)repEntryCol.get(i);
            if (!repObj.getBoolean("isrep")) continue;
            int reppriority = repObj.getInt("reppriority");
            repMainObjMap.put(reppriority, repObj);
        }
        return repMainObjMap;
    }

    private BigDecimal getMultiplyNumber(BigDecimal mole, BigDecimal done, DynamicObject bomRepConfig) {
        int doneIndex;
        if (!bomRepConfig.getBoolean("isreduction")) {
            return BigDecimal.ONE;
        }
        int moleIndex = this.getNumberOfPoint(mole);
        int tmpIndex = doneIndex = this.getNumberOfPoint(done);
        if (moleIndex > doneIndex) {
            tmpIndex = moleIndex;
        }
        StringBuilder pointNumStr = new StringBuilder("1");
        for (int num = 0; num < tmpIndex; ++num) {
            pointNumStr = pointNumStr.append("0");
        }
        return new BigDecimal(pointNumStr.toString());
    }

    public BigDecimal getCommomDivisor(BigDecimal num1, BigDecimal num2, DynamicObject bomRepConfig) {
        if (!bomRepConfig.getBoolean("isreduction")) {
            return BigDecimal.ONE;
        }
        while (num2.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal temp = num2;
            num2 = num1.remainder(num2);
            num1 = temp;
        }
        return num1;
    }

    private int getNumberOfPoint(BigDecimal dec) {
        String str = dec.stripTrailingZeros().toPlainString();
        int index = str.indexOf(46);
        if (index <= 0) {
            return 0;
        }
        return str.length() - index - 1;
    }

    private OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("ignorewarn", "true");
        option.setVariableValue("ignoreinteraction", "true");
        option.setVariableValue("batchop_batchsize", "50");
        option.setVariableValue("needlog", String.valueOf(true));
        return option;
    }

    private String getErrorMsg(OperationResult operationResult) {
        StringBuilder errMsg = new StringBuilder();
        List validateErrors = operationResult.getValidateResult().getValidateErrors();
        for (ValidateResult validateResult : validateErrors) {
            List allErrorInfo = validateResult.getAllErrorInfo();
            String validatorKey = validateResult.getValidatorKey();
            allErrorInfo.forEach(operateErrorInfo -> {
                String message = operateErrorInfo.getMessage();
                errMsg.append(validatorKey).append(message);
            });
        }
        if (errMsg.length() < 1 && !operationResult.getAllErrorInfo().isEmpty()) {
            errMsg.append(operationResult.getAllErrorInfo());
        }
        if (errMsg.length() < 1 && !operationResult.isSuccess() && operationResult.getMessage() != null) {
            errMsg.append(operationResult.getMessage());
        }
        if (errMsg.length() < 1 && operationResult.getInteractionContext() != null && operationResult.getInteractionContext().getSimpleMessage() != null) {
            errMsg.append(operationResult.getInteractionContext().getSimpleMessage());
        }
        if (errMsg.length() < 1 && !operationResult.isSuccess()) {
            errMsg.append(operationResult.toString());
        }
        return errMsg.toString();
    }

    private boolean isError(JSONObject resultData) {
        return resultData.getBoolean("result") == false;
    }

    private boolean checkIsFullMatch(Set<Long> bomEntryIdSet, DynamicObject replacePlan) {
        ReplacePlanBusiness impl = new ReplacePlanBusiness();
        return impl.checkBomEntryIdMatch(Long.valueOf(replacePlan.getLong("id")), bomEntryIdSet);
    }

    private BigDecimal getReplaceMaterialEntryMole(DynamicObject replaceMaterialEntry) {
        return replaceMaterialEntry.getBigDecimal("repmole");
    }

    private BigDecimal getReplaceMaterialEntryDeno(DynamicObject replaceMaterialEntry) {
        return replaceMaterialEntry.getBigDecimal("repdeno");
    }

    private String checkMaterialValidData(DynamicObject replacePlan, DynamicObject bom) {
        DynamicObject materialMft;
        DynamicObjectCollection mmEntryColl = this.getReplacePlanMMEntry(replacePlan);
        DynamicObjectCollection repEntryColl = this.getReplacePlanRMEntry(replacePlan);
        Long orgId = bom.getDynamicObject("createorg").getLong("id");
        HashMap<Long, DynamicObject> materialMap = new HashMap<Long, DynamicObject>(16);
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        for (DynamicObject mmEntry : mmEntryColl) {
            materialMft = mmEntry.getDynamicObject("material");
            if (materialMft == null) continue;
            materialIdSet.add(materialMft.getDynamicObject("masterid").getLong("id"));
            materialMap.put(materialMft.getDynamicObject("masterid").getLong("id"), materialMft.getDynamicObject("masterid"));
        }
        for (DynamicObject repEntry : repEntryColl) {
            materialMft = repEntry.getDynamicObject("repmaterial");
            if (materialMft == null) continue;
            materialIdSet.add(materialMft.getDynamicObject("masterid").getLong("id"));
            materialMap.put(materialMft.getDynamicObject("masterid").getLong("id"), materialMft.getDynamicObject("masterid"));
        }
        StringBuilder sb = new StringBuilder();
        Map mftMap = MaterialMftQueryHelper.getDataCacheByMaterialSet(materialIdSet, (Long)orgId);
        for (Long materialId : materialIdSet) {
            DynamicObject mft = (DynamicObject)mftMap.get(materialId);
            if (mft == null) {
                DynamicObject org = OrgQueryHelper.getDataCacheByID((Object)orgId);
                DynamicObject material = (DynamicObject)materialMap.get(materialId);
                sb.append(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%2$s\u201d\u7684\u7269\u6599\u201c%3$s\u201d\u5728\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u4e0d\u5b58\u5728\u53ef\u7528\u4e14\u5df2\u5ba1\u6838\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"ReplacePlanUpdateBomBusiness_04", (String)"mmc-pdm-business", (Object[])new Object[0]), org.getString("name"), replacePlan.getString("number"), material.get("number")));
                sb.append("\r\n");
                continue;
            }
            DynamicObject material = mft.getDynamicObject("masterid");
            if (!"C".equals(mft.getString("status")) || !"1".equals(mft.getString("enable"))) {
                DynamicObject org = OrgQueryHelper.getDataCacheByID((Object)orgId);
                sb.append(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%2$s\u201d\u7684\u7269\u6599\u201c%3$s\u201d\u5728\u7ec4\u7ec7\u201c%1$s\u201d\u4e0b\u4e0d\u5b58\u5728\u53ef\u7528\u4e14\u5df2\u5ba1\u6838\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"ReplacePlanUpdateBomBusiness_04", (String)"mmc-pdm-business", (Object[])new Object[0]), org.getString("name"), replacePlan.getString("number"), material.get("number")));
                sb.append("\r\n");
            }
            if ("C".equals(material.getString("status")) && "1".equals(material.getString("enable"))) continue;
            sb.append(String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%1$s\u201d\u7684\u7269\u6599\u201c%2$s\u201d\u4e0d\u5904\u4e8e\u53ef\u7528\u6216\u5ba1\u6838\u72b6\u6001\u3002", (String)"ReplacePlanUpdateBomBusiness_05", (String)"mmc-pdm-business", (Object[])new Object[0]), replacePlan.getString("number"), material.get("number")));
            sb.append("\r\n");
        }
        return sb.toString();
    }

    private String checkBomAndReplacePlan(DynamicObject replacePlan, DynamicObject bom) {
        if (!"1".equals(replacePlan.getString("enable"))) {
            return String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%1$s\u201d\u4e0d\u662f\u53ef\u7528\u72b6\u6001\u3002", (String)"ReplacePlanUpdateBomBusiness_07", (String)"mmc-pdm-business", (Object[])new Object[0]), replacePlan.getString("number"));
        }
        if (!"C".equals(replacePlan.getString("status"))) {
            return String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848\u201c%1$s\u201d\u4e0d\u662f\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"ReplacePlanUpdateBomBusiness_08", (String)"mmc-pdm-business", (Object[])new Object[0]), replacePlan.getString("number"));
        }
        if (!"1".equals(bom.getString("enable"))) {
            return String.format(ResManager.loadKDString((String)"BOM\u201c%1$s\u201d\u4e0d\u53ef\u7528\u3002", (String)"ReplacePlanUpdateBomBusiness_09", (String)"mmc-pdm-business", (Object[])new Object[0]), bom.getString("number"));
        }
        if ("A".equals(bom.getDynamicObject("type").getString("purpose"))) {
            DynamicObjectCollection repColl = replacePlan.getDynamicObjectCollection("repmaterentry");
            for (Object rep : repColl) {
                DynamicObject materialMft = rep.getDynamicObject("repmaterial");
                if (!"2".equals(materialMft.getDynamicObject("masterid").getString("configproperties"))) continue;
                return String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848[%1$s]\u4e0b\u7684\u66ff\u4ee3\u7269\u6599[%2$s]\u662f\u914d\u7f6e\u4ef6\uff0c\u4e14BOM[%1$s]\u7684\u7528\u9014\u4e3a\u5236\u9020\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u66ff\u4ee3\u64cd\u4f5c\u3002", (String)"ReplacePlanUpdateBomBusiness_13", (String)"mmc-pdm-business", (Object[])new Object[0]), replacePlan.getString("number"), materialMft.getDynamicObject("masterid").getString("number"), bom.getString("number"));
            }
        }
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        materialIdSet.add(bom.getDynamicObject("materialid").getLong("id"));
        DynamicObjectCollection bomCopEntry = bom.getDynamicObjectCollection("copentry");
        if (!PlatformUtils.isNullCollection((DynamicObjectCollection)bomCopEntry)) {
            for (DynamicObject entry : bomCopEntry) {
                if (entry.getDynamicObject("copentrymaterialid") == null) continue;
                materialIdSet.add(entry.getDynamicObject("copentrymaterialid").getLong("id"));
            }
        }
        DynamicObjectCollection repColl = replacePlan.getDynamicObjectCollection("repmaterentry");
        for (DynamicObject rep : repColl) {
            DynamicObject materialMft = rep.getDynamicObject("repmaterial");
            if (!materialIdSet.contains(materialMft.getDynamicObject("masterid").getLong("id"))) continue;
            return String.format(ResManager.loadKDString((String)"\u66ff\u4ee3\u65b9\u6848[%1$s]\u4e0b\u7684\u66ff\u4ee3\u7269\u6599[%2$s]\u5b58\u5728\u4e8eBOM[%1$s]\u7684\u8868\u5934\u4ea7\u54c1\u6216\u8054\u526f\u4ea7\u54c1\u4e2d\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u66ff\u4ee3\u64cd\u4f5c\u3002", (String)"ReplacePlanUpdateBomBusiness_14", (String)"mmc-pdm-business", (Object[])new Object[0]), replacePlan.getString("number"), materialMft.getDynamicObject("masterid").getString("number"), bom.getString("number"));
        }
        return "";
    }

    private Object getExtPlugin() {
        String extClassPlugin = PdmParamSetHelper.getStringParamValue((String)"ReplacePlanUpdateBomExtPlugin");
        if (!StringUtils.isEmpty((String)extClassPlugin)) {
            try {
                Object object = Class.forName(extClassPlugin).newInstance();
                if (AbstractReplacePlanUpdateBomExtPlugin.class.isInstance(object)) {
                    return object;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.error((Throwable)e);
            }
        }
        return null;
    }
}

