/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.proconfig.proconfigEdit;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class ConfigRuleTransBusiness {
    private static ConfigRuleTransBusiness configRuleTransBusiness;
    private Map<String, String> valueMap = new HashMap<String, String>(100);

    private ConfigRuleTransBusiness() {
    }

    public static ConfigRuleTransBusiness getInstance() {
        if (configRuleTransBusiness == null) {
            configRuleTransBusiness = new ConfigRuleTransBusiness();
        }
        return configRuleTransBusiness;
    }

    public String parseRule(String formulatype, String formulaSrc) {
        this.valueMap.clear();
        String retStr = "";
        if (formulatype == null || formulaSrc == null) {
            return null;
        }
        switch (formulatype) {
            case "A": {
                retStr = this.getQuestionRule(formulaSrc);
                break;
            }
            case "B": {
                retStr = this.getProcessRule(formulaSrc);
                break;
            }
            case "C": {
                break;
            }
        }
        return retStr;
    }

    private String getQuestionRule(String formulaSrc) {
        String noValueStr = this.dealValue(formulaSrc);
        String noKeyworkStr = this.dealKeyWord(noValueStr == null ? "" : noValueStr);
        String newLogicStr = this.getNewLogic(noKeyworkStr == null ? "" : noKeyworkStr);
        String retStr = this.retSetValue(newLogicStr);
        StringBuilder sb = new StringBuilder("if(");
        sb.append(retStr);
        sb.append("){ \n");
        sb.append("     formula_result = true;\n");
        sb.append(" }else{ \n");
        sb.append("     formula_result = false; \n");
        sb.append("} \n");
        return sb.toString();
    }

    private String getProcessRule(String formulaSrc) {
        String retStr;
        String questoin;
        String value;
        String lowerStr = formulaSrc.toLowerCase();
        int index = lowerStr.indexOf("if");
        if (index < 0) {
            value = formulaSrc;
            questoin = null;
        } else {
            value = formulaSrc.substring(0, index - 1);
            questoin = formulaSrc.substring(index + 2);
        }
        int indexFlag = value.indexOf("$SET_DEFAULT");
        if (value.startsWith("$SET_DEFAULT")) {
            value = value.substring(indexFlag + 12);
            value = this.dealDefaultValue(value);
        } else if (value.startsWith("$SELF")) {
            value = this.dealKeyWord(value);
            JSONObject obj = new JSONObject();
            String[] fieldVal = value.split("=");
            if (fieldVal.length >= 2) {
                obj.put("field", (Object)fieldVal[0]);
                obj.put("QCP", (Object)"=");
                String tmpVal = fieldVal[1];
                if (tmpVal != null) {
                    tmpVal = tmpVal.trim().replace("'", "");
                }
                obj.put("value", (Object)tmpVal);
                obj.put("type", (Object)"set_value");
            }
            value = obj.toString();
        } else {
            value = "\"\"";
        }
        if (questoin == null) {
            retStr = value = "formula_result = " + value;
        } else {
            String preCondition = this.getQuestionRule(questoin);
            if (preCondition == null) {
                String retStr2 = value;
                return retStr2;
            }
            value = "formula_result = " + value;
            retStr = preCondition.replace("formula_result = true", value).replace("formula_result = false", "formula_result = \"\"");
        }
        return retStr;
    }

    private String dealDefaultValue(String defualtStr) {
        int index;
        if (defualtStr == null) {
            return "";
        }
        if ((defualtStr = defualtStr.trim()).startsWith("(") && defualtStr.endsWith(")") && defualtStr.length() >= 3) {
            defualtStr = defualtStr.substring(1, defualtStr.length() - 2);
        }
        if ((index = defualtStr.indexOf(44)) < 0) {
            return defualtStr;
        }
        String[] fieldVal = defualtStr.split(",");
        JSONObject obj = new JSONObject();
        if (fieldVal.length >= 3) {
            obj.put("field", (Object)fieldVal[1]);
            obj.put("QCP", (Object)"=");
            String value = fieldVal[2];
            if (value != null) {
                value = value.trim().replace("'", "");
            }
            obj.put("value", (Object)value);
            obj.put("type", (Object)"set_default");
        }
        return obj.toString();
    }

    private String dealKeyWord(String formulaSrc) {
        if (formulaSrc == null) {
            return "";
        }
        String retStr = formulaSrc;
        int index1 = formulaSrc.indexOf(36);
        int index2 = formulaSrc.indexOf(46);
        if (index1 >= 0 && index1 < index2) {
            String keyword = formulaSrc.substring(index1, index2 + 1);
            retStr = formulaSrc.replace(keyword, "");
            this.dealKeyWord(retStr);
        }
        return retStr;
    }

    private String getNewLogic(String str) {
        if (str == null) {
            return "";
        }
        String noAndStr = str.replace(" and ", " && ").replace(" AND ", " && ").replace(")AND ", ") && ").replace(")and ", ") && ").replace(" AND(", " && (").replace(" and(", " && (");
        String noOrStr = noAndStr.replace(" or ", " || ").replace(" OR ", " || ").replace(")OR ", ") || ").replace(")or ", ") || ").replace(" OR(", " || (").replace(" or(", " || (");
        noOrStr = noOrStr.replace(" not ", " !").replace("not ", " !").replace(" NOT ", " !").replace("NOT ", " !").replace("NOT(", " !(").replace("not(", " !(");
        noOrStr = noOrStr.replace("=", "==");
        noOrStr = noOrStr.replace("!=", "!");
        return noOrStr;
    }

    private String dealValue(String str) {
        String retStr = str;
        if (str == null) {
            return retStr;
        }
        UUID uuid = UUID.randomUUID();
        int index1 = str.indexOf("'");
        if (index1 < 0) {
            return retStr;
        }
        String newStr = str.substring(index1 + 1);
        int index2 = newStr.indexOf("'");
        if (index2 < 0) {
            return retStr;
        }
        String value = str.substring(index1, index1 + index2 + 2);
        this.valueMap.put(uuid.toString(), value);
        retStr = str.replace(value, uuid.toString());
        if (!retStr.equals(str)) {
            retStr = this.dealValue(retStr);
        }
        return retStr;
    }

    private String retSetValue(String str) {
        String retStr = str;
        if (str == null) {
            return str;
        }
        Set<Map.Entry<String, String>> set = this.valueMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String keyStr = entry.getKey();
            String valStr = entry.getValue();
            if ("".equals(retStr)) {
                retStr = str.replace(keyStr, valStr);
                continue;
            }
            retStr = retStr.replace(keyStr, valStr);
        }
        return retStr;
    }
}

