/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.proconfig.proconfigEdit;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.pdm.business.proconfig.proconfiglist.PDMFormulaRunBusiness;

public class ProdConfigFeatureSearchBusiness {
    public JSONArray batchGetRelationFeature(String reqParams) {
        JSONArray array = new JSONArray();
        if (reqParams == null) {
            return array;
        }
        JSONArray reqArray = JSONObject.parseArray((String)reqParams);
        for (int i = 0; i < reqArray.size(); ++i) {
            JSONObject reqJson = reqArray.getJSONObject(i);
            JSONArray retArray = this.getRelationFeature(reqJson.toJSONString());
            reqJson.put("datas", (Object)retArray);
            array.add((Object)reqJson);
        }
        return array;
    }

    public JSONArray getRelationFeature(String reqParams) {
        String featureVal;
        if (reqParams == null) {
            return new JSONArray();
        }
        JSONObject reqJson = JSONObject.parseObject((String)reqParams);
        String featureNum = reqJson.getString("featureNum");
        DynamicObject featureDef = this.getFeatureFormula(featureNum, featureVal = reqJson.getString("featureVal"));
        if (featureDef == null) {
            return new JSONArray();
        }
        HashMap<String, List<Object>> paramsMap = new HashMap<String, List<Object>>(16);
        ArrayList<String> paramsList = new ArrayList<String>(16);
        paramsList.add(featureVal);
        paramsMap.put(featureNum, paramsList);
        String formula = featureDef.getString("formula");
        if (formula == null || "".equals(formula)) {
            return new JSONArray();
        }
        HashSet<String> formulaSet = new HashSet<String>(24);
        formulaSet.add(formula);
        JSONObject retObj = (JSONObject)PDMFormulaRunBusiness.getInstance().runFormula("3", formulaSet, paramsMap);
        JSONArray retArray = this.getFeatureInfo(retObj);
        return retArray;
    }

    private DynamicObject getFeatureFormula(String featureNum, String featureVal) {
        String fields = "treeentryentity.entryconfigrule.formula formula";
        QFilter featureNumfilter = new QFilter("number", "=", (Object)featureNum);
        QFilter featureValfilter = new QFilter("treeentryentity.entryvalue", "=", (Object)featureVal);
        QFilter type = new QFilter("treeentryentity.entryconfigrule.type", "=", (Object)"3");
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        return QueryServiceHelper.queryOne((String)"pdm_featuredefinition", (String)fields, (QFilter[])new QFilter[]{featureNumfilter, featureValfilter, type, status, enable});
    }

    public Map<Long, Set<String>> getFeatureFormula(Set<Long> featureIdSet) {
        String fields = "id,configentity.featurerule.formula formula";
        QFilter featureNumfilter = new QFilter("id", "in", featureIdSet);
        QFilter type = new QFilter("configentity.featurerule.type", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection featureCol = QueryServiceHelper.query((String)"pdm_featuredefinition", (String)fields, (QFilter[])new QFilter[]{featureNumfilter, type, status, enable});
        HashMap<Long, Set<String>> retMap = new HashMap<Long, Set<String>>(featureCol.size());
        for (int i = 0; i < featureCol.size(); ++i) {
            DynamicObject featureObj = (DynamicObject)featureCol.get(i);
            long featureId = featureObj.getLong("id");
            String formula = featureObj.getString("formula");
            HashSet<String> formulaSet = (HashSet<String>)retMap.get(featureId);
            if (formulaSet == null) {
                formulaSet = new HashSet<String>();
            }
            formulaSet.add(formula);
            retMap.put(featureId, formulaSet);
        }
        return retMap;
    }

    public Map<Object, DynamicObject> getProConfigRule(Set<Long> ruleIdSet) {
        String fields = "id,formula";
        QFilter filter1 = new QFilter("id", "in", ruleIdSet);
        QFilter filter2 = new QFilter("type", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.loadFromCache((String)"pdm_chararule", (String)fields, (QFilter[])new QFilter[]{filter1, filter2, status, enable});
    }

    private JSONArray getFeatureInfo(JSONObject retObj) {
        JSONArray retArray = new JSONArray();
        if (retObj == null || retObj.isEmpty()) {
            return retArray;
        }
        Set keySet = retObj.keySet();
        String fields = "id,number,treeentryentity.id entryid,treeentryentity.entryvalue entryvalue,treeentryentity.entryvaluename entryname";
        QFilter featureNumfilter = new QFilter("number", "in", (Object)keySet);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        DataSet data = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pdm_featuredefinition", (String)fields, (QFilter[])new QFilter[]{featureNumfilter, status, enable}, null);
        while (data.hasNext()) {
            Row row = data.next();
            long id = row.getLong("id");
            String number = row.getString("number");
            long entryId = row.getLong("entryid");
            String entryvalue = row.getString("entryvalue");
            String entryname = row.getString("entryname");
            JSONArray featureValArray = retObj.getJSONArray(number);
            if (featureValArray == null || !featureValArray.contains((Object)entryvalue)) continue;
            JSONObject obj = new JSONObject();
            obj.put("featurenumberid", (Object)String.valueOf(id));
            obj.put("featureid", (Object)id);
            obj.put("number", (Object)number);
            obj.put("featurevalue", (Object)entryvalue);
            obj.put("featurevaluename", (Object)entryname);
            obj.put("featurevalueid", (Object)entryId);
            retArray.add((Object)obj);
        }
        return retArray;
    }
}

