/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.proconfig.proconfiglist;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.mmc.pdm.business.proconfig.proconfiglist.ProductConfigCommonBusiness;
import kd.mmc.pdm.business.proconfig.proconfiglist.ProductConifgListBusiness;
import kd.mmc.pdm.business.proconfig.proconfiglist.batchtask.ConfigBomExpandBatchTaskEvent;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTask;
import org.apache.log4j.Logger;

public class BatchProConfigFeatureListBusiness
extends ProductConfigCommonBusiness {
    private static Logger logger = Logger.getLogger(BatchProConfigFeatureListBusiness.class);
    private static BatchProConfigFeatureListBusiness productConifgListBusiness;

    public static BatchProConfigFeatureListBusiness getInstance() {
        if (productConifgListBusiness == null) {
            productConifgListBusiness = new BatchProConfigFeatureListBusiness();
        }
        return productConifgListBusiness;
    }

    private String initJsonParam(String paramJsonString) {
        JSONObject paramsJson = JSONObject.parseObject((String)paramJsonString);
        paramsJson.put("cacheRedis", (Object)Boolean.TRUE);
        if (!paramsJson.containsKey((Object)"uuid")) {
            throw new KDBizException(new ErrorCode("parseException", ResManager.loadKDString((String)"\u63a5\u53e3\u6267\u884c\u9519\u8bef\uff1a\u7f3a\u5c11\u53c2\u6570uuid\u3002", (String)"BatchProConfigFeatureListBusiness_01", (String)"mmc-pdm-business", (Object[])new Object[0])), new Object[]{""});
        }
        Long uuid = paramsJson.getLong("uuid");
        if (uuid == null || uuid.equals(0L)) {
            throw new KDBizException(new ErrorCode("parseException", ResManager.loadKDString((String)"\u63a5\u53e3\u6267\u884c\u9519\u8bef\uff1a\u7f3a\u5c11\u53c2\u6570uuid\u3002", (String)"BatchProConfigFeatureListBusiness_01", (String)"mmc-pdm-business", (Object[])new Object[0])), new Object[]{""});
        }
        return paramsJson.toJSONString();
    }

    public JSONObject getBatchProdConfigListByFeature(String inparams) {
        String logMsg = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u5f00\u59cb\uff0c\u8c03\u7528\u53c2\u6570:%s\u3002", (String)"BatchProConfigFeatureListBusiness_6", (String)"mmc-pdm-business", (Object[])new Object[0]), inparams);
        logger.info((Object)logMsg);
        ProductConifgListBusiness imp = ProductConifgListBusiness.getInstance();
        JSONObject res = new JSONObject();
        try {
            String params = this.initJsonParam(inparams);
            long startTime = System.currentTimeMillis();
            boolean isBatchCompute = this.getIsBatchCompute();
            if (!isBatchCompute) {
                return imp.getProdConfigListByFeature(params);
            }
            String computeQueue = this.getExpandQueue();
            JSONObject paramsJson = JSONObject.parseObject((String)params);
            List configCodeList = JSONObject.parseArray((String)paramsJson.get((Object)"configCodeList").toString(), Long.class);
            if (configCodeList == null || configCodeList.isEmpty()) {
                return imp.getProdConfigListByFeature(params);
            }
            logger.info((Object)"by execBatchCompute");
            res = this.execBatchCompute(paramsJson, configCodeList);
            long enddate = System.currentTimeMillis() - startTime;
            logger.info((Object)("getBatchProdConfigListByFeature-end,configCodeList.size =" + configCodeList.size() + ",totalcost:" + enddate + "ms"));
        }
        catch (Exception e) {
            res.put("status", (Object)"failed");
            res.put("msg", (Object)String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u6267\u884c\u9519\u8bef\uff1a%s\u3002", (String)"BatchProConfigFeatureListBusiness_2", (String)"mmc-pdm-business", (Object[])new Object[0]), e.toString()));
            res.put("data", (Object)new JSONObject());
            throw new KDBizException((Throwable)e, new ErrorCode("parseException", ResManager.loadKDString((String)"\u63a5\u53e3\u6267\u884c\u9519\u8bef\u3002", (String)"BatchProConfigFeatureListBusiness_3", (String)"mmc-pdm-business", (Object[])new Object[0])), new Object[]{""});
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject execBatchCompute(JSONObject paramsObject, List<Long> configCodeList) {
        BatchTask task = BatchTask.create((String)"ConfigBomExpandByTask");
        String taskId = task.getCalcId();
        int oneBatchCount = this.getOneBatchCount();
        task.setQueueName(this.getExpandQueue());
        task.registBizClass(ConfigBomExpandBatchTaskEvent.class);
        ArrayList<Long> batchConfigCodeList = new ArrayList<Long>(oneBatchCount);
        int size = configCodeList.size();
        int batch = 0;
        for (int i = 0; i < size; ++i) {
            Long configId = configCodeList.get(i);
            batchConfigCodeList.add(configId);
            if (batchConfigCodeList.size() < oneBatchCount) continue;
            ++batch;
            HashMap<String, Object> batchParams = new HashMap<String, Object>(16);
            batchParams.put("params", paramsObject.toJSONString());
            ArrayList<Long> oneConfigCodeList = new ArrayList<Long>(oneBatchCount);
            oneConfigCodeList.addAll(batchConfigCodeList);
            batchParams.put("configList", oneConfigCodeList);
            batchParams.put("batch", batch);
            task.addEvent(batchParams);
            batchConfigCodeList.clear();
        }
        if (batchConfigCodeList.size() > 0) {
            ++batch;
            HashMap<String, Object> batchParams = new HashMap<String, Object>(16);
            batchParams.put("params", paramsObject.toJSONString());
            ArrayList<Long> oneConfigCodeList = new ArrayList<Long>(oneBatchCount);
            oneConfigCodeList.addAll(batchConfigCodeList);
            batchParams.put("configList", oneConfigCodeList);
            batchParams.put("batch", batch);
            task.addEvent(batchParams);
            batchConfigCodeList.clear();
        }
        long startTime = System.currentTimeMillis();
        boolean successful = true;
        try {
            logger.info((Object)("configBomExpand_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u5f00\u59cb\uff0c[" + configCodeList.size() + "]\u4e2a\u914d\u7f6e\u53f7\u5206\u53d1\u4e3a\u5171[" + batch + "]\u4e2a\u4efb\u52a1..."));
            task.startTask();
            logger.info((Object)"configBomExpand_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u7ed3\u675f...");
        }
        catch (Exception e) {
            logger.error((Object)("configBomExpand_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
            successful = false;
        }
        finally {
            task.terminate();
        }
        if (!successful) {
            throw new KDBizException(ResManager.loadKDString((String)"BOM\u914d\u7f6e\u6279\u91cf\u8ba1\u7b97\u5931\u8d25\u3002\u8bf7\u67e5\u770b\u65e5\u5fd7\u4e86\u89e3\u8be6\u60c5\u3002", (String)"BatchProConfigFeatureListBusiness_4", (String)"mmc-pdm-business", (Object[])new Object[0]));
        }
        long enddate = System.currentTimeMillis() - startTime;
        logger.info((Object)("configBomExpand_BatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97,configCodeList.size =" + configCodeList.size() + ",cost:" + enddate + "ms"));
        JSONObject res = new JSONObject();
        String cacheRedisPath = this.getRedisPath();
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(cacheRedisPath);
        String keyString = this.getParamKeyString(paramsObject);
        JSONObject ret = new JSONObject();
        ArrayList<String> configIdKeyList = new ArrayList<String>(size);
        for (Long configId : configCodeList) {
            String configKeyString = String.valueOf(configId) + "_" + keyString;
            configIdKeyList.add(configKeyString);
        }
        ret.put("configIdKeyList", configIdKeyList);
        ret.put("redisCachePath", (Object)this.getRedisPath());
        res.put("status", (Object)"success");
        res.put("msg", (Object)ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"BatchProConfigFeatureListBusiness_5", (String)"mmc-pdm-business", (Object[])new Object[0]));
        res.put("data", (Object)ret);
        return res;
    }

    public void clearRedisCache(String params) {
        if (params == null || "".equals(params)) {
            return;
        }
        JSONObject paramsJson = JSONObject.parseObject((String)params);
        List configObj = JSONObject.parseArray((String)paramsJson.get((Object)"configCodeList").toString(), Long.class);
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(this.getRedisPath());
        String keyString = this.getParamKeyString(paramsJson);
        ArrayList<String> moveKey = new ArrayList<String>(2);
        for (Long ids : configObj) {
            String configKeyString = String.valueOf(ids) + "_" + keyString;
            if (!this.isContains(cache, configKeyString)) continue;
            moveKey.add(configKeyString);
        }
        cache.remove(moveKey.toArray(new String[moveKey.size()]));
    }

    public boolean isContains(DistributeSessionlessCache cache, String configKeyString) {
        return cache.contains(configKeyString);
    }
}

