/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pdm.business.proconfig.proconfiglist;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.ext.mmc.business.query.helper.MmcCommonHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pdm.business.mftbom.bomsearch.BomUnitConvertBusiness;
import kd.mmc.pdm.business.proconfig.proconfiglist.ParseFeatureListToMatListBusiness;
import kd.mmc.pdm.common.util.MMCUtils;
import kd.mmc.pdm.common.util.PdmParamSetHelper;

public class ProductConfigCommonBusiness {
    private static final Log logger = LogFactory.getLog(ProductConfigCommonBusiness.class);
    public static final DBRoute scmDBRoute = new DBRoute("scm");
    public static final String PARAM_CONSUMERQUEUE = "configBomExpand_ConsumerQueue";
    public static final String PARAM_ISBATCHCOMPUTE = "configBomExpand_IsBatchCompute";
    public static final String PARAM_ONEBATCHCOUNT = "configBomExpand_OneBatchCount";
    public static final String PARAM_REDISPATH = "configBomExpand_RedisPath";
    public static final String PARAM_REDISTIMELONG = "configBomExpand_RedisTimeOutLong";

    public Map<Long, List<Map<String, Object>>> getProComfigFeature(DataSet dataSet) {
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        HashMap<Long, List<Map<String, Object>>> retMap = new HashMap<Long, List<Map<String, Object>>>();
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long id = row.getLong("id");
                ArrayList entryList = (ArrayList)retMap.get(id);
                if (entryList == null) {
                    entryList = new ArrayList(10);
                }
                HashMap<String, Object> entryMap = new HashMap<String, Object>(10);
                for (int i = 0; i < fieldNames.length; ++i) {
                    String fieldName = fieldNames[i];
                    if (fieldName.equalsIgnoreCase("featuredefno")) {
                        fieldName = "featuredefno";
                    } else if (fieldName.equalsIgnoreCase("id")) {
                        fieldName = "id";
                    } else if (fieldName.equalsIgnoreCase("featuredefnum")) {
                        fieldName = "featuredefnum";
                    } else if (fieldName.equalsIgnoreCase("entryvalue")) {
                        fieldName = "entryvalue";
                    } else if (fieldName.equalsIgnoreCase("entryvaluename")) {
                        fieldName = "entryvaluename";
                    }
                    if ("id".equalsIgnoreCase(fieldName)) continue;
                    entryMap.put(fieldName, row.get(fieldName));
                }
                entryList.add(entryMap);
                retMap.put(id, entryList);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        finally {
            dataSet.close();
        }
        return retMap;
    }

    public JSONArray createEntryRetVal(DataSet treeEntryDataSet, Row proConfigRow, Map<String, String> featureMatAttrMap, boolean purchaseExpand, long proMatId, BigDecimal num, Set<Long> matIdSet, Set<Long> unitSet) {
        return this.matchEntryRetVal(treeEntryDataSet, proConfigRow, featureMatAttrMap, proMatId, num, matIdSet, unitSet);
    }

    public JSONArray matchEntryRetVal(DataSet treeEntryDataSet, Row proConfigRow, Map<String, String> featureMatAttrMap, long prodMatId, BigDecimal num, Set<Long> matIdSet, Set<Long> unitSet) {
        List<String> fieldList = this.getRetField();
        JSONArray treeArray = new JSONArray();
        Map<Long, Map<String, Object>> matMap = this.getFeatureTypeMaterial(matIdSet);
        BomUnitConvertBusiness unitConvertImp = new BomUnitConvertBusiness();
        HashMap<String, DynamicObject> unitMap = new HashMap<String, DynamicObject>(matIdSet.size());
        Map<String, DynamicObject> allCommonUnitMap = unitConvertImp.getAllCommonConvertRule(unitSet);
        boolean isFirstLoad = true;
        if (prodMatId == 0L || prodMatId == -1L) {
            prodMatId = proConfigRow.getLong("materielno");
        }
        int fieldSize = fieldList.size();
        while (treeEntryDataSet.hasNext()) {
            Row row = treeEntryDataSet.next();
            String configproperties = row.getString("configproperties");
            String entrytype = row.getString("entrytype");
            String createorg = row.getString("createorg");
            long entryMatLongId = row.getLong("entrymaterial_id");
            Map<String, Object> matObj = matMap.get(entryMatLongId);
            long baseUnit = 0L;
            if (matObj != null && "B".equals(entrytype)) {
                baseUnit = matObj.get("baseunit") == null ? 0L : Long.parseLong(matObj.get("baseunit").toString());
            }
            JSONObject treeEntryObj = new JSONObject();
            for (int i = 0; i < fieldSize; ++i) {
                BigDecimal convertrate;
                String fieldName = fieldList.get(i);
                Object valObj = row.get(fieldName);
                if ("pid".equals(fieldName) || "id".equals(fieldName) || "routeId".equals(fieldName)) {
                    treeEntryObj.put(fieldName, (Object)(valObj == null ? 0L : Long.parseLong(valObj.toString())));
                    continue;
                }
                if ("entryunitqty".equals(fieldName)) {
                    BigDecimal entryunitqty = this.calculateNumerator(row, num);
                    if ("B".equals(entrytype) && baseUnit != 0L) {
                        BigDecimal convertrate2 = this.getConvertrate(unitConvertImp, row, baseUnit, unitMap, allCommonUnitMap, isFirstLoad, matIdSet, unitSet);
                        isFirstLoad = false;
                        entryunitqty = MMCUtils.multiply((BigDecimal)entryunitqty, (BigDecimal)convertrate2);
                    }
                    treeEntryObj.put(fieldName, (Object)entryunitqty);
                    continue;
                }
                if ("entryunit".equals(fieldName) && "B".equals(entrytype) && baseUnit != 0L) {
                    treeEntryObj.put(fieldName, (Object)baseUnit);
                    continue;
                }
                if ("convertrate".equals(fieldName) && "B".equals(entrytype) && baseUnit != 0L) {
                    convertrate = this.getConvertrate(unitConvertImp, row, baseUnit, unitMap, allCommonUnitMap, isFirstLoad, matIdSet, unitSet);
                    isFirstLoad = false;
                    treeEntryObj.put(fieldName, (Object)convertrate);
                    continue;
                }
                if ("entryqty".equals(fieldName) && "B".equals(entrytype) && baseUnit != 0L) {
                    convertrate = this.getConvertrate(unitConvertImp, row, baseUnit, unitMap, allCommonUnitMap, isFirstLoad, matIdSet, unitSet);
                    isFirstLoad = false;
                    BigDecimal entryQty = (BigDecimal)row.get(fieldName);
                    entryQty = MMCUtils.multiply((BigDecimal)entryQty, (BigDecimal)convertrate);
                    treeEntryObj.put(fieldName, (Object)entryQty);
                    continue;
                }
                treeEntryObj.put(fieldName, row.get(fieldName));
            }
            String entryMatId = row.getString("entrymaterial_id");
            String keyStr = createorg + "-" + entryMatId;
            String entryFeatureMatAttr = featureMatAttrMap.get(keyStr);
            if ("B".equals(entrytype)) {
                treeEntryObj.put("entrymaterialattr", (Object)entryFeatureMatAttr);
            }
            if ("2".equals(configproperties) || "3".equals(configproperties)) {
                treeEntryObj.put("configcode", (Object)proConfigRow.getLong("masterconfigcode"));
            } else {
                treeEntryObj.put("configcode", (Object)0L);
            }
            treeEntryObj.put("configlistid", (Object)proConfigRow.getLong("id"));
            treeEntryObj.put("prodorgid", (Object)proConfigRow.getLong("prodorgid"));
            treeEntryObj.put("prodMatId", (Object)prodMatId);
            treeEntryObj.put("num", (Object)num);
            treeArray.add((Object)treeEntryObj);
        }
        return treeArray;
    }

    public BigDecimal getConvertrate(BomUnitConvertBusiness bomUnitConvertBusiness, Row row, long baseUnit, Map<String, DynamicObject> unitMap, Map<String, DynamicObject> allCommonUnitMap, boolean isFirstLoad, Set<Long> allMatIdset, Set<Long> unitSet) {
        long entryMatId = row.getLong("entrymaterial_id");
        long entryunit = row.getLong("entryunit");
        BigDecimal newConvertrate = BigDecimal.ONE;
        DynamicObject unitObj = null;
        if (baseUnit != entryunit) {
            boolean isBackWard = false;
            unitObj = allCommonUnitMap.get(entryunit + "-" + baseUnit);
            if (unitObj == null) {
                unitObj = bomUnitConvertBusiness.getMultiTypeUnit(entryMatId + "-" + entryunit, isFirstLoad, unitMap, allMatIdset, unitSet);
                isFirstLoad = false;
            }
            if (unitObj == null) {
                isBackWard = true;
                unitObj = allCommonUnitMap.get(baseUnit + "-" + entryunit);
            }
            newConvertrate = bomUnitConvertBusiness.convert(unitObj, newConvertrate, isBackWard);
        }
        return newConvertrate;
    }

    public Map<Long, Map<String, Object>> getFeatureTypeMaterial(Set<Long> matIdSet) {
        if (matIdSet.isEmpty()) {
            return new HashMap<Long, Map<String, Object>>(1);
        }
        HashMap<Long, Map<String, Object>> retMatMap = new HashMap<Long, Map<String, Object>>(matIdSet.size());
        QFilter filter = new QFilter("id", "in", matIdSet);
        QFilter statusQFilter = new QFilter("status", "=", (Object)"C");
        QFilter useQFilter = new QFilter("enable", "=", (Object)"1");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BOMForwardSearchReportPlugin", (String)"bd_material", (String)"id,number,baseunit", (QFilter[])new QFilter[]{filter.and(statusQFilter).and(useQFilter)}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long matId = row.getLong("id");
                String matNum = row.getString("number");
                long baseUnit = row.getLong("baseunit");
                HashMap<String, Object> matMap = new HashMap<String, Object>(16);
                matMap.put("number", matNum);
                matMap.put("baseunit", baseUnit);
                retMatMap.put(matId, matMap);
            }
        }
        return retMatMap;
    }

    private BigDecimal calculateNumerator(Row row, BigDecimal demandCount) {
        String parentfxd = row.getString("parentfxd");
        BigDecimal entryqtydenominator = row.getBigDecimal("entryqtydenominator");
        String entryqtytype = row.getString("entryqtytype");
        BigDecimal commonused = row.getBigDecimal("entryqty");
        BigDecimal oneNumberator = null;
        oneNumberator = "1".equals(parentfxd) || "B".equals(entryqtytype) ? MMCUtils.multiply((BigDecimal)commonused, (BigDecimal)entryqtydenominator) : MMCUtils.multiplyAndDivide((BigDecimal)commonused, (BigDecimal)entryqtydenominator, (BigDecimal)demandCount);
        return oneNumberator;
    }

    public Map<String, List<Map<String, Object>>> getSelectedFeatureVal(Row proConfigListRow, Map<Long, List<Map<String, Object>>> featureValMap) {
        HashMap<String, List<Map<String, Object>>> newFeatureDefAndValueColls = new HashMap<String, List<Map<String, Object>>>();
        if (featureValMap == null || featureValMap.isEmpty()) {
            return newFeatureDefAndValueColls;
        }
        long proConfigListId = proConfigListRow.getLong("id");
        List<Map<String, Object>> featureValList = featureValMap.get(proConfigListId);
        if (featureValList == null || featureValList.isEmpty()) {
            return newFeatureDefAndValueColls;
        }
        int size = featureValList.size();
        for (int i = 0; i < size; ++i) {
            String featureDefId;
            Map<String, Object> entryMap = featureValList.get(i);
            Object featureObj = entryMap.get("featuredefno");
            if (featureObj == null || newFeatureDefAndValueColls.containsKey(featureDefId = featureObj.toString())) continue;
            List<Map<String, Object>> col = this.getTheSameFeatureValOfFeatureDef(featureValList, featureDefId);
            newFeatureDefAndValueColls.put(featureDefId, col);
        }
        return newFeatureDefAndValueColls;
    }

    public List<Map<String, Object>> getTheSameFeatureValOfFeatureDef(List<Map<String, Object>> featureValList, String id) {
        ArrayList<Map<String, Object>> featureValMap = new ArrayList<Map<String, Object>>(10);
        int size = featureValList.size();
        for (int i = 0; i < size; ++i) {
            String featureDefId;
            Map<String, Object> entryMap = featureValList.get(i);
            Object featureObj = entryMap.get("featuredefno");
            if (featureObj == null || (featureDefId = featureObj.toString()) == null || !featureDefId.equals(id)) continue;
            featureValMap.add(entryMap);
        }
        return featureValMap;
    }

    public String getFeatureFields() {
        StringBuilder sb = new StringBuilder("id");
        sb.append(",entryentity.featureid as featureid");
        sb.append(",entryentity.itemselector as itemselector");
        return sb.toString();
    }

    public String getFeatureValFields() {
        StringBuilder sb = new StringBuilder("id");
        sb.append(",featuretreeentryentity.featuredefno.id as featuredefno");
        sb.append(",featuretreeentryentity.featuredefno.number as featuredefnum");
        sb.append(",featuretreeentryentity.entryvalue as entryvalue");
        sb.append(",featuretreeentryentity.entryvaluename as entryvaluename");
        return sb.toString();
    }

    public List<String> getRetField() {
        ArrayList<String> fieldList = new ArrayList<String>(64);
        fieldList.add("pid");
        fieldList.add("id");
        fieldList.add("createorg");
        fieldList.add("pmaterial");
        fieldList.add("pmaterialmftinfo");
        fieldList.add("pversion");
        fieldList.add("superbomid");
        fieldList.add("number");
        fieldList.add("entryseq");
        fieldList.add("entrytype");
        fieldList.add("superbomentryid");
        fieldList.add("entrymaterial");
        fieldList.add("entrymaterial_id");
        fieldList.add("entryversion");
        fieldList.add("entrymaterialattr");
        fieldList.add("entryunit");
        fieldList.add("entryqtytype");
        fieldList.add("entryauxproperty");
        fieldList.add("entryvaliddate");
        fieldList.add("entryinvaliddate");
        fieldList.add("entryscraprate");
        fieldList.add("entryfixscrap");
        fieldList.add("entryqtynumerator");
        fieldList.add("entryqtydenominator");
        fieldList.add("entryunitqty");
        fieldList.add("parentqty");
        fieldList.add("entryqty");
        fieldList.add("convertrate");
        fieldList.add("entryisjumplevel");
        fieldList.add("issolid");
        fieldList.add("workentryqty");
        fieldList.add("workcenter");
        fieldList.add("workstation");
        fieldList.add("routeId");
        fieldList.add("isauxbom");
        fieldList.add("entryisreplace");
        fieldList.add("entryreplaceplan");
        fieldList.add("entryisreplaceplanmm");
        fieldList.add("entryreplacegroup");
        fieldList.add("reppriority");
        return fieldList;
    }

    public void initProConfigData(DataSet proConfigListDataSet, Set<Long> idSet, Map<Long, Set<Long>> materialMap) {
        while (proConfigListDataSet.hasNext()) {
            Row row = proConfigListDataSet.next();
            Long id = row.getLong("id");
            idSet.add(id);
            long headMaterialId = row.getLong("materielno");
            long createOrgId = row.getLong("createorg");
            Set<Long> materialIdSet = materialMap.get(createOrgId);
            if (materialIdSet == null) {
                materialIdSet = new HashSet<Long>(16);
            }
            materialIdSet.add(headMaterialId);
            materialMap.put(createOrgId, materialIdSet);
        }
        proConfigListDataSet.close();
    }

    public long getReplaceNo(DataSet superBom) {
        long retReplaceNo = 0L;
        if (superBom == null) {
            return retReplaceNo;
        }
        try (DataSet bomSet = superBom.copy();){
            Row row = bomSet.next();
            retReplaceNo = row.getLong("replaceno");
        }
        return retReplaceNo;
    }

    public DataSet getSuperBom(String orgIdStr, String bomIdStr, long matId, Row proConfigRow, String bomVer, Set<Long> bomTypeSet, BigDecimal num, long replaceNo) {
        long headMaterialId = proConfigRow.getLong("materielno");
        if (matId == -1L) {
            matId = headMaterialId;
        }
        long orgId = -1L;
        if (orgIdStr != null && !"".equals(orgIdStr)) {
            orgId = Long.parseLong(orgIdStr);
        }
        long bomId = -1L;
        if (bomIdStr != null && !"".equals(bomIdStr) && !"0".equals(bomIdStr)) {
            bomId = Long.parseLong(bomIdStr);
        }
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter material = new QFilter("materialid", "=", (Object)matId);
        QFilter superBomIds = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_mftbom", (Long)orgId);
        QFilter auxPropFilter = new QFilter("auxproperty", "=", (Object)0L);
        QFilter configCeode = new QFilter("configuredcode", "=", (Object)0L);
        QFilter bomTypeFilter = new QFilter("type", "in", bomTypeSet);
        QFilter[] superBomFilter = new QFilter[]{material, superBomIds, status, enable, auxPropFilter, bomTypeFilter, configCeode};
        if (bomId != -1L) {
            QFilter bomIdFilter = new QFilter("id", "=", (Object)bomId);
            superBomFilter = new QFilter[]{bomIdFilter};
        }
        DataSet superBomSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pdm_mftbom", (String)ParseFeatureListToMatListBusiness.getPropertiesWithQuerySuperBom(num), (QFilter[])superBomFilter, (String)"id");
        return superBomSet;
    }

    private DynamicObject getMaterial(long matId) {
        return QueryServiceHelper.queryOne((String)"bd_material", (String)"id,isenablematerialversion", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)matId)});
    }

    public static String getKeyString(long a, long b) {
        return a + "_" + b;
    }

    public Map<String, Map<String, Object>> getCofigPlan(long matId, Map<Long, Set<Long>> materialOrgMap) {
        HashMap<String, Map<String, Object>> dataMap = new HashMap<String, Map<String, Object>>(16);
        long startTime = System.currentTimeMillis();
        if (materialOrgMap != null) {
            for (Map.Entry<Long, Set<Long>> entrys : materialOrgMap.entrySet()) {
                Set<Long> materialIdSet = entrys.getValue();
                long createOrgId = entrys.getKey();
                QFilter schemeIds = BaseDataServiceHelper.getBaseDataFilter((String)"pdm_proconfigscheme", (Long)createOrgId);
                QFilter materialnum = new QFilter("materielnum", "in", materialIdSet);
                QFilter status = new QFilter("status", "=", (Object)"C");
                QFilter enable = new QFilter("enable", "=", (Object)"1");
                String fields = "id,bomexpandconfig,materielnum,configtype";
                DataSet proConfigSchemeDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pdm_proconfigscheme", (String)fields, (QFilter[])new QFilter[]{schemeIds, materialnum, status, enable}, null);
                Throwable throwable = null;
                try {
                    while (proConfigSchemeDataSet.hasNext()) {
                        Row row = proConfigSchemeDataSet.next();
                        long materialId = row.getLong("materielnum");
                        long id = row.getLong("id");
                        long bomExpandConfig = row.getLong("bomexpandconfig");
                        String configtype = row.getString("configtype");
                        String keyString = ProductConfigCommonBusiness.getKeyString(materialId, createOrgId);
                        HashMap<String, Object> aMap = new HashMap<String, Object>(16);
                        aMap.put("id", id);
                        aMap.put("bomExpandConfig", bomExpandConfig);
                        aMap.put("configtype", configtype);
                        dataMap.put(keyString, aMap);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (proConfigSchemeDataSet == null) continue;
                    if (throwable != null) {
                        try {
                            proConfigSchemeDataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    proConfigSchemeDataSet.close();
                }
            }
        }
        long enddate = System.currentTimeMillis() - startTime;
        logger.info("mmc-pdm-queryProconfigschemeData,cost:" + enddate + "ms");
        return dataMap;
    }

    public DataSet getFeatureDataSet(Set<Long> proConfigListIdSet) {
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" fid as ", new Object[0]).append("id", new Object[0]);
        sb.append(",ffeatureid as featureid", new Object[0]);
        sb.append(",fitemselector as itemselector", new Object[0]);
        sb.append(" from t_pdm_prodconffeaturedef ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("fid", proConfigListIdSet.toArray());
        return DB.queryDataSet((String)this.getAlgoxKeyString("getFeatureDataSet"), (DBRoute)scmDBRoute, (SqlBuilder)sb);
    }

    private String getAlgoxKeyString(String paramString) {
        return ProductConfigCommonBusiness.class.getName() + "_" + paramString;
    }

    public DataSet getFeatureValueDataSet(Set<Long> proConfigListIdSet) {
        SqlBuilder sb = new SqlBuilder();
        sb.append(" select", new Object[0]);
        sb.append(" a.fid as ", new Object[0]).append("id", new Object[0]);
        sb.append(",a.ffeaturedefnoid as ", new Object[0]).append("featuredefno", new Object[0]);
        sb.append(",b.fnumber as ", new Object[0]).append("featuredefnum", new Object[0]);
        sb.append(",a.fentryvalue as ", new Object[0]).append("entryvalue", new Object[0]);
        sb.append(",a.fentryvaluename as entryvaluename", new Object[0]);
        sb.append(" from t_pdm_prodconffeatureval a ", new Object[0]);
        sb.append(" inner join  t_pdm_featuredefinition b on a.ffeaturedefnoid = b.fid ", new Object[0]);
        sb.append(" where  ", new Object[0]);
        sb.appendIn("a.fid", proConfigListIdSet.toArray());
        return DB.queryDataSet((String)this.getAlgoxKeyString("getFeatureValueDataSet"), (DBRoute)scmDBRoute, (SqlBuilder)sb);
    }

    public boolean getIsBatchCompute() {
        return PdmParamSetHelper.getBooleanParamValue((String)PARAM_ISBATCHCOMPUTE);
    }

    public int getOneBatchCount() {
        return PdmParamSetHelper.getIntParamValue((String)PARAM_ONEBATCHCOUNT);
    }

    public String getExpandQueue() {
        return PdmParamSetHelper.getStringParamValue((String)PARAM_CONSUMERQUEUE);
    }

    public String getRedisPath() {
        String defValue = PdmParamSetHelper.getStringParamValue((String)PARAM_REDISPATH);
        if (StringUtils.isEmpty((String)defValue)) {
            defValue = "mmc-pdm-configbomsearch";
        }
        return defValue;
    }

    public int getRedisTimeOutLong() {
        return PdmParamSetHelper.getIntParamValue((String)PARAM_REDISTIMELONG);
    }

    public List<String> cacheRedisValue(JSONObject dealJsonData, JSONObject paramsJson) {
        String cacheRedisPath = this.getRedisPath();
        Set configIdStrSet = dealJsonData.keySet();
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(cacheRedisPath);
        int timeOutLong = this.getRedisTimeOutLong();
        String keyString = this.getParamKeyString(paramsJson);
        ArrayList<String> configKeyStringList = new ArrayList<String>(configIdStrSet.size());
        for (String configIdStr : configIdStrSet) {
            JSONObject jsObj = dealJsonData.getJSONObject(configIdStr);
            String configKeyString = configIdStr + "_" + keyString;
            this.setCache(cache, configKeyString, jsObj, timeOutLong);
            configKeyStringList.add(configKeyString);
        }
        return configKeyStringList;
    }

    private void setCache(DistributeSessionlessCache cache, String configKeyString, JSONObject jsObj, int timeOutLong) {
        cache.put(configKeyString, (Object)jsObj.toJSONString(), timeOutLong);
    }

    public String getParamKeyString(JSONObject paramsJson) {
        Date dateTime = paramsJson.getDate("searchTime");
        if (dateTime == null) {
            dateTime = new Date();
            paramsJson.put("searchTime", (Object)dateTime);
        }
        boolean isNeedProRoute = paramsJson.getBoolean("isNeedProRoute");
        String model = paramsJson.getString("model");
        String matIdStr = paramsJson.getString("matId");
        String bomVer = paramsJson.getString("bomVer");
        BigDecimal num = paramsJson.getBigDecimal("num");
        String workCenter = paramsJson.getString("workCenter");
        boolean purchaseExpand = true;
        if (paramsJson.containsKey((Object)"purchaseExpand")) {
            purchaseExpand = paramsJson.getBoolean("purchaseExpand");
        }
        Long uuid = 0L;
        if (paramsJson.containsKey((Object)"uuid")) {
            uuid = paramsJson.getLong("uuid");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(uuid);
        sb.append('_');
        boolean isBomExpandTime = MmcCommonHelper.IsBomExpandTime();
        if (!isBomExpandTime) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            sb.append(sdf.format(dateTime));
        } else {
            sb.append(dateTime.getTime());
        }
        sb.append('_');
        sb.append(isNeedProRoute);
        sb.append('_');
        sb.append(model);
        sb.append('_');
        sb.append(matIdStr == null ? "" : matIdStr);
        sb.append('_');
        sb.append(bomVer == null ? "" : bomVer);
        sb.append('_');
        sb.append(num);
        sb.append('_');
        sb.append(workCenter == null ? "" : workCenter);
        sb.append('_');
        sb.append(purchaseExpand);
        return sb.toString();
    }
}

