/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common;

import java.util.Calendar;

public class CronStruct {
    private String seconds;
    private String minutes;
    private String hours;
    private String dayOfMonth;
    private String month;
    private String dayOfWeek;
    private String year;
    private StringBuilder descBuf;

    public String getSeconds() {
        return this.seconds;
    }

    public void setSeconds(String seconds) {
        this.seconds = seconds;
    }

    public String getMinutes() {
        return this.minutes;
    }

    public void setMinutes(String minutes) {
        this.minutes = minutes;
    }

    public String getHours() {
        return this.hours;
    }

    public void setHours(String hours) {
        this.hours = hours;
    }

    public String getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(String dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public String getMonth() {
        return this.month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public String getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(String dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public static CronStruct parse(String cronStr) {
        if (cronStr == null) {
            return null;
        }
        String[] cronArray = cronStr.split(" ");
        if (cronArray.length >= 6 && cronArray.length <= 7) {
            CronStruct cronStruct = new CronStruct();
            cronStruct.setSeconds(cronArray[0]);
            cronStruct.setMinutes(cronArray[1]);
            cronStruct.setHours(cronArray[2]);
            cronStruct.setDayOfMonth(cronArray[3]);
            cronStruct.setMonth(cronArray[4]);
            cronStruct.setDayOfWeek(cronArray[5]);
            if (cronArray.length == 7) {
                cronStruct.setYear(cronArray[6]);
            }
            return cronStruct;
        }
        return null;
    }

    public String toString() {
        String cronStr = this.getSeconds() + " " + this.getMinutes() + " " + this.getHours() + " " + this.getDayOfMonth() + " " + this.getMonth() + " " + this.getDayOfWeek();
        if (this.getYear() != null) {
            cronStr = cronStr + " " + this.getYear();
        }
        return cronStr;
    }

    public StringBuilder getDescBuf() {
        if (this.descBuf == null) {
            this.descBuf = new StringBuilder();
        }
        return this.descBuf;
    }

    public static CronStruct init(Calendar calendar) {
        CronStruct cron = new CronStruct();
        cron.setSeconds("0");
        cron.setMinutes(String.valueOf(calendar.get(12)));
        cron.setHours(String.valueOf(calendar.get(11)));
        cron.setDayOfMonth(String.valueOf(calendar.get(5)));
        cron.setMonth(String.valueOf(calendar.get(2) + 1));
        cron.setDayOfWeek("?");
        cron.setYear(String.valueOf(calendar.get(1)));
        return cron;
    }
}

