/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ExecutionResult {
    private int totalCount;
    private int ignoredCount;
    private int successCount;
    private int failedCount;
    private Set<String> stateSet;

    public ExecutionResult(int totalCount, int ignoredCount, int successCount, int failedCount, Set<String> stateSet) {
        this.totalCount = totalCount;
        this.ignoredCount = ignoredCount;
        this.successCount = successCount;
        this.failedCount = failedCount;
        this.stateSet = new HashSet<String>(stateSet);
    }

    public boolean isCompleted() {
        return this.getStateSet().size() == 1 && this.getStateSet().contains(StateEnum.SUCCESS.getValue());
    }

    public boolean isCancel() {
        return this.getStateSet().size() == 1 && this.getStateSet().contains(StateEnum.CANCEL.getValue());
    }

    public boolean isFailed() {
        return this.getStateSet().size() == 1 && this.getStateSet().contains(StateEnum.FAIL.getValue());
    }

    public int getTotalCount() {
        return this.totalCount <= 0 ? -1 : this.totalCount;
    }

    public int getIgnoredCount() {
        return this.ignoredCount < 0 ? 0 : this.ignoredCount;
    }

    public int getSuccessCount() {
        return this.successCount < 0 ? 0 : this.successCount;
    }

    public int getFailedCount() {
        return this.failedCount < 0 ? 0 : this.failedCount;
    }

    public Set<String> getStateSet() {
        return Collections.unmodifiableSet(this.stateSet);
    }

    private static enum StateEnum {
        CREATE("C"),
        RUNNING("R"),
        SUCCESS("S"),
        FAIL("F"),
        CANCEL("X");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

