/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.adaptor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.mmc.phm.common.bizmodel.Column;
import kd.mmc.phm.common.bizmodel.DetailTable;
import kd.mmc.phm.common.info.CellInfo;
import kd.mmc.phm.common.info.ContentInfo;
import kd.mmc.phm.common.info.TableHeadInfo;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelAdaptor {
    private ContentInfo contentInfo;
    private Workbook workbook;

    public ExcelAdaptor(DetailTable detailTable) {
        Objects.requireNonNull(detailTable);
        this.workbook = new SXSSFWorkbook();
        this.init(detailTable);
    }

    private void init(DetailTable detailTable) {
        ArrayList<TableHeadInfo> tableHeadInfos = new ArrayList<TableHeadInfo>(1);
        ArrayList<List<CellInfo>> tableBodyInfos = new ArrayList<List<CellInfo>>(1);
        this.contentInfo = new ContentInfo(tableHeadInfos, tableBodyInfos);
        List<Column> cols = detailTable.getCols();
        List<Map<String, Object>> all = detailTable.getAll();
        int allSize = all.size();
        int colsSize = cols.size();
        Object[][] cells = new Object[allSize][colsSize];
        for (int i = 0; i < colsSize; ++i) {
            Column col = cols.get(i);
            String title = col.getTitle();
            String field = col.getField();
            tableHeadInfos.add(new TableHeadInfo(title, 1500));
            for (int j = 0; j < allSize; ++j) {
                Object cellData;
                Map<String, Object> stringObjectMap = all.get(j);
                cells[j][i] = cellData = stringObjectMap.get(field);
            }
        }
        for (int j = 0; j < allSize; ++j) {
            ArrayList<CellInfo> cellInfos = new ArrayList<CellInfo>(colsSize);
            for (int i = 0; i < colsSize; ++i) {
                cellInfos.add(new CellInfo(cells[j][i]));
            }
            tableBodyInfos.add(cellInfos);
        }
    }

    public String getExcelFileTempUrl(String fileName) {
        Sheet sheet = this.workbook.createSheet(ResManager.loadKDString((String)"\u7b2c\u4e00\u9875", (String)"ExcelAdaptor_0", (String)"mmc-phm-common", (Object[])new Object[0]));
        Row row = sheet.createRow(0);
        List<TableHeadInfo> tableHeadInfos = this.contentInfo.getTableHeadInfos();
        for (int i = 0; i < tableHeadInfos.size(); ++i) {
            TableHeadInfo tableHeadInfo = tableHeadInfos.get(i);
            String value = tableHeadInfo.getValue();
            int width = tableHeadInfo.getWidth();
            sheet.setColumnWidth(i, width);
            Cell cell = row.createCell(i);
            cell.setCellValue(value);
            cell.setCellStyle(this.makeStyle(1));
        }
        List<List<CellInfo>> tableBodyInfos = this.contentInfo.getTableBodyInfos();
        for (int i = 0; i < tableBodyInfos.size(); ++i) {
            List<CellInfo> tableBodies = tableBodyInfos.get(i);
            Row tableRow = sheet.createRow(i + 1);
            for (int j = 0; j < tableBodies.size(); ++j) {
                CellInfo cellInfo = tableBodies.get(j);
                Object value = cellInfo.getValue();
                Cell cell = tableRow.createCell(j);
                if (value instanceof Double) {
                    cell.setCellValue(((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Date) {
                    cell.setCellValue((Date)value);
                    continue;
                }
                cell.setCellValue(value.toString());
            }
        }
        String tempUrl = "";
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        int timeout = 7200;
        try {
            out = new ByteArrayOutputStream();
            this.workbook.write((OutputStream)out);
            in = new ByteArrayInputStream(out.toByteArray());
            tempUrl = cache.saveAsUrl(fileName + ".xlsx", (InputStream)in, timeout);
            out.close();
            ((InputStream)in).close();
            this.workbook.close();
        }
        catch (IOException e) {
            throw new KDException(new ErrorCode(ResManager.loadKDString((String)"\u660e\u7ec6\u5bfc\u51fa\u51fa\u9519", (String)"ExcelAdaptor_1", (String)"mmc-phm-common", (Object[])new Object[0]), e.getMessage()), new Object[]{e});
        }
        return tempUrl;
    }

    private CellStyle makeStyle(int type) {
        CellStyle style = this.workbook.createCellStyle();
        DataFormat format = this.workbook.createDataFormat();
        style.setDataFormat(format.getFormat("@"));
        style.setAlignment(HorizontalAlignment.CENTER);
        Font font = this.workbook.createFont();
        if (type == 1) {
            style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setAlignment(HorizontalAlignment.GENERAL);
        }
        style.setFont(font);
        return style;
    }
}

