/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.bizmodel;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;

public enum ComponentType implements Serializable
{
    ELEMENT("phm_bizmodel_element", "phm_element_component"),
    ADJUSTMENT("phm_bizmodel_adjust", "phm_adjust_component"),
    CONNECTION("phm_bizmodel_connect", "phm_connect_component"),
    EIGENVALUE("phm_bizmodel_eigen", "phm_eigen_component"),
    QUERY("phm_bizmodel_query", "phm_query_component"),
    DETAIL("phm_bizmodel_detail", "phm_detail_component"),
    TEXT("phm_bizmodel_txt", "phm_txt_component"),
    UNDEFINED("", "undefined");

    private final String name;
    private final String value;

    private ComponentType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static ComponentType fromValue(String value) {
        for (ComponentType componentType : ComponentType.values()) {
            if (!StringUtils.equals((CharSequence)value, (CharSequence)componentType.getValue())) continue;
            return componentType;
        }
        return UNDEFINED;
    }

    public static List<ComponentType> getAll() {
        return Arrays.stream(ComponentType.values()).filter(componentType -> componentType != UNDEFINED).collect(Collectors.toList());
    }
}

