/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.common.bizmodel;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.NetAddressUtils;
import kd.mmc.phm.common.basemanager.ScheduleConsts;

public class TaskUtils {
    private static final String PROP_NUMBER = "number";
    private static final String ENTITY_SCH_JOB = "sch_job";
    private static final String ENTITY_SCH_SCHEDULE = "sch_schedule";
    public static final String BASE_TASK = "kd.mmc.phm.common.task.BizModelCalculatTask";
    public static final String LOCALIP = "127.0.0.1";

    public static OperationResult taskUpdate(DynamicObject plan) {
        OperationResult result = new OperationResult();
        DynamicObjectCollection rows = plan.getDynamicObjectCollection("entryentity");
        if (rows == null || rows.size() < 1) {
            return result;
        }
        for (DynamicObject row : rows) {
            DynamicObject model = row.getDynamicObject("bizmodel");
            String modelNum = model.getString(PROP_NUMBER).toUpperCase();
            String modelName = model.getString("name");
            result = TaskUtils.createJob(model.getString("id"), modelName, modelNum);
            if (!result.isSuccess()) {
                return result;
            }
            List pkId = result.getSuccessPkIds();
            String jobId = pkId.get(0).toString();
            if ((result = TaskUtils.createPlan(jobId, plan, modelNum, modelName)).isSuccess()) continue;
            return result;
        }
        return result;
    }

    private static OperationResult createPlan(String jobId, DynamicObject plan, String modelNum, String modelName) {
        String planNum = "PLAN-PHM-" + modelNum;
        String planId = TaskUtils.getIdByNum(ENTITY_SCH_SCHEDULE, planNum);
        DynamicObject schedule = TaskUtils.getExistedObject(ENTITY_SCH_SCHEDULE, planId);
        schedule.set("name", (Object)(ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212-\u8fd0\u8425\u5927\u8111-", (String)"TaskUtils_0", (String)"mmc-phm-common", (Object[])new Object[0]) + modelName));
        schedule.set(PROP_NUMBER, (Object)planNum);
        schedule.set("job", (Object)jobId);
        schedule.set("job_id", (Object)jobId);
        schedule.set("starttime", (Object)TaskUtils.getStartTime(plan));
        schedule.set("endtime", (Object)TaskUtils.getEndTime(plan));
        schedule.set("status", (Object)"1");
        schedule.set("repeatmode", plan.get("repeatmode"));
        schedule.set("cyclenum", plan.get("cyclenum"));
        schedule.set("plan", plan.get("plan"));
        schedule.set("txtdesc", plan.get("txtdesc"));
        schedule.set("combdorw", plan.get("combdorw"));
        schedule.set("txthost", (Object)TaskUtils.getHostIpAddress());
        for (String monthProp : ScheduleConsts.CKMONTH) {
            schedule.set(monthProp, plan.get(monthProp));
        }
        for (String dateProp : ScheduleConsts.CKDATE) {
            schedule.set(dateProp, plan.get(dateProp));
        }
        for (String weekProp : ScheduleConsts.CKWEEK) {
            schedule.set(weekProp, plan.get(weekProp));
        }
        schedule.set("comno", plan.get("comno"));
        schedule.set("comweek", plan.get("comweek"));
        schedule.set("ckbyweek", plan.get("ckbyweek"));
        return SaveServiceHelper.saveOperate((String)ENTITY_SCH_SCHEDULE, (DynamicObject[])new DynamicObject[]{schedule}, (OperateOption)OperateOption.create());
    }

    public static OperationResult createJob(String modId, String modName, String modNum) {
        String jobNum = "JOB-PHM-" + modNum;
        String jobId = TaskUtils.getIdByNum(ENTITY_SCH_JOB, jobNum);
        DynamicObject job = TaskUtils.getExistedObject(ENTITY_SCH_JOB, jobId);
        job.set(PROP_NUMBER, (Object)jobNum);
        job.set("jobtype", (Object)JobType.BIZ);
        String jobName = ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a-\u8fd0\u8425\u5927\u8111-", (String)"TaskUtils_1", (String)"mmc-phm-common", (Object[])new Object[0]) + modName;
        job.set("name", (Object)jobName);
        job.set("taskclassname", (Object)TaskUtils.getTaskId());
        job.set("classname", (Object)BASE_TASK);
        job.set("runbyuser", (Object)RequestContext.get().getUserId());
        job.set("status", (Object)1);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("modelId", modId);
        job.set("params", (Object)SerializationUtils.toJsonString(params));
        DynamicObjectCollection entries = job.getDynamicObjectCollection("entryentity");
        entries.clear();
        DynamicObject dataPumpParam = entries.addNew();
        dataPumpParam.set("paramname", (Object)"modelId");
        dataPumpParam.set("paramvalue", (Object)modId);
        return SaveServiceHelper.saveOperate((String)ENTITY_SCH_JOB, (DynamicObject[])new DynamicObject[]{job}, (OperateOption)OperateOption.create());
    }

    public static String getIdByNum(String entityName, String num) {
        QFilter f1 = new QFilter(PROP_NUMBER, "=", (Object)num);
        DynamicObject job = QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])new QFilter[]{f1});
        if (job != null) {
            return job.getString("id");
        }
        return "";
    }

    public static String getIdByLikeNum(String entityName, String num) {
        QFilter f1 = new QFilter(PROP_NUMBER, "ftlike", (Object)num);
        DynamicObject job = QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])new QFilter[]{f1});
        if (job != null) {
            return job.getString("id");
        }
        return "";
    }

    public static List<String> getExistByNum(String entityName, List<String> nums) {
        QFilter f1 = new QFilter(PROP_NUMBER, "in", nums);
        DynamicObjectCollection job = QueryServiceHelper.query((String)entityName, (String)"id,number", (QFilter[])new QFilter[]{f1});
        ArrayList<String> list = new ArrayList<String>(8);
        if (job != null && job.size() > 0) {
            for (DynamicObject dynamicObject : job) {
                list.add(dynamicObject.getString(PROP_NUMBER));
            }
        }
        return list;
    }

    public static List<String> getExistLikeByNum(String entityName, List<String> nums) {
        ArrayList<QFilter> qfNums = new ArrayList<QFilter>(nums.size());
        for (String qf : nums) {
            QFilter f1 = new QFilter(PROP_NUMBER, "ftlike", (Object)qf);
            qfNums.add(f1);
        }
        int i = 0;
        QFilter queryQf = null;
        for (QFilter qFilter : qfNums) {
            if (i == 0) {
                queryQf = qFilter;
            } else if (queryQf != null) {
                queryQf = queryQf.or(qFilter);
            }
            ++i;
        }
        DynamicObjectCollection job = QueryServiceHelper.query((String)entityName, (String)"id,number", (QFilter[])new QFilter[]{queryQf});
        ArrayList<String> list = new ArrayList<String>(8);
        if (job != null && job.size() > 0) {
            for (DynamicObject dynamicObject : job) {
                list.add(dynamicObject.getString(PROP_NUMBER));
            }
        }
        return list;
    }

    public static DynamicObject getExistedObject(String entityName, String id) {
        if (QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)})) {
            return BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName);
        }
        return BusinessDataServiceHelper.newDynamicObject((String)entityName);
    }

    public static boolean isExistedObject(String entityName, String id) {
        return QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
    }

    private static Date getEndTime(DynamicObject plan) {
        Date end = plan.getDate("expired_time");
        if (end == null) {
            end = new Timestamp(System.currentTimeMillis() + 315360000000L);
        }
        return end;
    }

    private static Date getStartTime(DynamicObject plan) {
        Date start = plan.getDate("validated_time");
        if (start == null) {
            start = new Date(System.currentTimeMillis() - 86400000L);
        }
        return start;
    }

    public static String getTaskId() {
        DynamicObject taskname = BusinessDataServiceHelper.loadSingle((String)"sch_taskdefine", (String)PROP_NUMBER, (QFilter[])new QFilter[]{new QFilter("classname", "=", (Object)BASE_TASK)});
        if (taskname == null) {
            return null;
        }
        return String.valueOf(taskname.getPkValue());
    }

    public static String getHostIpAddress() {
        Enumeration<NetworkInterface> allNetInterfaces = null;
        try {
            allNetInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException var6) {
            throw new KDBizException((Throwable)var6, new ErrorCode("", ResManager.loadKDString((String)"\u8fde\u63a5\u8d85\u65f6\uff1a%s", (String)"TaskUtils_2", (String)"mmc-phm-common", (Object[])new Object[0])), new Object[]{LOCALIP});
        }
        InetAddress ip = null;
        boolean hasGet = false;
        String ipStr = null;
        while (allNetInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = allNetInterfaces.nextElement();
            Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                ip = addresses.nextElement();
                if (!(ip instanceof Inet4Address) || LOCALIP.equals(ipStr = NetAddressUtils.getLocalIpAddress())) continue;
                hasGet = true;
                break;
            }
            if (!hasGet) continue;
            break;
        }
        return ipStr;
    }
}

